/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.policy.action;

import com.hs.atic.bis.util.BisUtil;
import com.hs.atic.bis.util.ZoneBisUtil;
import com.hs.atic.sdk.util.StringUtils;
import com.hs.atic.util.AticUtil;
import com.hs.atic.zone.dao.ZoneDao;
import com.hs.atic.zone.model.ZoneInfo;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.comm.BatchOperation;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.lego.ui.plat.common.webapp.action.BaseAction;
import com.hs.vsm.secservice.ddos.policy.ref.ZoneReferUtil;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneBlackWhiteForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZonePolicyApplyForm;
import com.hs.vsm.secservice.sdk.module.ddos.service.IBlackWhiteListService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;

public class ZoneBlackWhiteListAction
extends BaseAction {
    private static final long serialVersionUID = 8985210199496182780L;
    private String zoneId;
    private String zoneBlackWhiteListIp;
    private List<ZoneBlackWhiteForm> zoneBlackWhitelistIpFormsList;
    private ZoneBlackWhiteForm addZoneBlackListForm;
    private ZoneBlackWhiteForm addZoneWhiteListForm;
    private Long[] pkids;
    private String[] ipAddressAndMasks;
    private String ipAddress;
    private IBlackWhiteListService blackWhiteListService;
    private String sortType;
    private String sortField;
    private final Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private ZoneDao zoneDao;

    public String showZoneBlackList() {
        this.logger.info((Object)("showZoneBlackList zoneBlackWhiteListIp:" + this.zoneBlackWhiteListIp));
        this.zoneBlackWhitelistIpFormsList = new ArrayList<ZoneBlackWhiteForm>();
        if (null == this.zoneId) {
            throw new LegoCheckedException(630111L);
        }
        BisUtil.checkUserSecurity(this.queryMoidByZoneId());
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("zoneId", this.zoneId);
        queryMap.put("blackWhiteType", String.valueOf(1));
        queryMap.put("deleteFlag", String.valueOf(0));
        if (!AticUtil.isNull((String)this.zoneBlackWhiteListIp)) {
            queryMap.put("ipAddress", this.zoneBlackWhiteListIp.trim());
        }
        if (this.checkParams(this.sortField, this.sortType) && this.sortField.equalsIgnoreCase("zoneBlackWhiteListIp")) {
            queryMap.put("sortName", "ipAddress");
            queryMap.put("sortType", this.sortType);
        }
        Paging page = this.blackWhiteListService.queryByPage(queryMap, this.start, this.pageSize);
        this.zoneBlackWhitelistIpFormsList = page.getData();
        this.getSession().setAttribute("pageSize", (Object)this.getPageSize());
        this.getSession().setAttribute("start", (Object)this.getStart());
        this.setTotal(page.getCount());
        return "success";
    }

    private boolean checkParams(String name, String type) {
        String regular;
        return !AticUtil.isNull((String)type) && !AticUtil.isNull((String)name) && Pattern.matches(regular = "^[A-Za-z0-9|_]+$", name) && (type.trim().equalsIgnoreCase("desc") || type.trim().equalsIgnoreCase("asc"));
    }

    public String showZoneWhiteList() {
        this.zoneBlackWhitelistIpFormsList = new ArrayList<ZoneBlackWhiteForm>();
        if (null == this.zoneId) {
            throw new LegoCheckedException(630111L);
        }
        BisUtil.checkUserSecurity(this.queryMoidByZoneId());
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("zoneId", this.zoneId);
        queryMap.put("blackWhiteType", String.valueOf(2));
        queryMap.put("deleteFlag", String.valueOf(0));
        if (!AticUtil.isNull((String)this.zoneBlackWhiteListIp)) {
            queryMap.put("ipAddress", this.zoneBlackWhiteListIp.trim());
        }
        if (this.checkParams(this.sortField, this.sortType) && this.sortField.equalsIgnoreCase("zoneBlackWhiteListIp")) {
            queryMap.put("sortName", "ipAddress");
            queryMap.put("sortType", this.sortType);
        }
        Paging page = this.blackWhiteListService.queryByPage(queryMap, this.start, this.pageSize);
        this.zoneBlackWhitelistIpFormsList = page.getData();
        this.getSession().setAttribute("pageSize", (Object)this.getPageSize());
        this.getSession().setAttribute("start", (Object)this.getStart());
        this.setTotal(page.getCount());
        return "success";
    }

    public String addZoneBlackList() {
        if (null == this.zoneId) {
            throw new LegoCheckedException(630111L);
        }
        BisUtil.checkUserSecurity(this.queryMoidByZoneId());
        return "success";
    }

    private List<Long> queryMoidByZoneId() {
        ArrayList<Long> moIDList = new ArrayList<Long>();
        if (this.zoneId.contains(",")) {
            String[] deviceIdTemp = this.zoneId.split(",");
            this.zoneId = deviceIdTemp[0];
            moIDList.add(ZoneBisUtil.getMoidByZoneid(Long.parseLong(this.zoneId.trim())));
        } else if (StringUtils.isNotBlank(this.zoneId)) {
            moIDList.add(ZoneBisUtil.getMoidByZoneid(Long.parseLong(this.zoneId.trim())));
        }
        return moIDList;
    }

    public String addZoneWhiteList() {
        if (null == this.zoneId) {
            throw new LegoCheckedException(630111L);
        }
        BisUtil.checkUserSecurity(this.queryMoidByZoneId());
        this.logger.info((Object)"addZoneWhiteList step in add zone whitelist");
        return "success";
    }

    public void saveZoneBlackList() {
        if (null == this.zoneId) {
            throw new LegoCheckedException(630111L);
        }
        BisUtil.checkUserSecurity(this.queryMoidByZoneId());
        ZonePolicyApplyForm zonePolicyApplyForm = ZoneReferUtil.getZonePolicyService().queryByZoneId(Long.parseLong(this.zoneId), 1);
        if (null == zonePolicyApplyForm) {
            throw new LegoCheckedException(630111L);
        }
        String zoneName = "";
        String[] detailPara = new String[]{""};
        try {
            zoneName = zonePolicyApplyForm.getZoneName();
            if (this.addZoneBlackListForm == null) {
                this.logger.error((Object)"save zone blacklist addZoneBlackListForm is null");
                this.responseResult("form is null");
                return;
            }
            String blackListIpAddress = this.addZoneBlackListForm.getIpAddress();
            Integer mask = this.addZoneBlackListForm.getMask();
            if (AticUtil.isNull((String)blackListIpAddress)) {
                this.logger.error((Object)"save zone blacklist blackListIpAddress is null");
                this.responseResult("blacklist ip address is null");
                return;
            }
            if (!this.valiateIp(blackListIpAddress)) {
                detailPara = new String[]{blackListIpAddress};
                this.getOperateLog().normal("com.hs.vsm.secservice.ddos.policy.create.blacklist", "com.hs.vsm.secservice.ddos.policy.module", zoneName, false, "com.hs.vsm.secservice.ddos.policy.blacklist.ip.incorrect.oplog.add", detailPara);
                this.responseResult("blacklist ip format is incorrect");
                return;
            }
            if (!this.valiateMask(blackListIpAddress, mask)) {
                detailPara = new String[]{blackListIpAddress + "/" + mask};
                this.getOperateLog().normal("com.hs.vsm.secservice.ddos.policy.create.blacklist", "com.hs.vsm.secservice.ddos.policy.module", zoneName, false, "com.hs.vsm.secservice.ddos.policy.blacklist.ip.mask.incorrect.oplog.add", detailPara);
                this.responseResult("blacklist mask format is incorrect");
                return;
            }
            this.addZoneBlackListForm.setBlackWhiteType(1);
            this.addZoneBlackListForm.setDeleteFlag(0);
            this.addZoneBlackListForm.setZoneId(Long.parseLong(this.zoneId));
            int blackWhilteType = this.blackWhiteListService.saveZoneBlackWhiteList(this.addZoneBlackListForm);
            if (blackWhilteType == 1) {
                detailPara = new String[]{blackListIpAddress + "/" + mask};
                this.getOperateLog().normal("com.hs.vsm.secservice.ddos.policy.create.blacklist", "com.hs.vsm.secservice.ddos.policy.module", zoneName, false, "com.hs.vsm.secservice.ddos.policy.blacklist.ip.address.is.exist", detailPara);
                this.responseResult("zone black list is exist");
                return;
            }
            if (blackWhilteType == 2) {
                detailPara = new String[]{blackListIpAddress + "/" + mask};
                this.getOperateLog().normal("com.hs.vsm.secservice.ddos.policy.create.blacklist", "com.hs.vsm.secservice.ddos.policy.module", zoneName, false, "com.hs.vsm.secservice.ddos.policy.whitelist.ip.address.is.exist", detailPara);
                this.responseResult("zone white list is exist");
                return;
            }
            if (blackWhilteType == 1000) {
                this.responseResult("max number of black lists");
                return;
            }
            detailPara = new String[]{blackListIpAddress + "/" + mask};
        }
        catch (Exception e) {
            this.getOperateLog().normal("com.hs.vsm.secservice.ddos.policy.create.blacklist", "com.hs.vsm.secservice.ddos.policy.module", zoneName, false, "com.hs.vsm.secservice.ddos.policy.blacklist.ip.oplog.add.failed", null);
            this.logger.error((Object)e.getMessage());
        }
        this.getOperateLog().normal("com.hs.vsm.secservice.ddos.policy.create.blacklist", "com.hs.vsm.secservice.ddos.policy.module", zoneName, true, "com.hs.vsm.secservice.ddos.policy.blacklist.oplog.add.success", detailPara);
        this.responseResult("success");
    }

    public void saveZoneWhiteList() {
        if (null == this.zoneId) {
            throw new LegoCheckedException(630111L);
        }
        BisUtil.checkUserSecurity(this.queryMoidByZoneId());
        ZonePolicyApplyForm zonePolicyApplyForm = ZoneReferUtil.getZonePolicyService().queryByZoneId(Long.parseLong(this.zoneId), 1);
        if (null == zonePolicyApplyForm) {
            throw new LegoCheckedException(630111L);
        }
        String zoneName = "";
        String[] detailPara = new String[]{""};
        try {
            zoneName = zonePolicyApplyForm.getZoneName();
            if (this.addZoneWhiteListForm == null) {
                this.logger.error((Object)"save zone whitelist addZoneWhiteListForm is null");
                this.responseResult("form is null");
                return;
            }
            String whiteListIpAddress = this.addZoneWhiteListForm.getIpAddress();
            if (AticUtil.isNull((String)whiteListIpAddress)) {
                this.logger.error((Object)"save zone whitelist whiteListIpAddress is null");
                this.responseResult("whitelist ip address is null");
                return;
            }
            if (!this.valiateIp(whiteListIpAddress)) {
                detailPara = new String[]{whiteListIpAddress};
                this.getOperateLog().normal("com.hs.vsm.secservice.ddos.policy.create.whitelist", "com.hs.vsm.secservice.ddos.policy.module", zoneName, false, "com.hs.vsm.secservice.ddos.policy.whitelist.ip.incorrect.oplog.add", detailPara);
                this.responseResult("whitelist ip format is incorrect");
                return;
            }
            Integer mask = this.addZoneWhiteListForm.getMask();
            if (!this.valiateMask(whiteListIpAddress, mask)) {
                detailPara = new String[]{whiteListIpAddress + "/" + mask};
                this.getOperateLog().normal("com.hs.vsm.secservice.ddos.policy.create.whitelist", "com.hs.vsm.secservice.ddos.policy.module", zoneName, false, "com.hs.vsm.secservice.ddos.policy.whitelist.mask.incorrect.oplog.add", detailPara);
                this.responseResult("whitelist mask format is incorrect");
                return;
            }
            this.addZoneWhiteListForm.setBlackWhiteType(2);
            this.addZoneWhiteListForm.setDeleteFlag(0);
            this.addZoneWhiteListForm.setZoneId(Long.parseLong(this.zoneId));
            int blackWhilteType = this.blackWhiteListService.saveZoneBlackWhiteList(this.addZoneWhiteListForm);
            if (blackWhilteType == 1) {
                detailPara = new String[]{whiteListIpAddress + "/" + mask};
                this.getOperateLog().normal("com.hs.vsm.secservice.ddos.policy.create.whitelist", "com.hs.vsm.secservice.ddos.policy.module", zoneName, false, "com.hs.vsm.secservice.ddos.policy.blacklist.ip.address.is.exist", detailPara);
                this.responseResult("zone black list is exist");
                return;
            }
            if (blackWhilteType == 2) {
                detailPara = new String[]{whiteListIpAddress + "/" + mask};
                this.getOperateLog().normal("com.hs.vsm.secservice.ddos.policy.create.whitelist", "com.hs.vsm.secservice.ddos.policy.module", zoneName, false, "com.hs.vsm.secservice.ddos.policy.whitelist.ip.address.is.exist", detailPara);
                this.responseResult("zone white list is exist");
                return;
            }
            if (blackWhilteType == 1000) {
                this.responseResult("max number of white lists");
                return;
            }
            detailPara = new String[]{whiteListIpAddress + "/" + mask};
        }
        catch (Exception e) {
            this.getOperateLog().normal("com.hs.vsm.secservice.ddos.policy.create.whitelist", "com.hs.vsm.secservice.ddos.policy.module", zoneName, false, "com.hs.vsm.secservice.ddos.policy.whitelist.ip.oplog.add.failed", null);
            this.logger.error((Object)e.getMessage());
        }
        this.getOperateLog().normal("com.hs.vsm.secservice.ddos.policy.create.whitelist", "com.hs.vsm.secservice.ddos.policy.module", zoneName, true, "com.hs.vsm.secservice.ddos.policy.whitelist.ip.oplog.add.success", detailPara);
        this.responseResult("success");
    }

    private boolean valiateIp(String ip) {
        return IPUtil.isIpv4((String)ip) || IPUtil.isIpv6((String)ip);
    }

    private boolean valiateMask(String ip, Integer ipMask) {
        return IPUtil.isIpv4((String)ip) ? ipMask >= 8 && ipMask <= 32 : IPUtil.isIpv6((String)ip) && ipMask >= 8 && ipMask <= 128;
    }

    public void deleteZoneBlackList() {
        if (null == this.zoneId) {
            throw new LegoCheckedException(630111L);
        }
        String zoneName = "";
        try {
            BisUtil.checkUserSecurity(this.queryMoidByZoneId());
            ZoneInfo zoneInfo = this.zoneDao.getByZoneId(Long.parseLong(this.zoneId));
            if (zoneInfo != null) {
                zoneName = zoneInfo.getZoneName();
            }
            if (this.getPkids().length == 0) {
                this.logger.error((Object)"deleted zone blacklist pkids is null");
                this.responseResult("blacklist pkids is null");
                return;
            }
            if (this.getIpAddressAndMasks().length == 0) {
                this.logger.error((Object)"deleted zone blacklist ip address and mask is null");
                this.responseResult("ipAddressAndMasks is null");
                return;
            }
            this.getOperateLog().info("com.hs.vsm.secservice.ddos.policy.delete.blacklist", "com.hs.vsm.secservice.ddos.policy.module");
            ArrayList<BatchOperation> batchOpList = new ArrayList<BatchOperation>();
            for (int i = 0; i < this.pkids.length; ++i) {
                BatchOperation bo = new BatchOperation();
                bo.setTargetId(this.pkids[i].longValue());
                bo.setTargetName(zoneName);
                batchOpList.add(bo);
            }
            this.batchOperationResult = this.blackWhiteListService.batchDelZoneBlackWhiteList(batchOpList);
            StringBuffer names = new StringBuffer();
            for (BatchOperation bo : this.batchOperationResult.getResult()) {
                names.append(bo.getTargetName()).append(',');
            }
            this.logger.info((Object)("delete ipBlackList : " + this.getcleanedMessage(names.toString())));
        }
        catch (Exception e) {
            this.getOperateLog().normal("com.hs.vsm.secservice.ddos.policy.delete.blacklist", "com.hs.vsm.secservice.ddos.policy.module", zoneName, true, "com.hs.vsm.secservice.ddos.policy.delete.blacklist.failed", null);
            this.logger.error((Object)e.getMessage());
        }
        this.bathResult(this.batchOperationResult);
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    public void deleteZoneWhiteList() {
        if (null == this.zoneId) {
            throw new LegoCheckedException(630111L);
        }
        String zoneName = "";
        try {
            BisUtil.checkUserSecurity(this.queryMoidByZoneId());
            ZoneInfo zoneInfo = this.zoneDao.getByZoneId(Long.parseLong(this.zoneId));
            if (zoneInfo != null) {
                zoneName = zoneInfo.getZoneName();
            }
            if (this.getPkids().length == 0) {
                this.logger.error((Object)"delete zone whiteList ip address and mask is null");
                this.responseResult("whitelist pkids is null");
                return;
            }
            if (this.getIpAddressAndMasks().length == 0) {
                this.logger.error((Object)"delete zone whiteList pkids is null");
                this.responseResult("whitelist ipaddress and mask is null");
                return;
            }
            this.getOperateLog().normal("com.hs.vsm.secservice.ddos.policy.delete.whitelist", "com.hs.vsm.secservice.ddos.policy.module");
            ArrayList<BatchOperation> batchOpList = new ArrayList<BatchOperation>();
            for (int i = 0; i < this.pkids.length; ++i) {
                BatchOperation bo = new BatchOperation();
                bo.setTargetId(this.pkids[i].longValue());
                bo.setTargetName(zoneName);
                batchOpList.add(bo);
            }
            this.batchOperationResult = this.blackWhiteListService.batchDelZoneBlackWhiteList(batchOpList);
            StringBuffer names = new StringBuffer();
            for (BatchOperation bo : this.batchOperationResult.getResult()) {
                names.append(bo.getTargetName()).append(',');
            }
            this.logger.info((Object)("delete ip blacklist : " + this.getcleanedMessage(names.toString())));
        }
        catch (Exception e) {
            this.getOperateLog().normal("com.hs.vsm.secservice.ddos.policy.delete.whitelist", "com.hs.vsm.secservice.ddos.policy.module", zoneName, false, "com.hs.vsm.secservice.ddos.policy.delete.whitelist.failed", null);
            this.logger.error((Object)e.getMessage());
        }
        this.bathResult(this.batchOperationResult);
    }

    public void deleteAllZoneBlackList() {
        if (null == this.zoneId) {
            throw new LegoCheckedException(630111L);
        }
        BisUtil.checkUserSecurity(this.queryMoidByZoneId());
        String zoneName = "";
        ZoneInfo zoneInfo = this.zoneDao.getByZoneId(Long.parseLong(this.zoneId));
        if (zoneInfo != null) {
            zoneName = zoneInfo.getZoneName();
        }
        try {
            ZoneBlackWhiteForm zoneBlackWhiteForm = new ZoneBlackWhiteForm();
            zoneBlackWhiteForm.setZoneId(Long.parseLong(this.zoneId.trim()));
            zoneBlackWhiteForm.setBlackWhiteType(1);
            this.blackWhiteListService.batchDelAllZoneBlackWhiteList(zoneBlackWhiteForm);
            this.getOperateLog().normal("com.hs.vsm.secservice.ddos.policy.delete.allblacklist", "com.hs.vsm.secservice.ddos.policy.module", zoneName, true, "com.hs.vsm.secservice.ddos.policy.delete.allblacklist.success", null);
        }
        catch (Exception e) {
            this.getOperateLog().normal("com.hs.vsm.secservice.ddos.policy.delete.allblacklist", "com.hs.vsm.secservice.ddos.policy.module", null, false, "com.hs.vsm.secservice.ddos.policy.delete.allblacklist.failed", null);
            this.logger.error((Object)e.getMessage());
        }
        this.responseResult("success");
    }

    public void deleteAllZoneWhiteList() {
        if (null == this.zoneId) {
            throw new LegoCheckedException(630111L);
        }
        BisUtil.checkUserSecurity(this.queryMoidByZoneId());
        String zoneName = "";
        try {
            ZoneInfo zoneInfo = this.zoneDao.getByZoneId(Long.parseLong(this.zoneId));
            if (zoneInfo != null) {
                zoneName = zoneInfo.getZoneName();
            }
            ZoneBlackWhiteForm zoneBlackWhiteForm = new ZoneBlackWhiteForm();
            zoneBlackWhiteForm.setZoneId(Long.parseLong(this.zoneId.trim()));
            zoneBlackWhiteForm.setBlackWhiteType(2);
            this.blackWhiteListService.batchDelAllZoneBlackWhiteList(zoneBlackWhiteForm);
            this.getOperateLog().normal("com.hs.vsm.secservice.ddos.policy.delete.allwhitelist", "com.hs.vsm.secservice.ddos.policy.module", zoneName, true, "com.hs.vsm.secservice.ddos.policy.delete.allwhitelist.failed", null);
        }
        catch (Exception e) {
            this.getOperateLog().normal("com.hs.vsm.secservice.ddos.policy.delete.allwhitelist", "com.hs.vsm.secservice.ddos.policy.module", zoneName, false, "com.hs.vsm.secservice.ddos.policy.delete.allwhitelist.success", null);
            this.logger.error((Object)e.getMessage());
        }
        this.responseResult("success");
    }

    public boolean validateZoneId() {
        if (AticUtil.isNull((String)this.zoneId)) {
            return false;
        }
        long parseZoneId = 0L;
        try {
            if (this.zoneId.contains(",")) {
                String[] deviceIdTemp = this.zoneId.split(",");
                parseZoneId = Long.parseLong(deviceIdTemp[0]);
            } else if (StringUtils.isNotBlank(this.zoneId)) {
                parseZoneId = Long.parseLong(this.zoneId);
            }
        }
        catch (NumberFormatException e) {
            return false;
        }
        return parseZoneId >= 0L;
    }

    public boolean validateIp(String ipStr) {
        return AticUtil.isNullForVpn((String)ipStr) || AticUtil.validateIpv4((String)ipStr) || IPUtil.isIpv6((String)ipStr);
    }

    public boolean validateIds() {
        if (null == this.pkids) {
            return false;
        }
        for (Long testId : this.pkids) {
            if (null != testId && testId >= 0L) continue;
            return false;
        }
        return true;
    }

    public boolean validateBlackListIps() {
        if (null == this.ipAddressAndMasks) {
            return false;
        }
        for (String testIp : this.ipAddressAndMasks) {
            if (StringUtils.isBlank(testIp)) {
                return false;
            }
            String[] ipMask = testIp.split("/");
            if (IPUtil.isIpv4((String)ipMask[0]) || IPUtil.isIpv6((String)ipMask[0])) continue;
            return false;
        }
        return true;
    }

    public String getZoneId() {
        return this.zoneId;
    }

    public void setZoneId(String zoneId) {
        this.zoneId = zoneId;
    }

    public String getZoneBlackWhiteListIp() {
        return this.zoneBlackWhiteListIp;
    }

    public void setZoneBlackWhiteListIp(String zoneBlackWhiteListIp) {
        this.zoneBlackWhiteListIp = zoneBlackWhiteListIp;
    }

    public List<ZoneBlackWhiteForm> getZoneBlackWhitelistIpFormsList() {
        return this.zoneBlackWhitelistIpFormsList;
    }

    public void setZoneBlackWhitelistIpFormsList(List<ZoneBlackWhiteForm> zoneBlackWhitelistIpFormsList) {
        this.zoneBlackWhitelistIpFormsList = zoneBlackWhitelistIpFormsList;
    }

    public ZoneBlackWhiteForm getAddZoneBlackListForm() {
        return this.addZoneBlackListForm;
    }

    public void setAddZoneBlackListForm(ZoneBlackWhiteForm addZoneBlackListForm) {
        this.addZoneBlackListForm = addZoneBlackListForm;
    }

    public ZoneBlackWhiteForm getAddZoneWhiteListForm() {
        return this.addZoneWhiteListForm;
    }

    public void setAddZoneWhiteListForm(ZoneBlackWhiteForm addZoneWhiteListForm) {
        this.addZoneWhiteListForm = addZoneWhiteListForm;
    }

    public Long[] getPkids() {
        if (null == this.pkids) {
            return new Long[0];
        }
        return (Long[])this.pkids.clone();
    }

    public void setPkids(Long[] pkids) {
        this.pkids = null == pkids ? null : (Long[])pkids.clone();
    }

    public String[] getIpAddressAndMasks() {
        if (null == this.ipAddressAndMasks) {
            return new String[0];
        }
        return (String[])this.ipAddressAndMasks.clone();
    }

    public void setIpAddressAndMasks(String[] ipAddressAndMasks) {
        this.ipAddressAndMasks = null == ipAddressAndMasks ? null : (String[])ipAddressAndMasks.clone();
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public IBlackWhiteListService getBlackWhiteListService() {
        return this.blackWhiteListService;
    }

    public void setBlackWhiteListService(IBlackWhiteListService blackWhiteListService) {
        this.blackWhiteListService = blackWhiteListService;
    }

    public String getSortType() {
        return this.sortType;
    }

    public void setSortType(String sortType) {
        this.sortType = sortType;
    }

    public String getSortField() {
        return this.sortField;
    }

    public void setSortField(String sortField) {
        this.sortField = sortField;
    }

    public ZoneDao getZoneDao() {
        return this.zoneDao;
    }

    public void setZoneDao(ZoneDao zoneDao) {
        this.zoneDao = zoneDao;
    }
}

