/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.policy.action;

import com.hs.atic.bis.util.BisUtil;
import com.hs.atic.bis.util.ZoneBisUtil;
import com.hs.atic.sdk.zone.form.IpDomainForm;
import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.atic.sdk.zone.form.ZoneIpForm;
import com.hs.atic.sdk.zone.form.ZoneListIpForm;
import com.hs.atic.sdk.zone.service.IImportAndExportService;
import com.hs.atic.sdk.zone.service.IIpDomainService;
import com.hs.atic.sdk.zone.service.IZoneImportAndExportXmlService;
import com.hs.atic.sdk.zone.service.IZoneService;
import com.hs.atic.util.AticUtil;
import com.hs.atic.util.CrashThreadHandler;
import com.hs.lego.cbb.user.sdk.model.User;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.comm.BatchOperation;
import com.hs.lego.core.sdk.comm.BatchOperationResult;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.lego.ui.plat.common.constants.LangPair;
import com.hs.lego.ui.plat.common.webapp.action.BaseAction;
import com.hs.vsm.secservice.ddos.policy.action.ExportZonePolicyThread;
import com.hs.vsm.secservice.ddos.policy.action.ZoneManageAction;
import com.hs.vsm.secservice.ddos.policy.beans.DeviceAndGroup;
import com.hs.vsm.secservice.ddos.policy.ref.ZoneReferUtil;
import com.hs.vsm.secservice.ddos.policy.util.CSVReader;
import com.hs.vsm.secservice.ddos.policy.util.ZoneConstants;
import com.hs.vsm.secservice.ddos.policy.util.ZoneUtil;
import com.hs.vsm.secservice.sdk.module.ddos.form.ExportZoneConditionForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneDeviceForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZonePolicyIOForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneServiceForm;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneDeviceService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneServiceService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.sdk.bis.form.DefendGroupForm;
import com.huawei.atic.sdk.bis.service.IDefendGroupService;
import com.huawei.atic.secne.common.LocaleUtil;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import jxl.Cell;
import jxl.Sheet;
import jxl.Workbook;
import jxl.read.biff.BiffException;
import org.apache.commons.io.output.FileWriterWithEncoding;
import org.apache.struts2.ServletActionContext;

public class ZoneImportAndExportAction
extends BaseAction {
    public static final int NUMBER_ZONE_NAME = 0;
    public static final int NUMBER_ZONE_DESC = 1;
    public static final int NUMBER_ZONE_TYPE = 2;
    public static final int NUMBER_ZONE_CONTACT = 3;
    public static final int NUMBER_ZONE_TELEPHONE = 4;
    public static final int NUMBER_ZONE_MOBILE = 5;
    public static final int NUMBER_ZONE_POST = 6;
    public static final int NUMBER_ZONE_EMAIL = 7;
    public static final int NUMBER_ZONE_ADDRESS = 8;
    public static final int NUMBER_ZONE_REAMRK = 9;
    public static final int NUMBER_ZONE_REGULAR_LISTIP = 10;
    public static final int NUMBER_ZONE_EXCULDE_LISTIP = 11;
    public static final int NUMBER_ELEVEN = 11;
    public static final String TAG = "idStr";
    public static final String EXPORT_BY_ZONE = "atic.bis.policy.exportZone";
    public static final String EXPORT_BY_ZONE_ALL = "atic.bis.policy.exportZone.all";
    static Comparator<DeviceAndGroup> comparator = new Comparator<DeviceAndGroup>(){

        @Override
        public int compare(DeviceAndGroup dev1, DeviceAndGroup dev2) {
            return dev1.getDefGroupName().compareTo(dev2.getDefGroupName());
        }
    };
    private static final long serialVersionUID = 2212426292223304616L;
    private static Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private Integer startNum;
    private Integer endNum;
    private boolean superSize;
    private String importFilePath;
    private Long progressId;
    private IZoneService zoneService;
    private IZoneServiceService zoneServiceService;
    private IZoneImportAndExportXmlService zoneImportAndExportXmlService;
    private IImportAndExportService importAndExportService;
    private List<ZoneInfoForm> zoneInfoFormList = new ArrayList<ZoneInfoForm>();
    private List<BatchOperation> frontOperationList = new ArrayList<BatchOperation>();
    private List<LangPair> selectExportContentList;
    private List<LangPair> selectExportContentByDeviceList;
    private String selectExportContents;
    private String dimension;
    private String deviceIp;
    private Long deviceId;
    private String zoneNames;
    private String exportTag;
    private int zoneCount;
    private Long progressBarId;
    private String idStr;
    private String exportFileName;
    private String exportContentStr;
    private String deviceIdStr;
    private List<DeviceAndGroup> devicesAndGroups;

    public void importZone() {
        try {
            Workbook workbook = this.getWorkbook();
            this.validateWorkbook(workbook);
            this.clearCahe();
            this.getImportZoneFromWorkbook(workbook);
            this.initZoneService();
            BatchOperationResult backOperationResult = this.saveImportZoneAndGetResult();
            this.getOperateLog().info("atic.user.title.import", "lego.dic.module.AticZone");
            BatchOperationResult operationResult = this.cleanUpBatchOperationResult(backOperationResult);
            this.closeProgressBar();
            this.bathResult(operationResult);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("import zone error : " + e.getErrorCode()));
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)"import zone error : ", (Throwable)e);
            throw new LegoCheckedException(570698L, (Throwable)e);
        }
    }

    private void clearCahe() {
        this.zoneInfoFormList.clear();
        this.frontOperationList.clear();
    }

    private void closeProgressBar() {
        this.zoneService.removeProgressState(this.progressId);
    }

    private BatchOperationResult cleanUpBatchOperationResult(BatchOperationResult backOperationResult) {
        ArrayList<BatchOperation> batchOpList = new ArrayList<BatchOperation>();
        for (BatchOperation batchOperation : this.frontOperationList) {
            batchOpList.add(batchOperation);
        }
        for (BatchOperation batchOperation : backOperationResult.getResult()) {
            batchOpList.add(batchOperation);
        }
        BatchOperationResult batchOperationResult = new BatchOperationResult();
        batchOperationResult.setResult(batchOpList);
        batchOperationResult.setFailCount(this.frontOperationList.size() + backOperationResult.getFailCount());
        batchOperationResult.setTotalCount(this.frontOperationList.size() + backOperationResult.getTotalCount());
        batchOperationResult.setSucceedCount(backOperationResult.getSucceedCount());
        return batchOperationResult;
    }

    private void initZoneService() {
        this.zoneService = ZoneUtil.getZoneService();
    }

    private void initZoneImportAndExportService() {
        this.zoneImportAndExportXmlService = ZoneUtil.getZoneImportAndExportService();
    }

    private BatchOperationResult saveImportZoneAndGetResult() {
        Long userId = this.getUserId();
        BatchOperationResult backOperationResult = new BatchOperationResult();
        if (!this.zoneInfoFormList.isEmpty()) {
            logger.info((Object)"save zones in memory");
            backOperationResult = this.zoneService.batchAddZone(this.zoneInfoFormList, userId, this.progressId);
        }
        return backOperationResult;
    }

    private Long getUserId() {
        User currentUser = (User)this.getSession().getAttribute("currentUser");
        Long currentUserId = 0L;
        Boolean currentUserIsAdmin = Boolean.parseBoolean(currentUser.getIsAdmin());
        if (currentUserIsAdmin.equals(false)) {
            currentUserId = currentUser.getUserID();
        }
        return currentUserId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Workbook getWorkbook() throws BiffException, IOException {
        Workbook workbook;
        Workbook workbook2 = null;
        FileInputStream importFileInputStream = null;
        try {
            this.importFilePath = this.getSession().getServletContext().getRealPath("") + File.separator + "import" + File.separator + this.importFilePath;
            importFileInputStream = new FileInputStream(this.importFilePath);
            workbook = workbook2 = Workbook.getWorkbook((InputStream)importFileInputStream);
        }
        catch (Throwable throwable) {
            ZoneUtil.closeInputStream(importFileInputStream);
            throw throwable;
        }
        ZoneUtil.closeInputStream(importFileInputStream);
        return workbook;
    }

    private void validateWorkbook(Workbook workbook) {
        if (workbook == null) {
            throw new LegoCheckedException(570602L);
        }
        Sheet sheet = workbook.getSheet(0);
        if (sheet.getColumns() != 12) {
            throw new LegoCheckedException(570602L);
        }
        Cell[] cell = sheet.getRow(2);
        if (cell == null || cell.length != 12) {
            throw new LegoCheckedException(570602L);
        }
        if (!ZoneConstants.EXCEL_TABLENAME_NAME_ZH.equalsIgnoreCase(cell[0].getContents().trim()) && !ZoneConstants.EXCEL_TABLENAME_NAME_EN.equalsIgnoreCase(cell[0].getContents().trim())) {
            throw new LegoCheckedException(570602L);
        }
        if (!ZoneConstants.EXCEL_TABLENAME_DESC_ZH.equalsIgnoreCase(cell[1].getContents().trim()) && !ZoneConstants.EXCEL_TABLENAME_DESC_EN.equalsIgnoreCase(cell[1].getContents().trim())) {
            throw new LegoCheckedException(570602L);
        }
        if (!ZoneConstants.EXCEL_TABLENAME_TYPE_ZH.equalsIgnoreCase(cell[2].getContents().trim()) && !ZoneConstants.EXCEL_TABLENAME_TYPE_EN.equalsIgnoreCase(cell[2].getContents().trim())) {
            throw new LegoCheckedException(570602L);
        }
        if (!ZoneConstants.EXCEL_TABLENAME_CONTACT_ZH.equalsIgnoreCase(cell[3].getContents().trim()) && !ZoneConstants.EXCEL_TABLENAME_CONTACT_EN.equalsIgnoreCase(cell[3].getContents().trim())) {
            throw new LegoCheckedException(570602L);
        }
        if (!ZoneConstants.EXCEL_TABLENAME_TELEPHONE_EN.equalsIgnoreCase(cell[4].getContents().trim()) && !ZoneConstants.EXCEL_TABLENAME_TELEPHONE_ZH.equalsIgnoreCase(cell[4].getContents().trim())) {
            throw new LegoCheckedException(570602L);
        }
        if (!ZoneConstants.EXCEL_TABLENAME_PHONE_ZH.equalsIgnoreCase(cell[5].getContents().trim()) && !ZoneConstants.EXCEL_TABLENAME_PHONE_EN.equalsIgnoreCase(cell[5].getContents().trim())) {
            throw new LegoCheckedException(570602L);
        }
        if (!ZoneConstants.EXCEL_TABLENAME_ZIP_ZH.equalsIgnoreCase(cell[6].getContents().trim()) && !ZoneConstants.EXCEL_TABLENAME_ZIP_EN.equalsIgnoreCase(cell[6].getContents().trim())) {
            throw new LegoCheckedException(570602L);
        }
        if (!ZoneConstants.EXCEL_TABLENAME_EMAIL_ZH.equalsIgnoreCase(cell[7].getContents().trim()) && !ZoneConstants.EXCEL_TABLENAME_EMAIL_EN.equalsIgnoreCase(cell[7].getContents().trim())) {
            throw new LegoCheckedException(570602L);
        }
        if (!ZoneConstants.EXCEL_TABLENAME_ADDRESS_ZH.equalsIgnoreCase(cell[8].getContents().trim()) && !ZoneConstants.EXCEL_TABLENAME_ADDRESS_EN.equalsIgnoreCase(cell[8].getContents().trim())) {
            throw new LegoCheckedException(570602L);
        }
        if (!ZoneConstants.EXCEL_TABLENAME_REMARK_ZH.equalsIgnoreCase(cell[9].getContents().trim()) && !ZoneConstants.EXCEL_TABLENAME_REMARK_EN.equalsIgnoreCase(cell[9].getContents().trim())) {
            throw new LegoCheckedException(570602L);
        }
        if (!ZoneConstants.EXCEL_TABLENAME_REGULARIP_ZH.equalsIgnoreCase(cell[10].getContents().trim()) && !ZoneConstants.EXCEL_TABLENAME_REGULARIP_EN.equalsIgnoreCase(cell[10].getContents().trim())) {
            throw new LegoCheckedException(570602L);
        }
        if (!ZoneConstants.EXCEL_TABLENAME_EXCULDEIP_ZH.equalsIgnoreCase(cell[11].getContents().trim()) && !ZoneConstants.EXCEL_TABLENAME_EXCULDEIP_EN.equalsIgnoreCase(cell[11].getContents().trim())) {
            throw new LegoCheckedException(570602L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getImportZoneFromWorkbook(Workbook workbook) {
        try {
            Sheet sheet = workbook.getSheet(0);
            int j = sheet.getRows();
            for (int i = 3; i < j; ++i) {
                ZoneInfoForm zoneInfoForm;
                Cell[] cells = ZoneUtil.fillCell(sheet.getRow(i));
                boolean isEmptyRow = this.checkIsEmptyRow(cells);
                if (isEmptyRow || (zoneInfoForm = this.getAndCheckImportZoneInfoByCells(cells)) == null) continue;
                if (!zoneInfoForm.getZoneType().equals(ZoneConstants.ZONE_TYPE_DEFAULT)) {
                    List<ZoneListIpForm> zoneListIpFormList = this.getAndCheckImportZoneIpByCells(cells);
                    if (zoneListIpFormList == null) continue;
                    List<ZoneIpForm> zoneIpFormList = ZoneUtil.getZoneIpFormList(zoneListIpFormList);
                    zoneInfoForm.setZoneListIpFormList(zoneListIpFormList);
                    zoneInfoForm.setZoneIpFormList(zoneIpFormList);
                }
                this.zoneInfoFormList.add(zoneInfoForm);
            }
            if (this.zoneInfoFormList != null && this.zoneInfoFormList.size() > 1000) {
                logger.warn((Object)("import zone failed, import-zone count over maximum 1000 once import, the import-zone count : " + this.zoneInfoFormList.size()));
                throw new LegoCheckedException(570631L);
            }
        }
        finally {
            ZoneUtil.closeWorkbook(workbook);
        }
    }

    private boolean checkIsEmptyRow(Cell[] cells) {
        String zoneName = cells[0].getContents().trim();
        String zoneDesc = cells[1].getContents().trim();
        String zoneType = cells[2].getContents().trim();
        return ZoneUtil.isNull(zoneName) && ZoneUtil.isNull(zoneDesc) && ZoneUtil.isNull(zoneType);
    }

    private ZoneInfoForm getAndCheckImportZoneInfoByCells(Cell[] cells) {
        String zoneDesc = cells[1].getContents().trim();
        boolean isZoneDescPass = ZoneUtil.isValidZoneDesc(zoneDesc);
        if (!isZoneDescPass) {
            logger.info((Object)("import zone info failed, the name is wrong, zone name : " + zoneDesc));
            this.createImportFailedBO(zoneDesc, 570614L);
            return null;
        }
        String zoneName = cells[0].getContents().trim();
        boolean isZoneNamePass = ZoneUtil.isValidZoneName(zoneName);
        if (!isZoneNamePass) {
            logger.info((Object)("import zone info failed, the account is wrong, zone account : " + zoneDesc));
            this.createImportFailedBO(zoneDesc, 570613L);
            return null;
        }
        String zoneTypeString = cells[2].getContents().trim();
        boolean isZoneTypePass = ZoneUtil.isValidZoneType(zoneTypeString);
        if (!isZoneTypePass) {
            logger.info((Object)("import zone info failed, the type is wrong, zone type : " + zoneTypeString));
            this.createImportFailedBO(zoneDesc, 570615L);
            return null;
        }
        String zoneContact = cells[3].getContents().trim();
        boolean isZoneContactPass = ZoneUtil.isValidZoneContact(zoneContact);
        if (!isZoneContactPass) {
            logger.info((Object)("import zone info failed, the contact is wrong, zone contact : " + zoneContact));
            this.createImportFailedBO(zoneDesc, 570616L);
            return null;
        }
        String zoneTelephone = cells[4].getContents().trim();
        boolean isZoneTelephonePass = ZoneUtil.isValidZoneTelephone(zoneTelephone);
        if (!isZoneTelephonePass) {
            logger.info((Object)("import zone info failed, the telephone is wrong, zone telephone's length : " + zoneTelephone.length()));
            this.createImportFailedBO(zoneDesc, 570617L);
            return null;
        }
        String zoneMobile = cells[5].getContents().trim();
        boolean isZoneMobilePass = ZoneUtil.isValidZoneMobile(zoneMobile);
        if (!isZoneMobilePass) {
            logger.info((Object)("import zone info failed, the mobile is wrong, zone mobile's length : " + zoneMobile.length()));
            this.createImportFailedBO(zoneDesc, 570618L);
            return null;
        }
        String zonePost = cells[6].getContents().trim();
        boolean isZonePostPass = ZoneUtil.isValidZonePost(zonePost);
        if (!isZonePostPass) {
            logger.info((Object)("import zone info failed, the post is wrong, zone post's : " + zonePost.length()));
            this.createImportFailedBO(zoneDesc, 570619L);
            return null;
        }
        String zoneEmail = cells[7].getContents().trim();
        boolean isZoneEmailPass = ZoneUtil.isValidZoneEmail(zoneEmail);
        if (!isZoneEmailPass) {
            logger.info((Object)("import zone info failed, the email is wrong, zone email's : " + zoneEmail.length()));
            this.createImportFailedBO(zoneDesc, 570620L);
            return null;
        }
        String zoneAddress = cells[8].getContents().trim();
        boolean isZoneAddressPass = ZoneUtil.isValidZoneRemarkOrAddr(zoneAddress);
        if (!isZoneAddressPass) {
            logger.info((Object)("import zone info failed, the address is wrong, zone address's : " + zoneAddress.length()));
            this.createImportFailedBO(zoneDesc, 570621L);
            return null;
        }
        String zoneRemark = cells[9].getContents().trim();
        boolean isZoneRemarkPass = ZoneUtil.isValidZoneRemarkOrAddr(zoneRemark);
        if (!isZoneRemarkPass) {
            logger.info((Object)("import zone info failed, the remark is wrong, zone address's length : " + zoneRemark.length()));
            this.createImportFailedBO(zoneDesc, 570622L);
            return null;
        }
        logger.info((Object)("import zone info to memory,  zone name : " + zoneDesc + ", zone account : " + zoneDesc));
        ZoneInfoForm zoneInfoForm = new ZoneInfoForm();
        zoneInfoForm.setZoneName(zoneName);
        zoneInfoForm.setZoneDesc(zoneDesc);
        int zoneTypeInt = zoneTypeString.equals(ZoneConstants.ZONE_TYPE_DEFALUT_ZH) || zoneTypeString.equals(ZoneConstants.ZONE_TYPE_DEFALUT_EN) ? ZoneConstants.ZONE_TYPE_DEFAULT : ZoneConstants.ZONE_TYPE_CUSTOME;
        zoneInfoForm.setZoneType(zoneTypeInt);
        zoneInfoForm.setContact(zoneContact);
        zoneInfoForm.setTelephone(zoneTelephone);
        zoneInfoForm.setMobile(zoneMobile);
        zoneInfoForm.setAddress(zoneAddress);
        zoneInfoForm.setPost(zonePost);
        zoneInfoForm.setRemark(zoneRemark);
        zoneInfoForm.setEmail(zoneEmail);
        return zoneInfoForm;
    }

    private List<ZoneListIpForm> getAndCheckImportZoneIpByCells(Cell[] cells) {
        String zoneDesc = cells[1].getContents().trim();
        String listRegularIpString = cells[10].getContents().trim();
        String listExculdeIpString = cells[11].getContents().trim();
        List<ZoneListIpForm> zoneRegularListIpFromList = this.getAndCheckImportZoneIpByListIpString(listRegularIpString, 0);
        if (zoneRegularListIpFromList == null) {
            this.createImportFailedBO(zoneDesc, 570623L);
            return null;
        }
        List<ZoneListIpForm> zoneExculdeListIpFromList = this.getAndCheckImportZoneIpByListIpString(listExculdeIpString, 1);
        if (zoneExculdeListIpFromList == null) {
            this.createImportFailedBO(zoneDesc, 570699L);
            return null;
        }
        ArrayList<ZoneListIpForm> zoneListIpFromList = new ArrayList<ZoneListIpForm>();
        zoneListIpFromList.addAll(zoneRegularListIpFromList);
        zoneListIpFromList.addAll(zoneExculdeListIpFromList);
        return zoneListIpFromList;
    }

    private List<ZoneListIpForm> getAndCheckImportZoneIpByListIpString(String listIpString, int zoneIpType) {
        ArrayList<ZoneListIpForm> zoneListIpFromList = new ArrayList<ZoneListIpForm>();
        if (ZoneUtil.isNull(listIpString)) {
            return zoneListIpFromList;
        }
        String[] listIpArray = listIpString.split(";");
        int j = listIpArray.length;
        for (int i = 0; i < j; ++i) {
            ZoneListIpForm zoneListIpFrom = this.getAndCheckZoneListIpFormByListIpString(listIpArray[i], zoneIpType);
            if (zoneListIpFrom == null) {
                logger.info((Object)("import zone ip failed, the failed ip : " + listIpString));
                return null;
            }
            logger.info((Object)("import zone ip to memory, the ip : " + listIpArray[i]));
            zoneListIpFromList.add(zoneListIpFrom);
        }
        return zoneListIpFromList;
    }

    private ZoneListIpForm getAndCheckZoneListIpFormByListIpString(String listIpString, int zoneIpType) {
        if (ZoneUtil.isNull(listIpString)) {
            return null;
        }
        String fristPartIpInfo = "";
        String secondPartIpInfo = "";
        int zoneMaskType = -1;
        if (listIpString.indexOf(47) > -1) {
            zoneMaskType = 0;
            fristPartIpInfo = listIpString.split("/")[0];
            secondPartIpInfo = listIpString.split("/")[1];
        } else if (listIpString.indexOf(45) > -1) {
            zoneMaskType = 1;
            fristPartIpInfo = listIpString.split("-")[0];
            secondPartIpInfo = listIpString.split("-")[1];
        } else if (IPUtil.isIpv4((String)listIpString)) {
            zoneMaskType = 0;
            fristPartIpInfo = listIpString;
            secondPartIpInfo = "32";
        } else if (IPUtil.isIpv6((String)listIpString)) {
            zoneMaskType = 0;
            fristPartIpInfo = listIpString;
            secondPartIpInfo = "128";
        }
        ZoneListIpForm zoneListIpForm = this.getAndCheckZoneListIpForm(fristPartIpInfo, secondPartIpInfo, zoneIpType, zoneMaskType);
        return zoneListIpForm;
    }

    private ZoneListIpForm getAndCheckZoneListIpForm(String fristPartIpInfo, String secondPartIpInfo, int zoneIpType, int zoneMaskType) {
        if (zoneIpType == -1) {
            return null;
        }
        if (zoneMaskType == -1) {
            return null;
        }
        if (!(zoneMaskType != 1 || IPUtil.isIpv4((String)fristPartIpInfo) && IPUtil.isIpv4((String)secondPartIpInfo) || IPUtil.isIpv6((String)fristPartIpInfo) && IPUtil.isIpv6((String)secondPartIpInfo))) {
            return null;
        }
        if (!(zoneMaskType != 0 || IPUtil.isIpv4((String)fristPartIpInfo) && this.isValidIpv4Mask(secondPartIpInfo) || IPUtil.isIpv6((String)fristPartIpInfo) && this.isValidIpv6Mask(secondPartIpInfo))) {
            return null;
        }
        ZoneListIpForm zoneListIpForm = new ZoneListIpForm();
        switch (zoneMaskType) {
            case 0: {
                int mask = Integer.parseInt(secondPartIpInfo);
                zoneListIpForm.setZoneIp(fristPartIpInfo);
                zoneListIpForm.setIntMask(mask);
                zoneListIpForm.setStartIp(IPUtil.getSubnetRange((String)fristPartIpInfo, (int)mask)[0]);
                zoneListIpForm.setEndIp(IPUtil.getSubnetRange((String)fristPartIpInfo, (int)mask)[1]);
                break;
            }
            case 1: {
                zoneListIpForm.setStartIp(fristPartIpInfo);
                zoneListIpForm.setEndIp(secondPartIpInfo);
                break;
            }
            default: {
                return null;
            }
        }
        zoneListIpForm.setMaskType(zoneMaskType);
        zoneListIpForm.setIpType(zoneIpType);
        return zoneListIpForm;
    }

    private boolean isValidIpv4Mask(String mask) {
        boolean isValid = false;
        try {
            int intMask = Integer.parseInt(mask);
            if (intMask >= 8 && intMask <= 32) {
                isValid = true;
            }
        }
        catch (Exception e) {
            logger.error((Object)("Invalid ipv4 zone mask: " + AticUtil.getcleanedMessage((String)mask)));
        }
        return isValid;
    }

    private boolean isValidIpv6Mask(String mask) {
        boolean isValid = false;
        try {
            int intMask = Integer.parseInt(mask);
            if (intMask >= 8 && intMask <= 128) {
                isValid = true;
            }
        }
        catch (Exception e) {
            logger.error((Object)("Invalid ipv6 zone mask: " + AticUtil.getcleanedMessage((String)mask)));
        }
        return isValid;
    }

    private void createImportFailedBO(String targetName, long errorCode) {
        BatchOperation batchOperation = new BatchOperation();
        batchOperation.setTargetName(targetName);
        batchOperation.setErrorCode(errorCode);
        this.frontOperationList.add(batchOperation);
    }

    public void exportIpDomain() {
        if (null != this.idStr) {
            String[] idStrCs;
            String idStrC = this.idStr.substring(0, this.idStr.length() - 1);
            for (String id : idStrCs = idStrC.split(",")) {
                if (AticUtil.isNum((String)id).booleanValue()) continue;
                throw new LegoCheckedException(570505L);
            }
        }
        try {
            String exportFilePath = this.initExportFile("ipdomain");
            List<IpDomainForm> ipDomainForms = this.getExportIpDomain();
            this.writeIpDomainToExportFile(ipDomainForms, exportFilePath);
            String[] args = exportFilePath.split("\\\\");
            this.responseResult(args[args.length - 1]);
        }
        catch (Exception e) {
            logger.error((Object)"export IpDomain error : ", (Throwable)e);
            throw new LegoCheckedException(570697L, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeIpDomainToExportFile(List<IpDomainForm> ipDomainForms, String exportFilePath) throws IOException {
        CSVReader reader = new CSVReader(exportFilePath);
        BufferedWriter fw = new BufferedWriter((Writer)new FileWriterWithEncoding(exportFilePath, System.getProperty("file.encoding")));
        try {
            List<String> ipDomains = reader.getList();
            for (String line : ipDomains) {
                fw.write(line + System.getProperty("line.separator", "/n"));
            }
            if (null != ipDomainForms && !ipDomainForms.isEmpty()) {
                int j = ipDomainForms.size();
                for (int i = 0; i < j; ++i) {
                    IpDomainForm ipDomainForm = ipDomainForms.get(i);
                    fw.write(ipDomainForm.getDestIp() + "," + ipDomainForm.getDomain() + System.getProperty("line.separator", "/n"));
                }
            }
        }
        finally {
            fw.close();
            reader.csvClose();
        }
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private List<IpDomainForm> getExportIpDomain() {
        IIpDomainService service = ZoneReferUtil.getIpDomainService();
        String path = this.getExportFilePath("ipdomain");
        String[] fileName = path.split("\\\\");
        List<IpDomainForm> ipDomainForms = null;
        if (null != this.idStr) {
            if (!"".equals(this.idStr)) {
                this.idStr = this.idStr.substring(0, this.idStr.length() - 1);
                ipDomainForms = service.getByIds(this.idStr);
            }
            this.getOperateLog().info("atic.ipdomain.title.export.select", "lego.dic.module.AticBis", fileName[fileName.length - 1], false, "atic.ip.domain.title.emport.success", null);
            logger.info((Object)("export IpDomain to memory, the export-IpDomain : " + this.getcleanedMessage(this.idStr)));
        } else {
            ipDomainForms = service.queryByPage(this.createIpDomainQueryAllMap(), 0, Integer.MAX_VALUE).getData();
            this.getOperateLog().info("atic.ipdomain.title.export.all", "lego.dic.module.AticBis", fileName[fileName.length - 1], false, "atic.ip.domain.title.emport.success", null);
            logger.info((Object)"export IpDomain to memory, the export-IpDomain : all");
        }
        return ipDomainForms;
    }

    private String initExportFile(String source) throws IOException {
        String exportFilePath = this.getExportFilePath(source);
        String templateFilePath = "";
        if ("zoneInfo".equals(source)) {
            templateFilePath = this.getSession().getServletContext().getRealPath("") + File.separator + "template" + File.separator + LocaleUtil.INSTANCE.getText("atic.user.file.template.name");
            ZoneUtil.copyFile(templateFilePath, exportFilePath);
        } else {
            templateFilePath = this.getSession().getServletContext().getRealPath("") + File.separator + "template" + File.separator + LocaleUtil.INSTANCE.getText("atic.ipdomain.file.template.name");
            ZoneUtil.copyCsvFile(templateFilePath, exportFilePath);
        }
        return exportFilePath;
    }

    private String getExportFilePath(String source) {
        String exportFolderPath = this.getSession().getServletContext().getRealPath("") + File.separator + "export";
        boolean isCreateExportFolderSuccess = ZoneUtil.isCreateFolderSuccess(exportFolderPath);
        if (!isCreateExportFolderSuccess) {
            throw new LegoCheckedException(0L);
        }
        Long dateTime = System.currentTimeMillis();
        String exportFolderName = "";
        exportFolderName = source.contains("zoneInfo") ? "zoneInfo_" + dateTime + ".xls" : "ipDescription_" + dateTime + ".csv";
        return exportFolderPath + File.separator + exportFolderName;
    }

    private Map<String, String> createQueryAllMap() {
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("zoneName", null);
        queryMap.put("zoneType", null);
        queryMap.put("queryIpAddress", null);
        queryMap.put("sortName", null);
        queryMap.put("sortType", null);
        User currentUser = (User)this.getSession().getAttribute("currentUser");
        if (null != currentUser) {
            queryMap.put("currentUserId", String.valueOf(currentUser.getUserID()));
            queryMap.put("currentUserIsAdmin", currentUser.getIsAdmin());
        }
        return queryMap;
    }

    private Map<String, String> createIpDomainQueryAllMap() {
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("destIp", null);
        queryMap.put("domain", null);
        queryMap.put("sortName", null);
        queryMap.put("sortType", null);
        User currentUser = (User)this.getSession().getAttribute("currentUser");
        if (null != currentUser) {
            queryMap.put("currentUserId", String.valueOf(currentUser.getUserID()));
            queryMap.put("currentUserIsAdmin", currentUser.getIsAdmin());
        }
        return queryMap;
    }

    public void cancelTask() {
        this.importAndExportService = ZoneUtil.getImportAndExportService();
        this.importAndExportService.cancelTask(this.progressId);
    }

    public void exportByZone() {
        List<Long> zoneIds = this.dealIds(TAG);
        if (zoneIds.isEmpty()) {
            this.initZoneService();
            this.zoneInfoFormList = this.zoneService.queryByPage(this.createQueryAllMap(), 0, Integer.MAX_VALUE).getData();
            for (ZoneInfoForm form : this.zoneInfoFormList) {
                zoneIds.add(form.getZoneId());
            }
        }
        List<Long> deviceIds = this.dealIds("deviceIdStr");
        this.dealExport(this.getNeedExportZone(zoneIds), deviceIds, "policy-zone");
    }

    private List<Long> getNeedExportZone(List<Long> zoneIds) {
        ArrayList<Long> zoneIdReturn = new ArrayList<Long>();
        IZoneDeviceService zoneDeviceService = ZoneReferUtil.getZoneDeviceService();
        for (Long id : zoneIds) {
            boolean containsDdosDev = false;
            List devList = zoneDeviceService.getByZoneId(id);
            if (null != devList && !devList.isEmpty()) {
                for (ZoneDeviceForm zoneDeviceForm : devList) {
                    AticDevice aticDevice;
                    IAticDeviceService aticDeviceService;
                    if (null == zoneDeviceForm || null == zoneDeviceForm.getDeviceId() || null == (aticDeviceService = ZoneReferUtil.getFirewallService()) || null == (aticDevice = aticDeviceService.getDeviceByMoid(zoneDeviceForm.getDeviceId().longValue())) || 5 == aticDevice.getDeviceType()) continue;
                    containsDdosDev = true;
                    break;
                }
            } else {
                containsDdosDev = true;
            }
            if (!containsDdosDev) continue;
            zoneIdReturn.add(id);
        }
        return zoneIdReturn;
    }

    public void validateStartAndEndNum() {
        if (!this.validateStartAndEndNum4Back()) {
            this.responseResult("error");
            return;
        }
    }

    public boolean validateStartAndEndNum4Back() {
        if (null == this.startNum || null == this.endNum) {
            return false;
        }
        if (this.startNum < 1 || this.startNum > this.zoneCount) {
            return false;
        }
        if (this.endNum < 1 || this.endNum > this.zoneCount) {
            return false;
        }
        if (this.startNum > this.endNum) {
            return false;
        }
        return this.endNum - this.startNum <= 999;
    }

    private void dealExport(List<Long> zoneIds, List<Long> deviceIds, String fileName) {
        if (null == this.zoneImportAndExportXmlService) {
            this.initZoneImportAndExportService();
        }
        String logType = "";
        String[] str = null;
        if ("policy-device".equals(fileName)) {
            logType = "lego.dic.module.neGlobalApp";
            AticDevice device = ZoneReferUtil.getFirewallService().getDeviceByIp(this.deviceIp);
            str = null != device ? new String[]{device.getName(), this.deviceIp} : new String[]{};
        } else {
            logType = "lego.dic.module.ddosApp";
        }
        if ("exportAll".equals(this.exportTag)) {
            this.initZoneService();
            this.zoneInfoFormList = this.zoneService.queryByPage(this.createQueryAllMap(), 0, Integer.MAX_VALUE).getData();
            StringBuffer sBuffer = new StringBuffer();
            for (ZoneInfoForm form : this.zoneInfoFormList) {
                sBuffer.append(form.getZoneDesc()).append(',');
            }
            this.zoneNames = sBuffer.toString();
        } else {
            List<ZoneInfoForm> allZonenames = this.zoneService.getZoneListByZoneIdS(this.idStr);
            if (allZonenames != null) {
                for (ZoneInfoForm zoneinfo : allZonenames) {
                    this.zoneNames = this.zoneNames + zoneinfo.getZoneName() + ",";
                }
            }
        }
        if (null != this.zoneNames && !this.zoneNames.isEmpty()) {
            try {
                this.zoneNames = URLDecoder.decode(this.zoneNames, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                logger.info((Object)e);
            }
            this.zoneNames = this.zoneNames.substring(0, this.zoneNames.length() - 1);
        }
        try {
            String exportFilePath = this.getExportFilePathForExportZone(fileName);
            ZonePolicyIOForm form = new ZonePolicyIOForm();
            String fmt = "yyyy-MM-dd H:m:s";
            SimpleDateFormat sdf = new SimpleDateFormat(fmt);
            Date date = new Date();
            String time = sdf.format(date);
            String paraKey = "lego.lab.com.about.red.versionval";
            String systemVersion = this.getText(paraKey);
            if (!AticUtil.isNull((String)systemVersion) && !systemVersion.equals(paraKey)) {
                form.setSystemVersion(systemVersion.split(this.getText("atic.public.punctuation.colon2"))[1].trim());
            } else {
                form.setSystemVersion("ATIC");
            }
            form.setDimension(this.dimension);
            form.setTime(time);
            ExportZoneConditionForm conditionForm = new ExportZoneConditionForm();
            conditionForm.setZoneIds(zoneIds);
            if ("policy-device".equals(fileName)) {
                ArrayList<Long> idList = new ArrayList<Long>();
                idList.add(this.deviceId);
                conditionForm.setDeviceIds(idList);
            } else {
                conditionForm.setDeviceIds(deviceIds);
            }
            conditionForm.setExportFilePath(exportFilePath);
            conditionForm.setExportSelectedContent(this.exportContentStr);
            conditionForm.setDeviceId(this.deviceId);
            conditionForm.setDimension(this.dimension);
            ExportZonePolicyThread task = new ExportZonePolicyThread(form, conditionForm, this.progressBarId);
            task.setStartNum(this.startNum);
            task.setEndNum(this.endNum);
            task.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)CrashThreadHandler.getInstance());
            task.start();
            while (!task.isEnd()) {
                try {
                    Thread.sleep(2000L);
                    logger.info((Object)"wait all task run over");
                }
                catch (InterruptedException e) {
                    logger.info((Object)e);
                }
            }
            if (this.zoneNames != null && this.zoneNames.length() > 255) {
                try {
                    this.zoneNames = ZoneUtil.substring(this.zoneNames, 252, "UTF-8") + "...";
                }
                catch (UnsupportedEncodingException e1) {
                    logger.info((Object)e1);
                }
            }
            this.getOperateLog().normal("exportAll".equals(this.exportTag) ? EXPORT_BY_ZONE_ALL : EXPORT_BY_ZONE, logType, "policy-device".equals(fileName) ? this.deviceIp : this.zoneNames, false, "policy-device".equals(fileName) ? "atic.zone.export.device.success.log" : "atic.zone.export.zone.success.log", str);
        }
        catch (LegoCheckedException e) {
            this.zoneNames = this.getOperateLogZoneNames();
            this.getOperateLog().normal("exportAll".equals(this.exportTag) ? EXPORT_BY_ZONE_ALL : EXPORT_BY_ZONE, logType, "policy-device".equals(fileName) ? this.deviceIp : this.zoneNames, false, "policy-device".equals(fileName) ? "atic.zone.export.device.failed.log" : "atic.zone.export.zone.failed.log", str);
            throw new LegoCheckedException(e.getErrorCode(), (Throwable)e);
        }
    }

    private String getOperateLogZoneNames() {
        if (this.zoneNames != null && this.zoneNames.length() > 255) {
            try {
                this.zoneNames = ZoneUtil.substring(this.zoneNames, 252, "UTF-8") + "...";
            }
            catch (UnsupportedEncodingException e1) {
                this.zoneNames = "allZone";
                logger.info((Object)e1);
            }
        } else {
            this.zoneNames = "allZone";
        }
        return this.zoneNames;
    }

    public void exportByDeviceGetFileName() {
        String exportFilePath = this.getExportFilePathForExportZone("policy-device");
        String[] args = exportFilePath.split("\\\\");
        this.responseResult(args[args.length - 1]);
    }

    private String getExportFilePathForExportZone(String source) {
        String exportFolderPath = this.getSession().getServletContext().getRealPath("") + File.separator + "export";
        boolean isCreateExportFolderSuccess = ZoneUtil.isCreateFolderSuccess(exportFolderPath);
        if (!isCreateExportFolderSuccess) {
            throw new LegoCheckedException(0L);
        }
        String exportFolderName = "";
        exportFolderName = source.contains("zone") ? "policy-zone.xml" : "policy-device-" + this.deviceIp + ".xml";
        return exportFolderPath + File.separator + exportFolderName;
    }

    public List<Long> dealIds(String tag) {
        HttpServletRequest request = this.fetchRequest();
        ArrayList<Long> zoneOrDeviceIds = new ArrayList<Long>();
        if (request.getParameter(tag) != null) {
            String tempStr = null;
            if (tag.equals(TAG)) {
                tempStr = this.idStr;
            } else if (tag.equals("deviceIdStr")) {
                tempStr = this.deviceIdStr;
            }
            if (null != tempStr && !"".equals(tempStr)) {
                String[] ids = tempStr.split(",");
                for (int i = 0; i < ids.length; ++i) {
                    if (null == ids[i] || "".equals(ids[i])) continue;
                    Long moId = ZoneBisUtil.getMoidByZoneid(Long.valueOf(ids[i]));
                    ArrayList<Long> moIdList = new ArrayList<Long>();
                    moIdList.add(moId);
                    BisUtil.checkUserSecurity(moIdList);
                    zoneOrDeviceIds.add(Long.valueOf(ids[i]));
                }
            }
        }
        return zoneOrDeviceIds;
    }

    public String selectExportContent() {
        this.initSelectExportContentList();
        this.initDevicesAndGroups();
        return "success";
    }

    public void selectExportValateCount() {
        this.initZoneService();
        this.zoneInfoFormList = this.zoneService.queryByPage(this.createQueryAllMap(), 0, Integer.MAX_VALUE).getData();
        if (this.zoneInfoFormList.size() > 1000) {
            this.responseResult("max");
        } else {
            this.responseResult("success");
        }
    }

    public void selectExportByDeviceValateCount() {
        if (null == this.zoneServiceService) {
            this.zoneServiceService = ZoneReferUtil.getZoneServiceService();
        }
        List<ZoneServiceForm> list = this.zoneServiceService.queryByDeviceId(this.deviceId);
        HashSet<Long> idSet = new HashSet<Long>();
        for (ZoneServiceForm form : list) {
            idSet.add(form.getZoneId());
        }
        if (idSet.size() > 1000) {
            this.zoneCount = list.size();
            this.responseResult("" + this.zoneCount);
        } else {
            this.responseResult("success");
        }
    }

    public String selectExportContentByDevice() {
        ArrayList<Long> deviceList = new ArrayList<Long>();
        deviceList.add(Long.valueOf(this.idStr));
        BisUtil.checkUserSecurity(deviceList);
        this.initSelectExportContentByDeviceList();
        return "success";
    }

    public void initSelectExportContentByDeviceList() {
        this.selectExportContentByDeviceList = new ArrayList<LangPair>();
        LangPair pair1 = new LangPair(this.getText("atic.zone.export.by.zone.global.policy"), "globalPolicy");
        LangPair pair2 = new LangPair(this.getText("atic.zone.export.by.zone.ip.location"), "ipLocation");
        LangPair pair3 = new LangPair(this.getText("atic.zone.export.by.zone.filter"), "filter");
        LangPair pair4 = new LangPair(this.getText("atic.zone.export.by.zone.defense.policy"), "defensePolicy");
        this.selectExportContentByDeviceList.add(pair1);
        this.selectExportContentByDeviceList.add(pair2);
        this.selectExportContentByDeviceList.add(pair3);
        this.selectExportContentByDeviceList.add(pair4);
    }

    public void initSelectExportContentList() {
        this.selectExportContentList = new ArrayList<LangPair>();
        LangPair pair1 = new LangPair(this.getText("atic.zone.export.by.zone.basic.information"), "basicInformation");
        LangPair pair2 = new LangPair(this.getText("atic.zone.export.by.zone.ip.address"), "ipAddress");
        LangPair pair3 = new LangPair(this.getText("atic.zone.export.by.zone.defense.mode"), "defenseMode");
        LangPair pair4 = new LangPair(this.getText("atic.zone.export.by.zone.filter"), "filter");
        LangPair pair5 = new LangPair(this.getText("atic.zone.export.by.zone.defense.policy"), "defensePolicy");
        LangPair pair6 = new LangPair(this.getText("atic.zone.export.by.zone.blocked.location"), "blockedLocation");
        LangPair pair7 = new LangPair(this.getText("atic.zone.export.by.zone.black.list"), "blackListPolicy");
        LangPair pair8 = new LangPair(this.getText("atic.zone.export.by.zone.white.list"), "whiteListPolicy");
        this.selectExportContentList.add(pair1);
        this.selectExportContentList.add(pair2);
        this.selectExportContentList.add(pair3);
        this.selectExportContentList.add(pair4);
        this.selectExportContentList.add(pair5);
        this.selectExportContentList.add(pair6);
        this.selectExportContentList.add(pair7);
        this.selectExportContentList.add(pair8);
    }

    private List<ZoneDeviceForm> zoneDeviceFormsList() {
        List<Long> zoneIds = this.dealIds(TAG);
        if (zoneIds.isEmpty()) {
            this.initZoneService();
            this.zoneInfoFormList = this.zoneService.queryByPage(this.createQueryAllMap(), 0, Integer.MAX_VALUE).getData();
            for (ZoneInfoForm form : this.zoneInfoFormList) {
                zoneIds.add(form.getZoneId());
            }
        }
        this.zoneCount = zoneIds.size();
        IZoneDeviceService zoneDeviceService = ZoneReferUtil.getZoneDeviceService();
        ArrayList<ZoneDeviceForm> zoneDeviceList = new ArrayList<ZoneDeviceForm>();
        for (Long id : zoneIds) {
            List zoneDeviceFormsList = zoneDeviceService.queryZoneDeviceFormsByZoneID(id);
            for (ZoneDeviceForm form : zoneDeviceFormsList) {
                boolean tag = true;
                for (ZoneDeviceForm zoneDeviceForm : zoneDeviceList) {
                    if (!form.getDeviceId().equals(zoneDeviceForm.getDeviceId())) continue;
                    tag = false;
                }
                if (!tag) continue;
                zoneDeviceList.add(form);
            }
        }
        return zoneDeviceList;
    }

    private void initDevicesAndGroups() {
        IDefendGroupService defendGroupService = ZoneReferUtil.getDefendGroupService();
        IAticDeviceService aticDeviceService = ZoneReferUtil.getFirewallService();
        ArrayList<DeviceAndGroup> devicesInGroup = new ArrayList<DeviceAndGroup>();
        ArrayList<DeviceAndGroup> devicesSimple = new ArrayList<DeviceAndGroup>();
        DeviceAndGroup device = null;
        List<ZoneDeviceForm> zoneDeviceFormsList = this.zoneDeviceFormsList();
        if (!zoneDeviceFormsList.isEmpty()) {
            for (ZoneDeviceForm zoneDeviceForm : zoneDeviceFormsList) {
                AticDevice ne = ZoneReferUtil.getDevice(zoneDeviceForm.getDeviceId());
                if (null == ne) continue;
                List defendGroupFormList = defendGroupService.getDefendGroupFormListByDevId(zoneDeviceForm.getDeviceId().longValue());
                device = new DeviceAndGroup();
                device.setId(ne.getMoId());
                device.setDeviceName(ne.getName());
                device.setIpAddress(ne.getIpAddress());
                device.setDeviceState(String.valueOf(aticDeviceService.getStatusByMoid(ne.getMoId())));
                device.setDeviceVpn(zoneDeviceForm.getVpnName());
                device.setDevType(ne.getDdosType());
                if (defendGroupFormList.isEmpty()) {
                    if (ne.getDeviceType() != 1) continue;
                    device.setDefGroupName("");
                    devicesSimple.add(device);
                    continue;
                }
                if (ne.getDeviceType() != 1) continue;
                device.setDefGroupName(((DefendGroupForm)defendGroupFormList.get(0)).getGroupName());
                devicesInGroup.add(device);
            }
            Collections.sort(devicesInGroup, comparator);
        }
        this.devicesAndGroups = new ArrayList<DeviceAndGroup>();
        this.devicesAndGroups.addAll(devicesInGroup);
        this.devicesAndGroups.addAll(devicesSimple);
    }

    public String showProgressExportPolicy() {
        return "success";
    }

    public String getImportFilePath() {
        return this.importFilePath;
    }

    public void setImportFilePath(String importFilePath) {
        this.importFilePath = importFilePath;
    }

    public Long getProgressId() {
        return this.progressId;
    }

    public void setProgressId(Long progressId) {
        this.progressId = progressId;
    }

    public IZoneService getZoneService() {
        return this.zoneService;
    }

    public void setZoneService(IZoneService zoneService) {
        this.zoneService = zoneService;
    }

    public List<ZoneInfoForm> getZoneInfoFormList() {
        return this.zoneInfoFormList;
    }

    public void setZoneInfoFormList(List<ZoneInfoForm> zoneInfoFormList) {
        this.zoneInfoFormList = zoneInfoFormList;
    }

    public List<BatchOperation> getFrontOperationList() {
        return this.frontOperationList;
    }

    public void setFrontOperationList(List<BatchOperation> frontOperationList) {
        this.frontOperationList = frontOperationList;
    }

    public IZoneImportAndExportXmlService getZoneImportAndExportXmlService() {
        return this.zoneImportAndExportXmlService;
    }

    public void setZoneImportAndExportXmlService(IZoneImportAndExportXmlService zoneImportAndExportXmlService) {
        this.zoneImportAndExportXmlService = zoneImportAndExportXmlService;
    }

    public List<LangPair> getSelectExportContentList() {
        return this.selectExportContentList;
    }

    public void setSelectExportContentList(List<LangPair> selectExportContentList) {
        this.selectExportContentList = selectExportContentList;
    }

    public String getSelectExportContents() {
        return this.selectExportContents;
    }

    public void setSelectExportContents(String selectExportContents) {
        this.selectExportContents = selectExportContents;
    }

    public List<DeviceAndGroup> getDevicesAndGroups() {
        return this.devicesAndGroups;
    }

    public void setDevicesAndGroups(List<DeviceAndGroup> devicesAndGroups) {
        this.devicesAndGroups = devicesAndGroups;
    }

    public String getDimension() {
        return this.dimension;
    }

    public void setDimension(String dimension) {
        this.dimension = dimension;
    }

    public List<LangPair> getSelectExportContentByDeviceList() {
        return this.selectExportContentByDeviceList;
    }

    public void setSelectExportContentByDeviceList(List<LangPair> selectExportContentByDeviceList) {
        this.selectExportContentByDeviceList = selectExportContentByDeviceList;
    }

    public String getDeviceIp() {
        return this.deviceIp;
    }

    public void setDeviceIp(String deviceIp) {
        this.deviceIp = deviceIp;
    }

    public Long getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(Long deviceId) {
        this.deviceId = deviceId;
    }

    public String getZoneNames() {
        return this.zoneNames;
    }

    public void setZoneNames(String zoneNames) {
        this.zoneNames = zoneNames;
    }

    public String getExportTag() {
        return this.exportTag;
    }

    public void setExportTag(String exportTag) {
        this.exportTag = exportTag;
    }

    public int getZoneCount() {
        return this.zoneCount;
    }

    public void setZoneCount(int zoneCount) {
        this.zoneCount = zoneCount;
    }

    public Long getProgressBarId() {
        return this.progressBarId;
    }

    public void setProgressBarId(Long progressBarId) {
        this.progressBarId = progressBarId;
    }

    public String getIdStr() {
        return this.idStr;
    }

    public void setIdStr(String idStr) {
        this.idStr = idStr;
    }

    public String getExportFileName() {
        return this.exportFileName;
    }

    public void setExportFileName(String exportFileName) {
        this.exportFileName = exportFileName;
    }

    public String getExportContentStr() {
        return this.exportContentStr;
    }

    public void setExportContentStr(String exportContentStr) {
        this.exportContentStr = exportContentStr;
    }

    public boolean isSuperSize() {
        return this.superSize;
    }

    public void setSuperSize(boolean superSize) {
        this.superSize = superSize;
    }

    public Integer getStartNum() {
        return this.startNum;
    }

    public void setStartNum(Integer startNum) {
        this.startNum = startNum;
    }

    public Integer getEndNum() {
        return this.endNum;
    }

    public void setEndNum(Integer endNum) {
        this.endNum = endNum;
    }

    public String getDeviceIdStr() {
        return this.deviceIdStr;
    }

    public void setDeviceIdStr(String deviceIdStr) {
        this.deviceIdStr = deviceIdStr;
    }

    public IZoneServiceService getZoneServiceService() {
        return this.zoneServiceService;
    }

    public void setZoneServiceService(IZoneServiceService zoneServiceService) {
        this.zoneServiceService = zoneServiceService;
    }

    public boolean validateIdstr(String parameterName) {
        HttpServletRequest request = this.fetchRequest();
        String zoneIdsTemp = request.getParameter(parameterName);
        if (null == zoneIdsTemp) {
            return true;
        }
        return new ZoneManageAction().validateZoneIds(parameterName);
    }

    public boolean validatedeviceIdStr() {
        if (this.deviceIdStr == null || "".equals(this.deviceIdStr.trim())) {
            return true;
        }
        String[] ids = this.deviceIdStr.split(",");
        for (int i = 0; i < ids.length; ++i) {
            try {
                long id = Long.parseLong(ids[i]);
                if (id >= 0L) continue;
                return false;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return true;
    }

    public boolean validateZoneNames() {
        String[] ids;
        String regex = "^(?!(?i)null$)[\\w|\u4e00-\u9fa5|\\-|\\!|\\@|\\#|\\$|\\^|\\.|\\+|\\}|\\{|\\,|\\%]*$";
        if (null == this.zoneNames || null == this.idStr || "".equals(this.zoneNames) || "".equals(this.idStr)) {
            return true;
        }
        String[] names = this.zoneNames.split(",");
        if (names.length != (ids = this.idStr.split(",")).length) {
            return false;
        }
        for (int i = 0; i < names.length; ++i) {
            if (names[i].matches(regex) && names[i].length() >= 1 && names[i].length() <= 255) continue;
            return false;
        }
        return true;
    }

    public boolean validateSuperSize() {
        HttpServletRequest request = ServletActionContext.getRequest();
        String size = request.getParameter("superSize");
        if (null == size) {
            return true;
        }
        return "true".equals(size) || "false".equals(size);
    }

    public boolean validateExportContentStr() {
        if (this.exportContentStr == null || "".equals(this.exportContentStr.trim()) || "null".equals(this.exportContentStr)) {
            return false;
        }
        String regex = "^[0-9A-Za-z,]{0,}$";
        return this.exportContentStr.matches(regex);
    }

    public boolean validateDeviceIp() {
        if (this.deviceIp != null) {
            return IPUtil.isIpv4((String)this.deviceIp.trim()) || IPUtil.isIpv6((String)this.deviceIp.trim());
        }
        return true;
    }

    public boolean validateIdStr() {
        if (null == this.idStr) {
            return true;
        }
        String[] ids = this.idStr.split(",");
        for (int i = 0; i < ids.length; ++i) {
            try {
                long id = Long.parseLong(ids[i]);
                if (id >= 0L) continue;
                return false;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return true;
    }

    public boolean validateBatchBatchIdStr() {
        try {
            String idStrC;
            if (null != this.idStr && !AticUtil.isNum((String)(idStrC = this.idStr.substring(0, this.idStr.length() - 1))).booleanValue()) {
                return false;
            }
        }
        catch (RuntimeException e) {
            return false;
        }
        return true;
    }

    public boolean validateExportTag() {
        if (null == this.exportTag) {
            return true;
        }
        return "export".equals(this.exportTag) || "exportAll".equals(this.exportTag);
    }
}

