/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.policy.util;

import com.hs.vsm.secservice.ddos.policy.beans.DevCapPair;
import com.hs.vsm.secservice.ddos.policy.ref.ZoneReferUtil;
import com.hs.vsm.secservice.nfa.util.NfaClusterUtil;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.adapter.capability.model.DeviceTypeInfo;
import com.huawei.atic.secne.adapter.capability.model.ParaBean;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.huawei.atic.secservice.sdk.module.ddos.service.IDdosDevCapabilityService;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;

public final class DevCapUtil {
    private static final DevCapUtil INSTANCE = new DevCapUtil();
    private ReentrantLock lock = new ReentrantLock();
    private Map<DevCapPair, Map<String, ParaBean>> cacheMap = new HashMap<DevCapPair, Map<String, ParaBean>>();
    private Map<DevCapPair, Set<String>> cacheSupport = new HashMap<DevCapPair, Set<String>>();
    private Map<Long, DeviceTypeInfo> cacheDeviceTypeInfo = new HashMap<Long, DeviceTypeInfo>();

    private DevCapUtil() {
    }

    public static DevCapUtil getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initContext(Long moId, String serviceType) {
        this.lock.lock();
        try {
            IDdosDevCapabilityService ddosDevCapServ = ZoneReferUtil.getDdosDevCapabilityService();
            IAticDeviceService mgr = ZoneReferUtil.getFirewallService();
            if (mgr != null) {
                AticDevice securityNE = mgr.getDeviceByMoid(moId.longValue());
                DeviceTypeInfo devInfo = new DeviceTypeInfo();
                if (securityNE.getDeviceType() == 1 || securityNE.getDeviceType() == 5) {
                    devInfo.setDevType(securityNE.getDeviceModel());
                    devInfo.setDevOSVersion(securityNE.getVersion());
                } else if (securityNE.getDeviceType() == 7) {
                    AticDevice aticDevice = NfaClusterUtil.getNfaDeviceInfo(securityNE.getMoId());
                    devInfo.setDevType(aticDevice.getDeviceModel());
                    devInfo.setDevOSVersion(aticDevice.getVersion());
                }
                String serviceTypeTmp = serviceType;
                if ("DEFAULT".equals(serviceType)) {
                    serviceTypeTmp = "Default";
                }
                devInfo.setDevVersion(serviceTypeTmp);
                DevCapPair devCapPair = new DevCapPair(moId, serviceType);
                this.checkCache(devInfo, devCapPair);
                this.cacheData(ddosDevCapServ, devInfo, devCapPair);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initContext(String serviceType, String devType, String devOSVersion) {
        this.lock.lock();
        try {
            IDdosDevCapabilityService ddosDevCapServ = ZoneReferUtil.getDdosDevCapabilityService();
            DeviceTypeInfo devInfo = new DeviceTypeInfo();
            devInfo.setDevType(devType);
            devInfo.setDevOSVersion(devOSVersion);
            String serviceTypeTmp = serviceType;
            if ("DEFAULT".equals(serviceType)) {
                serviceTypeTmp = "Default";
            }
            devInfo.setDevVersion(serviceTypeTmp);
            DevCapPair devCapPair = new DevCapPair(serviceType, devType, devOSVersion);
            this.cacheData(ddosDevCapServ, devInfo, devCapPair);
        }
        finally {
            this.lock.unlock();
        }
    }

    private synchronized void cacheData(IDdosDevCapabilityService ddosDevCapServ, DeviceTypeInfo devInfo, DevCapPair devCapPair) {
        if (!this.cacheMap.containsKey(devCapPair)) {
            Map paramBeanMap = ddosDevCapServ.getAllParaBeanMap(devInfo);
            this.cacheMap.put(devCapPair, paramBeanMap);
        }
        if (!this.cacheSupport.containsKey(devCapPair)) {
            Set supportAttrs = ddosDevCapServ.getAllSupportedAttr(devInfo);
            this.cacheSupport.put(devCapPair, supportAttrs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEnable(String id, Long moId, String serviceType) {
        this.lock.lock();
        try {
            DevCapPair devCapPair = new DevCapPair(moId, serviceType);
            Set<String> supportAttrs = this.cacheSupport.get(devCapPair);
            if (null != supportAttrs && supportAttrs.contains(id)) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEnable(String id, String serviceType, String devType, String devOSVersion) {
        this.lock.lock();
        try {
            DevCapPair devCapPair = new DevCapPair(serviceType, devType, devOSVersion);
            Set<String> supportAttrs = this.cacheSupport.get(devCapPair);
            if (null != supportAttrs && supportAttrs.contains(id)) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParaBean hasParasDiff(String id, Long moId, String serviceType) {
        this.lock.lock();
        try {
            DevCapPair devCapPair = new DevCapPair(moId, serviceType);
            ParaBean paraBean = this.getCacheParaBean(id, devCapPair);
            return paraBean;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParaBean hasParasDiff(String id, String serviceType, String devType, String devOSVersion) {
        this.lock.lock();
        try {
            DevCapPair devCapPair = new DevCapPair(serviceType, devType, devOSVersion);
            ParaBean paraBean = this.getCacheParaBean(id, devCapPair);
            return paraBean;
        }
        finally {
            this.lock.unlock();
        }
    }

    private synchronized ParaBean getCacheParaBean(String id, DevCapPair devCapPair) {
        Map<String, ParaBean> paramBeanMap = this.cacheMap.get(devCapPair);
        if (null != paramBeanMap && paramBeanMap.keySet().contains(id)) {
            return paramBeanMap.get(id);
        }
        return null;
    }

    private synchronized void checkCache(DeviceTypeInfo devInfo, DevCapPair devPair) {
        if (this.cacheDeviceTypeInfo.containsKey(devPair.getMoId())) {
            DeviceTypeInfo cacheInfo = this.cacheDeviceTypeInfo.get(devPair.getMoId());
            if (!cacheInfo.getDevType().equals(devInfo.getDevType()) || !cacheInfo.getDevOSVersion().equals(devInfo.getDevOSVersion())) {
                this.cacheMap.remove(devPair);
                this.cacheSupport.remove(devPair);
            }
        } else {
            this.cacheDeviceTypeInfo.put(devPair.getMoId(), devInfo);
        }
    }
}

