/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.policy.util;

import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.comm.BatchOperation;
import com.hs.lego.core.sdk.comm.BatchOperationResult;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.vsm.secservice.ddos.policy.util.Subnet;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpSession;
import org.apache.commons.net.util.SubnetUtils;
import org.springframework.beans.BeanUtils;

public final class PolicyUtil {
    public static final Long NUM_THREE_HUNDRED = 300L;
    public static final Long NUM_THREE_THOUSAND_SIX_HUNDRED = 3600L;
    public static final Long NUM_2130706431 = 0x7EFFFFFFL;
    public static final Long NUM_2147483648 = 0x80000000L;

    private PolicyUtil() {
    }

    public static String convertIpFromLong2Str(long address) {
        byte[] values = new byte[]{(byte)(address >>> 24 & 0xFFL), (byte)(address >>> 16 & 0xFFL), (byte)(address >>> 8 & 0xFFL), (byte)(address >>> 0 & 0xFFL)};
        return (values[0] & 0xFF) + "." + (values[1] & 0xFF) + "." + (values[2] & 0xFF) + "." + (values[3] & 0xFF);
    }

    public static long convertIpFromStr2Long(String strIp) {
        try {
            if (PolicyUtil.isNull(strIp)) {
                return 0L;
            }
            long[] ip = new long[4];
            int position1 = strIp.indexOf(".");
            int position2 = strIp.indexOf(".", position1 + 1);
            int position3 = strIp.indexOf(".", position2 + 1);
            ip[0] = Long.parseLong(strIp.substring(0, position1));
            ip[1] = Long.parseLong(strIp.substring(position1 + 1, position2));
            ip[2] = Long.parseLong(strIp.substring(position2 + 1, position3));
            ip[3] = Long.parseLong(strIp.substring(position3 + 1));
            return (ip[0] << 24) + (ip[1] << 16) + (ip[2] << 8) + ip[3];
        }
        catch (RuntimeException e) {
            return 0L;
        }
    }

    public static String appendOperNameFromBatchOper(BatchOperationResult batchOperationResult) {
        StringBuffer names = new StringBuffer();
        for (BatchOperation bo : batchOperationResult.getResult()) {
            names.append(bo.getTargetName()).append(',');
        }
        return names.toString();
    }

    public static boolean isNull(String str) {
        return str == null || "".equals(str.trim()) || "null".equals(str);
    }

    public static boolean isNullForVpn(String str) {
        return str == null || "".equals(str.trim());
    }

    public static long convertTimeString(String time) {
        if (time == null || time.length() == 0) {
            return 0L;
        }
        SimpleDateFormat formate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            Date date = formate.parse(time.trim());
            return date.getTime() / 1000L;
        }
        catch (ParseException ex) {
            return 0L;
        }
    }

    public static String convertTime2DayString(long time) {
        if (time <= 0L) {
            return "";
        }
        SimpleDateFormat formate = new SimpleDateFormat("yyyy-MM-dd");
        return formate.format(new Date(time * 1000L));
    }

    public static String convertTimeLong(Long time) {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(time * 1000L));
    }

    public static String convertTime2FormatString(String time) {
        String formateString = "";
        if (!PolicyUtil.isNull(time)) {
            Long longTime = Long.parseLong(time);
            SimpleDateFormat formate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            formateString = formate.format(new Date(longTime * 1000L));
        }
        return formateString;
    }

    public static ServiceContext getServiceContext() {
        ServiceContext context = ServiceContext.getInstance();
        if (null == context) {
            throw new LegoCheckedException(570506L);
        }
        return context;
    }

    public static Object copyProperties(Object source, Object target) {
        if (null == source || null == target) {
            return null;
        }
        BeanUtils.copyProperties((Object)source, (Object)target);
        return target;
    }

    public static String getMaskStartIp(String ip, String mask) {
        if (mask.equals("255.255.255.255")) {
            return ip;
        }
        SubnetUtils subnetUtils = new SubnetUtils(ip, mask);
        String startIp = subnetUtils.getInfo().getLowAddress();
        Long startIpLong = PolicyUtil.convertIpFromStr2Long(startIp);
        String startIpStr = PolicyUtil.convertIpFromLong2Str(startIpLong - 1L);
        return startIpStr;
    }

    public static String getMaskEndIp(String ip, String mask) {
        if (mask.equals("255.255.255.255")) {
            return ip;
        }
        String endIp = new SubnetUtils(ip, mask).getInfo().getHighAddress();
        Long endIpLong = PolicyUtil.convertIpFromStr2Long(endIp);
        String endIpStr = PolicyUtil.convertIpFromLong2Str(endIpLong + 1L);
        return endIpStr;
    }

    public static boolean isReSubmit(HttpSession session, StringBuffer submitToken) {
        StringBuffer token = null;
        if (session.getAttribute("submitToken") != null) {
            token = new StringBuffer((String)session.getAttribute("submitToken"));
        }
        if (null != token && token.toString().equals(submitToken.toString())) {
            return true;
        }
        session.setAttribute("submitToken", (Object)submitToken.toString());
        return false;
    }

    public static List<String> splitIpUtil(String ip, String mask, int maskDigit) {
        if (null == ip || null == mask) {
            return null;
        }
        ArrayList<String> iPList = new ArrayList<String>();
        if (mask.equals("255.255.255.255")) {
            iPList.add(ip);
            return iPList;
        }
        String startIp = PolicyUtil.getMaskStartIp(ip, mask);
        String endIp = PolicyUtil.getMaskEndIp(ip, mask);
        Long slong = PolicyUtil.convertIpFromStr2Long(startIp);
        Long elong = PolicyUtil.convertIpFromStr2Long(endIp);
        ArrayList<String> splitIpList = new ArrayList<String>();
        long flag = (long)Math.pow(2.0, 32 - maskDigit);
        splitIpList.add(startIp);
        boolean isAdd = true;
        while (isAdd) {
            String splitIpString;
            if ((slong = Long.valueOf(slong + flag)) < elong) {
                isAdd = true;
                splitIpString = PolicyUtil.convertIpFromLong2Str(slong);
                splitIpList.add(splitIpString);
                continue;
            }
            if (slong.equals(elong)) {
                isAdd = false;
                splitIpString = PolicyUtil.convertIpFromLong2Str(slong);
                splitIpList.add(splitIpString);
                continue;
            }
            isAdd = false;
        }
        return splitIpList;
    }

    public static String getMask(Integer maskBit) {
        StringBuffer mask = new StringBuffer();
        int a = -1;
        a = 0 == maskBit ? 0 : (a <<= 32 - maskBit);
        mask.append((a & 0xFF000000) >>> 24);
        mask.append('.');
        mask.append((a & 0xFF0000) >> 16);
        mask.append('.');
        mask.append((a & 0xFF00) >> 8);
        mask.append('.');
        mask.append(a & 0xFF);
        return mask.toString();
    }

    public static Integer getMaskBit(String mask) {
        Integer maskBit = 0;
        if (null == mask || "".equals(mask)) {
            return maskBit;
        }
        String[] maskSplit = mask.split("\\.");
        String bmask = "";
        for (int i = 0; i < maskSplit.length; ++i) {
            int maskNum = Integer.parseInt(maskSplit[i]);
            bmask = bmask.concat(Integer.toBinaryString(maskNum));
        }
        maskBit = bmask.lastIndexOf("1") + 1;
        return maskBit;
    }

    public static String stringFilter(String str) {
        String regEx = "[`~!@#$%^&*()+=|{}':;',\\[\\].<>/?~\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c\u3001\uff1f]";
        Pattern p = Pattern.compile(regEx);
        Matcher m = p.matcher(str);
        return m.replaceAll("").trim();
    }

    public static List<String[]> getFinalIpList(List<String[]> includeIpList, List<String[]> excludeIpList) {
        int n = excludeIpList.size();
        for (int m = 0; m < n; ++m) {
            ArrayList newIncludeIpList = new ArrayList();
            Iterator<String[]> i = includeIpList.iterator();
            while (i.hasNext()) {
                String[] includeIp = i.next();
                String[] excludeIp = excludeIpList.get(m);
                newIncludeIpList.addAll(IPUtil.getIpRangeExceptOther((String[])includeIp, (String[])excludeIp));
                i.remove();
            }
            includeIpList.addAll(newIncludeIpList);
        }
        return includeIpList;
    }

    public static List<String[]> cleanUpIpList(List<String[]> ipList) {
        Collections.sort(ipList, new Comparator<String[]>(){

            @Override
            public int compare(String[] ip1, String[] ip2) {
                return IPUtil.compareTo((String)ip1[0], (String)ip2[0]);
            }
        });
        ArrayList<String[]> returnIpList = new ArrayList<String[]>();
        int k = ipList.size();
        for (int i = 0; i < k; ++i) {
            String[] tempIp;
            String[] ip = ipList.get(i);
            String startIp = ip[0];
            String endIp = ip[1];
            while (i < k - 1 && IPUtil.compareTo((String)endIp, (String)IPUtil.ipPrevious((String)(tempIp = ipList.get(i + 1))[0])) >= 0) {
                endIp = IPUtil.compareTo((String)endIp, (String)tempIp[1]) >= 0 ? endIp : tempIp[1];
                ++i;
            }
            String[] returnIp = new String[]{startIp, endIp};
            returnIpList.add(returnIp);
        }
        return returnIpList;
    }

    public static List<Subnet> getSubnetList(long startIp, long endIp) {
        ArrayList<Subnet> list = new ArrayList<Subnet>();
        int mask = 0;
        while (startIp < endIp) {
            if (startIp > NUM_2130706431 && startIp < NUM_2147483648) {
                if (endIp < NUM_2147483648) break;
                startIp = NUM_2147483648;
            }
            long currentip = startIp;
            int temp = Long.numberOfTrailingZeros(startIp);
            mask = 32 - temp;
            if (mask < 8) {
                mask = 8;
            }
            startIp = PolicyUtil.getEndIpByLongStartIpAndIntMask(startIp, mask);
            while (startIp > endIp) {
                if (++mask > 32) {
                    startIp = currentip;
                    mask = 32;
                    continue;
                }
                startIp = PolicyUtil.getEndIpByLongStartIpAndIntMask(currentip, mask);
            }
            Subnet subnet = new Subnet(PolicyUtil.convertIpFromLong2Str(currentip), PolicyUtil.maskInt2String(mask));
            if (!PolicyUtil.isNull(subnet.getIp()) && !PolicyUtil.isNull(subnet.getMask())) {
                list.add(subnet);
            }
            ++startIp;
        }
        if (startIp == endIp) {
            Subnet subnet = new Subnet(PolicyUtil.convertIpFromLong2Str(startIp), PolicyUtil.maskInt2String(32));
            list.add(subnet);
        }
        return list;
    }

    public static long getEndIpByLongStartIpAndIntMask(long start, int msk) {
        String yi = "1";
        String startbin = Long.toBinaryString(start);
        int slength = startbin.length();
        String endbin = startbin.substring(0, msk - 32 + slength);
        for (int i = 0; i < 32 - msk; ++i) {
            endbin = endbin.concat(yi);
        }
        String endIp = PolicyUtil.ipBin2String(endbin, slength);
        return PolicyUtil.convertIpFromStr2Long(endIp);
    }

    public static String maskInt2String(int mask) {
        HashMap<Integer, String> masks = new HashMap<Integer, String>();
        masks.put(32, "255.255.255.255");
        masks.put(31, "255.255.255.254");
        masks.put(30, "255.255.255.252");
        masks.put(29, "255.255.255.248");
        masks.put(28, "255.255.255.240");
        masks.put(27, "255.255.255.224");
        masks.put(26, "255.255.255.192");
        masks.put(25, "255.255.255.128");
        masks.put(24, "255.255.255.0");
        masks.put(23, "255.255.254.0");
        masks.put(22, "255.255.252.0");
        masks.put(21, "255.255.248.0");
        masks.put(20, "255.255.240.0");
        masks.put(19, "255.255.224.0");
        masks.put(18, "255.255.192.0");
        masks.put(17, "255.255.128.0");
        masks.put(16, "255.255.0.0");
        masks.put(15, "255.254.0.0");
        masks.put(14, "255.252.0.0");
        masks.put(13, "255.248.0.0");
        masks.put(12, "255.240.0.0");
        masks.put(11, "255.224.0.0");
        masks.put(10, "255.192.0.0");
        masks.put(9, "255.128.0.0");
        masks.put(8, "255.0.0.0");
        return masks.get(mask) == null ? "" : (String)masks.get(mask);
    }

    public static String ipBin2String(String strIp, int strlength) {
        int[] ip = new int[]{Integer.parseInt(strIp.substring(0, strlength - 24), 2), Integer.parseInt(strIp.substring(strlength - 24, strlength - 16), 2), Integer.parseInt(strIp.substring(strlength - 16, strlength - 8), 2), Integer.parseInt(strIp.substring(strlength - 8, strlength), 2)};
        StringBuffer sb = new StringBuffer("");
        sb.append(String.valueOf(ip[0]));
        sb.append('.');
        sb.append(String.valueOf(ip[1]));
        sb.append('.');
        sb.append(String.valueOf(ip[2]));
        sb.append('.');
        sb.append(String.valueOf(ip[3]));
        return sb.toString();
    }

    public static void checkFilterBeforeAdd(String filterName) {
        if (PolicyUtil.isNull(filterName)) {
            throw new LegoCheckedException(570505L);
        }
        String locationNameRegex = "^(?!\\s*null$)[\\w*]{1,63}$";
        if (filterName.length() > 63 || !filterName.matches(locationNameRegex)) {
            throw new LegoCheckedException(570505L);
        }
    }

    public static boolean isValidDate(String str) {
        boolean convertSuccess = true;
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            format.setLenient(false);
            format.parse(str);
        }
        catch (ParseException e) {
            convertSuccess = false;
        }
        return convertSuccess;
    }
}

