/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.policy.util;

import com.hs.atic.sdk.bis.form.FaultSeverityRuleForm;
import com.hs.atic.sdk.bis.model.FaultSeverityRule;
import com.hs.atic.sdk.bis.service.FaultSeverityRuleService;
import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.atic.sdk.zone.form.ZoneIpForm;
import com.hs.atic.sdk.zone.form.ZoneListIpForm;
import com.hs.atic.sdk.zone.form.ZonePortMapForm;
import com.hs.atic.sdk.zone.service.IImportAndExportService;
import com.hs.atic.sdk.zone.service.IZoneImportAndExportXmlService;
import com.hs.atic.sdk.zone.service.IZoneService;
import com.hs.atic.util.AticUtil;
import com.hs.atic.zone.util.ImportZoneUtil;
import com.hs.lego.cbb.user.sdk.model.User;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.comm.BatchOperation;
import com.hs.lego.core.sdk.comm.BatchOperationResult;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.vsm.common.sdk.util.IPUtil4Atic;
import com.hs.vsm.secservice.ddos.policy.ref.ZoneReferUtil;
import com.hs.vsm.secservice.ddos.policy.util.CSVReader;
import com.hs.vsm.secservice.ddos.policy.util.PolicyUtil;
import com.hs.vsm.secservice.ddos.policy.util.SESubNet;
import com.hs.vsm.secservice.ddos.policy.util.Subnet;
import com.hs.vsm.secservice.ddos.policy.util.ZoneConstants;
import com.hs.vsm.secservice.sdk.module.ddos.Constant;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZonePolicyApplyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneServiceForm;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZonePolicyApplyService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneServiceService;
import com.huawei.atic.secne.common.LocaleUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpSession;
import jxl.Cell;
import jxl.Sheet;
import jxl.Workbook;
import jxl.biff.EmptyCell;
import jxl.write.WritableWorkbook;
import org.apache.commons.io.output.FileWriterWithEncoding;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.net.util.SubnetUtils;

public final class ZoneUtil {
    public static final String IMPORT_TYPE_ZONE = "zone";
    public static final String IMPORT_TYPE_DEVICE = "device";
    public static final String XML_FILE_TYPE = "3C3F786D6C";
    private static final Long NUM_1 = 0x7EFFFFFFL;
    private static final Long NUM_2 = 0x80000000L;
    private static Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);

    private ZoneUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkFileTypeIsXml(File importFilePath) {
        byte[] b = new byte[50];
        FileInputStream is = null;
        try {
            String filetypeHex;
            is = new FileInputStream(importFilePath);
            if (((InputStream)is).read(b) < 0) {
                logger.info((Object)"is.read(b) < 0");
            }
            if ((filetypeHex = String.valueOf(ZoneUtil.bytesToHexString(b))).toUpperCase(Locale.getDefault()).startsWith(XML_FILE_TYPE)) {
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (null != is) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException e) {
                    logger.error((Object)"checkFileTypeIsXml", (Throwable)e);
                }
            }
        }
        return false;
    }

    public static String bytesToHexString(byte[] src) {
        StringBuilder sBuilder = new StringBuilder();
        if (src == null || src.length <= 0) {
            return null;
        }
        for (int i = 0; i < src.length; ++i) {
            int v = src[i] & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                sBuilder.append(0);
            }
            sBuilder.append(hv);
        }
        return sBuilder.toString();
    }

    public static IZoneService getZoneService() {
        IZoneService zoneService = ZoneReferUtil.getZoneService();
        if (zoneService == null) {
            throw new LegoCheckedException(570610L);
        }
        return zoneService;
    }

    public static IImportAndExportService getImportAndExportService() {
        IImportAndExportService importAndExportService = ZoneReferUtil.getImportAndExportService();
        if (importAndExportService == null) {
            throw new LegoCheckedException(570610L);
        }
        return importAndExportService;
    }

    public static IZoneImportAndExportXmlService getZoneImportAndExportService() {
        IZoneImportAndExportXmlService zoneImportAndExportService = ZoneReferUtil.getZoneImportAndExportService();
        if (zoneImportAndExportService == null) {
            throw new LegoCheckedException(570610L);
        }
        return zoneImportAndExportService;
    }

    public static IZonePolicyApplyService getZonePolicyApplyService() {
        IZonePolicyApplyService zonePolicyApplyService = ZoneReferUtil.getZonePolicyService();
        if (zonePolicyApplyService == null) {
            throw new LegoCheckedException(570610L);
        }
        return zonePolicyApplyService;
    }

    public static void validateIpNum(String[] ipAndMaskArray) {
        if (ipAndMaskArray.length > ZoneConstants.IP_NUM_PER_ZONE) {
            throw new LegoCheckedException(570613L);
        }
    }

    public static boolean isSigZoneName(String zoneName) {
        return zoneName.toLowerCase(Locale.ENGLISH).startsWith("sig");
    }

    public static boolean isSigZoneType(String zoneType) {
        return String.valueOf(ZoneConstants.ZONE_TYPE_SIG).equals(zoneType);
    }

    public static boolean isValidZoneName(String zoneName) {
        return !ZoneUtil.isNull(zoneName) && zoneName.toLowerCase(Locale.ENGLISH).matches("^(?!sig.*$)(?!default$)[a-z|A-Z]\\w{0,32}");
    }

    public static boolean isValidZoneDesc(String zoneDesc) {
        return !ZoneUtil.isNull(zoneDesc) && zoneDesc.matches("^(?!null$)[\\w|\u4e00-\u9fa5|\\-|\\!|\\@|\\#|\\$|\\^|\\.|\\+|\\}|\\{]*$");
    }

    public static boolean isValidZoneType(String zoneType) {
        return !ZoneUtil.isNull(zoneType) && (ZoneConstants.ZONE_TYPE_CUSTOME_EN.equals(zoneType) || ZoneConstants.ZONE_TYPE_CUSTOME_ZH.equals(zoneType) || ZoneConstants.ZONE_TYPE_DEFALUT_EN.equals(zoneType) || ZoneConstants.ZONE_TYPE_DEFALUT_ZH.equals(zoneType));
    }

    public static boolean isValidZoneContact(String contact) {
        String contactRegex = "(?!null$)(?![\\s\\S]*[\\s]+null$)(?![\\s\\S]*\\s$)(?!null\\s{1,}[\\s\\S]*$)(?![\\s\\S]*[\\s]+null[\\s]+[\\s\\S]*$)[\\w|\u4e00-\u9fa5|\\ |\\!|\\:|\\;|\\?|\\.|\\,]*$";
        return contact.matches(contactRegex);
    }

    public static boolean isValidZoneTelephone(String telphone) {
        return "".equals(telphone) || telphone.matches("[+]?\\d+\\s?\\d*\\s?-?\\d*$") && telphone.length() <= 30;
    }

    public static boolean isValidZoneMobile(String mobile) {
        return "".equals(mobile) || mobile.matches("^(\\+?\\d+,{1}\\+?\\d+)$|^(\\+?\\d+)$") && mobile.length() <= 50;
    }

    public static boolean isValidZonePost(String post) {
        return post.matches("[0-9]{0,20}$");
    }

    public static boolean validateIndustry(String industry) {
        return AticUtil.isNull((String)industry) || ZoneConstants.INDUSTRY_LIST.contains(industry);
    }

    public static boolean isValidZoneEmail(String email) {
        return "".equals(email) || email.matches("^\\w+([-\\.]\\w+)*@\\w+([-\\.]\\w+)*\\.\\w+([-\\.]\\w+)*$") && email.length() <= 64;
    }

    public static boolean isValidZoneRemarkOrAddr(String value) {
        String zoneRemark = "(?!\\s*null$)(?![\\s\\S]*[\\s]+null$)(?!\\s*null\\s{1}[\\s\\S]*$)(?![\\s\\S]*[\\s]+null[\\s]+[\\s\\S]*$)[\u4e00-\u9fa5|\\\u3002|\\\uff0c|\\\uff1a|\\\uff1b|\\\uff01|\\\uff1f|\\\u3001|\\\u300a|\\\u300b|\\\u201c|\\\u201d|\\\u2018|\\\u2019|\\\uffe5|\\\uff08|\\\uff09|\\\u3010|\\\u3011|\\\u2026|\\ |\\w|\\!|\\:|\\;|\\?|\\.|\\,|\\-|\\r|\\n]*$";
        return value.matches(zoneRemark) && value.length() <= 255;
    }

    public static boolean isDefaultZone(String zoneType) {
        return ZoneConstants.ZONE_TYPE_DEFALUT_EN.equals(zoneType) || ZoneConstants.ZONE_TYPE_DEFALUT_ZH.equals(zoneType);
    }

    public static boolean isValidLimitThreshold(String limit) {
        return "".equals(limit) || limit.matches("^[0-9]*$") && limit.length() <= 5;
    }

    public static Cell[] fillCell(Cell[] cell) {
        if (cell.length == 12) {
            return cell;
        }
        Cell[] cellToFill = new Cell[12];
        System.arraycopy(cell, 0, cellToFill, 0, cell.length);
        for (int i = cell.length; i < 12; ++i) {
            cellToFill[i] = new EmptyCell(0, 0);
        }
        return cellToFill;
    }

    public static String[] generateTitles() {
        return new String[]{ZoneUtil.getText("atic.user.export.name"), ZoneUtil.getText("atic.user.export.desc"), ZoneUtil.getText("atic.user.export.type"), ZoneUtil.getText("atic.user.contact"), ZoneUtil.getText("atic.user.telephone"), ZoneUtil.getText("atic.user.mobile.phone"), ZoneUtil.getText("atic.user.zip"), ZoneUtil.getText("atic.user.email"), ZoneUtil.getText("atic.user.address"), ZoneUtil.getText("atic.user.remark"), ZoneUtil.getText("atic.user.export.user.ip")};
    }

    public static boolean isValidFormat(Sheet sheet, String[] title) {
        if (sheet.getColumns() != 12) {
            return false;
        }
        Cell[] cell = sheet.getRow(2);
        if (!title[0].equalsIgnoreCase(cell[0].getContents().trim())) {
            return false;
        }
        if (!title[1].equalsIgnoreCase(cell[1].getContents().trim())) {
            return false;
        }
        if (!title[2].equalsIgnoreCase(cell[2].getContents().trim())) {
            return false;
        }
        if (!title[3].equalsIgnoreCase(cell[3].getContents().trim())) {
            return false;
        }
        if (!title[4].equalsIgnoreCase(cell[4].getContents().trim())) {
            return false;
        }
        if (!title[5].equalsIgnoreCase(cell[5].getContents().trim())) {
            return false;
        }
        if (!title[6].equalsIgnoreCase(cell[6].getContents().trim())) {
            return false;
        }
        if (!title[7].equalsIgnoreCase(cell[7].getContents().trim())) {
            return false;
        }
        if (!title[8].equalsIgnoreCase(cell[8].getContents().trim())) {
            return false;
        }
        if (!title[9].equalsIgnoreCase(cell[9].getContents().trim())) {
            return false;
        }
        return title[10].equalsIgnoreCase(cell[10].getContents().trim());
    }

    public static String appendOperNameFromBatchOper(BatchOperationResult batchOperationResult) {
        StringBuffer names = new StringBuffer();
        for (BatchOperation bo : batchOperationResult.getResult()) {
            names.append(bo.getTargetName()).append(',');
        }
        return names.toString();
    }

    public static boolean isValidIp(String ip) {
        return true;
    }

    public static boolean isNull(String str) {
        return str == null || "".equals(str.trim()) || "null".equalsIgnoreCase(str);
    }

    public static String getText(String i18n) {
        return LocaleUtil.INSTANCE.getText(i18n);
    }

    public static ServiceContext getServiceContext() {
        ServiceContext context = ServiceContext.getInstance();
        if (null == context) {
            throw new LegoCheckedException(570610L);
        }
        return context;
    }

    public static String getMaskStartIp(String ip, String mask) {
        if ("255.255.255.255".equals(mask)) {
            return ip;
        }
        SubnetUtils subnetUtils = new SubnetUtils(ip, mask);
        String startIp = subnetUtils.getInfo().getLowAddress();
        Long startIpLong = ZoneUtil.convertIpFromStr2Long(startIp);
        String startIpStr = ZoneUtil.convertIpFromLong2Str(startIpLong - 1L);
        return startIpStr;
    }

    public static String getMaskEndIp(String ip, String mask) {
        if ("255.255.255.255".equals(mask)) {
            return ip;
        }
        String endIp = new SubnetUtils(ip, mask).getInfo().getHighAddress();
        Long endIpLong = ZoneUtil.convertIpFromStr2Long(endIp);
        String endIpStr = ZoneUtil.convertIpFromLong2Str(endIpLong + 1L);
        return endIpStr;
    }

    public static String convertIpFromLong2Str(long address) {
        byte[] values = new byte[]{(byte)(address >>> 24 & 0xFFL), (byte)(address >>> 16 & 0xFFL), (byte)(address >>> 8 & 0xFFL), (byte)(address >>> 0 & 0xFFL)};
        return (values[0] & 0xFF) + "." + (values[1] & 0xFF) + "." + (values[2] & 0xFF) + "." + (values[3] & 0xFF);
    }

    public static long convertIpFromStr2Long(String strIp) {
        if (ZoneUtil.isNull(strIp)) {
            return 0L;
        }
        long[] ip = new long[4];
        int position1 = strIp.indexOf(46);
        int position2 = strIp.indexOf(46, position1 + 1);
        int position3 = strIp.indexOf(46, position2 + 1);
        ip[0] = Long.parseLong(strIp.substring(0, position1));
        ip[1] = Long.parseLong(strIp.substring(position1 + 1, position2));
        ip[2] = Long.parseLong(strIp.substring(position2 + 1, position3));
        ip[3] = Long.parseLong(strIp.substring(position3 + 1));
        return (ip[0] << 24) + (ip[1] << 16) + (ip[2] << 8) + ip[3];
    }

    public static boolean isIpValid(boolean is1stByte, int ipInt) {
        return is1stByte ? ipInt != 127 && ipInt >= 1 && ipInt <= 223 : ipInt <= 255 && ipInt >= 0;
    }

    public static boolean isReSubmit(HttpSession session, StringBuffer submitToken) {
        StringBuffer token = null;
        if (session.getAttribute("submitToken") != null) {
            token = new StringBuffer((String)session.getAttribute("submitToken"));
        }
        if (null != token && token.toString().equals(submitToken.toString())) {
            return true;
        }
        session.setAttribute("submitToken", (Object)submitToken.toString());
        return false;
    }

    public static String stringFilter(String str) {
        String regEx = "[`~!@#$%^&*()+=|{}':;',\\[\\].<>/?~\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c\u3001\uff1f]";
        Pattern p = Pattern.compile(regEx);
        Matcher m = p.matcher(str);
        return m.replaceAll("").trim();
    }

    public static IZoneServiceService getZoneServiceService() {
        IZoneServiceService zoneServiceService = ZoneReferUtil.getZoneServiceService();
        if (zoneServiceService == null) {
            throw new LegoCheckedException(570610L);
        }
        return zoneServiceService;
    }

    public static List<Subnet> getSubnetList(long startIp, long endIp) {
        ArrayList<Subnet> list = new ArrayList<Subnet>();
        int mask = 0;
        while (startIp < endIp) {
            if (startIp > NUM_1 && startIp < NUM_2) {
                if (endIp < NUM_2) break;
                startIp = NUM_2;
            }
            long currentip = startIp;
            int temp = Long.numberOfTrailingZeros(startIp);
            mask = 32 - temp;
            if (mask < 8) {
                mask = 8;
            }
            startIp = ZoneUtil.getEndIpByLongStartIpAndIntMask(startIp, mask);
            while (startIp > endIp) {
                if (++mask > 32) {
                    startIp = currentip;
                    mask = 32;
                    continue;
                }
                startIp = ZoneUtil.getEndIpByLongStartIpAndIntMask(currentip, mask);
            }
            Subnet subnet = new Subnet(ZoneUtil.convertIpFromLong2Str(currentip), ZoneUtil.maskInt2String(mask));
            if (!ZoneUtil.isNull(subnet.getIp()) && !ZoneUtil.isNull(subnet.getMask())) {
                list.add(subnet);
            }
            ++startIp;
        }
        if (startIp == endIp) {
            Subnet subnet = new Subnet(ZoneUtil.convertIpFromLong2Str(startIp), ZoneUtil.maskInt2String(32));
            list.add(subnet);
        }
        return list;
    }

    public static String maskInt2String(int mask) {
        HashMap<Integer, String> masks = new HashMap<Integer, String>();
        masks.put(32, "255.255.255.255");
        masks.put(31, "255.255.255.254");
        masks.put(30, "255.255.255.252");
        masks.put(29, "255.255.255.248");
        masks.put(28, "255.255.255.240");
        masks.put(27, "255.255.255.224");
        masks.put(26, "255.255.255.192");
        masks.put(25, "255.255.255.128");
        masks.put(24, "255.255.255.0");
        masks.put(23, "255.255.254.0");
        masks.put(22, "255.255.252.0");
        masks.put(21, "255.255.248.0");
        masks.put(20, "255.255.240.0");
        masks.put(19, "255.255.224.0");
        masks.put(18, "255.255.192.0");
        masks.put(17, "255.255.128.0");
        masks.put(16, "255.255.0.0");
        masks.put(15, "255.254.0.0");
        masks.put(14, "255.252.0.0");
        masks.put(13, "255.248.0.0");
        masks.put(12, "255.240.0.0");
        masks.put(11, "255.224.0.0");
        masks.put(10, "255.192.0.0");
        masks.put(9, "255.128.0.0");
        masks.put(8, "255.0.0.0");
        return masks.get(mask) == null ? "" : (String)masks.get(mask);
    }

    public static long getEndIpByLongStartIpAndIntMask(long start, int msk) {
        String one = "1";
        String startbin = Long.toBinaryString(start);
        int slength = startbin.length();
        String endbin = startbin.substring(0, msk - 32 + slength);
        for (int i = 0; i < 32 - msk; ++i) {
            endbin = endbin.concat(one);
        }
        String endIp = ZoneUtil.ipBin2String(endbin, slength);
        return ZoneUtil.convertIpFromStr2Long(endIp);
    }

    public static String ipBin2String(String strIp, int strlength) {
        int[] ip = new int[]{Integer.parseInt(strIp.substring(0, strlength - 24), 2), Integer.parseInt(strIp.substring(strlength - 24, strlength - 16), 2), Integer.parseInt(strIp.substring(strlength - 16, strlength - 8), 2), Integer.parseInt(strIp.substring(strlength - 8, strlength), 2)};
        StringBuffer sb = new StringBuffer("");
        sb.append(String.valueOf(ip[0]));
        sb.append('.');
        sb.append(String.valueOf(ip[1]));
        sb.append('.');
        sb.append(String.valueOf(ip[2]));
        sb.append('.');
        sb.append(String.valueOf(ip[3]));
        return sb.toString();
    }

    public static List<SESubNet> getFinalSESubNetList(List<SESubNet> regularSubNetList, List<SESubNet> excludeSubNetList) {
        int n = excludeSubNetList.size();
        for (int m = 0; m < n; ++m) {
            ArrayList<SESubNet> newAddregularSubNetList = new ArrayList<SESubNet>();
            Iterator<SESubNet> i = regularSubNetList.iterator();
            while (i.hasNext()) {
                SESubNet newSESubNet;
                SESubNet regularSubNet = i.next();
                SESubNet excludeSubNet = excludeSubNetList.get(m);
                long regularStartip = regularSubNet.getStartIp();
                long regularEndip = regularSubNet.getEndIp();
                long excludeStartip = excludeSubNet.getStartIp();
                long excludeEndip = excludeSubNet.getEndIp();
                if (regularStartip > excludeEndip || regularEndip < excludeStartip) continue;
                if (regularStartip > excludeStartip) {
                    if (regularEndip <= excludeEndip) {
                        i.remove();
                        continue;
                    }
                    i.remove();
                    newSESubNet = new SESubNet(excludeEndip + 1L, regularEndip, 0);
                    newAddregularSubNetList.add(newSESubNet);
                    continue;
                }
                if (regularStartip < excludeStartip) {
                    if (regularEndip > excludeEndip) {
                        i.remove();
                        SESubNet newSESubNetA = new SESubNet(regularStartip, excludeStartip - 1L, 0);
                        SESubNet newSESubNetB = new SESubNet(excludeEndip + 1L, regularEndip, 0);
                        newAddregularSubNetList.add(newSESubNetA);
                        newAddregularSubNetList.add(newSESubNetB);
                        continue;
                    }
                    i.remove();
                    newSESubNet = new SESubNet(regularStartip, excludeStartip - 1L, 0);
                    newAddregularSubNetList.add(newSESubNet);
                    continue;
                }
                if (regularEndip > excludeEndip) {
                    i.remove();
                    newSESubNet = new SESubNet(excludeEndip + 1L, regularEndip, 0);
                    newAddregularSubNetList.add(newSESubNet);
                    continue;
                }
                i.remove();
            }
            regularSubNetList.addAll(newAddregularSubNetList);
        }
        regularSubNetList = ZoneUtil.uniteByRegularAndExcludeIp(regularSubNetList);
        return regularSubNetList;
    }

    public static boolean isParseInt(String intString) {
        try {
            Integer.parseInt(intString);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public static List<SESubNet> uniteByRegularAndExcludeIp(List<SESubNet> seSubNetList) {
        Collections.sort(seSubNetList, new Comparator<SESubNet>(){

            @Override
            public int compare(SESubNet seSubNet1, SESubNet seSubNet2) {
                return seSubNet1.getStartIp().compareTo(seSubNet2.getStartIp());
            }
        });
        ArrayList<SESubNet> returnSeSubNetList = new ArrayList<SESubNet>();
        int k = seSubNetList.size();
        for (int i = 0; i < k; ++i) {
            SESubNet seSubNet = seSubNetList.get(i);
            Long startIp = seSubNet.getStartIp();
            Long endIp = seSubNet.getEndIp();
            while (i < k - 1) {
                SESubNet seSubNetNext = seSubNetList.get(i + 1);
                if (endIp < seSubNetNext.getStartIp() - 1L) break;
                endIp = endIp > seSubNetNext.getEndIp() ? endIp : seSubNetNext.getEndIp();
                ++i;
            }
            SESubNet returnSESubNet = new SESubNet(startIp, endIp, 0);
            returnSeSubNetList.add(returnSESubNet);
        }
        return returnSeSubNetList;
    }

    public static boolean isIp(String ipString) {
        if (ZoneUtil.isNull(ipString)) {
            return false;
        }
        String[] subIps = ipString.split("\\.");
        if (subIps.length != 4) {
            return false;
        }
        int j = subIps.length;
        for (int i = 0; i < j; ++i) {
            if (ZoneUtil.isParseInt(subIps[i])) {
                int subIpInt = Integer.parseInt(subIps[i]);
                if (subIpInt >= 0 && subIpInt <= 255) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public static boolean isCreateFolderSuccess(String filePath) {
        File file = new File(filePath);
        if (!file.exists()) {
            return file.mkdir();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(String fromPath, String toPath) throws IOException {
        BufferedInputStream bis = null;
        BufferedOutputStream bos = null;
        FileInputStream fileInput = null;
        FileOutputStream fileOutput = null;
        try {
            int bytesRead;
            fileInput = new FileInputStream(fromPath);
            fileOutput = new FileOutputStream(toPath);
            bis = new BufferedInputStream(fileInput);
            bos = new BufferedOutputStream(fileOutput);
            byte[] buff = new byte[0x100000];
            while (-1 != (bytesRead = bis.read(buff, 0, buff.length))) {
                bos.write(buff, 0, bytesRead);
            }
        }
        catch (Throwable throwable) {
            ZoneUtil.closeFileOutputStream(fileOutput);
            ZoneUtil.closeFileInputStream(fileInput);
            ZoneUtil.closeBufferedInputStream(bis);
            ZoneUtil.closeBufferedOutputStream(bos);
            throw throwable;
        }
        ZoneUtil.closeFileOutputStream(fileOutput);
        ZoneUtil.closeFileInputStream(fileInput);
        ZoneUtil.closeBufferedInputStream(bis);
        ZoneUtil.closeBufferedOutputStream(bos);
    }

    private static void closeInStream(CSVReader inStream) {
        if (null != inStream) {
            try {
                inStream.csvClose();
            }
            catch (Exception e) {
                logger.error((Object)"close inputStream error", (Throwable)e);
            }
            finally {
                inStream = null;
            }
        }
    }

    private static void closeOutStream(BufferedWriter outStream) {
        if (null != outStream) {
            try {
                outStream.close();
            }
            catch (Exception e) {
                logger.error((Object)"close outputStream error", (Throwable)e);
            }
            finally {
                outStream = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyCsvFile(String fromPath, String toPath) throws IOException {
        CSVReader reader = new CSVReader(fromPath);
        BufferedWriter fw = new BufferedWriter((Writer)new FileWriterWithEncoding(toPath, System.getProperty("file.encoding")));
        try {
            List<String> ipDomains = reader.getList();
            for (String line : ipDomains) {
                fw.write(line);
            }
        }
        finally {
            ZoneUtil.closeOutStream(fw);
            ZoneUtil.closeInStream(reader);
        }
    }

    public static void closeBufferedInputStream(BufferedInputStream bufferedInputStream) {
        if (bufferedInputStream != null) {
            try {
                bufferedInputStream.close();
            }
            catch (IOException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            finally {
                bufferedInputStream = null;
            }
        }
    }

    public static void closeBufferedOutputStream(BufferedOutputStream bufferedOutputStream) {
        if (bufferedOutputStream != null) {
            try {
                bufferedOutputStream.close();
            }
            catch (IOException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            finally {
                bufferedOutputStream = null;
            }
        }
    }

    public static void closeFileInputStream(FileInputStream fileInputStream) {
        if (null != fileInputStream) {
            try {
                fileInputStream.close();
            }
            catch (IOException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            finally {
                fileInputStream = null;
            }
        }
    }

    public static void closeFileOutputStream(FileOutputStream fileOutputStream) {
        if (null != fileOutputStream) {
            try {
                fileOutputStream.close();
            }
            catch (IOException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            finally {
                fileOutputStream = null;
            }
        }
    }

    public static void closeWorkbook(Workbook workbook) {
        if (null != workbook) {
            try {
                workbook.close();
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            finally {
                workbook = null;
            }
        }
    }

    public static void closeWritableWorkbook(WritableWorkbook writableWorkbook) {
        if (null != writableWorkbook) {
            try {
                writableWorkbook.close();
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            finally {
                writableWorkbook = null;
            }
        }
    }

    public static void closeOutputStream(OutputStream outputStream) {
        if (outputStream != null) {
            try {
                outputStream.close();
            }
            catch (IOException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            finally {
                outputStream = null;
            }
        }
    }

    public static void closeInputStream(InputStream inputStream) {
        if (null != inputStream) {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            finally {
                inputStream = null;
            }
        }
    }

    public static String getEndIpByIpAndIntMask(String ip, int mask) {
        String stringMask = ZoneUtil.maskInt2String(mask);
        return ZoneUtil.getMaskEndIp(ip, stringMask);
    }

    public static String getStartIpByIpAndIntMask(String ip, int mask) {
        String stringMask = ZoneUtil.maskInt2String(mask);
        return ZoneUtil.getMaskStartIp(ip, stringMask);
    }

    public static List<ZoneIpForm> getZoneIpFormList(List<ZoneListIpForm> zoneListIpFormList) {
        ArrayList<ZoneIpForm> zoneIpFormList = new ArrayList<ZoneIpForm>();
        if (zoneListIpFormList != null && !zoneListIpFormList.isEmpty()) {
            ArrayList<String[]> includeIpv4List = new ArrayList<String[]>();
            ArrayList<String[]> includeIpv6List = new ArrayList<String[]>();
            ArrayList<String[]> excludeIpv4List = new ArrayList<String[]>();
            ArrayList<String[]> excludeIpv6List = new ArrayList<String[]>();
            for (ZoneListIpForm zoneListIpForm : zoneListIpFormList) {
                String startIp = zoneListIpForm.getStartIp();
                String endIp = zoneListIpForm.getEndIp();
                String[] subnetRange = new String[]{startIp, endIp};
                if (zoneListIpForm.getIpType() == 1) {
                    if (IPUtil.isIpv4((String)startIp)) {
                        excludeIpv4List.add(subnetRange);
                        continue;
                    }
                    excludeIpv6List.add(subnetRange);
                    continue;
                }
                if (IPUtil.isIpv4((String)startIp)) {
                    includeIpv4List.add(subnetRange);
                    continue;
                }
                includeIpv6List.add(subnetRange);
            }
            List<String[]> finalIpv4List = PolicyUtil.getFinalIpList(includeIpv4List, excludeIpv4List);
            List<String[]> finalIpv6List = PolicyUtil.getFinalIpList(includeIpv6List, excludeIpv6List);
            ArrayList<String[]> finalIpList = new ArrayList<String[]>();
            finalIpList.addAll(finalIpv4List);
            finalIpList.addAll(finalIpv6List);
            for (String[] ip : finalIpList) {
                try {
                    String startIp = ip[0];
                    String endIp = ip[1];
                    String[] tempIpArray = IPUtil.getNetworkSegment((String)startIp, (String)endIp);
                    for (int i = 0; i < tempIpArray.length; ++i) {
                        String ipAndMask = tempIpArray[i];
                        String[] temp = ipAndMask.split("/");
                        String zoneIp = temp[0];
                        String mask = temp[1];
                        ZoneIpForm zoneIpForm = new ZoneIpForm();
                        zoneIpForm.setZoneIp(zoneIp);
                        zoneIpForm.setMask(Integer.valueOf(mask));
                        zoneIpForm.setStartIp(startIp);
                        zoneIpForm.setEndIp(endIp);
                        zoneIpFormList.add(zoneIpForm);
                    }
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        return zoneIpFormList;
    }

    public static Long saveZoneInfoAndIp(Object[] params) {
        Long zoneId = (Long)params[0];
        Log codeLogger = (Log)params[1];
        List zoneListIpFormList = (List)params[2];
        List zoneListPortMapFormList = (List)params[6];
        ZoneInfoForm zoneInfoForm = (ZoneInfoForm)params[3];
        Long userId = (Long)params[4];
        Log timeLogger = (Log)params[5];
        long startTime = System.currentTimeMillis();
        timeLogger.info((Object)("The saveZoneInfoAndIp() start time is " + startTime));
        boolean isAdd = zoneId == null;
        IZoneService zoneService = ZoneReferUtil.getZoneService();
        if (null != zoneListIpFormList && !zoneListIpFormList.isEmpty()) {
            ZoneUtil.getIpRange(zoneListIpFormList);
            List<ZoneIpForm> zifList = ZoneUtil.getZoneIpFormList(zoneListIpFormList);
            zoneInfoForm.setZoneIpFormList(zifList);
            if (null != zoneListPortMapFormList && !zoneListPortMapFormList.isEmpty()) {
                zoneInfoForm.setZoneDoPortMapFormLis(zoneListPortMapFormList);
            }
        }
        if (AticUtil.isNull((String)zoneInfoForm.getIndustry())) {
            zoneInfoForm.setIndustry("Gaming");
        }
        zoneId = zoneService.saveZone(zoneInfoForm, userId, isAdd);
        codeLogger.info((Object)(isAdd ? "add zone : " : "modify zone : " + AticUtil.getcleanedMessage((String)zoneInfoForm.getZoneName())));
        timeLogger.info((Object)("The saveZoneInfoAndIp() used times is " + (System.currentTimeMillis() - startTime) + "ms"));
        return zoneId;
    }

    private static void getIpRange(List<ZoneListIpForm> zoneListIpFormList) {
        for (ZoneListIpForm listIpForm : zoneListIpFormList) {
            if (listIpForm.getMaskType() != 0) continue;
            String[] srcIpRange = IPUtil.getSubnetRange((String)listIpForm.getZoneIp(), (int)listIpForm.getIntMask());
            listIpForm.setStartIp(srcIpRange[0]);
            listIpForm.setEndIp(srcIpRange[1]);
        }
    }

    public static boolean validateIpAddress(Object[] params) {
        boolean isAdd;
        Long zoneId = (Long)params[0];
        List zoneListIpFormList = (List)params[1];
        ZoneInfoForm zoneInfoForm = (ZoneInfoForm)params[2];
        List frontOperationList = (List)params[3];
        List<ZonePortMapForm> zonePortMapFormList = zoneInfoForm.getZonePortMapFormList();
        Log codeLogger = (Log)params[4];
        String zoneString = (String)params[5];
        boolean bl = isAdd = zoneId == null;
        if (zoneListIpFormList != null && !zoneListIpFormList.isEmpty()) {
            ArrayList<ZoneListIpForm> temList = new ArrayList<ZoneListIpForm>();
            ArrayList<ZoneListIpForm> needZoneIpFormList = new ArrayList<ZoneListIpForm>();
            for (ZoneListIpForm zoneListIpForm : zoneListIpFormList) {
                if (AticUtil.isNull((String)zoneListIpForm.getZoneIp()) && AticUtil.isNull((String)zoneListIpForm.getStartIp()) && AticUtil.isNull((String)zoneListIpForm.getEndIp())) {
                    temList.add(zoneListIpForm);
                }
                if (zoneListIpForm.getIpType() != 0 && zoneListIpForm.getIpType() != 1) {
                    codeLogger.info((Object)("IP type is out of range " + zoneListIpForm.getIpType()));
                    ImportZoneUtil.recordErrorMessg(zoneString + zoneInfoForm.getZoneDesc() + "/" + zoneListIpForm.getIpType(), 572026L, frontOperationList);
                    return false;
                }
                if (zoneListIpForm.getMaskType() != 0 && zoneListIpForm.getMaskType() != 1) {
                    codeLogger.info((Object)("IP address creation way out of range.maskType=" + zoneListIpForm.getMaskType()));
                    ImportZoneUtil.recordErrorMessg(zoneString + zoneInfoForm.getZoneDesc() + "/" + zoneListIpForm.getMaskType(), 572027L, frontOperationList);
                    return false;
                }
                Map<String, Boolean> ipResultMap = ImportZoneUtil.getIpResultMap();
                if (AticUtil.isNull((String)zoneListIpForm.getZoneIp()) && (AticUtil.isNull((String)zoneListIpForm.getStartIp()) || AticUtil.isNull((String)zoneListIpForm.getEndIp()))) continue;
                if (zoneListIpForm.getMaskType() != 1 && zoneListIpForm.getIntMask() < 8) {
                    temList.add(zoneListIpForm);
                    codeLogger.info((Object)("save zoneInfoForm ipAddress error " + zoneListIpForm.getIntMask()));
                    ImportZoneUtil.recordErrorMessg(zoneString + zoneInfoForm.getZoneDesc() + "/" + zoneListIpForm.getZoneIp() + "/" + zoneListIpForm.getIntMask(), 572012L, frontOperationList);
                    continue;
                }
                String startIp = "";
                String endIp = "";
                if (zoneListIpForm.getMaskType() != 1) {
                    if (!ImportZoneUtil.validateIpAddr(zoneListIpForm.getZoneIp() + "/" + zoneListIpForm.getIntMask(), ipResultMap, true)) {
                        if (ipResultMap.get("isZero").booleanValue()) {
                            temList.add(zoneListIpForm);
                            codeLogger.error((Object)("The IP is zero.IP =" + zoneListIpForm.getZoneIp()));
                            ImportZoneUtil.recordErrorMessg(zoneString + zoneInfoForm.getZoneDesc() + "/" + zoneListIpForm.getZoneIp(), 571986L, frontOperationList);
                            continue;
                        }
                        if (ipResultMap.get("ipAddrError").booleanValue()) {
                            temList.add(zoneListIpForm);
                            codeLogger.error((Object)("Iip format wrong.IP= " + zoneListIpForm.getZoneIp()));
                            ImportZoneUtil.recordErrorMessg(zoneString + zoneInfoForm.getZoneDesc() + "/" + zoneListIpForm.getZoneIp(), 571986L, frontOperationList);
                            continue;
                        }
                        if (ipResultMap.get("maskError").booleanValue()) {
                            temList.add(zoneListIpForm);
                            codeLogger.error((Object)("IP mask error. The mak =  " + zoneListIpForm.getIntMask()));
                            ImportZoneUtil.recordErrorMessg(zoneString + zoneInfoForm.getZoneDesc() + "/" + zoneListIpForm.getZoneIp() + "/" + zoneListIpForm.getIntMask(), 571987L, frontOperationList);
                            continue;
                        }
                    }
                    startIp = ZoneReferUtil.getMaskStartIp(zoneListIpForm.getZoneIp(), zoneListIpForm.getIntMask());
                    endIp = ZoneReferUtil.getMaskEndIp(zoneListIpForm.getZoneIp(), zoneListIpForm.getIntMask());
                } else {
                    if (!ImportZoneUtil.validateIpAddr(zoneListIpForm.getStartIp() + "-" + zoneListIpForm.getEndIp(), ipResultMap, true)) {
                        if (ipResultMap.get("isZero").booleanValue()) {
                            temList.add(zoneListIpForm);
                            codeLogger.error((Object)("The IP is zero.IP =" + zoneListIpForm.getStartIp() + "-" + zoneListIpForm.getEndIp()));
                            ImportZoneUtil.recordErrorMessg(zoneString + zoneInfoForm.getZoneDesc() + "/" + zoneListIpForm.getZoneIp(), 571986L, frontOperationList);
                            continue;
                        }
                        if (ipResultMap.get("rangeError").booleanValue()) {
                            temList.add(zoneListIpForm);
                            codeLogger.error((Object)("The ip range error.The ipRange=" + zoneListIpForm.getStartIp() + "-" + zoneListIpForm.getEndIp()));
                            ImportZoneUtil.recordErrorMessg(zoneString + zoneInfoForm.getZoneDesc() + "/" + zoneListIpForm.getStartIp() + "-" + zoneListIpForm.getEndIp(), 572021L, frontOperationList);
                            continue;
                        }
                        if (ipResultMap.get("ipAddrError").booleanValue()) {
                            temList.add(zoneListIpForm);
                            codeLogger.error((Object)("Iip format wrong.IP= " + zoneListIpForm.getStartIp() + "-" + zoneListIpForm.getEndIp()));
                            ImportZoneUtil.recordErrorMessg(zoneString + zoneInfoForm.getZoneDesc() + "/" + zoneListIpForm.getStartIp() + "-" + zoneListIpForm.getEndIp(), 571986L, frontOperationList);
                            continue;
                        }
                    }
                    startIp = zoneListIpForm.getStartIp();
                    endIp = zoneListIpForm.getEndIp();
                }
                zoneListIpForm.setStartIp(startIp);
                zoneListIpForm.setEndIp(endIp);
                needZoneIpFormList.add(zoneListIpForm);
            }
            if (!needZoneIpFormList.isEmpty()) {
                List<ZoneIpForm> zifList = ZoneUtil.getZoneIpFormList(needZoneIpFormList);
                IZoneService zoneService = ZoneReferUtil.getZoneService();
                for (ZoneIpForm zoneIpForm : zifList) {
                    List<ZoneIpForm> repeatList;
                    String startIp = ZoneReferUtil.getMaskStartIp(zoneIpForm.getZoneIp(), zoneIpForm.getMask());
                    String endIp = ZoneReferUtil.getMaskEndIp(zoneIpForm.getZoneIp(), zoneIpForm.getMask());
                    if (zoneService == null) {
                        zoneService = ZoneReferUtil.getZoneService();
                    }
                    if (null == (repeatList = zoneService.getRepeatIpWithOtherZone(zoneId == null ? 0L : zoneId, startIp, endIp, isAdd)) || repeatList.isEmpty()) continue;
                    ZoneIpForm zoneIpFormRepeat = repeatList.get(0);
                    startIp = ZoneUtil.getRepeatStartIp(startIp, zoneIpFormRepeat);
                    ZoneListIpForm zoneListIpForm01 = ZoneUtil.getRepeatZoneListIpForm(needZoneIpFormList, startIp);
                    temList.add(zoneListIpForm01);
                    ZoneUtil.checkZonePortMapIsRepeat(zoneListIpForm01, zonePortMapFormList);
                    codeLogger.info((Object)("save zoneInfoForm ipAddress error " + zoneListIpForm01.getIntMask()));
                    ImportZoneUtil.recordErrorMessg(zoneString + zoneInfoForm.getZoneDesc() + "/" + ZoneUtil.getResponseResultStr(zoneListIpForm01), 572013L, frontOperationList);
                }
            }
            zoneListIpFormList.removeAll(temList);
            zoneInfoForm.setZoneListIpFormList(zoneListIpFormList);
            zoneInfoForm.setZonePortMapFormList(zonePortMapFormList);
        }
        return true;
    }

    private static String getRepeatStartIp(String startIp, ZoneIpForm zoneIpFormRepeat) {
        String startIpTemp = ZoneReferUtil.getMaskStartIp(zoneIpFormRepeat.getZoneIp(), zoneIpFormRepeat.getMask());
        return IPUtil.compareTo((String)startIp, (String)startIpTemp) >= 0 ? startIp : startIpTemp;
    }

    private static ZoneListIpForm getRepeatZoneListIpForm(List<ZoneListIpForm> zoneListIpFormList, String startIp) {
        if (zoneListIpFormList != null && !zoneListIpFormList.isEmpty()) {
            for (ZoneListIpForm zoneListIpForm01 : zoneListIpFormList) {
                if (IPUtil.isIpv4((String)startIp) && IPUtil.isIpv6((String)zoneListIpForm01.getStartIp()) || IPUtil.isIpv6((String)startIp) && IPUtil.isIpv4((String)zoneListIpForm01.getStartIp()) || IPUtil.isIpv4((String)startIp) && IPUtil.isIpv6((String)zoneListIpForm01.getEndIp()) || IPUtil.isIpv6((String)startIp) && IPUtil.isIpv4((String)zoneListIpForm01.getEndIp()) || IPUtil.compareTo((String)startIp, (String)zoneListIpForm01.getStartIp()) < 0 || IPUtil.compareTo((String)startIp, (String)zoneListIpForm01.getEndIp()) > 0 || zoneListIpForm01.getIpType() == 1) continue;
                return zoneListIpForm01;
            }
        }
        return null;
    }

    private static void checkZonePortMapIsRepeat(ZoneListIpForm zoneListIpForm, List<ZonePortMapForm> zoneListIpFormList) {
        Iterator<ZonePortMapForm> it = zoneListIpFormList.iterator();
        while (it.hasNext()) {
            ZonePortMapForm tmp = it.next();
            String[] ipRange = new String[]{zoneListIpForm.getStartIp(), zoneListIpForm.getEndIp()};
            String[] srcIpRange = new String[]{tmp.getIpAddress(), tmp.getIpAddress()};
            if (!IPUtil4Atic.isCrossIpRange((String[])ipRange, (String[])srcIpRange)) continue;
            it.remove();
        }
    }

    private static String getResponseResultStr(ZoneListIpForm zoneListIpForm) {
        String responseResultStr = "";
        if (zoneListIpForm != null) {
            switch (zoneListIpForm.getMaskType()) {
                case 0: {
                    responseResultStr = zoneListIpForm.getZoneIp() + "/" + zoneListIpForm.getIntMask();
                    break;
                }
                case 1: {
                    responseResultStr = zoneListIpForm.getStartIp() + "-" + zoneListIpForm.getEndIp();
                    break;
                }
                default: {
                    responseResultStr = "";
                }
            }
        }
        return responseResultStr;
    }

    private static boolean paramsNotValid(ZoneInfoForm zoneInfoForm) {
        return zoneInfoForm == null || null == zoneInfoForm.getZoneName() || "".equals(zoneInfoForm.getZoneName()) || null == zoneInfoForm.getZoneDesc() || "".equals(zoneInfoForm.getZoneDesc());
    }

    public static boolean validateZoneInfo(Log codeLogger, ZoneInfoForm zoneInfoForm, List<BatchOperation> frontOperationList, String zoneString) {
        IZoneService zoneService = ZoneReferUtil.getZoneService();
        BatchOperation batchOperation = null;
        if (ZoneUtil.paramsNotValid(zoneInfoForm)) {
            codeLogger.info((Object)"validate post params for add zone, params invalid");
            batchOperation = new BatchOperation();
            batchOperation.setTargetName(zoneString + AticUtil.getcleanedMessage((String)zoneInfoForm.getZoneDesc()));
            batchOperation.setErrorCode(Long.valueOf(570601L).longValue());
            frontOperationList.add(batchOperation);
            return false;
        }
        if (!ZoneUtil.isValidZoneName(zoneInfoForm.getZoneName())) {
            codeLogger.info((Object)("invalid zoneName" + zoneInfoForm.getZoneName()));
            batchOperation = new BatchOperation();
            batchOperation.setTargetName(zoneString + zoneInfoForm.getZoneDesc());
            batchOperation.setErrorCode(Long.valueOf(570637L).longValue());
            frontOperationList.add(batchOperation);
            return false;
        }
        if (!ZoneUtil.isValidZoneDesc(zoneInfoForm.getZoneDesc())) {
            codeLogger.info((Object)("invalid zoneDesc" + zoneInfoForm.getZoneDesc()));
            batchOperation = new BatchOperation();
            batchOperation.setTargetName(zoneString + zoneInfoForm.getZoneDesc());
            batchOperation.setErrorCode(Long.valueOf(570636L).longValue());
            frontOperationList.add(batchOperation);
            return false;
        }
        if (zoneService.isZoneNameExists(zoneInfoForm.getZoneName(), zoneInfoForm.getZoneId())) {
            codeLogger.info((Object)("the zone name : " + AticUtil.getcleanedMessage((String)zoneInfoForm.getZoneName()) + "has been existed"));
            batchOperation = new BatchOperation();
            batchOperation.setTargetName(zoneString + zoneInfoForm.getZoneDesc() + "/" + zoneInfoForm.getZoneName());
            batchOperation.setErrorCode(Long.valueOf(570604L).longValue());
            frontOperationList.add(batchOperation);
            return false;
        }
        if (zoneService.isZoneDesExists(zoneInfoForm.getZoneDesc(), zoneInfoForm.getZoneId())) {
            codeLogger.info((Object)("the zone desc : " + zoneInfoForm.getZoneDesc() + "has been existed"));
            batchOperation = new BatchOperation();
            batchOperation.setTargetName(zoneString + zoneInfoForm.getZoneDesc());
            batchOperation.setErrorCode(Long.valueOf(570605L).longValue());
            frontOperationList.add(batchOperation);
            return false;
        }
        if (!ZoneUtil.isValidZoneContact(zoneInfoForm.getContact())) {
            codeLogger.info((Object)("invalid zoneContact" + AticUtil.getcleanedMessage((String)zoneInfoForm.getContact())));
            batchOperation = new BatchOperation();
            batchOperation.setTargetName(zoneString + zoneInfoForm.getZoneDesc() + "/" + zoneInfoForm.getContact());
            batchOperation.setErrorCode(Long.valueOf(570639L).longValue());
            frontOperationList.add(batchOperation);
            return false;
        }
        if (null == zoneInfoForm.getZoneType()) {
            codeLogger.info((Object)("import ZoneInfoForm failed, the error zoneDesc is " + AticUtil.getcleanedMessage((String)zoneInfoForm.getZoneDesc())));
            batchOperation = new BatchOperation();
            batchOperation.setTargetName(zoneString + zoneInfoForm.getZoneDesc() + "/" + zoneInfoForm.getZoneType());
            batchOperation.setErrorCode(572025L);
            frontOperationList.add(batchOperation);
            return false;
        }
        if (zoneInfoForm.getZoneType() != 1 && zoneInfoForm.getZoneType() != 2) {
            codeLogger.info((Object)("import ZoneInfoForm failed, the error zoneDesc is " + AticUtil.getcleanedMessage((String)zoneInfoForm.getZoneDesc())));
            batchOperation = new BatchOperation();
            batchOperation.setTargetName(zoneString + zoneInfoForm.getZoneDesc() + "/" + zoneInfoForm.getZoneType());
            batchOperation.setErrorCode(572025L);
            frontOperationList.add(batchOperation);
            return false;
        }
        if (!ZoneUtil.isValidZoneTelephone(zoneInfoForm.getTelephone())) {
            codeLogger.info((Object)"invalid zoneTelephone");
            batchOperation = new BatchOperation();
            batchOperation.setTargetName(zoneString + zoneInfoForm.getZoneDesc() + "/" + zoneInfoForm.getTelephone());
            batchOperation.setErrorCode(Long.valueOf(570640L).longValue());
            frontOperationList.add(batchOperation);
            return false;
        }
        if (!ZoneUtil.isValidZoneMobile(zoneInfoForm.getMobile())) {
            codeLogger.info((Object)"invalid zoneMobilePhone");
            batchOperation = new BatchOperation();
            batchOperation.setTargetName(zoneString + zoneInfoForm.getZoneDesc() + "/" + zoneInfoForm.getMobile());
            batchOperation.setErrorCode(Long.valueOf(570641L).longValue());
            frontOperationList.add(batchOperation);
            return false;
        }
        if (!ZoneUtil.validateIndustry(zoneInfoForm.getIndustry())) {
            codeLogger.info((Object)"invalid zoneIndustry");
            batchOperation = new BatchOperation();
            batchOperation.setTargetName(zoneString + zoneInfoForm.getZoneDesc() + "/" + zoneInfoForm.getIndustry());
            batchOperation.setErrorCode(Long.valueOf(570800L).longValue());
            frontOperationList.add(batchOperation);
            return false;
        }
        if (!ZoneUtil.isValidZonePost(zoneInfoForm.getPost())) {
            codeLogger.info((Object)"invalid zonePostCode");
            batchOperation = new BatchOperation();
            batchOperation.setTargetName(zoneString + zoneInfoForm.getZoneDesc() + "/" + zoneInfoForm.getPost());
            batchOperation.setErrorCode(Long.valueOf(570642L).longValue());
            frontOperationList.add(batchOperation);
            return false;
        }
        if (!ZoneUtil.isValidZoneEmail(zoneInfoForm.getEmail())) {
            codeLogger.info((Object)"invalid zoneEmail");
            batchOperation = new BatchOperation();
            batchOperation.setTargetName(zoneString + zoneInfoForm.getZoneDesc() + "/" + zoneInfoForm.getEmail());
            batchOperation.setErrorCode(Long.valueOf(570643L).longValue());
            frontOperationList.add(batchOperation);
            return false;
        }
        if (!ZoneUtil.isValidZoneRemarkOrAddr(zoneInfoForm.getAddress())) {
            codeLogger.info((Object)"invalid zoneAddress");
            batchOperation = new BatchOperation();
            batchOperation.setTargetName(zoneString + zoneInfoForm.getZoneDesc() + "/" + zoneInfoForm.getAddress());
            batchOperation.setErrorCode(Long.valueOf(570644L).longValue());
            frontOperationList.add(batchOperation);
            return false;
        }
        if (!ZoneUtil.isValidZoneRemarkOrAddr(zoneInfoForm.getRemark())) {
            codeLogger.info((Object)"invalid zoneRemark");
            batchOperation = new BatchOperation();
            batchOperation.setTargetName(zoneString + zoneInfoForm.getZoneDesc() + "/" + zoneInfoForm.getRemark());
            batchOperation.setErrorCode(Long.valueOf(570645L).longValue());
            frontOperationList.add(batchOperation);
            return false;
        }
        if (null == zoneInfoForm.getZoneId()) {
            if (zoneService.getZoneNum() >= 10000) {
                codeLogger.warn((Object)"exceed max zone num : 10000");
                batchOperation = new BatchOperation();
                batchOperation.setTargetName(zoneString + zoneInfoForm.getZoneDesc() + "/" + zoneInfoForm.getZoneDesc());
                batchOperation.setErrorCode(Long.valueOf(570603L).longValue());
                frontOperationList.add(batchOperation);
                return false;
            }
        } else if (zoneService.getZoneNum() > 10000) {
            codeLogger.warn((Object)"exceed max zone num : 10000");
            batchOperation = new BatchOperation();
            batchOperation.setTargetName(zoneString + zoneInfoForm.getZoneDesc() + "/" + zoneInfoForm.getZoneDesc());
            batchOperation.setErrorCode(Long.valueOf(570603L).longValue());
            frontOperationList.add(batchOperation);
            return false;
        }
        return true;
    }

    public static void saveZonePolicy(ZonePolicyApplyForm zonePolicyApplyForm) {
        IZonePolicyApplyService zonePolicyApplyService = ZoneReferUtil.getZonePolicyService();
        if (AticUtil.isNull((String)zonePolicyApplyForm.getDeployState())) {
            zonePolicyApplyForm.setDeployState("UNDEPLOY");
        } else if (!"UNDEPLOY".equals(zonePolicyApplyForm.getDeployState())) {
            zonePolicyApplyForm.setDeployState("INCREAMENT_UNDEPLOY");
        }
        zonePolicyApplyService.savePolicy(zonePolicyApplyForm, true);
    }

    public static List<Long> splitDeviceIds(String deviceIds) {
        ArrayList<Long> result = new ArrayList<Long>();
        if (StringUtils.isEmpty((CharSequence)deviceIds)) {
            return result;
        }
        String[] tempAllstr = deviceIds.split("\\|");
        for (int i = 0; i < tempAllstr.length; ++i) {
            if (AticUtil.isNull((String)tempAllstr[i])) continue;
            result.add(Long.valueOf(tempAllstr[i]));
        }
        return result;
    }

    private static void dealDefaultServiceNameAndType(ZoneServiceForm zoneService) {
        if (zoneService.getProtocol().equals("--")) {
            zoneService.setProtocol("DEFAULT");
            zoneService.setServiceType(0);
        } else if (zoneService.getProtocol().equals("DEFAULT")) {
            zoneService.setServiceType(0);
        } else {
            zoneService.setServiceType(1);
        }
    }

    public static void saveZoneService(Object[] params, User currentUser) {
        Log timeLogger = (Log)params[0];
        ZoneServiceForm zoneService = (ZoneServiceForm)params[1];
        Integer portListLimit = (Integer)params[2];
        String[] portList = (String[])params[3];
        String servicePort = (String)params[4];
        String[] ipList = (String[])params[5];
        long startTime = System.currentTimeMillis();
        timeLogger.info((Object)("The saveZoneService() start time is " + startTime));
        IZoneServiceService rmiService = ZoneReferUtil.getZoneServiceService();
        if (zoneService.getPkid() != null && rmiService.query(zoneService.getPkid()) == null) {
            return;
        }
        ZoneUtil.dealDefaultServiceNameAndType(zoneService);
        timeLogger.info((Object)("The dealDefaultServiceNameAndType() used times is " + (System.currentTimeMillis() - startTime) + "ms"));
        if (!Constant.PORT_LIST_LIMIT_NUMBER_ONE.equals(portListLimit)) {
            zoneService.setPortList(ZoneUtil.getComposeStr(portList));
        } else {
            zoneService.setPortList(servicePort);
        }
        zoneService.setIpList(ZoneUtil.getComposeStr(ipList));
        if (null == ZoneReferUtil.getZoneInfoFrom(zoneService.getZoneId(), currentUser)) {
            throw new LegoCheckedException(630111L);
        }
        timeLogger.info((Object)("The rmiService.create() start time is " + (System.currentTimeMillis() - startTime) + "ms"));
        rmiService.creatZoneServiceNoRefreshClollector(zoneService);
        timeLogger.info((Object)("The saveZoneService() used times is " + (System.currentTimeMillis() - startTime) + "ms"));
    }

    private static String getComposeStr(String[] array) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < array.length; ++i) {
            if (StringUtils.isEmpty((CharSequence)array[i])) continue;
            if (i == 0) {
                buffer.append(array[i]);
                continue;
            }
            buffer.append(";" + array[i]);
        }
        return buffer.toString();
    }

    public static String substring(String text, int length, String encode) throws UnsupportedEncodingException {
        if (text == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        int currentLength = 0;
        for (char c : text.toCharArray()) {
            if ((currentLength += String.valueOf(c).getBytes(encode).length) > length) break;
            sb.append(c);
        }
        return sb.toString();
    }

    public static void saveFaultSeverityRule(long zoneId, FaultSeverityRuleForm faultSeverityRuleForm) {
        if (null == faultSeverityRuleForm) {
            return;
        }
        faultSeverityRuleForm.getCriticalRule().setZoneId(Long.valueOf(zoneId));
        faultSeverityRuleForm.getMajorRule().setZoneId(Long.valueOf(zoneId));
        faultSeverityRuleForm.getMinorRule().setZoneId(Long.valueOf(zoneId));
        faultSeverityRuleForm.getWarningRule().setZoneId(Long.valueOf(zoneId));
        FaultSeverityRuleService service = ZoneReferUtil.getFaultSeverityRuleService();
        try {
            if (null != service) {
                FaultSeverityRuleForm faultSeverityRuleFormTemp = service.getZoneSeverityRuleByZoneId(Long.valueOf(zoneId), Integer.valueOf(faultSeverityRuleForm.getCriticalRule().getDirection()));
                if (null != faultSeverityRuleFormTemp) {
                    faultSeverityRuleForm.setNewRule(false);
                    faultSeverityRuleForm.getCriticalRule().setId(faultSeverityRuleFormTemp.getCriticalRule().getId());
                    faultSeverityRuleForm.getMajorRule().setId(faultSeverityRuleFormTemp.getMajorRule().getId());
                    faultSeverityRuleForm.getMinorRule().setId(faultSeverityRuleFormTemp.getMinorRule().getId());
                    faultSeverityRuleForm.getWarningRule().setId(faultSeverityRuleFormTemp.getWarningRule().getId());
                } else {
                    faultSeverityRuleForm.setNewRule(true);
                }
                service.saveRule(faultSeverityRuleForm);
            }
        }
        catch (RemoteException e) {
            logger.error((Object)"save fault severity rule failed.", (Throwable)e);
        }
    }

    public static void checkFaultSeverityRuleParameter(FaultSeverityRuleForm faultSeverityRuleForm) {
        if (null != faultSeverityRuleForm) {
            FaultSeverityRule criticalRule = faultSeverityRuleForm.getCriticalRule();
            FaultSeverityRule majorRule = faultSeverityRuleForm.getMajorRule();
            FaultSeverityRule minorRule = faultSeverityRuleForm.getMinorRule();
            FaultSeverityRule warningRule = faultSeverityRuleForm.getWarningRule();
            int critica01 = 1 == criticalRule.getInTrafficMbpsStatus() ? criticalRule.getInTrafficMbps() : Integer.MAX_VALUE;
            int major01 = 1 == majorRule.getInTrafficMbpsStatus() ? majorRule.getInTrafficMbps() : critica01;
            int minor01 = 1 == minorRule.getInTrafficMbpsStatus() ? minorRule.getInTrafficMbps() : major01;
            int warning01 = 1 == warningRule.getInTrafficMbpsStatus() ? warningRule.getInTrafficMbps() : minor01;
            ZoneUtil.checkSeverityRule(critica01, major01, minor01, warning01);
            critica01 = 1 == criticalRule.getInTrafficppsStatus() ? criticalRule.getInTrafficpps() : Integer.MAX_VALUE;
            major01 = 1 == majorRule.getInTrafficppsStatus() ? majorRule.getInTrafficpps() : critica01;
            minor01 = 1 == minorRule.getInTrafficppsStatus() ? minorRule.getInTrafficpps() : major01;
            warning01 = 1 == warningRule.getInTrafficppsStatus() ? warningRule.getInTrafficpps() : minor01;
            ZoneUtil.checkSeverityRule(critica01, major01, minor01, warning01);
            critica01 = 1 == criticalRule.getCurrentConnStatus() ? criticalRule.getCurrentConn() : Integer.MAX_VALUE;
            major01 = 1 == majorRule.getCurrentConnStatus() ? majorRule.getCurrentConn() : critica01;
            minor01 = 1 == minorRule.getCurrentConnStatus() ? minorRule.getCurrentConn() : major01;
            warning01 = 1 == warningRule.getCurrentConnStatus() ? warningRule.getCurrentConn() : minor01;
            ZoneUtil.checkSeverityRule(critica01, major01, minor01, warning01);
            critica01 = 1 == criticalRule.getNewConnStatus() ? criticalRule.getNewConn() : Integer.MAX_VALUE;
            major01 = 1 == majorRule.getNewConnStatus() ? majorRule.getNewConn() : critica01;
            minor01 = 1 == minorRule.getNewConnStatus() ? minorRule.getNewConn() : major01;
            warning01 = 1 == warningRule.getNewConnStatus() ? warningRule.getNewConn() : minor01;
            ZoneUtil.checkSeverityRule(critica01, major01, minor01, warning01);
            critica01 = 1 == criticalRule.getDurationStatus() ? criticalRule.getDuration() : Integer.MAX_VALUE;
            major01 = 1 == majorRule.getDurationStatus() ? majorRule.getDuration() : critica01;
            minor01 = 1 == minorRule.getDurationStatus() ? minorRule.getDuration() : major01;
            warning01 = 1 == warningRule.getDurationStatus() ? warningRule.getDuration() : minor01;
            ZoneUtil.checkSeverityRule(critica01, major01, minor01, warning01);
        }
    }

    private static void checkSeverityRule(int critical01, int major01, int minor01, int warning01) {
        if (critical01 < major01 || major01 < minor01 || minor01 < warning01) {
            throw new LegoCheckedException(632002L);
        }
    }

    public static boolean checkFaultSeverityRuleParameter4Import(ZoneInfoForm zoneInfoForm, FaultSeverityRuleForm faultSeverityRuleForm, List<BatchOperation> frontOperationList, String zoneString) {
        try {
            ZoneUtil.checkFaultSeverityRuleParameter(faultSeverityRuleForm);
            return true;
        }
        catch (LegoCheckedException e) {
            logger.info((Object)("import faultSeverityRuleForm failed, the error is " + e.getErrorCode()));
            ImportZoneUtil.recordErrorMessg(zoneString + zoneInfoForm.getZoneDesc() + "/" + zoneInfoForm.getZoneName(), 632002L, frontOperationList);
            return false;
        }
    }
}

