/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.service;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.secservice.ddos.common.util.xmlparser.MappingBean;
import com.hs.vsm.secservice.ddos.common.util.xmlparser.XmlParser;
import com.hs.vsm.secservice.sdk.module.ddos.form.AttackTypeInfoForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ManualDefendForm;
import com.hs.vsm.secservice.sdk.module.ddos.service.IAttackTypeInfoService;
import java.util.HashMap;
import java.util.Map;

public class AttackTypeInfoServiceImpl
implements IAttackTypeInfoService {
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private Map<String, String> mapping = new HashMap<String, String>();

    @Override
    public AttackTypeInfoForm getAttackTypeInfo(ManualDefendForm form) {
        AttackTypeInfoForm result = this.createAttackTypeForm(form);
        return result;
    }

    private AttackTypeInfoForm createAttackTypeForm(ManualDefendForm info) {
        int attackType = info.getAttackType();
        AttackTypeInfoForm form = new AttackTypeInfoForm();
        form.setAttackType(attackType);
        MappingBean mappingBean = this.getParseXmlMap();
        String attackTypeKey = "attackType." + attackType;
        String modeKey = "mode." + attackType;
        String attackTypeStr = null;
        String modeStr = null;
        if (mappingBean != null) {
            if (attackType == 0) {
                attackTypeStr = mappingBean.getMapping().get(attackTypeKey) + " " + info.getServiceName();
                modeStr = mappingBean.getMapping().get(modeKey);
                form.setAttackTypeStr(attackTypeStr);
                form.setMode(modeStr);
            } else if (attackType > 0) {
                attackTypeStr = mappingBean.getMapping().get(attackTypeKey);
                modeStr = mappingBean.getMapping().get(modeKey);
                form.setAttackTypeStr(attackTypeStr);
                form.setMode(modeStr);
            } else {
                attackTypeStr = " this should not happen .attackType: " + attackType;
                form.setAttackTypeStr(attackTypeStr);
            }
        }
        return form;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MappingBean getParseXmlMap() {
        MappingBean map;
        block6: {
            map = new MappingBean();
            String xmlPath = "conf/common/attackTypeService-mapping.xml";
            String xmlRulePath = "conf/rulefile/xmlrule-mapping.xml";
            try {
                map = (MappingBean)XmlParser.parseXml2Bean(xmlPath, xmlRulePath);
                if (null == map) {
                    this.logger.info((Object)"none data parsed from file: please check it");
                    break block6;
                }
                Map<String, String> map2 = this.mapping;
                synchronized (map2) {
                    this.mapping.putAll(map.getMapping());
                }
            }
            catch (Exception e) {
                this.logger.error((Object)e);
            }
        }
        return map;
    }

    @Override
    public Map<Integer, String> getAllAttackType() {
        MappingBean mappingBean = this.getParseXmlMap();
        HashMap<Integer, String> allAttackType = new HashMap<Integer, String>();
        if (mappingBean != null) {
            Map<String, String> allAttackMap = mappingBean.getMapping();
            for (Map.Entry<String, String> each : allAttackMap.entrySet()) {
                if (each.getKey().contains("mode") || each.getKey().contains("attackType")) continue;
                int attackId = Integer.parseInt(each.getKey());
                allAttackType.put(attackId, each.getValue());
            }
        }
        return allAttackType;
    }
}

