/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.service;

import com.hs.lego.core.sdk.comm.BatchOperation;
import com.hs.lego.core.sdk.comm.BatchOperationResult;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.vsm.secservice.ddos.dao.DnsDefendPolicyDao;
import com.hs.vsm.secservice.ddos.dao.DnsDomainCacheDao;
import com.hs.vsm.secservice.ddos.dao.DnsDomainDefendDao;
import com.hs.vsm.secservice.ddos.dao.DnsRequestStaticFingerDao;
import com.hs.vsm.secservice.ddos.dao.DnsResponseStaticFingerDao;
import com.hs.vsm.secservice.ddos.dao.DnsStatisticDao;
import com.hs.vsm.secservice.ddos.dao.SourceIpRequestDao;
import com.hs.vsm.secservice.ddos.dao.SourceIpResponseDao;
import com.hs.vsm.secservice.ddos.model.DnsDefendPolicyInfo;
import com.hs.vsm.secservice.ddos.model.DnsDomainCacheInfo;
import com.hs.vsm.secservice.ddos.model.DnsDomainDefendInfo;
import com.hs.vsm.secservice.ddos.model.DnsRequestStaticFingerInfo;
import com.hs.vsm.secservice.ddos.model.DnsResponseStaticFingerInfo;
import com.hs.vsm.secservice.ddos.model.DnsStatisticItemInfo;
import com.hs.vsm.secservice.ddos.model.SourceIpRequestInfo;
import com.hs.vsm.secservice.ddos.model.SourceIpResponseInfo;
import com.hs.vsm.secservice.sdk.common.util.VsmUtil;
import com.hs.vsm.secservice.sdk.module.ddos.form.DnsDefendPolicyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.DnsDomainCacheForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.DnsDomainDefendForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.DnsRequestStaticFingerForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.DnsResponseStaticFingerForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.DnsStatisticItem;
import com.hs.vsm.secservice.sdk.module.ddos.form.SourceIpRequestMessageForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.SourceIpResponseMessageForm;
import com.hs.vsm.secservice.sdk.module.ddos.service.IDnsDefendPolicyService;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DnsDefendPolicyServiceImpl
implements IDnsDefendPolicyService {
    private DnsDefendPolicyDao dnsDefendPolicyDao;
    private DnsDomainCacheDao dnsDomainCacheDao;
    private DnsDomainDefendDao dnsDomainDefendDao;
    private DnsStatisticDao dnsStatisticDao;
    private SourceIpResponseDao sourceIpResponseDao;
    private SourceIpRequestDao sourceIpRequestDao;
    private DnsRequestStaticFingerDao dnsRequestStaticFingerDao;
    private DnsResponseStaticFingerDao dnsResponseStaticFingerDao;

    public DnsRequestStaticFingerDao getDnsRequestStaticFingerDao() {
        return this.dnsRequestStaticFingerDao;
    }

    public void setDnsRequestStaticFingerDao(DnsRequestStaticFingerDao dnsRequestStaticFingerDao) {
        this.dnsRequestStaticFingerDao = dnsRequestStaticFingerDao;
    }

    public DnsResponseStaticFingerDao getDnsResponseStaticFingerDao() {
        return this.dnsResponseStaticFingerDao;
    }

    public void setDnsResponseStaticFingerDao(DnsResponseStaticFingerDao dnsResponseStaticFingerDao) {
        this.dnsResponseStaticFingerDao = dnsResponseStaticFingerDao;
    }

    public SourceIpResponseDao getSourceIpResponseDao() {
        return this.sourceIpResponseDao;
    }

    public void setSourceIpResponseDao(SourceIpResponseDao sourceIpResponseDao) {
        this.sourceIpResponseDao = sourceIpResponseDao;
    }

    public SourceIpRequestDao getSourceIpRequestDao() {
        return this.sourceIpRequestDao;
    }

    public void setSourceIpRequestDao(SourceIpRequestDao sourceIpRequestDao) {
        this.sourceIpRequestDao = sourceIpRequestDao;
    }

    public DnsStatisticDao getDnsStatisticDao() {
        return this.dnsStatisticDao;
    }

    public void setDnsStatisticDao(DnsStatisticDao dnsStatisticDao) {
        this.dnsStatisticDao = dnsStatisticDao;
    }

    @Override
    public DnsDefendPolicyForm queryByServiceId(Long serviceId) {
        if (null == serviceId) {
            return null;
        }
        DnsDefendPolicyInfo info = this.getDnsDefendPolicyDao().queryByServiceId(serviceId);
        DnsDefendPolicyForm form = this.tranInfo2Form(info);
        return form;
    }

    public Long create(DnsDefendPolicyForm form) {
        Long pkid = null;
        if (null != form) {
            DnsDefendPolicyInfo info = this.tranForm2Info(form);
            if (form.getDirection() == 1) {
                pkid = (Long)this.getDnsDefendPolicyDao().create(info);
                form.setId(pkid);
            }
        }
        return pkid;
    }

    public void createOrUpdate(DnsDefendPolicyForm form) {
        this.save(form);
    }

    public void delete(Long id) {
        if (null == id) {
            return;
        }
        this.getDnsDefendPolicyDao().delete(id);
    }

    public void delete(DnsDefendPolicyForm form) {
        if (null != form && null != form.getId()) {
            this.getDnsDefendPolicyDao().delete(form.getId());
        }
    }

    public BatchOperationResult deleteInBatch(List<BatchOperation> boList) {
        return null;
    }

    public DnsDefendPolicyForm query(Long id) {
        if (null == id) {
            return null;
        }
        DnsDefendPolicyInfo info = (DnsDefendPolicyInfo)this.getDnsDefendPolicyDao().query(id);
        DnsDefendPolicyForm form = this.tranInfo2Form(info);
        return form;
    }

    public Paging queryByPage(Map<String, String> queryMap, int start, int pageSize) {
        return this.dnsDefendPolicyDao.queryByPage(queryMap, start, pageSize);
    }

    public void save(DnsDefendPolicyForm form) {
        if (null != form) {
            DnsDefendPolicyInfo info = this.tranForm2Info(form);
            DnsDefendPolicyInfo infoInDB = (DnsDefendPolicyInfo)this.getDnsDefendPolicyDao().query(form.getId());
            List<DnsStatisticItemInfo> infoToDelete = this.getToDeleteStatistic(info, infoInDB);
            List<DnsDomainCacheInfo> cacheInfoToDelete = this.getToDeleteDomainCache(info, infoInDB);
            List<DnsDomainDefendInfo> defendInfoToDelete = this.getToDeleteDefendCache(info, infoInDB);
            List<SourceIpResponseInfo> sourceIpResponseInfoToDelete = this.getToDeleteSourceIpResponseInfos(info, infoInDB);
            List<SourceIpRequestInfo> sourceIpRequestInfoToDelete = this.getToDeleteSourceIpRequestInfos(info, infoInDB);
            List<DnsRequestStaticFingerInfo> requestStaticFingerToDelete = this.getToDeleteDnsRequestStaticFingers(info, infoInDB);
            List<DnsResponseStaticFingerInfo> responseStaticFingerToDelete = this.getToDeleteDnsResponseStaticFingers(info, infoInDB);
            this.getDnsDefendPolicyDao().save(info);
            this.getDnsDomainCacheDao().deleteList(cacheInfoToDelete);
            this.getDnsDomainDefendDao().deleteList(defendInfoToDelete);
            this.getDnsStatisticDao().deleteList(infoToDelete);
            this.getSourceIpResponseDao().deleteList(sourceIpResponseInfoToDelete);
            this.getSourceIpRequestDao().deleteList(sourceIpRequestInfoToDelete);
            this.getDnsRequestStaticFingerDao().deleteList(requestStaticFingerToDelete);
            this.getDnsResponseStaticFingerDao().deleteList(responseStaticFingerToDelete);
        }
    }

    private List<DnsStatisticItemInfo> getToDeleteStatistic(DnsDefendPolicyInfo info, DnsDefendPolicyInfo infoInDB) {
        ArrayList<DnsStatisticItemInfo> toDelete = new ArrayList<DnsStatisticItemInfo>();
        if (null == infoInDB) {
            return toDelete;
        }
        if (infoInDB.getDnsStatisticItemInfos() != null) {
            for (DnsStatisticItemInfo deleteInfo : infoInDB.getDnsStatisticItemInfos()) {
                if (null == info) {
                    toDelete.add(deleteInfo);
                    continue;
                }
                if (info.getDnsStatisticItemInfos().contains(deleteInfo)) continue;
                toDelete.add(deleteInfo);
            }
        }
        return toDelete;
    }

    public void update(DnsDefendPolicyForm form) {
        this.save(form);
    }

    private DnsDefendPolicyForm tranInfo2Form(DnsDefendPolicyInfo info) {
        if (null == info) {
            return null;
        }
        DnsDefendPolicyForm form = new DnsDefendPolicyForm();
        VsmUtil.getInstance().copyProperties(info, form);
        this.transResponseSourceIp(info, form);
        this.transRequestSourceIp(info, form);
        this.transRequestStaticFinger(info, form);
        this.transResponseStaticFinger(info, form);
        this.transCache(info, form);
        this.transDomainDefend(info, form);
        this.transStatisticItem(info, form);
        return form;
    }

    private void transStatisticItem(DnsDefendPolicyInfo info, DnsDefendPolicyForm form) {
        if (null == info || null == form) {
            return;
        }
        Set<DnsStatisticItemInfo> statistic = info.getDnsStatisticItemInfos();
        ArrayList<DnsStatisticItem> statisticItem = new ArrayList<DnsStatisticItem>();
        if (statistic != null && !statistic.isEmpty()) {
            for (DnsStatisticItemInfo defendInfo : statistic) {
                DnsStatisticItem defendForm = new DnsStatisticItem();
                VsmUtil.getInstance().copyProperties(defendInfo, defendForm);
                statisticItem.add(defendForm);
            }
        }
        form.setDnsStatisticItems(statisticItem);
    }

    private void transDomainDefend(DnsDefendPolicyInfo info, DnsDefendPolicyForm form) {
        if (null == info || null == form) {
            return;
        }
        Set<DnsDomainDefendInfo> defendInfoSet = info.getDnsDomainDefendInfos();
        ArrayList<DnsDomainDefendForm> defendFormList = new ArrayList<DnsDomainDefendForm>();
        if (defendInfoSet != null && !defendInfoSet.isEmpty()) {
            for (DnsDomainDefendInfo defendInfo : defendInfoSet) {
                DnsDomainDefendForm defendForm = new DnsDomainDefendForm();
                VsmUtil.getInstance().copyProperties(defendInfo, defendForm);
                defendFormList.add(defendForm);
            }
        }
        form.setDnsDomainDefendForms(defendFormList);
    }

    private void transCache(DnsDefendPolicyInfo info, DnsDefendPolicyForm form) {
        if (null == info || null == form) {
            return;
        }
        Set<DnsDomainCacheInfo> cacheInfoSet = info.getDnsDomainCacheInfos();
        ArrayList<DnsDomainCacheForm> cacheFormList = new ArrayList<DnsDomainCacheForm>();
        if (cacheInfoSet != null && !cacheInfoSet.isEmpty()) {
            for (DnsDomainCacheInfo cacheInfo : cacheInfoSet) {
                DnsDomainCacheForm cacheForm = new DnsDomainCacheForm();
                VsmUtil.getInstance().copyProperties(cacheInfo, cacheForm);
                cacheFormList.add(cacheForm);
            }
        }
        form.setDnsDomainCacheForms(cacheFormList);
    }

    private void transResponseStaticFinger(DnsDefendPolicyInfo info, DnsDefendPolicyForm form) {
        if (null == info || null == form) {
            return;
        }
        Set<DnsResponseStaticFingerInfo> responseStaticFingerInfoSet = info.getDnsResponseStaticFingerInfos();
        ArrayList<DnsResponseStaticFingerForm> responseStaticFingerForms = new ArrayList<DnsResponseStaticFingerForm>();
        if (responseStaticFingerInfoSet != null && !responseStaticFingerInfoSet.isEmpty()) {
            for (DnsResponseStaticFingerInfo responseStaticFingerInfo : responseStaticFingerInfoSet) {
                DnsResponseStaticFingerForm responseStaticFingerForm = new DnsResponseStaticFingerForm();
                VsmUtil.getInstance().copyProperties(responseStaticFingerInfo, responseStaticFingerForm);
                responseStaticFingerForms.add(responseStaticFingerForm);
            }
        }
        form.setDnsResponseStaticFingerForms(responseStaticFingerForms);
    }

    private void transRequestStaticFinger(DnsDefendPolicyInfo info, DnsDefendPolicyForm form) {
        if (null == info || null == form) {
            return;
        }
        Set<DnsRequestStaticFingerInfo> requestStaticFingerInfoSet = info.getDnsRequestStaticFingerInfos();
        ArrayList<DnsRequestStaticFingerForm> requestStaticFingerForms = new ArrayList<DnsRequestStaticFingerForm>();
        if (requestStaticFingerInfoSet != null && !requestStaticFingerInfoSet.isEmpty()) {
            for (DnsRequestStaticFingerInfo requestStaticFingerInfo : requestStaticFingerInfoSet) {
                DnsRequestStaticFingerForm requestStaticFingerForm = new DnsRequestStaticFingerForm();
                VsmUtil.getInstance().copyProperties(requestStaticFingerInfo, requestStaticFingerForm);
                requestStaticFingerForms.add(requestStaticFingerForm);
            }
        }
        form.setDnsRequestStaticFingerForms(requestStaticFingerForms);
    }

    private void transRequestSourceIp(DnsDefendPolicyInfo info, DnsDefendPolicyForm form) {
        if (null == info || null == form) {
            return;
        }
        Set<SourceIpRequestInfo> sourceIpRequestSet = info.getSourceIpRequestInfos();
        ArrayList<SourceIpRequestMessageForm> sourceIpRequestList = new ArrayList<SourceIpRequestMessageForm>();
        if (sourceIpRequestSet != null && !sourceIpRequestSet.isEmpty()) {
            for (SourceIpRequestInfo sourceIpRequestInfo : sourceIpRequestSet) {
                SourceIpRequestMessageForm sourceIpRequestForm = new SourceIpRequestMessageForm();
                VsmUtil.getInstance().copyProperties(sourceIpRequestInfo, sourceIpRequestForm);
                sourceIpRequestList.add(sourceIpRequestForm);
            }
        }
        form.setAppointSourceIpRequestMessageFroms(sourceIpRequestList);
    }

    private void transResponseSourceIp(DnsDefendPolicyInfo info, DnsDefendPolicyForm form) {
        if (null == info || null == form) {
            return;
        }
        Set<SourceIpResponseInfo> sourceIpResponseSet = info.getSourceIpResponseInfos();
        ArrayList<SourceIpResponseMessageForm> sourceIpResponseList = new ArrayList<SourceIpResponseMessageForm>();
        for (SourceIpResponseInfo sourceIpResponseInfo : sourceIpResponseSet) {
            SourceIpResponseMessageForm sourceIpResponseMessageForm = new SourceIpResponseMessageForm();
            VsmUtil.getInstance().copyProperties(sourceIpResponseInfo, sourceIpResponseMessageForm);
            sourceIpResponseList.add(sourceIpResponseMessageForm);
        }
        form.setAppointSourceIpResponseMessageForms(sourceIpResponseList);
    }

    private DnsDefendPolicyInfo tranForm2Info(DnsDefendPolicyForm form) {
        if (null == form) {
            return null;
        }
        DnsDefendPolicyInfo info = new DnsDefendPolicyInfo();
        VsmUtil.getInstance().copyProperties(form, info);
        List<DnsDomainCacheForm> cacheFormList = form.getDnsDomainCacheForms();
        HashSet<DnsDomainCacheInfo> cacheInfoSet = new HashSet<DnsDomainCacheInfo>();
        for (DnsDomainCacheForm cacheForm : cacheFormList) {
            DnsDomainCacheInfo cacheInfo = new DnsDomainCacheInfo();
            cacheForm.setId(null);
            VsmUtil.getInstance().copyProperties(cacheForm, cacheInfo);
            cacheInfoSet.add(cacheInfo);
        }
        info.setDnsDomainCacheInfos(cacheInfoSet);
        List<DnsDomainDefendForm> defendFormList = form.getDnsDomainDefendForms();
        HashSet<DnsDomainDefendInfo> defendInfoSet = new HashSet<DnsDomainDefendInfo>();
        for (DnsDomainDefendForm defendForm : defendFormList) {
            DnsDomainDefendInfo defendInfo = new DnsDomainDefendInfo();
            defendForm.setId(null);
            VsmUtil.getInstance().copyProperties(defendForm, defendInfo);
            defendInfoSet.add(defendInfo);
        }
        info.setDnsDomainDefendInfos(defendInfoSet);
        List<DnsStatisticItem> dnsStatisticForms = form.getDnsStatisticItems();
        HashSet<DnsStatisticItemInfo> dnsStatisticInfos = new HashSet<DnsStatisticItemInfo>();
        for (DnsStatisticItem dnsStatistic : dnsStatisticForms) {
            DnsStatisticItemInfo dnsStatisticItemInfo = new DnsStatisticItemInfo();
            dnsStatistic.setId(null);
            VsmUtil.getInstance().copyProperties(dnsStatistic, dnsStatisticItemInfo);
            dnsStatisticInfos.add(dnsStatisticItemInfo);
        }
        info.setDnsStatisticItemInfos(dnsStatisticInfos);
        List<SourceIpResponseMessageForm> sourceIpResponseMessageForms = form.getAppointSourceIpResponseMessageForms();
        HashSet<SourceIpResponseInfo> sourceIpResponseInfos = new HashSet<SourceIpResponseInfo>();
        for (SourceIpResponseMessageForm sourceIpResponseForm : sourceIpResponseMessageForms) {
            SourceIpResponseInfo sourceIpResponseInfo = new SourceIpResponseInfo();
            sourceIpResponseForm.setId(null);
            VsmUtil.getInstance().copyProperties(sourceIpResponseForm, sourceIpResponseInfo);
            sourceIpResponseInfos.add(sourceIpResponseInfo);
        }
        info.setSourceIpResponseInfos(sourceIpResponseInfos);
        List<SourceIpRequestMessageForm> sourceIpRequestMessageForms = form.getAppointSourceIpRequestMessageFroms();
        HashSet<SourceIpRequestInfo> sourceIpResponseInfoSet = new HashSet<SourceIpRequestInfo>();
        for (SourceIpRequestMessageForm sourceIpRequestMessageForm : sourceIpRequestMessageForms) {
            SourceIpRequestInfo sourceIpRequestInfo = new SourceIpRequestInfo();
            sourceIpRequestMessageForm.setId(null);
            VsmUtil.getInstance().copyProperties(sourceIpRequestMessageForm, sourceIpRequestInfo);
            sourceIpResponseInfoSet.add(sourceIpRequestInfo);
        }
        info.setSourceIpRequestInfos(sourceIpResponseInfoSet);
        List<DnsRequestStaticFingerForm> requestStaticFingerForms = form.getDnsRequestStaticFingerForms();
        HashSet<DnsRequestStaticFingerInfo> requestStaticFingerInfoSet = new HashSet<DnsRequestStaticFingerInfo>();
        for (DnsRequestStaticFingerForm requestStaticFingerForm : requestStaticFingerForms) {
            DnsRequestStaticFingerInfo requestStaticFingerInfo = new DnsRequestStaticFingerInfo();
            requestStaticFingerForm.setId(null);
            VsmUtil.getInstance().copyProperties(requestStaticFingerForm, requestStaticFingerInfo);
            requestStaticFingerInfoSet.add(requestStaticFingerInfo);
        }
        info.setDnsRequestStaticFingerInfos(requestStaticFingerInfoSet);
        List<DnsResponseStaticFingerForm> responseStaticFingerForms = form.getDnsResponseStaticFingerForms();
        HashSet<DnsResponseStaticFingerInfo> responseStaticFingerInfoSet = new HashSet<DnsResponseStaticFingerInfo>();
        for (DnsResponseStaticFingerForm responseStaticFingerForm : responseStaticFingerForms) {
            DnsResponseStaticFingerInfo responseStaticFingerInfo = new DnsResponseStaticFingerInfo();
            responseStaticFingerForm.setId(null);
            VsmUtil.getInstance().copyProperties(responseStaticFingerForm, responseStaticFingerInfo);
            responseStaticFingerInfoSet.add(responseStaticFingerInfo);
        }
        info.setDnsResponseStaticFingerInfos(responseStaticFingerInfoSet);
        return info;
    }

    public DnsDefendPolicyDao getDnsDefendPolicyDao() {
        return this.dnsDefendPolicyDao;
    }

    public void setDnsDefendPolicyDao(DnsDefendPolicyDao dnsDefendPolicyDao) {
        this.dnsDefendPolicyDao = dnsDefendPolicyDao;
    }

    public DnsDomainCacheDao getDnsDomainCacheDao() {
        return this.dnsDomainCacheDao;
    }

    public void setDnsDomainCacheDao(DnsDomainCacheDao dnsDomainCacheDao) {
        this.dnsDomainCacheDao = dnsDomainCacheDao;
    }

    public DnsDomainDefendDao getDnsDomainDefendDao() {
        return this.dnsDomainDefendDao;
    }

    public void setDnsDomainDefendDao(DnsDomainDefendDao dnsDomainDefendDao) {
        this.dnsDomainDefendDao = dnsDomainDefendDao;
    }

    private List<DnsDomainDefendInfo> getToDeleteDefendCache(DnsDefendPolicyInfo info, DnsDefendPolicyInfo infoInDB) {
        ArrayList<DnsDomainDefendInfo> toDelete = new ArrayList<DnsDomainDefendInfo>();
        for (DnsDomainDefendInfo defendInfo : infoInDB.getDnsDomainDefendInfos()) {
            if (info.getDnsDomainDefendInfos().contains(defendInfo)) continue;
            toDelete.add(defendInfo);
        }
        return toDelete;
    }

    private List<DnsDomainCacheInfo> getToDeleteDomainCache(DnsDefendPolicyInfo info, DnsDefendPolicyInfo infoInDB) {
        ArrayList<DnsDomainCacheInfo> toDelete = new ArrayList<DnsDomainCacheInfo>();
        for (DnsDomainCacheInfo domainInfo : infoInDB.getDnsDomainCacheInfos()) {
            if (info.getDnsDomainCacheInfos().contains(domainInfo)) continue;
            toDelete.add(domainInfo);
        }
        return toDelete;
    }

    private List<SourceIpResponseInfo> getToDeleteSourceIpResponseInfos(DnsDefendPolicyInfo info, DnsDefendPolicyInfo infoInDB) {
        ArrayList<SourceIpResponseInfo> toDelete = new ArrayList<SourceIpResponseInfo>();
        if (infoInDB.getSourceIpResponseInfos() != null && !infoInDB.getSourceIpResponseInfos().isEmpty()) {
            for (SourceIpResponseInfo sourceIpResponseInfo : infoInDB.getSourceIpResponseInfos()) {
                if (info.getSourceIpResponseInfos().contains(sourceIpResponseInfo)) continue;
                toDelete.add(sourceIpResponseInfo);
            }
        }
        return toDelete;
    }

    private List<SourceIpRequestInfo> getToDeleteSourceIpRequestInfos(DnsDefendPolicyInfo info, DnsDefendPolicyInfo infoInDB) {
        ArrayList<SourceIpRequestInfo> toDelete = new ArrayList<SourceIpRequestInfo>();
        if (infoInDB.getSourceIpRequestInfos() != null && !infoInDB.getSourceIpRequestInfos().isEmpty()) {
            for (SourceIpRequestInfo sourceIpRequestInfo : infoInDB.getSourceIpRequestInfos()) {
                if (info.getSourceIpRequestInfos().contains(sourceIpRequestInfo)) continue;
                toDelete.add(sourceIpRequestInfo);
            }
        }
        return toDelete;
    }

    private List<DnsRequestStaticFingerInfo> getToDeleteDnsRequestStaticFingers(DnsDefendPolicyInfo info, DnsDefendPolicyInfo infoInDB) {
        ArrayList<DnsRequestStaticFingerInfo> toDelete = new ArrayList<DnsRequestStaticFingerInfo>();
        if (infoInDB.getDnsRequestStaticFingerInfos() != null && !infoInDB.getDnsRequestStaticFingerInfos().isEmpty()) {
            for (DnsRequestStaticFingerInfo dnsRequestStaticFingerInfo : infoInDB.getDnsRequestStaticFingerInfos()) {
                if (info.getDnsRequestStaticFingerInfos().contains(dnsRequestStaticFingerInfo)) continue;
                toDelete.add(dnsRequestStaticFingerInfo);
            }
        }
        return toDelete;
    }

    private List<DnsResponseStaticFingerInfo> getToDeleteDnsResponseStaticFingers(DnsDefendPolicyInfo info, DnsDefendPolicyInfo infoInDB) {
        ArrayList<DnsResponseStaticFingerInfo> toDelete = new ArrayList<DnsResponseStaticFingerInfo>();
        if (infoInDB.getDnsResponseStaticFingerInfos() != null && !infoInDB.getDnsResponseStaticFingerInfos().isEmpty()) {
            for (DnsResponseStaticFingerInfo dnsResponseStaticFingerInfo : infoInDB.getDnsResponseStaticFingerInfos()) {
                if (info.getDnsResponseStaticFingerInfos().contains(dnsResponseStaticFingerInfo)) continue;
                toDelete.add(dnsResponseStaticFingerInfo);
            }
        }
        return toDelete;
    }

    @Override
    public void deleteByServiceId(Long serviceId) {
        if (null == serviceId) {
            return;
        }
        DnsDefendPolicyForm form = this.queryByServiceId(serviceId);
        if (null != form) {
            this.delete(form);
        }
    }
}

