/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.service;

import com.hs.atic.zone.util.ZoneUtil;
import com.hs.vsm.secservice.ddos.dao.FilterDeviceZoneInfoDao;
import com.hs.vsm.secservice.ddos.model.FilterDeviceZoneInfo;
import com.hs.vsm.secservice.sdk.common.util.VsmUtil;
import com.hs.vsm.secservice.sdk.module.ddos.form.FilterDeviceZoneForm;
import com.hs.vsm.secservice.sdk.module.ddos.service.IFilterDeviceZoneInfoService;
import com.huawei.atic.device.model.AticDeviceNfaCluster;
import com.huawei.atic.secne.sdk.service.IClusterService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FilterDeviceZoneInfoServiceImpl
implements IFilterDeviceZoneInfoService {
    private FilterDeviceZoneInfoDao filterDeviceZoneInfoDao;
    private IClusterService clusterService;

    @Override
    public List<FilterDeviceZoneForm> getByFilterId(Long filterId, int direction) {
        List<FilterDeviceZoneInfo> filterDeviceZoneInfoList = this.filterDeviceZoneInfoDao.getByFilterId(filterId, direction);
        ArrayList<FilterDeviceZoneForm> filterDeviceZoneFormList = new ArrayList<FilterDeviceZoneForm>();
        if (filterDeviceZoneInfoList != null && !filterDeviceZoneInfoList.isEmpty()) {
            int j = filterDeviceZoneInfoList.size();
            for (int i = 0; i < j; ++i) {
                FilterDeviceZoneForm filterDeviceZoneForm = new FilterDeviceZoneForm();
                VsmUtil.getInstance().copyProperties(filterDeviceZoneInfoList.get(i), filterDeviceZoneForm);
                filterDeviceZoneFormList.add(filterDeviceZoneForm);
            }
        }
        return filterDeviceZoneFormList;
    }

    @Override
    public List<FilterDeviceZoneForm> getByFilterIdAuthority(Map<String, String> queryMap) {
        List<FilterDeviceZoneInfo> filterDeviceZoneInfoList = this.filterDeviceZoneInfoDao.getByFilterIdAuthority(queryMap);
        ArrayList<FilterDeviceZoneForm> filterDeviceZoneFormList = new ArrayList<FilterDeviceZoneForm>();
        if (filterDeviceZoneInfoList != null && !filterDeviceZoneInfoList.isEmpty()) {
            int j = filterDeviceZoneInfoList.size();
            for (int i = 0; i < j; ++i) {
                FilterDeviceZoneInfo info = filterDeviceZoneInfoList.get(i);
                FilterDeviceZoneForm filterDeviceZoneForm = new FilterDeviceZoneForm();
                VsmUtil.getInstance().copyProperties(info, filterDeviceZoneForm);
                filterDeviceZoneFormList.add(filterDeviceZoneForm);
            }
        }
        return filterDeviceZoneFormList;
    }

    @Override
    public List<FilterDeviceZoneForm> queryByZoneId(Long zoneId) {
        HashMap<Integer, Long> condition = new HashMap<Integer, Long>();
        condition.put(0, zoneId);
        ArrayList<FilterDeviceZoneForm> filterDeviceForms = new ArrayList<FilterDeviceZoneForm>();
        List filterDeviceInfos = this.filterDeviceZoneInfoDao.queryByHql(" from FilterDeviceZoneInfo where zoneId = ? ", condition);
        if (null == filterDeviceInfos || filterDeviceInfos.isEmpty()) {
            return filterDeviceForms;
        }
        for (FilterDeviceZoneInfo filterDeviceInfo : filterDeviceInfos) {
            FilterDeviceZoneForm filterDeviceForm = new FilterDeviceZoneForm();
            VsmUtil.getInstance().copyProperties(filterDeviceInfo, filterDeviceForm);
            filterDeviceForms.add(filterDeviceForm);
        }
        return filterDeviceForms;
    }

    @Override
    public Set<Long> delFilterRelationByDeviceIds(Long zoneId, List<Long> deviceIds) {
        StringBuffer sql = new StringBuffer();
        sql.append("from FilterDeviceZoneInfo where zoneId = ? and deviceId in ( ");
        HashMap<Integer, Long> condition = new HashMap<Integer, Long>();
        int index = 0;
        condition.put(index++, zoneId);
        for (int i = 0; i < deviceIds.size(); ++i) {
            condition.put(index++, deviceIds.get(i));
            if (i == 0) {
                sql.append("?");
                continue;
            }
            sql.append(",?");
        }
        sql.append(")");
        List filterDeviceZoneInfos = this.filterDeviceZoneInfoDao.queryByHql(sql.toString(), condition);
        HashSet<Long> filterIds = new HashSet<Long>();
        if (null != filterDeviceZoneInfos && !filterDeviceZoneInfos.isEmpty()) {
            for (FilterDeviceZoneInfo filterDeviceZoneInfo : filterDeviceZoneInfos) {
                filterIds.add(filterDeviceZoneInfo.getFilterId());
            }
            this.filterDeviceZoneInfoDao.deleteList(filterDeviceZoneInfos);
        }
        return filterIds;
    }

    @Override
    public Set<Long> delFilterRelationByZoneId(Long zoneId) {
        HashMap<Integer, Long> condition = new HashMap<Integer, Long>();
        condition.put(0, zoneId);
        List filterDeviceZoneInfos = this.filterDeviceZoneInfoDao.queryByHql(" from FilterDeviceZoneInfo where zoneId = ? ", condition);
        HashSet<Long> filterIds = new HashSet<Long>();
        if (null != filterDeviceZoneInfos && !filterDeviceZoneInfos.isEmpty()) {
            for (FilterDeviceZoneInfo filterDeviceZoneInfo : filterDeviceZoneInfos) {
                filterIds.add(filterDeviceZoneInfo.getFilterId());
            }
            this.filterDeviceZoneInfoDao.deleteList(filterDeviceZoneInfos);
        }
        return filterIds;
    }

    @Override
    public void delFilterRelationByDeviceId(Long deviceId) {
        this.filterDeviceZoneInfoDao.deleteByDeviceId(deviceId);
    }

    @Override
    public Long queryPreferenceByFilterIdAndZoneId(Long filterId, Long zoneId, int direction) {
        return this.filterDeviceZoneInfoDao.queryPreferenceByFilterIdAndZoneId(filterId, zoneId, direction);
    }

    @Override
    public Set<Long> queryFilterRelationByDeviceIds(Long zoneId, List<Long> deviceIds) {
        StringBuffer sql = new StringBuffer();
        sql.append("from FilterDeviceZoneInfo where zoneId = ? and deviceId in ( ");
        HashMap<Integer, Long> condition = new HashMap<Integer, Long>();
        int index = 0;
        condition.put(index++, zoneId);
        for (int i = 0; i < deviceIds.size(); ++i) {
            condition.put(index++, deviceIds.get(i));
            if (i == 0) {
                sql.append("?");
                continue;
            }
            sql.append(",?");
        }
        sql.append(")");
        List filterDeviceZoneInfos = this.filterDeviceZoneInfoDao.queryByHql(sql.toString(), condition);
        HashSet<Long> filterIds = new HashSet<Long>();
        if (null != filterDeviceZoneInfos && !filterDeviceZoneInfos.isEmpty()) {
            for (FilterDeviceZoneInfo filterDeviceZoneInfo : filterDeviceZoneInfos) {
                filterIds.add(filterDeviceZoneInfo.getFilterId());
            }
        }
        return filterIds;
    }

    @Override
    public List<FilterDeviceZoneInfo> queryGloFilter(Long zoneId, Long deviceId, int direction) {
        HashMap<Integer, Number> condition = new HashMap<Integer, Number>();
        condition.put(0, zoneId);
        condition.put(1, deviceId);
        condition.put(2, direction);
        List filterDeviceZoneInfos = this.filterDeviceZoneInfoDao.queryByHql(" from FilterDeviceZoneInfo where zoneId = ? and deviceId = ? and direction = ? and gloApplyFlag = 1", condition);
        return filterDeviceZoneInfos;
    }

    @Override
    public List<FilterDeviceZoneInfo> quertByZoneIdAndDeviceId(Long zoneId, Long deviceId, int direction) {
        HashMap<Integer, Number> condition = new HashMap<Integer, Number>();
        condition.put(0, zoneId);
        condition.put(1, deviceId);
        condition.put(2, direction);
        List filterDeviceZoneInfos = this.filterDeviceZoneInfoDao.queryByHql(" from FilterDeviceZoneInfo where zoneId = ? and deviceId = ? and direction = ?", condition);
        return filterDeviceZoneInfos;
    }

    @Override
    public List<FilterDeviceZoneInfo> querydeployFilter(Long zoneId, Long deviceId, int direction) {
        HashMap<Integer, Number> condition = new HashMap<Integer, Number>();
        condition.put(0, zoneId);
        condition.put(1, deviceId);
        condition.put(2, direction);
        List filterDeviceZoneInfos = this.filterDeviceZoneInfoDao.queryByHql(" from FilterDeviceZoneInfo where zoneId = ? and deviceId = ? and direction = ? and deleteFlag = 0 and gloApplyFlag = 1", condition);
        return filterDeviceZoneInfos;
    }

    @Override
    public List<FilterDeviceZoneInfo> querydeployedFilterByfilterIdAndDeviceId(Long filterId, Long deviceId, int direction) {
        HashMap<Integer, Number> condition = new HashMap<Integer, Number>();
        condition.put(0, filterId);
        condition.put(1, deviceId);
        condition.put(2, direction);
        List filterDeviceZoneInfos = this.filterDeviceZoneInfoDao.queryByHql(" from FilterDeviceZoneInfo where filterId = ? and deviceId = ? and direction = ? and gloApplyFlag = 1 and deployState = 'SUCCESS'", condition);
        return filterDeviceZoneInfos;
    }

    @Override
    public void saveFilterRelationByDeviceId(FilterDeviceZoneForm fiForm) {
        Long deviceId = fiForm.getDeviceId();
        List<Long> filterIdList = fiForm.getFilterIdList();
        List<Long> filterPreferenceList = fiForm.getFilterPreferenceList();
        if (!this.isNull(filterIdList)) {
            for (int i = 0; i < fiForm.getFilterIdList().size(); ++i) {
                FilterDeviceZoneInfo info = new FilterDeviceZoneInfo();
                List<FilterDeviceZoneInfo> infos = this.filterDeviceZoneInfoDao.getByDeviceIdAndFilterIdAndZoneId(deviceId, filterIdList.get(i), 0L, 1);
                if (null != infos && !infos.isEmpty()) {
                    info = infos.get(0);
                } else {
                    info.setDeviceId(deviceId);
                    info.setFilterId(filterIdList.get(i));
                    info.setZoneId(0L);
                    info.setDirection(1);
                    Long preferecne = this.getPreference(deviceId, fiForm.getZoneId(), fiForm.getDirection());
                    if (preferecne != 0L) {
                        info.setPreference(preferecne + 1L);
                    } else {
                        info.setPreference(filterPreferenceList.get(i));
                    }
                    info.setFilterDefineState(fiForm.getFilterDefineState());
                    info.setDeployState("UNDEPLOY");
                }
                info.setDeleteFlag(0L);
                info.setGloApplyFlag(fiForm.getGloApplyFlag());
                this.filterDeviceZoneInfoDao.createOrUpdate(info);
            }
        }
    }

    private Long getPreference(Long deviceId, Long zoneId, int direction) {
        List<FilterDeviceZoneInfo> list = this.filterDeviceZoneInfoDao.getFilteIds(deviceId, zoneId, direction);
        Long maxPreference = 0L;
        if (null != list && !list.isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                if (maxPreference >= list.get(i).getPreference()) continue;
                maxPreference = list.get(i).getPreference();
            }
        }
        return maxPreference;
    }

    private boolean isNull(List<Long> list) {
        return list.contains(null);
    }

    @Override
    public List<FilterDeviceZoneInfo> queryRelationByDeviceId(Long deviceId) {
        List<FilterDeviceZoneInfo> filterDeviceInfos = this.filterDeviceZoneInfoDao.queryByDeviceId(deviceId);
        return filterDeviceInfos;
    }

    @Override
    public List<FilterDeviceZoneForm> queryNeedDeployData(Long deviceId) {
        ArrayList<FilterDeviceZoneForm> filterDeviceForms = new ArrayList<FilterDeviceZoneForm>();
        List<FilterDeviceZoneInfo> filterDeviceInfos = this.filterDeviceZoneInfoDao.queryNeedDeployData(deviceId);
        if (null != filterDeviceInfos && !filterDeviceInfos.isEmpty()) {
            for (FilterDeviceZoneInfo filterDeviceInfo : filterDeviceInfos) {
                FilterDeviceZoneForm filterDeviceForm = new FilterDeviceZoneForm();
                VsmUtil.getInstance().copyProperties(filterDeviceInfo, filterDeviceForm);
                filterDeviceForms.add(filterDeviceForm);
            }
        }
        return filterDeviceForms;
    }

    @Override
    public List<FilterDeviceZoneInfo> getDeployedDefineForGloByFilterIdAndDeviceId(Long filterId, Long deviceId) {
        return this.filterDeviceZoneInfoDao.getDeployedDefineForGloByFilterIdAndDeviceId(filterId, deviceId);
    }

    @Override
    public void updateGloFilterDeployState(Long filterId, Long deviceId, Long zoneId, boolean deployState) {
        this.filterDeviceZoneInfoDao.updateFilterDeployStateForGlo(deployState, filterId, deviceId, zoneId);
    }

    @Override
    public void updateFilterRelationDeployState(Long filterId, Long deviceId, Long zoneId, String deployState, int gloApplyFlag) {
        this.filterDeviceZoneInfoDao.updateFilterRelationDeployState(deployState, filterId, deviceId, zoneId, gloApplyFlag);
    }

    @Override
    public void updateGloFilterDefineDeployState(Long filterId, Long deviceId, Long zoneId) {
        this.filterDeviceZoneInfoDao.updateFilterDefineDeployStateForGlo(filterId, deviceId, zoneId);
    }

    @Override
    public void delFilterRelationUndoDeploy(Long filterId, Long deviceId, Long zoneId) {
        this.filterDeviceZoneInfoDao.delFilterRelationAferUno(filterId, deviceId, zoneId);
    }

    @Override
    public Long queryFilterPreference(Long filterId, Long deviceId, Long zoneId, int direction) {
        if (this.clusterService.isBelongCluster(deviceId)) {
            AticDeviceNfaCluster aticDeviceNfaCluster = this.clusterService.getClusterByNfaId(deviceId);
            deviceId = aticDeviceNfaCluster.getClusterId();
        }
        return this.filterDeviceZoneInfoDao.queryFilterPerference(filterId, deviceId, zoneId, direction);
    }

    @Override
    public List<FilterDeviceZoneForm> getByFilterId(Long filterId) {
        ArrayList<FilterDeviceZoneForm> filterDeviceZoneForms = new ArrayList<FilterDeviceZoneForm>();
        List<FilterDeviceZoneInfo> filterDeviceZoneInfoList = this.filterDeviceZoneInfoDao.getByFilterId(filterId);
        for (FilterDeviceZoneInfo filterDeviceZoneInfo : filterDeviceZoneInfoList) {
            FilterDeviceZoneForm filterDeviceZoneForm = new FilterDeviceZoneForm();
            ZoneUtil.copyProperties(filterDeviceZoneInfo, filterDeviceZoneForm);
            filterDeviceZoneForms.add(filterDeviceZoneForm);
        }
        return filterDeviceZoneForms;
    }

    @Override
    public List<FilterDeviceZoneForm> queryFilterDirection(Long filterId, Long deviceId, Long zoneId) {
        ArrayList<FilterDeviceZoneForm> filterDeviceZoneForms = new ArrayList<FilterDeviceZoneForm>();
        List<FilterDeviceZoneInfo> filterDeviceZoneInfoList = this.filterDeviceZoneInfoDao.getByDeviceIdAndFilterIdAndZoneId(filterId, deviceId, zoneId);
        for (FilterDeviceZoneInfo filterDeviceZoneInfo : filterDeviceZoneInfoList) {
            FilterDeviceZoneForm filterDeviceZoneForm = new FilterDeviceZoneForm();
            ZoneUtil.copyProperties(filterDeviceZoneInfo, filterDeviceZoneForm);
            filterDeviceZoneForms.add(filterDeviceZoneForm);
        }
        return filterDeviceZoneForms;
    }

    @Override
    public void saveAll(List<FilterDeviceZoneForm> filterDeviceZoneForms) {
        if (!filterDeviceZoneForms.isEmpty()) {
            ArrayList<FilterDeviceZoneInfo> filterDeviceZoneInfos = new ArrayList<FilterDeviceZoneInfo>();
            for (FilterDeviceZoneForm filterDeviceZoneForm : filterDeviceZoneForms) {
                FilterDeviceZoneInfo filterDeviceZoneInfo = new FilterDeviceZoneInfo();
                ZoneUtil.copyProperties(filterDeviceZoneForm, filterDeviceZoneInfo);
                filterDeviceZoneInfos.add(filterDeviceZoneInfo);
            }
            this.filterDeviceZoneInfoDao.saveAll(filterDeviceZoneInfos);
        }
    }

    public FilterDeviceZoneInfoDao getFilterDeviceZoneInfoDao() {
        return this.filterDeviceZoneInfoDao;
    }

    public void setFilterDeviceZoneInfoDao(FilterDeviceZoneInfoDao filterDeviceZoneInfoDao) {
        this.filterDeviceZoneInfoDao = filterDeviceZoneInfoDao;
    }

    public IClusterService getClusterService() {
        return this.clusterService;
    }

    public void setClusterService(IClusterService clusterService) {
        this.clusterService = clusterService;
    }

    @Override
    public List<FilterDeviceZoneForm> queryDeploydDefineFilter(Long deviceId) {
        ArrayList<FilterDeviceZoneForm> filterDeviceZoneForms = new ArrayList<FilterDeviceZoneForm>();
        List<FilterDeviceZoneInfo> filterDeviceZoneInfos = this.filterDeviceZoneInfoDao.queryDeploydDefineFilter(deviceId);
        if (null != filterDeviceZoneInfos && !filterDeviceZoneInfos.isEmpty()) {
            for (FilterDeviceZoneInfo filterDeviceZoneInfo : filterDeviceZoneInfos) {
                FilterDeviceZoneForm filterDeviceZoneForm = new FilterDeviceZoneForm();
                ZoneUtil.copyProperties(filterDeviceZoneInfo, filterDeviceZoneForm);
                filterDeviceZoneForms.add(filterDeviceZoneForm);
            }
        }
        return filterDeviceZoneForms;
    }

    @Override
    public void delteFilterList(Long[] filterIds, Long deviceId) {
        if (null != filterIds && filterIds.length >= 1) {
            for (int i = 0; i < filterIds.length; ++i) {
                Long filterId = filterIds[i];
                List<FilterDeviceZoneInfo> filterDeviceZoneInfos = this.filterDeviceZoneInfoDao.getByDeviceIdAndFilterIdAndZoneId(deviceId, filterId, 0L);
                FilterDeviceZoneInfo filterDeviceZoneInfo = new FilterDeviceZoneInfo();
                if (null != filterDeviceZoneInfos && !filterDeviceZoneInfos.isEmpty()) {
                    filterDeviceZoneInfo = filterDeviceZoneInfos.get(0);
                }
                if (filterDeviceZoneInfo.getDeployState().equalsIgnoreCase("UNDEPLOY")) {
                    this.filterDeviceZoneInfoDao.deleteByFilterIdAndDeviceIdAndZoneId(filterId, deviceId, 0L);
                    continue;
                }
                this.filterDeviceZoneInfoDao.updateDeleteFlag(filterId, deviceId, 0L);
            }
        }
    }
}

