/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.service;

import com.hs.atic.rmi.SysManagerService;
import com.hs.atic.rmi.ZoneCollectorRMIProxy;
import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.atic.sdk.zone.service.IZoneService;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.comm.BatchOperation;
import com.hs.lego.core.sdk.comm.BatchOperationResult;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.secservice.ddos.common.CmdUtil;
import com.hs.vsm.secservice.ddos.common.ErrorMsg2ResKey;
import com.hs.vsm.secservice.ddos.dao.FilterDao;
import com.hs.vsm.secservice.ddos.dao.FilterDeviceZoneInfoDao;
import com.hs.vsm.secservice.ddos.dao.FilterDeviceZoneStatusDao;
import com.hs.vsm.secservice.ddos.dao.NPFilterDao;
import com.hs.vsm.secservice.ddos.dao.ZonePolicyApplyDao;
import com.hs.vsm.secservice.ddos.model.FilterDeviceZoneInfo;
import com.hs.vsm.secservice.ddos.model.FilterDeviceZoneStatusInfo;
import com.hs.vsm.secservice.ddos.model.FilterInfo;
import com.hs.vsm.secservice.ddos.model.HttpFilterInfo;
import com.hs.vsm.secservice.ddos.model.NPFilterInfo;
import com.hs.vsm.secservice.ddos.model.ZonePolicyApplyInfo;
import com.hs.vsm.secservice.ddos.service.data.feature.FilterData;
import com.hs.vsm.secservice.ddos.service.data.feature.FilterZoneData;
import com.hs.vsm.secservice.ddos.service.function.deploy.FilterDeployCtrl;
import com.hs.vsm.secservice.sdk.common.util.ProgressBar;
import com.hs.vsm.secservice.sdk.common.util.VsmUtil;
import com.hs.vsm.secservice.sdk.frame.model.LogicDev;
import com.hs.vsm.secservice.sdk.module.ddos.Constant;
import com.hs.vsm.secservice.sdk.module.ddos.form.FilterDeviceZoneForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.FilterForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.HttpFilterForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneDeviceForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZonePolicyApplyForm;
import com.hs.vsm.secservice.sdk.module.ddos.service.IFilterDeviceZoneInfoService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IFilterService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IHttpFilterService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneDeviceService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZonePolicyApplyService;
import com.huawei.atic.collector.entity.CollectorInfo;
import com.huawei.atic.collector.service.ICollectorService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.device.model.AticDeviceNfaCluster;
import com.huawei.atic.parents.servcice.FilterParentService;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.huawei.atic.secne.sdk.service.IClusterService;
import com.huawei.atic.secservice.sdk.module.ddos.service.ICommonUtilService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FilterServiceImpl
implements IFilterService,
FilterParentService {
    public static final String DEPLOY_STATUS_OF_FAIL = "FAIL";
    private static int filterNumberLimit = 512;
    private static final int FILTER_ID_MIN = 1;
    private static final int FILTER_ID_MAX = 65535;
    private FilterDao dao;
    private NPFilterDao npFilterDao;
    private IHttpFilterService httpFilterService;
    private IAticDeviceService aticDeviceService;
    private ICommonUtilService commonUtilService;
    private IZoneDeviceService zoneDeviceService;
    private IZoneService userService;
    private FilterDeviceZoneInfoDao filterDeviceZoneInfoDao;
    private ZonePolicyApplyDao userPolicyApplyDao;
    private FilterDeviceZoneStatusDao filterDeviceZoneStatusDao;
    private IZonePolicyApplyService zonePolicyService;
    private FilterDeployCtrl filterDeployCtrl;
    private IFilterDeviceZoneInfoService filterDeviceZoneInfoService;
    private Map<String, String> errorMapping = ErrorMsg2ResKey.getInstance().getErrorMsgKeyMapping();
    private IClusterService clusterService;
    private ICollectorService collectorService;
    private ZoneCollectorRMIProxy collectorRMIProxy;
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);

    public Long create(FilterForm form) {
        FilterInfo info = new FilterInfo();
        VsmUtil.getInstance().copyProperties(form, info);
        this.processFilter(info);
        this.dao.saveOrUpdate(info);
        this.addFilterInfos();
        Long pkid = info.getPkid();
        form.setPkid(pkid);
        this.createHttpFilter(form, pkid);
        if (form.isEditGloFilter() || form.isGlobalFilterConfig()) {
            this.saveFilterZoneDeviceForGlo(form);
        } else {
            this.saveFilterZoneDevice(form);
        }
        return pkid;
    }

    public void processFilter(FilterInfo filterInfo) {
        if (filterInfo != null) {
            if (filterInfo.getDeviceType().equalsIgnoreCase("ALL")) {
                filterInfo.setDeviceType("All");
            }
            filterInfo.setFilterType(filterInfo.getFilterType().toUpperCase(Locale.ENGLISH));
        }
    }

    @Override
    public Long create(FilterForm form, ZonePolicyApplyInfo info) {
        FilterInfo filterInfo = new FilterInfo();
        VsmUtil.getInstance().copyProperties(form, filterInfo);
        this.processFilter(filterInfo);
        this.dao.saveOrUpdate(filterInfo);
        this.addFilterInfos();
        Long pkid = filterInfo.getPkid();
        form.setPkid(pkid);
        this.createHttpFilter(form, pkid);
        this.saveFilterZoneDevice(form);
        if (!"UNDEPLOY".equals(info.getFilterState())) {
            info.setFilterState("INCREAMENT_UNDEPLOY");
            this.userPolicyApplyDao.saveOrUpdate(info);
        }
        if (!"UNDEPLOY".equals(info.getDeployState())) {
            info.setDeployState("INCREAMENT_UNDEPLOY");
            this.userPolicyApplyDao.saveOrUpdate(info);
        }
        return pkid;
    }

    public void createOrUpdate(FilterForm form) {
        if (null == form.getPkid()) {
            this.create(form);
        } else {
            this.update(form);
        }
    }

    public void delete(FilterForm form) {
    }

    public void delete(Long id) {
        FilterInfo info = this.dao.get(id);
        if (null == info) {
            this.logger.error((Object)"info is null");
            return;
        }
        List<FilterDeviceZoneInfo> filterDeviceZoneInfos = this.filterDeviceZoneInfoDao.getByFilterId(id);
        HashMap deviceZoneIds = new HashMap();
        for (FilterDeviceZoneInfo finfo : filterDeviceZoneInfos) {
            if (!deviceZoneIds.containsKey(finfo.getDeviceId())) {
                deviceZoneIds.put(finfo.getDeviceId(), new ArrayList());
            }
            ((List)deviceZoneIds.get(finfo.getDeviceId())).add(finfo.getZoneId());
        }
        String systemView = "sy";
        String undoDeployZoneFilterCmd = "undo apply anti-ddos filter name " + info.getFilterName();
        String quitCmd = "q";
        if (!deviceZoneIds.isEmpty()) {
            for (Map.Entry entry : deviceZoneIds.entrySet()) {
                for (Long zoneId : (List)entry.getValue()) {
                    ZoneInfoForm zoneInfoForm = this.userService.getById(zoneId);
                    String zoneViewCmd = "ddos-zone name " + zoneInfoForm.getZoneName();
                    ArrayList<String> deployFilterZoneCmdList = new ArrayList<String>();
                    deployFilterZoneCmdList.add(systemView);
                    deployFilterZoneCmdList.add(zoneViewCmd);
                    deployFilterZoneCmdList.add(undoDeployZoneFilterCmd);
                    deployFilterZoneCmdList.add(quitCmd);
                    CmdUtil.execCmds((Long)entry.getKey(), deployFilterZoneCmdList);
                }
            }
        }
        String undoFilterCmd = "undo filter name " + info.getFilterName();
        for (Map.Entry entry : deviceZoneIds.entrySet()) {
            ArrayList<String> undoFilterCmdList = new ArrayList<String>();
            undoFilterCmdList.add(systemView);
            undoFilterCmdList.add(undoFilterCmd);
            undoFilterCmdList.add(quitCmd);
            CmdUtil.execCmds((Long)entry.getKey(), undoFilterCmdList);
        }
        this.dao.delete(info);
        this.deleteHttpFilterInfo(info);
        this.filterDeviceZoneInfoDao.deleteByFilterId(id);
    }

    private void deleteHttpFilterInfo(FilterInfo info) {
        List<HttpFilterForm> httpFilterFormList = this.httpFilterService.queryByFilterId(info.getPkid());
        if (null != httpFilterFormList) {
            for (HttpFilterForm httpFilterForm : httpFilterFormList) {
                this.httpFilterService.delete(httpFilterForm.getPkid());
            }
        }
    }

    public BatchOperationResult deleteInBatch(List<BatchOperation> boList) {
        BatchOperationResult result = new BatchOperationResult();
        int fail = 0;
        for (BatchOperation bo : boList) {
            try {
                List<FilterDeviceZoneStatusInfo> filterDeviceZoneStatusInfoList = this.filterDeviceZoneStatusDao.getByFilterId(bo.getTargetId());
                if (null != filterDeviceZoneStatusInfoList && !filterDeviceZoneStatusInfoList.isEmpty()) {
                    bo.setErrorCode(670820L);
                    ++fail;
                    continue;
                }
                this.delete(bo.getTargetId());
            }
            catch (RuntimeException e) {
                bo.setErrorCode(630158L);
                ++fail;
            }
        }
        if (fail != boList.size()) {
            this.logger.info((Object)"delete filter ");
            this.addFilterInfos();
        }
        result.setTotalCount(boList.size());
        result.setSucceedCount(boList.size() - fail);
        result.setFailCount(fail);
        result.setResult(boList);
        return result;
    }

    public FilterForm query(Long id) {
        FilterInfo filterInfo = this.dao.get(id);
        FilterForm filterForm = new FilterForm();
        VsmUtil.getInstance().copyProperties(filterInfo, filterForm);
        List<HttpFilterForm> httpFilterFormList = this.httpFilterService.queryByFilterId(id);
        filterForm.setHttpFilterFormList(httpFilterFormList);
        ArrayList<Long> zoneIdList = new ArrayList<Long>();
        ArrayList<Long> deviceIdList = new ArrayList<Long>();
        List<FilterDeviceZoneInfo> filterDeviceZoneInfoList = this.filterDeviceZoneInfoDao.getByFilterId(id);
        for (FilterDeviceZoneInfo filterDeviceZoneInfo : filterDeviceZoneInfoList) {
            if (!zoneIdList.contains(filterDeviceZoneInfo.getZoneId())) {
                zoneIdList.add(filterDeviceZoneInfo.getZoneId());
            }
            if (deviceIdList.contains(filterDeviceZoneInfo.getDeviceId())) continue;
            deviceIdList.add(filterDeviceZoneInfo.getDeviceId());
        }
        filterForm.setZoneIdList(zoneIdList);
        filterForm.setDeviceIdList(deviceIdList);
        filterForm.setFilterDeviceZoneInfos(filterDeviceZoneInfoList);
        return filterForm;
    }

    @Override
    public FilterForm queryForGlo(Long filterId, int globalApplyFlag) {
        FilterInfo filterInfo = this.dao.get(filterId);
        FilterForm filterForm = new FilterForm();
        VsmUtil.getInstance().copyProperties(filterInfo, filterForm);
        List<HttpFilterForm> httpFilterFormList = this.httpFilterService.queryByFilterId(filterId);
        filterForm.setHttpFilterFormList(httpFilterFormList);
        ArrayList<Long> deviceIdList = new ArrayList<Long>();
        List<FilterDeviceZoneInfo> filterDeviceZoneInfoList = this.filterDeviceZoneInfoDao.getByFilterIdForGlo(filterId, globalApplyFlag);
        for (FilterDeviceZoneInfo filterDeviceZoneInfo : filterDeviceZoneInfoList) {
            if (deviceIdList.contains(filterDeviceZoneInfo.getDeviceId())) continue;
            deviceIdList.add(filterDeviceZoneInfo.getDeviceId());
        }
        filterForm.setDeviceIdList(deviceIdList);
        filterForm.setFilterDeviceZoneInfos(filterDeviceZoneInfoList);
        return filterForm;
    }

    public Paging queryByPage(Map<String, String> queryMap, int start, int pageSize) {
        Paging page = this.dao.queryByPage(queryMap, start, pageSize);
        ArrayList<FilterForm> froms = new ArrayList<FilterForm>();
        if (page.getCount() > 0) {
            List infos = page.getData();
            for (FilterInfo info : infos) {
                FilterForm form = new FilterForm();
                VsmUtil.getInstance().copyProperties(info, form);
                froms.add(form);
            }
        }
        page.setData(froms);
        return page;
    }

    public void save(FilterForm form) {
        FilterInfo info = this.tranForm2Info(form);
        this.dao.save(info);
        this.saveHttpFilter(form);
        this.saveFilterZoneDeviceForGlo(form);
    }

    private void saveFilterZoneDevice(FilterForm form) {
        List<Long> zoneIdList = form.getZoneIdList();
        if (null != zoneIdList) {
            for (Long zoneId : zoneIdList) {
                ZonePolicyApplyForm zonePolicyForm = null;
                zonePolicyForm = this.zonePolicyService.queryByZoneId(zoneId);
                if (null == zonePolicyForm || null == zonePolicyForm.getZoneDeviceForms()) continue;
                for (ZoneDeviceForm zoneDeviceForm : zonePolicyForm.getZoneDeviceForms()) {
                    AticDevice aticDevice = this.aticDeviceService.getDeviceByMoid(zoneDeviceForm.getDeviceId().longValue());
                    int deviceType = aticDevice.getDeviceType();
                    String filterDeviceType = form.getDeviceType();
                    if (deviceType == 7) {
                        List nfaClusters = this.clusterService.getBindNfaDevice(Long.valueOf(aticDevice.getMoId()));
                        for (AticDeviceNfaCluster aticDeviceNfaCluster : nfaClusters) {
                            zoneDeviceForm.setDeviceId(aticDeviceNfaCluster.getDeviceId());
                            this.saveDeviceZoneInfo(deviceType, filterDeviceType, zoneDeviceForm, form);
                        }
                        continue;
                    }
                    this.saveDeviceZoneInfo(deviceType, filterDeviceType, zoneDeviceForm, form);
                }
            }
        }
        if (!form.isGlobalFilterConfig()) {
            this.filterDeviceZoneInfoDao.deleteByFilterIdExceptionZoneId(form.getPkid(), zoneIdList);
        }
    }

    private void saveFilterZoneDeviceForGlo(FilterForm form) {
        List<Long> deviceIdList = form.getDeviceIdList();
        if (null != deviceIdList) {
            for (Long deviceId : deviceIdList) {
                AticDevice aticDevice = this.aticDeviceService.getDeviceByMoid(deviceId.longValue());
                int deviceType = aticDevice.getDeviceType();
                String filterDeviceType = form.getDeviceType();
                if (deviceType == 7) {
                    List nfaClusters = this.clusterService.getBindNfaDevice(Long.valueOf(aticDevice.getMoId()));
                    for (AticDeviceNfaCluster aticDeviceNfaCluster : nfaClusters) {
                        ZoneDeviceForm zoneDeviceForm = new ZoneDeviceForm();
                        zoneDeviceForm.setDeviceId(aticDeviceNfaCluster.getDeviceId());
                        zoneDeviceForm.setZoneId(Long.valueOf(0L));
                        this.saveDeviceZoneInfo(deviceType, filterDeviceType, zoneDeviceForm, form);
                    }
                    continue;
                }
                ZoneDeviceForm zoneDeviceForm = new ZoneDeviceForm();
                zoneDeviceForm.setDeviceId(deviceId);
                zoneDeviceForm.setZoneId(Long.valueOf(0L));
                this.saveDeviceZoneInfo(deviceType, filterDeviceType, zoneDeviceForm, form);
            }
        }
    }

    private void saveDeviceZoneInfo(int deviceType, String filterDeviceType, ZoneDeviceForm zoneDeviceForm, FilterForm form) {
        if (null != filterDeviceType && "All".equals(filterDeviceType)) {
            this.createFilterDeviceZoneInfo(zoneDeviceForm, form);
        } else if (null != filterDeviceType && "AntiDDoS".equals(filterDeviceType) && 1 == deviceType) {
            this.createFilterDeviceZoneInfo(zoneDeviceForm, form);
        } else if (null != filterDeviceType && "NFA".equals(filterDeviceType) && (5 == deviceType || 7 == deviceType)) {
            this.createFilterDeviceZoneInfo(zoneDeviceForm, form);
        }
    }

    private void createFilterDeviceZoneInfo(ZoneDeviceForm zoneDeviceForm, FilterForm form) {
        FilterDeviceZoneInfo info = new FilterDeviceZoneInfo();
        info.setDeviceId(zoneDeviceForm.getDeviceId());
        info.setZoneId(zoneDeviceForm.getZoneId());
        info.setFilterId(form.getPkid());
        info.setDirection(form.getDirection());
        info.setGloApplyFlag(form.isDeployApply() ? 1 : 0);
        info.setDeleteFlag(0L);
        if (form.getImportGlobalFilter().booleanValue()) {
            info.setGloApplyFlag(1);
        }
        if (form.isGlobalFilterConfig()) {
            info.setDeployState("UNDEPLOY");
            FilterDeviceZoneInfo filterDeviceZoneInfo = this.filterDeviceZoneInfoDao.getByFilterIdAndDeviceIdAndZoneId(form.getPkid(), info.getDeviceId(), info.getZoneId(), info.getDirection());
            if (null != filterDeviceZoneInfo) {
                info.setFilterDefineState(filterDeviceZoneInfo.getFilterDefineState());
            } else {
                info.setFilterDefineState(false);
            }
            if (null != filterDeviceZoneInfo && filterDeviceZoneInfo.getPreference() != null && filterDeviceZoneInfo.getPreference() != 0L) {
                info.setPreference(filterDeviceZoneInfo.getPreference());
            } else {
                Long preferecne = this.getPreference(info.getDeviceId(), info.getZoneId(), info.getDirection());
                info.setPreference(preferecne + Constant.NUM_1L);
            }
            this.filterDeviceZoneInfoDao.saveForGlo(info);
        } else {
            Long preference = this.filterDeviceZoneInfoDao.queryPreference(info.getDeviceId(), info.getZoneId(), info.getDirection()) + Constant.NUM_1L;
            info.setPreference(preference);
            this.filterDeviceZoneInfoDao.saveForZone(info);
        }
    }

    private Long getPreference(Long deviceId, Long zoneId, int direction) {
        List<FilterDeviceZoneInfo> list = this.filterDeviceZoneInfoDao.getFilteIds(deviceId, zoneId, direction);
        Long maxPreference = 0L;
        if (null != list && !list.isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                if (list.get(i) == null) {
                    return maxPreference;
                }
                if (maxPreference >= list.get(i).getPreference()) continue;
                maxPreference = list.get(i).getPreference();
            }
        }
        return maxPreference;
    }

    private void saveHttpFilter(FilterForm form) {
        List<HttpFilterForm> httpFilterFormList = form.getHttpFilterFormList();
        List<HttpFilterForm> oldHttpFilterFormList = this.httpFilterService.queryByFilterId(form.getPkid());
        if (null != oldHttpFilterFormList && null != httpFilterFormList) {
            for (HttpFilterForm oldHttpFilterForm : oldHttpFilterFormList) {
                boolean isExist = false;
                for (HttpFilterForm httpFilterForm : httpFilterFormList) {
                    if (!oldHttpFilterForm.getPkid().equals(httpFilterForm.getPkid())) continue;
                    isExist = true;
                }
                if (isExist) continue;
                this.httpFilterService.delete(oldHttpFilterForm.getPkid());
            }
        }
        if (null != oldHttpFilterFormList && null == httpFilterFormList) {
            for (HttpFilterForm oldHttpFilterForm : oldHttpFilterFormList) {
                this.httpFilterService.delete(oldHttpFilterForm.getPkid());
            }
        }
        if (null != httpFilterFormList) {
            for (HttpFilterForm httpFilterForm : httpFilterFormList) {
                httpFilterForm.setFilterId(form.getPkid());
                if (httpFilterForm.getPkid() != null) {
                    this.httpFilterService.save(httpFilterForm);
                    continue;
                }
                httpFilterForm.setPkid((Long)this.httpFilterService.create(httpFilterForm));
            }
        }
    }

    private void createHttpFilter(FilterForm form, Long filterId) {
        List<HttpFilterForm> httpFilterFormList = form.getHttpFilterFormList();
        if (null != httpFilterFormList) {
            for (HttpFilterForm httpFilterForm : httpFilterFormList) {
                httpFilterForm.setFilterId(filterId);
                if (httpFilterForm.getPkid() != null) {
                    this.httpFilterService.save(httpFilterForm);
                    continue;
                }
                httpFilterForm.setPkid((Long)this.httpFilterService.create(httpFilterForm));
            }
        }
    }

    public void update(FilterForm form) {
        if (!form.isEditGloFilter()) {
            FilterInfo info = this.tranForm2Info(form);
            this.dao.update(info);
            this.saveHttpFilter(form);
            this.saveFilterZoneDeviceForGlo(form);
        } else if (form.isGlobalFilterConfig() || form.isEditGloFilter()) {
            this.saveFilterZoneDeviceForGlo(form);
        } else {
            this.saveFilterZoneDevice(form);
        }
    }

    private FilterInfo tranForm2Info(FilterForm form) {
        FilterInfo info = null;
        if (null != form) {
            info = new FilterInfo();
            VsmUtil.getInstance().copyProperties(form, info);
        }
        return info;
    }

    public void doDeploy(Long filterId) {
        this.filterDeployCtrl.doDeployWithFilter(filterId, null, null, null, null, false);
    }

    @Override
    public List<FilterDeviceZoneForm> doDeploy(FilterForm filterForm, List<Long> zoneIdList) {
        this.doDeploy(filterForm.getPkid());
        ArrayList<FilterDeviceZoneForm> resultList = new ArrayList<FilterDeviceZoneForm>();
        return resultList;
    }

    @Override
    public Boolean filterNameExsit(Long pkid, String filterName) {
        return this.dao.filterNameExsit(pkid, filterName);
    }

    @Override
    public String checkFilterNumberLimit(FilterForm filterForm) {
        ArrayList<Long> deviceIdList = new ArrayList<Long>();
        List<ZonePolicyApplyForm> zonePolicyFormList = this.zonePolicyService.queryByZoneIds(filterForm.getZoneIdList());
        for (ZonePolicyApplyForm zonePolicyApplyForm : zonePolicyFormList) {
            List<ZoneDeviceForm> zoneDeviceFormList = zonePolicyApplyForm.getZoneDeviceForms();
            for (ZoneDeviceForm zoneDeviceForm : zoneDeviceFormList) {
                if (deviceIdList.contains(zoneDeviceForm.getDeviceId())) continue;
                deviceIdList.add(zoneDeviceForm.getDeviceId());
            }
        }
        for (Long deviceId : deviceIdList) {
            List<FilterDeviceZoneInfo> filterDeviceZoneInfoList = this.filterDeviceZoneInfoDao.getByDeviceIdExceptionFilterId(deviceId, filterForm.getPkid());
            HashMap<String, Integer> keyNnmberMap = new HashMap<String, Integer>();
            if (filterDeviceZoneInfoList.size() >= 10) {
                return String.valueOf(deviceId);
            }
            for (FilterDeviceZoneInfo filterDeviceZoneInfo : filterDeviceZoneInfoList) {
                List<HttpFilterForm> httpFilterFormList = this.httpFilterService.queryByFilterId(filterDeviceZoneInfo.getFilterId());
                for (HttpFilterForm httpFilterForm : httpFilterFormList) {
                    if (keyNnmberMap.containsKey(httpFilterForm.getFilterKey())) {
                        keyNnmberMap.put(httpFilterForm.getFilterKey(), (Integer)keyNnmberMap.get(httpFilterForm.getFilterKey()) + 1);
                        continue;
                    }
                    keyNnmberMap.put(httpFilterForm.getFilterKey(), 1);
                }
            }
            if (null != filterForm.getHttpFilterFormList()) {
                for (HttpFilterForm httpFilterForm : filterForm.getHttpFilterFormList()) {
                    if (keyNnmberMap.containsKey(httpFilterForm.getFilterKey())) {
                        keyNnmberMap.put(httpFilterForm.getFilterKey(), (Integer)keyNnmberMap.get(httpFilterForm.getFilterKey()) + 1);
                        continue;
                    }
                    keyNnmberMap.put(httpFilterForm.getFilterKey(), 1);
                }
            }
            for (Map.Entry entry : keyNnmberMap.entrySet()) {
                if ((Integer)entry.getValue() <= filterNumberLimit) continue;
                return deviceId + "," + (String)entry.getKey();
            }
        }
        return null;
    }

    @Override
    public Long checkFilterNumberLimitByDevice(FilterForm filterForm) {
        ArrayList zoneDeviceFormList = new ArrayList();
        List<FilterDeviceZoneInfo> infoList = null;
        ArrayList<Long> deviceIdList = new ArrayList<Long>();
        List<Long> zoneIdList = filterForm.getZoneIdList();
        ArrayList<Long> filterIdList = new ArrayList<Long>();
        if (filterForm.getPkid() != null) {
            filterIdList.add(filterForm.getPkid());
        }
        if (zoneIdList != null && !zoneIdList.isEmpty()) {
            for (Long zoneId : zoneIdList) {
                zoneDeviceFormList.addAll(this.zoneDeviceService.getByZoneId(zoneId));
            }
        }
        if (!zoneDeviceFormList.isEmpty()) {
            for (ZoneDeviceForm form : zoneDeviceFormList) {
                if (deviceIdList.contains(form.getDeviceId())) continue;
                deviceIdList.add(form.getDeviceId());
            }
        }
        if (!deviceIdList.isEmpty()) {
            for (Long devicdId : deviceIdList) {
                infoList = this.filterDeviceZoneInfoDao.getByDeviceIdExceptionFilterIdGroupByFilterIds(devicdId, filterIdList);
                if (infoList.size() < filterNumberLimit) continue;
                return devicdId;
            }
        }
        return null;
    }

    @Override
    public Long checkFilterNumberLimitByDevice(Long zoneId, List<Long> newFilterIdList, List<Long> deleteFilterIdList) {
        Long deviceId = null;
        List<FilterDeviceZoneInfo> infoList = null;
        List zoneDeviceFormList = this.zoneDeviceService.getByZoneId(zoneId);
        ArrayList<Long> exceptionList = new ArrayList<Long>(newFilterIdList);
        if (zoneDeviceFormList != null && !zoneDeviceFormList.isEmpty()) {
            for (ZoneDeviceForm form : zoneDeviceFormList) {
                deviceId = form.getDeviceId();
                if (deleteFilterIdList != null && !deleteFilterIdList.isEmpty()) {
                    for (Long filterId : deleteFilterIdList) {
                        List<FilterDeviceZoneInfo> tempInfoList = this.filterDeviceZoneInfoDao.getByFilterIdAndDeviceIdExceptZoneId(filterId, deviceId, zoneId);
                        if (!tempInfoList.isEmpty()) continue;
                        exceptionList.add(filterId);
                    }
                }
                infoList = this.filterDeviceZoneInfoDao.getByDeviceIdExceptionFilterIdGroupByFilterIds(deviceId, exceptionList);
                if (newFilterIdList.size() + infoList.size() <= filterNumberLimit) continue;
                return deviceId;
            }
        }
        return null;
    }

    @Override
    public Long checkFilterNumberLimitByZone(FilterForm filterForm) {
        List<Long> zoneIdList = filterForm.getZoneIdList();
        List<FilterDeviceZoneInfo> infoList = null;
        if (zoneIdList != null && !zoneIdList.isEmpty()) {
            for (Long zoneId : zoneIdList) {
                infoList = this.filterDeviceZoneInfoDao.getByZoneIdExceptionFilterIdGroupByFilterId(zoneId, filterForm.getPkid());
                if (infoList == null || infoList.size() < 20) continue;
                return zoneId;
            }
        }
        return null;
    }

    public FilterDao getDao() {
        return this.dao;
    }

    public void setDao(FilterDao dao) {
        this.dao = dao;
    }

    public IHttpFilterService getHttpFilterService() {
        return this.httpFilterService;
    }

    public void setHttpFilterService(IHttpFilterService httpFilterService) {
        this.httpFilterService = httpFilterService;
    }

    public IZoneDeviceService getZoneDeviceService() {
        return this.zoneDeviceService;
    }

    public void setZoneDeviceService(IZoneDeviceService zoneDeviceService) {
        this.zoneDeviceService = zoneDeviceService;
    }

    public IZoneService getUserService() {
        return this.userService;
    }

    public void setUserService(IZoneService userService) {
        this.userService = userService;
    }

    public FilterDeviceZoneInfoDao getFilterDeviceZoneInfoDao() {
        return this.filterDeviceZoneInfoDao;
    }

    public void setFilterDeviceZoneInfoDao(FilterDeviceZoneInfoDao filterDeviceZoneInfoDao) {
        this.filterDeviceZoneInfoDao = filterDeviceZoneInfoDao;
    }

    public ZonePolicyApplyDao getUserPolicyApplyDao() {
        return this.userPolicyApplyDao;
    }

    public void setUserPolicyApplyDao(ZonePolicyApplyDao userPolicyApplyDao) {
        this.userPolicyApplyDao = userPolicyApplyDao;
    }

    public ICommonUtilService getCommonUtilService() {
        return this.commonUtilService;
    }

    public void setCommonUtilService(ICommonUtilService commonUtilService) {
        this.commonUtilService = commonUtilService;
    }

    public IZonePolicyApplyService getZonePolicyService() {
        return this.zonePolicyService;
    }

    public void setZonePolicyService(IZonePolicyApplyService zonePolicyService) {
        this.zonePolicyService = zonePolicyService;
    }

    public FilterDeployCtrl getFilterDeployCtrl() {
        return this.filterDeployCtrl;
    }

    public void setFilterDeployCtrl(FilterDeployCtrl filterDeployCtrl) {
        this.filterDeployCtrl = filterDeployCtrl;
    }

    @Override
    public List<FilterForm> findAll() {
        ArrayList<FilterForm> filterFormList = new ArrayList<FilterForm>();
        List<FilterInfo> filterInfoList = this.getDao().getAllfilterByName();
        if (!filterInfoList.isEmpty()) {
            for (FilterInfo info : filterInfoList) {
                FilterForm filterForm = new FilterForm();
                AticUtil.copyProperties((Object)info, (Object)filterForm);
                filterFormList.add(filterForm);
            }
        }
        return filterFormList;
    }

    @Override
    public List<FilterForm> queryByFilterIds(String filterIds) {
        ArrayList<FilterForm> filterForms = new ArrayList<FilterForm>();
        List<FilterInfo> filterInfos = this.getDao().queryByFilterIds(filterIds);
        for (FilterInfo filterInfo : filterInfos) {
            FilterForm filterForm = new FilterForm();
            VsmUtil.getInstance().copyProperties(filterInfo, filterForm);
            filterForms.add(filterForm);
        }
        return filterForms;
    }

    @Override
    public void updatePreference(List<Long> zoneIdList) {
        if (zoneIdList != null && !zoneIdList.isEmpty()) {
            for (int i = 0; i < zoneIdList.size(); ++i) {
                List<FilterDeviceZoneInfo> infoList = this.filterDeviceZoneInfoDao.queryByZoneId(zoneIdList.get(i));
                if (null == infoList) continue;
                for (int j = 0; j < infoList.size(); ++j) {
                    FilterDeviceZoneInfo info = infoList.get(j);
                    info.setPreference((long)(j + 1) * Constant.NUM_1L);
                    this.filterDeviceZoneInfoDao.save(info);
                }
            }
        }
    }

    public void setAticDeviceService(IAticDeviceService aticDeviceService) {
        this.aticDeviceService = aticDeviceService;
    }

    public IAticDeviceService getAticDeviceService() {
        return this.aticDeviceService;
    }

    @Override
    public List<Integer> getCurExistFilterIds() {
        List<Integer> list = this.dao.queryAllFilterId();
        return list;
    }

    @Override
    public Integer calculationFilterId() {
        List<Integer> list = this.getCurExistFilterIds();
        Integer filterIdValue = 0;
        if (list.isEmpty()) {
            filterIdValue = 1;
            return filterIdValue;
        }
        for (int i = 1; i <= 65535; ++i) {
            if (list.contains(i)) continue;
            filterIdValue = i;
            return filterIdValue;
        }
        return filterIdValue;
    }

    @Override
    public FilterForm queryFilterName(Long underFilterId) {
        if (null == underFilterId) {
            return null;
        }
        FilterForm form = new FilterForm();
        FilterInfo info = this.dao.queryByUnderFilterId(underFilterId);
        if (null == info) {
            return null;
        }
        VsmUtil.getInstance().copyProperties(info, form);
        return form;
    }

    @Override
    public FilterForm queryByName(String filterName) {
        FilterInfo filterInfo = this.dao.queryByName(filterName);
        if (null != filterInfo) {
            FilterForm filterForm = new FilterForm();
            AticUtil.copyProperties((Object)filterInfo, (Object)filterForm);
            return filterForm;
        }
        return null;
    }

    @Override
    public Map<Long, List<String>> doDeployFilter(ProgressBar progressBar, Long deviceId, List<FilterForm> listFilterForms) {
        HashMap<Long, List<String>> filterResult = new HashMap<Long, List<String>>();
        List<HttpFilterForm> httFilterForms = null;
        String errorCode = "--";
        for (FilterForm filterForm : listFilterForms) {
            try {
                httFilterForms = filterForm.getHttpFilterFormList();
                ArrayList<HttpFilterInfo> httFilterInfos = new ArrayList<HttpFilterInfo>();
                for (HttpFilterForm httForm : httFilterForms) {
                    HttpFilterInfo httpInfo = new HttpFilterInfo();
                    VsmUtil.getInstance().copyProperties(httForm, httpInfo);
                    httFilterInfos.add(httpInfo);
                }
                FilterInfo filterInfo = new FilterInfo();
                VsmUtil.getInstance().copyProperties(filterForm, filterInfo);
                FilterData filterData = new FilterData("", null, filterInfo, httFilterInfos);
                ZoneInfoForm zoneInfo = new ZoneInfoForm();
                zoneInfo.setZoneId(0L);
                FilterZoneData filterZoneData = new FilterZoneData(null, null, filterInfo, zoneInfo, 1);
                LogicDev logicDev = new LogicDev();
                logicDev.setDeviceId(deviceId);
                Long zoneId = 0L;
                Long deleteFlag = filterInfo.getDeleteFlag();
                String deployState = filterInfo.getDeployState();
                boolean defineState = filterInfo.isDefineState();
                ArrayList<String> deployResuList = new ArrayList<String>();
                if (deleteFlag != 1L && "SUCCESS".equals(deployState) && defineState) {
                    progressBar.next();
                    continue;
                }
                if (deleteFlag == 1L) {
                    List undoApplyResult = (List)filterZoneData.doUndeploy(logicDev, null);
                    errorCode = this.checkCmdResultList(undoApplyResult);
                    if (!errorCode.equals("--") && !errorCode.equals("")) {
                        deployResuList.add(DEPLOY_STATUS_OF_FAIL.concat("::").concat(DEPLOY_STATUS_OF_FAIL));
                        deployResuList.add("ERRORCODE".concat("::").concat(errorCode));
                        deployResuList.add("filterName::" + filterForm.getFilterName());
                        deployResuList.add("filterId::--");
                        deployResuList.add("preference::--");
                        filterResult.put(filterForm.getPkid(), deployResuList);
                        progressBar.next();
                        continue;
                    }
                    this.filterDeviceZoneInfoService.updateFilterRelationDeployState(filterInfo.getPkid(), deviceId, zoneId, "UNDEPLOY", 0);
                    List doUndeploy = (List)filterData.doUndeploy(logicDev, filterInfo);
                    errorCode = this.checkCmdResultList(doUndeploy);
                    if (errorCode.equals("--") || errorCode.equals("")) {
                        this.filterDeviceZoneInfoService.delFilterRelationUndoDeploy(filterInfo.getPkid(), deviceId, zoneId);
                        this.logger.info((Object)("delete filter define success." + filterInfo.getPkid()));
                    } else {
                        this.logger.warn((Object)("undeploy filter define failed." + filterInfo.getPkid()));
                    }
                } else if (deleteFlag == 0L) {
                    List doResult = (List)filterData.doDeploy(logicDev, filterInfo);
                    errorCode = this.checkCmdResultList(doResult);
                    if (!errorCode.equals("--") && !errorCode.equals("")) {
                        this.filterDeviceZoneInfoService.updateGloFilterDeployState(filterInfo.getPkid(), deviceId, zoneId, false);
                        deployResuList.add(DEPLOY_STATUS_OF_FAIL.concat("::").concat(DEPLOY_STATUS_OF_FAIL));
                        deployResuList.add("ERRORCODE".concat("::").concat(errorCode));
                        deployResuList.add("filterName::" + filterForm.getFilterName());
                        deployResuList.add("filterId::" + filterForm.getFilterId());
                        deployResuList.add("preference::--");
                        filterResult.put(filterForm.getPkid(), deployResuList);
                        progressBar.next();
                        continue;
                    }
                    this.filterDeviceZoneInfoService.updateGloFilterDeployState(filterInfo.getPkid(), deviceId, zoneId, true);
                    filterInfo.setDefineState(true);
                    filterInfo.setDeployApply(true);
                    filterZoneData.setFilterInfo(filterInfo);
                    List doApplyResult = (List)filterZoneData.doDeploy(logicDev, null);
                    errorCode = this.checkCmdResultList(doApplyResult);
                    if (errorCode.equals("--") || errorCode.equals("")) {
                        this.filterDeviceZoneInfoService.updateFilterRelationDeployState(filterInfo.getPkid(), deviceId, zoneId, "SUCCESS", 1);
                    } else {
                        this.filterDeviceZoneInfoService.updateFilterRelationDeployState(filterInfo.getPkid(), deviceId, zoneId, DEPLOY_STATUS_OF_FAIL, 1);
                        deployResuList.add(DEPLOY_STATUS_OF_FAIL.concat("::").concat(DEPLOY_STATUS_OF_FAIL));
                        deployResuList.add("ERRORCODE".concat("::").concat(errorCode));
                        deployResuList.add("filterName::" + filterForm.getFilterName());
                        deployResuList.add("filterId::--");
                        deployResuList.add("preference::" + filterForm.getPreference());
                        filterResult.put(filterForm.getPkid(), deployResuList);
                    }
                }
                progressBar.next();
            }
            catch (LegoCheckedException e) {
                ArrayList<String> catchErrorList = new ArrayList<String>();
                catchErrorList.add(DEPLOY_STATUS_OF_FAIL.concat("::").concat(DEPLOY_STATUS_OF_FAIL));
                catchErrorList.add("ERRORCODE".concat("::").concat(errorCode));
                catchErrorList.add("filterName::" + filterForm.getFilterName());
                catchErrorList.add("filterId::--");
                catchErrorList.add("preference::--");
                filterResult.put(filterForm.getPkid(), catchErrorList);
                progressBar.next();
            }
        }
        return filterResult;
    }

    private String checkCmdResultList(List<String> cmdResultList) {
        int count = 0;
        Iterator<String> iterator = cmdResultList.iterator();
        while (iterator.hasNext()) {
            String resultStringTemp;
            String resultString = resultStringTemp = iterator.next();
            resultString = resultString.toLowerCase(Locale.ENGLISH);
            ++count;
            if ("".equals(resultString)) continue;
            for (Map.Entry<String, String> entry : this.errorMapping.entrySet()) {
                String key = entry.getKey().toLowerCase(Locale.ENGLISH);
                Pattern p = Pattern.compile(key);
                Matcher matcher = p.matcher(resultString);
                if (!matcher.find()) continue;
                if ("lego.err.631003".equals(entry.getValue()) && count == 3) {
                    Pattern p1 = Pattern.compile("-filter-");
                    Matcher matcher1 = p1.matcher(resultString);
                    if (matcher1.find()) continue;
                    return entry.getValue();
                }
                if ("lego.err.631065".equals(entry.getValue())) {
                    return "lego.err.631066";
                }
                if ("lego.err.631042".equals(entry.getValue())) {
                    return "lego.err.631071";
                }
                return entry.getValue();
            }
        }
        return "--";
    }

    @Override
    public FilterForm queryRelationFilter(Long id, int direction) {
        FilterForm filterForm = new FilterForm();
        ArrayList<Long> zoneIdList = new ArrayList<Long>();
        List<FilterDeviceZoneInfo> filterDeviceZoneInfoList = this.filterDeviceZoneInfoDao.getByFilterId(id, direction);
        if (null != filterDeviceZoneInfoList && !filterDeviceZoneInfoList.isEmpty()) {
            for (FilterDeviceZoneInfo filterDeviceZoneInfo : filterDeviceZoneInfoList) {
                if (zoneIdList.contains(filterDeviceZoneInfo.getZoneId())) continue;
                zoneIdList.add(filterDeviceZoneInfo.getZoneId());
            }
            FilterInfo filterInfo = this.dao.get(id);
            VsmUtil.getInstance().copyProperties(filterInfo, filterForm);
            List<HttpFilterForm> httpFilterFormList = this.httpFilterService.queryByFilterId(id);
            filterForm.setHttpFilterFormList(httpFilterFormList);
            filterForm.setZoneIdList(zoneIdList);
            filterForm.setFilterDeviceZoneInfos(filterDeviceZoneInfoList);
        }
        return filterForm;
    }

    @Override
    public void addFilterInfos() {
        List collectorList = this.collectorService.listCollector(null);
        for (CollectorInfo collectorInfo : collectorList) {
            int flag = 0;
            while (!this.addFilterInfosByCollectorId(collectorInfo.getId()) && 3 >= ++flag) {
            }
        }
    }

    private boolean addFilterInfosByCollectorId(Long collectorId) {
        CollectorInfo cInfo = this.collectorService.getCollectorInfo(collectorId.longValue());
        if (null == cInfo) {
            throw new LegoCheckedException(201L);
        }
        SysManagerService sysManagerService = this.collectorRMIProxy.getSysManagerService(cInfo.getIpAddress());
        if (null != sysManagerService) {
            HashMap<Integer, String> filterMap = new HashMap<Integer, String>();
            List<FilterInfo> filterInfos = this.dao.getAllfilterByName();
            for (FilterInfo filterInfo : filterInfos) {
                filterMap.put(filterInfo.getFilterId(), filterInfo.getFilterName());
            }
            List<NPFilterInfo> npFilterInfosList = this.npFilterDao.getAllFilter();
            for (NPFilterInfo npFilterInfo : npFilterInfosList) {
                Integer npFilterId = npFilterInfo.getFilterIndex() + 80000;
                filterMap.put(npFilterId, npFilterInfo.getFilterName());
            }
            this.logger.info((Object)("send collector filterMap.size:" + filterMap.size()));
            try {
                sysManagerService.setFilterInfos(filterMap);
            }
            catch (LegoCheckedException legoCheckedException) {
                this.logger.error((Object)("save Collector FilterInfos failed! collectorId:" + collectorId + "List<FilterInfo>: " + filterInfos.toString()), (Throwable)legoCheckedException);
                return false;
            }
            catch (Exception exception) {
                this.logger.error((Object)("save Collector FilterInfos failed! collectorId:" + collectorId + "List<FilterInfo>: " + filterInfos.toString()), (Throwable)exception);
                return false;
            }
        }
        return true;
    }

    public static int getFilterNumberLimit() {
        return filterNumberLimit;
    }

    public static void setFilterNumberLimit(int filterNumberLimit) {
        FilterServiceImpl.filterNumberLimit = filterNumberLimit;
    }

    public IFilterDeviceZoneInfoService getFilterDeviceZoneInfoService() {
        return this.filterDeviceZoneInfoService;
    }

    public void setFilterDeviceZoneInfoService(IFilterDeviceZoneInfoService filterDeviceZoneInfoService) {
        this.filterDeviceZoneInfoService = filterDeviceZoneInfoService;
    }

    public Map<String, String> getErrorMapping() {
        return this.errorMapping;
    }

    public void setErrorMapping(Map<String, String> errorMapping) {
        this.errorMapping = errorMapping;
    }

    public FilterDeviceZoneStatusDao getFilterDeviceZoneStatusDao() {
        return this.filterDeviceZoneStatusDao;
    }

    public void setFilterDeviceZoneStatusDao(FilterDeviceZoneStatusDao filterDeviceZoneStatusDao) {
        this.filterDeviceZoneStatusDao = filterDeviceZoneStatusDao;
    }

    public IClusterService getClusterService() {
        return this.clusterService;
    }

    public void setClusterService(IClusterService clusterService) {
        this.clusterService = clusterService;
    }

    public ICollectorService getCollectorService() {
        return this.collectorService;
    }

    public void setCollectorService(ICollectorService collectorService) {
        this.collectorService = collectorService;
    }

    public ZoneCollectorRMIProxy getCollectorRMIProxy() {
        return this.collectorRMIProxy;
    }

    public void setCollectorRMIProxy(ZoneCollectorRMIProxy collectorRMIProxy) {
        this.collectorRMIProxy = collectorRMIProxy;
    }

    public Map<Integer, String> getFilterMap() {
        HashMap<Integer, String> filterMap = new HashMap<Integer, String>();
        List<FilterForm> filterForms = this.findAll();
        for (FilterForm filterForm : filterForms) {
            filterMap.put(filterForm.getFilterId(), filterForm.getFilterName());
        }
        return filterMap;
    }

    @Override
    public void doDeployFilterDstIp(FilterForm filter) {
        this.filterDeployCtrl.doDeployWithFilterDstIp(filter);
    }

    @Override
    public void doUndeployFilterDstIp(FilterForm filter) {
        this.filterDeployCtrl.doUnDeployWithFilterDstIp(filter);
    }

    @Override
    public List<FilterForm> queryGloFilterTemplate() {
        ArrayList<FilterForm> filterList = new ArrayList<FilterForm>();
        List<FilterInfo> gloFilterTemp = this.dao.queryGloFilter();
        for (FilterInfo filterInfo : gloFilterTemp) {
            FilterForm filterForm = new FilterForm();
            VsmUtil.getInstance().copyProperties(filterInfo, filterForm);
            filterList.add(filterForm);
        }
        return filterList;
    }

    public NPFilterDao getNpFilterDao() {
        return this.npFilterDao;
    }

    public void setNpFilterDao(NPFilterDao npFilterDao) {
        this.npFilterDao = npFilterDao;
    }

    @Override
    public void saveFilterZone(FilterForm form) {
        FilterInfo info = new FilterInfo();
        VsmUtil.getInstance().copyProperties(form, info);
        this.processFilter(info);
        this.dao.saveOrUpdate(info);
        Long pkid = info.getPkid();
        form.setPkid(pkid);
        this.createHttpFilter(form, pkid);
        this.saveFilterZoneDevice(form);
    }
}

