/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.service;

import com.hs.atic.sdk.util.StringUtils;
import com.hs.lego.core.sdk.comm.BatchOperation;
import com.hs.lego.core.sdk.comm.BatchOperationResult;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.vsm.secservice.ddos.dao.HttpFilterDao;
import com.hs.vsm.secservice.ddos.model.HttpFilterInfo;
import com.hs.vsm.secservice.sdk.common.util.VsmUtil;
import com.hs.vsm.secservice.sdk.module.ddos.form.HttpFilterForm;
import com.hs.vsm.secservice.sdk.module.ddos.service.IHttpFilterService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.dao.DataAccessException;

public class HttpFilterServiceImpl
implements IHttpFilterService {
    private HttpFilterDao dao;

    public Long create(HttpFilterForm form) {
        Long pkid = -1L;
        if (null != form) {
            HttpFilterInfo info = new HttpFilterInfo();
            String filterContent = form.getFilterContent();
            if (!StringUtils.isEmpty(filterContent) && (filterContent.startsWith("include    ") || filterContent.startsWith("equal    "))) {
                String[] httpContent = filterContent.split("    ", 2);
                StringBuffer sBuffer = new StringBuffer();
                sBuffer.append(httpContent[0]).append("    ");
                sBuffer.append(httpContent[1].replaceAll(" ", "\\\\x20"));
                form.setFilterContent(sBuffer.toString());
            }
            VsmUtil.getInstance().copyProperties(form, info);
            pkid = (Long)this.dao.create(info);
        }
        return pkid;
    }

    public void createOrUpdate(HttpFilterForm form) {
    }

    public void delete(HttpFilterForm form) {
    }

    public void delete(Long id) {
        HttpFilterInfo info = (HttpFilterInfo)this.dao.query(id);
        if (info != null) {
            this.dao.delete(id);
        }
    }

    public BatchOperationResult deleteInBatch(List<BatchOperation> boList) {
        return null;
    }

    public HttpFilterForm query(Long id) {
        return null;
    }

    public Paging queryByPage(Map<String, String> queryMap, int start, int pageSize) {
        return null;
    }

    public void save(HttpFilterForm form) {
        if (null != form) {
            HttpFilterInfo info = new HttpFilterInfo();
            String filterContent = form.getFilterContent();
            if (!StringUtils.isEmpty(filterContent) && (filterContent.startsWith("include    ") || filterContent.startsWith("equal    "))) {
                String[] httpContent = filterContent.split("    ", 2);
                StringBuffer sBuffer = new StringBuffer();
                sBuffer.append(httpContent[0]).append("    ");
                sBuffer.append(httpContent[1].replaceAll(" ", "\\\\x20"));
                form.setFilterContent(sBuffer.toString());
            }
            VsmUtil.getInstance().copyProperties(form, info);
            this.dao.save(info);
        }
    }

    @Override
    public List<HttpFilterForm> queryByFilterId(Long filterId) {
        List<HttpFilterInfo> httpFilterInfoList = this.dao.queryByFilterId(filterId);
        ArrayList<HttpFilterForm> httpFilterFormList = new ArrayList<HttpFilterForm>();
        for (HttpFilterInfo httpFilterInfo : httpFilterInfoList) {
            HttpFilterForm httpFilterForm = new HttpFilterForm();
            VsmUtil.getInstance().copyProperties(httpFilterInfo, httpFilterForm);
            httpFilterFormList.add(httpFilterForm);
        }
        return httpFilterFormList;
    }

    @Override
    public List<HttpFilterForm> queryByFilterIds(String filterIds) {
        ArrayList<HttpFilterForm> httpFilterFormList = new ArrayList<HttpFilterForm>();
        List<HttpFilterInfo> httpFilterInfoList = this.dao.queryByFilterIds(filterIds);
        for (HttpFilterInfo httpFilterInfo : httpFilterInfoList) {
            HttpFilterForm httpFilterForm = new HttpFilterForm();
            VsmUtil.getInstance().copyProperties(httpFilterInfo, httpFilterForm);
            httpFilterFormList.add(httpFilterForm);
        }
        return httpFilterFormList;
    }

    @Override
    public HttpFilterForm queryByFilterContent(String filterContent, String filterId) {
        HttpFilterForm httpFilterForm = new HttpFilterForm();
        HttpFilterInfo httpFilterInfo = this.dao.queryByFilterContent(filterContent, filterId);
        VsmUtil.getInstance().copyProperties(httpFilterInfo, httpFilterForm);
        return httpFilterForm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchOperationResult batchAddFilter(List<HttpFilterForm> httpFilterList) {
        BatchOperationResult result = new BatchOperationResult();
        int fail = 0;
        ArrayList<BatchOperation> batchOperationList = new ArrayList<BatchOperation>();
        for (HttpFilterForm httpFilterForm : httpFilterList) {
            HttpFilterServiceImpl httpFilterServiceImpl = this;
            synchronized (httpFilterServiceImpl) {
                BatchOperation bo = new BatchOperation();
                Long filterId = httpFilterForm.getFilterId();
                String filterContent = httpFilterForm.getFilterContent();
                bo.setTargetName(filterContent);
                batchOperationList.add(bo);
                HttpFilterForm filterForm = this.queryByFilterContent(filterContent, String.valueOf(filterId));
                if (filterContent.equalsIgnoreCase(filterForm.getFilterContent())) {
                    ++fail;
                    bo.setTargetName(filterContent);
                    bo.setErrorCode(670708L);
                    continue;
                }
                try {
                    this.save(httpFilterForm);
                }
                catch (DataAccessException e) {
                    ++fail;
                    bo.setErrorCode(670708L);
                }
            }
        }
        result.setResult(batchOperationList);
        result.setFailCount(fail);
        result.setTotalCount(batchOperationList.size());
        result.setSucceedCount(batchOperationList.size() - fail);
        return result;
    }

    public void update(HttpFilterForm form) {
        if (null != form) {
            HttpFilterInfo info = new HttpFilterInfo();
            String filterContent = form.getFilterContent();
            if (!StringUtils.isEmpty(filterContent) && (filterContent.startsWith("include    ") || filterContent.startsWith("equal    "))) {
                String[] httpContent = filterContent.split("    ", 2);
                StringBuffer sBuffer = new StringBuffer();
                sBuffer.append(httpContent[0]).append("    ");
                sBuffer.append(httpContent[1].replaceAll(" ", "\\\\x20"));
                form.setFilterContent(sBuffer.toString());
            }
            VsmUtil.getInstance().copyProperties(form, info);
            this.dao.update(info);
        }
    }

    public HttpFilterDao getDao() {
        return this.dao;
    }

    public void setDao(HttpFilterDao dao) {
        this.dao = dao;
    }

    @Override
    public List<HttpFilterForm> queryFilterContent(String filerKey, String filterId) {
        ArrayList<HttpFilterForm> httpFilterFormList = new ArrayList<HttpFilterForm>();
        List<HttpFilterInfo> httpFilterInfoList = this.dao.queryFilterContent(filerKey, filterId);
        for (HttpFilterInfo httpFilterInfo : httpFilterInfoList) {
            HttpFilterForm httpFilterForm = new HttpFilterForm();
            VsmUtil.getInstance().copyProperties(httpFilterInfo, httpFilterForm);
            httpFilterFormList.add(httpFilterForm);
        }
        return httpFilterFormList;
    }

    @Override
    public void queryAndDeleteByFilterId(Long filterId) {
        List<HttpFilterInfo> httpFilterInfoList = this.dao.queryByFilterId(filterId);
        for (HttpFilterInfo info : httpFilterInfoList) {
            if (info == null) continue;
            this.dao.delete(info.getPkid());
        }
    }

    @Override
    public List<String> queryByFilterIdAndFilterKey(long filterId, String filterKey) {
        List<HttpFilterInfo> queryByFilterIdAndFilterKey = this.dao.queryByFilterIdAndFilterKey(filterId, filterKey);
        ArrayList<String> dstIps = new ArrayList<String>();
        for (HttpFilterInfo httpFilterInfo : queryByFilterIdAndFilterKey) {
            dstIps.add(httpFilterInfo.getFilterContent());
        }
        return dstIps;
    }
}

