/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.service;

import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.comm.BatchOperation;
import com.hs.lego.core.sdk.comm.BatchOperationResult;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.secservice.ddos.dao.NPFilterDao;
import com.hs.vsm.secservice.ddos.dao.NPFilterDeviceInfoDao;
import com.hs.vsm.secservice.ddos.dao.NPFilterDeviceStatusDao;
import com.hs.vsm.secservice.ddos.dao.NPFilterRuleDao;
import com.hs.vsm.secservice.ddos.model.NPFilterDeviceInfo;
import com.hs.vsm.secservice.ddos.model.NPFilterDeviceStatusInfo;
import com.hs.vsm.secservice.ddos.model.NPFilterInfo;
import com.hs.vsm.secservice.ddos.model.NPFilterRuleInfo;
import com.hs.vsm.secservice.ddos.service.npfilter.data.NPFilterDeployCtrl;
import com.hs.vsm.secservice.ddos.service.npfilter.data.NPFilterUnDeployCtrl;
import com.hs.vsm.secservice.sdk.common.util.ProgressBar;
import com.hs.vsm.secservice.sdk.module.ddos.form.NPFilterDeviceForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.NPFilterDeviceStatusForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.NPFilterForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.NPFilterRuleForm;
import com.hs.vsm.secservice.sdk.module.ddos.service.IFilterService;
import com.hs.vsm.secservice.sdk.module.ddos.service.INpFilterService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class NpFilterServiceImpl
implements INpFilterService {
    private static final int FILTER_ID_MIN = 1;
    private static final int FILTER_ID_MAX = 800;
    private static final int FILTER_DEVICE_MAX = 32;
    private static final String TCP_FLAG_NONE = "--";
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private NPFilterDao npFilterDao;
    private NPFilterDeviceInfoDao npFilterDeviceInfoDao;
    private NPFilterDeviceStatusDao npFilterDeviceStatusDao;
    private NPFilterRuleDao npFilterRuleDao;
    private NPFilterDeployCtrl npFilterDeployCtrl;
    private NPFilterUnDeployCtrl npFilterUnDeployCtrl;
    private IFilterService filterService;

    public NPFilterDao getNpFilterDao() {
        return this.npFilterDao;
    }

    public void setNpFilterDao(NPFilterDao npFilterDao) {
        this.npFilterDao = npFilterDao;
    }

    public NPFilterDeviceInfoDao getNpFilterDeviceInfoDao() {
        return this.npFilterDeviceInfoDao;
    }

    public void setNpFilterDeviceInfoDao(NPFilterDeviceInfoDao npFilterDeviceInfoDao) {
        this.npFilterDeviceInfoDao = npFilterDeviceInfoDao;
    }

    public NPFilterDeviceStatusDao getNpFilterDeviceStatusDao() {
        return this.npFilterDeviceStatusDao;
    }

    public void setNpFilterDeviceStatusDao(NPFilterDeviceStatusDao npFilterDeviceStatusDao) {
        this.npFilterDeviceStatusDao = npFilterDeviceStatusDao;
    }

    public NPFilterRuleDao getNpFilterRuleDao() {
        return this.npFilterRuleDao;
    }

    public void setNpFilterRuleDao(NPFilterRuleDao npFilterRuleDao) {
        this.npFilterRuleDao = npFilterRuleDao;
    }

    public NPFilterDeployCtrl getNpFilterDeployCtrl() {
        return this.npFilterDeployCtrl;
    }

    public void setNpFilterDeployCtrl(NPFilterDeployCtrl npFilterDeployCtrl) {
        this.npFilterDeployCtrl = npFilterDeployCtrl;
    }

    public NPFilterUnDeployCtrl getNpFilterUnDeployCtrl() {
        return this.npFilterUnDeployCtrl;
    }

    public void setNpFilterUnDeployCtrl(NPFilterUnDeployCtrl npFilterUnDeployCtrl) {
        this.npFilterUnDeployCtrl = npFilterUnDeployCtrl;
    }

    public IFilterService getFilterService() {
        return this.filterService;
    }

    public void setFilterService(IFilterService filterService) {
        this.filterService = filterService;
    }

    @Override
    public Paging queryByPage(Map<String, String> conditionMap, int start, int pageSize) {
        return this.npFilterDao.qeuryByPage(conditionMap, start, pageSize);
    }

    @Override
    public void saveNpFilter(NPFilterForm npFilterForm) {
        Long oldCrc;
        Long newCrc;
        List<NPFilterDeviceStatusInfo> npFilterStatusInfoList;
        NPFilterInfo npFilterInfo = null;
        if (null != npFilterForm.getId()) {
            npFilterInfo = this.npFilterDao.getById(npFilterForm.getId());
            npFilterInfo.setFilterAction(npFilterForm.getFilterAction());
            npFilterInfo.setFilterAlert(npFilterForm.getFilterAlert());
            this.npFilterDao.createOrUpdate(npFilterInfo);
        } else {
            npFilterInfo = new NPFilterInfo();
            AticUtil.copyProperties((Object)npFilterForm, (Object)npFilterInfo);
            npFilterInfo.setFilterIndex(this.calculationFilterId());
            npFilterInfo = (NPFilterInfo)this.npFilterDao.save(npFilterInfo);
        }
        this.filterService.addFilterInfos();
        Long filterId = npFilterInfo.getId();
        npFilterForm.setId(filterId);
        NPFilterRuleForm npFilterRuleForm = npFilterForm.getNpFilterRuleForm();
        NPFilterRuleInfo npFilterRuleInfo = new NPFilterRuleInfo();
        AticUtil.copyProperties((Object)npFilterRuleForm, (Object)npFilterRuleInfo);
        if (this.isNUllOrBlank(npFilterRuleInfo.getDestinationIp())) {
            npFilterRuleInfo.setDestinationIp(null);
        }
        if (this.isNUllOrBlank(npFilterRuleInfo.getDestinationPort())) {
            npFilterRuleInfo.setDestinationPort(null);
        }
        if (this.isNUllOrBlank(npFilterRuleInfo.getSourceIp())) {
            npFilterRuleInfo.setSourceIp(null);
        }
        if (this.isNUllOrBlank(npFilterRuleInfo.getSourcePort())) {
            npFilterRuleInfo.setSourcePort(null);
        }
        if (this.isNUllOrBlank(npFilterRuleInfo.getTcpFlag()) || TCP_FLAG_NONE.equals(npFilterRuleInfo.getTcpFlag())) {
            npFilterRuleInfo.setTcpFlag(null);
        }
        npFilterRuleInfo.setFilterId(filterId);
        this.npFilterRuleDao.createOrUpdate(npFilterRuleInfo);
        this.npFilterDeviceInfoDao.deleteByFilterId(filterId);
        List<NPFilterDeviceForm> npFilterDeviceFromList = npFilterForm.getNpFilterDeviceFormList();
        if (null != npFilterDeviceFromList) {
            for (NPFilterDeviceForm npFilterDeviceFrom : npFilterDeviceFromList) {
                NPFilterDeviceInfo npFilterDeviceInfo = new NPFilterDeviceInfo();
                AticUtil.copyProperties((Object)npFilterDeviceFrom, (Object)npFilterDeviceInfo);
                npFilterDeviceInfo.setFilterId(filterId);
                this.npFilterDeviceInfoDao.createOrUpdate(npFilterDeviceInfo);
            }
        }
        if (!(npFilterStatusInfoList = this.npFilterDeviceStatusDao.getInfoByFilterId(filterId)).isEmpty() && !(newCrc = npFilterForm.getBasicCalcCrc()).equals(oldCrc = npFilterStatusInfoList.get(0).getDeployCrc())) {
            this.npFilterDeviceStatusDao.updateDeployStatusByFilterId(filterId, "PARTDEPLOY");
        }
    }

    @Override
    public Map<Long, Set<Long>> deployNpFilter(Long filterId, Long progressBarId, ProgressBar progressBar, Long adminId) {
        return this.npFilterDeployCtrl.doDeployWithFilter(filterId, progressBarId, progressBar, adminId);
    }

    @Override
    public void unDeployNpFilter(List<Long> filterIdList, Long progressBarId, ProgressBar progressBar, Long adminId) {
        this.npFilterUnDeployCtrl.doUnDeployWithFilter(filterIdList, progressBarId, progressBar, adminId);
    }

    @Override
    public boolean saveNpFilterStatus(NPFilterDeviceStatusForm statusForm) {
        NPFilterDeviceStatusInfo npFilterDeviceStatus = new NPFilterDeviceStatusInfo();
        AticUtil.copyProperties((Object)statusForm, (Object)npFilterDeviceStatus);
        this.npFilterDeviceStatusDao.saveNpFilterDeviceStatus(npFilterDeviceStatus);
        return true;
    }

    @Override
    public NPFilterForm queryById(Long pkId) {
        NPFilterForm npFilterForm = new NPFilterForm();
        NPFilterRuleForm npFilterRuleForm = new NPFilterRuleForm();
        ArrayList<NPFilterDeviceForm> npFilterDeviceFormList = new ArrayList<NPFilterDeviceForm>();
        NPFilterInfo npFilterInfo = this.npFilterDao.getById(pkId);
        List<NPFilterDeviceInfo> npFilterDeviceList = this.npFilterDeviceInfoDao.getByFilterId(pkId);
        for (NPFilterDeviceInfo npFilterDeviceInfo : npFilterDeviceList) {
            NPFilterDeviceForm deviceForm = new NPFilterDeviceForm();
            AticUtil.copyProperties((Object)npFilterDeviceInfo, (Object)deviceForm);
            NPFilterDeviceStatusInfo devStatusInfo = this.npFilterDeviceStatusDao.queryByDeviceFilterId(npFilterDeviceInfo.getDeviceId(), npFilterDeviceInfo.getFilterId());
            if (null != devStatusInfo.getId()) {
                deviceForm.setDeployState(devStatusInfo.getDeployState());
            }
            deviceForm.setDeployState(devStatusInfo.getDeployState());
            deviceForm.setErrorCode(devStatusInfo.getErrorCode());
            deviceForm.setErrorParam(devStatusInfo.getErrorParam());
            npFilterDeviceFormList.add(deviceForm);
        }
        NPFilterRuleInfo npFilterRuleInfo = this.npFilterRuleDao.queryByFilterId(pkId);
        AticUtil.copyProperties((Object)npFilterInfo, (Object)npFilterForm);
        AticUtil.copyProperties((Object)npFilterRuleInfo, (Object)npFilterRuleForm);
        if (null != npFilterRuleInfo.getPacketStartLength() && null != npFilterRuleInfo.getPacketEndLength()) {
            npFilterRuleForm.setPacketLength(npFilterRuleInfo.getPacketStartLength() + "-" + npFilterRuleInfo.getPacketEndLength());
        }
        npFilterForm.setNpFilterDeviceFormList(npFilterDeviceFormList);
        npFilterForm.setNpFilterRuleForm(npFilterRuleForm);
        return npFilterForm;
    }

    @Override
    public Integer calculationFilterId() {
        List<Integer> list = this.getCurExistFilterIds();
        Integer filterIdValue = 0;
        if (list.isEmpty()) {
            filterIdValue = 1;
            return filterIdValue;
        }
        for (int i = 1; i <= 800; ++i) {
            if (list.contains(i)) continue;
            filterIdValue = i;
            return filterIdValue;
        }
        return filterIdValue;
    }

    public List<Integer> getCurExistFilterIds() {
        List<Integer> list = this.npFilterDao.queryAllFilterIndex();
        return list;
    }

    @Override
    public boolean queryByName(String npFilterName, Long filterId) {
        List<NPFilterInfo> queryByNpFilterList = this.npFilterDao.queryByNpFilterName(npFilterName, filterId);
        return null != queryByNpFilterList && !queryByNpFilterList.isEmpty();
    }

    @Override
    public List<NPFilterRuleForm> queryAllNpFilterRule() {
        ArrayList<NPFilterRuleForm> npFilterRuleFormList = new ArrayList<NPFilterRuleForm>();
        List npFilterRuleInfoList = this.npFilterRuleDao.queryAll();
        if (null != npFilterRuleInfoList && !npFilterRuleInfoList.isEmpty()) {
            for (NPFilterRuleInfo npFilterRuleInfo : npFilterRuleInfoList) {
                NPFilterRuleForm ruleForm = new NPFilterRuleForm();
                AticUtil.copyProperties((Object)npFilterRuleInfo, (Object)ruleForm);
                npFilterRuleFormList.add(ruleForm);
            }
            return npFilterRuleFormList;
        }
        return new ArrayList<NPFilterRuleForm>();
    }

    @Override
    public List<NPFilterForm> queryAllNpFilterExcludeFilterId(Long filterId) {
        ArrayList<NPFilterForm> resultList = new ArrayList<NPFilterForm>();
        List<NPFilterInfo> npFIlterInfoList = this.npFilterDao.queryAllInfoExcludeFilterId(filterId);
        for (NPFilterInfo info : npFIlterInfoList) {
            NPFilterForm filterForm = new NPFilterForm();
            AticUtil.copyProperties((Object)info, (Object)filterForm);
            NPFilterRuleInfo ruleInfo = this.npFilterRuleDao.queryByFilterId(info.getId());
            NPFilterRuleForm ruleForm = new NPFilterRuleForm();
            AticUtil.copyProperties((Object)ruleInfo, (Object)ruleForm);
            filterForm.setNpFilterRuleForm(ruleForm);
            resultList.add(filterForm);
        }
        return resultList;
    }

    @Override
    public boolean checkNpFilterNumberLimit() {
        int npFilterCount = this.npFilterDao.getCountNpFilter();
        return npFilterCount >= 800;
    }

    @Override
    public boolean checkNpFilterDeviceNumberLimit(Long deviceId, Long filterId) {
        List<NPFilterDeviceInfo> npFilterDeviceList = this.npFilterDeviceInfoDao.queryNpFilterByDeviceIdNotFilterId(deviceId, filterId);
        return npFilterDeviceList.size() >= 32;
    }

    @Override
    public BatchOperationResult deleteInBatch(List<BatchOperation> boList) {
        BatchOperationResult result = new BatchOperationResult();
        int fail = 0;
        for (BatchOperation bo : boList) {
            Long filterId = bo.getTargetId();
            try {
                List<NPFilterDeviceStatusInfo> statusInfoList = this.npFilterDeviceStatusDao.getInfoByFilterId(filterId);
                if (!statusInfoList.isEmpty()) {
                    bo.setErrorCode(670821L);
                    ++fail;
                    continue;
                }
                this.npFilterDao.deleteById(filterId);
                this.npFilterRuleDao.deleteByFilterId(filterId);
            }
            catch (RuntimeException e) {
                bo.setErrorCode(670822L);
                ++fail;
            }
        }
        result.setTotalCount(boList.size());
        result.setSucceedCount(boList.size() - fail);
        result.setFailCount(fail);
        result.setResult(boList);
        return result;
    }

    private boolean isNUllOrBlank(String value) {
        return null == value || "".equals(value.trim());
    }

    @Override
    public NPFilterForm queryNPFilterFormByfilterId(long filterId) {
        Integer filterIdStrIntger = null;
        try {
            String filterIdStr = String.valueOf(filterId);
            filterIdStrIntger = Integer.valueOf(filterIdStr);
        }
        catch (Exception e) {
            this.logger.error((Object)("Long type conversion integer type failed; filterId = " + filterId));
        }
        if (filterIdStrIntger == null) {
            return null;
        }
        NPFilterForm npFilterForm = new NPFilterForm();
        NPFilterInfo npFilterInfo = this.npFilterDao.getByFilterIndex(filterIdStrIntger);
        if (npFilterInfo != null) {
            AticUtil.copyProperties((Object)npFilterInfo, (Object)npFilterForm);
            return npFilterForm;
        }
        return null;
    }

    @Override
    public List<NPFilterForm> getAllNpFilter() {
        ArrayList<NPFilterForm> filterForms = new ArrayList<NPFilterForm>();
        List<NPFilterInfo> filterInfos = this.npFilterDao.getAllFilter();
        for (NPFilterInfo filterInfo : filterInfos) {
            NPFilterForm filterForm = new NPFilterForm();
            AticUtil.copyProperties((Object)filterInfo, (Object)filterForm);
            filterForms.add(filterForm);
        }
        return filterForms;
    }
}

