/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.service;

import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.atic.sdk.zone.service.IZoneService;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.secservice.ddos.dao.ServiceLearningParamDao;
import com.hs.vsm.secservice.ddos.dao.ZoneDeviceDao;
import com.hs.vsm.secservice.ddos.model.ServiceLearningInfo;
import com.hs.vsm.secservice.ddos.model.ServiceLearningParamInfo;
import com.hs.vsm.secservice.ddos.model.ZoneDeviceInfo;
import com.hs.vsm.secservice.ddos.scheduler.ServiceLearningThread;
import com.hs.vsm.secservice.ddos.service.data.feature.ServiceLearningData;
import com.hs.vsm.secservice.sdk.common.util.VsmUtil;
import com.hs.vsm.secservice.sdk.module.ddos.form.ServiceLearningParamForm;
import com.hs.vsm.secservice.sdk.module.ddos.service.IServiceLearningParamService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.huawei.atic.secservice.sdk.module.ddos.service.ICommonUtilService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class ServiceLearningParamServiceImpl
implements IServiceLearningParamService {
    private static final int STOP = 2;
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private ServiceLearningParamDao serviceLearningParamDao;
    private ServiceLearningThread serviceLearningThread;
    private ServiceLearningData serviceLearningData;
    private ZoneDeviceDao zoneDeviceDao;
    private IAticDeviceService aticDeviceService;
    private ICommonUtilService commonUtilService;
    private IZoneService zoneService;

    private ServiceLearningParamInfo converToInfo(ServiceLearningParamForm form) {
        if (form == null) {
            return null;
        }
        ServiceLearningParamInfo info = new ServiceLearningParamInfo();
        VsmUtil.getInstance().copyProperties(form, info);
        return info;
    }

    @Override
    public void create(ServiceLearningParamForm form) {
        this.serviceLearningParamDao.create(this.converToInfo(form));
    }

    @Override
    public Long createOrUpdate(ServiceLearningParamForm form) {
        this.serviceLearningParamDao.createOrUpdate(this.converToInfo(form));
        ServiceLearningParamForm serviceLearningParamForm = this.queryByZoneId(form.getZoneId());
        if (serviceLearningParamForm != null) {
            return serviceLearningParamForm.getId();
        }
        return null;
    }

    @Override
    public void updateServiceParamStatus(Long zoneId) {
        HashMap<Integer, String> condition = new HashMap<Integer, String>();
        String hsql = "update ServiceLearningParamInfo set taskStatus = 0 where zoneId= ? ";
        condition.put(0, String.valueOf(zoneId));
        this.serviceLearningParamDao.executeHql(hsql, condition);
    }

    private ServiceLearningParamForm converToForm(ServiceLearningParamInfo info) {
        ServiceLearningParamForm form = new ServiceLearningParamForm();
        if (info != null) {
            VsmUtil.getInstance().copyProperties(info, form);
        }
        return form;
    }

    @Override
    public ServiceLearningParamForm queryByZoneId(String zoneId) {
        HashMap<Integer, String> condition = new HashMap<Integer, String>();
        condition.put(0, zoneId);
        List serviceLearningParamInfos = this.serviceLearningParamDao.queryByHql("from com.hs.vsm.secservice.ddos.model.ServiceLearningParamInfo as paramInfo where paramInfo.zoneId = ? ", condition);
        if (serviceLearningParamInfos != null && !serviceLearningParamInfos.isEmpty()) {
            return this.converToForm((ServiceLearningParamInfo)serviceLearningParamInfos.get(0));
        }
        return null;
    }

    @Override
    public void deployStartupCommand(ServiceLearningParamForm serviceLearningParamForm) {
        this.serviceLearningThread.addTask(serviceLearningParamForm);
    }

    @Override
    public void deplyStopCommand(Long zoneId) {
        boolean flag = this.serviceLearningThread.deleteTask(String.valueOf(zoneId));
        if (flag) {
            List<ServiceLearningInfo> zoneDeviceInfoList = this.queryServiceLearningInfo(zoneId);
            if (null != zoneDeviceInfoList) {
                for (ServiceLearningInfo sLearningInfo : zoneDeviceInfoList) {
                    this.serviceLearningData.excuteStopCommandSingle(sLearningInfo);
                }
            } else {
                this.logger.info((Object)("deplyStopCommand(), zoneDeviceInfoList is null, zoneId = " + zoneId));
            }
        }
    }

    private List<ServiceLearningInfo> queryServiceLearningInfo(Long zoneId) {
        ServiceLearningParamForm form = this.queryByZoneId(String.valueOf(zoneId));
        ZoneInfoForm zoneInfoForm = this.zoneService.getById(zoneId);
        List<ZoneDeviceInfo> zoneDeviceInfoList = this.zoneDeviceDao.getByZoneId(zoneId);
        if (zoneDeviceInfoList.isEmpty()) {
            return null;
        }
        ArrayList<ServiceLearningInfo> servicesinfos = new ArrayList<ServiceLearningInfo>();
        for (ZoneDeviceInfo info : zoneDeviceInfoList) {
            long deviceId = info.getDeviceId();
            AticDevice device = this.aticDeviceService.getDeviceByMoid(deviceId);
            if (device.getDeviceType() != 1) continue;
            String deviceIp = device.getIpAddress();
            ServiceLearningInfo serviceLearningInfo = new ServiceLearningInfo();
            serviceLearningInfo.setDeployStatus(2);
            serviceLearningInfo.setDeviceId(deviceId);
            serviceLearningInfo.setZoneType(zoneInfoForm.getZoneType());
            serviceLearningInfo.setRate(form.getAlertRate());
            serviceLearningInfo.setStartTime(form.getStartupTime());
            serviceLearningInfo.setStopTime(form.getStopTime());
            serviceLearningInfo.setZoneId(zoneId);
            serviceLearningInfo.setZoneName(zoneInfoForm.getZoneName());
            serviceLearningInfo.setTaskStatus(form.getTaskStatus());
            serviceLearningInfo.setTopObj(form.getTopObj());
            serviceLearningInfo.setDeviceIp(deviceIp);
            serviceLearningInfo.setDeviceName(device.getName());
            serviceLearningInfo.setConfirmType(form.getConfirmType());
            if (!this.isSupportLearnCommand(serviceLearningInfo)) continue;
            servicesinfos.add(serviceLearningInfo);
            this.logger.info((Object)("add device learnning task" + this.getcleanedMessage(serviceLearningInfo.toString())));
        }
        return servicesinfos;
    }

    private boolean isSupportLearnCommand(ServiceLearningInfo info) {
        return this.commonUtilService.isSupportSrvLearning(info.getDeviceIp());
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    @Override
    public void deleteServiceLearningTask(Long zoneId) {
        ServiceLearningParamForm serviceLearningParamForm = this.queryByZoneId(String.valueOf(zoneId));
        if (null != serviceLearningParamForm) {
            try {
                this.serviceLearningParamDao.delete(serviceLearningParamForm.getId());
                this.logger.info((Object)("delete servicelearn task success when delete zone !!![zoneid:" + zoneId + "]"));
            }
            catch (Exception e) {
                this.logger.error((Object)"delete servicelearn task failure when delete zone !!!", (Throwable)e);
            }
            try {
                this.serviceLearningThread.removeTaskForZoneChange(serviceLearningParamForm);
            }
            catch (Exception e) {
                this.logger.error((Object)"remove  servicelearn task from memory failure when delete zone !!!", (Throwable)e);
            }
        }
    }

    @Override
    public void stopServiceLearningTask(Long zoneId) {
        ServiceLearningParamForm serviceLearningParamForm = this.queryByZoneId(String.valueOf(zoneId));
        if (null != serviceLearningParamForm) {
            try {
                this.updateServiceParamStatus(zoneId);
                this.logger.info((Object)("delete servicelearn task success when delpoy zone !!![zoneid:" + zoneId + "]"));
            }
            catch (Exception e) {
                this.logger.error((Object)"delete servicelearn task failure when delete zone !!!", (Throwable)e);
            }
            try {
                this.serviceLearningThread.removeTaskForZoneChange(serviceLearningParamForm);
            }
            catch (Exception e) {
                this.logger.error((Object)"remove  servicelearn task from memory failure when delete zone !!!", (Throwable)e);
            }
        }
    }

    @Override
    public void stopServiceLearnintTaskByDevice(Long zoneId, Set<Long> devices) {
        this.serviceLearningThread.stopServiceLearnintTaskByDevice(zoneId, devices);
    }

    @Override
    public List<ServiceLearningParamForm> getSrvLearningTaskByDev(long devId) {
        List<ServiceLearningParamInfo> infos = this.serviceLearningParamDao.getSrvLearningTaskByDev(devId);
        ArrayList<ServiceLearningParamForm> forms = new ArrayList<ServiceLearningParamForm>();
        if (null == infos) {
            return forms;
        }
        for (ServiceLearningParamInfo info : infos) {
            ServiceLearningParamForm form = new ServiceLearningParamForm();
            VsmUtil.getInstance().copyProperties(info, form);
            forms.add(form);
        }
        return forms;
    }

    public ServiceLearningParamDao getServiceLearningParamDao() {
        return this.serviceLearningParamDao;
    }

    public void setServiceLearningParamDao(ServiceLearningParamDao serviceLearningParamDao) {
        this.serviceLearningParamDao = serviceLearningParamDao;
    }

    public ServiceLearningThread getServiceLearningThread() {
        return this.serviceLearningThread;
    }

    public void setServiceLearningThread(ServiceLearningThread serviceLearningThread) {
        this.serviceLearningThread = serviceLearningThread;
    }

    public ServiceLearningData getServiceLearningData() {
        return this.serviceLearningData;
    }

    public void setServiceLearningData(ServiceLearningData serviceLearningData) {
        this.serviceLearningData = serviceLearningData;
    }

    public ZoneDeviceDao getZoneDeviceDao() {
        return this.zoneDeviceDao;
    }

    public void setZoneDeviceDao(ZoneDeviceDao zoneDeviceDao) {
        this.zoneDeviceDao = zoneDeviceDao;
    }

    public IAticDeviceService getAticDeviceService() {
        return this.aticDeviceService;
    }

    public void setAticDeviceService(IAticDeviceService aticDeviceService) {
        this.aticDeviceService = aticDeviceService;
    }

    public ICommonUtilService getCommonUtilService() {
        return this.commonUtilService;
    }

    public void setCommonUtilService(ICommonUtilService commonUtilService) {
        this.commonUtilService = commonUtilService;
    }

    public IZoneService getZoneService() {
        return this.zoneService;
    }

    public void setZoneService(IZoneService zoneService) {
        this.zoneService = zoneService;
    }
}

