/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.service;

import com.hs.lego.core.sdk.comm.BatchOperation;
import com.hs.lego.core.sdk.comm.BatchOperationResult;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.vsm.secservice.ddos.dao.ZoneDeviceDeployStatusDao;
import com.hs.vsm.secservice.ddos.model.ZoneDeviceDeployStatusInfo;
import com.hs.vsm.secservice.sdk.common.util.VsmUtil;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneDeviceDeployStatusForm;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneDeviceDeployStatusService;
import com.huawei.atic.device.model.AticDeviceNfaCluster;
import com.huawei.atic.secne.sdk.service.IClusterService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ZoneDeviceDeployStatusServiceImpl
implements IZoneDeviceDeployStatusService {
    private ZoneDeviceDeployStatusDao zoneDeviceDeployStatusDao;
    private IClusterService clusterService;

    public ZoneDeviceDeployStatusDao getZoneDeviceDeployStatusDao() {
        return this.zoneDeviceDeployStatusDao;
    }

    public void setZoneDeviceDeployStatusDao(ZoneDeviceDeployStatusDao zoneDeviceDeployStatusDao) {
        this.zoneDeviceDeployStatusDao = zoneDeviceDeployStatusDao;
    }

    public IClusterService getClusterService() {
        return this.clusterService;
    }

    public void setClusterService(IClusterService clusterService) {
        this.clusterService = clusterService;
    }

    @Override
    public List<ZoneDeviceDeployStatusForm> queryByZoneId(Long zoneId) {
        ArrayList<ZoneDeviceDeployStatusForm> formList = new ArrayList<ZoneDeviceDeployStatusForm>();
        List<ZoneDeviceDeployStatusInfo> infoList = this.zoneDeviceDeployStatusDao.queryByZoneId(zoneId);
        if (null != infoList) {
            for (ZoneDeviceDeployStatusInfo info : infoList) {
                ZoneDeviceDeployStatusForm form = new ZoneDeviceDeployStatusForm();
                VsmUtil.getInstance().copyProperties(info, form);
                formList.add(form);
            }
        }
        return formList;
    }

    @Override
    public List<ZoneDeviceDeployStatusForm> queryAllByZoneId(Long zoneId) {
        ArrayList<ZoneDeviceDeployStatusForm> formList = new ArrayList<ZoneDeviceDeployStatusForm>();
        List<ZoneDeviceDeployStatusInfo> infoList = this.zoneDeviceDeployStatusDao.queryByZoneId2(zoneId);
        for (ZoneDeviceDeployStatusInfo info : infoList) {
            ZoneDeviceDeployStatusForm form = new ZoneDeviceDeployStatusForm();
            VsmUtil.getInstance().copyProperties(info, form);
            formList.add(form);
        }
        return formList;
    }

    public Long create(ZoneDeviceDeployStatusForm form) {
        Long pkid = null;
        if (null != form) {
            ZoneDeviceDeployStatusInfo info = new ZoneDeviceDeployStatusInfo();
            VsmUtil.getInstance().copyProperties(form, info);
            pkid = (Long)this.zoneDeviceDeployStatusDao.create(info);
        }
        return pkid;
    }

    public void createOrUpdate(ZoneDeviceDeployStatusForm form) {
        this.save(form);
    }

    public void delete(Long id) {
        this.zoneDeviceDeployStatusDao.delete(id);
    }

    public void delete(ZoneDeviceDeployStatusForm form) {
        if (null != form) {
            this.delete(form.getId());
        }
    }

    public BatchOperationResult deleteInBatch(List<BatchOperation> boList) {
        return null;
    }

    public ZoneDeviceDeployStatusForm query(Long id) {
        ZoneDeviceDeployStatusForm form = new ZoneDeviceDeployStatusForm();
        ZoneDeviceDeployStatusInfo info = (ZoneDeviceDeployStatusInfo)this.zoneDeviceDeployStatusDao.query(id);
        VsmUtil.getInstance().copyProperties(info, form);
        return form;
    }

    public Paging queryByPage(Map<String, String> queryMap, int start, int pageSize) {
        return null;
    }

    public void save(ZoneDeviceDeployStatusForm form) {
        if (null != form) {
            ZoneDeviceDeployStatusInfo info = new ZoneDeviceDeployStatusInfo();
            VsmUtil.getInstance().copyProperties(form, info);
            this.zoneDeviceDeployStatusDao.create(info);
        }
    }

    public void update(ZoneDeviceDeployStatusForm form) {
        this.save(form);
    }

    @Override
    public void deleteByZoneId(long zoneId) {
        this.zoneDeviceDeployStatusDao.deleteByZoneId(zoneId);
    }

    @Override
    public void deleteByDeviceId(long deviceId) {
        this.zoneDeviceDeployStatusDao.deleteByDeviceId(deviceId);
    }

    @Override
    public void updateDeviceIdByZoneId(Long zoneId, Long lastTimeDeviceId, Long deviceId) {
        this.zoneDeviceDeployStatusDao.updateDeviceIdByZoneId(zoneId, lastTimeDeviceId, deviceId);
    }

    @Override
    public void deleteByDeviceIdAndZoneId(long deviceId, long zoneId) {
        this.zoneDeviceDeployStatusDao.deleteByDeviceIdAndZoneId(deviceId, zoneId);
    }

    @Override
    public ZoneDeviceDeployStatusForm getByZoneIdAndDeviceId(Long zoneId, Long deviceId) {
        List<ZoneDeviceDeployStatusInfo> zoneDeviceDeployStatusInfoList = this.zoneDeviceDeployStatusDao.getByZoneIdAndDeviceId(zoneId, deviceId);
        if (zoneDeviceDeployStatusInfoList != null && !zoneDeviceDeployStatusInfoList.isEmpty()) {
            ZoneDeviceDeployStatusForm zoneDeviceDeployStatusForm = new ZoneDeviceDeployStatusForm();
            VsmUtil.getInstance().copyProperties(zoneDeviceDeployStatusInfoList.get(0), zoneDeviceDeployStatusForm);
            return zoneDeviceDeployStatusForm;
        }
        return null;
    }

    @Override
    public List<Long> getDevByZone4Secutity(Long zoneId, Boolean isAdmin, Long userId) {
        ArrayList<Long> result = new ArrayList<Long>();
        List<ZoneDeviceDeployStatusInfo> list = this.zoneDeviceDeployStatusDao.queryByZoneId4Secutity(zoneId, isAdmin, userId);
        if (list != null) {
            for (ZoneDeviceDeployStatusInfo info : list) {
                AticDeviceNfaCluster tempcluster;
                Long deviceId = info.getDeviceId();
                if (this.clusterService.isBelongCluster(deviceId) && null != (tempcluster = this.clusterService.getClusterByNfaId(deviceId))) {
                    deviceId = tempcluster.getClusterId();
                }
                if (result.contains(deviceId)) continue;
                result.add(deviceId);
            }
        }
        return result;
    }

    @Override
    public void deleteByDeployType(Long zoneId, int deployType) {
        this.zoneDeviceDeployStatusDao.deleteNfaDeployType(zoneId, deployType);
    }

    @Override
    public List<ZoneDeviceDeployStatusForm> getAllStatus() {
        List all = this.zoneDeviceDeployStatusDao.getAll();
        ArrayList<ZoneDeviceDeployStatusForm> allStatus = new ArrayList<ZoneDeviceDeployStatusForm>();
        if (null != all && !all.isEmpty()) {
            for (ZoneDeviceDeployStatusInfo zoneDeviceDeployStatusInfo : all) {
                ZoneDeviceDeployStatusForm form = new ZoneDeviceDeployStatusForm();
                VsmUtil.getInstance().copyProperties(zoneDeviceDeployStatusInfo, form);
                allStatus.add(form);
            }
        }
        return allStatus;
    }

    @Override
    public List<ZoneDeviceDeployStatusInfo> queryPolicyDeployResult(Long zoneId) {
        List<ZoneDeviceDeployStatusInfo> infoList = this.zoneDeviceDeployStatusDao.queryPolicyResultByZoneId(zoneId);
        return infoList;
    }
}

