/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.service;

import com.hs.atic.rmi.ZoneCollectorRMIProxy;
import com.hs.atic.rmi.ZoneState;
import com.hs.atic.rmi.ZoneStateService;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.comm.BatchOperation;
import com.hs.lego.core.sdk.comm.BatchOperationResult;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.secservice.ddos.dao.ZoneDeviceDao;
import com.hs.vsm.secservice.ddos.dao.ZonePolicyApplyDao;
import com.hs.vsm.secservice.ddos.model.ZoneDeviceInfo;
import com.hs.vsm.secservice.sdk.common.util.VsmUtil;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneDeviceForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZonePolicyApplyForm;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneDeviceService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZonePolicyApplyService;
import com.huawei.atic.collector.entity.CollectorInfo;
import com.huawei.atic.collector.service.ICollectorDeviceService;
import com.huawei.atic.collector.service.ICollectorService;
import com.huawei.atic.parents.servcice.IZoneDeviceParentService;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ZoneDeviceServiceImpl
implements IZoneDeviceService,
IZoneDeviceParentService {
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private ZoneDeviceDao zoneDeviceDao;
    private IZonePolicyApplyService zonePolicyApplyService;
    private ICollectorDeviceService collectorDeviceService;
    private ICollectorService collectorService;
    private ZoneCollectorRMIProxy collectorRMIProxy;
    private ZonePolicyApplyDao userPolicyApplyDao;

    public List<ZoneDeviceForm> queryZoneDeviceFormsByZoneID(Long id) {
        ArrayList<ZoneDeviceForm> forms = new ArrayList<ZoneDeviceForm>();
        List<ZoneDeviceInfo> infos = this.zoneDeviceDao.getByZoneId(id);
        for (ZoneDeviceInfo info : infos) {
            ZoneDeviceForm form = new ZoneDeviceForm();
            VsmUtil.getInstance().copyProperties(info, form);
            forms.add(form);
        }
        return forms;
    }

    public List<ZoneDeviceForm> queryZoneDeviceFormsByZoneID(Long id, long userId, boolean isAdmin) {
        ArrayList<ZoneDeviceForm> forms = new ArrayList<ZoneDeviceForm>();
        List<ZoneDeviceInfo> infos = this.zoneDeviceDao.getByZoneId(id, userId, isAdmin);
        for (ZoneDeviceInfo info : infos) {
            ZoneDeviceForm form = new ZoneDeviceForm();
            VsmUtil.getInstance().copyProperties(info, form);
            forms.add(form);
        }
        return forms;
    }

    public List<ZoneDeviceForm> queryByZoneIdExpDevId(Long zoneId, Long devId) {
        ArrayList<ZoneDeviceForm> forms = new ArrayList<ZoneDeviceForm>();
        List<ZoneDeviceInfo> infos = this.zoneDeviceDao.getByZoneId(zoneId);
        for (ZoneDeviceInfo info : infos) {
            if (info.getDeviceId().equals(devId)) continue;
            ZoneDeviceForm form = new ZoneDeviceForm();
            VsmUtil.getInstance().copyProperties(info, form);
            forms.add(form);
        }
        return forms;
    }

    public Long create(ZoneDeviceForm form) {
        Long pkid = null;
        if (null != form) {
            ZoneDeviceInfo info = new ZoneDeviceInfo();
            VsmUtil.getInstance().copyProperties(form, info);
            this.zoneDeviceDao.save(info);
            pkid = info.getId();
        }
        return pkid;
    }

    public void createOrUpdate(ZoneDeviceForm form) {
        if (null != form) {
            ZoneDeviceInfo info = new ZoneDeviceInfo();
            VsmUtil.getInstance().copyProperties(form, info);
            this.zoneDeviceDao.saveOrUpdate(info);
        }
    }

    public List<Long> findPkIdByZoneIdAndDeviceId(Long zoneId, List<Long> deviceIds) {
        if (!deviceIds.isEmpty()) {
            return this.zoneDeviceDao.findPkIdByZoneIdAndDeviceId(zoneId, deviceIds);
        }
        return null;
    }

    public ZoneDeviceForm findZoneDeviceFormByZoneIdAndDeviceId(Long zoneId, Long deviceId) {
        return this.zoneDeviceDao.findZoneDeviceFormByZoneIdAndDeviceId(zoneId, deviceId);
    }

    public void deleteByDeviceId(Long deviceId) {
        this.zoneDeviceDao.deleteByDeviceId(deviceId);
    }

    public void delete(Long zoneId) {
        this.zoneDeviceDao.deleteByZoneId(zoneId);
    }

    public void delete(ZoneDeviceForm form) {
    }

    public BatchOperationResult deleteInBatch(List<BatchOperation> boList) {
        return null;
    }

    public ZoneDeviceForm query(Long id) {
        return null;
    }

    public Paging queryByPage(Map<String, String> queryMap, int start, int pageSize) {
        return null;
    }

    public void save(ZoneDeviceForm form) {
    }

    public void update(ZoneDeviceForm form) {
        if (null != form) {
            ZoneDeviceInfo info = new ZoneDeviceInfo();
            VsmUtil.getInstance().copyProperties(form, info);
            this.getZoneDeviceDao().update(info);
        }
    }

    public List<Long> getZonesByDevId(Long devId) {
        return this.zoneDeviceDao.getByDevId(devId);
    }

    public Long getDefaultZoneIdByDevId(Long deviceId) {
        return this.zoneDeviceDao.getDefaultZoneIdByDevId(deviceId);
    }

    public Long getDefaultZoneIdByDevIdToSecne(Long deviceId) {
        return this.zoneDeviceDao.getDefaultZoneIdByDevId(deviceId);
    }

    public List<Long> getDeviceIdsByZoneId(Long zoneId) {
        return this.zoneDeviceDao.getDeviceIdsByZoneId(zoneId);
    }

    public List<ZoneDeviceForm> getByZoneId(Long zoneId) {
        List<ZoneDeviceInfo> zoneDeviceInfoTempList = this.zoneDeviceDao.getByZoneId(zoneId);
        ArrayList<ZoneDeviceForm> zoneDeviceFormReturnList = new ArrayList<ZoneDeviceForm>();
        if (!zoneDeviceInfoTempList.isEmpty()) {
            int j = zoneDeviceInfoTempList.size();
            for (int i = 0; i < j; ++i) {
                ZoneDeviceInfo zoneDeviceInfoTemp = zoneDeviceInfoTempList.get(i);
                ZoneDeviceForm zoneDeviceFormTemp = new ZoneDeviceForm();
                VsmUtil.getInstance().copyProperties(zoneDeviceInfoTemp, zoneDeviceFormTemp);
                zoneDeviceFormReturnList.add(zoneDeviceFormTemp);
            }
        }
        return zoneDeviceFormReturnList;
    }

    public List<ZoneDeviceForm> getByDeviceId(Long deviceId) {
        List<ZoneDeviceInfo> zoneDeviceInfoTempList = this.zoneDeviceDao.getByDeviceId(deviceId);
        ArrayList<ZoneDeviceForm> zoneDeviceFormReturnList = new ArrayList<ZoneDeviceForm>();
        if (!zoneDeviceInfoTempList.isEmpty()) {
            int j = zoneDeviceInfoTempList.size();
            for (int i = 0; i < j; ++i) {
                ZoneDeviceInfo zoneDeviceInfoTemp = zoneDeviceInfoTempList.get(i);
                ZoneDeviceForm zoneDeviceFormTemp = new ZoneDeviceForm();
                VsmUtil.getInstance().copyProperties(zoneDeviceInfoTemp, zoneDeviceFormTemp);
                zoneDeviceFormReturnList.add(zoneDeviceFormTemp);
            }
        }
        return zoneDeviceFormReturnList;
    }

    public void updateDeviceIdByZoneId(Long zoneId, Long lastTimeDeviceId, Long deviceId) {
        this.zoneDeviceDao.updateDeviceIdByZoneId(zoneId, lastTimeDeviceId, deviceId);
    }

    public void deleteByDeviceIdAndZoneId(long deviceId, long zoneId) {
        this.zoneDeviceDao.deleteByDeviceIdAndZoneId(deviceId, zoneId);
    }

    public ZoneDeviceForm getByZoneIdAndDeviceid(Long zoneId, Long deviceId) {
        List<ZoneDeviceInfo> zoneDeviceInfoList = this.zoneDeviceDao.getByZoneIdAndDevId(zoneId, deviceId);
        if (!zoneDeviceInfoList.isEmpty()) {
            ZoneDeviceForm zoneDeviceForm = new ZoneDeviceForm();
            VsmUtil.getInstance().copyProperties(zoneDeviceInfoList.get(0), zoneDeviceForm);
            return zoneDeviceForm;
        }
        return null;
    }

    public void notifyZoneUpdateState(List<Long> zoneIdList) {
        if (null != zoneIdList && !zoneIdList.isEmpty()) {
            for (Long zoneId : zoneIdList) {
                ZonePolicyApplyForm zonePolicyApplyForm = this.zonePolicyApplyService.queryByZoneId(zoneId);
                List<ZoneDeviceForm> deviceIdList = null;
                if (zonePolicyApplyForm != null) {
                    deviceIdList = zonePolicyApplyForm.getZoneDeviceForms();
                }
                if (null == deviceIdList) continue;
                for (ZoneDeviceForm device : deviceIdList) {
                    ZoneStateService zoneStateService;
                    Long collectorId = this.collectorDeviceService.getCollectorIdByDevId(device.getDeviceId());
                    if (null == collectorId) continue;
                    String collectorIp = null;
                    CollectorInfo info = this.collectorService.getCollectorInfo(collectorId.longValue());
                    if (info != null && info.getStatus() == 1) {
                        collectorIp = info.getIpAddress();
                    }
                    if (null == collectorIp || null == (zoneStateService = this.collectorRMIProxy.getZoneStateService(collectorIp))) continue;
                    ZoneState state = new ZoneState();
                    state.setZoneId(zoneId);
                    state.setDeviceIp(device.getDeviceIp());
                    try {
                        int zoneState = zoneStateService.getZoneState(state);
                        this.logger.info((Object)("zoneState is " + zoneState));
                        String abnormalState = "NORMAL";
                        if (zoneState == 2) {
                            abnormalState = "ALERTED";
                            this.userPolicyApplyDao.updateAbnormalState(zoneId, abnormalState);
                            continue;
                        }
                        if (zoneState != 3) continue;
                        abnormalState = "ATTACKED";
                        this.userPolicyApplyDao.updateAbnormalState(zoneId, abnormalState);
                    }
                    catch (RemoteException e) {
                        this.logger.error((Object)"getZoneState is error", (Throwable)e);
                        throw new LegoCheckedException(101L, (Throwable)e);
                    }
                }
            }
        }
    }

    public List<ZoneDeviceForm> queryAllDeviceAssociatedZone() {
        List<ZoneDeviceInfo> zoneDeviceInfoTempList = this.zoneDeviceDao.queryAllDeviceAssociatedZone();
        ArrayList<ZoneDeviceForm> zoneDeviceFormReturnList = new ArrayList<ZoneDeviceForm>();
        if (!zoneDeviceInfoTempList.isEmpty()) {
            int j = zoneDeviceInfoTempList.size();
            for (int i = 0; i < j; ++i) {
                ZoneDeviceInfo zoneDeviceInfoTemp = zoneDeviceInfoTempList.get(i);
                ZoneDeviceForm zoneDeviceFormTemp = new ZoneDeviceForm();
                VsmUtil.getInstance().copyProperties(zoneDeviceInfoTemp, zoneDeviceFormTemp);
                zoneDeviceFormReturnList.add(zoneDeviceFormTemp);
            }
        }
        return zoneDeviceFormReturnList;
    }

    public ZoneDeviceDao getZoneDeviceDao() {
        return this.zoneDeviceDao;
    }

    public void setZoneDeviceDao(ZoneDeviceDao zoneDeviceDao) {
        this.zoneDeviceDao = zoneDeviceDao;
    }

    public IZonePolicyApplyService getZonePolicyApplyService() {
        return this.zonePolicyApplyService;
    }

    public void setZonePolicyApplyService(IZonePolicyApplyService zonePolicyApplyService) {
        this.zonePolicyApplyService = zonePolicyApplyService;
    }

    public ICollectorDeviceService getCollectorDeviceService() {
        return this.collectorDeviceService;
    }

    public void setCollectorDeviceService(ICollectorDeviceService collectorDeviceService) {
        this.collectorDeviceService = collectorDeviceService;
    }

    public ICollectorService getCollectorService() {
        return this.collectorService;
    }

    public void setCollectorService(ICollectorService collectorService) {
        this.collectorService = collectorService;
    }

    public ZoneCollectorRMIProxy getCollectorRMIProxy() {
        return this.collectorRMIProxy;
    }

    public void setCollectorRMIProxy(ZoneCollectorRMIProxy collectorRMIProxy) {
        this.collectorRMIProxy = collectorRMIProxy;
    }

    public ZonePolicyApplyDao getUserPolicyApplyDao() {
        return this.userPolicyApplyDao;
    }

    public void setUserPolicyApplyDao(ZonePolicyApplyDao userPolicyApplyDao) {
        this.userPolicyApplyDao = userPolicyApplyDao;
    }
}

