/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.service;

import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.atic.sdk.zone.service.IZoneService;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.vsm.secservice.ddos.common.CmdUtil;
import com.hs.vsm.secservice.ddos.dao.FilterDao;
import com.hs.vsm.secservice.ddos.dao.FilterDeviceZoneInfoDao;
import com.hs.vsm.secservice.ddos.dao.HttpFilterDao;
import com.hs.vsm.secservice.ddos.dao.ZoneDeviceDeployStatusDao;
import com.hs.vsm.secservice.ddos.dao.ZoneFeatureStatusDao;
import com.hs.vsm.secservice.ddos.dao.ZonePolicyApplyDao;
import com.hs.vsm.secservice.ddos.dao.ZoneServiceStatusDao;
import com.hs.vsm.secservice.ddos.model.FilterDeviceZoneInfo;
import com.hs.vsm.secservice.ddos.model.FilterInfo;
import com.hs.vsm.secservice.ddos.model.HttpFilterInfo;
import com.hs.vsm.secservice.ddos.model.ZoneFeatureStatusInfo;
import com.hs.vsm.secservice.ddos.model.ZonePolicyApplyInfo;
import com.hs.vsm.secservice.ddos.service.function.undeploy.FilterUnDeployCtrl;
import com.hs.vsm.secservice.sdk.common.util.Locker;
import com.hs.vsm.secservice.sdk.common.util.ProgressBar;
import com.hs.vsm.secservice.sdk.common.util.VsmUtil;
import com.hs.vsm.secservice.sdk.module.ddos.Constant;
import com.hs.vsm.secservice.sdk.module.ddos.form.AttackTypeInfoForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.DnsDefendPolicyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.DnsStatisticItem;
import com.hs.vsm.secservice.sdk.module.ddos.form.DynamicBlacklistForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.FilterDeviceZoneStatusForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.FilterForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.HttpFilterForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ManualDefendForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneBlacklistForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneDeviceDeployStatusForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneDeviceForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneFingerPrintForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZonePolicyApplyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneServiceForm;
import com.hs.vsm.secservice.sdk.module.ddos.service.IAttackTypeInfoService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IDnsDefendPolicyService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IFilterDeployService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IFilterDeviceZoneStatusService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IFilterService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneDeviceService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneMgrNorthSerice;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZonePolicyApplyServiceSimple;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZonePolicyMgrService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneServiceService;
import com.huawei.atic.secne.adapter.capability.model.DeviceTypeInfo;
import com.huawei.atic.secne.adapter.frame.service.CmdDevCapManager;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.huawei.atic.secservice.ddos.service.impl.DdosDevCapabilityServiceImpl;
import com.huawei.atic.secservice.policyengine.command.CommandAPI;
import com.huawei.atic.secservice.policyengine.commandutil.CmdParam;
import com.huawei.atic.secservice.sdk.module.ddos.service.ICommonUtilService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class ZoneMgrNorthSericeImpl
implements IZoneMgrNorthSerice {
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private ICommonUtilService commonUtilService;
    private IZonePolicyApplyServiceSimple zonePolicyService;
    private IZoneServiceService zoneService;
    private IAttackTypeInfoService attackTypeInfoService;
    private IDnsDefendPolicyService dnsDefendPolicyService;
    private IAticDeviceService aticDeviceService;
    private IFilterDeviceZoneStatusService filterDeviceZoneStatusService;
    private IFilterDeployService filterDeployService;
    private FilterUnDeployCtrl filterUnDeployCtrl;
    private IFilterService filterService;
    private IZonePolicyMgrService zonePolicyMgrService;
    private FilterDeviceZoneInfoDao filterDeviceZoneInfoDao;
    private HttpFilterDao httpFilterDao;
    private FilterDao filterDao;
    private Long filterId;
    private ZonePolicyApplyDao userPolicyApplyDao;
    private IZoneDeviceService zoneDeviceService;
    private ZoneFeatureStatusDao zoneFeatureStatusDao;
    private ZoneDeviceDeployStatusDao zoneDeviceDeployStatusDao;
    private ZoneServiceStatusDao zoneServiceStatusDao;

    public IZoneDeviceService getZoneDeviceService() {
        return this.zoneDeviceService;
    }

    public void setZoneDeviceService(IZoneDeviceService zoneDeviceService) {
        this.zoneDeviceService = zoneDeviceService;
    }

    public FilterDao getFilterDao() {
        return this.filterDao;
    }

    public void setFilterDao(FilterDao filterDao) {
        this.filterDao = filterDao;
    }

    public HttpFilterDao getHttpFilterDao() {
        return this.httpFilterDao;
    }

    public ZonePolicyApplyDao getUserPolicyApplyDao() {
        return this.userPolicyApplyDao;
    }

    public void setUserPolicyApplyDao(ZonePolicyApplyDao userPolicyApplyDao) {
        this.userPolicyApplyDao = userPolicyApplyDao;
    }

    public void setHttpFilterDao(HttpFilterDao httpFilterDao) {
        this.httpFilterDao = httpFilterDao;
    }

    public IFilterDeviceZoneStatusService getFilterDeviceZoneStatusService() {
        return this.filterDeviceZoneStatusService;
    }

    public void setFilterDeviceZoneStatusService(IFilterDeviceZoneStatusService filterDeviceZoneStatusService) {
        this.filterDeviceZoneStatusService = filterDeviceZoneStatusService;
    }

    public IFilterDeployService getFilterDeployService() {
        return this.filterDeployService;
    }

    public void setFilterDeployService(IFilterDeployService filterDeployService) {
        this.filterDeployService = filterDeployService;
    }

    public IDnsDefendPolicyService getDnsDefendPolicyService() {
        return this.dnsDefendPolicyService;
    }

    public void setDnsDefendPolicyService(IDnsDefendPolicyService dnsDefendPolicyService) {
        this.dnsDefendPolicyService = dnsDefendPolicyService;
    }

    public IZonePolicyMgrService getZonePolicyMgrService() {
        return this.zonePolicyMgrService;
    }

    public void setZonePolicyMgrService(IZonePolicyMgrService zonePolicyMgrService) {
        this.zonePolicyMgrService = zonePolicyMgrService;
    }

    @Override
    public List<ZoneServiceForm> getBizByZoneId(Long zoneId) {
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("zoneId", String.valueOf(zoneId));
        Paging page = this.zoneService.queryByPage(queryMap, 0, Integer.MAX_VALUE);
        List list = page.getData();
        return list;
    }

    @Override
    public List<ZoneServiceForm> getBizByZoneId(Long zoneId, Long deviceId) {
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("zoneId", String.valueOf(zoneId));
        queryMap.put("deviceId", String.valueOf(deviceId));
        Paging page = this.zoneService.queryByPage(queryMap, 0, Integer.MAX_VALUE);
        List list = page.getData();
        return list;
    }

    @Override
    public List<ZoneServiceForm> getBizByZoneId(Long zoneId, String ddosType) {
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("zoneId", String.valueOf(zoneId));
        queryMap.put("ddosType", ddosType);
        Paging page = this.zoneService.queryByPage(queryMap, 0, Integer.MAX_VALUE);
        List list = page.getData();
        return list;
    }

    @Override
    public ZoneServiceForm getBizTypeById(Long serviceId) {
        return this.zoneService.queryByZoneServiceID(serviceId);
    }

    @Override
    public ZonePolicyApplyForm getDivertMode(Long zoneId) {
        return (ZonePolicyApplyForm)this.zonePolicyService.query(zoneId);
    }

    @Override
    public ZoneServiceForm getDnsName(Long serviceId) {
        return (ZoneServiceForm)this.zoneService.query(serviceId);
    }

    @Override
    public List<Long> getZoneByDev(Long deviceId) {
        ArrayList<Long> result = new ArrayList<Long>();
        List<ZoneFeatureStatusInfo> list = this.zoneFeatureStatusDao.queryByDeviceId(deviceId);
        for (ZoneFeatureStatusInfo info : list) {
            if (result.contains(info.getZoneId())) continue;
            result.add(info.getZoneId());
        }
        return result;
    }

    @Override
    public List<Long> getDevByZone4Secutity(List<Long> zoneIds, Boolean isAdmin, Long userId) {
        ArrayList<Long> result = new ArrayList<Long>();
        List<ZoneFeatureStatusInfo> list = this.zoneFeatureStatusDao.queryByZoneId4Secutity(zoneIds, isAdmin, userId);
        for (ZoneFeatureStatusInfo info : list) {
            if (result.contains(info.getDeviceId())) continue;
            result.add(info.getDeviceId());
        }
        return result;
    }

    @Override
    public List<Long> getDevByZone(Long zoneId) {
        ArrayList<Long> result = new ArrayList<Long>();
        List<ZoneFeatureStatusInfo> list = this.zoneFeatureStatusDao.queryByZoneId(zoneId);
        for (ZoneFeatureStatusInfo info : list) {
            if (result.contains(info.getDeviceId())) continue;
            result.add(info.getDeviceId());
        }
        return result;
    }

    public IAttackTypeInfoService getAttackTypeInfoService() {
        return this.attackTypeInfoService;
    }

    public void setAttackTypeInfoService(IAttackTypeInfoService attackTypeInfoService) {
        this.attackTypeInfoService = attackTypeInfoService;
    }

    public IZonePolicyApplyServiceSimple getZonePolicyService() {
        return this.zonePolicyService;
    }

    public void setZonePolicyService(IZonePolicyApplyServiceSimple zonePolicyService) {
        this.zonePolicyService = zonePolicyService;
    }

    public IZoneServiceService getZoneService() {
        return this.zoneService;
    }

    public void setZoneService(IZoneServiceService zoneService) {
        this.zoneService = zoneService;
    }

    public ZoneFeatureStatusDao getZoneFeatureStatusDao() {
        return this.zoneFeatureStatusDao;
    }

    public void setZoneFeatureStatusDao(ZoneFeatureStatusDao zoneFeatureStatusDao) {
        this.zoneFeatureStatusDao = zoneFeatureStatusDao;
    }

    public ZoneDeviceDeployStatusDao getZoneDeviceDeployStatusDao() {
        return this.zoneDeviceDeployStatusDao;
    }

    public void setZoneDeviceDeployStatusDao(ZoneDeviceDeployStatusDao zoneDeviceDeployStatusDao) {
        this.zoneDeviceDeployStatusDao = zoneDeviceDeployStatusDao;
    }

    public ZoneServiceStatusDao getZoneServiceStatusDao() {
        return this.zoneServiceStatusDao;
    }

    public void setZoneServiceStatusDao(ZoneServiceStatusDao zoneServiceStatusDao) {
        this.zoneServiceStatusDao = zoneServiceStatusDao;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deployDynamicBlacklist(DynamicBlacklistForm form) {
        block15: {
            if (null != form) {
                CmdParam zone;
                List cmds = null;
                ArrayList<CmdParam> cmdParams = new ArrayList<CmdParam>();
                CmdParam sys = new CmdParam();
                sys.setCmdID("system");
                cmdParams.add(sys);
                ZoneInfoForm zoneInfo = this.getZoneInfo(form.getZoneId());
                if (Constant.ZONE_TYPE_OF_DEFAULT.equals(zoneInfo.getZoneType())) {
                    zone = new CmdParam();
                    zone.setCmdID("zone");
                    zone.getParams().put("default", "default");
                    cmdParams.add(zone);
                } else {
                    zone = new CmdParam();
                    zone.setCmdID("zone");
                    zone.getParams().put("zoneName", zoneInfo.getZoneName());
                    cmdParams.add(zone);
                }
                CmdParam blacklist = new CmdParam();
                if (IPUtil.isIpv6((String)form.getIp())) {
                    blacklist.setCmdID("add_blacklist_ipv6");
                } else {
                    blacklist.setCmdID("add_blacklist");
                }
                blacklist.getParams().put("protocol", String.valueOf(form.getProtocol()));
                blacklist.getParams().put("ip", form.getIp());
                if (form.getPort() > 0) {
                    blacklist.getParams().put("port", String.valueOf(form.getPort()));
                }
                blacklist.getParams().put("timeout", String.valueOf(form.getTimeout()));
                cmdParams.add(blacklist);
                Boolean isLockOK = VsmUtil.getInstance().lock(form.getDeviceId());
                try {
                    if (isLockOK.booleanValue()) {
                        CommandAPI tool = new CommandAPI();
                        String cmdFileDir = CmdDevCapManager.getInstance().getCmdDevCapaFileDir(form.getDeviceId());
                        cmds = tool.doTranslate(cmdFileDir, "dynamic_defend", cmdParams);
                        List<String> cmdResult = CmdUtil.execCmds(form.getDeviceId(), cmds);
                        Boolean isDeployOK = VsmUtil.getInstance().checkCmdResult(cmdResult);
                        if (isDeployOK.booleanValue()) {
                            this.logger.info((Object)"deploy succeed ");
                            break block15;
                        }
                        this.logger.info((Object)"deploy failed ");
                        throw new LegoCheckedException(630006L);
                    }
                    this.logger.error((Object)("failed to lock device :" + form.getDeviceId()));
                    throw new LegoCheckedException(630007L);
                }
                catch (LegoCheckedException legoException) {
                    this.logger.error((Object)legoException);
                    throw legoException;
                }
                catch (Exception e) {
                    this.logger.error((Object)e);
                }
                finally {
                    if (isLockOK.booleanValue()) {
                        Locker.getInstance().unlock(form.getDeviceId(), 1);
                    }
                }
            }
        }
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean manualDefend(ManualDefendForm form) {
        boolean defendResult;
        block41: {
            defendResult = true;
            if (null != form) {
                CmdParam zone;
                List cmds = null;
                ArrayList<CmdParam> cmdParams = new ArrayList<CmdParam>();
                CmdParam sys = new CmdParam();
                sys.setCmdID("system");
                cmdParams.add(sys);
                ZoneInfoForm zoneInfo = this.getZoneInfo(form.getZoneId());
                if (Constant.ZONE_TYPE_OF_DEFAULT.equals(zoneInfo.getZoneType())) {
                    zone = new CmdParam();
                    zone.setCmdID("zone");
                    zone.getParams().put("default", "default");
                    cmdParams.add(zone);
                } else {
                    zone = new CmdParam();
                    zone.setCmdID("zone");
                    zone.getParams().put("zoneName", form.getZoneName());
                    cmdParams.add(zone);
                }
                DdosDevCapabilityServiceImpl devCapabilityService = DdosDevCapabilityServiceImpl.getInstance();
                DeviceTypeInfo devTypeInfo = CmdUtil.getDevTypeInfo(form.getDeviceId());
                Set supportAttrs = devCapabilityService.getAllSupportedAttr(devTypeInfo);
                Boolean withServiceViewCustomService = supportAttrs.contains("withServiceViewCustomService");
                ZoneDeviceForm zoneDeviceForm = this.zoneDeviceService.getByZoneIdAndDeviceid(form.getZoneId(), form.getDeviceId());
                boolean isVpn = false;
                if (null != zoneDeviceForm && !AticUtil.isNull((String)zoneDeviceForm.getVpnName())) {
                    isVpn = true;
                }
                if (withServiceViewCustomService.booleanValue()) {
                    ZoneServiceForm serviceForm = null;
                    if (null == form.getServiceId()) {
                        throw new LegoCheckedException(630110L);
                    }
                    serviceForm = this.zoneService.queryByZoneServiceID(form.getServiceId());
                    if (null == serviceForm) {
                        throw new LegoCheckedException(630110L);
                    }
                    this.logger.info((Object)("serviceForm : " + this.getcleanedMessage(serviceForm.toString())));
                    if (!"DEFAULT".equals(serviceForm.getProtocol())) {
                        this.enterServiceView(withServiceViewCustomService, cmdParams, serviceForm);
                        String attackMode = this.getAttackTypeMode(form);
                        this.logger.info((Object)("attackMode : " + this.getcleanedMessage(attackMode)));
                        CmdParam confirmAttack = new CmdParam();
                        if (IPUtil.isIpv6((String)form.getIp())) {
                            if (isVpn) {
                                confirmAttack.setCmdID("serviceAttackConfirm_ipv6_vpn");
                            } else {
                                confirmAttack.setCmdID("serviceAttackConfirm_ipv6");
                            }
                        } else if (isVpn) {
                            confirmAttack.setCmdID("serviceAttackConfirm_vpn");
                        } else {
                            confirmAttack.setCmdID("serviceAttackConfirm");
                        }
                        if (null != attackMode && attackMode.trim().equals("attack-type")) {
                            this.logger.info((Object)("attackMode : " + this.getcleanedMessage(attackMode)));
                            confirmAttack.getParams().put("attackTypeStr", this.getAttackTypeStr(form));
                        }
                        confirmAttack.getParams().put("attackTypeMode", attackMode);
                        confirmAttack.getParams().put("ip", form.getIp());
                        if (null != form.getPort() && form.getPort() != 0) {
                            confirmAttack.getParams().put("port", String.valueOf(form.getPort()));
                        }
                        if (isVpn) {
                            confirmAttack.getParams().put("vpnname", zoneDeviceForm.getVpnName());
                        }
                        cmdParams.add(confirmAttack);
                    } else {
                        CmdParam confirmAttack = new CmdParam();
                        if (IPUtil.isIpv6((String)form.getIp())) {
                            if (isVpn) {
                                confirmAttack.setCmdID("confirm_attack_ipv6_vpn");
                            } else {
                                confirmAttack.setCmdID("confirm_attack_ipv6");
                            }
                        } else if (isVpn) {
                            confirmAttack.setCmdID("confirm_attack_vpn");
                        } else {
                            confirmAttack.setCmdID("confirm_attack");
                        }
                        confirmAttack.getParams().put("attackTypeStr", this.getAttackTypeStr(form));
                        confirmAttack.getParams().put("attackTypeMode", this.getAttackTypeMode(form));
                        confirmAttack.getParams().put("ip", form.getIp());
                        if (isVpn) {
                            confirmAttack.getParams().put("vpnname", zoneDeviceForm.getVpnName());
                        }
                        cmdParams.add(confirmAttack);
                    }
                } else {
                    CmdParam confirmAttack = new CmdParam();
                    if (IPUtil.isIpv6((String)form.getIp())) {
                        if (isVpn) {
                            confirmAttack.setCmdID("confirm_attack_ipv6_vpn");
                        } else {
                            confirmAttack.setCmdID("confirm_attack_ipv6");
                        }
                    } else if (isVpn) {
                        confirmAttack.setCmdID("confirm_attack_vpn");
                    } else {
                        confirmAttack.setCmdID("confirm_attack");
                    }
                    confirmAttack.getParams().put("attackTypeStr", this.getAttackTypeStr(form));
                    confirmAttack.getParams().put("attackTypeMode", this.getAttackTypeMode(form));
                    confirmAttack.getParams().put("ip", form.getIp());
                    if (isVpn) {
                        confirmAttack.getParams().put("vpnname", zoneDeviceForm.getVpnName());
                    }
                    cmdParams.add(confirmAttack);
                }
                Boolean isLockOK = VsmUtil.getInstance().lock(form.getDeviceId());
                try {
                    if (isLockOK.booleanValue()) {
                        CommandAPI tool = new CommandAPI();
                        String cmdFileDir = CmdDevCapManager.getInstance().getCmdDevCapaFileDir(form.getDeviceId());
                        cmds = tool.doTranslate(cmdFileDir, "dynamic_defend", cmdParams);
                        this.logger.info((Object)("cmds to manualDefend : " + this.getcleanedMessage(cmds.toString())));
                        List<String> cmdResult = CmdUtil.execCmds(form.getDeviceId(), cmds);
                        Boolean isDeployOK = VsmUtil.getInstance().checkCmdResult(cmdResult);
                        defendResult = isDeployOK;
                        this.dealDeployResult(isDeployOK);
                        break block41;
                    }
                    defendResult = false;
                    this.logger.error((Object)("failed to lock device :" + form.getDeviceId()));
                    throw new LegoCheckedException(630007L);
                }
                catch (LegoCheckedException legoException) {
                    defendResult = false;
                    this.logger.error((Object)legoException);
                    throw legoException;
                }
                catch (Exception e) {
                    defendResult = false;
                    this.logger.error((Object)e);
                }
                finally {
                    if (isLockOK.booleanValue()) {
                        Locker.getInstance().unlock(form.getDeviceId(), 1);
                    }
                }
            }
        }
        return defendResult;
    }

    private ZoneInfoForm getZoneInfo(Long zoneId) {
        ZoneInfoForm form = null;
        ServiceContext context = ServiceContext.getInstance();
        if (context != null) {
            IZoneService userService = (IZoneService)context.getService("zoneService", IZoneService.class);
            form = userService.getById(zoneId);
        }
        if (null == form) {
            throw new LegoCheckedException(630010L);
        }
        return form;
    }

    private void dealDeployResult(Boolean isDeployOK) {
        if (!isDeployOK.booleanValue()) {
            this.logger.info((Object)"deploy failed ");
            throw new LegoCheckedException(630006L);
        }
        this.logger.info((Object)"deploy succeed ");
    }

    private void enterServiceView(Boolean withServiceViewCustomService, List<CmdParam> cmdParams, ZoneServiceForm form) {
        if (withServiceViewCustomService.booleanValue() && !"DEFAULT".equals(form.getProtocol())) {
            CmdParam serviceView = new CmdParam();
            serviceView.setCmdID("service");
            serviceView.getParams().put("serviceName", form.getServiceName());
            cmdParams.add(serviceView);
        }
    }

    private String getAttackTypeMode(ManualDefendForm form) {
        AttackTypeInfoForm info = this.attackTypeInfoService.getAttackTypeInfo(form);
        if (null == info) {
            return null;
        }
        return info.getMode();
    }

    private String getAttackTypeStr(ManualDefendForm form) {
        AttackTypeInfoForm info = this.attackTypeInfoService.getAttackTypeInfo(form);
        if (null == info) {
            return null;
        }
        return info.getAttackTypeStr();
    }

    @Override
    public void undeployDynamicBlacklist(DynamicBlacklistForm form) {
        block15: {
            if (null != form) {
                CmdParam zone;
                List cmds = null;
                ArrayList<CmdParam> cmdParams = new ArrayList<CmdParam>();
                CmdParam sys = new CmdParam();
                sys.setCmdID("system");
                cmdParams.add(sys);
                ZoneInfoForm zoneInfo = this.getZoneInfo(form.getZoneId());
                if (Constant.ZONE_TYPE_OF_DEFAULT.equals(zoneInfo.getZoneType())) {
                    zone = new CmdParam();
                    zone.setCmdID("zone");
                    zone.getParams().put("default", "default");
                    cmdParams.add(zone);
                } else {
                    zone = new CmdParam();
                    zone.setCmdID("zone");
                    zone.getParams().put("zoneName", zoneInfo.getZoneName());
                    cmdParams.add(zone);
                }
                CmdParam blacklist = new CmdParam();
                if (IPUtil.isIpv6((String)form.getIp())) {
                    blacklist.setCmdID("del_blacklist_ipv6");
                } else {
                    blacklist.setCmdID("del_blacklist");
                }
                blacklist.getParams().put("protocol", String.valueOf(form.getProtocol()));
                blacklist.getParams().put("ip", form.getIp());
                if (form.getPort() > 0) {
                    blacklist.getParams().put("port", String.valueOf(form.getPort()));
                }
                cmdParams.add(blacklist);
                Boolean isLockOK = VsmUtil.getInstance().lock(form.getDeviceId());
                try {
                    if (isLockOK.booleanValue()) {
                        CommandAPI tool = new CommandAPI();
                        String cmdFileDir = CmdDevCapManager.getInstance().getCmdDevCapaFileDir(form.getDeviceId());
                        cmds = tool.doTranslate(cmdFileDir, "dynamic_defend", cmdParams);
                        List<String> cmdResult = CmdUtil.execCmds(form.getDeviceId(), cmds);
                        Boolean isDeployOK = VsmUtil.getInstance().checkCmdResult(cmdResult);
                        if (isDeployOK.booleanValue()) {
                            this.logger.info((Object)"deploy succeed ");
                            break block15;
                        }
                        this.logger.info((Object)("deploy failed " + this.getcleanedMessage(cmdResult.toString())));
                        throw new LegoCheckedException(630006L);
                    }
                    this.logger.error((Object)("failed to lock device :" + form.getDeviceId()));
                    throw new LegoCheckedException(630007L);
                }
                catch (LegoCheckedException legoException) {
                    this.logger.error((Object)legoException);
                    throw legoException;
                }
                catch (Exception e) {
                    this.logger.error((Object)e);
                    throw new LegoCheckedException(630006L, (Throwable)e);
                }
                finally {
                    if (isLockOK.booleanValue()) {
                        Locker.getInstance().unlock(form.getDeviceId(), 1);
                    }
                }
            }
        }
    }

    @Override
    public void addFingerPrint2Zone(Long zoneId, Long deviceId) {
    }

    @Override
    public ZoneServiceForm getZoneServiceFormByProtocolAndPort(Long zoneId, String deviceIp, Integer protocol, Integer port) {
        HashMap<String, String> queryMap = new HashMap<String, String>();
        Long deviceId = this.aticDeviceService.getMoidByIP(deviceIp);
        queryMap.put("zoneId", String.valueOf(zoneId));
        queryMap.put("deviceId", String.valueOf(deviceId));
        String protocolStr = "";
        switch (protocol) {
            case 1: {
                protocolStr = "TCP";
                break;
            }
            case 2: {
                protocolStr = "UDP";
                break;
            }
            case 3: {
                protocolStr = "HTTP";
                break;
            }
        }
        queryMap.put("protocol", protocolStr);
        ZoneServiceForm result = null;
        try {
            Paging page = this.zoneService.queryByPage(queryMap, 0, Integer.MAX_VALUE);
            List form = page.getData();
            for (ZoneServiceForm each : form) {
                for (String eachPortStr : each.getPortList().split(";")) {
                    if (Integer.parseInt(eachPortStr) != port) continue;
                    result = each;
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e);
        }
        return result;
    }

    @Override
    public Map<Long, String> getUserDefDnsTypeCode(Long deviceId, Long zoneId, Long bizId) {
        Long all = 0L;
        this.logger.info((Object)("bizId is: " + bizId));
        HashMap<Long, String> result = new HashMap<Long, String>();
        if (bizId.equals(all)) {
            Map<Long, String> defDnsType = this.getDefBizDnsType(deviceId, zoneId);
            Map<Long, String> dnsDnsType = this.getDnsBizDnsType(deviceId, zoneId);
            result.putAll(defDnsType);
            result.putAll(dnsDnsType);
        } else {
            DnsDefendPolicyForm dnsForm = this.dnsDefendPolicyService.queryByServiceId(bizId);
            if (dnsForm != null) {
                List<DnsStatisticItem> items = dnsForm.getDnsStatisticItems();
                for (DnsStatisticItem item : items) {
                    result.put((long)item.getStasticTypeCode(), item.getDnsItemName());
                }
            }
        }
        return result;
    }

    private Map<Long, String> getDnsBizDnsType(Long deviceId, Long zoneId) {
        DnsDefendPolicyForm dnsForm;
        HashMap<Long, String> result = new HashMap<Long, String>();
        HashMap<String, String> dnsQueryMap = new HashMap<String, String>();
        dnsQueryMap.put("zoneId", zoneId.toString());
        dnsQueryMap.put("deviceId", deviceId.toString());
        dnsQueryMap.put("protocol", "UDP_DNS");
        Paging dnsPage = this.zoneService.queryByPage(dnsQueryMap, 0, Integer.MAX_VALUE);
        List servicesResult = dnsPage.getData();
        if (dnsPage.getCount() > 0 && (dnsForm = this.dnsDefendPolicyService.queryByServiceId(((ZoneServiceForm)servicesResult.get(0)).getPkid())) != null) {
            result = new HashMap();
            List<DnsStatisticItem> items = dnsForm.getDnsStatisticItems();
            for (DnsStatisticItem item : items) {
                result.put((long)item.getStasticTypeCode(), item.getDnsItemName());
            }
        }
        return result;
    }

    private Map<Long, String> getDefBizDnsType(Long deviceId, Long zoneId) {
        DnsDefendPolicyForm dnsForm;
        HashMap<Long, String> result = new HashMap<Long, String>();
        HashMap<String, String> defQueryMap = new HashMap<String, String>();
        defQueryMap.put("zoneId", zoneId.toString());
        defQueryMap.put("deviceId", deviceId.toString());
        defQueryMap.put("protocol", "DEFAULT");
        Paging defPage = this.zoneService.queryByPage(defQueryMap, 0, Integer.MAX_VALUE);
        List servicesResult = defPage.getData();
        if (defPage.getCount() > 0 && (dnsForm = this.dnsDefendPolicyService.queryByServiceId(((ZoneServiceForm)servicesResult.get(0)).getPkid())) != null) {
            result = new HashMap();
            List<DnsStatisticItem> items = dnsForm.getDnsStatisticItems();
            for (DnsStatisticItem item : items) {
                result.put((long)item.getStasticTypeCode(), item.getDnsItemName());
            }
        }
        return result;
    }

    public FilterUnDeployCtrl getFilterUnDeployCtrl() {
        return this.filterUnDeployCtrl;
    }

    public void setFilterUnDeployCtrl(FilterUnDeployCtrl filterUnDeployCtrl) {
        this.filterUnDeployCtrl = filterUnDeployCtrl;
    }

    public IFilterService getFilterService() {
        return this.filterService;
    }

    public void setFilterService(IFilterService filterService) {
        this.filterService = filterService;
    }

    public FilterDeviceZoneInfoDao getFilterDeviceZoneInfoDao() {
        return this.filterDeviceZoneInfoDao;
    }

    public void setFilterDeviceZoneInfoDao(FilterDeviceZoneInfoDao filterDeviceZoneInfoDao) {
        this.filterDeviceZoneInfoDao = filterDeviceZoneInfoDao;
    }

    public ICommonUtilService getCommonUtilService() {
        return this.commonUtilService;
    }

    public void setCommonUtilService(ICommonUtilService commonUtilService) {
        this.commonUtilService = commonUtilService;
    }

    @Override
    public List<FilterDeviceZoneStatusForm> getByFilterId(Long filterIds) {
        return this.filterDeviceZoneStatusService.getByFilterId(filterIds);
    }

    @Override
    public Map<Long, Set<Long>> doDeployWithFilter(Long filterIds, Long progressBarId, ProgressBar progressBar, Long adminId, List<Long> deleteDeviceIds, Boolean isGlobalApplyFilter) {
        return this.filterDeployService.doDeployWithFilter(filterIds, progressBarId, progressBar, adminId, deleteDeviceIds, isGlobalApplyFilter);
    }

    @Override
    public void doDeployWithZone(List<Long> zoneIdList, Long progressBarId, ProgressBar progressBar, Long adminId) {
        this.filterDeployService.doDeployWithZone(zoneIdList, progressBarId, progressBar, adminId);
    }

    @Override
    public void doUnDeployWithFilter(List<Long> filterIdList, Long progressBarId, ProgressBar progressBar, Long adminId) {
        this.filterUnDeployCtrl.doUnDeployWithFilter(filterIdList, progressBarId, progressBar, adminId);
    }

    private String getCurrentTimeString() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddhhmmssSSS");
        return sdf.format(new Date());
    }

    @Override
    public void addBlackListItems(List<ZoneBlacklistForm> blacklistForms) {
        Long zoneId = blacklistForms.get(0).getZoneId();
        if (this.isTooMuchFilter(zoneId)) {
            this.logger.error((Object)("zone filter (blacklist from pcap) number cannot be more than 10. zoneId= " + zoneId));
            throw new LegoCheckedException(631035L);
        }
        FilterForm filterForm = new FilterForm();
        filterForm.setFilterId(this.filterService.calculationFilterId());
        filterForm.setFilterName("Blacklist" + this.getCurrentTimeString());
        filterForm.setDeviceType("AntiDDoS");
        filterForm.setFilterAction(4);
        filterForm.setFilterMode(1);
        ArrayList<Long> zoneIdList = new ArrayList<Long>();
        zoneIdList.add(zoneId);
        filterForm.setZoneIdList(zoneIdList);
        String protocol = blacklistForms.get(0).getProtocol().toLowerCase(Locale.ENGLISH);
        filterForm.setFilterType(protocol.equals("all") ? "ip" : protocol);
        filterForm.setDirection(1);
        ArrayList<HttpFilterForm> filterFormList = new ArrayList<HttpFilterForm>();
        for (ZoneBlacklistForm form : blacklistForms) {
            HttpFilterForm sourceIp = new HttpFilterForm();
            sourceIp.setFilterKey("source-ip");
            sourceIp.setFilterContent(form.getIpAndMask());
            if (!filterFormList.contains(sourceIp)) {
                filterFormList.add(sourceIp);
            }
            if (protocol.equals("all") || protocol.equals("icmp") || protocol.equals("icmpv6")) continue;
            HttpFilterForm port = new HttpFilterForm();
            port.setFilterKey("destination-port");
            port.setFilterContent(form.getPort().toString());
            if (filterFormList.contains(port)) continue;
            filterFormList.add(port);
        }
        filterForm.setHttpFilterFormList(filterFormList);
        if (this.isFilterExist(zoneId, filterForm)) {
            this.logger.error((Object)("filter (blacklist from pcap) already exist. zoneId= " + zoneId));
            throw new LegoCheckedException(631041L);
        }
        ZonePolicyApplyInfo info = this.userPolicyApplyDao.getByZoneId(zoneId);
        this.filterService.create(filterForm, info);
    }

    private String toHexString(String s) {
        String str = "\\x";
        StringBuilder sb = new StringBuilder();
        sb.append(str);
        int i = 0;
        while (i + 2 <= s.length()) {
            sb.append(s.charAt(i)).append(s.charAt(i + 1));
            sb = sb.append("\\x");
            i += 2;
        }
        str = sb.toString();
        str = str.substring(0, str.lastIndexOf("\\x"));
        return str;
    }

    private boolean isSupportedFingerContentSupportVersion(Long deviceId) {
        DeviceTypeInfo devTypeInfo = CmdUtil.getDevTypeInfo(deviceId);
        Set supportAttr = DdosDevCapabilityServiceImpl.getInstance().getAllSupportedAttr(devTypeInfo);
        return supportAttr.contains("isFingerContentSupportVersion");
    }

    @Override
    public Integer addZoneFingerItem(Long zoneId, Long deviceId, ZoneFingerPrintForm form, String fingerName) {
        if (this.isTooMuchFilter(zoneId)) {
            this.logger.error((Object)("zone filter (fingerprint from pcap) number cannot be more than 10. zoneId= " + zoneId));
            return 630134;
        }
        FilterForm filterForm = new FilterForm();
        filterForm.setFilterId(this.filterService.calculationFilterId());
        if (AticUtil.isNull((String)fingerName)) {
            fingerName = "fingerprint" + this.getCurrentTimeString();
        }
        filterForm.setFilterName(fingerName);
        filterForm.setFilterAction(3);
        filterForm.setDeviceType("AntiDDoS");
        filterForm.setFilterMode(1);
        ArrayList<Long> zoneIdList = new ArrayList<Long>();
        zoneIdList.add(zoneId);
        filterForm.setZoneIdList(zoneIdList);
        String protocol = form.getProtocol().toUpperCase(Locale.ENGLISH);
        filterForm.setFilterType(protocol.equals("ipv4") ? "IP" : protocol);
        StringBuffer sb = new StringBuffer();
        String[] offset = form.getOffset().split(";");
        String[] content = form.getContent().split(";");
        for (int i = 0; i < offset.length; ++i) {
            sb.append(offset[i]);
            sb.append(' ');
            if (this.isSupportedFingerContentSupportVersion(deviceId)) {
                sb.append(content[i]);
            } else {
                sb.append(this.toHexString(content[i]));
            }
            sb.append(' ');
            sb.append(content[i].length() / 2);
            sb.append("        ");
        }
        ArrayList<HttpFilterForm> filterFormList = new ArrayList<HttpFilterForm>();
        HttpFilterForm fingerprint = new HttpFilterForm();
        fingerprint.setFilterKey("fingerprint");
        fingerprint.setFilterContent(sb.toString());
        filterFormList.add(fingerprint);
        filterForm.setHttpFilterFormList(filterFormList);
        filterForm.setDirection(1);
        if (this.isFilterExist(zoneId, filterForm)) {
            this.logger.error((Object)("filter (fingerprint from pcap) already exist. zoneId= " + zoneId));
            return 630133;
        }
        ZonePolicyApplyInfo info = this.userPolicyApplyDao.getByZoneId(zoneId);
        this.filterId = this.filterService.create(filterForm, info);
        return 0;
    }

    @Override
    public Integer addZoneFingerItem(Long zoneId, Long deviceId, ZoneFingerPrintForm form) {
        List<ZoneDeviceDeployStatusForm> zoneDeviceDeployStatusFormList;
        if (this.isTooMuchFilter(zoneId)) {
            this.logger.error((Object)("zone filter (fingerprint from pcap) number cannot be more than 10. zoneId= " + zoneId));
            return 630134;
        }
        FilterForm filterForm = new FilterForm();
        filterForm.setFilterId(this.filterService.calculationFilterId());
        filterForm.setFilterName("fingerprint" + this.getCurrentTimeString());
        filterForm.setFilterAction(3);
        filterForm.setDeviceType("AntiDDoS");
        ArrayList<Long> zoneIdList = new ArrayList<Long>();
        zoneIdList.add(zoneId);
        filterForm.setZoneIdList(zoneIdList);
        String protocol = form.getProtocol().toLowerCase(Locale.ENGLISH);
        filterForm.setFilterType(protocol.equals("ipv4") ? "ip" : protocol);
        StringBuffer sb = new StringBuffer();
        String[] offset = form.getOffset().split(";");
        String[] content = form.getContent().split(";");
        for (int i = 0; i < offset.length; ++i) {
            sb.append(offset[i]);
            sb.append(' ');
            if (this.isSupportedFingerContentSupportVersion(deviceId)) {
                sb.append(content[i]);
            } else {
                sb.append(this.toHexString(content[i]));
            }
            sb.append(' ');
            sb.append(content[i].length());
            sb.append("        ");
        }
        ArrayList<HttpFilterForm> filterFormList = new ArrayList<HttpFilterForm>();
        HttpFilterForm fingerprint = new HttpFilterForm();
        fingerprint.setFilterKey("fingerprint");
        fingerprint.setFilterContent(sb.toString());
        filterFormList.add(fingerprint);
        filterForm.setHttpFilterFormList(filterFormList);
        filterForm.setDirection(1);
        if (this.isFilterExist(zoneId, filterForm)) {
            this.logger.error((Object)("filter (fingerprint from pcap) already exist. zoneId= " + zoneId));
            return 630133;
        }
        this.filterId = (Long)this.filterService.create(filterForm);
        Map<Long, Set<Long>> resultMap = this.doDeployWithFilter(this.filterId, null, null, null, null, false);
        if (resultMap != null && !resultMap.isEmpty() && (zoneDeviceDeployStatusFormList = this.zonePolicyMgrService.queryDeployResultByZoneId(zoneId)) != null && !zoneDeviceDeployStatusFormList.isEmpty()) {
            int j = zoneDeviceDeployStatusFormList.size();
            for (int i = 0; i < j; ++i) {
                ZoneDeviceDeployStatusForm zoneDeviceDeployStatusInfo = zoneDeviceDeployStatusFormList.get(i);
                if (zoneDeviceDeployStatusInfo.getDeployState().booleanValue()) continue;
                String errorMsg = zoneDeviceDeployStatusInfo.getErrorMsgKey();
                errorMsg = errorMsg.replaceAll("lego.err.", "");
                this.logger.error((Object)("deploy zone filter (fingerprint from pcap) failed. zoneId= " + zoneId));
                return Integer.valueOf(errorMsg);
            }
        }
        return 0;
    }

    private boolean isTooMuchFilter(Long zoneId) {
        List<FilterDeviceZoneInfo> list = this.filterDeviceZoneInfoDao.queryByZoneId(zoneId);
        HashSet<Long> filterIdSet = new HashSet<Long>();
        if (list != null && !list.isEmpty()) {
            for (FilterDeviceZoneInfo info : list) {
                filterIdSet.add(info.getFilterId());
            }
        }
        return filterIdSet.size() >= 20;
    }

    private boolean isFilterExist(Long zoneId, FilterForm filterForm) {
        boolean bl;
        ArrayList<Long> filterIdList = new ArrayList<Long>();
        List<FilterDeviceZoneInfo> fdzInfoList = this.filterDeviceZoneInfoDao.getByZoneId(zoneId);
        if (fdzInfoList != null && !fdzInfoList.isEmpty()) {
            for (FilterDeviceZoneInfo filterDeviceZoneInfo : fdzInfoList) {
                String type = this.getFilterType(filterDeviceZoneInfo.getFilterId());
                if (!filterForm.getFilterType().equals(type) || filterIdList.contains(filterDeviceZoneInfo.getFilterId())) continue;
                filterIdList.add(filterDeviceZoneInfo.getFilterId());
            }
        }
        ArrayList<HttpFilterInfo> filterInfoList = new ArrayList<HttpFilterInfo>();
        for (Long filterIds : filterIdList) {
            List<HttpFilterInfo> tempList = this.httpFilterDao.queryByFilterId(filterIds);
            filterInfoList.addAll(tempList);
        }
        boolean bl2 = false;
        boolean isSourceIpExist = false;
        boolean isFingerprintExist = false;
        block2: for (HttpFilterForm form : filterForm.getHttpFilterFormList()) {
            if (form.getFilterKey().equals("destination-port")) {
                for (HttpFilterInfo info : filterInfoList) {
                    if (!form.getFilterKey().equals(info.getFilterKey()) || !form.getFilterContent().equals(info.getFilterContent())) continue;
                    bl = true;
                    break;
                }
            }
            if (form.getFilterKey().equals("source-ip")) {
                for (HttpFilterInfo info : filterInfoList) {
                    if (!form.getFilterKey().equals(info.getFilterKey()) || !form.getFilterContent().equals(info.getFilterContent())) continue;
                    isSourceIpExist = true;
                    break;
                }
            }
            if (!form.getFilterKey().equals("fingerprint")) continue;
            for (HttpFilterInfo info : filterInfoList) {
                if (!form.getFilterKey().equals(info.getFilterKey()) || !form.getFilterContent().equals(info.getFilterContent())) continue;
                isFingerprintExist = true;
                continue block2;
            }
        }
        if (bl && isSourceIpExist) {
            this.logger.info((Object)"destinationPort & sourceIp already exist.");
            return true;
        }
        if (isFingerprintExist) {
            this.logger.info((Object)"fingerprint already exist.");
            return true;
        }
        return false;
    }

    private String getFilterType(Long filterIds) {
        FilterInfo filterInfo = this.filterDao.get(filterIds);
        if (null != filterInfo) {
            return filterInfo.getFilterType();
        }
        return "";
    }

    public void setAticDeviceService(IAticDeviceService aticDeviceService) {
        this.aticDeviceService = aticDeviceService;
    }

    public IAticDeviceService getAticDeviceService() {
        return this.aticDeviceService;
    }

    @Override
    public void undeployAllDynamicBlacklist(Long zoneId, Long deviceId) {
        block11: {
            CmdParam zone;
            List cmds = null;
            ArrayList<CmdParam> cmdParams = new ArrayList<CmdParam>();
            CmdParam sys = new CmdParam();
            sys.setCmdID("system");
            cmdParams.add(sys);
            CmdParam diagnose = new CmdParam();
            diagnose.setCmdID("diagnose");
            cmdParams.add(diagnose);
            ZoneInfoForm zoneInfo = this.getZoneInfo(zoneId);
            if (Constant.ZONE_TYPE_OF_DEFAULT.equals(zoneInfo.getZoneType())) {
                zone = new CmdParam();
                zone.setCmdID("clear");
                zone.getParams().put("default", "default");
                cmdParams.add(zone);
            } else {
                zone = new CmdParam();
                zone.setCmdID("clear");
                zone.getParams().put("zoneName", zoneInfo.getZoneName());
                cmdParams.add(zone);
            }
            Boolean isLockOK = VsmUtil.getInstance().lock(deviceId);
            try {
                if (isLockOK.booleanValue()) {
                    CommandAPI tool = new CommandAPI();
                    String cmdFileDir = CmdDevCapManager.getInstance().getCmdDevCapaFileDir(deviceId);
                    cmds = tool.doTranslate(cmdFileDir, "dynamic_defend", cmdParams);
                    List<String> cmdResult = CmdUtil.execCmds(deviceId, cmds);
                    Boolean isDeployOK = VsmUtil.getInstance().checkCmdResult(cmdResult);
                    if (isDeployOK.booleanValue()) {
                        this.logger.info((Object)"deploy succeed ");
                        break block11;
                    }
                    this.logger.info((Object)("deploy failed " + this.getcleanedMessage(cmdResult.toString())));
                    throw new LegoCheckedException(630006L);
                }
                throw new LegoCheckedException(630007L);
            }
            catch (LegoCheckedException legoException) {
                this.logger.error((Object)legoException);
                throw legoException;
            }
            catch (Exception e) {
                this.logger.error((Object)e);
                throw new LegoCheckedException(630006L, (Throwable)e);
            }
            finally {
                if (isLockOK.booleanValue()) {
                    Locker.getInstance().unlock(deviceId, 1);
                }
            }
        }
    }
}

