/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.service;

import com.hs.lego.core.sdk.comm.BatchOperation;
import com.hs.lego.core.sdk.comm.BatchOperationResult;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.vsm.secservice.ddos.dao.BlackWhiteListDao;
import com.hs.vsm.secservice.ddos.dao.FilterDeviceZoneInfoDao;
import com.hs.vsm.secservice.ddos.dao.ZoneDeviceDeployStatusDao;
import com.hs.vsm.secservice.ddos.dao.ZoneIpLocationDao;
import com.hs.vsm.secservice.ddos.dao.ZonePolicyApplyDao;
import com.hs.vsm.secservice.ddos.model.BlackWhiteListInfo;
import com.hs.vsm.secservice.ddos.model.FilterDeviceZoneInfo;
import com.hs.vsm.secservice.ddos.model.ZoneDeviceDeployStatusInfo;
import com.hs.vsm.secservice.ddos.model.ZoneDeviceInfo;
import com.hs.vsm.secservice.ddos.model.ZoneIpLocationInfo;
import com.hs.vsm.secservice.ddos.model.ZonePolicyApplyInfo;
import com.hs.vsm.secservice.sdk.common.util.VsmUtil;
import com.hs.vsm.secservice.sdk.module.ddos.Constant;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneBlackWhiteForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneDeviceForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneIpLocationForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZonePolicyApplyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneWhiteForm;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZonePolicyApplyServiceSimple;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ZonePolicyApplyServiceImplSimple
implements IZonePolicyApplyServiceSimple {
    private IAticDeviceService aticDeviceService;
    private ZonePolicyApplyDao userPolicyApplyDao;
    private ZoneDeviceDeployStatusDao zoneDeviceDeployStatusDao;
    private FilterDeviceZoneInfoDao filterDeviceZoneInfoDao;
    private ZoneIpLocationDao zoneIpLocationDao;
    private BlackWhiteListDao blackWhiteListDao;

    public FilterDeviceZoneInfoDao getFilterDeviceZoneInfoDao() {
        return this.filterDeviceZoneInfoDao;
    }

    public void setFilterDeviceZoneInfoDao(FilterDeviceZoneInfoDao filterDeviceZoneInfoDao) {
        this.filterDeviceZoneInfoDao = filterDeviceZoneInfoDao;
    }

    public ZoneDeviceDeployStatusDao getZoneDeviceDeployStatusDao() {
        return this.zoneDeviceDeployStatusDao;
    }

    public void setZoneDeviceDeployStatusDao(ZoneDeviceDeployStatusDao zoneDeviceDeployStatusDao) {
        this.zoneDeviceDeployStatusDao = zoneDeviceDeployStatusDao;
    }

    public ZonePolicyApplyDao getUserPolicyApplyDao() {
        return this.userPolicyApplyDao;
    }

    public void setUserPolicyApplyDao(ZonePolicyApplyDao userPolicyApplyDao) {
        this.userPolicyApplyDao = userPolicyApplyDao;
    }

    private ZonePolicyApplyForm tranInfo2Form(ZonePolicyApplyInfo zonePolicyApplyInfo) {
        ZonePolicyApplyForm userPolicyApplyForm = new ZonePolicyApplyForm();
        ArrayList<ZoneDeviceForm> tmpDevList = new ArrayList<ZoneDeviceForm>();
        VsmUtil.getInstance().copyProperties(zonePolicyApplyInfo, userPolicyApplyForm);
        for (ZoneDeviceInfo info : zonePolicyApplyInfo.getZoneDeviceInfos()) {
            ZoneDeviceForm devForm = new ZoneDeviceForm();
            VsmUtil.getInstance().copyProperties(info, devForm);
            tmpDevList.add(devForm);
        }
        userPolicyApplyForm.setZoneDeviceForms(tmpDevList);
        return userPolicyApplyForm;
    }

    private ZonePolicyApplyInfo tranForm2Info(ZonePolicyApplyForm form) {
        ZonePolicyApplyInfo info = new ZonePolicyApplyInfo();
        VsmUtil.getInstance().copyProperties(form, info);
        List<ZoneDeviceForm> devList = form.getZoneDeviceForms();
        HashSet<ZoneDeviceInfo> deviceSet = new HashSet<ZoneDeviceInfo>();
        for (ZoneDeviceForm zoneDeviceForm : devList) {
            ZoneDeviceInfo zoneDeviceInfo = new ZoneDeviceInfo();
            VsmUtil.getInstance().copyProperties(zoneDeviceForm, zoneDeviceInfo);
            deviceSet.add(zoneDeviceInfo);
        }
        info.setZoneDeviceInfos(deviceSet);
        return info;
    }

    private List<ZoneIpLocationForm> tranInfoList2FormList(List<ZoneIpLocationInfo> infoList) {
        ArrayList<ZoneIpLocationForm> formList = new ArrayList<ZoneIpLocationForm>();
        if (infoList != null && !infoList.isEmpty()) {
            for (ZoneIpLocationInfo info : infoList) {
                ZoneIpLocationForm form = new ZoneIpLocationForm();
                VsmUtil.getInstance().copyProperties(info, form);
                formList.add(form);
            }
        }
        return formList;
    }

    private List<ZoneBlackWhiteForm> zoneBlackWhiteTranInfoList2FormList(List<BlackWhiteListInfo> blackWhiteListInfoList) {
        ArrayList<ZoneBlackWhiteForm> blackWhiteFormList = new ArrayList<ZoneBlackWhiteForm>();
        if (blackWhiteListInfoList != null && !blackWhiteListInfoList.isEmpty()) {
            for (BlackWhiteListInfo info : blackWhiteListInfoList) {
                ZoneBlackWhiteForm form = new ZoneBlackWhiteForm();
                VsmUtil.getInstance().copyProperties(info, form);
                blackWhiteFormList.add(form);
            }
        }
        return blackWhiteFormList;
    }

    private List<ZoneWhiteForm> zoneWhiteTranInfoList2FormList(List<BlackWhiteListInfo> whiteListInfoList) {
        ArrayList<ZoneWhiteForm> whiteFormList = new ArrayList<ZoneWhiteForm>();
        if (whiteListInfoList != null && !whiteListInfoList.isEmpty()) {
            for (BlackWhiteListInfo info : whiteListInfoList) {
                ZoneWhiteForm form = new ZoneWhiteForm();
                VsmUtil.getInstance().copyProperties(info, form);
                whiteFormList.add(form);
            }
        }
        return whiteFormList;
    }

    public Long create(ZonePolicyApplyForm form) {
        Long pkid = null;
        if (null != form) {
            ZonePolicyApplyInfo info = this.tranForm2Info(form);
            pkid = (Long)this.userPolicyApplyDao.save(info);
        }
        return pkid;
    }

    public void delete(Long id) {
        this.getUserPolicyApplyDao().delete(id);
    }

    public void delete(ZonePolicyApplyForm form) {
        ZonePolicyApplyInfo info = this.tranForm2Info(form);
        this.userPolicyApplyDao.delete(info);
    }

    public BatchOperationResult deleteInBatch(List<BatchOperation> boList) {
        return null;
    }

    public ZonePolicyApplyForm query(Long id) {
        List<ZonePolicyApplyInfo> userList = this.userPolicyApplyDao.getListByZoneId(id);
        ZonePolicyApplyForm userPolicyApplyForm = null;
        if (!userList.isEmpty()) {
            ZonePolicyApplyInfo zonePolicyApplyInfo = userList.get(0);
            userPolicyApplyForm = this.tranInfo2Form(zonePolicyApplyInfo);
            List<ZoneIpLocationInfo> infoList = this.zoneIpLocationDao.getByZoneId(id);
            List<ZoneIpLocationForm> formList = this.tranInfoList2FormList(infoList);
            Collections.sort(formList);
            userPolicyApplyForm.setZoneIpLocationList(formList);
            List<FilterDeviceZoneInfo> filterDeviceZoneInfoList = this.filterDeviceZoneInfoDao.queryByZoneId(id);
            if (null != filterDeviceZoneInfoList) {
                ArrayList<Long> filterIdList = new ArrayList<Long>();
                for (FilterDeviceZoneInfo filterDeviceZoneInfo : filterDeviceZoneInfoList) {
                    if (filterIdList.contains(filterDeviceZoneInfo.getFilterId())) continue;
                    filterIdList.add(filterDeviceZoneInfo.getFilterId());
                }
                userPolicyApplyForm.setFilterIdList(filterIdList);
            }
            List<BlackWhiteListInfo> blackListInfoList = this.blackWhiteListDao.queryBlackWhiteListByZoneId(id, 1);
            List<ZoneBlackWhiteForm> zoneBlackFormList = this.zoneBlackWhiteTranInfoList2FormList(blackListInfoList);
            Collections.sort(zoneBlackFormList);
            userPolicyApplyForm.setZoneBlackWhiteFormList(zoneBlackFormList);
            List<BlackWhiteListInfo> whiteListInfoList = this.blackWhiteListDao.queryBlackWhiteListByZoneId(id, 2);
            List<ZoneWhiteForm> zonewhiteFormList = this.zoneWhiteTranInfoList2FormList(whiteListInfoList);
            Collections.sort(zonewhiteFormList);
            userPolicyApplyForm.setZoneWhiteFormList(zonewhiteFormList);
        }
        return userPolicyApplyForm;
    }

    public void update(ZonePolicyApplyForm form) {
        if (null != form) {
            ZonePolicyApplyInfo zonePolicyApplyInfo = this.tranForm2Info(form);
            this.userPolicyApplyDao.saveOrUpdate(zonePolicyApplyInfo);
        }
    }

    @Override
    public ZonePolicyApplyForm queryByZoneId(Long id) {
        return this.query(id);
    }

    @Override
    public List<ZonePolicyApplyForm> queryByZoneIds(List<Long> zoneIds) {
        ArrayList<ZonePolicyApplyForm> policyForms = new ArrayList<ZonePolicyApplyForm>();
        if (null == zoneIds || zoneIds.isEmpty()) {
            return policyForms;
        }
        List<ZonePolicyApplyInfo> policyApplyInfos = this.userPolicyApplyDao.queryByZoneIds(zoneIds);
        if (policyApplyInfos.isEmpty()) {
            return policyForms;
        }
        ZonePolicyApplyForm policyForm = null;
        for (ZonePolicyApplyInfo policyInfo : policyApplyInfos) {
            policyForm = this.tranInfo2Form(policyInfo);
            policyForms.add(policyForm);
        }
        return policyForms;
    }

    @Override
    public void updateDDosPolicyDeployedState(Long zoneId) {
        ZonePolicyApplyInfo policyInfo = this.userPolicyApplyDao.getByZoneId(zoneId);
        if (!"UNDEPLOY".equals(policyInfo.getDeployState())) {
            policyInfo.setDeployState("INCREAMENT_UNDEPLOY");
        }
        this.userPolicyApplyDao.update(policyInfo);
        this.updateZoneDeviceDeployStatus(policyInfo);
    }

    private void updateZoneDeviceDeployStatus(ZonePolicyApplyInfo policyInfo) {
        Set<ZoneDeviceInfo> zoneDeviceInfos = policyInfo.getZoneDeviceInfos();
        for (ZoneDeviceInfo zoneDeviceInfo : zoneDeviceInfos) {
            List<ZoneDeviceDeployStatusInfo> statusInfos = this.zoneDeviceDeployStatusDao.getByZoneIdAndDeviceId(policyInfo.getZoneId(), zoneDeviceInfo.getDeviceId());
            if (null == statusInfos || statusInfos.isEmpty()) continue;
            ZoneDeviceDeployStatusInfo tempStatusInfo = statusInfos.get(0);
            tempStatusInfo.setHasChange(true);
            this.zoneDeviceDeployStatusDao.update(tempStatusInfo);
        }
    }

    @Override
    public void updateDeployStateByZoneId(Long zoneId, String deployState) {
        this.userPolicyApplyDao.updateDeployStateByZoneId(zoneId, deployState);
    }

    public void createOrUpdate(ZonePolicyApplyForm form) {
    }

    public Paging queryByPage(Map<String, String> queryMap, int start, int pageSize) {
        return null;
    }

    public void save(ZonePolicyApplyForm form) {
    }

    public void setAticDeviceService(IAticDeviceService aticDeviceService) {
        this.aticDeviceService = aticDeviceService;
    }

    public IAticDeviceService getAticDeviceService() {
        return this.aticDeviceService;
    }

    public ZoneIpLocationDao getZoneIpLocationDao() {
        return this.zoneIpLocationDao;
    }

    public void setZoneIpLocationDao(ZoneIpLocationDao zoneIpLocationDao) {
        this.zoneIpLocationDao = zoneIpLocationDao;
    }

    public BlackWhiteListDao getBlackWhiteListDao() {
        return this.blackWhiteListDao;
    }

    public void setBlackWhiteListDao(BlackWhiteListDao blackWhiteListDao) {
        this.blackWhiteListDao = blackWhiteListDao;
    }

    @Override
    public ZonePolicyApplyForm query(Long id, List<String> features) {
        List<ZonePolicyApplyInfo> zonePolicyApplyInfos;
        ZonePolicyApplyForm userPolicyApplyForm = null;
        if ((null == features || features.contains(Constant.Feature.ZoneBasicPolicyInfo.toString()) || features.contains(Constant.Feature.ZoneDefendModeData.toString())) && !(zonePolicyApplyInfos = this.userPolicyApplyDao.getListByZoneId(id)).isEmpty()) {
            List<BlackWhiteListInfo> blackListInfoList;
            List<FilterDeviceZoneInfo> filterDeviceZoneInfoList;
            ZonePolicyApplyInfo zonePolicyApplyInfo = zonePolicyApplyInfos.get(0);
            userPolicyApplyForm = this.tranInfo2Form(zonePolicyApplyInfo);
            if (null == features || features.contains(Constant.Feature.ZoneIpLocationData.toString())) {
                List<ZoneIpLocationInfo> infoList = this.zoneIpLocationDao.getByZoneId(id);
                List<ZoneIpLocationForm> formList = this.tranInfoList2FormList(infoList);
                Collections.sort(formList);
                userPolicyApplyForm.setZoneIpLocationList(formList);
            }
            if ((null == features || features.contains(Constant.Feature.FilterZoneData.toString())) && null != (filterDeviceZoneInfoList = this.filterDeviceZoneInfoDao.queryByZoneId(id))) {
                ArrayList<Long> filterIdList = new ArrayList<Long>();
                for (FilterDeviceZoneInfo filterDeviceZoneInfo : filterDeviceZoneInfoList) {
                    if (filterIdList.contains(filterDeviceZoneInfo.getFilterId())) continue;
                    filterIdList.add(filterDeviceZoneInfo.getFilterId());
                }
                userPolicyApplyForm.setFilterIdList(filterIdList);
            }
            if ((null == features || features.contains(Constant.Feature.ZoneBlackListData.toString())) && !(blackListInfoList = this.blackWhiteListDao.getBlackWhiteListByZoneIdAndType(id, 1)).isEmpty()) {
                List<ZoneBlackWhiteForm> zoneBlackWhiteFormList = this.zoneBlackWhiteTranInfoList2FormList(blackListInfoList);
                Collections.sort(zoneBlackWhiteFormList);
                userPolicyApplyForm.setZoneBlackWhiteFormList(zoneBlackWhiteFormList);
            }
            if ((null == features || features.contains(Constant.Feature.ZoneWhiteListData.toString())) && !(blackListInfoList = this.blackWhiteListDao.getBlackWhiteListByZoneIdAndType(id, 2)).isEmpty()) {
                List<ZoneWhiteForm> zoneWhiteFormList = this.zoneWhiteTranInfoList2FormList(blackListInfoList);
                Collections.sort(zoneWhiteFormList);
                userPolicyApplyForm.setZoneWhiteFormList(zoneWhiteFormList);
            }
        }
        return userPolicyApplyForm;
    }
}

