/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.service;

import com.hs.atic.sdk.bis.service.IFoundDefaultIdService;
import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.atic.sdk.zone.form.ZoneIpForm;
import com.hs.atic.sdk.zone.service.IZoneService;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.comm.BatchOperation;
import com.hs.lego.core.sdk.comm.BatchOperationResult;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.lego.core.system.syslog.sdk.model.SysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.ISysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.SysoplogLevel;
import com.hs.vsm.common.sdk.util.IPUtil4Atic;
import com.hs.vsm.secservice.ddos.common.CmdUtil;
import com.hs.vsm.secservice.ddos.dao.ZoneDeviceDeployStatusDao;
import com.hs.vsm.secservice.ddos.dao.ZoneFeatureStatusDao;
import com.hs.vsm.secservice.ddos.dao.ZonePolicyApplyDao;
import com.hs.vsm.secservice.ddos.dao.ZoneServiceDao;
import com.hs.vsm.secservice.ddos.dao.ZoneServiceStatusDao;
import com.hs.vsm.secservice.ddos.model.ZoneDeviceDeployStatusInfo;
import com.hs.vsm.secservice.ddos.model.ZoneDeviceInfo;
import com.hs.vsm.secservice.ddos.model.ZoneFeatureStatusInfo;
import com.hs.vsm.secservice.ddos.model.ZonePolicyApplyInfo;
import com.hs.vsm.secservice.ddos.model.ZoneServiceInfo;
import com.hs.vsm.secservice.ddos.model.ZoneServiceStatusInfo;
import com.hs.vsm.secservice.ddos.service.data.ConfigDataTools;
import com.hs.vsm.secservice.ddos.service.data.ZoneConfigData;
import com.hs.vsm.secservice.ddos.service.data.ZoneToDeployData;
import com.hs.vsm.secservice.ddos.util.DDosUtil;
import com.hs.vsm.secservice.sdk.common.util.CrcUtil;
import com.hs.vsm.secservice.sdk.common.util.VsmUtil;
import com.hs.vsm.secservice.sdk.module.ddos.Constant;
import com.hs.vsm.secservice.sdk.module.ddos.form.DnsDefendPolicyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.HttpDefendPolicyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.HttpsDefendPolicyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.IcmpDefendPolicyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.NfaPolicyEditForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.OtherDefendPolicyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.SipDefendPolicyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.TcpDefendPolicyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.TopNStudyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.UdpDefendPolicyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneDeviceForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneModifyDetailForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneServiceForm;
import com.hs.vsm.secservice.sdk.module.ddos.service.IDnsDefendPolicyService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IHttpDefendService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IHttpsDefendPolicyService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IIcmpDefendPolicyService;
import com.hs.vsm.secservice.sdk.module.ddos.service.INfaPolicyEditService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IOtherDefendPolicyService;
import com.hs.vsm.secservice.sdk.module.ddos.service.ISipDefendPolicyService;
import com.hs.vsm.secservice.sdk.module.ddos.service.ITcpDefendService;
import com.hs.vsm.secservice.sdk.module.ddos.service.ITopnStudyDefendService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IUdpDefendPolicyService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneDeviceService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneServiceService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.adapter.capability.model.DeviceTypeInfo;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.huawei.atic.secservice.ddos.service.impl.DdosDevCapabilityServiceImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class ZoneServiceServiceImpl
implements IZoneServiceService {
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private ZoneServiceDao zoneServiceDao;
    private ZonePolicyApplyDao zonePolicyApplyDao;
    private ITcpDefendService tcpDefendService;
    private IHttpDefendService httpDefendService;
    private IHttpsDefendPolicyService httpsDefendPolicyService;
    private IOtherDefendPolicyService otherDefendService;
    private ISipDefendPolicyService sipDefendService;
    private IUdpDefendPolicyService udpDefendPolicyService;
    private IIcmpDefendPolicyService icmpDefendPolicyService;
    private ITopnStudyDefendService topnStudyDefendService;
    private IDnsDefendPolicyService dnsDefendPolicyService;
    private IZoneDeviceService zoneDeviceService;
    private ZoneDeviceDeployStatusDao zoneDeviceDeployStatusDao;
    private ZoneServiceStatusDao zoneServiceStatusDao;
    private ZoneFeatureStatusDao zoneFeatureStatusDao;
    private IZoneService userService;
    private IAticDeviceService aticDeviceService;
    private IFoundDefaultIdService foundDefaultIdService;
    private ConfigDataTools configDataTools;
    private ISysOptLog sysOptLog;
    private INfaPolicyEditService nfaPolicyEditService;

    private void addCopyOperateLog(long zoneId, String fromSerName, String toSerNames) {
        try {
            ZoneInfoForm zoneInfoForm = this.userService.getById(zoneId);
            String zoneName = zoneInfoForm.getZoneDesc();
            SysOptLog sysOptLogLego = new SysOptLog();
            sysOptLogLego.setDate(new Date());
            sysOptLogLego.setLevel(SysoplogLevel.info.getValue());
            sysOptLogLego.setModule("lego.dic.module.ddosApp");
            sysOptLogLego.setOperation("com.hs.vsm.secservice.ddos.policy.operation.name.copy.defservice.success");
            sysOptLogLego.setOperator("system");
            sysOptLogLego.setTarget(zoneName);
            sysOptLogLego.setResult(1);
            sysOptLogLego.setDetail("com.hs.vsm.secservice.ddos.policy.operation.detail.copy.defservice.success");
            String[] para = new String[]{zoneName, fromSerName, toSerNames};
            sysOptLogLego.setDetailPara(para);
            sysOptLogLego.setTerminalIp("127.0.0.1");
            this.sysOptLog.writeOptLog(sysOptLogLego);
        }
        catch (RuntimeException e) {
            this.logger.error((Object)"generate addCopyOperateLog error");
        }
    }

    private void buildProtocolList(ZoneServiceForm form, List<String> protocolList) {
        ArrayList<String> tcpList = new ArrayList<String>();
        tcpList.add("TCP");
        tcpList.add("HTTP");
        tcpList.add("HTTPS");
        tcpList.add("TCP_DNS");
        ArrayList<String> udpList = new ArrayList<String>();
        udpList.add("UDP");
        udpList.add("SIP");
        udpList.add("UDP_DNS");
        ArrayList<String> bothList = new ArrayList<String>();
        bothList.add("DNS");
        ArrayList<String> otherList = new ArrayList<String>();
        otherList.add("Other");
        String protocol = form.getProtocol();
        if (bothList.contains(protocol)) {
            protocolList.addAll(tcpList);
            protocolList.addAll(udpList);
            protocolList.addAll(bothList);
        } else if (udpList.contains(protocol)) {
            protocolList.addAll(udpList);
            protocolList.addAll(bothList);
        } else if (tcpList.contains(protocol)) {
            protocolList.addAll(tcpList);
            protocolList.addAll(bothList);
        } else if (otherList.contains(protocol)) {
            protocolList.addAll(otherList);
        }
    }

    private void checkAssociatedDeviceExist(Long zoneID, Long deviceId, String protocol) {
        if ("DEFAULT".equals(protocol)) {
            return;
        }
        ZoneDeviceForm zoneDeviceForm = this.zoneDeviceService.findZoneDeviceFormByZoneIdAndDeviceId(zoneID, deviceId);
        if (null == zoneDeviceForm) {
            throw new LegoCheckedException(630135L);
        }
    }

    private void checkCustomServiceUpperLimit(List<ZoneServiceInfo> zoneServInfos, String protocol, Long deviceId) {
        Boolean hasDefault = false;
        Integer serviceperzoneupperlimit = Constant.PORT_SERVICE_ZONE_MAXIMUM_DEVICE;
        for (int k = 0; k < zoneServInfos.size(); ++k) {
            if (!zoneServInfos.get(k).getProtocol().equals("DEFAULT")) continue;
            hasDefault = true;
        }
        if (hasDefault != false ? zoneServInfos.size() > serviceperzoneupperlimit : !"DEFAULT".equals(protocol) && zoneServInfos.size() == serviceperzoneupperlimit.intValue()) {
            throw new LegoCheckedException(630003L);
        }
    }

    @Override
    public Boolean checkIpAddrValid(String ipAddr, Long zoneId) {
        ZoneInfoForm zoneInfoForm = this.userService.getById(zoneId);
        if (null == zoneInfoForm) {
            return false;
        }
        List<ZoneIpForm> ipForms = zoneInfoForm.getZoneIpFormList();
        if (ipForms == null || ipForms.isEmpty()) {
            return false;
        }
        for (ZoneIpForm ipForm : ipForms) {
            String[] ipRange = new String[2];
            String startIp = ipForm.getStartIp();
            String endIp = ipForm.getEndIp();
            if (null == startIp || null == endIp) {
                ipRange = IPUtil.getSubnetRange((String)ipForm.getZoneIp(), (int)ipForm.getMask());
            } else {
                ipRange[0] = startIp;
                ipRange[1] = endIp;
            }
            if (!IPUtil4Atic.isInIpRange((String[])ipRange, (String)ipAddr)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Boolean checkIpAddrValid(String ipAddr, Long zoneId, Long deviceId) {
        Boolean flag = false;
        ZoneInfoForm zoneInfoForm = this.userService.getById(zoneId);
        if (Constant.ZONE_TYPE_OF_DEFAULT.equals(zoneInfoForm.getZoneType())) {
            flag = true;
            List zoneIds = this.zoneDeviceService.getZonesByDevId(deviceId);
            if (null != zoneIds && !zoneIds.isEmpty()) {
                for (Long singleZoneId : zoneIds) {
                    ZoneInfoForm infoForm;
                    if (zoneId.equals(singleZoneId) || !this.customZoneServiceIPCheck(infoForm = this.userService.getById(singleZoneId), ipAddr).booleanValue()) continue;
                    flag = false;
                    break;
                }
            }
        } else {
            flag = this.customZoneServiceIPCheck(zoneInfoForm, ipAddr);
        }
        return flag;
    }

    private String checkIpInUse(String[] ipArr, ZoneServiceForm serviceForm) {
        for (String ipStr : ipArr) {
            String[] serviceIps;
            String startIpStr = ipStr.split(",")[0];
            String endIpStr = ipStr.split(",")[1];
            for (String serviceIp : serviceIps = serviceForm.getIpList().split(";")) {
                String[] ipRange = new String[]{startIpStr, endIpStr};
                if (!IPUtil4Atic.isInIpRange((String[])ipRange, (String)serviceIp)) continue;
                return startIpStr + "," + endIpStr;
            }
        }
        return "";
    }

    private void checkSameServiceExist(List<ZoneServiceInfo> zoneServInfos, String portList) {
        if (StringUtils.isEmpty((CharSequence)portList)) {
            return;
        }
        for (int i = 0; i < zoneServInfos.size(); ++i) {
            ZoneServiceInfo info = zoneServInfos.get(i);
            String portListInDB = info.getPortList();
            String[] portArrayInDB = null;
            if (StringUtils.isEmpty((CharSequence)portListInDB)) continue;
            portArrayInDB = portListInDB.split(";");
            String[] portArray = portList.split(";");
            this.sameServiceCheck(portArrayInDB, portArray);
        }
    }

    @Override
    public void checkServiceValid(ZoneServiceForm form) {
        String protocol = form.getProtocol();
        String portList = form.getPortList();
        List<ZoneServiceInfo> zoneServInfos = this.getZoneServiceDao().getByMultiId(form);
        List<ZoneServiceInfo> servInfos = this.getZoneServiceDao().getByMultiIdAndServiceName(form);
        if (!servInfos.isEmpty()) {
            throw new LegoCheckedException(630001L);
        }
        if (!zoneServInfos.isEmpty()) {
            DdosDevCapabilityServiceImpl devCapabilityService = DdosDevCapabilityServiceImpl.getInstance();
            DeviceTypeInfo devTypeInfo = null;
            devTypeInfo = CmdUtil.getDevTypeInfo(form.getDeviceId());
            Set supportAttrs = devCapabilityService.getAllSupportedAttr(devTypeInfo);
            Boolean isSupportPortService = supportAttrs.contains("isSupportPortService");
            if (isSupportPortService.booleanValue()) {
                this.checkCustomServiceUpperLimit(zoneServInfos, protocol, form.getDeviceId());
                this.checkSameServiceExist(zoneServInfos, portList);
            }
        }
    }

    @Override
    public void checkServiceValid4Import(ZoneServiceForm form) {
        ZoneServiceForm form1 = form;
        AticDevice aticDevice = null;
        if (null != form1.getDeviceId()) {
            aticDevice = this.aticDeviceService.getDeviceByMoid(form1.getDeviceId().longValue());
        } else if (null != form1.getDeviceIp()) {
            aticDevice = this.aticDeviceService.getDeviceByIp(form1.getDeviceIp());
        }
        if (null != aticDevice) {
            if (null != form1.getPortType() && 1 != aticDevice.getDeviceType()) {
                throw new LegoCheckedException(733037L);
            }
            form1.setDeviceId(aticDevice.getMoId());
        }
        String protocol = form1.getProtocol();
        String portList = form1.getPortList();
        List<ZoneServiceInfo> zoneServInfos = null;
        zoneServInfos = this.getZoneServiceDao().getByMultiServiceName(form1);
        if (!zoneServInfos.isEmpty()) {
            DdosDevCapabilityServiceImpl devCapabilityService = DdosDevCapabilityServiceImpl.getInstance();
            DeviceTypeInfo devTypeInfo = null;
            devTypeInfo = CmdUtil.getDevTypeInfo(form1.getDeviceId());
            Set supportAttrs = devCapabilityService.getAllSupportedAttr(devTypeInfo);
            Boolean isSupportPortService = supportAttrs.contains("isSupportPortService");
            if (isSupportPortService.booleanValue()) {
                this.checkCustomServiceUpperLimit(zoneServInfos, protocol, form1.getDeviceId());
                this.checkSameServiceExist(zoneServInfos, portList);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void checkUnvalidDelService(ZoneServiceForm form) {
        void var12_18;
        Long zoneID = form.getZoneId();
        Long deviceId = form.getDeviceId();
        int direction = form.getDirection();
        List<ZoneServiceForm> zoneServiceForms = this.queryAllZoneService(String.valueOf(zoneID), String.valueOf(deviceId), direction);
        HashMap<Integer, Object> condition = new HashMap<Integer, Object>();
        condition.put(0, zoneID);
        condition.put(1, deviceId);
        List serviceStatusInfos = this.zoneServiceStatusDao.queryByHql(" from ZoneServiceStatusInfo where zoneId = ? and deviceId = ? and protocol !='DEFAULT'", condition);
        condition.put(2, ZoneServiceForm.class.getSimpleName());
        List zoneFeatureStatusInfos = this.zoneFeatureStatusDao.queryByHql(" from ZoneFeatureStatusInfo where zoneId = ? and deviceId = ? and featureType = ? and deployState = true", condition);
        ArrayList<Long> delServiceIds = new ArrayList<Long>();
        ArrayList<Long> serviceIds = new ArrayList<Long>();
        for (ZoneServiceForm zoneServiceForm : zoneServiceForms) {
            serviceIds.add(zoneServiceForm.getPkid());
        }
        ArrayList<Long> serviceIdsWithoutDefaultAndZoneServiceToUndeploy = new ArrayList<Long>();
        for (ZoneServiceStatusInfo zoneServiceStatInfo : serviceStatusInfos) {
            serviceIdsWithoutDefaultAndZoneServiceToUndeploy.add(zoneServiceStatInfo.getServiceId());
        }
        if (zoneFeatureStatusInfos != null) {
            for (ZoneFeatureStatusInfo featureStatusInfo : zoneFeatureStatusInfos) {
                if (serviceIds.contains(featureStatusInfo.getFeatureId()) || !serviceIdsWithoutDefaultAndZoneServiceToUndeploy.contains(featureStatusInfo.getFeatureId())) continue;
                delServiceIds.add(featureStatusInfo.getFeatureId());
            }
        }
        Object var12_16 = null;
        if (0 != delServiceIds.size()) {
            HashMap<Integer, Long> condition1 = new HashMap<Integer, Long>();
            int index1 = 0;
            StringBuffer hql = new StringBuffer();
            hql.append("from ZoneServiceStatusInfo where zoneId = ?  and deviceId = ?  and serviceId in ( ");
            condition1.put(index1++, zoneID);
            condition1.put(index1++, deviceId);
            for (int i = 0; i < delServiceIds.size(); ++i) {
                condition1.put(index1++, (Long)delServiceIds.get(i));
                if (0 == i) {
                    hql.append("?");
                    continue;
                }
                hql.append(",?");
            }
            hql.append(")");
            List list = this.zoneServiceStatusDao.queryByHql(hql.toString(), condition1);
        }
        ArrayList<String> serviceNamesDel = new ArrayList<String>();
        if (null != var12_18 && !var12_18.isEmpty()) {
            for (ZoneServiceStatusInfo serviceStatusInfo : var12_18) {
                serviceNamesDel.add(serviceStatusInfo.getServiceName());
            }
        }
        if (serviceNamesDel.contains(form.getServiceName())) {
            throw new LegoCheckedException(630156L);
        }
    }

    @Override
    public void copyZoneSerivce(long zoneId, long fromDevId, String[] toDevIds) {
        ZoneServiceForm fromServ = this.queryByZonePairAndProtocol(zoneId, fromDevId, "DEFAULT");
        if (null == fromServ) {
            this.logger.error((Object)"fromServ is null");
            return;
        }
        StringBuffer targetSerName = new StringBuffer();
        for (String each : toDevIds) {
            AticDevice fw = this.aticDeviceService.getDeviceByIp(each);
            ZoneServiceForm eachService = this.queryByZonePairAndProtocol(zoneId, fw.getMoId(), "DEFAULT");
            if (null == eachService) {
                this.logger.error((Object)"eachService is null");
                return;
            }
            targetSerName.append(eachService.getServiceName());
            targetSerName.append(',');
            ZoneServiceInfo oldInfo = new ZoneServiceInfo();
            VsmUtil.getInstance().copyProperties(eachService, oldInfo);
            ZoneServiceForm target = new ZoneServiceForm();
            VsmUtil.getInstance().copyProperties(fromServ, target);
            VsmUtil.getInstance().copyProperties(oldInfo, target);
            long targetServiceId = oldInfo.getPkid();
            target.getTcpDefendPolicyForm().setServiceId(targetServiceId);
            target.getTcpDefendPolicyForm().setId(eachService.getTcpDefendPolicyForm().getId());
            target.getUdpDefendPolicyForm().setServiceId(targetServiceId);
            target.getUdpDefendPolicyForm().setId(eachService.getUdpDefendPolicyForm().getId());
            target.getIcmpDefendPolicyForm().setServiceId(targetServiceId);
            target.getIcmpDefendPolicyForm().setId(eachService.getIcmpDefendPolicyForm().getId());
            target.getHttpDefendPolicyForm().setServiceId(targetServiceId);
            target.getHttpDefendPolicyForm().setId(eachService.getHttpDefendPolicyForm().getId());
            target.getHttpsDefendPolicyForm().setServiceId(targetServiceId);
            target.getHttpsDefendPolicyForm().setId(eachService.getHttpsDefendPolicyForm().getId());
            target.getSipDefendPolicyForm().setServiceId(targetServiceId);
            target.getSipDefendPolicyForm().setId(eachService.getSipDefendPolicyForm().getId());
            target.getDnsDefendPolicyForm().setServiceId(targetServiceId);
            target.getDnsDefendPolicyForm().setId(eachService.getDnsDefendPolicyForm().getId());
            target.getOtherDefendPolicyForm().setServiceId(targetServiceId);
            target.getOtherDefendPolicyForm().setId(eachService.getOtherDefendPolicyForm().getId());
            target.getTopNStudyForm().setServiceId(targetServiceId);
            target.getTopNStudyForm().setId(eachService.getTopNStudyForm().getId());
            this.create(target);
        }
        this.addCopyOperateLog(zoneId, fromServ.getServiceName(), targetSerName.substring(0, targetSerName.length() - 1));
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    public Long create(ZoneServiceForm form) {
        long startTime = System.currentTimeMillis();
        this.logger.info((Object)("The create() start time is " + startTime));
        Boolean isLockZoneOK = false;
        ArrayList<Long> zoneIds = new ArrayList<Long>();
        try {
            Long pkid = -1L;
            if (null == form) {
                Long l = pkid;
                return l;
            }
            zoneIds.add(form.getZoneId());
            if (!"DEFAULT".equals(form.getProtocol()) || form.getPkid() != null) {
                isLockZoneOK = VsmUtil.getInstance().lockZones(zoneIds, "editPolicy");
            }
            this.logger.info((Object)"enter create service");
            Long zoneID = form.getZoneId();
            this.checkAssociatedDeviceExist(zoneID, form.getDeviceId(), form.getProtocol());
            ArrayList<String> protocolList = new ArrayList<String>();
            this.buildProtocolList(form, protocolList);
            this.checkUnvalidDelService(form);
            this.checkServiceValid(form);
            Long currentCrc = CrcUtil.getCrcValue(form.getCalcCrcString());
            this.logger.info((Object)("ZoneServiceForm getCrcString : " + this.getcleanedMessage(form.getCalcCrcString())));
            this.logger.info((Object)("currentcrc in createService : " + currentCrc));
            form.setCurrentCrc(currentCrc);
            ZoneServiceInfo info = new ZoneServiceInfo();
            VsmUtil.getInstance().copyProperties(form, info);
            if (form.getPkid() == null || form.getPkid() == 0L) {
                pkid = (Long)this.getZoneServiceDao().save(info);
                this.setServiceType(form);
                form.setPkid(pkid);
                this.createServicePolicy(form);
            } else {
                pkid = form.getPkid();
                ZoneServiceInfo infoInDB = this.getZoneServiceDao().get(pkid);
                if (infoInDB != null) {
                    info.setDeployedCrc(infoInDB.getDeployedCrc());
                    form.setDeployedCrc(infoInDB.getDeployedCrc());
                }
                this.logger.info((Object)("The saveOrUpdate() start time is " + (System.currentTimeMillis() - startTime) + "ms"));
                this.getZoneServiceDao().saveOrUpdate(info);
                this.logger.info((Object)("The saveOrUpdate() used times is " + (System.currentTimeMillis() - startTime) + "ms"));
                this.saveServicePolicy(form);
                this.logger.info((Object)("The saveServicePolicy() used times is " + (System.currentTimeMillis() - startTime) + "ms"));
            }
            AticDevice device = this.aticDeviceService.getDeviceByMoid(form.getDeviceId().longValue());
            ZonePolicyApplyInfo zonePolicyApplyInfo = this.zonePolicyApplyDao.getByZoneId(zoneID);
            if (device.getDeviceType() == 1) {
                List<ZoneModifyDetailForm> modifyDetailForms = this.getZoneModifyDetail(zoneID);
                if (null == modifyDetailForms || modifyDetailForms.isEmpty()) {
                    List<ZoneFeatureStatusInfo> list = this.zoneFeatureStatusDao.queryByZoneId(zoneID);
                    boolean featureStatus = true;
                    if (list != null) {
                        for (ZoneFeatureStatusInfo each : list) {
                            if (each.getDeployState().booleanValue()) continue;
                            featureStatus = false;
                        }
                    }
                    if (featureStatus) {
                        zonePolicyApplyInfo.setDeployState("SUCCESS");
                    } else {
                        zonePolicyApplyInfo.setDeployState("PART_SUCCESS");
                    }
                    this.zonePolicyApplyDao.saveOrUpdate(zonePolicyApplyInfo);
                    this.logger.info((Object)("The saveOrUpdate() used times is " + (System.currentTimeMillis() - startTime) + "ms"));
                } else {
                    if (!"UNDEPLOY".equals(zonePolicyApplyInfo.getDeployState())) {
                        zonePolicyApplyInfo.setDeployState("INCREAMENT_UNDEPLOY");
                    }
                    this.zonePolicyApplyDao.saveOrUpdate(zonePolicyApplyInfo);
                    this.logger.info((Object)("The saveOrUpdate() used times is " + (System.currentTimeMillis() - startTime) + "ms"));
                    this.notifyZoneDeviceDeployStatusChanged(form);
                    this.logger.info((Object)("The notifyZoneDeviceDeployStatusChanged() used times is " + (System.currentTimeMillis() - startTime) + "ms"));
                }
            } else if (device.getDeviceType() == 5 || device.getDeviceType() == 7) {
                if (!"UNDEPLOY".equals(zonePolicyApplyInfo.getDeployState()) && info.getCurrentCrc().longValue() != info.getDeployedCrc().longValue()) {
                    zonePolicyApplyInfo.setDeployState("INCREAMENT_UNDEPLOY");
                }
                this.zonePolicyApplyDao.saveOrUpdate(zonePolicyApplyInfo);
            }
            try {
                if (!"DEFAULT".equals(form.getProtocol())) {
                    this.getFoundDefaultIdService().refreshUserDefBizData();
                }
            }
            catch (Exception e) {
                this.logger.error((Object)"refreshUserDefBizData error");
            }
            this.logger.info((Object)"leave create service");
            Long l = pkid;
            return l;
        }
        catch (LegoCheckedException e) {
            this.logger.error((Object)("create service is error: " + e.getErrorCode()));
            throw new LegoCheckedException(e.getErrorCode());
        }
        catch (Exception e) {
            this.logger.error((Object)("create service is error: " + e.getMessage()));
            throw new LegoCheckedException(630114L);
        }
        finally {
            if (isLockZoneOK.booleanValue()) {
                VsmUtil.getInstance().unlockZones(zoneIds);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long creatZoneServiceNoRefreshClollector(ZoneServiceForm form) {
        long startTime = System.currentTimeMillis();
        Boolean isLockZoneOK = false;
        ArrayList<Long> zoneIds = new ArrayList<Long>();
        try {
            Long pkid = -1L;
            if (null == form) {
                Long l = pkid;
                return l;
            }
            zoneIds.add(form.getZoneId());
            if (!"DEFAULT".equals(form.getProtocol()) || form.getPkid() != null) {
                isLockZoneOK = VsmUtil.getInstance().lockZones(zoneIds, "editPolicy");
            }
            this.logger.info((Object)"enter create service");
            Long zoneID = form.getZoneId();
            this.checkAssociatedDeviceExist(zoneID, form.getDeviceId(), form.getProtocol());
            ArrayList<String> protocolList = new ArrayList<String>();
            this.buildProtocolList(form, protocolList);
            this.checkUnvalidDelService(form);
            this.checkServiceValid(form);
            Long currentCrc = CrcUtil.getCrcValue(form.getCalcCrcString());
            this.logger.info((Object)("ZoneServiceForm getCrcString : " + this.getcleanedMessage(form.getCalcCrcString())));
            this.logger.info((Object)("currentcrc in createService : " + currentCrc));
            form.setCurrentCrc(currentCrc);
            ZoneServiceInfo info = new ZoneServiceInfo();
            VsmUtil.getInstance().copyProperties(form, info);
            if (form.getPkid() == null || form.getPkid() == 0L) {
                pkid = (Long)this.getZoneServiceDao().save(info);
                this.setServiceType(form);
                form.setPkid(pkid);
                this.createServicePolicy(form);
            } else {
                pkid = form.getPkid();
                ZoneServiceInfo infoInDB = this.getZoneServiceDao().get(pkid);
                if (infoInDB != null) {
                    info.setDeployedCrc(infoInDB.getDeployedCrc());
                    form.setDeployedCrc(infoInDB.getDeployedCrc());
                }
                this.getZoneServiceDao().saveOrUpdate(info);
                this.saveServicePolicy(form);
            }
            AticDevice device = this.aticDeviceService.getDeviceByMoid(form.getDeviceId().longValue());
            ZonePolicyApplyInfo zonePolicyApplyInfo = this.zonePolicyApplyDao.getByZoneId(zoneID);
            if (device.getDeviceType() == 1) {
                List<ZoneModifyDetailForm> modifyDetailForms = this.getZoneModifyDetail(zoneID);
                if (null == modifyDetailForms || modifyDetailForms.isEmpty()) {
                    List<ZoneFeatureStatusInfo> list = this.zoneFeatureStatusDao.queryByZoneId(zoneID);
                    boolean featureStatus = true;
                    if (list != null) {
                        for (ZoneFeatureStatusInfo each : list) {
                            if (each.getDeployState().booleanValue()) continue;
                            featureStatus = false;
                        }
                    }
                    if (featureStatus) {
                        zonePolicyApplyInfo.setDeployState("SUCCESS");
                    } else {
                        zonePolicyApplyInfo.setDeployState("PART_SUCCESS");
                    }
                    this.zonePolicyApplyDao.saveOrUpdate(zonePolicyApplyInfo);
                } else {
                    if (!"UNDEPLOY".equals(zonePolicyApplyInfo.getDeployState())) {
                        zonePolicyApplyInfo.setDeployState("INCREAMENT_UNDEPLOY");
                    }
                    this.zonePolicyApplyDao.saveOrUpdate(zonePolicyApplyInfo);
                    this.notifyZoneDeviceDeployStatusChanged(form);
                }
            }
            this.logger.info((Object)"leave create service");
            Long l = pkid;
            return l;
        }
        finally {
            this.logger.info((Object)("The create() used times is " + (System.currentTimeMillis() - startTime) + "ms"));
            if (isLockZoneOK.booleanValue()) {
                VsmUtil.getInstance().unlockZones(zoneIds);
            }
        }
    }

    private void createDnsPolicy(ZoneServiceForm form, Long serviceId) {
        if (null != form.getDnsDefendPolicyForm()) {
            form.getDnsDefendPolicyForm().setServiceId(serviceId);
            this.dnsDefendPolicyService.create(form.getDnsDefendPolicyForm());
        } else {
            DnsDefendPolicyForm dnsForm = new DnsDefendPolicyForm();
            dnsForm.setServiceId(serviceId);
            this.dnsDefendPolicyService.create(dnsForm);
        }
    }

    private void createHttpPolicy(ZoneServiceForm form, Long serviceId) {
        if (null != form.getHttpDefendPolicyForm()) {
            form.getHttpDefendPolicyForm().setServiceId(serviceId);
            this.httpDefendService.create(form.getHttpDefendPolicyForm());
        } else {
            HttpDefendPolicyForm httpForm = new HttpDefendPolicyForm();
            httpForm.setServiceId(serviceId);
            this.httpDefendService.create(httpForm);
        }
    }

    private void createHttpsPolicy(ZoneServiceForm form, Long serviceId) {
        if (null != form.getHttpsDefendPolicyForm()) {
            form.getHttpsDefendPolicyForm().setServiceId(serviceId);
            this.httpsDefendPolicyService.create(form.getHttpsDefendPolicyForm());
        } else {
            HttpsDefendPolicyForm httpsForm = new HttpsDefendPolicyForm();
            httpsForm.setServiceId(serviceId);
            this.httpsDefendPolicyService.create(httpsForm);
        }
    }

    private void createIcmpPolicy(ZoneServiceForm form, Long serviceId) {
        if (null != form.getIcmpDefendPolicyForm()) {
            form.getIcmpDefendPolicyForm().setServiceId(serviceId);
            this.icmpDefendPolicyService.create(form.getIcmpDefendPolicyForm());
        } else {
            IcmpDefendPolicyForm icmpForm = new IcmpDefendPolicyForm();
            icmpForm.setServiceId(serviceId);
            this.icmpDefendPolicyService.create(icmpForm);
        }
    }

    public void createOrUpdate(ZoneServiceForm form) {
        this.save(form);
    }

    private void createOtherPolicy(ZoneServiceForm form, Long serviceId) {
        if (null != form.getOtherDefendPolicyForm()) {
            form.getOtherDefendPolicyForm().setServiceId(serviceId);
            this.otherDefendService.create(form.getOtherDefendPolicyForm());
        } else {
            OtherDefendPolicyForm otherForm = new OtherDefendPolicyForm();
            otherForm.setServiceId(serviceId);
            this.otherDefendService.create(otherForm);
        }
    }

    private void createServicePolicy(ZoneServiceForm form) {
        String serviceProtocol = form.getProtocol();
        Long serviceId = form.getPkid();
        int direction = form.getDirection();
        List<String> policys = ZoneServiceForm.getService2policy().get(serviceProtocol);
        AticDevice device = this.aticDeviceService.getDeviceByMoid(form.getDeviceId().longValue());
        if (device == null) {
            this.logger.error((Object)("securityNE has been deleted!! " + form.getDeviceId()));
            return;
        }
        DdosDevCapabilityServiceImpl devCapabilityService = DdosDevCapabilityServiceImpl.getInstance();
        DeviceTypeInfo devTypeInfo = CmdUtil.getDevTypeInfo(form.getDeviceId());
        Set supportAttrs = devCapabilityService.getAllSupportedAttr(devTypeInfo);
        Boolean isSupportWithServiceViewCustomService = supportAttrs.contains("withServiceViewCustomService");
        if (5 == device.getDeviceType() || 7 == device.getDeviceType()) {
            this.createNfaPolicy(form, serviceId);
            return;
        }
        if (policys.contains("TCP")) {
            this.createTcpPolicy(form, serviceId, isSupportWithServiceViewCustomService);
        }
        if (policys.contains("UDP")) {
            this.createUdpPolicy(form, serviceId);
        }
        if (policys.contains("ICMP")) {
            this.createIcmpPolicy(form, serviceId);
        }
        if (policys.contains("HTTP") && direction == 1) {
            this.createHttpPolicy(form, serviceId);
        }
        if (policys.contains("HTTPS") && direction == 1) {
            this.createHttpsPolicy(form, serviceId);
        }
        if (policys.contains("DNS") && direction == 1) {
            this.createDnsPolicy(form, serviceId);
        }
        if (policys.contains("SIP") && direction == 1) {
            this.createSipPolicy(form, serviceId);
        }
        if (policys.contains("Other") && direction == 1) {
            this.createOtherPolicy(form, serviceId);
        }
        if (policys.contains("TOPNSTUDY") && direction == 1) {
            this.createTopnZonePolicy(form, serviceId);
        }
    }

    private void createNfaPolicy(ZoneServiceForm form, Long serviceId) {
        if (form.getNfaPolicyEditForm() != null) {
            form.getNfaPolicyEditForm().setServiceId(serviceId);
            form.getNfaPolicyEditForm().setZoneId(form.getZoneId());
            this.nfaPolicyEditService.createOrUpdate(form.getNfaPolicyEditForm());
        } else {
            NfaPolicyEditForm nfaPolicyEditForm = new NfaPolicyEditForm();
            nfaPolicyEditForm.setServiceId(serviceId);
            this.nfaPolicyEditService.createOrUpdate(nfaPolicyEditForm);
        }
    }

    private void createSipPolicy(ZoneServiceForm form, Long serviceId) {
        if (null != form.getSipDefendPolicyForm()) {
            form.getSipDefendPolicyForm().setServiceId(serviceId);
            this.sipDefendService.create(form.getSipDefendPolicyForm());
        } else {
            SipDefendPolicyForm sipForm = new SipDefendPolicyForm();
            sipForm.setServiceId(serviceId);
            this.sipDefendService.create(sipForm);
        }
    }

    private void createTcpPolicy(ZoneServiceForm form, Long serviceId, Boolean isSupportWithServiceViewCustomService) {
        if (form.getTcpDefendPolicyForm() != null) {
            form.getTcpDefendPolicyForm().setServiceId(serviceId);
            this.tcpDefendService.create(form.getTcpDefendPolicyForm());
        } else if (this.isNotHttpServiceR1(form, isSupportWithServiceViewCustomService).booleanValue()) {
            TcpDefendPolicyForm tcpForm = new TcpDefendPolicyForm();
            tcpForm.setServiceId(serviceId);
            this.tcpDefendService.create(tcpForm);
        }
    }

    private void createTopnZonePolicy(ZoneServiceForm form, Long serviceId) {
        if (form.getTopNStudyForm() != null) {
            form.getTopNStudyForm().setServiceId(serviceId);
            this.topnStudyDefendService.create(form.getTopNStudyForm());
        } else {
            TopNStudyForm topnStudyForm = new TopNStudyForm();
            topnStudyForm.setServiceId(serviceId);
            this.topnStudyDefendService.create(topnStudyForm);
        }
    }

    private void createUdpPolicy(ZoneServiceForm form, Long serviceId) {
        if (form.getUdpDefendPolicyForm() != null) {
            form.getUdpDefendPolicyForm().setServiceId(serviceId);
            this.udpDefendPolicyService.create(form.getUdpDefendPolicyForm());
        } else {
            UdpDefendPolicyForm udpForm = new UdpDefendPolicyForm();
            udpForm.setServiceId(serviceId);
            this.udpDefendPolicyService.create(udpForm);
        }
    }

    private Boolean customZoneServiceIPCheck(ZoneInfoForm zoneInfoForm, String ipAddr) {
        List<ZoneIpForm> ipForms = zoneInfoForm.getZoneIpFormList();
        if (ipForms == null || ipForms.isEmpty()) {
            return false;
        }
        for (ZoneIpForm ipForm : ipForms) {
            String startIp = ipForm.getStartIp();
            String endIp = ipForm.getEndIp();
            String[] ipRange = new String[2];
            if (null == startIp || null == endIp) {
                ipRange = IPUtil.getSubnetRange((String)ipForm.getZoneIp(), (int)ipForm.getMask());
            } else {
                ipRange[0] = startIp;
                ipRange[1] = endIp;
            }
            if (!IPUtil4Atic.isInIpRange((String[])ipRange, (String)ipAddr)) continue;
            return true;
        }
        return false;
    }

    public void delete(Long id) {
        ZoneServiceForm form = this.queryByZoneServiceID(id);
        if (null != form) {
            this.getZoneServiceDao().delete(id);
            this.tcpDefendService.deleteByServiceId(id);
            this.udpDefendPolicyService.deleteByServiceId(id);
            this.icmpDefendPolicyService.deleteByServiceId(id);
            this.httpDefendService.deleteByServiceId(id);
            this.httpsDefendPolicyService.deleteByServiceId(id);
            this.sipDefendService.deleteByServiceId(id);
            this.otherDefendService.deleteByServiceId(id);
            this.dnsDefendPolicyService.deleteByServiceId(id);
            ZonePolicyApplyInfo zonePolicyApplyInfo = this.zonePolicyApplyDao.getByZoneId(form.getZoneId());
            if (!"UNDEPLOY".equals(zonePolicyApplyInfo.getDeployState())) {
                List<ZoneModifyDetailForm> modifyDetailForms = this.getZoneModifyDetail(form.getZoneId());
                if (null == modifyDetailForms || modifyDetailForms.isEmpty()) {
                    zonePolicyApplyInfo.setDeployState("SUCCESS");
                } else {
                    zonePolicyApplyInfo.setDeployState("INCREAMENT_UNDEPLOY");
                }
            }
            this.zonePolicyApplyDao.saveOrUpdate(zonePolicyApplyInfo);
        }
    }

    public void delete(ZoneServiceForm form) {
        this.delete(form.getPkid());
        ZonePolicyApplyInfo zonePolicyApplyInfo = this.zonePolicyApplyDao.getByZoneId(form.getZoneId());
        if (!"UNDEPLOY".equals(zonePolicyApplyInfo.getDeployState())) {
            zonePolicyApplyInfo.setDeployState("INCREAMENT_UNDEPLOY");
        }
        this.zonePolicyApplyDao.saveOrUpdate(zonePolicyApplyInfo);
        try {
            this.getFoundDefaultIdService().refreshUserDefBizData();
        }
        catch (Exception e) {
            this.logger.error((Object)("refreshUserDefBizData error : " + e));
        }
    }

    @Override
    public void deleteByDeviceId(long deviceId) {
        List<ZoneServiceForm> zoneServiceFormList = this.queryByDeviceId(deviceId);
        if (!zoneServiceFormList.isEmpty()) {
            for (ZoneServiceForm zoneServiceForm : zoneServiceFormList) {
                this.getZoneServiceDao().delete(zoneServiceForm.getPkid());
                this.tcpDefendService.deleteByServiceId(zoneServiceForm.getPkid());
                this.udpDefendPolicyService.deleteByServiceId(zoneServiceForm.getPkid());
                this.icmpDefendPolicyService.deleteByServiceId(zoneServiceForm.getPkid());
                this.httpDefendService.deleteByServiceId(zoneServiceForm.getPkid());
                this.httpsDefendPolicyService.deleteByServiceId(zoneServiceForm.getPkid());
                this.sipDefendService.deleteByServiceId(zoneServiceForm.getPkid());
                this.otherDefendService.deleteByServiceId(zoneServiceForm.getPkid());
                this.dnsDefendPolicyService.deleteByServiceId(zoneServiceForm.getPkid());
                this.nfaPolicyEditService.deleteByServiceId(zoneServiceForm.getPkid());
            }
        }
    }

    @Override
    public void deleteByDeviceIdAndZoneId(long deviceId, long zoneId) {
        List<ZoneServiceInfo> zoneServiceInfoList = this.zoneServiceDao.getZoneServiceInfoListByZoneIdAndDeviceId(zoneId, deviceId);
        if (null != zoneServiceInfoList && !zoneServiceInfoList.isEmpty()) {
            for (ZoneServiceInfo zoneServiceInfo : zoneServiceInfoList) {
                this.getZoneServiceDao().delete(zoneServiceInfo.getPkid());
                this.tcpDefendService.deleteByServiceId(zoneServiceInfo.getPkid());
                this.udpDefendPolicyService.deleteByServiceId(zoneServiceInfo.getPkid());
                this.icmpDefendPolicyService.deleteByServiceId(zoneServiceInfo.getPkid());
                this.httpDefendService.deleteByServiceId(zoneServiceInfo.getPkid());
                this.httpsDefendPolicyService.deleteByServiceId(zoneServiceInfo.getPkid());
                this.sipDefendService.deleteByServiceId(zoneServiceInfo.getPkid());
                this.otherDefendService.deleteByServiceId(zoneServiceInfo.getPkid());
                this.dnsDefendPolicyService.deleteByServiceId(zoneServiceInfo.getPkid());
            }
        }
    }

    public BatchOperationResult deleteInBatch(List<BatchOperation> boList) {
        BatchOperationResult result = new BatchOperationResult();
        int fail = 0;
        for (BatchOperation bo : boList) {
            try {
                ZoneServiceForm zoneServiceForm = this.query(bo.getTargetId());
                if (null == zoneServiceForm) {
                    bo.setErrorCode(570632L);
                    ++fail;
                    continue;
                }
                ArrayList<BatchOperation> udpBoList = new ArrayList<BatchOperation>();
                if (null != bo.getDetailParam()) {
                    for (BatchOperation boTemp : boList) {
                        if (!StringUtils.equals((CharSequence)"UDP", (CharSequence)boTemp.getDetailParam()[2])) continue;
                        udpBoList.add(boTemp);
                    }
                    if (this.isRelUpdService(bo, udpBoList)) {
                        bo.setErrorCode(570633L);
                        ++fail;
                        continue;
                    }
                }
                this.delete(bo.getTargetId());
            }
            catch (RuntimeException e) {
                bo.setErrorCode(570632L);
                ++fail;
            }
        }
        result.setResult(boList);
        result.setFailCount(fail);
        result.setTotalCount(boList.size());
        result.setSucceedCount(boList.size() - fail);
        return result;
    }

    private boolean excludeDeletedUdpService(List<UdpDefendPolicyForm> udpDefendPolicyFormList, List<BatchOperation> udpBoList) {
        if (udpDefendPolicyFormList == null || udpDefendPolicyFormList.isEmpty()) {
            return false;
        }
        Iterator<UdpDefendPolicyForm> i = udpDefendPolicyFormList.iterator();
        block0: while (i.hasNext()) {
            UdpDefendPolicyForm udpDefendPolicyForm = i.next();
            for (BatchOperation boTemp : udpBoList) {
                Long delServiceId;
                Long updServiceId;
                if (udpDefendPolicyForm.getServiceId() == null || !DDosUtil.isPraseLong(boTemp.getDetailParam()[7]) || 0 != (updServiceId = udpDefendPolicyForm.getServiceId()).compareTo(delServiceId = Long.valueOf(boTemp.getDetailParam()[7]))) continue;
                i.remove();
                continue block0;
            }
        }
        return !udpDefendPolicyFormList.isEmpty();
    }

    public ConfigDataTools getConfigDataTools() {
        return this.configDataTools;
    }

    public IDnsDefendPolicyService getDnsDefendPolicyService() {
        return this.dnsDefendPolicyService;
    }

    private IFoundDefaultIdService getFoundDefaultIdService() {
        return this.foundDefaultIdService;
    }

    public void setFoundDefaultIdService(IFoundDefaultIdService foundDefaultIdService) {
        this.foundDefaultIdService = foundDefaultIdService;
    }

    public IHttpDefendService getHttpDefendService() {
        return this.httpDefendService;
    }

    public IHttpsDefendPolicyService getHttpsDefendPolicyService() {
        return this.httpsDefendPolicyService;
    }

    public IIcmpDefendPolicyService getIcmpDefendPolicyService() {
        return this.icmpDefendPolicyService;
    }

    public IOtherDefendPolicyService getOtherDefendService() {
        return this.otherDefendService;
    }

    public ISipDefendPolicyService getSipDefendService() {
        return this.sipDefendService;
    }

    public ISysOptLog getSysOptLog() {
        return this.sysOptLog;
    }

    public ITcpDefendService getTcpDefendService() {
        return this.tcpDefendService;
    }

    public ITopnStudyDefendService getTopnStudyDefendService() {
        return this.topnStudyDefendService;
    }

    public IUdpDefendPolicyService getUdpDefendPolicyService() {
        return this.udpDefendPolicyService;
    }

    public IZoneService getUserService() {
        return this.userService;
    }

    @Override
    public ZoneServiceForm getZoneAndDeviceDefaultService(Long zoneId, Long deviceId) {
        List<ZoneServiceInfo> zoneServiceInfoList = this.zoneServiceDao.getZoneAndDeviceDefaultService(zoneId, deviceId);
        if (zoneServiceInfoList != null && !zoneServiceInfoList.isEmpty()) {
            ZoneServiceForm zoneServiceForm = new ZoneServiceForm();
            VsmUtil.getInstance().copyProperties(zoneServiceInfoList.get(0), zoneServiceForm);
            return zoneServiceForm;
        }
        return null;
    }

    public ZoneDeviceDeployStatusDao getZoneDeviceDeployStatusDao() {
        return this.zoneDeviceDeployStatusDao;
    }

    public IZoneDeviceService getZoneDeviceService() {
        return this.zoneDeviceService;
    }

    public ZoneFeatureStatusDao getZoneFeatureStatusDao() {
        return this.zoneFeatureStatusDao;
    }

    private List<ZoneModifyDetailForm> getZoneModifyDetail(Long zoneId) {
        ZoneConfigData zoneConfigData = this.getConfigDataTools().initZoneConfigData(zoneId);
        ZoneToDeployData zoneModifiedData = new ZoneToDeployData();
        List<ZoneModifyDetailForm> zoneModifyDetailForms = zoneModifiedData.initModifiedData(zoneConfigData, zoneId);
        return zoneModifyDetailForms;
    }

    public ZonePolicyApplyDao getZonePolicyApplyDao() {
        return this.zonePolicyApplyDao;
    }

    public ZoneServiceDao getZoneServiceDao() {
        return this.zoneServiceDao;
    }

    @Override
    public String getZoneServiceName(String serviceName, long zoneId) {
        if (serviceName == null) {
            serviceName = "";
        }
        try {
            List<ZoneServiceInfo> zoneServiceInfos = this.zoneServiceDao.getZoneServiceByServiceName(serviceName, zoneId);
            if (zoneServiceInfos.isEmpty()) {
                return serviceName;
            }
            int i = 0;
            String result = serviceName;
            while (true) {
                if (i > 0) {
                    result = new StringBuffer(serviceName).append("_").append(i).toString();
                }
                boolean isMatch = false;
                for (ZoneServiceInfo info : zoneServiceInfos) {
                    if (!info.getServiceName().equalsIgnoreCase(result)) continue;
                    isMatch = true;
                    break;
                }
                if (!isMatch) break;
                ++i;
            }
            return result;
        }
        catch (RuntimeException e) {
            return "";
        }
    }

    public ZoneServiceStatusDao getZoneServiceStatusDao() {
        return this.zoneServiceStatusDao;
    }

    private Boolean hasDnsPolicy(List<String> policys, ZoneServiceForm form) {
        if (policys.contains("DNS") && null != form.getDnsDefendPolicyForm()) {
            return true;
        }
        return false;
    }

    private Boolean hasHttpPolicy(List<String> policys, ZoneServiceForm form) {
        if (policys.contains("HTTP") && null != form.getHttpDefendPolicyForm()) {
            return true;
        }
        return false;
    }

    private Boolean hasHttpsPolicy(List<String> policys, ZoneServiceForm form) {
        if (policys.contains("HTTPS") && null != form.getHttpsDefendPolicyForm()) {
            return true;
        }
        return false;
    }

    private Boolean hasSipPolicy(List<String> policys, ZoneServiceForm form) {
        if (policys.contains("SIP") && null != form.getSipDefendPolicyForm()) {
            return true;
        }
        return false;
    }

    private Boolean isNotHttpServiceR1(ZoneServiceForm form, Boolean isSupportWithServiceViewCustomService) {
        if (!StringUtils.equals((CharSequence)"HTTP", (CharSequence)form.getProtocol()) || isSupportWithServiceViewCustomService.booleanValue()) {
            return true;
        }
        return false;
    }

    private boolean isNull(String str) {
        return str == null || StringUtils.equals((CharSequence)"", (CharSequence)str);
    }

    private boolean isRelUpdService(BatchOperation bo, List<BatchOperation> udpBoList) {
        if (bo.getDetailParam() == null || bo.getDetailParam().length < 8 || !StringUtils.equals((CharSequence)"TCP", (CharSequence)bo.getDetailParam()[2]) && !StringUtils.equals((CharSequence)"HTTP", (CharSequence)bo.getDetailParam()[2]) && !StringUtils.equals((CharSequence)"HTTPS", (CharSequence)bo.getDetailParam()[2])) {
            return false;
        }
        if (!DDosUtil.isPraseLong(bo.getDetailParam()[5]) || !DDosUtil.isPraseLong(bo.getDetailParam()[6])) {
            return false;
        }
        long deviceId = Long.parseLong(bo.getDetailParam()[5]);
        long zoneId = Long.parseLong(bo.getDetailParam()[6]);
        List<ZoneServiceInfo> zoneServiceInfoList = this.zoneServiceDao.getZoneServiceInfoListByZoneIdAndDeviceId(zoneId, deviceId);
        ArrayList<Long> serviceIdList = new ArrayList<Long>();
        for (ZoneServiceInfo zoneServiceInfo : zoneServiceInfoList) {
            serviceIdList.add(zoneServiceInfo.getPkid());
        }
        List<UdpDefendPolicyForm> udpDefendPolicyFormList = this.udpDefendPolicyService.queryBySerIdListAndRelSerName(serviceIdList, bo.getDetailParam()[3]);
        return this.excludeDeletedUdpService(udpDefendPolicyFormList, udpBoList);
    }

    private void notifyZoneDeviceDeployStatusChanged(ZoneServiceForm zoneServiceForm) {
        HashMap<Integer, Long> condition = new HashMap<Integer, Long>();
        condition.put(0, zoneServiceForm.getZoneId());
        condition.put(1, zoneServiceForm.getDeviceId());
        List zoneDeviceDeployStatusInfos = this.zoneDeviceDeployStatusDao.queryByHql(" from ZoneDeviceDeployStatusInfo where zoneId = ? and deviceId = ? and deployType = 1", condition);
        if (null != zoneDeviceDeployStatusInfos && !zoneDeviceDeployStatusInfos.isEmpty()) {
            ZoneDeviceDeployStatusInfo deviceStatusInfo = (ZoneDeviceDeployStatusInfo)zoneDeviceDeployStatusInfos.get(0);
            deviceStatusInfo.setHasChange(true);
            this.zoneDeviceDeployStatusDao.update(deviceStatusInfo);
        }
    }

    public ZoneServiceForm query(Long id) {
        return this.query(id, null);
    }

    @Override
    public ZoneServiceForm query(Long id, List<String> features) {
        ZoneServiceForm form = new ZoneServiceForm();
        ZoneServiceInfo info = this.getZoneServiceDao().get(id);
        if (null == info) {
            return null;
        }
        VsmUtil.getInstance().copyProperties(info, form);
        this.queryPolicyData(form, features);
        return form;
    }

    @Override
    public List<ZoneServiceForm> queryAll() {
        ArrayList<ZoneServiceForm> formList = new ArrayList<ZoneServiceForm>();
        List<ZoneServiceInfo> infoList = this.zoneServiceDao.getAll();
        for (ZoneServiceInfo info : infoList) {
            ZoneServiceForm form = new ZoneServiceForm();
            VsmUtil.getInstance().copyProperties(info, form);
            formList.add(form);
        }
        return formList;
    }

    @Override
    public List<ZoneServiceForm> queryAllZoneService(String zoneId, String deviceId) {
        List<ZoneServiceInfo> zoneServiceInfos = null;
        ArrayList<ZoneServiceForm> zoneServiceForms = new ArrayList<ZoneServiceForm>();
        zoneServiceInfos = this.getZoneServiceDao().getByZoneIdAndDeviceId(zoneId, deviceId);
        for (ZoneServiceInfo info : zoneServiceInfos) {
            ZoneServiceForm form = new ZoneServiceForm();
            VsmUtil.getInstance().copyProperties(info, form);
            zoneServiceForms.add(form);
        }
        return zoneServiceForms;
    }

    @Override
    public List<ZoneServiceForm> queryByDeviceId(Long deviceId) {
        List<ZoneServiceInfo> zoneServiceInfos = null;
        zoneServiceInfos = this.getZoneServiceDao().getByDeviceId(deviceId);
        ArrayList<ZoneServiceForm> zoneServiceForms = new ArrayList<ZoneServiceForm>();
        for (ZoneServiceInfo info : zoneServiceInfos) {
            ZoneServiceForm form = new ZoneServiceForm();
            VsmUtil.getInstance().copyProperties(info, form);
            zoneServiceForms.add(form);
        }
        return zoneServiceForms;
    }

    public Paging queryByPage(Map<String, String> queryMap, int start, int pageSize) {
        Paging page = this.getZoneServiceDao().queryByPage(queryMap, start, pageSize);
        List infoList = page.getData();
        ArrayList<ZoneServiceForm> formList = new ArrayList<ZoneServiceForm>();
        for (ZoneServiceInfo info : infoList) {
            ZoneServiceForm form = new ZoneServiceForm();
            VsmUtil.getInstance().copyProperties(info, form);
            formList.add(form);
        }
        page.setData(formList);
        return page;
    }

    @Override
    public List<ZoneServiceForm> queryByProtocolAndPort(Long zoneId, Long deviceId, String protocol, String port) {
        if (this.isNull(protocol) || this.isNull(port)) {
            return null;
        }
        List<ZoneServiceInfo> zoneServiceInfos = null;
        ArrayList<ZoneServiceForm> zoneServiceForms = new ArrayList<ZoneServiceForm>();
        zoneServiceInfos = this.getZoneServiceDao().getByIdsAndProtocol(deviceId, zoneId, protocol);
        StringBuffer portList = new StringBuffer();
        String seprator = ";";
        for (ZoneServiceInfo info : zoneServiceInfos) {
            portList.append(seprator).append(info.getPortList() == null || StringUtils.equals((CharSequence)"", (CharSequence)info.getPortList()) ? "0" : info.getPortList()).append(seprator);
            if (!portList.toString().contains(seprator + port + seprator)) continue;
            ZoneServiceForm form = new ZoneServiceForm();
            VsmUtil.getInstance().copyProperties(info, form);
            zoneServiceForms.add(form);
        }
        return zoneServiceForms;
    }

    @Override
    public ZoneServiceForm queryByZonePairAndProtocol(Long zoneId, Long deviceId, String serviceType) {
        if (zoneId == 0L || serviceType == null) {
            return null;
        }
        ZoneServiceForm zoneServiceForm = new ZoneServiceForm();
        List<ZoneServiceInfo> zoneServiceInfoList = this.zoneServiceDao.getByIdsAndType(zoneId, deviceId, serviceType);
        ZoneServiceInfo zoneServiceInfo = null;
        if (!zoneServiceInfoList.isEmpty()) {
            zoneServiceInfo = zoneServiceInfoList.get(0);
        }
        if (zoneServiceInfo == null) {
            return null;
        }
        VsmUtil.getInstance().copyProperties(zoneServiceInfo, zoneServiceForm);
        this.queryPolicyData(zoneServiceForm, null);
        return zoneServiceForm;
    }

    @Override
    public ZoneServiceForm queryByZoneServiceID(Long id) {
        ZoneServiceForm form = new ZoneServiceForm();
        ZoneServiceInfo info = this.getZoneServiceDao().get(id);
        if (info != null) {
            VsmUtil.getInstance().copyProperties(info, form);
            return form;
        }
        return null;
    }

    private void queryPolicyData(ZoneServiceForm form, List<String> features) {
        String serviceProtocol = form.getProtocol();
        DeviceTypeInfo devTypeInfo = CmdUtil.getDevTypeInfo(form.getDeviceId());
        Long serviceId = form.getPkid();
        List<String> policys = ZoneServiceForm.getService2policy().get(serviceProtocol);
        if (devTypeInfo.getDevType().contains("NFA")) {
            policys = new ArrayList<String>();
        }
        if (policys.contains("TCP") && (null == features || features.contains(Constant.Feature.ServiceTcpDefendData.toString()))) {
            TcpDefendPolicyForm tcp = this.getTcpDefendService().queryByServiceId(form.getPkid());
            form.setTcpDefendPolicyForm(tcp);
        }
        if (policys.contains("UDP") && (null == features || features.contains(Constant.Feature.ServiceUdpDefendData.toString()))) {
            UdpDefendPolicyForm udp = this.getUdpDefendPolicyService().queryByServiceId(serviceId);
            form.setUdpDefendPolicyForm(udp);
        }
        if (policys.contains("ICMP") && (null == features || features.contains(Constant.Feature.ServiceIcmpDefendData.toString()))) {
            IcmpDefendPolicyForm icmp = this.getIcmpDefendPolicyService().queryByServiceId(serviceId);
            form.setIcmpDefendPolicyForm(icmp);
        }
        if (policys.contains("HTTP") && (null == features || features.contains(Constant.Feature.ServiceHttpDefendData.toString()))) {
            HttpDefendPolicyForm http = this.getHttpDefendService().queryByServiceId(serviceId);
            form.setHttpDefendPolicyForm(http);
        }
        if (policys.contains("HTTPS") && (null == features || features.contains(Constant.Feature.ServiceHttpsDefendData.toString()))) {
            HttpsDefendPolicyForm https = this.getHttpsDefendPolicyService().queryByServiceId(serviceId);
            form.setHttpsDefendPolicyForm(https);
        }
        if (policys.contains("DNS") && (null == features || features.contains(Constant.Feature.ServiceDnsDefendData.toString()))) {
            DnsDefendPolicyForm dns = this.getDnsDefendPolicyService().queryByServiceId(serviceId);
            form.setDnsDefendPolicyForm(dns);
        }
        if (policys.contains("SIP") && (null == features || features.contains(Constant.Feature.ServiceSipDefendData.toString()))) {
            SipDefendPolicyForm sip = this.getSipDefendService().queryByServiceId(serviceId);
            form.setSipDefendPolicyForm(sip);
        }
        if (policys.contains("Other") && (null == features || features.contains(Constant.Feature.ServiceOtherDefendData.toString()))) {
            OtherDefendPolicyForm other = this.getOtherDefendService().queryByServiceId(serviceId);
            form.setOtherDefendPolicyForm(other);
        }
        if (policys.contains("TOPNSTUDY") && (null == features || features.contains(Constant.Feature.TopnStudyDefendData.toString()))) {
            TopNStudyForm topn = this.getTopnStudyDefendService().queryByServiceId(serviceId);
            form.setTopNStudyForm(topn);
        }
        if (form.getServiceName().contains("NFA")) {
            NfaPolicyEditForm nfaEditForm = this.nfaPolicyEditService.queryByServiceId(serviceId);
            form.setNfaPolicyEditForm(nfaEditForm);
        }
    }

    @Override
    public List<ZoneServiceForm> queryServiceName(Long deviceId, Long zoneID) {
        List<ZoneServiceInfo> zoneServiceInfos = null;
        ArrayList<ZoneServiceForm> zoneServiceForms = new ArrayList<ZoneServiceForm>();
        zoneServiceInfos = this.getZoneServiceDao().getByIdsAndprotocol(deviceId, zoneID);
        for (ZoneServiceInfo info : zoneServiceInfos) {
            ZoneServiceForm form = new ZoneServiceForm();
            VsmUtil.getInstance().copyProperties(info, form);
            zoneServiceForms.add(form);
        }
        return zoneServiceForms;
    }

    @Override
    public int queryZoneDynFingerNum(Long zoneId, Long deviceId) {
        return this.zoneServiceDao.queryDynFingerNum(zoneId, deviceId);
    }

    private void sameServiceCheck(String[] portArrayInDB, String[] portArray) {
        ArrayList<String> portList = new ArrayList<String>(Arrays.asList(portArray));
        ArrayList<String> portListInDB = new ArrayList<String>(Arrays.asList(portArrayInDB));
        if (this.isCrossOnPort(portListInDB, portList)) {
            throw new LegoCheckedException(631002L);
        }
    }

    private boolean isCrossOnPort(List<String> portListInDB, List<String> portList) {
        for (String singlePort : portList) {
            String[] portRange = singlePort.split("~");
            int portStart = Integer.parseInt(portRange[0]);
            int portEnd = Integer.parseInt(portRange[1]);
            for (String singlePortInDB : portListInDB) {
                String[] portRangeInDB = singlePortInDB.split("~");
                int portStartInDB = Integer.parseInt(portRangeInDB[0]);
                int portEndInDB = Integer.parseInt(portRangeInDB[1]);
                if ((portStart < portStartInDB || portStart > portEndInDB) && (portEnd < portStartInDB || portEnd > portEndInDB)) continue;
                return true;
            }
        }
        return false;
    }

    public void save(ZoneServiceForm form) {
        if (null != form) {
            ZoneServiceInfo info = new ZoneServiceInfo();
            VsmUtil.getInstance().copyProperties(form, info);
            this.getZoneServiceDao().saveOrUpdate(info);
            this.saveServicePolicy(form);
            Long currentCrc = CrcUtil.getCrcValue(form.getCalcCrcString());
            form.setCurrentCrc(currentCrc);
            if (0 != currentCrc.compareTo(form.getDeployedCrc())) {
                ZonePolicyApplyInfo zonePolicyApplyInfo = this.zonePolicyApplyDao.getByZoneId(form.getZoneId());
                if (!StringUtils.equals((CharSequence)"UNDEPLOY", (CharSequence)zonePolicyApplyInfo.getDeployState())) {
                    zonePolicyApplyInfo.setDeployState("INCREAMENT_UNDEPLOY");
                }
                this.zonePolicyApplyDao.saveOrUpdate(zonePolicyApplyInfo);
            }
        }
    }

    private void saveServicePolicy(ZoneServiceForm form) {
        String serviceProtocol = form.getProtocol();
        int direction = form.getDirection();
        List<String> policys = ZoneServiceForm.getService2policy().get(serviceProtocol);
        AticDevice device = this.aticDeviceService.getDeviceByMoid(form.getDeviceId().longValue());
        if (device == null) {
            this.logger.error((Object)("securityNE has been deleted!! " + form.getDeviceId()));
            return;
        }
        DdosDevCapabilityServiceImpl devCapabilityService = DdosDevCapabilityServiceImpl.getInstance();
        DeviceTypeInfo devTypeInfo = CmdUtil.getDevTypeInfo(form.getDeviceId());
        Set supportAttrs = devCapabilityService.getAllSupportedAttr(devTypeInfo);
        Boolean isSupportWithServiceViewCustomService = supportAttrs.contains("withServiceViewCustomService");
        if (device.getDeviceType() == 5 || device.getDeviceType() == 7) {
            this.nfaPolicyEditService.save(form.getNfaPolicyEditForm());
            return;
        }
        if (policys.contains("TCP") && this.isNotHttpServiceR1(form, isSupportWithServiceViewCustomService).booleanValue()) {
            this.tcpDefendService.save(form.getTcpDefendPolicyForm());
        }
        if (policys.contains("UDP")) {
            this.udpDefendPolicyService.save(form.getUdpDefendPolicyForm());
        }
        if (policys.contains("ICMP")) {
            this.icmpDefendPolicyService.save(form.getIcmpDefendPolicyForm());
        }
        if (this.hasHttpPolicy(policys, form).booleanValue() && direction == 1) {
            this.httpDefendService.save(form.getHttpDefendPolicyForm());
        }
        if (this.hasHttpsPolicy(policys, form).booleanValue() && direction == 1) {
            this.httpsDefendPolicyService.save(form.getHttpsDefendPolicyForm());
        }
        if (this.hasDnsPolicy(policys, form).booleanValue() && direction == 1) {
            this.dnsDefendPolicyService.save(form.getDnsDefendPolicyForm());
        }
        if (this.hasSipPolicy(policys, form).booleanValue() && direction == 1) {
            this.sipDefendService.save(form.getSipDefendPolicyForm());
        }
        if (policys.contains("Other") && direction == 1) {
            this.otherDefendService.save(form.getOtherDefendPolicyForm());
        }
        if (policys.contains("TOPNSTUDY") && direction == 1) {
            this.topnStudyDefendService.save(form.getTopNStudyForm());
        }
    }

    public void setConfigDataTools(ConfigDataTools configDataTools) {
        this.configDataTools = configDataTools;
    }

    public void setDnsDefendPolicyService(IDnsDefendPolicyService dnsDefendPolicyService) {
        this.dnsDefendPolicyService = dnsDefendPolicyService;
    }

    public void setHttpDefendService(IHttpDefendService httpDefendService) {
        this.httpDefendService = httpDefendService;
    }

    public void setHttpsDefendPolicyService(IHttpsDefendPolicyService httpsDefendPolicyService) {
        this.httpsDefendPolicyService = httpsDefendPolicyService;
    }

    public void setIcmpDefendPolicyService(IIcmpDefendPolicyService icmpDefendPolicyService) {
        this.icmpDefendPolicyService = icmpDefendPolicyService;
    }

    public void setOtherDefendService(IOtherDefendPolicyService otherDefendService) {
        this.otherDefendService = otherDefendService;
    }

    private void setServiceType(ZoneServiceForm form) {
        if (null != form && null == form.getServiceType()) {
            if (StringUtils.equals((CharSequence)"DEFAULT", (CharSequence)form.getProtocol())) {
                form.setServiceType(0);
            } else {
                form.setServiceType(1);
            }
        }
    }

    public void setSipDefendService(ISipDefendPolicyService sipDefendService) {
        this.sipDefendService = sipDefendService;
    }

    public void setSysOptLog(ISysOptLog sysOptLog) {
        this.sysOptLog = sysOptLog;
    }

    public void setTcpDefendService(ITcpDefendService tcpDefendService) {
        this.tcpDefendService = tcpDefendService;
    }

    public void setTopnStudyDefendService(ITopnStudyDefendService topnStudyDefendService) {
        this.topnStudyDefendService = topnStudyDefendService;
    }

    public void setUdpDefendPolicyService(IUdpDefendPolicyService udpDefendPolicyService) {
        this.udpDefendPolicyService = udpDefendPolicyService;
    }

    public void setUserService(IZoneService userService) {
        this.userService = userService;
    }

    public void setZoneDeviceDeployStatusDao(ZoneDeviceDeployStatusDao zoneDeviceDeployStatusDao) {
        this.zoneDeviceDeployStatusDao = zoneDeviceDeployStatusDao;
    }

    public void setZoneDeviceService(IZoneDeviceService zoneDeviceService) {
        this.zoneDeviceService = zoneDeviceService;
    }

    public void setZoneFeatureStatusDao(ZoneFeatureStatusDao zoneFeatureStatusDao) {
        this.zoneFeatureStatusDao = zoneFeatureStatusDao;
    }

    public void setZonePolicyApplyDao(ZonePolicyApplyDao zonePolicyApplyDao) {
        this.zonePolicyApplyDao = zonePolicyApplyDao;
    }

    public void setZoneServiceDao(ZoneServiceDao zoneServiceDao) {
        this.zoneServiceDao = zoneServiceDao;
    }

    public void setZoneServiceStatusDao(ZoneServiceStatusDao zoneServiceStatusDao) {
        this.zoneServiceStatusDao = zoneServiceStatusDao;
    }

    public void update(ZoneServiceForm form) {
        this.save(form);
    }

    @Override
    public void updateServiceBasicInfo(ZoneServiceForm zoneserviceForm) {
        if (null != zoneserviceForm) {
            ZoneServiceInfo info = new ZoneServiceInfo();
            VsmUtil.getInstance().copyProperties(zoneserviceForm, info);
            this.getZoneServiceDao().saveOrUpdate(info);
        }
    }

    @Override
    public String validToDeleteIpAddr(String[] ipArr, Long zoneId) {
        if (null == zoneId || null == ipArr) {
            return "";
        }
        ZonePolicyApplyInfo info = this.zonePolicyApplyDao.getByZoneId(zoneId);
        if (null == info) {
            return "";
        }
        Set<ZoneDeviceInfo> deviceInfos = info.getZoneDeviceInfos();
        for (ZoneDeviceInfo deviceInfo : deviceInfos) {
            DeviceTypeInfo devTypeInfo;
            Long deviceId = deviceInfo.getDeviceId();
            DdosDevCapabilityServiceImpl devCapabilityService = DdosDevCapabilityServiceImpl.getInstance();
            Set supportAttrs = devCapabilityService.getAllSupportedAttr(devTypeInfo = CmdUtil.getDevTypeInfo(deviceId));
            Boolean withServiceViewCustomService = supportAttrs.contains("withServiceViewCustomService");
            if (!withServiceViewCustomService.booleanValue()) continue;
            List<ZoneServiceForm> serviceForms = this.queryAllZoneService(String.valueOf(zoneId), String.valueOf(deviceId));
            for (ZoneServiceForm serviceForm : serviceForms) {
                String isUseIpString;
                if (StringUtils.equals((CharSequence)"DEFAULT", (CharSequence)serviceForm.getProtocol()) || StringUtils.equals((CharSequence)"", (CharSequence)(isUseIpString = this.checkIpInUse(ipArr, serviceForm)))) continue;
                return isUseIpString;
            }
        }
        return "";
    }

    public void setAticDeviceService(IAticDeviceService aticDeviceService) {
        this.aticDeviceService = aticDeviceService;
    }

    public IAticDeviceService getAticDeviceService() {
        return this.aticDeviceService;
    }

    public INfaPolicyEditService getNfaPolicyEditService() {
        return this.nfaPolicyEditService;
    }

    public void setNfaPolicyEditService(INfaPolicyEditService nfaPolicyEditService) {
        this.nfaPolicyEditService = nfaPolicyEditService;
    }

    @Override
    public List<ZoneServiceForm> queryZoneServicesByZoneId(Long zoneId, List<Long> deviceIds) {
        List<ZoneServiceInfo> infoList = this.zoneServiceDao.getByZoneId(zoneId, deviceIds);
        ArrayList<ZoneServiceForm> formList = new ArrayList<ZoneServiceForm>();
        for (ZoneServiceInfo info : infoList) {
            ZoneServiceForm form = new ZoneServiceForm();
            VsmUtil.getInstance().copyProperties(info, form);
            this.queryPolicyData(form, null);
            formList.add(form);
        }
        return formList;
    }

    @Override
    public List<ZoneServiceForm> queryAllZoneService(String zoneId, String deviceId, int direction) {
        List<ZoneServiceInfo> zoneServiceInfos = null;
        ArrayList<ZoneServiceForm> zoneServiceForms = new ArrayList<ZoneServiceForm>();
        zoneServiceInfos = this.getZoneServiceDao().getByZoneIdAndDeviceIdAndDirection(zoneId, deviceId, direction);
        for (ZoneServiceInfo info : zoneServiceInfos) {
            ZoneServiceForm form = new ZoneServiceForm();
            VsmUtil.getInstance().copyProperties(info, form);
            zoneServiceForms.add(form);
        }
        return zoneServiceForms;
    }
}

