/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.service;

import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.atic.sdk.zone.service.IZoneService;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.comm.BatchOperation;
import com.hs.lego.core.sdk.comm.BatchOperationResult;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.secservice.ddos.dao.ZoneServiceDao;
import com.hs.vsm.secservice.ddos.dao.ZoneTemplateDao;
import com.hs.vsm.secservice.ddos.model.ZoneServiceInfo;
import com.hs.vsm.secservice.ddos.model.ZoneTemplateInfo;
import com.hs.vsm.secservice.ddos.model.ZoneTemplateItemsInfo;
import com.hs.vsm.secservice.nfa.util.NfaPolicyUtil;
import com.hs.vsm.secservice.sdk.common.util.VsmUtil;
import com.hs.vsm.secservice.sdk.module.ddos.Constant;
import com.hs.vsm.secservice.sdk.module.ddos.form.DnsDefendPolicyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.HttpDefendPolicyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.HttpsDefendPolicyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.IcmpDefendPolicyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.NfaPolicyEditForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.NfaPolicyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.OtherDefendPolicyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.SipDefendPolicyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.TcpDefendPolicyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.TopNStudyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.UdpDefendPolicyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneDeviceForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneServiceForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneTemplateForm;
import com.hs.vsm.secservice.sdk.module.ddos.service.IDnsDefendPolicyService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IHttpDefendService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IHttpsDefendPolicyService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IIcmpDefendPolicyService;
import com.hs.vsm.secservice.sdk.module.ddos.service.INfaPolicyEditService;
import com.hs.vsm.secservice.sdk.module.ddos.service.INfaPolicyService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IOtherDefendPolicyService;
import com.hs.vsm.secservice.sdk.module.ddos.service.ISipDefendPolicyService;
import com.hs.vsm.secservice.sdk.module.ddos.service.ITcpDefendService;
import com.hs.vsm.secservice.sdk.module.ddos.service.ITopnStudyDefendService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IUdpDefendPolicyService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneDeviceService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneServiceService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneTemplateService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.huawei.atic.secservice.sdk.module.ddos.service.ICommonUtilService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ZoneTemplateServiceImpl
implements IZoneTemplateService {
    List<Long> pkids = new ArrayList<Long>();
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private ZoneTemplateDao dao;
    private ZoneServiceDao serviceDao;
    private IZoneServiceService zoneServiceService;
    private ITcpDefendService tcpDefendService;
    private IHttpDefendService httpDefendService;
    private IHttpsDefendPolicyService httpsDefendPolicyService;
    private IOtherDefendPolicyService otherDefendService;
    private ITopnStudyDefendService topnStudyDefendService;
    private INfaPolicyService nfaPolicyService;
    private INfaPolicyEditService nfaPolicyEditService;
    private ISipDefendPolicyService sipDefendService;
    private IUdpDefendPolicyService udpDefendPolicyService;
    private IIcmpDefendPolicyService icmpDefendPolicyService;
    private IDnsDefendPolicyService dnsDefendPolicyService;
    private IZoneService zoneDefineService;
    private ICommonUtilService commonUtilService;
    private IAticDeviceService aticDeviceService;
    private IZoneDeviceService zoneDeviceService;

    public ITopnStudyDefendService getTopnStudyDefendService() {
        return this.topnStudyDefendService;
    }

    public void setTopnStudyDefendService(ITopnStudyDefendService topnStudyDefendService) {
        this.topnStudyDefendService = topnStudyDefendService;
    }

    private Boolean canPass(Boolean flag, Object obj) {
        if (flag.booleanValue() && obj != null) {
            return true;
        }
        return false;
    }

    public Long create(ZoneTemplateForm form) {
        return null;
    }

    private ZoneServiceForm createDefaultServiceForDevice(Long zoneId, Long deviceId) {
        ZoneServiceForm zoneServiceForm = null;
        zoneServiceForm = this.initZoneServiceForm();
        zoneServiceForm.setZoneId(zoneId);
        zoneServiceForm.setProtocol("DEFAULT");
        zoneServiceForm.setDeviceId(deviceId);
        zoneServiceForm.setServiceType(0);
        zoneServiceForm.setIpList("");
        zoneServiceForm.setPortList("");
        AticDevice device = this.aticDeviceService.getDeviceByMoid(deviceId.longValue());
        if (device.getDeviceType() == 5 || device.getDeviceType() == 7) {
            ZoneInfoForm zoneInfoFormTemp = this.zoneDefineService.getById(zoneServiceForm.getZoneId());
            if (zoneInfoFormTemp != null && Constant.ZONE_TYPE_OF_DEFAULT.equals(zoneInfoFormTemp.getZoneType())) {
                zoneServiceForm.setServiceName("Basic_NFA" + device.getIpAddress().replace(".", "_"));
            } else {
                zoneServiceForm.setServiceName("Basic_NFA");
            }
        } else {
            zoneServiceForm.setServiceName("Basic_" + device.getIpAddress().replace(".", "_"));
        }
        return zoneServiceForm;
    }

    public void createOrUpdate(ZoneTemplateForm form) {
        if (form != null) {
            if (form.getPkid() == null) {
                this.save(form);
            } else {
                this.update(form);
            }
        }
    }

    private void createServicePolicy(ZoneTemplateForm form) {
        Long pkid;
        String serviceProtocol = form.getProtocol();
        List<String> policys = ZoneTemplateForm.getServicetype2policys().get(serviceProtocol);
        if (this.canPass(policys.contains("TCP"), form.getTcpDefendPolicyForm()).booleanValue()) {
            form.getTcpDefendPolicyForm().setServiceId(null);
            pkid = (Long)this.tcpDefendService.create(form.getTcpDefendPolicyForm());
            form.getTcpDefendPolicyForm().setId(pkid);
        }
        if (this.canPass(policys.contains("UDP"), form.getUdpDefendPolicyForm()).booleanValue()) {
            form.getUdpDefendPolicyForm().setServiceId(null);
            pkid = (Long)this.udpDefendPolicyService.create(form.getUdpDefendPolicyForm());
            form.getUdpDefendPolicyForm().setId(pkid);
        }
        if (this.canPass(policys.contains("ICMP"), form.getIcmpDefendPolicyForm()).booleanValue()) {
            form.getIcmpDefendPolicyForm().setServiceId(null);
            pkid = (Long)this.icmpDefendPolicyService.create(form.getIcmpDefendPolicyForm());
            form.getIcmpDefendPolicyForm().setId(pkid);
        }
        if (this.canPass(policys.contains("HTTP"), form.getHttpDefendPolicyForm()).booleanValue()) {
            form.getHttpDefendPolicyForm().setServiceId(null);
            pkid = (Long)this.httpDefendService.create(form.getHttpDefendPolicyForm());
            form.getHttpDefendPolicyForm().setId(pkid);
        }
        if (this.canPass(policys.contains("HTTPS"), form.getHttpsDefendPolicyForm()).booleanValue()) {
            form.getHttpsDefendPolicyForm().setServiceId(null);
            pkid = (Long)this.httpsDefendPolicyService.create(form.getHttpsDefendPolicyForm());
            form.getHttpsDefendPolicyForm().setId(pkid);
        }
        if (this.canPass(policys.contains("DNS"), form.getDnsDefendPolicyForm()).booleanValue()) {
            form.getDnsDefendPolicyForm().setServiceId(null);
            pkid = (Long)this.dnsDefendPolicyService.create(form.getDnsDefendPolicyForm());
            form.getDnsDefendPolicyForm().setId(pkid);
        }
        if (this.canPass(policys.contains("SIP"), form.getSipDefendPolicyForm()).booleanValue()) {
            form.getSipDefendPolicyForm().setServiceId(null);
            pkid = (Long)this.sipDefendService.create(form.getSipDefendPolicyForm());
            form.getSipDefendPolicyForm().setId(pkid);
        }
        if (this.canPass(policys.contains("Other"), form.getOtherDefendPolicyForm()).booleanValue()) {
            form.getOtherDefendPolicyForm().setServiceId(null);
            pkid = (Long)this.otherDefendService.create(form.getOtherDefendPolicyForm());
            form.getOtherDefendPolicyForm().setId(pkid);
        }
        if (this.canPass(policys.contains("TOPNSTUDY"), form.getTopNStudyForm()).booleanValue()) {
            form.getTopNStudyForm().setServiceId(null);
            pkid = (Long)this.topnStudyDefendService.create(form.getTopNStudyForm());
            form.getTopNStudyForm().setId(pkid);
        }
        if ("NFA".equals(form.getDeviceType())) {
            NfaPolicyEditForm nfaPolicyEditForm = form.getNfaPolicyEditForm();
            nfaPolicyEditForm.setDirection(form.getDirection());
            List<NfaPolicyForm> nfaPolicyForms = NfaPolicyUtil.nfaPolicyEditFormConvNfaPolicyFrom(nfaPolicyEditForm);
            if (!nfaPolicyForms.isEmpty()) {
                this.pkids.clear();
                for (NfaPolicyForm nfaPolicyForm : nfaPolicyForms) {
                    nfaPolicyForm.setServiceId(null);
                    Long pkid2 = (Long)this.nfaPolicyService.create(nfaPolicyForm);
                    this.pkids.add(pkid2);
                }
            }
        }
    }

    public void delete(Long id) {
        ZoneTemplateInfo info = this.dao.query(id);
        if (info != null) {
            this.dao.delete(info);
            this.deleteServicePolicy(info);
        }
    }

    public void delete(ZoneTemplateForm form) {
        this.delete(form.getPkid());
    }

    public BatchOperationResult deleteInBatch(List<BatchOperation> boList) {
        BatchOperationResult result = new BatchOperationResult();
        int fail = 0;
        for (BatchOperation bo : boList) {
            try {
                ZoneTemplateForm zoneTemplateForm = this.query(bo.getTargetId());
                if (null == zoneTemplateForm) {
                    bo.setErrorCode(570535L);
                    ++fail;
                    continue;
                }
                this.delete(bo.getTargetId());
                this.nfaPolicyEditService.deleteByTemplateId(bo.getTargetId());
            }
            catch (RuntimeException e) {
                bo.setErrorCode(570535L);
                ++fail;
            }
        }
        result.setTotalCount(boList.size());
        result.setSucceedCount(boList.size() - fail);
        result.setFailCount(fail);
        result.setResult(boList);
        return result;
    }

    private void deleteServicePolicy(ZoneTemplateInfo info) {
        String serviceProtocol = info.getProtocol();
        List<String> policys = ZoneTemplateForm.getServicetype2policys().get(serviceProtocol);
        Long pkid = null;
        pkid = this.getServicePolicyId(info, "TCP");
        if (this.canPass(policys.contains("TCP"), pkid).booleanValue()) {
            this.tcpDefendService.delete(pkid);
        }
        pkid = this.getServicePolicyId(info, "UDP");
        if (this.canPass(policys.contains("UDP"), pkid).booleanValue()) {
            this.udpDefendPolicyService.delete(pkid);
        }
        pkid = this.getServicePolicyId(info, "ICMP");
        if (this.canPass(policys.contains("ICMP"), pkid).booleanValue()) {
            this.icmpDefendPolicyService.delete(pkid);
        }
        pkid = this.getServicePolicyId(info, "HTTP");
        if (this.canPass(policys.contains("HTTP"), pkid).booleanValue()) {
            this.httpDefendService.delete(pkid);
        }
        pkid = this.getServicePolicyId(info, "HTTPS");
        if (this.canPass(policys.contains("HTTPS"), pkid).booleanValue()) {
            this.httpsDefendPolicyService.delete(pkid);
        }
        pkid = this.getServicePolicyId(info, "DNS");
        if (this.canPass(policys.contains("DNS"), pkid).booleanValue()) {
            this.dnsDefendPolicyService.delete(pkid);
        }
        pkid = this.getServicePolicyId(info, "SIP");
        if (this.canPass(policys.contains("SIP"), pkid).booleanValue()) {
            this.sipDefendService.delete(pkid);
        }
        pkid = this.getServicePolicyId(info, "Other");
        if (this.canPass(policys.contains("Other"), pkid).booleanValue()) {
            this.otherDefendService.delete(pkid);
        }
        pkid = this.getServicePolicyId(info, "TOPNSTUDY");
        if (this.canPass(policys.contains("TOPNSTUDY"), pkid).booleanValue()) {
            this.topnStudyDefendService.delete(pkid);
        }
    }

    private void fillDefaultServiceForDevice(ZoneTemplateForm zoneTemplateForm, Map<Long, ZoneServiceForm> deviceDefaultServiceMap) {
        for (Map.Entry<Long, ZoneServiceForm> entry : deviceDefaultServiceMap.entrySet()) {
            Long servicePkId = entry.getValue().getPkid();
            Map<String, String> oldServiceIdMap = null;
            try {
                oldServiceIdMap = this.getOldServiceId(entry.getValue());
            }
            catch (Exception e) {
                this.logger.error((Object)("oldServiceIdMap error : " + e));
            }
            VsmUtil.getInstance().copyProperties(zoneTemplateForm, entry.getValue());
            entry.getValue().setPkid(servicePkId);
            if (null != oldServiceIdMap) {
                this.revertServiceId(entry.getValue(), oldServiceIdMap);
            }
            this.zoneServiceService.create(entry.getValue());
        }
    }

    public ICommonUtilService getCommonUtilService() {
        return this.commonUtilService;
    }

    public ZoneTemplateDao getDao() {
        return this.dao;
    }

    public IDnsDefendPolicyService getDnsDefendPolicyService() {
        return this.dnsDefendPolicyService;
    }

    public IHttpDefendService getHttpDefendService() {
        return this.httpDefendService;
    }

    public IHttpsDefendPolicyService getHttpsDefendPolicyService() {
        return this.httpsDefendPolicyService;
    }

    public IIcmpDefendPolicyService getIcmpDefendPolicyService() {
        return this.icmpDefendPolicyService;
    }

    private Map<String, String> getOldServiceId(ZoneServiceForm objService) {
        HashMap<String, String> result = new HashMap<String, String>();
        String pkidServiceId = null;
        if (null != objService.getTcpDefendPolicyForm()) {
            pkidServiceId = objService.getTcpDefendPolicyForm().getId() + "-" + objService.getTcpDefendPolicyForm().getServiceId();
            result.put("TCP", pkidServiceId);
        }
        if (null != objService.getUdpDefendPolicyForm()) {
            pkidServiceId = objService.getUdpDefendPolicyForm().getId() + "-" + objService.getUdpDefendPolicyForm().getServiceId();
            result.put("UDP", pkidServiceId);
        }
        if (null != objService.getHttpDefendPolicyForm()) {
            pkidServiceId = objService.getHttpDefendPolicyForm().getId() + "-" + objService.getHttpDefendPolicyForm().getServiceId();
            result.put("HTTP", pkidServiceId);
        }
        if (null != objService.getIcmpDefendPolicyForm()) {
            pkidServiceId = objService.getIcmpDefendPolicyForm().getId() + "-" + objService.getIcmpDefendPolicyForm().getServiceId();
            result.put("ICMP", pkidServiceId);
        }
        if (null != objService.getDnsDefendPolicyForm()) {
            pkidServiceId = objService.getDnsDefendPolicyForm().getId() + "-" + objService.getDnsDefendPolicyForm().getServiceId();
            result.put("DNS", pkidServiceId);
        }
        if (null != objService.getHttpsDefendPolicyForm()) {
            pkidServiceId = objService.getHttpsDefendPolicyForm().getId() + "-" + objService.getHttpsDefendPolicyForm().getServiceId();
            result.put("HTTPS", pkidServiceId);
        }
        if (null != objService.getOtherDefendPolicyForm()) {
            pkidServiceId = objService.getOtherDefendPolicyForm().getId() + "-" + objService.getOtherDefendPolicyForm().getServiceId();
            result.put("Other", pkidServiceId);
        }
        if (null != objService.getSipDefendPolicyForm()) {
            pkidServiceId = objService.getSipDefendPolicyForm().getId() + "-" + objService.getSipDefendPolicyForm().getServiceId();
            result.put("SIP", pkidServiceId);
        }
        if (null != objService.getTopNStudyForm()) {
            pkidServiceId = objService.getTopNStudyForm().getId() + "-" + objService.getTopNStudyForm().getServiceId();
            result.put("TOPNSTUDY", pkidServiceId);
        }
        if (objService.getServiceName().contains("NFA")) {
            ZoneTemplateServiceImpl.nfaPolicyRelation(result, objService);
        }
        return result;
    }

    private static void nfaPolicyRelation(Map<String, String> result, ZoneServiceForm objService) {
        NfaPolicyEditForm nfaPolicyEditForm = objService.getNfaPolicyEditForm();
        List<NfaPolicyForm> nfaPolicyForms = NfaPolicyUtil.nfaPolicyEditFormConvNfaPolicyFrom(nfaPolicyEditForm);
        for (NfaPolicyForm nfaForm : nfaPolicyForms) {
            if ("Host_Traffic_Overflow".equals(nfaForm.getName())) {
                nfaPolicyEditForm.setHostTotal(nfaForm);
                String pkidServiceId1 = nfaForm.getPkid() + "-" + nfaForm.getServiceId() + "-" + nfaForm.getZoneId();
                result.put("Host_Traffic_Overflow", pkidServiceId1);
                continue;
            }
            if ("Tcp_Syn_Flood".equals(nfaForm.getName())) {
                nfaPolicyEditForm.setTcpSynFlood(nfaForm);
                String pkidServiceId2 = nfaForm.getPkid() + "-" + nfaForm.getServiceId() + "-" + nfaForm.getZoneId();
                result.put("Tcp_Syn_Flood", pkidServiceId2);
                continue;
            }
            if ("Tcp_Fragment_Flood".equals(nfaForm.getName())) {
                nfaPolicyEditForm.setTcpFragmentFlood(nfaForm);
                String pkidServiceId3 = nfaForm.getPkid() + "-" + nfaForm.getServiceId() + "-" + nfaForm.getZoneId();
                result.put("Tcp_Fragment_Flood", pkidServiceId3);
                continue;
            }
            if ("Tcp_Ack_Flood".equals(nfaForm.getName())) {
                nfaPolicyEditForm.setTcpAckFlood(nfaForm);
                String pkidServiceId4 = nfaForm.getPkid() + "-" + nfaForm.getServiceId() + "-" + nfaForm.getZoneId();
                result.put("Tcp_Ack_Flood", pkidServiceId4);
                continue;
            }
            if ("Tcp_Malformed_Flood".equals(nfaForm.getName())) {
                nfaPolicyEditForm.setTcpAbnormalFlood(nfaForm);
                String pkidServiceId5 = nfaForm.getPkid() + "-" + nfaForm.getServiceId() + "-" + nfaForm.getZoneId();
                result.put("Tcp_Malformed_Flood", pkidServiceId5);
                continue;
            }
            if ("Tcp_RstFin_Flood".equals(nfaForm.getName())) {
                nfaPolicyEditForm.setTcpRstFinFlood(nfaForm);
                String pkidServiceId6 = nfaForm.getPkid() + "-" + nfaForm.getServiceId() + "-" + nfaForm.getZoneId();
                result.put("Tcp_RstFin_Flood", pkidServiceId6);
                continue;
            }
            if ("Udp_Flood".equals(nfaForm.getName())) {
                nfaPolicyEditForm.setUdpFlood(nfaForm);
                String pkidServiceId7 = nfaForm.getPkid() + "-" + nfaForm.getServiceId() + "-" + nfaForm.getZoneId();
                result.put("Udp_Flood", pkidServiceId7);
                continue;
            }
            if ("Udp_Fragment_Flood".equals(nfaForm.getName())) {
                nfaPolicyEditForm.setUdpFragmentFlood(nfaForm);
                String pkidServiceId8 = nfaForm.getPkid() + "-" + nfaForm.getServiceId() + "-" + nfaForm.getZoneId();
                result.put("Udp_Fragment_Flood", pkidServiceId8);
                continue;
            }
            if ("Dns_Query_Flood".equals(nfaForm.getName())) {
                nfaPolicyEditForm.setDnsQueryFlood(nfaForm);
                String pkidServiceId9 = nfaForm.getPkid() + "-" + nfaForm.getServiceId() + "-" + nfaForm.getZoneId();
                result.put("Dns_Query_Flood", pkidServiceId9);
                continue;
            }
            if ("Dns_Reply_Flood".equals(nfaForm.getName())) {
                nfaPolicyEditForm.setDnsReplyFlood(nfaForm);
                String pkidServiceId10 = nfaForm.getPkid() + "-" + nfaForm.getServiceId() + "-" + nfaForm.getZoneId();
                result.put("Dns_Reply_Flood", pkidServiceId10);
                continue;
            }
            if ("Http_Flood".equals(nfaForm.getName())) {
                nfaPolicyEditForm.setHttpFlood(nfaForm);
                String pkidServiceId11 = nfaForm.getPkid() + "-" + nfaForm.getServiceId() + "-" + nfaForm.getZoneId();
                result.put("Http_Flood", pkidServiceId11);
                continue;
            }
            if ("Https_Flood".equals(nfaForm.getName())) {
                nfaPolicyEditForm.setHttpsFlood(nfaForm);
                String pkidServiceId12 = nfaForm.getPkid() + "-" + nfaForm.getServiceId() + "-" + nfaForm.getZoneId();
                result.put("Https_Flood", pkidServiceId12);
                continue;
            }
            if ("Sip_Flood".equals(nfaForm.getName())) {
                nfaPolicyEditForm.setSipFlood(nfaForm);
                String pkidServiceId13 = nfaForm.getPkid() + "-" + nfaForm.getServiceId() + "-" + nfaForm.getZoneId();
                result.put("Sip_Flood", pkidServiceId13);
                continue;
            }
            if ("Icmp_Flood".equals(nfaForm.getName())) {
                nfaPolicyEditForm.setIcmpFlood(nfaForm);
                String pkidServiceId14 = nfaForm.getPkid() + "-" + nfaForm.getServiceId() + "-" + nfaForm.getZoneId();
                result.put("Icmp_Flood", pkidServiceId14);
                continue;
            }
            if ("Other_Flood".equals(nfaForm.getName())) {
                nfaPolicyEditForm.setOtherFlood(nfaForm);
                String pkidServiceId15 = nfaForm.getPkid() + "-" + nfaForm.getServiceId() + "-" + nfaForm.getZoneId();
                result.put("Other_Flood", pkidServiceId15);
                continue;
            }
            if (!"Dark_Ip".equals(nfaForm.getName())) continue;
            nfaPolicyEditForm.setDarkIp(nfaForm);
            String pkidServiceId16 = nfaForm.getPkid() + "-" + nfaForm.getServiceId() + "-" + nfaForm.getZoneId();
            result.put("Dark_Ip", pkidServiceId16);
        }
    }

    public IOtherDefendPolicyService getOtherDefendService() {
        return this.otherDefendService;
    }

    public ZoneServiceDao getServiceDao() {
        return this.serviceDao;
    }

    private Long getServicePolicyId(ZoneTemplateInfo info, String protocol) {
        for (ZoneTemplateItemsInfo itemInfo : info.getZoneTemplateItemsInfos()) {
            if (!protocol.equals(itemInfo.getType())) continue;
            return itemInfo.getChildrenId();
        }
        return null;
    }

    public ISipDefendPolicyService getSipDefendService() {
        return this.sipDefendService;
    }

    public ITcpDefendService getTcpDefendService() {
        return this.tcpDefendService;
    }

    public IUdpDefendPolicyService getUdpDefendPolicyService() {
        return this.udpDefendPolicyService;
    }

    public IZoneService getZoneDefineService() {
        return this.zoneDefineService;
    }

    public IZoneDeviceService getZoneDeviceService() {
        return this.zoneDeviceService;
    }

    public IZoneServiceService getZoneServiceService() {
        return this.zoneServiceService;
    }

    @Override
    public List<ZoneServiceForm> importDefServiceByTemplate(Long zoneId, Set<Long> deviceIds, Long templateId) {
        ArrayList<ZoneServiceForm> zoneServcieForms = new ArrayList<ZoneServiceForm>();
        Map<Long, ZoneServiceForm> tempMap = this.importDefServiceTemplate(zoneId, deviceIds, templateId);
        if (null != tempMap) {
            for (Map.Entry<Long, ZoneServiceForm> entry : tempMap.entrySet()) {
                zoneServcieForms.add(entry.getValue());
            }
        }
        return zoneServcieForms;
    }

    @Override
    public void importDefServicesByTemplate(List<Long> zoneIdList, Long templateId) {
        ZoneTemplateInfo zoneTemplateInfo = this.dao.getTemplateByTemplateId(templateId);
        if (null == templateId) {
            this.logger.error((Object)"templateId is null");
        } else if (null != zoneTemplateInfo) {
            String deviceType = zoneTemplateInfo.getDeviceType();
            boolean isDDoSTemp = false;
            if ("NFA".equals(deviceType)) {
                isDDoSTemp = false;
            } else if ("AntiDDoS_".contains(deviceType)) {
                isDDoSTemp = true;
            }
            for (Long zoneId : zoneIdList) {
                HashSet<Long> deviceIds = new HashSet<Long>();
                List zoneDeviceForms = this.zoneDeviceService.getByZoneId(zoneId);
                for (ZoneDeviceForm zoneDeviceForm : zoneDeviceForms) {
                    AticDevice aticDevice = this.aticDeviceService.getDeviceByMoid(zoneDeviceForm.getDeviceId().longValue());
                    if (aticDevice.getDeviceType() == 1 && isDDoSTemp) {
                        deviceIds.add(zoneDeviceForm.getDeviceId());
                    }
                    if (aticDevice.getDeviceType() != 5 && aticDevice.getDeviceType() != 7 || isDDoSTemp) continue;
                    deviceIds.add(zoneDeviceForm.getDeviceId());
                }
                this.importDefServiceByTemplate(zoneId, deviceIds, templateId);
            }
        } else {
            this.logger.error((Object)"zoneTemplateInfo is null");
        }
    }

    private Map<Long, ZoneServiceForm> importDefServiceTemplate(Long zoneId, Set<Long> deviceIds, Long templateId) {
        ZoneTemplateForm zoneTemplateForm = this.query(templateId);
        if (null != zoneTemplateForm) {
            NfaPolicyEditForm nfaPolicyEditForm = this.nfaPolicyEditService.queryNfaPolicyByTemplateId(templateId);
            zoneTemplateForm.setNfaPolicyEditForm(nfaPolicyEditForm);
            HashMap<Long, ZoneServiceForm> deviceDefaultServiceMap = new HashMap<Long, ZoneServiceForm>();
            for (Long deviceId : deviceIds) {
                ZoneServiceForm zoneServiceForm = this.queryDefaultService(zoneId, deviceId, zoneTemplateForm.getDirection());
                deviceDefaultServiceMap.put(deviceId, zoneServiceForm);
            }
            this.fillDefaultServiceForDevice(zoneTemplateForm, deviceDefaultServiceMap);
            return deviceDefaultServiceMap;
        }
        this.logger.error((Object)"zoneTemplateForm is null");
        return null;
    }

    private ZoneServiceForm initZoneServiceForm() {
        TcpDefendPolicyForm tcpDefendPolicyForm = new TcpDefendPolicyForm();
        UdpDefendPolicyForm udpDefendPolicyForm = new UdpDefendPolicyForm();
        HttpDefendPolicyForm httpDefendPolicyForm = new HttpDefendPolicyForm();
        HttpsDefendPolicyForm httpsDefendPolicyForm = new HttpsDefendPolicyForm();
        IcmpDefendPolicyForm icmpDefendPolicyForm = new IcmpDefendPolicyForm();
        DnsDefendPolicyForm dnsDefendPolicyForm = new DnsDefendPolicyForm();
        SipDefendPolicyForm sipDefendPolicyForm = new SipDefendPolicyForm();
        OtherDefendPolicyForm otherDefendPolicyForm = new OtherDefendPolicyForm();
        TopNStudyForm topNStudyForm = new TopNStudyForm();
        ZoneServiceForm zoneServiceForm = new ZoneServiceForm();
        zoneServiceForm.setTcpDefendPolicyForm(tcpDefendPolicyForm);
        zoneServiceForm.setUdpDefendPolicyForm(udpDefendPolicyForm);
        zoneServiceForm.setHttpDefendPolicyForm(httpDefendPolicyForm);
        zoneServiceForm.setHttpsDefendPolicyForm(httpsDefendPolicyForm);
        zoneServiceForm.setIcmpDefendPolicyForm(icmpDefendPolicyForm);
        zoneServiceForm.setDnsDefendPolicyForm(dnsDefendPolicyForm);
        zoneServiceForm.setSipDefendPolicyForm(sipDefendPolicyForm);
        zoneServiceForm.setOtherDefendPolicyForm(otherDefendPolicyForm);
        zoneServiceForm.setTopNStudyForm(topNStudyForm);
        return zoneServiceForm;
    }

    public ZoneTemplateForm query(Long id) {
        ZoneTemplateInfo info = this.dao.query(id);
        ZoneTemplateForm form = null;
        if (info != null) {
            form = new ZoneTemplateForm();
            VsmUtil.getInstance().copyProperties(info, form);
            this.queryPolicyData(form, info);
        }
        return form;
    }

    @Override
    public List<ZoneTemplateForm> queryAllDefaultTemplate() {
        ArrayList<ZoneTemplateForm> zoneTemplateForms = new ArrayList<ZoneTemplateForm>();
        List<ZoneTemplateInfo> infos = this.dao.getDefaultTemplate();
        if (infos.isEmpty()) {
            return zoneTemplateForms;
        }
        for (ZoneTemplateInfo info : infos) {
            ZoneTemplateForm form = new ZoneTemplateForm();
            VsmUtil.getInstance().copyProperties(info, form);
            zoneTemplateForms.add(form);
        }
        return zoneTemplateForms;
    }

    public Paging queryByPage(Map<String, String> queryMap, int start, int pageSize) {
        Paging page = this.dao.queryByPage(queryMap, start, pageSize);
        ArrayList<ZoneTemplateForm> froms = new ArrayList<ZoneTemplateForm>();
        if (page.getCount() > 0) {
            List infos = page.getData();
            for (ZoneTemplateInfo info : infos) {
                ZoneTemplateForm form = new ZoneTemplateForm();
                VsmUtil.getInstance().copyProperties(info, form);
                froms.add(form);
            }
        }
        page.setData(froms);
        return page;
    }

    private ZoneServiceForm queryDefaultService(Long zoneId, Long deviceId, Integer direction) {
        ZoneServiceForm zoneServiceForm = null;
        List<ZoneServiceInfo> serviceInfos = this.serviceDao.getZoneAndDeviceDefaultService(zoneId, deviceId);
        if (null == serviceInfos || serviceInfos.isEmpty()) {
            zoneServiceForm = this.createDefaultServiceForDevice(zoneId, deviceId);
        } else {
            for (ZoneServiceInfo zoneServiceInfo : serviceInfos) {
                if (direction.intValue() != zoneServiceInfo.getDirection().intValue()) continue;
                zoneServiceForm = (ZoneServiceForm)this.zoneServiceService.query(zoneServiceInfo.getPkid());
                NfaPolicyEditForm nfaPolicyEditForm = this.nfaPolicyEditService.queryNfaPolicyByServiceId(zoneServiceInfo.getPkid());
                zoneServiceForm.setNfaPolicyEditForm(nfaPolicyEditForm);
            }
        }
        return zoneServiceForm;
    }

    private void queryPolicyData(ZoneTemplateForm form, ZoneTemplateInfo info) {
        String serviceProtocol = form.getProtocol();
        List<String> policys = ZoneTemplateForm.getServicetype2policys().get(serviceProtocol);
        Long pkid = null;
        pkid = this.getServicePolicyId(info, "TCP");
        if (this.canPass(policys.contains("TCP"), pkid).booleanValue()) {
            TcpDefendPolicyForm tcp = (TcpDefendPolicyForm)this.getTcpDefendService().query(pkid);
            form.setTcpDefendPolicyForm(tcp);
        }
        pkid = this.getServicePolicyId(info, "UDP");
        if (this.canPass(policys.contains("UDP"), pkid).booleanValue()) {
            UdpDefendPolicyForm udp = (UdpDefendPolicyForm)this.getUdpDefendPolicyService().query(pkid);
            form.setUdpDefendPolicyForm(udp);
        }
        pkid = this.getServicePolicyId(info, "ICMP");
        if (this.canPass(policys.contains("ICMP"), pkid).booleanValue()) {
            IcmpDefendPolicyForm icmp = (IcmpDefendPolicyForm)this.getIcmpDefendPolicyService().query(pkid);
            form.setIcmpDefendPolicyForm(icmp);
        }
        pkid = this.getServicePolicyId(info, "HTTP");
        if (this.canPass(policys.contains("HTTP"), pkid).booleanValue()) {
            HttpDefendPolicyForm http = (HttpDefendPolicyForm)this.getHttpDefendService().query(pkid);
            form.setHttpDefendPolicyForm(http);
        }
        pkid = this.getServicePolicyId(info, "HTTPS");
        if (this.canPass(policys.contains("HTTPS"), pkid).booleanValue()) {
            HttpsDefendPolicyForm https = (HttpsDefendPolicyForm)this.getHttpsDefendPolicyService().query(pkid);
            form.setHttpsDefendPolicyForm(https);
        }
        pkid = this.getServicePolicyId(info, "DNS");
        if (this.canPass(policys.contains("DNS"), pkid).booleanValue()) {
            DnsDefendPolicyForm dns = (DnsDefendPolicyForm)this.getDnsDefendPolicyService().query(pkid);
            form.setDnsDefendPolicyForm(dns);
        }
        pkid = this.getServicePolicyId(info, "SIP");
        if (this.canPass(policys.contains("SIP"), pkid).booleanValue()) {
            SipDefendPolicyForm sip = (SipDefendPolicyForm)this.getSipDefendService().query(pkid);
            form.setSipDefendPolicyForm(sip);
        }
        pkid = this.getServicePolicyId(info, "Other");
        if (this.canPass(policys.contains("Other"), pkid).booleanValue()) {
            OtherDefendPolicyForm other = (OtherDefendPolicyForm)this.getOtherDefendService().query(pkid);
            form.setOtherDefendPolicyForm(other);
        }
        pkid = this.getServicePolicyId(info, "TOPNSTUDY");
        if (this.canPass(policys.contains("TOPNSTUDY"), pkid).booleanValue()) {
            TopNStudyForm topnForm = (TopNStudyForm)this.getTopnStudyDefendService().query(pkid);
            form.setTopNStudyForm(topnForm);
        }
    }

    private void revertServiceId(ZoneServiceForm zoneService, Map<String, String> oldServiceIdMap) {
        NfaPolicyEditForm nfaPolicyEditForm;
        if (null != zoneService.getTcpDefendPolicyForm() && null != oldServiceIdMap.get("TCP")) {
            String[] pkidServiceIdTcp = oldServiceIdMap.get("TCP").split("-");
            zoneService.getTcpDefendPolicyForm().setId(Long.valueOf(pkidServiceIdTcp[0]));
            zoneService.getTcpDefendPolicyForm().setServiceId(Long.valueOf(pkidServiceIdTcp[1]));
        }
        if (null != zoneService.getUdpDefendPolicyForm() && null != oldServiceIdMap.get("UDP")) {
            String[] pkidServiceIdUdp = oldServiceIdMap.get("UDP").split("-");
            zoneService.getUdpDefendPolicyForm().setId(Long.valueOf(pkidServiceIdUdp[0]));
            zoneService.getUdpDefendPolicyForm().setServiceId(Long.valueOf(pkidServiceIdUdp[1]));
        }
        if (null != zoneService.getIcmpDefendPolicyForm() && null != oldServiceIdMap.get("ICMP")) {
            String[] pkidServiceIdIcmp = oldServiceIdMap.get("ICMP").split("-");
            zoneService.getIcmpDefendPolicyForm().setId(Long.valueOf(pkidServiceIdIcmp[0]));
            zoneService.getIcmpDefendPolicyForm().setServiceId(Long.valueOf(pkidServiceIdIcmp[1]));
        }
        if (null != zoneService.getOtherDefendPolicyForm() && null != oldServiceIdMap.get("Other")) {
            String[] pkidServiceIdOther = oldServiceIdMap.get("Other").split("-");
            zoneService.getOtherDefendPolicyForm().setId(Long.valueOf(pkidServiceIdOther[0]));
            zoneService.getOtherDefendPolicyForm().setServiceId(Long.valueOf(pkidServiceIdOther[1]));
        }
        if (null != zoneService.getDnsDefendPolicyForm() && null != oldServiceIdMap.get("DNS")) {
            String[] pkidServiceIdDns = oldServiceIdMap.get("DNS").split("-");
            zoneService.getDnsDefendPolicyForm().setId(Long.valueOf(pkidServiceIdDns[0]));
            zoneService.getDnsDefendPolicyForm().setServiceId(Long.valueOf(pkidServiceIdDns[1]));
        }
        if (null != zoneService.getHttpDefendPolicyForm() && null != oldServiceIdMap.get("HTTP")) {
            String[] pkidServiceIdHttp = oldServiceIdMap.get("HTTP").split("-");
            zoneService.getHttpDefendPolicyForm().setId(Long.valueOf(pkidServiceIdHttp[0]));
            zoneService.getHttpDefendPolicyForm().setServiceId(Long.valueOf(pkidServiceIdHttp[1]));
        }
        if (null != zoneService.getHttpsDefendPolicyForm() && null != oldServiceIdMap.get("HTTPS")) {
            String[] pkidServiceIdHttps = oldServiceIdMap.get("HTTPS").split("-");
            zoneService.getHttpsDefendPolicyForm().setId(Long.valueOf(pkidServiceIdHttps[0]));
            zoneService.getHttpsDefendPolicyForm().setServiceId(Long.valueOf(pkidServiceIdHttps[1]));
        }
        if (null != zoneService.getSipDefendPolicyForm() && null != oldServiceIdMap.get("SIP")) {
            String[] pkidServiceIdSip = oldServiceIdMap.get("SIP").split("-");
            zoneService.getSipDefendPolicyForm().setId(Long.valueOf(pkidServiceIdSip[0]));
            zoneService.getSipDefendPolicyForm().setServiceId(Long.valueOf(pkidServiceIdSip[1]));
        }
        if (null != zoneService.getTopNStudyForm() && null != oldServiceIdMap.get("TOPNSTUDY")) {
            String[] pkidServiceIdTopnStudy = oldServiceIdMap.get("TOPNSTUDY").split("-");
            zoneService.getTopNStudyForm().setId(Long.valueOf(pkidServiceIdTopnStudy[0]));
            zoneService.getTopNStudyForm().setServiceId(Long.valueOf(pkidServiceIdTopnStudy[1]));
        }
        if (zoneService.getServiceName().contains("NFA") && (nfaPolicyEditForm = zoneService.getNfaPolicyEditForm()) != null) {
            List<NfaPolicyForm> nfaPolicyForms = NfaPolicyUtil.nfaPolicyEditFormConvNfaPolicyFrom(nfaPolicyEditForm);
            block0: for (Map.Entry<String, String> entry : oldServiceIdMap.entrySet()) {
                String name = entry.getKey();
                String value = entry.getValue();
                for (NfaPolicyForm nfaForm : nfaPolicyForms) {
                    if (!name.equals(nfaForm.getName())) continue;
                    String[] pkidServiceId = value.split("-");
                    nfaForm.setPkid(Long.valueOf(pkidServiceId[0]));
                    nfaForm.setServiceId(Long.valueOf(pkidServiceId[1]));
                    nfaForm.setZoneId(Long.valueOf(pkidServiceId[2]));
                    continue block0;
                }
            }
        }
    }

    public void save(ZoneTemplateForm form) {
        this.createServicePolicy(form);
        ZoneTemplateInfo info = this.tranForm2Info(form);
        this.dao.saveOrUpdate(info);
    }

    private void saveServicePolicy(ZoneTemplateForm form) {
        NfaPolicyEditForm nfaPolicyEditForm;
        List<NfaPolicyForm> nfaPolicyForms;
        String serviceProtocol = form.getProtocol();
        List<String> policys = ZoneTemplateForm.getServicetype2policys().get(serviceProtocol);
        if (this.canPass(policys.contains("TCP"), form.getTcpDefendPolicyForm()).booleanValue()) {
            this.tcpDefendService.save(form.getTcpDefendPolicyForm());
        }
        if (this.canPass(policys.contains("UDP"), form.getUdpDefendPolicyForm()).booleanValue()) {
            this.udpDefendPolicyService.save(form.getUdpDefendPolicyForm());
        }
        if (this.canPass(policys.contains("ICMP"), form.getIcmpDefendPolicyForm()).booleanValue()) {
            this.icmpDefendPolicyService.save(form.getIcmpDefendPolicyForm());
        }
        if (this.canPass(policys.contains("HTTP"), form.getHttpDefendPolicyForm()).booleanValue()) {
            this.httpDefendService.save(form.getHttpDefendPolicyForm());
        }
        if (this.canPass(policys.contains("HTTPS"), form.getHttpsDefendPolicyForm()).booleanValue()) {
            this.httpsDefendPolicyService.save(form.getHttpsDefendPolicyForm());
        }
        if (this.canPass(policys.contains("DNS"), form.getDnsDefendPolicyForm()).booleanValue()) {
            this.dnsDefendPolicyService.save(form.getDnsDefendPolicyForm());
        }
        if (this.canPass(policys.contains("SIP"), form.getSipDefendPolicyForm()).booleanValue()) {
            this.sipDefendService.save(form.getSipDefendPolicyForm());
        }
        if (this.canPass(policys.contains("Other"), form.getOtherDefendPolicyForm()).booleanValue()) {
            this.otherDefendService.save(form.getOtherDefendPolicyForm());
        }
        if (this.canPass(policys.contains("TOPNSTUDY"), form.getTopNStudyForm()).booleanValue()) {
            this.topnStudyDefendService.save(form.getTopNStudyForm());
        }
        if ("NFA".equals(form.getDeviceType()) && !(nfaPolicyForms = NfaPolicyUtil.nfaPolicyEditFormConvNfaPolicyFrom(nfaPolicyEditForm = form.getNfaPolicyEditForm())).isEmpty()) {
            for (NfaPolicyForm nfaPolicyForm : nfaPolicyForms) {
                this.nfaPolicyService.save(nfaPolicyForm);
            }
        }
    }

    public void setCommonUtilService(ICommonUtilService commonUtilService) {
        this.commonUtilService = commonUtilService;
    }

    public void setDao(ZoneTemplateDao dao) {
        this.dao = dao;
    }

    public void setDnsDefendPolicyService(IDnsDefendPolicyService dnsDefendPolicyService) {
        this.dnsDefendPolicyService = dnsDefendPolicyService;
    }

    public void setHttpDefendService(IHttpDefendService httpDefendService) {
        this.httpDefendService = httpDefendService;
    }

    public void setHttpsDefendPolicyService(IHttpsDefendPolicyService httpsDefendPolicyService) {
        this.httpsDefendPolicyService = httpsDefendPolicyService;
    }

    public void setIcmpDefendPolicyService(IIcmpDefendPolicyService icmpDefendPolicyService) {
        this.icmpDefendPolicyService = icmpDefendPolicyService;
    }

    public void setOtherDefendService(IOtherDefendPolicyService otherDefendService) {
        this.otherDefendService = otherDefendService;
    }

    public void setServiceDao(ZoneServiceDao serviceDao) {
        this.serviceDao = serviceDao;
    }

    public void setSipDefendService(ISipDefendPolicyService sipDefendService) {
        this.sipDefendService = sipDefendService;
    }

    public void setTcpDefendService(ITcpDefendService tcpDefendService) {
        this.tcpDefendService = tcpDefendService;
    }

    public void setUdpDefendPolicyService(IUdpDefendPolicyService udpDefendPolicyService) {
        this.udpDefendPolicyService = udpDefendPolicyService;
    }

    public void setZoneDefineService(IZoneService zoneDefineService) {
        this.zoneDefineService = zoneDefineService;
    }

    public void setZoneDeviceService(IZoneDeviceService zoneDeviceService) {
        this.zoneDeviceService = zoneDeviceService;
    }

    public void setZoneServiceService(IZoneServiceService zoneServiceService) {
        this.zoneServiceService = zoneServiceService;
    }

    @Override
    public Boolean templateNameExsit(Long pkid, String templateName) {
        return this.dao.templateNameExsit(pkid, templateName);
    }

    private ZoneTemplateInfo tranForm2Info(ZoneTemplateForm form) {
        ZoneTemplateInfo info = null;
        if (form != null) {
            ZoneTemplateItemsInfo itemInfo;
            try {
                Date date = new Date();
                form.setAddTime(date.getTime() / 1000L);
            }
            catch (Exception e) {
                form.setAddTime(0L);
            }
            info = new ZoneTemplateInfo();
            VsmUtil.getInstance().copyProperties(form, info);
            String serviceProtocol = form.getProtocol();
            List<String> policys = ZoneTemplateForm.getServicetype2policys().get(serviceProtocol);
            if (this.canPass(policys.contains("TCP"), form.getTcpDefendPolicyForm()).booleanValue()) {
                itemInfo = new ZoneTemplateItemsInfo();
                itemInfo.setChildrenId(form.getTcpDefendPolicyForm().getId());
                itemInfo.setType("TCP");
                info.addTozoneTemplateItemsInfos(itemInfo);
            }
            if (this.canPass(policys.contains("UDP"), form.getUdpDefendPolicyForm()).booleanValue()) {
                itemInfo = new ZoneTemplateItemsInfo();
                itemInfo.setChildrenId(form.getUdpDefendPolicyForm().getId());
                itemInfo.setType("UDP");
                info.addTozoneTemplateItemsInfos(itemInfo);
            }
            if (this.canPass(policys.contains("ICMP"), form.getIcmpDefendPolicyForm()).booleanValue()) {
                itemInfo = new ZoneTemplateItemsInfo();
                itemInfo.setChildrenId(form.getIcmpDefendPolicyForm().getId());
                itemInfo.setType("ICMP");
                info.addTozoneTemplateItemsInfos(itemInfo);
            }
            if (this.canPass(policys.contains("HTTP"), form.getHttpDefendPolicyForm()).booleanValue()) {
                itemInfo = new ZoneTemplateItemsInfo();
                itemInfo.setChildrenId(form.getHttpDefendPolicyForm().getId());
                itemInfo.setType("HTTP");
                info.addTozoneTemplateItemsInfos(itemInfo);
            }
            if (this.canPass(policys.contains("HTTPS"), form.getHttpsDefendPolicyForm()).booleanValue()) {
                itemInfo = new ZoneTemplateItemsInfo();
                itemInfo.setChildrenId(form.getHttpsDefendPolicyForm().getId());
                itemInfo.setType("HTTPS");
                info.addTozoneTemplateItemsInfos(itemInfo);
            }
            if (this.canPass(policys.contains("DNS"), form.getDnsDefendPolicyForm()).booleanValue()) {
                itemInfo = new ZoneTemplateItemsInfo();
                itemInfo.setChildrenId(form.getDnsDefendPolicyForm().getId());
                itemInfo.setType("DNS");
                info.addTozoneTemplateItemsInfos(itemInfo);
            }
            if (this.canPass(policys.contains("SIP"), form.getSipDefendPolicyForm()).booleanValue()) {
                itemInfo = new ZoneTemplateItemsInfo();
                itemInfo.setChildrenId(form.getSipDefendPolicyForm().getId());
                itemInfo.setType("SIP");
                info.addTozoneTemplateItemsInfos(itemInfo);
            }
            if (this.canPass(policys.contains("Other"), form.getOtherDefendPolicyForm()).booleanValue()) {
                itemInfo = new ZoneTemplateItemsInfo();
                itemInfo.setChildrenId(form.getOtherDefendPolicyForm().getId());
                itemInfo.setType("Other");
                info.addTozoneTemplateItemsInfos(itemInfo);
            }
            if (this.canPass(policys.contains("TOPNSTUDY"), form.getTopNStudyForm()).booleanValue()) {
                itemInfo = new ZoneTemplateItemsInfo();
                itemInfo.setChildrenId(form.getTopNStudyForm().getId());
                itemInfo.setType("TOPNSTUDY");
                info.addTozoneTemplateItemsInfos(itemInfo);
            }
            if ("NFA".equals(form.getDeviceType()) && null != this.pkids && !this.pkids.isEmpty()) {
                for (Long pkid : this.pkids) {
                    ZoneTemplateItemsInfo itemInfo2 = new ZoneTemplateItemsInfo();
                    itemInfo2.setChildrenId(pkid);
                    itemInfo2.setType("NFA");
                    info.addTozoneTemplateItemsInfos(itemInfo2);
                }
            }
        }
        return info;
    }

    public void update(ZoneTemplateForm form) {
        this.saveServicePolicy(form);
        if (null == form.getNfaPolicyEditForm() || "NFA".equals(form.getDeviceType()) && null != form.getNfaPolicyEditForm()) {
            ZoneTemplateInfo info = this.tranForm2Info(form);
            this.dao.update(info);
        }
    }

    @Override
    public ZoneTemplateForm queryTemplateByName(String templateName) {
        ZoneTemplateForm zoneTemplateForm = new ZoneTemplateForm();
        List<ZoneTemplateInfo> infos = this.dao.getTemplateByName(templateName);
        if (infos.isEmpty()) {
            return zoneTemplateForm;
        }
        VsmUtil.getInstance().copyProperties(infos.get(0), zoneTemplateForm);
        return zoneTemplateForm;
    }

    public void setAticDeviceService(IAticDeviceService aticDeviceService) {
        this.aticDeviceService = aticDeviceService;
    }

    public IAticDeviceService getAticDeviceService() {
        return this.aticDeviceService;
    }

    public INfaPolicyService getNfaPolicyService() {
        return this.nfaPolicyService;
    }

    public void setNfaPolicyService(INfaPolicyService nfaPolicyService) {
        this.nfaPolicyService = nfaPolicyService;
    }

    public INfaPolicyEditService getNfaPolicyEditService() {
        return this.nfaPolicyEditService;
    }

    public void setNfaPolicyEditService(INfaPolicyEditService nfaPolicyEditService) {
        this.nfaPolicyEditService = nfaPolicyEditService;
    }

    public List<Long> getPkids() {
        return this.pkids;
    }

    public void setPkids(List<Long> pkids) {
        this.pkids = pkids;
    }

    @Override
    public ZoneTemplateForm queryTemplateById(Long templateId) {
        ZoneTemplateInfo zoneTemplateInfo = this.dao.getTemplateByTemplateId(templateId);
        ZoneTemplateForm zoneTemplateForm = new ZoneTemplateForm();
        VsmUtil.getInstance().copyProperties(zoneTemplateInfo, zoneTemplateForm);
        return zoneTemplateForm;
    }
}

