/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.service.data;

import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.atic.sdk.zone.form.ZoneIpForm;
import com.hs.atic.sdk.zone.service.IZoneService;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.secservice.ddos.common.FeaturePair;
import com.hs.vsm.secservice.ddos.common.ServicePair;
import com.hs.vsm.secservice.ddos.dao.ZoneDeviceDeployStatusDao;
import com.hs.vsm.secservice.ddos.dao.ZoneFeatureStatusDao;
import com.hs.vsm.secservice.ddos.dao.ZoneServiceStatusDao;
import com.hs.vsm.secservice.ddos.model.ZoneDeviceDeployStatusInfo;
import com.hs.vsm.secservice.ddos.model.ZoneFeatureStatusInfo;
import com.hs.vsm.secservice.ddos.model.ZoneServiceStatusInfo;
import com.hs.vsm.secservice.ddos.service.data.ZoneConfigData;
import com.hs.vsm.secservice.sdk.common.util.ProgressBar;
import com.hs.vsm.secservice.sdk.module.ddos.common.ZonePair;
import com.hs.vsm.secservice.sdk.module.ddos.form.FilterDeviceZoneForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.NfaPolicyEditForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneDeviceForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZonePolicyApplyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneServiceForm;
import com.hs.vsm.secservice.sdk.module.ddos.service.IFilterDeviceZoneInfoService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IFilterService;
import com.hs.vsm.secservice.sdk.module.ddos.service.INfaPolicyEditService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZonePolicyApplyServiceSimple;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneServiceService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class ConfigDataTools {
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private IZonePolicyApplyServiceSimple zonePolicyService;
    private IZoneServiceService zoneService;
    private IZoneService userService;
    private ZoneFeatureStatusDao zoneFeatureStatusDao;
    private ZoneDeviceDeployStatusDao zoneDeviceDeployStatusDao;
    private ZoneServiceStatusDao zoneServiceStatusDao;
    private IAticDeviceService aticDeviceService;
    private IFilterDeviceZoneInfoService filterZoneService;
    private IFilterService filterService;
    private INfaPolicyEditService nfaPolicyEditService;

    public INfaPolicyEditService getNfaPolicyEditService() {
        return this.nfaPolicyEditService;
    }

    public void setNfaPolicyEditService(INfaPolicyEditService nfaPolicyEditService) {
        this.nfaPolicyEditService = nfaPolicyEditService;
    }

    public IFilterService getFilterService() {
        return this.filterService;
    }

    public void setFilterService(IFilterService filterService) {
        this.filterService = filterService;
    }

    public IFilterDeviceZoneInfoService getFilterZoneService() {
        return this.filterZoneService;
    }

    public void setFilterZoneService(IFilterDeviceZoneInfoService filterZoneService) {
        this.filterZoneService = filterZoneService;
    }

    public IZoneService getUserService() {
        return this.userService;
    }

    public void setUserService(IZoneService userService) {
        this.userService = userService;
    }

    public ZoneConfigData initZoneConfigData(List<Long> zoneIdList, ProgressBar pbr, List<String> features, List<String> zoneIp) {
        ZoneConfigData configData = new ZoneConfigData();
        for (Long zoneId : zoneIdList) {
            ZoneInfoForm zoneInfoForm = this.userService.getInitConfigById(zoneId, features, zoneIp);
            if (null != zoneInfoForm) {
                configData.getZoneInfoMap().put(zoneId, zoneInfoForm);
            } else {
                this.logger.error((Object)("no info for zoneId:" + zoneId));
            }
            ZonePolicyApplyForm zoneBasiPolicy = this.zonePolicyService.query(zoneId, features);
            if (null != zoneBasiPolicy) {
                configData.getZoneBasicInfoMap().put(zoneId, zoneBasiPolicy);
                this.initZoneID2DeviceIdsMap(zoneBasiPolicy, configData);
                this.initDeviceID2ZoneIDsMap(zoneBasiPolicy, configData);
                this.initZoneId2CrcDeployedMap(zoneBasiPolicy, configData);
                this.initZoneId2PreDeployStatusMap(zoneBasiPolicy, configData);
                this.initZoneFeatureStatus(zoneId, configData);
                this.initZoneServiceStatusMap(zoneId, configData);
                this.initZoneDeviceStatusMap(zoneId, configData);
            } else {
                this.logger.error((Object)("no info for zoneId:" + zoneId));
            }
            this.initZoneService(zoneId, configData, features);
            if (null != configData.getZoneID2DeviceIdsMap().get(zoneId) || null == pbr) continue;
            pbr.next(pbr.getTotalStep() - pbr.getCurrentStep());
            throw new LegoCheckedException(630100L);
        }
        this.initZoneServiceToUndeploy(configData);
        return configData;
    }

    public ZoneConfigData initZoneConfigData(Long zoneId) {
        ZoneConfigData configData = new ZoneConfigData();
        ZoneInfoForm zoneInfoForm = this.userService.getById(zoneId);
        if (null != zoneInfoForm) {
            configData.getZoneInfoMap().put(zoneId, zoneInfoForm);
        } else {
            this.logger.error((Object)("no info for zoneId:" + zoneId));
        }
        ZonePolicyApplyForm zoneBasiPolicy = (ZonePolicyApplyForm)this.zonePolicyService.query(zoneId);
        if (null != zoneBasiPolicy) {
            configData.getZoneBasicInfoMap().put(zoneId, zoneBasiPolicy);
            this.initZoneID2DeviceIdsMap(zoneBasiPolicy, configData);
            this.initZoneFilterMap(zoneId, configData);
            this.initZoneFeatureStatus(zoneId, configData);
            this.initZoneServiceStatusMap(zoneId, configData);
            this.initZoneDeviceStatusMap(zoneId, configData);
        } else {
            this.logger.error((Object)("no info for zoneId:" + zoneId));
        }
        this.initZoneService(zoneId, configData, null);
        this.initZoneServiceToUndeploy(configData);
        return configData;
    }

    private void initZoneFilterMap(Long zoneId, ZoneConfigData configData) {
        List<Object> filterForms = new ArrayList();
        List<FilterDeviceZoneForm> filterDeviceZoneForms = this.filterZoneService.queryByZoneId(zoneId);
        if (null == filterDeviceZoneForms || filterDeviceZoneForms.isEmpty()) {
            configData.getZoneFilterInfoMap().put(zoneId, filterForms);
            return;
        }
        HashSet<Long> filterIdSet = new HashSet<Long>();
        for (FilterDeviceZoneForm filterDeviceForm : filterDeviceZoneForms) {
            filterIdSet.add(filterDeviceForm.getFilterId());
        }
        String filterIds = "";
        StringBuffer buf = new StringBuffer();
        if (!filterIdSet.isEmpty()) {
            for (Long id : filterIdSet) {
                buf.append(id + ",");
            }
            filterIds = buf.toString();
            filterIds = filterIds.substring(0, filterIds.length() - 1);
            filterForms = this.filterService.queryByFilterIds(filterIds);
        }
        configData.getZoneFilterInfoMap().put(zoneId, filterForms);
    }

    public ZoneConfigData initUndeployData(List<Long> zoneIdList, ProgressBar pbr) {
        ZoneConfigData configData = new ZoneConfigData();
        for (Long zoneId : zoneIdList) {
            ZonePolicyApplyForm zoneBasiPolicy;
            ZoneInfoForm zoneInfoForm = this.userService.getById(zoneId);
            if (null != zoneInfoForm) {
                configData.getZoneInfoMap().put(zoneId, zoneInfoForm);
            } else {
                this.logger.error((Object)("no info for zoneId:" + zoneId));
            }
            if (null == (zoneBasiPolicy = (ZonePolicyApplyForm)this.zonePolicyService.query(zoneId)) || zoneBasiPolicy.getDeployState().equals("UNDEPLOY")) continue;
            configData.getZoneBasicInfoMap().put(zoneId, zoneBasiPolicy);
            this.initZoneID2DeviceIdsMap(zoneBasiPolicy, configData);
            this.initDeviceID2ZoneIDsMap(zoneBasiPolicy, configData);
            this.initZoneFeatureStatus(zoneId, configData);
            this.initZoneServiceStatusMap(zoneId, configData);
            this.initZoneDeviceStatusMap(zoneId, configData);
        }
        return configData;
    }

    public ZoneConfigData initUndeployData(Long zoneId, List<Long> deviceIds, ProgressBar pbr) {
        ZoneConfigData configData = new ZoneConfigData();
        ZoneInfoForm zoneInfoForm = this.userService.getById(zoneId);
        if (null != zoneInfoForm) {
            configData.getZoneInfoMap().put(zoneId, zoneInfoForm);
        } else {
            this.logger.error((Object)("no info for zoneId:" + zoneId));
        }
        ZonePolicyApplyForm zoneBasiPolicy = (ZonePolicyApplyForm)this.zonePolicyService.query(zoneId);
        if (null != zoneBasiPolicy) {
            ArrayList<ZoneDeviceForm> zoneDevice = new ArrayList<ZoneDeviceForm>();
            for (int i = 0; i < deviceIds.size(); ++i) {
                AticDevice device = this.aticDeviceService.getDeviceByMoid(deviceIds.get(i).longValue());
                if (null == device) continue;
                ZoneDeviceForm zoneDeviceForm = new ZoneDeviceForm();
                zoneDeviceForm.setDeviceId(deviceIds.get(i));
                zoneDeviceForm.setZoneId(zoneId);
                zoneDevice.add(zoneDeviceForm);
            }
            zoneBasiPolicy.setZoneDeviceForms(zoneDevice);
            configData.getZoneBasicInfoMap().put(zoneId, zoneBasiPolicy);
            this.initZoneID2DeviceIdsMap(zoneBasiPolicy, configData);
            this.initDeviceID2ZoneIDsMap(zoneBasiPolicy, configData);
            this.initZoneFeatureStatus(zoneId, configData);
            this.initZoneServiceStatusMap(zoneId, configData);
            this.initZoneDeviceStatusMap(zoneId, configData);
        }
        return configData;
    }

    private void initZoneDeviceStatusMap(Long zoneId, ZoneConfigData configData) {
        List<ZoneDeviceDeployStatusInfo> list = this.zoneDeviceDeployStatusDao.queryByZoneId(zoneId);
        if (null != list) {
            for (ZoneDeviceDeployStatusInfo info : list) {
                ZonePair pair = new ZonePair(info.getDeviceId(), info.getZoneId());
                configData.getZoneDeviceStatusMap().put(pair, info);
            }
        }
    }

    private void initZoneServiceStatusMap(Long zoneId, ZoneConfigData configData) {
        List<ZoneServiceStatusInfo> list = this.zoneServiceStatusDao.queryByZoneId(zoneId);
        for (ZoneServiceStatusInfo info : list) {
            ServicePair pair = new ServicePair(info.getZoneId(), info.getDeviceId(), info.getServiceId());
            configData.getZoneServiceStatusMap().put(pair, info);
        }
    }

    private void initZoneFeatureStatus(Long zoneId, ZoneConfigData configData) {
        List<ZoneFeatureStatusInfo> list = this.zoneFeatureStatusDao.queryByZoneId(zoneId);
        if (null != list) {
            for (ZoneFeatureStatusInfo info : list) {
                FeaturePair pair = new FeaturePair(info.getZoneId(), info.getDeviceId(), info.getFeatureType(), info.getFeatureId());
                configData.getZoneFeatureStatusMap().put(pair, info);
            }
        }
    }

    private void initZoneServiceToUndeploy(ZoneConfigData configData) {
        for (Map.Entry<ServicePair, ZoneServiceStatusInfo> service : configData.getZoneServiceStatusMap().entrySet()) {
            if (configData.getZoneServiceMap().containsKey(service.getKey().getServiceId())) continue;
            ServicePair pair = service.getKey();
            ZoneServiceForm form = new ZoneServiceForm();
            ZoneServiceStatusInfo statusInfo = service.getValue();
            form.setPkid(statusInfo.getServiceId());
            form.setServiceName(statusInfo.getServiceName());
            form.setServiceType(statusInfo.getServiceType());
            form.setProtocol(statusInfo.getProtocol());
            configData.getZoneServiceToUndeploy().put(pair, form);
        }
    }

    private void initDeviceID2ZoneIDsMap(ZonePolicyApplyForm form, ZoneConfigData configData) {
        if (null == form || form.getZoneDeviceForms().isEmpty()) {
            return;
        }
        List<ZoneDeviceForm> zoneDeviceInfos = form.getZoneDeviceForms();
        for (ZoneDeviceForm deviceform : zoneDeviceInfos) {
            AticDevice device = this.aticDeviceService.getDeviceByMoid(deviceform.getDeviceId().longValue());
            if (device == null) {
                this.logger.error((Object)("securityNE has been deleted!! deviceId is : " + deviceform.getDeviceId()));
                continue;
            }
            Map<Long, List<Long>> map = configData.getDeviceId2ZoneIDsMap();
            if (map.containsKey(deviceform.getDeviceId())) {
                if (map.get(deviceform.getDeviceId()).contains(form.getZoneId())) continue;
                map.get(deviceform.getDeviceId()).add(form.getZoneId());
                continue;
            }
            ArrayList<Long> list = new ArrayList<Long>();
            if (!list.contains(form.getZoneId())) {
                list.add(form.getZoneId());
            }
            map.put(deviceform.getDeviceId(), list);
        }
    }

    private void initZoneId2CrcDeployedMap(ZonePolicyApplyForm form, ZoneConfigData configData) {
        if (null == form || form.getZoneDeviceForms().isEmpty()) {
            return;
        }
        configData.getZoneId2CrcDeployedMap().put(form.getZoneId(), form.getDeployedCrc());
    }

    private void initServiceId2CrcDeployedMap(ZoneServiceForm form, ZoneConfigData configData) {
        if (null == form) {
            return;
        }
        configData.getServiceId2CrcDeployedMap().put(form.getPkid(), form.getDeployedCrc());
    }

    private void initZoneService(Long zoneId, ZoneConfigData configData, List<String> features) {
        long startTime = System.currentTimeMillis();
        this.logger.debug((Object)("The initZoneService() start time is " + startTime));
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("zoneId", String.valueOf(zoneId));
        Paging page = this.zoneService.queryByPage(queryMap, 0, Integer.MAX_VALUE);
        List serviceForms = page.getData();
        HashMap<Long, AticDevice> deviceMap = new HashMap<Long, AticDevice>();
        this.logger.debug((Object)("The for(){} start time is " + (System.currentTimeMillis() - startTime) + "ms"));
        for (ZoneServiceForm service : serviceForms) {
            AticDevice device = (AticDevice)deviceMap.get(service.getDeviceId());
            if (device == null) {
                AticDevice deviceSec = this.aticDeviceService.getDeviceByMoid(service.getDeviceId().longValue());
                if (null == deviceSec) {
                    this.logger.error((Object)"securityNE has been deleted!! ");
                    continue;
                }
                deviceMap.put(service.getDeviceId(), deviceSec);
            }
            ZoneServiceForm serviceForm = this.zoneService.query(service.getPkid(), features);
            NfaPolicyEditForm nfaPolicyEditForm = new NfaPolicyEditForm();
            if (null != this.nfaPolicyEditService) {
                nfaPolicyEditForm = this.nfaPolicyEditService.queryNfaPolicyByServiceId(service.getPkid());
            }
            if (null != serviceForm) {
                if (null != nfaPolicyEditForm) {
                    serviceForm.setNfaPolicyEditForm(nfaPolicyEditForm);
                }
                configData.getZoneServiceMap().put(service.getPkid(), serviceForm);
                this.initZoneId2ServiceIdsMap(serviceForm.getZoneId(), serviceForm.getPkid(), configData);
                this.initServiceId2CrcDeployedMap(serviceForm, configData);
                continue;
            }
            this.logger.error((Object)("no info for zoneId:" + zoneId));
        }
        this.logger.debug((Object)("The for(){} used times is " + (System.currentTimeMillis() - startTime) + "ms"));
    }

    private void initZoneID2DeviceIdsMap(ZonePolicyApplyForm form, ZoneConfigData configData) {
        if (null == form || form.getZoneDeviceForms().isEmpty()) {
            return;
        }
        ArrayList<Long> deviceList = new ArrayList<Long>();
        for (ZoneDeviceForm deviceForm : form.getZoneDeviceForms()) {
            Long deviceId = deviceForm.getDeviceId();
            AticDevice device = this.aticDeviceService.getDeviceByMoid(deviceId.longValue());
            if (device == null) {
                this.logger.error((Object)("securityNE has been deleted!! deviceId is : " + deviceId));
                continue;
            }
            deviceList.add(deviceId);
        }
        configData.getZoneID2DeviceIdsMap().put(form.getZoneId(), deviceList);
    }

    private void initZoneId2PreDeployStatusMap(ZonePolicyApplyForm form, ZoneConfigData configData) {
        if (null == form || form.getZoneDeviceForms().isEmpty()) {
            return;
        }
        configData.getZoneId2PreDeployStatusMap().put(form.getZoneId(), form.getDeployState());
    }

    private void initZoneId2ServiceIdsMap(Long zoneId, Long serviceId, ZoneConfigData configData) {
        Map<Long, List<Long>> map = configData.getZoneId2ServiceIdsMap();
        if (map.containsKey(zoneId)) {
            if (!map.get(zoneId).contains(serviceId)) {
                map.get(zoneId).add(serviceId);
            }
        } else {
            ArrayList<Long> list = new ArrayList<Long>();
            if (!list.contains(serviceId)) {
                list.add(serviceId);
            }
            map.put(zoneId, list);
        }
    }

    public IZonePolicyApplyServiceSimple getZonePolicyService() {
        return this.zonePolicyService;
    }

    public void setZonePolicyService(IZonePolicyApplyServiceSimple zonePolicyService) {
        this.zonePolicyService = zonePolicyService;
    }

    public IZoneServiceService getZoneService() {
        return this.zoneService;
    }

    public void setZoneService(IZoneServiceService zoneService) {
        this.zoneService = zoneService;
    }

    public String getZoneInfoCalcCrcString(ZoneInfoForm form) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("ZoneInfoForm [").append("zoneName=" + form.getZoneName() + ",").append("zoneId=" + form.getZoneId() + "]");
        ArrayList<String> ipList = new ArrayList<String>();
        for (ZoneIpForm ip : form.getZoneIpFormList()) {
            ipList.add("ipitem[ip=" + ip.getZoneIp() + ",mask=" + ip.getMask() + "]");
        }
        Collections.sort(ipList);
        buffer.append(((Object)ipList).toString());
        return buffer.toString();
    }

    public ZoneFeatureStatusDao getZoneFeatureStatusDao() {
        return this.zoneFeatureStatusDao;
    }

    public void setZoneFeatureStatusDao(ZoneFeatureStatusDao zoneFeatureStatusDao) {
        this.zoneFeatureStatusDao = zoneFeatureStatusDao;
    }

    public ZoneDeviceDeployStatusDao getZoneDeviceDeployStatusDao() {
        return this.zoneDeviceDeployStatusDao;
    }

    public void setZoneDeviceDeployStatusDao(ZoneDeviceDeployStatusDao zoneDeviceDeployStatusDao) {
        this.zoneDeviceDeployStatusDao = zoneDeviceDeployStatusDao;
    }

    public ZoneServiceStatusDao getZoneServiceStatusDao() {
        return this.zoneServiceStatusDao;
    }

    public void setZoneServiceStatusDao(ZoneServiceStatusDao zoneServiceStatusDao) {
        this.zoneServiceStatusDao = zoneServiceStatusDao;
    }

    public void setAticDeviceService(IAticDeviceService aticDeviceService) {
        this.aticDeviceService = aticDeviceService;
    }

    public IAticDeviceService getAticDeviceService() {
        return this.aticDeviceService;
    }
}

