/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.service.data;

import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.atic.sdk.zone.service.IZoneService;
import com.hs.atic.util.AticUtil;
import com.hs.vsm.secservice.ddos.common.FilterDeviceZonePair;
import com.hs.vsm.secservice.ddos.common.FilterZonePair;
import com.hs.vsm.secservice.ddos.dao.FilterDao;
import com.hs.vsm.secservice.ddos.dao.FilterDeviceZoneInfoDao;
import com.hs.vsm.secservice.ddos.dao.HttpFilterDao;
import com.hs.vsm.secservice.ddos.model.FilterDeviceZoneInfo;
import com.hs.vsm.secservice.ddos.model.FilterInfo;
import com.hs.vsm.secservice.ddos.model.HttpFilterInfo;
import com.huawei.atic.device.model.AticDevice;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FilterInitDeployData {
    private Map<Long, ZoneInfoForm> zoneInfoMap = new HashMap<Long, ZoneInfoForm>();
    private Map<Long, FilterInfo> filterInfoMap = new HashMap<Long, FilterInfo>();
    private Map<Long, AticDevice> neInfoMap = new HashMap<Long, AticDevice>();
    private Map<Long, List<HttpFilterInfo>> filterPolicyMap = new HashMap<Long, List<HttpFilterInfo>>();
    private Map<Long, Set<Long>> deviceDeployFiltersMap = new HashMap<Long, Set<Long>>();
    private Map<Long, Set<FilterZonePair>> deviceFilterDeployZoneMap = new HashMap<Long, Set<FilterZonePair>>();
    private Map<Long, Set<FilterZonePair>> deviceFilterUnDeployZoneMap = new HashMap<Long, Set<FilterZonePair>>();

    public void addToZoneInfoMap(Long zoneId, IZoneService zoneService) {
        if (this.zoneInfoMap.get(zoneId) == null) {
            ZoneInfoForm zoneInfoForm = zoneService.getById(zoneId);
            if (zoneId == 0L) {
                zoneInfoForm = new ZoneInfoForm();
                zoneInfoForm.setZoneId(0L);
            }
            this.zoneInfoMap.put(zoneId, zoneInfoForm);
        }
    }

    public void addToFilterDeployZoneMap(Long filterId, Long deviceId, Long zoneId, int direction) {
        FilterZonePair filterZonePair = new FilterZonePair(filterId, zoneId, direction);
        if (this.deviceFilterDeployZoneMap.get(deviceId) == null) {
            this.deviceFilterDeployZoneMap.put(deviceId, new HashSet());
        }
        this.deviceFilterDeployZoneMap.get(deviceId).add(filterZonePair);
    }

    public void addToFilterUnDeployZoneMap(Long filterId, Long deviceId, Long zoneId, int direction) {
        FilterZonePair filterZonePair = new FilterZonePair(filterId, zoneId, direction);
        if (this.deviceFilterUnDeployZoneMap.get(deviceId) == null) {
            this.deviceFilterUnDeployZoneMap.put(deviceId, new HashSet());
        }
        this.deviceFilterUnDeployZoneMap.get(deviceId).add(filterZonePair);
    }

    public void addToFilterInfoMap(FilterDeviceZonePair filterDeviceZonePair, FilterDao filterDao, FilterDeviceZoneInfoDao filterDeviceZoneInfoDao) {
        Long filterId = filterDeviceZonePair.getFilterId();
        Long deviceId = filterDeviceZonePair.getDeviceId();
        int gloApplyFlag = filterDeviceZonePair.getGloApplyFlag();
        FilterDeviceZoneInfo filterDeviceZoneInfo = null;
        if (this.filterInfoMap.get(filterId) == null) {
            FilterInfo filterInfo = filterDao.get(filterId);
            List<FilterDeviceZoneInfo> filterDeviceZoneList = filterDeviceZoneInfoDao.queryFilterForGlo(deviceId, filterId);
            if (!filterDeviceZoneList.isEmpty()) {
                filterDeviceZoneInfo = filterDeviceZoneList.get(0);
            }
            if (null != filterDeviceZoneInfo) {
                filterInfo.setGloFilter(true);
                filterInfo.setDeployApply(gloApplyFlag == 1);
                filterInfo.setDefineState(filterDeviceZoneInfo.getFilterDefineState());
                filterInfo.setDeployState(filterDeviceZoneInfo.getDeployState());
                filterInfo.setPreference(filterDeviceZoneInfo.getPreference());
                filterInfo.setFilterView(true);
                filterInfo.setDirection(1);
            }
            this.filterInfoMap.put(filterId, filterInfo);
        }
    }

    public void addToNeInfoMap(Long deviceId) {
        this.neInfoMap.put(deviceId, null);
    }

    public void addToDeviceDeployFiltersMap(Long filterId, Long deviceId, HttpFilterDao httpFilterDao) {
        if (this.deviceDeployFiltersMap.get(deviceId) == null) {
            this.deviceDeployFiltersMap.put(deviceId, new HashSet());
        }
        this.deviceDeployFiltersMap.get(deviceId).add(filterId);
        if (this.filterPolicyMap.get(filterId) == null) {
            List<HttpFilterInfo> filterPolicyList = httpFilterDao.queryByFilterId(filterId);
            List<HttpFilterInfo> afterTransList = this.handlerFilterContent(filterPolicyList);
            this.filterPolicyMap.put(filterId, afterTransList);
        }
    }

    private List<HttpFilterInfo> handlerFilterContent(List<HttpFilterInfo> filterPolicyList) {
        ArrayList<HttpFilterInfo> afterTrans = new ArrayList<HttpFilterInfo>();
        for (HttpFilterInfo each : filterPolicyList) {
            HttpFilterInfo hfInfo = new HttpFilterInfo();
            AticUtil.copyProperties((Object)each, (Object)hfInfo);
            String filterConten = each.getFilterContent();
            String result = this.transBlankAndQues(filterConten);
            hfInfo.setFilterContent(result);
            afterTrans.add(hfInfo);
        }
        return afterTrans;
    }

    private String transBlankAndQues(String toTrans) {
        int lastIndex;
        char[] eachs;
        String afterTrans = toTrans.replaceAll("\\\\x", "\\\\\\\\x");
        StringBuffer buffer = new StringBuffer();
        for (char each : eachs = afterTrans.toCharArray()) {
            if (each == '?') {
                char bb = each;
                String cc = Integer.toHexString(bb);
                buffer.append("\\x");
                buffer.append(cc);
                continue;
            }
            buffer.append(each);
        }
        String result = buffer.toString().trim();
        if (result.length() > 600 && (lastIndex = (result = result.substring(0, 600)).lastIndexOf("\\x")) > 251) {
            result = result.substring(0, lastIndex);
        }
        return result;
    }

    public Map<Long, ZoneInfoForm> getZoneInfoMap() {
        return this.zoneInfoMap;
    }

    public void setZoneInfoMap(Map<Long, ZoneInfoForm> zoneInfoMap) {
        this.zoneInfoMap = zoneInfoMap;
    }

    public Map<Long, FilterInfo> getFilterInfoMap() {
        return this.filterInfoMap;
    }

    public void setFilterInfoMap(Map<Long, FilterInfo> filterInfoMap) {
        this.filterInfoMap = filterInfoMap;
    }

    public Map<Long, AticDevice> getNeInfoMap() {
        return this.neInfoMap;
    }

    public void setNeInfoMap(Map<Long, AticDevice> neInfoMap) {
        this.neInfoMap = neInfoMap;
    }

    public Map<Long, List<HttpFilterInfo>> getFilterPolicyMap() {
        return this.filterPolicyMap;
    }

    public void setFilterPolicyMap(Map<Long, List<HttpFilterInfo>> filterPolicyMap) {
        this.filterPolicyMap = filterPolicyMap;
    }

    public Map<Long, Set<Long>> getDeviceDeployFiltersMap() {
        return this.deviceDeployFiltersMap;
    }

    public void setDeviceDeployFiltersMap(Map<Long, Set<Long>> deviceDeployFiltersMap) {
        this.deviceDeployFiltersMap = deviceDeployFiltersMap;
    }

    public Map<Long, Set<FilterZonePair>> getDeviceFilterDeployZoneMap() {
        return this.deviceFilterDeployZoneMap;
    }

    public void setDeviceFilterDeployZoneMap(Map<Long, Set<FilterZonePair>> deviceFilterDeployZoneMap) {
        this.deviceFilterDeployZoneMap = deviceFilterDeployZoneMap;
    }

    public Map<Long, Set<FilterZonePair>> getDeviceFilterUnDeployZoneMap() {
        return this.deviceFilterUnDeployZoneMap;
    }

    public void setDeviceFilterUnDeployZoneMap(Map<Long, Set<FilterZonePair>> deviceFilterUnDeployZoneMap) {
        this.deviceFilterUnDeployZoneMap = deviceFilterUnDeployZoneMap;
    }
}

