/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.service.data;

import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.secservice.ddos.common.ServicePair;
import com.hs.vsm.secservice.ddos.model.ZoneServiceStatusInfo;
import com.hs.vsm.secservice.ddos.service.data.ZoneConfigData;
import com.hs.vsm.secservice.ddos.service.data.feature.UndeployMissFaultData;
import com.hs.vsm.secservice.ddos.service.data.feature.ZoneDefineInfo;
import com.hs.vsm.secservice.sdk.frame.model.CmdViewBean;
import com.hs.vsm.secservice.sdk.frame.model.IFeature;
import com.hs.vsm.secservice.sdk.frame.model.LogicDev;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ZoneToUndeployData {
    private Map<LogicDev, List<IFeature>> toUndeployData = new HashMap<LogicDev, List<IFeature>>();
    private ZoneConfigData zoneConfigData;
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);

    public void initToUndeployData(ZoneConfigData zoneConfigDatas) {
        this.zoneConfigData = zoneConfigDatas;
        HashSet<Long> setZoneIds = new HashSet<Long>();
        for (Map.Entry<Long, List<Long>> device2ZoneIds : this.zoneConfigData.getDeviceId2ZoneIDsMap().entrySet()) {
            Long deviceId = device2ZoneIds.getKey();
            List<Long> zoneIds = device2ZoneIds.getValue();
            ArrayList<ZoneDefineInfo> list = new ArrayList<ZoneDefineInfo>();
            for (Long zoneId : zoneIds) {
                ZoneInfoForm zoneInfoForm = this.zoneConfigData.getZoneInfoMap().get(zoneId);
                if (null == zoneInfoForm) {
                    this.logger.error((Object)("can not find data ZoneInfoMap with zoneId of :" + zoneId));
                    continue;
                }
                ArrayList<ZoneServiceStatusInfo> zoneServiceStatusInfolList = new ArrayList<ZoneServiceStatusInfo>();
                Map<ServicePair, ZoneServiceStatusInfo> servicePairMap = zoneConfigDatas.getZoneServiceStatusMap();
                Set<Map.Entry<ServicePair, ZoneServiceStatusInfo>> servicePairMapEntrySet = servicePairMap.entrySet();
                for (Map.Entry<ServicePair, ZoneServiceStatusInfo> servicePairMapEntry : servicePairMapEntrySet) {
                    ZoneServiceStatusInfo zoneServiceStatusInfo;
                    if (!servicePairMapEntry.getKey().getZoneId().equals(zoneId) || !servicePairMapEntry.getKey().getDeviceId().equals(deviceId) || (zoneServiceStatusInfo = servicePairMapEntry.getValue()).getServiceType() == null || !zoneServiceStatusInfo.getServiceType().equals(1)) continue;
                    zoneServiceStatusInfolList.add(zoneServiceStatusInfo);
                }
                ZoneDefineInfo zoneDefineInfo = new ZoneDefineInfo(zoneInfoForm, zoneInfoForm.getClass().getSimpleName(), zoneInfoForm.getZoneId());
                zoneDefineInfo.setZoneServiceStatusInfolList(zoneServiceStatusInfolList);
                zoneDefineInfo.setCmdViewList(this.buildView4System());
                list.add(zoneDefineInfo);
                setZoneIds.add(zoneId);
            }
            LogicDev logicDev = new LogicDev(deviceId, 1, "--");
            this.toUndeployData.put(logicDev, list);
        }
        this.initMissFault(setZoneIds);
    }

    private void initMissFault(Set<Long> setZoneIds) {
        Long deviceId = -1L;
        LogicDev logicDev = new LogicDev(deviceId, 1, "--");
        ArrayList<IFeature> list = new ArrayList<IFeature>();
        for (Long zoneId : setZoneIds) {
            this.generateList(list, zoneId);
        }
        this.toUndeployData.put(logicDev, list);
    }

    private void generateList(List<IFeature> list, Long zoneId) {
        ZoneInfoForm zoneInfoForm = this.zoneConfigData.getZoneInfoMap().get(zoneId);
        if (null != zoneInfoForm) {
            UndeployMissFaultData undeployMissFaultData = new UndeployMissFaultData(zoneInfoForm);
            list.add(undeployMissFaultData);
        }
    }

    public void initToUndeployData(ZoneConfigData zoneConfigDatas, String zoneName, Integer zoneType) {
        this.zoneConfigData = zoneConfigDatas;
        for (Map.Entry<Long, List<Long>> device2ZoneIds : this.zoneConfigData.getDeviceId2ZoneIDsMap().entrySet()) {
            Long deviceId = device2ZoneIds.getKey();
            List<Long> zoneIds = device2ZoneIds.getValue();
            ArrayList<ZoneDefineInfo> list = new ArrayList<ZoneDefineInfo>();
            for (Long zoneId : zoneIds) {
                ZoneInfoForm zoneInfoForm = this.zoneConfigData.getZoneInfoMap().get(zoneId);
                if (null == zoneInfoForm) {
                    if (null == zoneName) continue;
                    this.logger.error((Object)("can not find data ZoneInfoMap with zoneId of :" + zoneId));
                    zoneInfoForm = new ZoneInfoForm();
                    zoneInfoForm.setZoneId(zoneId);
                    zoneInfoForm.setZoneName(zoneName);
                    zoneInfoForm.setZoneType(zoneType);
                }
                ArrayList<ZoneServiceStatusInfo> zoneServiceStatusInfolList = new ArrayList<ZoneServiceStatusInfo>();
                Map<ServicePair, ZoneServiceStatusInfo> servicePairMap = zoneConfigDatas.getZoneServiceStatusMap();
                Set<Map.Entry<ServicePair, ZoneServiceStatusInfo>> servicePairMapEntrySet = servicePairMap.entrySet();
                for (Map.Entry<ServicePair, ZoneServiceStatusInfo> servicePairMapEntry : servicePairMapEntrySet) {
                    if (!servicePairMapEntry.getKey().getZoneId().equals(zoneId) || !servicePairMapEntry.getKey().getDeviceId().equals(deviceId)) continue;
                    ZoneServiceStatusInfo zoneServiceStatusInfo = servicePairMapEntry.getValue();
                    zoneServiceStatusInfolList.add(zoneServiceStatusInfo);
                }
                ZoneDefineInfo zoneDefineInfo = new ZoneDefineInfo(zoneInfoForm, zoneInfoForm.getClass().getSimpleName(), zoneInfoForm.getZoneId());
                zoneDefineInfo.setZoneServiceStatusInfolList(zoneServiceStatusInfolList);
                zoneDefineInfo.setCmdViewList(this.buildView4System());
                list.add(zoneDefineInfo);
            }
            LogicDev logicDev = new LogicDev(deviceId, 1, "--");
            this.toUndeployData.put(logicDev, list);
        }
    }

    public Map<LogicDev, List<IFeature>> getToUndeployData() {
        return this.toUndeployData;
    }

    public void setToUndeployData(Map<LogicDev, List<IFeature>> toUndeployData) {
        this.toUndeployData = toUndeployData;
    }

    public ZoneConfigData getZoneConfigData() {
        return this.zoneConfigData;
    }

    public void setZoneConfigData(ZoneConfigData zoneConfigData) {
        this.zoneConfigData = zoneConfigData;
    }

    private List<CmdViewBean> buildView4System() {
        ArrayList<CmdViewBean> list = new ArrayList<CmdViewBean>();
        CmdViewBean view = new CmdViewBean();
        HashMap<String, String> params = new HashMap<String, String>();
        view.setViewName("system");
        view.setViewParams(params);
        list.add(view);
        return list;
    }
}

