/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.service.data.feature;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.vsm.secservice.ddos.common.CmdUtil;
import com.hs.vsm.secservice.ddos.model.FilterInfo;
import com.hs.vsm.secservice.ddos.model.HttpFilterInfo;
import com.hs.vsm.secservice.sdk.frame.model.AbstractFeature;
import com.hs.vsm.secservice.sdk.frame.model.IFeature;
import com.hs.vsm.secservice.sdk.frame.model.LogicDev;
import com.huawei.atic.secne.adapter.capability.model.DeviceTypeInfo;
import com.huawei.atic.secne.adapter.frame.service.CmdDevCapManager;
import com.huawei.atic.secservice.ddos.service.impl.DdosDevCapabilityServiceImpl;
import com.huawei.atic.secservice.policyengine.command.CommandAPI;
import com.huawei.atic.secservice.policyengine.commandutil.CmdParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FilterData
extends AbstractFeature
implements Serializable {
    private static final long serialVersionUID = 6902038552149604753L;
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private FilterInfo filterInfo;
    private List<HttpFilterInfo> filterPolicyInfoList;

    public FilterData(String featureType, Long featureId, FilterInfo filterInfo, List<HttpFilterInfo> filterPolicyInfoList) {
        this.setFeatureId(featureId);
        this.setFeatureType(featureType);
        this.setFilterInfo(filterInfo);
        this.setFilterPolicyInfoList(filterPolicyInfoList);
    }

    @Override
    public Object doAudit(LogicDev logicDev, Object object) {
        return null;
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    @Override
    public Object doDeploy(LogicDev logicDev, Object object) {
        List<String> cmdList = this.doDeployTranslate(logicDev, true);
        this.logger.info((Object)("deploy filter, filter id : " + this.filterInfo.getPkid() + ", device id : " + logicDev.getDeviceId() + " cmd list :" + this.getcleanedMessage(cmdList.toString())));
        List<String> result = CmdUtil.execCmds(logicDev.getDeviceId(), cmdList);
        this.logger.info((Object)("deploy filter, filter id : " + this.filterInfo.getPkid() + ", device id : " + logicDev.getDeviceId() + " result list :" + this.getcleanedMessage(result.toString())));
        return result;
    }

    private List<String> doDeployTranslate(LogicDev logicDev, boolean isDeploy) {
        Long deviceId = logicDev.getDeviceId();
        ArrayList<CmdParam> cmdParamList = new ArrayList<CmdParam>();
        this.systemViewParam(cmdParamList);
        if (isDeploy) {
            this.createFilterParam(cmdParamList);
            this.filterViewPram(cmdParamList);
            this.filterActionParam(cmdParamList, deviceId);
            if (this.isSupportedUnderFilterId(deviceId)) {
                this.filterIdParam(cmdParamList);
            }
            this.undoAllKey(cmdParamList);
            this.createFilterPolicy(cmdParamList);
        } else {
            this.createUndoFilterParam(cmdParamList);
        }
        CommandAPI tool = new CommandAPI();
        String cmdFileDir = CmdDevCapManager.getInstance().getCmdDevCapaFileDir(deviceId);
        List cmdList = tool.doTranslate(cmdFileDir, "filter", cmdParamList);
        if (isDeploy) {
            this.translateFinger(deviceId, cmdList);
        }
        return cmdList;
    }

    private void translateFinger(Long deviceId, List<String> cmdList) {
        ArrayList<String> finStr = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        if (null != this.filterPolicyInfoList && !this.filterPolicyInfoList.isEmpty()) {
            for (HttpFilterInfo info : this.filterPolicyInfoList) {
                String filterKey = info.getFilterKey();
                String filterContent = "";
                if (!filterKey.equals("fingerprint")) continue;
                if (null != info.getFilterContent() && !info.getFilterContent().equals("")) {
                    String[] contents = info.getFilterContent().split("        ");
                    sb = sb.append("fingerprint");
                    for (int i = 0; i < contents.length; ++i) {
                        String[] content = contents[i].split(" ");
                        filterContent = this.translateFingerContent(content[1]);
                        if (content.length == 2) {
                            sb = sb.append(" offset ").append(content[0]).append(" content ").append(filterContent);
                            continue;
                        }
                        if (content.length != 3) continue;
                        sb = sb.append(" offset ").append(content[0]).append(" content ").append(filterContent).append(" depth ").append(content[2]);
                    }
                    finStr.add(sb.toString());
                }
                if (this.isSupportedFingerContentSupportVersion(deviceId)) {
                    String errorCode = "lego.err.631050";
                    if (!this.fingerContentIsV1R1(filterContent)) {
                        throw new LegoCheckedException(errorCode);
                    }
                }
                sb = new StringBuilder();
            }
            finStr.add("quit");
            cmdList.addAll(finStr);
        }
    }

    private String translateFingerContent(String fingerContent) {
        fingerContent = fingerContent.replace("\\\\x", "\\x");
        return fingerContent;
    }

    private boolean isSupportedUnderFilterId(Long deviceId) {
        DeviceTypeInfo devTypeInfo = CmdUtil.getDevTypeInfo(deviceId);
        Set supportAttr = DdosDevCapabilityServiceImpl.getInstance().getAllSupportedAttr(devTypeInfo);
        return supportAttr.contains("isSupportUnderFilterId");
    }

    private void systemViewParam(List<CmdParam> cmdParamList) {
        CmdParam cmdParam = new CmdParam();
        cmdParam.setCmdID("system");
        cmdParamList.add(cmdParam);
    }

    private void createFilterParam(List<CmdParam> cmdParamList) {
        CmdParam cmdParam = new CmdParam();
        cmdParam.setCmdID("filter");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("name", this.filterInfo.getFilterName());
        paramMap.put("type", this.filterInfo.getFilterType());
        cmdParam.setParams(paramMap);
        cmdParamList.add(cmdParam);
    }

    private void filterViewPram(List<CmdParam> cmdParamList) {
        CmdParam cmdParam = new CmdParam();
        cmdParam.setCmdID("filter");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("name", this.filterInfo.getFilterName());
        cmdParam.setParams(paramMap);
        cmdParamList.add(cmdParam);
    }

    private void createUndoFilterParam(List<CmdParam> cmdParamList) {
        CmdParam cmdParam = new CmdParam();
        cmdParam.setCmdID("filter");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("undo", "undo");
        paramMap.put("name", this.filterInfo.getFilterName());
        cmdParam.setParams(paramMap);
        cmdParamList.add(cmdParam);
    }

    private void filterActionParam(List<CmdParam> cmdParamList, Long deviceId) {
        CmdParam cmdParam = new CmdParam();
        cmdParam.setCmdID("action");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        String filterAction = "";
        if (this.filterInfo.getFilterAction() == 1) {
            filterAction = "pass";
            paramMap.put("action", filterAction);
        } else if (this.filterInfo.getFilterAction() == 2) {
            filterAction = "pass-mark-white";
            paramMap.put("action", filterAction);
        } else if (this.filterInfo.getFilterAction() == 3) {
            filterAction = "drop";
            paramMap.put("action", filterAction);
        } else if (this.filterInfo.getFilterAction() == 4) {
            filterAction = "drop-mark-black";
            paramMap.put("action", filterAction);
        } else if (this.filterInfo.getFilterAction() == 5) {
            filterAction = "limit " + this.filterInfo.getFilterAlert().toString();
            paramMap.put("action", filterAction);
        } else if (this.filterInfo.getFilterAction() == 6) {
            filterAction = "source-detect";
            paramMap.put("action", filterAction);
        } else if (this.filterInfo.getFilterAction() == 7) {
            if (this.isSupportSourceIpLimit(deviceId)) {
                filterAction = "limit source-ip " + this.filterInfo.getFilterAlert().toString();
                paramMap.put("action", filterAction);
            } else {
                String errorCode = "lego.err.631059";
                throw new LegoCheckedException(errorCode);
            }
        }
        cmdParam.setParams(paramMap);
        cmdParamList.add(cmdParam);
    }

    private boolean isSupportSourceIpLimit(Long deviceId) {
        DeviceTypeInfo devTypeInfo = CmdUtil.getDevTypeInfo(deviceId);
        Set supportAttr = DdosDevCapabilityServiceImpl.getInstance().getAllSupportedAttr(devTypeInfo);
        return supportAttr.contains("isSupportSourceLimit");
    }

    private void filterIdParam(List<CmdParam> cmdParamList) {
        int type = this.filterInfo.getFilterId();
        if (type == 0) {
            return;
        }
        CmdParam cmdParam = new CmdParam();
        cmdParam.setCmdID("filter-id");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("filter-id", String.valueOf(type));
        cmdParam.setParams(paramMap);
        cmdParamList.add(cmdParam);
    }

    private void createFilterPolicy(List<CmdParam> cmdParamList) {
        for (HttpFilterInfo info : this.filterPolicyInfoList) {
            String filterKey = info.getFilterKey();
            if (filterKey.equals("source-ip")) {
                this.createKeySourceIp(info, cmdParamList);
                continue;
            }
            if (filterKey.equals("destination-ip")) {
                this.createKeyDestinationIp(info, cmdParamList);
                continue;
            }
            if (filterKey.equals("packet-length")) {
                this.createKeyPacketLength(info, cmdParamList);
                continue;
            }
            if (filterKey.equals("ttl")) {
                this.createKeyTtl(info, cmdParamList);
                continue;
            }
            if (filterKey.equals("protocol")) {
                this.createKeyProtocol(info, cmdParamList);
                continue;
            }
            if (filterKey.equals("dscp")) {
                this.createKeyDscp(info, cmdParamList);
                continue;
            }
            if (filterKey.equals("fragment")) {
                this.createKeyFragment(info, cmdParamList);
                continue;
            }
            if (filterKey.equals("tcp-flag")) {
                this.createKeyTcpFlag(info, cmdParamList);
                continue;
            }
            if (filterKey.equals("destination-port")) {
                this.createKeyDestinationPort(info, cmdParamList);
                continue;
            }
            if (filterKey.equals("source-port")) {
                this.createKeySourcePort(info, cmdParamList);
                continue;
            }
            if (filterKey.equals("opcode")) {
                this.createKeyOpcode(info, cmdParamList);
                continue;
            }
            if (filterKey.equals("cookie")) {
                this.createKeyCookie(info, cmdParamList);
                continue;
            }
            if (filterKey.equals("host")) {
                this.createKeyHost(info, cmdParamList);
                continue;
            }
            if (filterKey.equals("referer")) {
                this.createKeyReferer(info, cmdParamList);
                continue;
            }
            if (filterKey.equals("uri")) {
                this.createKeyUri(info, cmdParamList);
                continue;
            }
            if (filterKey.equals("user-agent")) {
                this.createKeyUserAgent(info, cmdParamList);
                continue;
            }
            if (filterKey.equals("domain")) {
                this.createKeyDomain(info, cmdParamList);
                continue;
            }
            if (filterKey.equals("qr")) {
                this.createKeyQr(info, cmdParamList);
                continue;
            }
            if (filterKey.equals("type")) {
                this.createKeyType(info, cmdParamList);
                continue;
            }
            if (filterKey.equals("caller")) {
                this.createKeyCaller(info, cmdParamList);
                continue;
            }
            if (!filterKey.equals("callee")) continue;
            this.createKeyCallee(info, cmdParamList);
        }
    }

    private void createKeySourceIp(HttpFilterInfo info, List<CmdParam> cmdParamList) {
        CmdParam cmdParam = new CmdParam();
        cmdParam.setCmdID("source-ip");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        String[] content = info.getFilterContent().split("/");
        String ip = content[0];
        String mask = content[1];
        if (IPUtil.isIpv4((String)ip)) {
            paramMap.put("ip", ip);
            paramMap.put("mask", mask);
        } else if (IPUtil.isIpv6((String)ip)) {
            paramMap.put("ipv6", ip);
            paramMap.put("mask", mask);
        }
        cmdParam.setParams(paramMap);
        cmdParamList.add(cmdParam);
    }

    private void createKeyDestinationIp(HttpFilterInfo info, List<CmdParam> cmdParamList) {
        CmdParam cmdParam = new CmdParam();
        cmdParam.setCmdID("destination-ip");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        String[] content = info.getFilterContent().split("/");
        String ip = content[0];
        String mask = content[1];
        if (IPUtil.isIpv4((String)ip)) {
            paramMap.put("ip", ip);
            paramMap.put("mask", mask);
        } else if (IPUtil.isIpv6((String)ip)) {
            paramMap.put("ipv6", ip);
            paramMap.put("mask", mask);
        }
        cmdParam.setParams(paramMap);
        cmdParamList.add(cmdParam);
    }

    private void createKeyPacketLength(HttpFilterInfo info, List<CmdParam> cmdParamList) {
        CmdParam cmdParam = new CmdParam();
        cmdParam.setCmdID("packet-length");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        String[] content = info.getFilterContent().split("~");
        paramMap.put("min", content[0]);
        paramMap.put("max", content[1]);
        cmdParam.setParams(paramMap);
        cmdParamList.add(cmdParam);
    }

    private void createKeyTtl(HttpFilterInfo info, List<CmdParam> cmdParamList) {
        CmdParam cmdParam = new CmdParam();
        cmdParam.setCmdID("ttl");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("ttl", info.getFilterContent());
        cmdParam.setParams(paramMap);
        cmdParamList.add(cmdParam);
    }

    private boolean fingerContentIsV1R1(String content) {
        String regex = "^[0-9a-fA-F]{4}$|^[0-9a-fA-F]{6}$|^[0-9a-fA-F]{8}$|^[0-9a-fA-F]{10}$|^[0-9a-fA-F]{12}$|^[0-9a-fA-F]{14}$|^[0-9a-fA-F]{16}$";
        return content.matches(regex);
    }

    private boolean isSupportedFingerContentSupportVersion(Long deviceId) {
        DeviceTypeInfo devTypeInfo = CmdUtil.getDevTypeInfo(deviceId);
        Set supportAttr = DdosDevCapabilityServiceImpl.getInstance().getAllSupportedAttr(devTypeInfo);
        return supportAttr.contains("isFingerContentSupportVersion");
    }

    private void createKeyProtocol(HttpFilterInfo info, List<CmdParam> cmdParamList) {
        CmdParam cmdParam = new CmdParam();
        cmdParam.setCmdID("protocol");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("protocol", info.getFilterContent());
        cmdParam.setParams(paramMap);
        cmdParamList.add(cmdParam);
    }

    private void createKeyDscp(HttpFilterInfo info, List<CmdParam> cmdParamList) {
        CmdParam cmdParam = new CmdParam();
        cmdParam.setCmdID("dscp");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("dscp", info.getFilterContent());
        cmdParam.setParams(paramMap);
        cmdParamList.add(cmdParam);
    }

    private void createKeyFragment(HttpFilterInfo info, List<CmdParam> cmdParamList) {
        CmdParam cmdParam = new CmdParam();
        cmdParam.setCmdID("fragment");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("fragment", info.getFilterContent());
        cmdParam.setParams(paramMap);
        cmdParamList.add(cmdParam);
    }

    private void createKeyTcpFlag(HttpFilterInfo info, List<CmdParam> cmdParamList) {
        CmdParam cmdParam = new CmdParam();
        cmdParam.setCmdID("tcp-flag");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tcpFlag", info.getFilterContent());
        cmdParam.setParams(paramMap);
        cmdParamList.add(cmdParam);
    }

    private void createKeyDestinationPort(HttpFilterInfo info, List<CmdParam> cmdParamList) {
        CmdParam cmdParam = new CmdParam();
        cmdParam.setCmdID("destination-port");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        String[] content = info.getFilterContent().split("~");
        if (content.length > 1) {
            paramMap.put("port1", content[0]);
            paramMap.put("port2", content[1]);
        } else {
            paramMap.put("port", content[0]);
        }
        cmdParam.setParams(paramMap);
        cmdParamList.add(cmdParam);
    }

    private void createKeySourcePort(HttpFilterInfo info, List<CmdParam> cmdParamList) {
        CmdParam cmdParam = new CmdParam();
        cmdParam.setCmdID("source-port");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        String[] content = info.getFilterContent().split("~");
        if (content.length > 1) {
            paramMap.put("port1", content[0]);
            paramMap.put("port2", content[1]);
        } else {
            paramMap.put("port", content[0]);
        }
        cmdParam.setParams(paramMap);
        cmdParamList.add(cmdParam);
    }

    private void createKeyOpcode(HttpFilterInfo info, List<CmdParam> cmdParamList) {
        CmdParam cmdParam = new CmdParam();
        cmdParam.setCmdID("opcode");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("opcode", info.getFilterContent());
        cmdParam.setParams(paramMap);
        cmdParamList.add(cmdParam);
    }

    private void createKeyCookie(HttpFilterInfo info, List<CmdParam> cmdParamList) {
        CmdParam cmdParam = new CmdParam();
        cmdParam.setCmdID("cookie");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        String[] content = info.getFilterContent().split("    ");
        paramMap.put("operation", content[0]);
        paramMap.put("cookie", this.translateFingerContent(content[1]));
        cmdParam.setParams(paramMap);
        cmdParamList.add(cmdParam);
    }

    private void createKeyHost(HttpFilterInfo info, List<CmdParam> cmdParamList) {
        CmdParam cmdParam = new CmdParam();
        cmdParam.setCmdID("host");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        String[] content = info.getFilterContent().split("    ");
        paramMap.put("operation", content[0]);
        paramMap.put("host", this.translateFingerContent(content[1]));
        cmdParam.setParams(paramMap);
        cmdParamList.add(cmdParam);
    }

    private void createKeyReferer(HttpFilterInfo info, List<CmdParam> cmdParamList) {
        CmdParam cmdParam = new CmdParam();
        cmdParam.setCmdID("referer");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        String[] content = info.getFilterContent().split("    ");
        paramMap.put("operation", content[0]);
        paramMap.put("referer", this.translateFingerContent(content[1]));
        cmdParam.setParams(paramMap);
        cmdParamList.add(cmdParam);
    }

    private void createKeyUri(HttpFilterInfo info, List<CmdParam> cmdParamList) {
        CmdParam cmdParam = new CmdParam();
        cmdParam.setCmdID("uri");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        String[] content = info.getFilterContent().split("    ");
        paramMap.put("operation", content[0]);
        paramMap.put("uri", this.translateFingerContent(content[1]));
        cmdParam.setParams(paramMap);
        cmdParamList.add(cmdParam);
    }

    private void createKeyUserAgent(HttpFilterInfo info, List<CmdParam> cmdParamList) {
        CmdParam cmdParam = new CmdParam();
        cmdParam.setCmdID("user-agent");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        String[] content = info.getFilterContent().split("    ");
        paramMap.put("operation", content[0]);
        paramMap.put("userAgent", this.translateFingerContent(content[1]));
        cmdParam.setParams(paramMap);
        cmdParamList.add(cmdParam);
    }

    private void createKeyDomain(HttpFilterInfo info, List<CmdParam> cmdParamList) {
        CmdParam cmdParam = new CmdParam();
        cmdParam.setCmdID("domain");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        String[] content = info.getFilterContent().split("    ");
        paramMap.put("operation", content[0]);
        paramMap.put("domain", this.translateFingerContent(content[1]));
        cmdParam.setParams(paramMap);
        cmdParamList.add(cmdParam);
    }

    private void createKeyQr(HttpFilterInfo info, List<CmdParam> cmdParamList) {
        CmdParam cmdParam = new CmdParam();
        cmdParam.setCmdID("qr");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("qr", info.getFilterContent());
        cmdParam.setParams(paramMap);
        cmdParamList.add(cmdParam);
    }

    private void createKeyType(HttpFilterInfo info, List<CmdParam> cmdParamList) {
        CmdParam cmdParam = new CmdParam();
        cmdParam.setCmdID("type");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("type", info.getFilterContent());
        cmdParam.setParams(paramMap);
        cmdParamList.add(cmdParam);
    }

    private void createKeyCaller(HttpFilterInfo info, List<CmdParam> cmdParamList) {
        CmdParam cmdParam = new CmdParam();
        cmdParam.setCmdID("caller");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        String[] content = info.getFilterContent().split("    ");
        paramMap.put("operation", content[0]);
        paramMap.put("caller", this.translateFingerContent(content[1]));
        cmdParam.setParams(paramMap);
        cmdParamList.add(cmdParam);
    }

    private void createKeyCallee(HttpFilterInfo info, List<CmdParam> cmdParamList) {
        CmdParam cmdParam = new CmdParam();
        cmdParam.setCmdID("callee");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        String[] content = info.getFilterContent().split("    ");
        paramMap.put("operation", content[0]);
        paramMap.put("callee", this.translateFingerContent(content[1]));
        cmdParam.setParams(paramMap);
        cmdParamList.add(cmdParam);
    }

    public List<String> doUnDeployApplyTranslate(LogicDev logicDev, Object object) {
        List<CmdParam> cmdParamList = this.createGloCmdParamList();
        CommandAPI tool = new CommandAPI();
        String cmdFileDir = CmdDevCapManager.getInstance().getCmdDevCapaFileDir(logicDev.getDeviceId());
        List cmdList = tool.doTranslate(cmdFileDir, "filter", cmdParamList);
        List<String> result = CmdUtil.execCmds(logicDev.getDeviceId(), cmdList);
        return result;
    }

    private List<CmdParam> createGloCmdParamList() {
        ArrayList<CmdParam> cmdParamList = new ArrayList<CmdParam>();
        this.systemViewParam(cmdParamList);
        this.undoApplyFilterParam(cmdParamList);
        return cmdParamList;
    }

    private void undoAllKey(List<CmdParam> cmdParamList) {
        String filterType = this.filterInfo.getFilterType();
        if (filterType.equals("IP")) {
            this.undoKey(cmdParamList, "source-ip");
            this.undoKey(cmdParamList, "destination-ip");
            this.undoKey(cmdParamList, "packet-length");
            this.undoKey(cmdParamList, "ttl");
            this.undoKey(cmdParamList, "fingerprint");
            this.undoKey(cmdParamList, "protocol");
            this.undoKey(cmdParamList, "dscp");
            this.undoKeyFragmentAll(cmdParamList);
        } else if (filterType.equals("TCP")) {
            this.undoKey(cmdParamList, "source-ip");
            this.undoKey(cmdParamList, "destination-ip");
            this.undoKey(cmdParamList, "packet-length");
            this.undoKey(cmdParamList, "ttl");
            this.undoKey(cmdParamList, "fingerprint");
            this.undoKey(cmdParamList, "dscp");
            this.undoKey(cmdParamList, "tcp-flag");
            this.undoKey(cmdParamList, "destination-port");
            this.undoKey(cmdParamList, "source-port");
            this.undoKeyFragmentAll(cmdParamList);
        } else if (filterType.equals("UDP")) {
            this.undoKey(cmdParamList, "source-ip");
            this.undoKey(cmdParamList, "destination-ip");
            this.undoKey(cmdParamList, "packet-length");
            this.undoKey(cmdParamList, "ttl");
            this.undoKey(cmdParamList, "fingerprint");
            this.undoKey(cmdParamList, "dscp");
            this.undoKey(cmdParamList, "destination-port");
            this.undoKey(cmdParamList, "source-port");
            this.undoKeyFragmentAll(cmdParamList);
        } else if (filterType.equals("ICMP")) {
            this.undoKey(cmdParamList, "source-ip");
            this.undoKey(cmdParamList, "destination-ip");
            this.undoKey(cmdParamList, "packet-length");
            this.undoKey(cmdParamList, "ttl");
            this.undoKey(cmdParamList, "fingerprint");
            this.undoKey(cmdParamList, "dscp");
            this.undoKeyFragmentAll(cmdParamList);
        } else if (filterType.equals("HTTP")) {
            this.undoKey(cmdParamList, "source-ip");
            this.undoKey(cmdParamList, "destination-ip");
            this.undoKey(cmdParamList, "packet-length");
            this.undoKey(cmdParamList, "ttl");
            this.undoKey(cmdParamList, "fingerprint");
            this.undoKey(cmdParamList, "dscp");
            this.undoKeyFragmentAll(cmdParamList);
            this.undoKey(cmdParamList, "tcp-flag");
            this.undoKey(cmdParamList, "source-port");
            this.undoKeyOpcodeAll(cmdParamList);
            this.undoKey(cmdParamList, "cookie");
            this.undoKey(cmdParamList, "host");
            this.undoKey(cmdParamList, "referer");
            this.undoKey(cmdParamList, "uri");
            this.undoKey(cmdParamList, "user-agent");
        } else if (filterType.equals("DNS")) {
            this.undoKey(cmdParamList, "source-ip");
            this.undoKey(cmdParamList, "destination-ip");
            this.undoKey(cmdParamList, "packet-length");
            this.undoKey(cmdParamList, "ttl");
            this.undoKey(cmdParamList, "fingerprint");
            this.undoKey(cmdParamList, "dscp");
            this.undoKeyFragmentAll(cmdParamList);
            this.undoKey(cmdParamList, "source-port");
            this.undoKeyQrAll(cmdParamList);
            this.undoKey(cmdParamList, "domain");
            this.undoKey(cmdParamList, "type");
        } else if (filterType.equals("SIP")) {
            this.undoKey(cmdParamList, "source-ip");
            this.undoKey(cmdParamList, "destination-ip");
            this.undoKey(cmdParamList, "packet-length");
            this.undoKey(cmdParamList, "ttl");
            this.undoKey(cmdParamList, "fingerprint");
            this.undoKey(cmdParamList, "dscp");
            this.undoKeyFragmentAll(cmdParamList);
            this.undoKey(cmdParamList, "source-port");
            this.undoKey(cmdParamList, "caller");
            this.undoKey(cmdParamList, "callee");
        }
    }

    private void undoKey(List<CmdParam> cmdParamList, String key) {
        CmdParam cmdParam = new CmdParam();
        cmdParam.setCmdID(key);
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("undo", "undo");
        paramMap.put("all", "all");
        cmdParam.setParams(paramMap);
        cmdParamList.add(cmdParam);
    }

    private void undoKeyFragmentAll(List<CmdParam> cmdParamList) {
        this.undoKeyFragment(cmdParamList, "donot");
        this.undoKeyFragment(cmdParamList, "first");
        this.undoKeyFragment(cmdParamList, "last");
        this.undoKeyFragment(cmdParamList, "middle");
        this.undoKeyFragment(cmdParamList, "non");
    }

    private void undoKeyFragment(List<CmdParam> cmdParamList, String value) {
        CmdParam cmdParam = new CmdParam();
        cmdParam.setCmdID("fragment");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("undo", "undo");
        paramMap.put("fragment", value);
        cmdParam.setParams(paramMap);
        cmdParamList.add(cmdParam);
    }

    private void undoKeyOpcodeAll(List<CmdParam> cmdParamList) {
        this.undoKeyOpcode(cmdParamList, "get");
        this.undoKeyOpcode(cmdParamList, "post");
        this.undoKeyOpcode(cmdParamList, "put");
        this.undoKeyOpcode(cmdParamList, "head");
        this.undoKeyOpcode(cmdParamList, "delete");
        this.undoKeyOpcode(cmdParamList, "options");
        this.undoKeyOpcode(cmdParamList, "trace");
        this.undoKeyOpcode(cmdParamList, "connect");
    }

    private void undoKeyOpcode(List<CmdParam> cmdParamList, String value) {
        CmdParam cmdParam = new CmdParam();
        cmdParam.setCmdID("opcode");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("undo", "undo");
        paramMap.put("opcode", value);
        cmdParam.setParams(paramMap);
        cmdParamList.add(cmdParam);
    }

    private void undoKeyQrAll(List<CmdParam> cmdParamList) {
        this.undoKeyQr(cmdParamList, "query");
        this.undoKeyQr(cmdParamList, "reply");
    }

    private void undoKeyQr(List<CmdParam> cmdParamList, String value) {
        CmdParam cmdParam = new CmdParam();
        cmdParam.setCmdID("qr");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("undo", "undo");
        paramMap.put("qr", value);
        cmdParam.setParams(paramMap);
        cmdParamList.add(cmdParam);
    }

    private void undoApplyFilterParam(List<CmdParam> cmdParamList) {
        CmdParam cmdParam = new CmdParam();
        cmdParam.setCmdID("apply");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("undo", "undo");
        paramMap.put("name", this.filterInfo.getFilterName());
        cmdParam.setParams(paramMap);
        cmdParamList.add(cmdParam);
    }

    @Override
    public Object doDiscover(LogicDev logicDev, Object object) {
        return null;
    }

    @Override
    public Object doUndeploy(LogicDev logicDev, Object object) {
        List<String> cmdList = this.doUnDeployTranslate(logicDev, false);
        this.logger.info((Object)("undeploy filter, filter id : " + this.filterInfo.getPkid() + ", device id : " + logicDev.getDeviceId() + " cmd list :" + this.getcleanedMessage(cmdList.toString())));
        List<String> result = CmdUtil.execCmds(logicDev.getDeviceId(), cmdList);
        this.logger.info((Object)("undeploy filter, filter id : " + this.filterInfo.getPkid() + ", device id : " + logicDev.getDeviceId() + " result list :" + this.getcleanedMessage(result.toString())));
        return result;
    }

    private List<String> doUnDeployTranslate(LogicDev logicDev, boolean isDeploy) {
        return this.doDeployTranslate(logicDev, false);
    }

    @Override
    public Object doVerify(LogicDev logicDev, Object object) {
        return null;
    }

    @Override
    public Map<String, List<Long>> getDependFeatureID(List<IFeature> featureDataList) {
        return null;
    }

    @Override
    public Map<String, List<Long>> getDependFeatureID(Long featureID) {
        return null;
    }

    @Override
    public IFeature getFeature(Long featureID) {
        return null;
    }

    @Override
    public List<IFeature> getFeature(List<Long> featureIDList) {
        return null;
    }

    @Override
    public IFeature getTopFeatureData() {
        return null;
    }

    public FilterInfo getFilterInfo() {
        return this.filterInfo;
    }

    public void setFilterInfo(FilterInfo filterInfo) {
        this.filterInfo = filterInfo;
    }

    public List<HttpFilterInfo> getFilterPolicyInfoList() {
        return this.filterPolicyInfoList;
    }

    public void setFilterPolicyInfoList(List<HttpFilterInfo> filterPolicyInfoList) {
        this.filterPolicyInfoList = filterPolicyInfoList;
    }
}

