/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.service.data.feature;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.secservice.ddos.common.CmdUtil;
import com.hs.vsm.secservice.ddos.service.function.Util;
import com.hs.vsm.secservice.sdk.common.util.VsmUtil;
import com.hs.vsm.secservice.sdk.frame.model.AbstractFeature;
import com.hs.vsm.secservice.sdk.frame.model.CmdViewBean;
import com.hs.vsm.secservice.sdk.frame.model.IFeature;
import com.hs.vsm.secservice.sdk.frame.model.LogicDev;
import com.hs.vsm.secservice.sdk.module.ddos.Constant;
import com.huawei.atic.secne.adapter.capability.model.DeviceTypeInfo;
import com.huawei.atic.secne.adapter.frame.service.CmdDevCapManager;
import com.huawei.atic.secservice.ddos.service.impl.DdosDevCapabilityServiceImpl;
import com.huawei.atic.secservice.policyengine.command.CommandAPI;
import com.huawei.atic.secservice.policyengine.commandutil.CmdParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class ServiceHttpsDefendData
extends AbstractFeature
implements Serializable {
    private static final long serialVersionUID = -3274107996287508313L;
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);

    public ServiceHttpsDefendData() {
    }

    public ServiceHttpsDefendData(Object obj, String featureType, Long featureId) {
        this.setConfigData(obj);
        this.setFeatureType(featureType);
        this.setFeatureId(featureId);
    }

    @Override
    public Object doAudit(LogicDev logicDev, Object object) {
        return null;
    }

    @Override
    public Object doDeploy(LogicDev logicDev, Object object) {
        List<String> cmds = this.doTranslate(logicDev.getDeviceId());
        this.logger.info((Object)("device : " + logicDev.getDeviceId() + "to deploy cmds:" + this.getcleanedMessage(cmds.toString())));
        this.setCmds(cmds);
        List<String> result = CmdUtil.execCmds(logicDev.getDeviceId(), cmds);
        this.clearResult(result);
        this.logger.info((Object)("deploy result:" + this.getcleanedMessage(result.toString())));
        return result;
    }

    private void clearResult(List<String> result) {
        if (!result.toString().toLowerCase(Locale.ENGLISH).contains("error")) {
            return;
        }
        int num = result.size();
        String error = "";
        for (int j = 1; j < num; ++j) {
            error = result.get(j).toLowerCase(Locale.ENGLISH);
            if (error.contains("error") && error.contains("undo ") && (error.contains("anti-ddos https-flood ssl-decrypt") || error.contains("anti-ddos https-flood ssl-decrypt code-check") || error.contains("anti-ddos https-flood ssl-decrypt fingerprint-learn"))) {
                result.remove(j);
                result.add(j, "sslClearn");
                continue;
            }
            if (error.contains("error-number")) {
                result.remove(j);
                error = error.replace("error-number", "sslClearn");
                result.add(j, error);
            }
            if (error.contains("code-check  error")) {
                result.remove(j);
                error = error.replace("code-check  error", "code-check  sslClearn");
                result.add(j, error);
            }
            if (!error.contains("error") || !error.contains("anti-ddos https-flood ssl-decrypt") && !error.contains("anti-ddos https-flood ssl-decrypt code-check") && !error.contains("anti-ddos https-flood ssl-decrypt fingerprint-learn")) continue;
            result.add("lego.err.632003");
            break;
        }
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private boolean isDefaultService(int viewSize) {
        return viewSize == 2;
    }

    private List<String> doTranslate(Long moId) {
        List cmds = null;
        HashMap<String, String> undoMap = new HashMap<String, String>();
        undoMap.put("undo", "undo");
        ArrayList<CmdParam> cmdParams = new ArrayList<CmdParam>();
        List<CmdViewBean> viewList = this.getCmdViewList();
        Util.getInstance().addView(viewList, cmdParams);
        boolean isDefaultService = this.isDefaultService(viewList.size());
        DdosDevCapabilityServiceImpl devCapabilityService = DdosDevCapabilityServiceImpl.getInstance();
        DeviceTypeInfo devTypeInfo = CmdUtil.getDevTypeInfo(moId);
        Set supportAttrs = devCapabilityService.getAllSupportedAttr(devTypeInfo);
        Map<String, String> params = VsmUtil.getInstance().getObjectFieldAndValues(this.getConfigData());
        Integer sslDecryption = CmdUtil.querySslDecryption(moId);
        if (viewList.size() == Constant.CUSTOM_SERVICE_WITH_SERVICE_VIEW_SIZE.intValue()) {
            this.translateBlockCommand(params, undoMap, cmdParams);
            this.translateLimitCommand(params, undoMap, cmdParams);
        }
        this.undoHttpsDefend(undoMap, cmdParams, isDefaultService, supportAttrs, sslDecryption);
        if ((null == sslDecryption || 0 == sslDecryption) && supportAttrs.contains("httpsDecryptEnable")) {
            supportAttrs.remove("httpsDecryptEnable");
        }
        this.translateHttpsDefend(params, cmdParams, supportAttrs);
        CommandAPI tool = new CommandAPI();
        String cmdFileDir = CmdDevCapManager.getInstance().getCmdDevCapaFileDir(moId);
        cmds = tool.doTranslate(cmdFileDir, "https_defend", cmdParams);
        return cmds;
    }

    private void translateLimitCommand(Map<String, String> params, Map<String, String> undoMap, List<CmdParam> cmdParams) {
        if ("true".equals(params.get("limitEnable"))) {
            CmdParam cmdParam1d = new CmdParam();
            cmdParam1d.setCmdID("httpsLimit");
            cmdParam1d.setParams(params);
            cmdParams.add(cmdParam1d);
        } else {
            CmdParam cmdParam2d = new CmdParam();
            cmdParam2d.setCmdID("httpsLimit");
            cmdParam2d.setParams(undoMap);
            cmdParams.add(cmdParam2d);
        }
    }

    private void translateBlockCommand(Map<String, String> params, Map<String, String> undoMap, List<CmdParam> cmdParams) {
        if ("true".equals(params.get("httpsBlock"))) {
            CmdParam cmdParam1d = new CmdParam();
            cmdParam1d.setCmdID("serviceDrop");
            cmdParams.add(cmdParam1d);
        } else {
            CmdParam cmdParam2d = new CmdParam();
            cmdParam2d.setCmdID("serviceDrop");
            cmdParam2d.setParams(undoMap);
            cmdParams.add(cmdParam2d);
        }
    }

    private void translateHttpsDefend(Map<String, String> params, List<CmdParam> cmdParams, Set<String> supportAttrs) {
        if ("true".equals(params.get("httpsDefendEnable")) && "true".equals(params.get("httpsSrcEnable"))) {
            CmdParam cmdParamNego;
            CmdParam cmdParam0d = new CmdParam();
            cmdParam0d.setCmdID("httpsAlertRate");
            cmdParam0d.setParams(params);
            cmdParams.add(cmdParam0d);
            if ("true".equals(params.get("httpsSslEnable"))) {
                if ("true".equals(params.get("httpsNegoCheckEnable"))) {
                    cmdParamNego = new CmdParam();
                    cmdParamNego.setCmdID("httpsNego");
                    cmdParamNego.setParams(params);
                    cmdParams.add(cmdParamNego);
                }
                if ("true".equals(params.get("httpsNegoCheckEnable")) || "true".equals(params.get("httpsSessionCheckEnable"))) {
                    CmdParam cmdParamIll = new CmdParam();
                    cmdParamIll.setCmdID("httpsIll");
                    cmdParamIll.setParams(params);
                    cmdParams.add(cmdParamIll);
                }
                if ("true".equals(params.get("httpsSessionCheckEnable"))) {
                    CmdParam cmdParamSession = new CmdParam();
                    cmdParamSession.setCmdID("httpsSessionCheckEnable");
                    cmdParamSession.setParams(params);
                    cmdParams.add(cmdParamSession);
                }
            }
            if (supportAttrs.contains("httpsDecryptEnable") && "true".equals(params.get("httpsDecryptEnable"))) {
                CmdParam cmdParamCode;
                cmdParamNego = new CmdParam();
                cmdParamNego.setCmdID("httpsDecryptAlert");
                cmdParamNego.setParams(params);
                cmdParams.add(cmdParamNego);
                if ("true".equals(params.get("serverCodeEnable"))) {
                    cmdParamCode = new CmdParam();
                    cmdParamCode.setCmdID("httpsserverCode");
                    cmdParamCode.setParams(params);
                    cmdParams.add(cmdParamCode);
                }
                if ("true".equals(params.get("httpsFingerLearnEnable"))) {
                    cmdParamCode = new CmdParam();
                    cmdParamCode.setCmdID("httpsFingerLearn");
                    cmdParamCode.setParams(params);
                    cmdParams.add(cmdParamCode);
                }
            }
            if ("true".equals(params.get("httpsSrcStaticEnable"))) {
                CmdParam cmdParamSrcStatic = new CmdParam();
                cmdParamSrcStatic.setCmdID("httpsSrcStatic");
                cmdParamSrcStatic.setParams(params);
                cmdParams.add(cmdParamSrcStatic);
                if (supportAttrs.contains("httpsSrcStaticModeEnable")) {
                    this.defendModeAdapter(params);
                    CmdParam httpsSrcStaticMode = new CmdParam();
                    httpsSrcStaticMode.setCmdID("httpsSrcStaticMode");
                    httpsSrcStaticMode.setParams(params);
                    cmdParams.add(httpsSrcStaticMode);
                }
            }
        }
    }

    private void defendModeAdapter(Map<String, String> params) {
        if (params.get("httpsSrcMode") != null) {
            if (Constant.HTTP_FLOOD_DEFENDMODE_BASIC.equals(Integer.valueOf(params.get("httpsSrcMode")))) {
                params.put("httpsSrcMode", "basic");
            } else if (Constant.HTTP_FLOOD_DEFENDMODE_STRENGTHEN.equals(Integer.valueOf(params.get("httpsSrcMode")))) {
                params.put("httpsSrcMode", "advanced");
            }
        }
    }

    private void undoHttpsDefend(Map<String, String> undoMap, List<CmdParam> cmdParams, boolean isDefaultService, Set<String> supportAttrs, Integer sslDecryption) {
        CmdParam cmdParam0 = new CmdParam();
        cmdParam0.setCmdID("httpsAlertRate");
        cmdParam0.setParams(undoMap);
        cmdParams.add(cmdParam0);
        if (null != sslDecryption) {
            CmdParam cmdSsl1 = new CmdParam();
            cmdSsl1.setCmdID("httpsDecryptAlert");
            cmdSsl1.setParams(undoMap);
            cmdParams.add(cmdSsl1);
            CmdParam cmdSsl2 = new CmdParam();
            cmdSsl2.setCmdID("httpsserverCode");
            cmdSsl2.setParams(undoMap);
            cmdParams.add(cmdSsl2);
            CmdParam cmdSsl3 = new CmdParam();
            cmdSsl3.setCmdID("httpsFingerLearn");
            cmdSsl3.setParams(undoMap);
            cmdParams.add(cmdSsl3);
        }
        CmdParam undoCmdParamNego = new CmdParam();
        undoCmdParamNego.setCmdID("httpsNego");
        undoCmdParamNego.setParams(undoMap);
        cmdParams.add(undoCmdParamNego);
        CmdParam undoCmdParamIll = new CmdParam();
        undoCmdParamIll.setCmdID("httpsIll");
        undoCmdParamIll.setParams(undoMap);
        cmdParams.add(undoCmdParamIll);
        CmdParam undoCmdParamSession = new CmdParam();
        undoCmdParamSession.setCmdID("httpsSessionCheckEnable");
        undoCmdParamSession.setParams(undoMap);
        cmdParams.add(undoCmdParamSession);
        if (isDefaultService) {
            CmdParam undoCmdSrcStatic = new CmdParam();
            undoCmdSrcStatic.setCmdID("httpsSrcStatic");
            undoCmdSrcStatic.setParams(undoMap);
            cmdParams.add(undoCmdSrcStatic);
            if (supportAttrs.contains("httpsSrcStaticModeEnable")) {
                CmdParam undoSrcStaticMode = new CmdParam();
                undoSrcStaticMode.setCmdID("httpsSrcStaticMode");
                undoSrcStaticMode.setParams(undoMap);
                cmdParams.add(undoSrcStaticMode);
            }
        }
    }

    @Override
    public Object doDiscover(LogicDev logicDev, Object object) {
        return null;
    }

    @Override
    public Object doUndeploy(LogicDev logicDev, Object object) {
        return null;
    }

    @Override
    public Object doVerify(LogicDev logicDev, Object object) {
        return null;
    }

    @Override
    public Map<String, List<Long>> getDependFeatureID(List<IFeature> featureDataList) {
        return null;
    }

    @Override
    public Map<String, List<Long>> getDependFeatureID(Long featureID) {
        return null;
    }

    @Override
    public IFeature getFeature(Long featureID) {
        return null;
    }

    @Override
    public List<IFeature> getFeature(List<Long> featureIDList) {
        return null;
    }

    @Override
    public IFeature getTopFeatureData() {
        return null;
    }
}

