/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.service.data.feature;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.vsm.secservice.ddos.common.CmdUtil;
import com.hs.vsm.secservice.ddos.service.function.Util;
import com.hs.vsm.secservice.sdk.common.util.VsmUtil;
import com.hs.vsm.secservice.sdk.frame.model.AbstractFeature;
import com.hs.vsm.secservice.sdk.frame.model.CmdViewBean;
import com.hs.vsm.secservice.sdk.frame.model.IFeature;
import com.hs.vsm.secservice.sdk.frame.model.LogicDev;
import com.hs.vsm.secservice.sdk.module.ddos.Constant;
import com.hs.vsm.secservice.sdk.module.ddos.form.SipDefendPolicyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.SipSrcIpLimitForm;
import com.huawei.atic.secne.adapter.frame.service.CmdDevCapManager;
import com.huawei.atic.secservice.policyengine.command.CommandAPI;
import com.huawei.atic.secservice.policyengine.commandutil.CmdParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ServiceSipDefendData
extends AbstractFeature
implements Serializable {
    private static final long serialVersionUID = 6167521068768878648L;
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);

    public ServiceSipDefendData() {
    }

    public ServiceSipDefendData(Object obj, String featureType, Long featureId) {
        this.setConfigData(obj);
        this.setFeatureType(featureType);
        this.setFeatureId(featureId);
    }

    @Override
    public Object doAudit(LogicDev logicDev, Object object) {
        return null;
    }

    @Override
    public Object doDeploy(LogicDev logicDev, Object object) {
        List<String> cmds = this.doTranslate(logicDev.getDeviceId());
        this.logger.info((Object)("device : " + logicDev.getDeviceId() + "to deploy cmds:" + this.getcleanedMessage(cmds.toString())));
        this.setCmds(cmds);
        List<String> result = CmdUtil.execCmds(logicDev.getDeviceId(), cmds);
        this.logger.info((Object)("deploy result:" + this.getcleanedMessage(result.toString())));
        return result;
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private List<String> doTranslate(Long moId) {
        List cmds = null;
        HashMap<String, String> undoMap = new HashMap<String, String>();
        undoMap.put("undo", "undo");
        ArrayList<CmdParam> cmdParams = new ArrayList<CmdParam>();
        List<CmdViewBean> viewList = this.getCmdViewList();
        Util.getInstance().addView(viewList, cmdParams);
        SipDefendPolicyForm sipPolicyForm = (SipDefendPolicyForm)this.getConfigData();
        boolean isSipView = viewList.size() == Constant.CUSTOM_SERVICE_WITH_SERVICE_VIEW_SIZE.intValue();
        Map<String, String> params = VsmUtil.getInstance().getObjectFieldAndValues(this.getConfigData());
        List<SipSrcIpLimitForm> sipSrcIpForms = sipPolicyForm.getSipSrcLimitForms();
        if (isSipView) {
            CmdParam cmdParam1 = new CmdParam();
            cmdParam1.setCmdID("sipServiceDrop");
            cmdParam1.setParams(undoMap);
            cmdParams.add(cmdParam1);
            CmdParam cmdParam2 = new CmdParam();
            cmdParam2.setCmdID("sipLimit");
            cmdParam2.setParams(undoMap);
            cmdParams.add(cmdParam2);
            CmdParam cmdParam0 = new CmdParam();
            cmdParam0.setCmdID("sipAlertRate");
            cmdParam0.setParams(undoMap);
            cmdParams.add(cmdParam0);
            if ("true".equals(params.get("sipBlock"))) {
                CmdParam cmdParam1D = new CmdParam();
                cmdParam1D.setCmdID("sipServiceDrop");
                cmdParam1D.setParams(params);
                cmdParams.add(cmdParam1D);
            }
            if ("true".equals(params.get("limitEnable"))) {
                CmdParam cmdParam2D = new CmdParam();
                cmdParam2D.setCmdID("sipLimit");
                cmdParam2D.setParams(params);
                cmdParams.add(cmdParam2D);
            }
            if ("true".equals(params.get("sipDefendEnable")) && "true".equals(params.get("sipSrcDetectEnable"))) {
                CmdParam cmdParam0D = new CmdParam();
                cmdParam0D.setCmdID("sipAlertRate");
                cmdParam0D.setParams(params);
                cmdParams.add(cmdParam0D);
            }
        } else {
            this.transUndoCmd(cmdParams, undoMap);
            this.transDepCmd(cmdParams, params, sipSrcIpForms);
        }
        CommandAPI tool = new CommandAPI();
        String cmdFileDir = CmdDevCapManager.getInstance().getCmdDevCapaFileDir(moId);
        cmds = tool.doTranslate(cmdFileDir, "sip_defend", cmdParams);
        return cmds;
    }

    private void transDepCmd(List<CmdParam> cmdParams, Map<String, String> params, List<SipSrcIpLimitForm> sipSrcIpForms) {
        if ("true".equals(params.get("sipDefendEnable"))) {
            CmdParam cmdParam0D;
            if ("true".equals(params.get("sipSrcDetectEnable"))) {
                cmdParam0D = new CmdParam();
                cmdParam0D.setCmdID("sipAlertRate");
                cmdParam0D.setParams(params);
                cmdParams.add(cmdParam0D);
            }
            if ("true".equals(params.get("sipSrcOtherLimitEnable"))) {
                if (String.valueOf(Constant.SOURCE_OTHER_LIMIT_MODE_ON).equals(params.get("sipSrcOtherLimitMode"))) {
                    params.put("sipSrcOtherLimitMode", "on");
                } else {
                    params.put("sipSrcOtherLimitMode", "auto");
                }
                cmdParam0D = new CmdParam();
                cmdParam0D.setCmdID("sipSrcOtherLimit");
                cmdParam0D.setParams(params);
                cmdParams.add(cmdParam0D);
            }
            if ("true".equals(params.get("sipSrcIpLimitEnable"))) {
                for (SipSrcIpLimitForm each : sipSrcIpForms) {
                    CmdParam cmdParam9D;
                    Map<String, String> ipResponseParams = VsmUtil.getInstance().getObjectFieldAndValues(each);
                    if (IPUtil.isIpv6((String)each.getSourceIp())) {
                        cmdParam9D = new CmdParam();
                        cmdParam9D.setCmdID("sipSrcIpV6Limit");
                        cmdParam9D.setParams(ipResponseParams);
                        cmdParams.add(cmdParam9D);
                        continue;
                    }
                    cmdParam9D = new CmdParam();
                    cmdParam9D.setCmdID("sipSrcIpV4Limit");
                    cmdParam9D.setParams(ipResponseParams);
                    cmdParams.add(cmdParam9D);
                }
            }
        }
    }

    private void transUndoCmd(List<CmdParam> cmdParams, Map<String, String> undoMap) {
        CmdParam cmdParam0 = new CmdParam();
        cmdParam0.setCmdID("sipAlertRate");
        cmdParam0.setParams(undoMap);
        cmdParams.add(cmdParam0);
        CmdParam cmdParam1 = new CmdParam();
        cmdParam1.setCmdID("undoAllSipSrcIpLimit");
        cmdParam1.setParams(undoMap);
        cmdParams.add(cmdParam1);
    }

    @Override
    public Object doDiscover(LogicDev logicDev, Object object) {
        return null;
    }

    @Override
    public Object doUndeploy(LogicDev logicDev, Object object) {
        return null;
    }

    @Override
    public Object doVerify(LogicDev logicDev, Object object) {
        return null;
    }

    @Override
    public Map<String, List<Long>> getDependFeatureID(List<IFeature> featureDataList) {
        return null;
    }

    @Override
    public Map<String, List<Long>> getDependFeatureID(Long featureID) {
        return null;
    }

    @Override
    public IFeature getFeature(Long featureID) {
        return null;
    }

    @Override
    public List<IFeature> getFeature(List<Long> featureIDList) {
        return null;
    }

    @Override
    public IFeature getTopFeatureData() {
        return null;
    }
}

