/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.service.data.feature;

import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.lego.core.system.syslog.sdk.model.SysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.ISysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.SysoplogLevel;
import com.hs.lego.ui.plat.user.util.ArrayDeepClone;
import com.hs.vsm.secservice.ddos.common.CmdUtil;
import com.hs.vsm.secservice.ddos.policy.ref.ZoneReferUtil;
import com.hs.vsm.secservice.ddos.service.function.Util;
import com.hs.vsm.secservice.sdk.frame.model.AbstractFeature;
import com.hs.vsm.secservice.sdk.frame.model.CmdViewBean;
import com.hs.vsm.secservice.sdk.frame.model.IFeature;
import com.hs.vsm.secservice.sdk.frame.model.LogicDev;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneBlackWhiteForm;
import com.hs.vsm.secservice.sdk.module.ddos.service.IBlackWhiteListService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.adapter.frame.service.CmdDevCapManager;
import com.huawei.atic.secservice.policyengine.command.CommandAPI;
import com.huawei.atic.secservice.policyengine.commandutil.CmdParam;
import com.huawei.atic.util.CapaUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;

public class ZoneBlackWhiteListData
extends AbstractFeature
implements Serializable {
    private static final int BATCH_SIZE = 1000;
    private static final int REPEATED_TIMES = 3;
    private static final int LOG_BLACK_CMD_SUCCESS = 1;
    private static final int LOG_BLACK_CMD_FAILED = 0;
    private static final String DDOS_POLICY_BLACK_OPERATION = "com.hs.vsm.secservice.ddos.policy.black.operation";
    private static final String DDOS_POLICY_MODULE = "com.hs.vsm.secservice.ddos.policy.module";
    private static final String DDOS_POLICY_BLACK_LOG_DETAILS = "com.hs.vsm.secservice.ddos.policy.black.log.details";
    private static final String ERROR_CONFIGURATION = "error:";
    private static final long serialVersionUID = -8918274995893353825L;
    private static ReentrantLock lock = new ReentrantLock();
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private List<ZoneBlackWhiteForm> list;
    private List<ZoneBlackWhiteForm> zoneBlackWhiteFormList = new ArrayList<ZoneBlackWhiteForm>();
    private List<ZoneBlackWhiteForm> undoZoneBlackWhiteFormList = new ArrayList<ZoneBlackWhiteForm>();
    private List<ZoneBlackWhiteForm> resultZoneBlackFormList = new ArrayList<ZoneBlackWhiteForm>(1000);
    private List<ZoneBlackWhiteForm> resultUndoZoneBlackFormList = new ArrayList<ZoneBlackWhiteForm>(1000);
    private Set<String> doCmdSuccessList = new HashSet<String>();
    private Set<String> doCmdFailedList = new HashSet<String>();
    private Set<String> undoCmdSuccessList = new HashSet<String>();
    private Set<String> undoCmdFailedList = new HashSet<String>();

    public ZoneBlackWhiteListData(List<ZoneBlackWhiteForm> list, String featureType, Long featureId) {
        this.setList(list);
        this.setFeatureType(featureType);
        this.setFeatureId(featureId);
    }

    @Override
    public Object doAudit(LogicDev logicDev, Object object) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object doDeploy(LogicDev logicDev, Object object) {
        ArrayList<String> result = new ArrayList<String>();
        lock.lock();
        try {
            Long deviceId = logicDev.getDeviceId();
            this.getDozoneBlackWhiteFormList(deviceId);
            this.getUndozoneBlackWhiteFormList(deviceId);
            this.undoZoneBlackWhiteFormList(deviceId, result);
            this.doCmdZoneBlackFormList(deviceId, result);
            this.recordSystemLog(deviceId);
            this.logger.info((Object)("deploy ZoneWhiteListData result:" + this.getcleanedMessage(((Object)result).toString())));
        }
        finally {
            lock.unlock();
        }
        return result;
    }

    private void doCmdZoneBlackFormList(Long deviceId, List<String> result) {
        while (this.zoneBlackWhiteFormList.size() > 0) {
            if (this.zoneBlackWhiteFormList.size() > 1000) {
                this.resultZoneBlackFormList.addAll(this.zoneBlackWhiteFormList.subList(0, 1000));
                this.zoneBlackWhiteFormList.subList(0, 1000).clear();
            } else {
                this.resultZoneBlackFormList.addAll(this.zoneBlackWhiteFormList);
                this.zoneBlackWhiteFormList.clear();
            }
            boolean saveResult = false;
            List<Object> cmdsResult = new ArrayList();
            int zoneBlackWhiteListSize = this.resultZoneBlackFormList.size();
            for (int i = 0; i < zoneBlackWhiteListSize; ++i) {
                ZoneBlackWhiteForm zoneBlackWhiteForm = this.resultZoneBlackFormList.get(i);
                zoneBlackWhiteForm.setDeviceId(deviceId);
                saveResult = false;
                for (int j = 0; j < 3 && !saveResult; ++j) {
                    List<String> cmds = this.doResultTranslate(zoneBlackWhiteForm);
                    this.logger.info((Object)("zoneBlackWhiteFormList cmds: " + cmds.toString() + "; " + zoneBlackWhiteForm.toString()));
                    this.setCmds(cmds);
                    cmdsResult = CmdUtil.execCmds(deviceId, cmds);
                    this.logger.info((Object)("zoneBlackWhiteFormList cmdsResult: " + cmdsResult.toString()));
                    saveResult = this.saveZoneBlackStatus(zoneBlackWhiteForm, cmdsResult);
                    try {
                        if (saveResult) continue;
                        Thread.sleep(2000L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        this.logger.error((Object)("Deploy zone blacklist (do... ),failed to deploy and need retry, Failed times = " + (i + 1) + "; reason: " + cmdsResult.toString()));
                    }
                }
                if (saveResult) {
                    this.doCmdSuccessList.add(zoneBlackWhiteForm.getIpAddressAndMask());
                } else {
                    StringBuilder errorMsgKey = new StringBuilder("");
                    errorMsgKey.append(zoneBlackWhiteForm.getIpAddressAndMask()).append(" ");
                    for (String string : cmdsResult) {
                        String returnInfo = string.toLowerCase(Locale.ENGLISH);
                        if (!returnInfo.contains(ERROR_CONFIGURATION)) continue;
                        String cmdRest = returnInfo.split("\\r\\n")[1];
                        errorMsgKey.append(cmdRest.substring(cmdRest.indexOf(":") + 1)).append(" ");
                    }
                    this.logger.info((Object)("zoneBlackWhiteFormList errorMsgKey: " + errorMsgKey.toString()));
                    this.doCmdFailedList.add(errorMsgKey.toString());
                }
                result.addAll(cmdsResult);
            }
            this.resultZoneBlackFormList.clear();
        }
    }

    private boolean saveZoneBlackStatus(ZoneBlackWhiteForm zoneBlackWhiteForm, List<String> result) {
        int errorCode = AticUtil.cmdResult(result);
        if (errorCode == 1 || errorCode == 572220) {
            IBlackWhiteListService blackWhiteListService = ZoneReferUtil.getBlackWhiteListService();
            blackWhiteListService.singleSaveDoDeployStatus(zoneBlackWhiteForm, "SUCCESS");
            int cmdSize = result.size();
            for (int i = 0; i < cmdSize && errorCode == 572220; ++i) {
                String cmdResultLowcase = result.get(i).toLowerCase(Locale.ENGLISH);
                if (!cmdResultLowcase.contains("Error: The specified item has already existed.".toLowerCase(Locale.ENGLISH))) continue;
                this.logger.info((Object)("do deploy cmdResultLowcase result:" + this.getcleanedMessage(cmdResultLowcase)));
                result.set(i, "Info: The specified item has already existed.");
            }
        } else {
            return false;
        }
        return true;
    }

    private List<String> doResultTranslate(ZoneBlackWhiteForm zoneBlackWhiteForm) {
        List cmds = null;
        ArrayList<CmdParam> cmdParams = new ArrayList<CmdParam>();
        List<CmdViewBean> viewList = this.getCmdViewList();
        Util.getInstance().addView(viewList, cmdParams);
        CmdParam cmdParam = new CmdParam();
        HashMap<String, String> params = new HashMap<String, String>();
        if (zoneBlackWhiteForm.getBlackWhiteType() == 1) {
            if (IPUtil.isIpv4((String)zoneBlackWhiteForm.getIpAddress())) {
                cmdParam.setCmdID("zoneBlackListIpv4");
                params.put("ipAddress", zoneBlackWhiteForm.getIpAddress());
                params.put("mask", String.valueOf(zoneBlackWhiteForm.getMask()));
            }
            if (IPUtil.isIpv6((String)zoneBlackWhiteForm.getIpAddress())) {
                cmdParam.setCmdID("zoneBlackListIpv6");
                params.put("ipAddress", zoneBlackWhiteForm.getIpAddress());
                params.put("mask", String.valueOf(zoneBlackWhiteForm.getMask()));
            }
        } else if (zoneBlackWhiteForm.getBlackWhiteType() == 2) {
            if (IPUtil.isIpv4((String)zoneBlackWhiteForm.getIpAddress())) {
                cmdParam.setCmdID("zoneWhiteListIpv4");
                params.put("ipAddress", zoneBlackWhiteForm.getIpAddress());
                params.put("mask", String.valueOf(zoneBlackWhiteForm.getMask()));
            }
            if (IPUtil.isIpv6((String)zoneBlackWhiteForm.getIpAddress())) {
                cmdParam.setCmdID("zoneWhiteListIpv6");
                params.put("ipAddress", zoneBlackWhiteForm.getIpAddress());
                params.put("mask", String.valueOf(zoneBlackWhiteForm.getMask()));
            }
        }
        cmdParam.setParams(params);
        cmdParams.add(cmdParam);
        CommandAPI tool = new CommandAPI();
        String cmdFileDir = CmdDevCapManager.getInstance().getCmdDevCapaFileDir(zoneBlackWhiteForm.getDeviceId());
        cmds = tool.doTranslate(cmdFileDir, "firwall_ddos", cmdParams);
        return cmds;
    }

    private void undoZoneBlackWhiteFormList(Long deviceId, List<String> result) {
        while (this.undoZoneBlackWhiteFormList.size() > 0) {
            if (this.undoZoneBlackWhiteFormList.size() > 1000) {
                this.resultUndoZoneBlackFormList.addAll(this.undoZoneBlackWhiteFormList.subList(0, 1000));
                this.undoZoneBlackWhiteFormList.subList(0, 1000).clear();
            } else {
                this.resultUndoZoneBlackFormList.addAll(this.undoZoneBlackWhiteFormList);
                this.undoZoneBlackWhiteFormList.clear();
            }
            List<Object> cmdsResult = new ArrayList();
            int undoZoneBlackWhiteFormListSize = this.resultUndoZoneBlackFormList.size();
            for (int i = 0; i < undoZoneBlackWhiteFormListSize; ++i) {
                ZoneBlackWhiteForm undoZoneBlackWhiteForm = this.resultUndoZoneBlackFormList.get(i);
                undoZoneBlackWhiteForm.setDeviceId(deviceId);
                boolean saveResult = false;
                for (int j = 0; j < 3 && !saveResult; ++j) {
                    List<String> cmds = this.undoResultTranslate(undoZoneBlackWhiteForm);
                    this.logger.info((Object)("undoZoneBlackWhiteFormList cmds: " + cmds.toString() + "; " + undoZoneBlackWhiteForm.toString()));
                    this.setCmds(cmds);
                    cmdsResult = CmdUtil.execCmds(deviceId, cmds);
                    this.logger.info((Object)("undoZoneBlackWhiteFormList cmdsResult: " + cmdsResult.toString()));
                    saveResult = this.deleteZoneBlackInfo(undoZoneBlackWhiteForm, cmdsResult);
                    try {
                        if (saveResult) continue;
                        Thread.sleep(2000L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        this.logger.error((Object)("Deploy zone blacklist (do... ),failed to deploy and need retry, Failed times = " + (i + 1) + "; reason: " + cmdsResult.toString()));
                    }
                }
                if (saveResult) {
                    this.undoCmdSuccessList.add(undoZoneBlackWhiteForm.getIpAddressAndMask());
                } else {
                    StringBuilder errorMsgKey = new StringBuilder("");
                    errorMsgKey.append(undoZoneBlackWhiteForm.getIpAddressAndMask()).append(" ");
                    for (String string : cmdsResult) {
                        String returnInfo = string.toLowerCase(Locale.ENGLISH);
                        if (!returnInfo.contains(ERROR_CONFIGURATION)) continue;
                        String cmdRest = returnInfo.split("\\r\\n")[1];
                        errorMsgKey.append(cmdRest.substring(cmdRest.indexOf(":") + 1)).append(" ");
                    }
                    this.logger.info((Object)("undoZoneBlackWhiteFormList errorMsgKey: " + errorMsgKey.toString()));
                    this.undoCmdFailedList.add(errorMsgKey.toString());
                }
                result.addAll(cmdsResult);
            }
            this.resultUndoZoneBlackFormList.clear();
        }
    }

    private boolean deleteZoneBlackInfo(ZoneBlackWhiteForm zoneBlackWhiteForm, List<String> result) {
        int errorCode = AticUtil.cmdResult(result);
        if (errorCode == 1 || errorCode == 572219) {
            IBlackWhiteListService blackWhiteListService = ZoneReferUtil.getBlackWhiteListService();
            blackWhiteListService.singleDeleteUnDeployStatus(zoneBlackWhiteForm);
            int cmdSize = result.size();
            for (int i = 0; i < cmdSize && errorCode == 572219; ++i) {
                String cmdResultLowcase = result.get(i).toLowerCase(Locale.ENGLISH);
                if (!cmdResultLowcase.contains("Error: This specified item does not exist".toLowerCase(Locale.ENGLISH))) continue;
                this.logger.info((Object)("undo deploy cmdResultLowcase result:" + this.getcleanedMessage(cmdResultLowcase)));
                result.set(i, "Info: This specified item does not exist.");
            }
        } else {
            return false;
        }
        return true;
    }

    private List<String> undoResultTranslate(ZoneBlackWhiteForm undoform) {
        List cmds = null;
        ArrayList<CmdParam> cmdParams = new ArrayList<CmdParam>();
        List<CmdViewBean> viewList = this.getCmdViewList();
        Util.getInstance().addView(viewList, cmdParams);
        CmdParam cmdParam = new CmdParam();
        HashMap<String, String> params = new HashMap<String, String>();
        if (undoform.getBlackWhiteType() == 1) {
            if (IPUtil.isIpv4((String)undoform.getIpAddress())) {
                cmdParam.setCmdID("zoneBlackListIpv4");
                params.put("undo", "undo");
                params.put("ipAddress", undoform.getIpAddress());
                params.put("mask", String.valueOf(undoform.getMask()));
            }
            if (IPUtil.isIpv6((String)undoform.getIpAddress())) {
                cmdParam.setCmdID("zoneBlackListIpv6");
                params.put("undo", "undo");
                params.put("ipAddress", undoform.getIpAddress());
                params.put("mask", String.valueOf(undoform.getMask()));
            }
        } else if (undoform.getBlackWhiteType() == 2) {
            if (IPUtil.isIpv4((String)undoform.getIpAddress())) {
                cmdParam.setCmdID("zoneWhiteListIpv4");
                params.put("undo", "undo");
                params.put("ipAddress", undoform.getIpAddress());
                params.put("mask", String.valueOf(undoform.getMask()));
            }
            if (IPUtil.isIpv6((String)undoform.getIpAddress())) {
                cmdParam.setCmdID("zoneWhiteListIpv6");
                params.put("undo", "undo");
                params.put("ipAddress", undoform.getIpAddress());
                params.put("mask", String.valueOf(undoform.getMask()));
            }
        }
        cmdParam.setParams(params);
        cmdParams.add(cmdParam);
        CommandAPI tool = new CommandAPI();
        String cmdFileDir = CmdDevCapManager.getInstance().getCmdDevCapaFileDir(undoform.getDeviceId());
        cmds = tool.doTranslate(cmdFileDir, "firwall_ddos", cmdParams);
        return cmds;
    }

    private void recordSystemLog(Long deviceId) {
        AticDevice device = CapaUtil.getAticDeviceService().getDeviceByMoid(deviceId.longValue());
        Long zoneId = this.getFeatureId();
        ZoneInfoForm zoneInfoForm = ZoneReferUtil.getById(zoneId);
        String zoneName = "--";
        if (zoneInfoForm != null && !AticUtil.isNull((String)zoneInfoForm.getZoneName())) {
            zoneName = zoneInfoForm.getZoneName();
        }
        String doCmdSuccess = "--";
        StringBuilder doCmdFailedBuilder = new StringBuilder("");
        String undoCmdSuccess = "--";
        StringBuilder undoCmdFailedBuilder = new StringBuilder("");
        if (this.doCmdSuccessList.size() > 0) {
            doCmdSuccess = this.doCmdSuccessList.toString();
        }
        if (this.doCmdFailedList.size() > 0) {
            doCmdFailedBuilder.append("[ ");
            for (String doCmdFailed : this.doCmdFailedList) {
                doCmdFailedBuilder.append(" ").append(doCmdFailed);
            }
            doCmdFailedBuilder.append(" ]");
        } else {
            doCmdFailedBuilder.append("-- ");
        }
        this.logger.info((Object)("deploy ZoneBlackWhiteListData doCmdFailedBuilder:" + this.getcleanedMessage(doCmdFailedBuilder.toString())));
        if (this.undoCmdSuccessList.size() > 0) {
            undoCmdSuccess = this.undoCmdSuccessList.toString();
        }
        if (this.undoCmdFailedList.size() > 0) {
            undoCmdFailedBuilder.append("[ ");
            for (String undoCmdFailed : this.undoCmdFailedList) {
                undoCmdFailedBuilder.append(" ").append(undoCmdFailed);
            }
            undoCmdFailedBuilder.append(" ]");
        } else {
            undoCmdFailedBuilder.append("-- ");
        }
        this.logger.info((Object)("deploy ZoneBlackWhiteListData undoCmdFailedBuilder:" + this.getcleanedMessage(undoCmdFailedBuilder.toString())));
        String[] detailPara = new String[]{zoneName, device.getName(), doCmdSuccess, doCmdFailedBuilder.toString(), undoCmdSuccess, undoCmdFailedBuilder.toString()};
        this.batchRsult(true, DDOS_POLICY_MODULE, zoneName, DDOS_POLICY_BLACK_LOG_DETAILS, DDOS_POLICY_BLACK_OPERATION, detailPara);
    }

    private void batchRsult(boolean isSuccess, String module, String target, String detail, String operation, String[] detailPara) {
        SysOptLog syncSysLog = new SysOptLog();
        syncSysLog.setOperation(operation);
        syncSysLog.setModule(module);
        syncSysLog.setLevel(SysoplogLevel.info.getValue());
        syncSysLog.setOperator("system");
        syncSysLog.setTerminalIp("127.0.0.1");
        syncSysLog.setTargetLocal(Boolean.valueOf(true));
        ISysOptLog sysOptLog = (ISysOptLog)ServiceContext.getInstance().getService("sysLogService", ISysOptLog.class);
        if (isSuccess) {
            syncSysLog.setResult(1);
            syncSysLog.setTarget(target);
            syncSysLog.setDetail(detail);
            syncSysLog.setDetailPara(detailPara);
            sysOptLog.writeOptLog(syncSysLog);
        } else {
            syncSysLog.setResult(0);
            syncSysLog.setTarget(target);
            syncSysLog.setDetail(detail);
            syncSysLog.setDetailPara(detailPara);
            sysOptLog.writeOptLog(syncSysLog);
        }
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private void getDozoneBlackWhiteFormList(Long deviceId) {
        IBlackWhiteListService blackWhiteListService = ZoneReferUtil.getBlackWhiteListService();
        if (this.list != null && !this.list.isEmpty()) {
            List cloneList = (List)ArrayDeepClone.deepClone(this.list);
            Long zoneId = this.getFeatureId();
            List<ZoneBlackWhiteForm> depolyZoneBlackWhiteFormList = blackWhiteListService.queryDoBlackWhiteListByZoneIdAndDeviceId(zoneId, deviceId);
            HashMap<String, ZoneBlackWhiteForm> zoneBlackWhiteFormMap = new HashMap<String, ZoneBlackWhiteForm>();
            for (ZoneBlackWhiteForm zoneBlackWhiteForm : depolyZoneBlackWhiteFormList) {
                zoneBlackWhiteFormMap.put(zoneBlackWhiteForm.getIpAddressAndMask(), zoneBlackWhiteForm);
            }
            for (ZoneBlackWhiteForm form : cloneList) {
                ZoneBlackWhiteForm zoneBlackWhiteFormTemp = (ZoneBlackWhiteForm)zoneBlackWhiteFormMap.get(form.getIpAddressAndMask());
                if (zoneBlackWhiteFormTemp != null && "SUCCESS".equals(zoneBlackWhiteFormTemp.getDeployState()) || form.getDeleteFlag() == 1) continue;
                this.zoneBlackWhiteFormList.add(form);
            }
        }
    }

    private void getUndozoneBlackWhiteFormList(Long deviceId) {
        IBlackWhiteListService blackWhiteListService = ZoneReferUtil.getBlackWhiteListService();
        Long zoneId = this.getFeatureId();
        List<ZoneBlackWhiteForm> depolyZoneBlackWhiteFormList = blackWhiteListService.queryDoBlackWhiteListByZoneIdAndDeviceId(zoneId, deviceId);
        HashMap<String, ZoneBlackWhiteForm> zoneBlackWhiteFormMap = new HashMap<String, ZoneBlackWhiteForm>();
        if (this.list != null && !this.list.isEmpty()) {
            List cloneList = (List)ArrayDeepClone.deepClone(this.list);
            for (ZoneBlackWhiteForm zoneBlackWhiteForm : cloneList) {
                zoneBlackWhiteFormMap.put(zoneBlackWhiteForm.getIpAddressAndMask(), zoneBlackWhiteForm);
            }
        }
        if (depolyZoneBlackWhiteFormList.size() > 0) {
            for (ZoneBlackWhiteForm form : depolyZoneBlackWhiteFormList) {
                ZoneBlackWhiteForm zoneBlackWhiteFormTemp = (ZoneBlackWhiteForm)zoneBlackWhiteFormMap.get(form.getIpAddressAndMask());
                if (zoneBlackWhiteFormTemp != null || !"SUCCESS".equals(form.getDeployState())) continue;
                this.undoZoneBlackWhiteFormList.add(form);
            }
        }
    }

    @Override
    public Object doDiscover(LogicDev logicDev, Object object) {
        return null;
    }

    @Override
    public Object doUndeploy(LogicDev logicDev, Object object) {
        return null;
    }

    @Override
    public Object doVerify(LogicDev logicDev, Object object) {
        return null;
    }

    @Override
    public Map<String, List<Long>> getDependFeatureID(List<IFeature> featureDataList) {
        return null;
    }

    @Override
    public Map<String, List<Long>> getDependFeatureID(Long featureID) {
        return null;
    }

    @Override
    public IFeature getFeature(Long featureID) {
        return null;
    }

    @Override
    public List<IFeature> getFeature(List<Long> featureIDList) {
        return null;
    }

    @Override
    public IFeature getTopFeatureData() {
        return null;
    }

    public List<ZoneBlackWhiteForm> getList() {
        return this.list;
    }

    public void setList(List<ZoneBlackWhiteForm> list) {
        this.list = list;
    }

    public List<ZoneBlackWhiteForm> getZoneBlackWhiteFormList() {
        return this.zoneBlackWhiteFormList;
    }

    public void setZoneBlackWhiteFormList(List<ZoneBlackWhiteForm> zoneBlackWhiteFormList) {
        this.zoneBlackWhiteFormList = zoneBlackWhiteFormList;
    }

    public List<ZoneBlackWhiteForm> getUndoZoneBlackWhiteFormList() {
        return this.undoZoneBlackWhiteFormList;
    }

    public void setUndoZoneBlackWhiteFormList(List<ZoneBlackWhiteForm> undoZoneBlackWhiteFormList) {
        this.undoZoneBlackWhiteFormList = undoZoneBlackWhiteFormList;
    }

    public List<ZoneBlackWhiteForm> getResultZoneBlackFormList() {
        return this.resultZoneBlackFormList;
    }

    public void setResultZoneBlackFormList(List<ZoneBlackWhiteForm> resultZoneBlackFormList) {
        this.resultZoneBlackFormList = resultZoneBlackFormList;
    }

    public List<ZoneBlackWhiteForm> getResultUndoZoneBlackFormList() {
        return this.resultUndoZoneBlackFormList;
    }

    public void setResultUndoZoneBlackFormList(List<ZoneBlackWhiteForm> resultUndoZoneBlackFormList) {
        this.resultUndoZoneBlackFormList = resultUndoZoneBlackFormList;
    }
}

