/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.service.data.feature;

import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.atic.sdk.zone.form.ZoneIpForm;
import com.hs.atic.sdk.zone.form.ZoneUndoIpForm;
import com.hs.atic.zone.model.ZoneListIpInfo;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.vsm.secservice.ddos.common.CmdUtil;
import com.hs.vsm.secservice.ddos.common.CommandPair;
import com.hs.vsm.secservice.ddos.policy.ref.ZoneReferUtil;
import com.hs.vsm.secservice.ddos.service.data.ZoneDeployResult;
import com.hs.vsm.secservice.ddos.service.function.Util;
import com.hs.vsm.secservice.sdk.common.util.VsmUtil;
import com.hs.vsm.secservice.sdk.frame.model.AbstractFeature;
import com.hs.vsm.secservice.sdk.frame.model.CmdViewBean;
import com.hs.vsm.secservice.sdk.frame.model.IFeature;
import com.hs.vsm.secservice.sdk.frame.model.LogicDev;
import com.huawei.atic.secne.adapter.frame.service.CmdDevCapManager;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.huawei.atic.secne.service.impl.ExcmdConnectUtil;
import com.huawei.atic.secne.service.impl.ExcmdConnectionPool;
import com.huawei.atic.secservice.policyengine.command.CommandAPI;
import com.huawei.atic.secservice.policyengine.commandutil.CmdParam;
import com.huawei.atic.south.model.TelnetPara;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ZoneIpInfo
extends AbstractFeature
implements Serializable {
    private static final long serialVersionUID = -5438125506088880047L;
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private List<String> zoneIp;
    private String cmdFileDir;
    private String commandType = ZoneListIpInfo.class.getSimpleName();

    public ZoneIpInfo() {
    }

    public ZoneIpInfo(Object configData, String featureType, Long featureId, List<String> zoneIp) {
        this.setConfigData(configData);
        this.setFeatureId(featureId);
        this.setFeatureType(featureType);
        this.setZoneIp(zoneIp);
    }

    @Override
    public Object doAudit(LogicDev logicDev, Object object) {
        return null;
    }

    @Override
    public Object doDeploy(LogicDev logicDev, Object object) {
        ArrayList<String> totalResult = new ArrayList<String>();
        Long moid = logicDev.getDeviceId();
        ExcmdConnectUtil excmdConnectUtil = null;
        IAticDeviceService aticDeviceService = ZoneReferUtil.getFirewallService();
        TelnetPara telnetPara = aticDeviceService.getDeviceTelnetPara(moid.longValue());
        this.cmdFileDir = CmdDevCapManager.getInstance().getCmdDevCapaFileDir(moid);
        ZoneDeployResult zoneDeployResult = (ZoneDeployResult)object;
        ZoneInfoForm infoForm = (ZoneInfoForm)this.getConfigData();
        this.clearZoneIpCommandPair(moid, infoForm.getZoneId(), zoneDeployResult.getCommandDeployResult());
        boolean cmdResultFlag = false;
        boolean isAllFail = true;
        List<String> cmd = null;
        try {
            if (null != telnetPara) {
                excmdConnectUtil = ExcmdConnectionPool.getInstance().getExcmdConnectUtil(telnetPara);
                cmdResultFlag = this.execCmds(excmdConnectUtil, totalResult, cmd = this.doZoneViewCmds(), true);
                if (!cmdResultFlag) {
                    this.deployResultAllFail(moid, zoneDeployResult);
                    ArrayList<String> arrayList = totalResult;
                    return arrayList;
                }
                if (infoForm.isUndoAll()) {
                    cmd = this.undoAllIpCmd();
                    cmdResultFlag = this.execCmds(excmdConnectUtil, totalResult, cmd, false);
                    if (!cmdResultFlag) {
                        this.deployResultAllFail(moid, zoneDeployResult);
                        ArrayList<String> arrayList = totalResult;
                        return arrayList;
                    }
                    isAllFail = false;
                    List<ZoneIpForm> zoneIpFormList = infoForm.getZoneIpFormList();
                    if (null != zoneIpFormList && !zoneIpFormList.isEmpty()) {
                        int size = zoneIpFormList.size();
                        for (int i = 0; i < size; ++i) {
                            ZoneIpForm zoneIpForm = zoneIpFormList.get(i);
                            ArrayList<ZoneIpForm> zoneIpforms = new ArrayList<ZoneIpForm>();
                            zoneIpforms.add(zoneIpForm);
                            try {
                                cmd = this.doDeployIpCmd(zoneIpForm);
                                cmdResultFlag = this.execCmds(excmdConnectUtil, totalResult, cmd, false);
                                if (!cmdResultFlag) {
                                    this.deployIpResult(moid, zoneDeployResult, zoneIpforms, false);
                                    continue;
                                }
                                this.deployIpResult(moid, zoneDeployResult, zoneIpforms, true);
                                continue;
                            }
                            catch (LegoCheckedException e) {
                                zoneIpforms.clear();
                                zoneIpforms.addAll(zoneIpFormList.subList(i, size));
                                this.deployIpResult(moid, zoneDeployResult, zoneIpforms, false);
                                this.logger.error((Object)("@doDeploy, deploy zoneIp, EXE CLI ERROR : " + e.getMessage()));
                                throw e;
                            }
                            catch (Exception e) {
                                zoneIpforms.clear();
                                zoneIpforms.addAll(zoneIpFormList.subList(i, size));
                                this.deployIpResult(moid, zoneDeployResult, zoneIpforms, false);
                                this.logger.error((Object)e);
                                throw new LegoCheckedException(630005L, (Throwable)e);
                            }
                        }
                    }
                } else {
                    isAllFail = false;
                    List<ZoneUndoIpForm> zoneUndoIpFormList = infoForm.getZoneUndoIpFromList();
                    if (null != zoneUndoIpFormList && !zoneUndoIpFormList.isEmpty()) {
                        int size = zoneUndoIpFormList.size();
                        for (int i = 0; i < size; ++i) {
                            ZoneUndoIpForm zoneUndoIpForm = zoneUndoIpFormList.get(i);
                            ArrayList<ZoneUndoIpForm> zoneUndoIpForms = new ArrayList<ZoneUndoIpForm>();
                            zoneUndoIpForms.add(zoneUndoIpForm);
                            try {
                                cmd = this.undoDeployIpCmd(zoneUndoIpForm);
                                cmdResultFlag = this.execCmds(excmdConnectUtil, totalResult, cmd, false);
                                if (!cmdResultFlag) {
                                    this.undoIpResult(moid, zoneDeployResult, zoneUndoIpForms, false);
                                    continue;
                                }
                                this.undoIpResult(moid, zoneDeployResult, zoneUndoIpForms, true);
                                continue;
                            }
                            catch (LegoCheckedException e) {
                                zoneUndoIpForms.clear();
                                zoneUndoIpForms.addAll(zoneUndoIpFormList.subList(i, size));
                                this.undoIpResult(moid, zoneDeployResult, zoneUndoIpForms, false);
                                this.deployIpResult(moid, zoneDeployResult, infoForm.getZoneIpFormList(), false);
                                this.logger.error((Object)("@doDeploy, deploy zoneIp, EXE CLI ERROR : " + e.getMessage()));
                                throw e;
                            }
                            catch (Exception e) {
                                zoneUndoIpForms.clear();
                                zoneUndoIpForms.addAll(zoneUndoIpFormList.subList(i, size));
                                this.undoIpResult(moid, zoneDeployResult, zoneUndoIpForms, false);
                                this.deployIpResult(moid, zoneDeployResult, infoForm.getZoneIpFormList(), false);
                                this.logger.error((Object)e);
                                throw new LegoCheckedException(630005L, (Throwable)e);
                            }
                        }
                    }
                    isAllFail = false;
                    List<ZoneIpForm> zoneIpFormList = infoForm.getZoneIpFormList();
                    if (null != zoneIpFormList && !zoneIpFormList.isEmpty()) {
                        int size = zoneIpFormList.size();
                        for (int i = 0; i < size; ++i) {
                            ZoneIpForm zoneIpForm = zoneIpFormList.get(i);
                            ArrayList<ZoneIpForm> zoneIpforms = new ArrayList<ZoneIpForm>();
                            zoneIpforms.add(zoneIpForm);
                            try {
                                cmd = this.doDeployIpCmd(zoneIpForm);
                                cmdResultFlag = this.execCmds(excmdConnectUtil, totalResult, cmd, false);
                                if (!cmdResultFlag) {
                                    this.deployIpResult(moid, zoneDeployResult, zoneIpforms, false);
                                    continue;
                                }
                                this.deployIpResult(moid, zoneDeployResult, zoneIpforms, true);
                                continue;
                            }
                            catch (LegoCheckedException e) {
                                zoneIpforms.clear();
                                zoneIpforms.addAll(zoneIpFormList.subList(i, size));
                                this.deployIpResult(moid, zoneDeployResult, zoneIpforms, false);
                                this.logger.error((Object)("@doDeploy, deploy zoneIp, EXE CLI ERROR : " + e.getMessage()));
                                throw e;
                            }
                            catch (Exception e) {
                                zoneIpforms.clear();
                                zoneIpforms.addAll(zoneIpFormList.subList(i, size));
                                this.deployIpResult(moid, zoneDeployResult, zoneIpforms, false);
                                this.logger.error((Object)e);
                                throw new LegoCheckedException(630005L, (Throwable)e);
                            }
                        }
                    }
                }
            }
        }
        catch (LegoCheckedException e) {
            if (isAllFail) {
                this.logger.error((Object)("@doDeploy, EXE CLI ERROR, isAllFail : " + isAllFail));
                this.deployResultAllFail(moid, zoneDeployResult);
            }
            this.logger.error((Object)("@doDeploy, EXE CLI ERROR : " + e.getMessage()));
            throw e;
        }
        finally {
            if (null != telnetPara) {
                ExcmdConnectionPool.getInstance().excmdConnectionRelease(moid.longValue(), excmdConnectUtil);
            }
        }
        return totalResult;
    }

    private void clearZoneIpCommandPair(Long deviceId, Long zoneId, Map<CommandPair, Boolean> commandDeployResult) {
        Iterator<Map.Entry<CommandPair, Boolean>> commandPairEntrys = commandDeployResult.entrySet().iterator();
        while (commandPairEntrys.hasNext()) {
            CommandPair commandPair = commandPairEntrys.next().getKey();
            if (!deviceId.equals(commandPair.getDeviceId()) || !zoneId.equals(commandPair.getZoneId()) || !this.commandType.equals(commandPair.getCommandType())) continue;
            commandPairEntrys.remove();
        }
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private List<String> doZoneViewCmds() {
        ArrayList<CmdParam> cmdParamList = new ArrayList<CmdParam>();
        List<CmdViewBean> viewList = this.getCmdViewList();
        Util.getInstance().addView(viewList, cmdParamList);
        List<String> reCmds = this.doTranslate(cmdParamList);
        this.logger.info((Object)("into zoneView cmd : " + this.getcleanedMessage(reCmds.toString())));
        return reCmds;
    }

    private List<String> undoAllIpCmd() {
        ArrayList<CmdParam> cmdParams = new ArrayList<CmdParam>();
        CmdParam cmdParamUndo = new CmdParam();
        cmdParamUndo.setCmdID("undoZoneIp");
        cmdParams.add(cmdParamUndo);
        List<String> reCmds = this.doTranslate(cmdParams);
        this.logger.info((Object)("undo all cmd : " + this.getcleanedMessage(reCmds.toString())));
        return reCmds;
    }

    private List<String> doDeployIpCmd(ZoneIpForm zoneIpForm) {
        ArrayList<CmdParam> cmdParams = new ArrayList<CmdParam>();
        this.logger.info((Object)("deploy cmd data is" + zoneIpForm.toString()));
        Map<String, String> paramsMap = VsmUtil.getInstance().getObjectFieldAndValues(zoneIpForm);
        CmdParam undoCmdParam = new CmdParam();
        if (IPUtil.isIpv6((String)zoneIpForm.getZoneIp())) {
            undoCmdParam.setCmdID("undoAddZoneIpV6");
        } else {
            undoCmdParam.setCmdID("undoAddZoneIp");
        }
        undoCmdParam.setParams(paramsMap);
        cmdParams.add(undoCmdParam);
        CmdParam cmdParam = new CmdParam();
        if (IPUtil.isIpv6((String)zoneIpForm.getZoneIp())) {
            cmdParam.setCmdID("addZoneIpv6");
        } else {
            cmdParam.setCmdID("addZoneIp");
        }
        cmdParam.setParams(paramsMap);
        cmdParams.add(cmdParam);
        List<String> reCmds = this.doTranslate(cmdParams);
        this.logger.info((Object)("do ip cmd : " + this.getcleanedMessage(reCmds.toString())));
        return reCmds;
    }

    private List<String> undoDeployIpCmd(ZoneUndoIpForm zoneUndoIpForm) {
        ArrayList<CmdParam> cmdParams = new ArrayList<CmdParam>();
        Map<String, String> paramsMap = VsmUtil.getInstance().getObjectFieldAndValues(zoneUndoIpForm);
        CmdParam cmdParam = new CmdParam();
        if (IPUtil.isIpv6((String)zoneUndoIpForm.getZoneIp())) {
            cmdParam.setCmdID("undoAddZoneIpV6");
        } else {
            cmdParam.setCmdID("undoAddZoneIp");
        }
        cmdParam.setParams(paramsMap);
        cmdParams.add(cmdParam);
        List<String> reCmds = this.doTranslate(cmdParams);
        this.logger.info((Object)("undo ip cmd : " + this.getcleanedMessage(reCmds.toString())));
        return reCmds;
    }

    private List<String> doTranslate(List<CmdParam> cmdParamList) {
        CommandAPI tool = new CommandAPI();
        String separator = System.getProperty("line.separator");
        ArrayList<String> reCmds = new ArrayList<String>();
        List cmds = tool.doTranslate(this.cmdFileDir, "firwall_ddos", cmdParamList);
        Iterator iterator = cmds.iterator();
        while (iterator.hasNext()) {
            String cmdStrTemp;
            String cmdStr = cmdStrTemp = (String)iterator.next();
            cmdStr = cmdStr.replaceAll("lineseparatortmp", separator);
            reCmds.add(cmdStr);
        }
        return reCmds;
    }

    private Boolean execCmds(ExcmdConnectUtil excmdConnectUtil, List<String> totalResult, List<String> cmd, boolean isFirst) {
        this.addCmd(cmd);
        List<String> result = CmdUtil.execCmds(excmdConnectUtil, cmd, isFirst);
        this.logger.info((Object)("deploy result : " + this.getcleanedMessage(result.toString())));
        totalResult.addAll(result);
        Boolean flag = VsmUtil.getInstance().checkCmdResult(result);
        this.logger.info((Object)("deploy flag : " + flag));
        return flag;
    }

    private void deployResultAllFail(Long deviceId, ZoneDeployResult zoneDeployResult) {
        block9: {
            List<ZoneUndoIpForm> zoneUndoIpForms;
            Long zoneId;
            ZoneInfoForm infoForm;
            Set<CommandPair> commandPairSet;
            Map<CommandPair, Boolean> commandDeployResult;
            block8: {
                commandDeployResult = zoneDeployResult.getCommandDeployResult();
                commandPairSet = commandDeployResult.keySet();
                infoForm = (ZoneInfoForm)this.getConfigData();
                zoneId = infoForm.getZoneId();
                if (!infoForm.isUndoAll()) break block8;
                List<ZoneIpForm> zoneIpForms = infoForm.getZoneIpFormList();
                if (null == zoneIpForms || zoneIpForms.isEmpty()) break block9;
                int size = zoneIpForms.size();
                for (int i = 0; i < size; ++i) {
                    ZoneIpForm zoneIpForm = zoneIpForms.get(i);
                    List<Long> pkIds = zoneIpForm.getPkIdList();
                    for (Long pkId : pkIds) {
                        CommandPair curCommand = new CommandPair(zoneId, deviceId, this.commandType, pkId);
                        if (commandPairSet.contains(curCommand) && !commandDeployResult.get(curCommand).booleanValue()) continue;
                        commandDeployResult.put(curCommand, false);
                    }
                }
                break block9;
            }
            List<ZoneIpForm> zoneIpForms = infoForm.getZoneIpFormList();
            if (null != zoneIpForms && !zoneIpForms.isEmpty()) {
                int size = zoneIpForms.size();
                for (int i = 0; i < size; ++i) {
                    ZoneIpForm zoneIpForm = zoneIpForms.get(i);
                    List<Long> pkIds = zoneIpForm.getPkIdList();
                    for (Long pkId : pkIds) {
                        CommandPair curCommand = new CommandPair(zoneId, deviceId, this.commandType, pkId);
                        if (commandPairSet.contains(curCommand) && !commandDeployResult.get(curCommand).booleanValue()) continue;
                        commandDeployResult.put(curCommand, false);
                    }
                }
            }
            if (null != (zoneUndoIpForms = infoForm.getZoneUndoIpFromList()) && !zoneUndoIpForms.isEmpty()) {
                int size = zoneUndoIpForms.size();
                for (int i = 0; i < size; ++i) {
                    ZoneUndoIpForm zoneUndoIpForm = zoneUndoIpForms.get(i);
                    List<Long> pkIds = zoneUndoIpForm.getPkIdList();
                    for (Long pkId : pkIds) {
                        CommandPair curCommand = new CommandPair(zoneId, deviceId, this.commandType, pkId);
                        if (commandPairSet.contains(curCommand) && !commandDeployResult.get(curCommand).booleanValue()) continue;
                        commandDeployResult.put(curCommand, false);
                    }
                }
            }
        }
    }

    private void deployIpResult(Long deviceId, ZoneDeployResult zoneDeployResult, List<ZoneIpForm> zoneIpForms, boolean flag) {
        Map<CommandPair, Boolean> commandDeployResult = zoneDeployResult.getCommandDeployResult();
        Set<CommandPair> commandPairSet = commandDeployResult.keySet();
        ZoneInfoForm infoForm = (ZoneInfoForm)this.getConfigData();
        Long zoneId = infoForm.getZoneId();
        if (null != zoneIpForms && !zoneIpForms.isEmpty()) {
            int size = zoneIpForms.size();
            for (int i = 0; i < size; ++i) {
                ZoneIpForm zoneIpForm = zoneIpForms.get(i);
                List<Long> pkIds = zoneIpForm.getPkIdList();
                for (Long pkId : pkIds) {
                    CommandPair curCommand = new CommandPair(zoneId, deviceId, this.commandType, pkId);
                    if (flag) {
                        if (commandPairSet.contains(curCommand)) continue;
                        commandDeployResult.put(curCommand, true);
                        continue;
                    }
                    if (commandPairSet.contains(curCommand) && !commandDeployResult.get(curCommand).booleanValue()) continue;
                    commandDeployResult.put(curCommand, false);
                }
            }
        }
    }

    private void undoIpResult(Long deviceId, ZoneDeployResult zoneDeployResult, List<ZoneUndoIpForm> zoneUndoIpForms, boolean flag) {
        Map<CommandPair, Boolean> commandDeployResult = zoneDeployResult.getCommandDeployResult();
        Set<CommandPair> commandPairSet = commandDeployResult.keySet();
        ZoneInfoForm infoForm = (ZoneInfoForm)this.getConfigData();
        Long zoneId = infoForm.getZoneId();
        if (null != zoneUndoIpForms && !zoneUndoIpForms.isEmpty()) {
            int size = zoneUndoIpForms.size();
            for (int i = 0; i < size; ++i) {
                ZoneUndoIpForm zoneIpForm = zoneUndoIpForms.get(i);
                List<Long> pkIds = zoneIpForm.getPkIdList();
                for (Long pkId : pkIds) {
                    CommandPair curCommand = new CommandPair(zoneId, deviceId, this.commandType, pkId);
                    if (flag) {
                        if (commandPairSet.contains(curCommand)) continue;
                        commandDeployResult.put(curCommand, true);
                        continue;
                    }
                    if (commandPairSet.contains(curCommand) && !commandDeployResult.get(curCommand).booleanValue()) continue;
                    commandDeployResult.put(curCommand, false);
                }
            }
        }
    }

    @Override
    public Object doDiscover(LogicDev logicDev, Object object) {
        return null;
    }

    @Override
    public Object doUndeploy(LogicDev logicDev, Object object) {
        return null;
    }

    @Override
    public Object doVerify(LogicDev logicDev, Object object) {
        return null;
    }

    @Override
    public Map<String, List<Long>> getDependFeatureID(List<IFeature> featureDataList) {
        return null;
    }

    @Override
    public Map<String, List<Long>> getDependFeatureID(Long featureID) {
        return null;
    }

    @Override
    public IFeature getFeature(Long featureID) {
        return null;
    }

    @Override
    public List<IFeature> getFeature(List<Long> featureIDList) {
        return null;
    }

    @Override
    public IFeature getTopFeatureData() {
        return null;
    }

    public List<String> getZoneIp() {
        return this.zoneIp;
    }

    public void setZoneIp(List<String> zoneIp) {
        this.zoneIp = zoneIp;
    }
}

