/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.service.data.feature;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.secservice.ddos.common.CmdUtil;
import com.hs.vsm.secservice.ddos.common.FeaturePair;
import com.hs.vsm.secservice.ddos.model.ZoneFeatureStatusInfo;
import com.hs.vsm.secservice.ddos.service.function.Util;
import com.hs.vsm.secservice.sdk.common.util.VsmUtil;
import com.hs.vsm.secservice.sdk.frame.model.AbstractFeature;
import com.hs.vsm.secservice.sdk.frame.model.CmdViewBean;
import com.hs.vsm.secservice.sdk.frame.model.IFeature;
import com.hs.vsm.secservice.sdk.frame.model.LogicDev;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneServiceForm;
import com.huawei.atic.secne.adapter.capability.model.DeviceTypeInfo;
import com.huawei.atic.secne.adapter.frame.service.CmdDevCapManager;
import com.huawei.atic.secservice.ddos.service.impl.DdosDevCapabilityServiceImpl;
import com.huawei.atic.secservice.policyengine.command.CommandAPI;
import com.huawei.atic.secservice.policyengine.commandutil.CmdParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ZoneServiceBasicInfo
extends AbstractFeature
implements Serializable {
    private static final long serialVersionUID = 1834645066158911819L;
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private Map<FeaturePair, ZoneFeatureStatusInfo> basicServiceStatusMap;
    private Boolean isServicesFully = false;

    public ZoneServiceBasicInfo() {
    }

    public ZoneServiceBasicInfo(Object obj, String featureType, Long featureId, Map<FeaturePair, ZoneFeatureStatusInfo> map) {
        this.setBasicServiceStatusMap(map);
        this.setConfigData(obj);
        this.setFeatureType(featureType);
        this.setFeatureId(featureId);
    }

    public Map<FeaturePair, ZoneFeatureStatusInfo> getBasicServiceStatusMap() {
        return this.basicServiceStatusMap;
    }

    public void setBasicServiceStatusMap(Map<FeaturePair, ZoneFeatureStatusInfo> basicServiceStatusMap) {
        this.basicServiceStatusMap = basicServiceStatusMap;
    }

    @Override
    public Object doAudit(LogicDev logicDev, Object object) {
        return null;
    }

    @Override
    public Object doDeploy(LogicDev logicDev, Object object) {
        DeviceTypeInfo devTypeInfo;
        ZoneServiceForm serviceForm = (ZoneServiceForm)this.getConfigData();
        List<Object> result = new ArrayList();
        if ("DEFAULT".equals(serviceForm.getProtocol())) {
            return result;
        }
        DdosDevCapabilityServiceImpl devCapabilityService = DdosDevCapabilityServiceImpl.getInstance();
        Set supportAttrs = devCapabilityService.getAllSupportedAttr(devTypeInfo = CmdUtil.getDevTypeInfo(logicDev.getDeviceId()));
        Boolean isSupportPortService = supportAttrs.contains("isSupportPortService");
        if (!isSupportPortService.booleanValue()) {
            return result;
        }
        List<String> cmds = this.doTranslate(logicDev.getDeviceId());
        this.logger.info((Object)("device : " + logicDev.getDeviceId() + "to deploy cmds:" + this.getcleanedMessage(cmds.toString())));
        this.setCmds(cmds);
        result = CmdUtil.execCmds(logicDev.getDeviceId(), cmds);
        this.logger.info((Object)("deploy result:" + this.getcleanedMessage(result.toString())));
        return result;
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private List<String> doTranslate(Long moId) {
        List cmds = null;
        ZoneServiceForm serviceBasicForm = (ZoneServiceForm)this.getConfigData();
        Map<String, String> params = VsmUtil.getInstance().getObjectFieldAndValues(serviceBasicForm);
        ArrayList<CmdParam> cmdParams = new ArrayList<CmdParam>();
        List<CmdViewBean> viewList = this.getCmdViewList();
        Util.getInstance().addView(viewList, cmdParams);
        FeaturePair featurePair = new FeaturePair(serviceBasicForm.getZoneId(), moId, serviceBasicForm.getClass().getSimpleName(), serviceBasicForm.getPkid());
        ZoneFeatureStatusInfo serviceBasicStatus = this.getBasicServiceStatusMap().get(featurePair);
        if (!this.lastDeploySuccess(serviceBasicStatus) || this.getIsServicesFully().booleanValue()) {
            this.translateServiceBasicInfo(params, cmdParams, false);
        } else {
            this.translateServiceBasicInfo(params, cmdParams, true);
        }
        CommandAPI tool = new CommandAPI();
        String cmdFileDir = CmdDevCapManager.getInstance().getCmdDevCapaFileDir(moId);
        cmds = tool.doTranslate(cmdFileDir, "basic_service", cmdParams);
        return cmds;
    }

    private boolean lastDeploySuccess(ZoneFeatureStatusInfo serviceBasicStatus) {
        return serviceBasicStatus != null && serviceBasicStatus.getDeployState() != null && serviceBasicStatus.getDeployState() != false;
    }

    private void translateServiceBasicInfo(Map<String, String> params, List<CmdParam> cmdParams, Boolean isDeploy) {
        CmdParam cmdParam2 = new CmdParam();
        cmdParam2.setCmdID("portService");
        cmdParam2.setParams(params);
        cmdParams.add(cmdParam2);
        if (!isDeploy.booleanValue()) {
            CmdParam cmdParam3 = new CmdParam();
            cmdParam3.setCmdID("portServiceId");
            cmdParam3.setParams(params);
            cmdParams.add(cmdParam3);
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        if ("1".equals(params.get("portType"))) {
            paramMap.put("portType", "authentication-port");
            CmdParam cmdParam4 = new CmdParam();
            cmdParam4.setCmdID("portServicePortType");
            cmdParam4.setParams(paramMap);
            cmdParams.add(cmdParam4);
        } else if ("2".equals(params.get("portType"))) {
            paramMap.put("portType", "service-port");
            CmdParam cmdParam4 = new CmdParam();
            cmdParam4.setCmdID("portServicePortType");
            cmdParam4.setParams(paramMap);
            cmdParams.add(cmdParam4);
        } else {
            paramMap.put("undo", "undo");
            CmdParam cmdParam4 = new CmdParam();
            cmdParam4.setCmdID("portServicePortType");
            cmdParam4.setParams(paramMap);
            cmdParams.add(cmdParam4);
        }
    }

    @Override
    public Object doDiscover(LogicDev logicDev, Object object) {
        return null;
    }

    @Override
    public Object doUndeploy(LogicDev logicDev, Object object) {
        return null;
    }

    @Override
    public Object doVerify(LogicDev logicDev, Object object) {
        return null;
    }

    @Override
    public Map<String, List<Long>> getDependFeatureID(List<IFeature> featureDataList) {
        return null;
    }

    @Override
    public Map<String, List<Long>> getDependFeatureID(Long featureID) {
        return null;
    }

    @Override
    public IFeature getFeature(Long featureID) {
        return null;
    }

    @Override
    public List<IFeature> getFeature(List<Long> featureIDList) {
        return null;
    }

    @Override
    public IFeature getTopFeatureData() {
        return null;
    }

    public Boolean getIsServicesFully() {
        return this.isServicesFully;
    }

    public void setIsServicesFully(Boolean isServicesFully) {
        this.isServicesFully = isServicesFully;
    }
}

