/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.service.function.deploy;

import com.hs.atic.sdk.res.service.ILicenseOutboundService;
import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.atic.util.AticUtil;
import com.hs.atic.zone.util.ZoneUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.secservice.ddos.common.ErrorMsg2ResKey;
import com.hs.vsm.secservice.ddos.common.FilterDevicePair;
import com.hs.vsm.secservice.ddos.common.FilterDeviceZonePair;
import com.hs.vsm.secservice.ddos.model.FilterInfo;
import com.hs.vsm.secservice.ddos.model.HttpFilterInfo;
import com.hs.vsm.secservice.ddos.service.data.FilterToDeployData;
import com.hs.vsm.secservice.ddos.service.data.feature.FilterData;
import com.hs.vsm.secservice.ddos.service.data.feature.FilterZoneData;
import com.hs.vsm.secservice.ddos.service.function.deploy.FilterDeployInfo;
import com.hs.vsm.secservice.nfa.restful.deploy.FormTransObject;
import com.hs.vsm.secservice.nfa.restful.deploy.InitNfaDeployData;
import com.hs.vsm.secservice.nfa.util.NfaFilterUtil;
import com.hs.vsm.secservice.sdk.frame.model.IFeature;
import com.hs.vsm.secservice.sdk.frame.model.LogicDev;
import com.hs.vsm.secservice.sdk.module.ddos.Constant;
import com.hs.vsm.secservice.sdk.module.ddos.form.NfaPolicyForm;
import com.hs.vsm.secservice.sdk.module.ddos.service.IFilterDeviceZoneInfoService;
import com.hs.vsm.secservice.sdk.module.ddos.service.INfaPolicyService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneFeatureStatusService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.huawei.atic.secservice.nfa.restful.model.DefinedFilter;
import com.huawei.atic.secservice.nfa.restful.model.FilterPolicyObject;
import com.huawei.atic.secservice.nfa.restful.model.NfaInfoForm;
import com.huawei.atic.secservice.nfa.restful.model.PolicyObject;
import com.huawei.atic.secservice.nfa.restful.model.Result;
import com.huawei.atic.secservice.nfa.restful.model.ZoneInfoObject;
import com.huawei.atic.secservice.nfa.restful.model.ZonePolicyObject;
import com.huawei.atic.secservice.nfa.restful.sdk.service.IRestfulNfaService;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FilterDeployThread
extends Thread {
    private static final int NFA_ERRORCODE = 462;
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private LogicDev logicDev;
    private FilterToDeployData filterToDeployData;
    private Map<FilterDevicePair, String> filterDeployResult;
    private Map<FilterDevicePair, String> filterUnDeployResult;
    private Map<FilterDeviceZonePair, String> filterZoneDeployResult;
    private Map<FilterDeviceZonePair, String> filterZoneUnDeployResult;
    private Boolean isDeviceConnectedOK = true;
    private Map<String, String> errorMapping = ErrorMsg2ResKey.getInstance().getErrorMsgKeyMapping();
    private IAticDeviceService aticDeviceService;
    private IRestfulNfaService restfulNfaService;
    private IZoneFeatureStatusService zoneFeatureStatusService;
    private ILicenseOutboundService licenseOutboundService;

    public FilterDeployThread(LogicDev logicDev, FilterDeployInfo filterDeployInfo) {
        this.logicDev = logicDev;
        this.filterToDeployData = filterDeployInfo.getFilterToDeployData();
        this.filterDeployResult = filterDeployInfo.getFilterDeployResult();
        this.filterUnDeployResult = filterDeployInfo.getFilterUnDeployResult();
        this.filterZoneDeployResult = filterDeployInfo.getFilterZoneDeployResult();
        this.filterZoneUnDeployResult = filterDeployInfo.getFilterZoneUnDeployResult();
    }

    @Override
    public void run() {
        this.aticDeviceService = (IAticDeviceService)ServiceContext.getInstance().getService("aticDeviceService", IAticDeviceService.class);
        this.zoneFeatureStatusService = (IZoneFeatureStatusService)ServiceContext.getInstance().getService("zoneFeatureStatusService", IZoneFeatureStatusService.class);
        AticDevice aticDevice = this.aticDeviceService.getDeviceByMoid(this.logicDev.getDeviceId().longValue());
        try {
            if (null != aticDevice && aticDevice.getDeviceType() == 5) {
                this.restfulNfaService = (IRestfulNfaService)ServiceContext.getInstance().getService("restfulNfaService", IRestfulNfaService.class);
                NfaInfoForm nfaInfoForm = NfaFilterUtil.getNfaInfoFormByDeviceId(this.logicDev.getDeviceId());
                if (null != nfaInfoForm) {
                    this.unDeployFilterZoneFromNfa(nfaInfoForm);
                    this.unDeployFilterFromNfa(nfaInfoForm);
                    this.deployFilterToNfa(nfaInfoForm);
                    this.deployfilterZoneToNfa(nfaInfoForm);
                } else {
                    this.logger.error((Object)"nfaInfoForm is null");
                }
            } else {
                this.unDeployFilterZoneFromDevice();
                this.unDeployFilterFromDevice();
                this.deployFilterToDevice();
                this.deployFilterZoneToDevice();
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("deploy filter thread error, device id : " + this.logicDev.getDeviceId()), (Throwable)e);
        }
    }

    private void deployFilterToNfa(NfaInfoForm nfaInfoForm) {
        List<IFeature> deployFilterData = this.filterToDeployData.getFilterInfoToDeployData().get(this.logicDev.getDeviceId());
        if (deployFilterData != null && !deployFilterData.isEmpty()) {
            for (int i = 0; i < deployFilterData.size(); ++i) {
                IFeature feature = deployFilterData.get(i);
                FilterData filterData = (FilterData)feature;
                this.logger.info((Object)("pre deploy filter on nfa,  deviceId : " + this.logicDev.getDeviceId() + ", filterId : " + filterData.getFilterInfo().getPkid()));
                String errorCode = "lego.err.631039";
                DefinedFilter definedFilter = this.getNfaFilter(filterData);
                try {
                    if (this.isDeviceConnectedOK.booleanValue() || i == 0) {
                        Result result = this.restfulNfaService.restNfaAddDefinedFilter(definedFilter, nfaInfoForm);
                        errorCode = this.getNfaErrorCode(result);
                    }
                }
                catch (LegoCheckedException e) {
                    this.logger.error((Object)"deploy filter on nfa error, ", (Throwable)e);
                    this.isDeviceConnectedOK = false;
                    errorCode = e.getErrorCode() == 0L ? e.getMessage() : "lego.err." + e.getErrorCode();
                }
                catch (Exception e) {
                    this.logger.error((Object)"deploy filter by deploy error, ", (Throwable)e);
                    errorCode = "lego.err.631039";
                }
                this.checkFilterResult(filterData.getFeatureId(), errorCode, true);
            }
        }
    }

    private String getNfaErrorCode(Result result) {
        String errorCode = "";
        errorCode = null != result && result.getStatusCode() == 200 && result.getJson().contains("ok") ? "" : (null != result && result.getStatusCode() == 462 ? "lego.err.9" : (null != result && null != result.getJson() && result.getJson().contains("certificate is error") ? "lego.err.certificate" : "lego.err.8"));
        return errorCode;
    }

    private DefinedFilter getNfaFilter(FilterData filterData) {
        DefinedFilter definedFilter = null;
        FilterInfo filterInfo = filterData.getFilterInfo();
        List<HttpFilterInfo> httpFilterInfos = filterData.getFilterPolicyInfoList();
        definedFilter = NfaFilterUtil.httpFilterTransfDefinedFilter(httpFilterInfos);
        if (null != filterInfo) {
            definedFilter.setFilterId(filterInfo.getFilterId());
            definedFilter.setFilterName(filterInfo.getFilterName());
            definedFilter.setType(filterInfo.getFilterType());
        }
        return definedFilter;
    }

    private void deployfilterZoneToNfa(NfaInfoForm nfaInfoForm) {
        List<IFeature> deployFilterDataZonesData = this.filterToDeployData.getFilterZonesToDeployData().get(this.logicDev.getDeviceId());
        if (deployFilterDataZonesData != null && !deployFilterDataZonesData.isEmpty()) {
            for (IFeature feature : deployFilterDataZonesData) {
                String errorCode = "";
                FilterZoneData filterZoneData = (FilterZoneData)feature;
                ZoneInfoForm zoneInfoForm = filterZoneData.getZoneInfoForm();
                Long zoneId = zoneInfoForm.getZoneId();
                if (0L == zoneId) {
                    return;
                }
                Long deviceId = nfaInfoForm.getDeviceId();
                Long preference = this.getPreference(filterZoneData.getFilterInfo().getPkid(), zoneId, filterZoneData.getDirection());
                filterZoneData.setPreference(preference);
                this.logger.info((Object)("pre deploy filterZone by deploy,  deviceId : " + deviceId + ", zoneId : " + zoneId + ", filterId : " + filterZoneData.getFilterInfo().getPkid()));
                FilterDevicePair filterDevicePair = new FilterDevicePair(filterZoneData.getFilterInfo().getPkid(), deviceId);
                if (this.filterDeployResult.get(filterDevicePair) != null) {
                    errorCode = this.filterDeployResult.get(filterDevicePair);
                }
                try {
                    if ("".equals(errorCode) && this.isDeviceConnectedOK.booleanValue()) {
                        Result result = this.deployZonePolicyToNfa(filterZoneData, nfaInfoForm);
                        if (result.getStatusCode() == 200 && result.getJson().contains("ok")) {
                            errorCode = "";
                            this.zoneFeatureStatusService.createOrUpdateZoneIpFeatureStatus(zoneInfoForm, deviceId);
                        } else {
                            errorCode = "lego.err.631039";
                        }
                    }
                }
                catch (LegoCheckedException e) {
                    this.logger.error((Object)"deploy filter by deploy error, ", (Throwable)e);
                    this.isDeviceConnectedOK = false;
                    errorCode = "lego.err." + e.getErrorCode();
                }
                catch (Exception e) {
                    this.logger.error((Object)"deploy filter by deploy error, ", (Throwable)e);
                    errorCode = "lego.err.631039";
                }
                this.checkFilterZoneResult(filterZoneData.getFilterInfo().getPkid(), filterZoneData.getZoneInfoForm().getZoneId(), errorCode, true, filterZoneData.getDirection());
            }
        }
    }

    private Result deployZonePolicyToNfa(FilterZoneData filterZoneData, NfaInfoForm nfaInfoForm) {
        int i;
        PolicyObject[] policyObject;
        FilterPolicyObject filterPolicyObject;
        List<NfaPolicyForm> nfaPolicyForms;
        Result result = null;
        INfaPolicyService nfaPolicyService = (INfaPolicyService)ServiceContext.getInstance().getService("nfaPolicyService", INfaPolicyService.class);
        this.licenseOutboundService = (ILicenseOutboundService)ServiceContext.getInstance().getService("licenseOutboundService", ILicenseOutboundService.class);
        FormTransObject formTransObject = new FormTransObject();
        ZoneInfoObject zoneInfoObject = new ZoneInfoObject();
        ZonePolicyObject zonePolicyObject = new ZonePolicyObject();
        ZoneInfoForm zoneInfoForm = filterZoneData.getZoneInfoForm();
        if (null == zoneInfoForm) {
            return result;
        }
        if (zoneInfoForm.getZoneType().intValue() == Constant.ZONE_TYPE_OF_DEFAULT.intValue()) {
            zoneInfoObject.setZoneName("default");
            zoneInfoObject.setZoneId(1L);
        } else {
            zoneInfoObject.setZoneName(zoneInfoForm.getZoneName());
            zoneInfoObject.setZoneId(zoneInfoForm.getZoneId().longValue());
        }
        List<NfaPolicyForm> nfaOutboundPolicyForms = null;
        Long zoneId = zoneInfoForm.getZoneId();
        Long deviceId = this.logicDev.getDeviceId();
        Long clusterId = nfaInfoForm.getClusterId();
        if (null != clusterId) {
            nfaPolicyForms = nfaPolicyService.getNfaPolicyForm(zoneId, clusterId);
            nfaOutboundPolicyForms = nfaPolicyService.getOutboundNfaPolicyForm(zoneId, clusterId);
        } else {
            nfaPolicyForms = nfaPolicyService.getNfaPolicyForm(zoneId, deviceId);
            nfaOutboundPolicyForms = nfaPolicyService.getOutboundNfaPolicyForm(zoneId, deviceId);
        }
        if (this.licenseOutboundService.isSupportOutbound()) {
            filterPolicyObject = InitNfaDeployData.queryFilterData(zoneId, deviceId, 2);
            zonePolicyObject.setFilterOut(filterPolicyObject);
        }
        filterPolicyObject = InitNfaDeployData.queryFilterData(zoneId, deviceId, 1);
        zonePolicyObject.setFilterIn(filterPolicyObject);
        if (null != nfaPolicyForms && !nfaPolicyForms.isEmpty()) {
            policyObject = new PolicyObject[nfaPolicyForms.size()];
            i = 0;
            for (NfaPolicyForm nfaPolicyForm : nfaPolicyForms) {
                policyObject[i] = formTransObject.nfaPolicyFormTransfObject(nfaPolicyForm);
                ++i;
            }
            ZoneUtil.addNfaZoneType(zonePolicyObject, zoneInfoForm.getZoneId());
            zonePolicyObject.setPolicyIn(policyObject);
        }
        if (null != nfaOutboundPolicyForms && !nfaOutboundPolicyForms.isEmpty()) {
            policyObject = new PolicyObject[nfaOutboundPolicyForms.size()];
            i = 0;
            for (NfaPolicyForm nfaPolicyForm : nfaOutboundPolicyForms) {
                policyObject[i] = formTransObject.nfaPolicyFormTransfObject(nfaPolicyForm);
                ++i;
            }
            ZoneUtil.addNfaZoneType(zonePolicyObject, zoneInfoForm.getZoneId());
            zonePolicyObject.setPolicyOut(policyObject);
        }
        try {
            result = this.restfulNfaService.addZoneOnNFA(zoneInfoObject, nfaInfoForm);
            if (result.getStatusCode() == 200 && result.getJson().contains("ok")) {
                result = this.restfulNfaService.restNfaZonePolicy(zonePolicyObject, nfaInfoForm);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e);
        }
        return result;
    }

    private void deployFilterToDevice() {
        List<IFeature> deployFilterData = this.filterToDeployData.getFilterInfoToDeployData().get(this.logicDev.getDeviceId());
        if (deployFilterData != null && !deployFilterData.isEmpty()) {
            for (int i = 0; i < deployFilterData.size(); ++i) {
                IFeature feature = deployFilterData.get(i);
                FilterData filterData = (FilterData)feature;
                this.logger.info((Object)("pre deploy filter by deploy,  deviceId : " + this.logicDev.getDeviceId() + ", filterId : " + filterData.getFilterInfo().getPkid()));
                String errorCode = "lego.err.631039";
                try {
                    if (this.isDeviceConnectedOK.booleanValue() || i == 0) {
                        List cmdResultList = (List)filterData.doDeploy(this.logicDev, null);
                        errorCode = this.checkCmdResultList(cmdResultList);
                    }
                }
                catch (LegoCheckedException e) {
                    this.logger.error((Object)"deploy filter by deploy error, ", (Throwable)e);
                    this.isDeviceConnectedOK = false;
                    errorCode = e.getErrorCode() == 0L ? e.getMessage() : "lego.err." + e.getErrorCode();
                }
                catch (Exception e) {
                    this.logger.error((Object)"deploy filter by deploy error, ", (Throwable)e);
                    errorCode = "lego.err.631039";
                }
                this.checkFilterResult(filterData.getFeatureId(), errorCode, true);
            }
        }
    }

    private void deployFilterZoneToDevice() {
        List<IFeature> deployFilterDataZonesData = this.filterToDeployData.getFilterZonesToDeployData().get(this.logicDev.getDeviceId());
        if (deployFilterDataZonesData != null && !deployFilterDataZonesData.isEmpty()) {
            for (IFeature feature : deployFilterDataZonesData) {
                String errorCode = "";
                FilterZoneData filterZoneData = (FilterZoneData)feature;
                Long zoneId = filterZoneData.getZoneInfoForm().getZoneId();
                if (zoneId != 0L) {
                    Long preference = this.getPreference(filterZoneData.getFilterInfo().getPkid(), zoneId, filterZoneData.getDirection());
                    filterZoneData.setPreference(preference);
                }
                this.logger.info((Object)("pre deploy filterZone by deploy,  deviceId : " + this.logicDev.getDeviceId() + ", zoneId : " + zoneId + ", filterId : " + filterZoneData.getFilterInfo().getPkid()));
                FilterDevicePair filterDevicePair = new FilterDevicePair(filterZoneData.getFilterInfo().getPkid(), this.logicDev.getDeviceId());
                if (this.filterDeployResult.get(filterDevicePair) != null && !AticUtil.isNull((String)(errorCode = this.filterDeployResult.get(filterDevicePair)))) {
                    this.logger.info((Object)("filterDeployResult errorCode is :" + this.getcleanedMessage(errorCode)));
                    this.checkFilterZoneResult(filterZoneData.getFilterInfo().getPkid(), zoneId, errorCode, true, filterZoneData.getDirection());
                    continue;
                }
                List cmdResultList = null;
                try {
                    if ("".equals(errorCode) && this.isDeviceConnectedOK.booleanValue()) {
                        cmdResultList = (List)filterZoneData.doDeploy(this.logicDev, null);
                        errorCode = this.checkCmdResultList(cmdResultList);
                    } else {
                        errorCode = "lego.err.631039";
                    }
                }
                catch (LegoCheckedException e) {
                    this.logger.error((Object)"deploy filter by deploy error, ", (Throwable)e);
                    this.isDeviceConnectedOK = false;
                    errorCode = "lego.err." + e.getErrorCode();
                }
                catch (Exception e) {
                    errorCode = "lego.err.631039";
                }
                this.checkFilterZoneResult(filterZoneData.getFilterInfo().getPkid(), zoneId, errorCode, true, filterZoneData.getDirection());
            }
        }
    }

    private void unDeployFilterFromDevice() {
        List<IFeature> unDeployFilterData = this.filterToDeployData.getFilterInfoToUnDeployData().get(this.logicDev.getDeviceId());
        if (unDeployFilterData != null && !unDeployFilterData.isEmpty()) {
            for (IFeature feature : unDeployFilterData) {
                FilterData filterData;
                String errorCode;
                block6: {
                    errorCode = "";
                    filterData = (FilterData)feature;
                    this.logger.info((Object)("pre undeploy filter by deploy,  deviceId : " + this.logicDev.getDeviceId() + ", filterId : " + filterData.getFilterInfo().getPkid()));
                    try {
                        if (this.isDeviceConnectedOK.booleanValue()) {
                            filterData.doUndeploy(this.logicDev, null);
                            break block6;
                        }
                        this.logger.info((Object)("deploy filter isDeviceConnectedOK is" + this.isDeviceConnectedOK));
                        break;
                    }
                    catch (LegoCheckedException e) {
                        this.logger.error((Object)"deploy filter by deploy error, ", (Throwable)e);
                        this.isDeviceConnectedOK = false;
                        errorCode = "lego.err." + e.getErrorCode();
                    }
                    catch (Exception e) {
                        errorCode = "lego.err.631039";
                    }
                }
                this.checkFilterResult(filterData.getFeatureId(), errorCode, false);
            }
        }
    }

    private void unDeployFilterFromNfa(NfaInfoForm nfaInfoForm) {
        List<IFeature> unDeployFilterData = this.filterToDeployData.getFilterInfoToUnDeployData().get(this.logicDev.getDeviceId());
        if (unDeployFilterData != null && !unDeployFilterData.isEmpty()) {
            for (IFeature feature : unDeployFilterData) {
                String errorCode = "";
                FilterData filterData = (FilterData)feature;
                this.logger.info((Object)("pre undeploy filter by undeploy,  deviceId : " + this.logicDev.getDeviceId() + ", filterId : " + filterData.getFilterInfo().getPkid()));
                DefinedFilter definedFilter = new DefinedFilter();
                definedFilter.setFilterId(filterData.getFilterInfo().getFilterId());
                try {
                    errorCode = this.getZoneDeployFromFilterErr(filterData.getFilterInfo().getPkid());
                    if ("".equals(errorCode) && this.isDeviceConnectedOK.booleanValue()) {
                        Result result = this.restfulNfaService.restNfaDelDefinedFilter(definedFilter, nfaInfoForm);
                        errorCode = this.getNfaErrorCode(result);
                    }
                }
                catch (LegoCheckedException e) {
                    this.logger.error((Object)"deploy filter by deploy error, ", (Throwable)e);
                    this.isDeviceConnectedOK = false;
                    errorCode = "lego.err." + e.getErrorCode();
                }
                catch (Exception e) {
                    errorCode = "lego.err.631039";
                }
                this.checkFilterResult(filterData.getFeatureId(), errorCode, false);
            }
        }
    }

    private String getZoneDeployFromFilterErr(Long filterId) {
        for (Map.Entry<FilterDeviceZonePair, String> deployResult : this.filterZoneUnDeployResult.entrySet()) {
            if (!deployResult.getKey().getFilterId().equals(filterId) || !deployResult.getKey().getDeviceId().equals(this.logicDev.getDeviceId()) || deployResult.getValue() == null || "".equals(deployResult.getValue())) continue;
            return deployResult.getValue();
        }
        return "";
    }

    private void unDeployFilterZoneFromNfa(NfaInfoForm nfaInfoForm) {
        List<IFeature> unDeployFilterDataZonesData = this.filterToDeployData.getFilterZonesToUnDeployData().get(this.logicDev.getDeviceId());
        if (unDeployFilterDataZonesData != null && !unDeployFilterDataZonesData.isEmpty()) {
            String errorCode = "";
            try {
                if (this.isDeviceConnectedOK.booleanValue()) {
                    Result result = this.unDeployZonePolicyToNfa(unDeployFilterDataZonesData, nfaInfoForm);
                    errorCode = this.getNfaErrorCode(result);
                } else {
                    errorCode = "lego.err.631039";
                }
            }
            catch (LegoCheckedException e) {
                this.logger.error((Object)"deploy filter by deploy error, ", (Throwable)e);
                this.isDeviceConnectedOK = false;
                errorCode = "lego.err." + e.getErrorCode();
            }
            catch (Exception e) {
                errorCode = "lego.err.631039";
            }
            for (IFeature feature : unDeployFilterDataZonesData) {
                FilterZoneData filterZoneData = (FilterZoneData)feature;
                this.logger.info((Object)("pre undeploy filterZone by undeploy,  deviceId : " + this.logicDev.getDeviceId() + "zoneId : " + filterZoneData.getZoneInfoForm().getZoneId() + ", filterId : " + filterZoneData.getFilterInfo().getPkid()));
                this.checkFilterZoneResult(filterZoneData.getFilterInfo().getPkid(), filterZoneData.getZoneInfoForm().getZoneId(), errorCode, false, filterZoneData.getDirection());
            }
        }
    }

    private Result unDeployZonePolicyToNfa(List<IFeature> unDeployFilterDataZonesData, NfaInfoForm nfaInfoForm) {
        int i;
        PolicyObject[] policyObject;
        FormTransObject formTransObject;
        FilterPolicyObject filterPolicyObject;
        Result result = new Result();
        INfaPolicyService nfaPolicyService = (INfaPolicyService)ServiceContext.getInstance().getService("nfaPolicyService", INfaPolicyService.class);
        this.licenseOutboundService = (ILicenseOutboundService)ServiceContext.getInstance().getService("licenseOutboundService", ILicenseOutboundService.class);
        if (null == nfaPolicyService) {
            this.logger.error((Object)"unDeployZonePolicyToNfa(), nfaPolicyService is null.");
            return result;
        }
        ZoneInfoForm zoneInfoForm = null;
        for (IFeature feature : unDeployFilterDataZonesData) {
            FilterZoneData filterZoneData = (FilterZoneData)feature;
            zoneInfoForm = filterZoneData.getZoneInfoForm();
        }
        if (null == zoneInfoForm) {
            this.logger.error((Object)"unDeployZonePolicyToNfa(), zoneInfoForm is null.");
            return result;
        }
        List<NfaPolicyForm> nfaOutboundPolicyForms = null;
        ZonePolicyObject zonePolicyObject = new ZonePolicyObject();
        zonePolicyObject.setZoneId(zoneInfoForm.getZoneId().longValue());
        Long zoneId = zoneInfoForm.getZoneId();
        if (0L == zoneId) {
            result.setJson("ok");
            result.setStatusCode(200);
            return result;
        }
        Long deviceId = nfaInfoForm.getDeviceId();
        List<NfaPolicyForm> nfaPolicyForms = nfaPolicyService.getNfaPolicyForm(zoneId, this.logicDev.getDeviceId());
        nfaOutboundPolicyForms = nfaPolicyService.getOutboundNfaPolicyForm(zoneId, deviceId);
        if (this.licenseOutboundService.isSupportOutbound()) {
            filterPolicyObject = InitNfaDeployData.queryFilterData(zoneId, deviceId, 2);
            zonePolicyObject.setFilterOut(filterPolicyObject);
        }
        filterPolicyObject = InitNfaDeployData.queryFilterData(zoneId, deviceId, 1);
        zonePolicyObject.setFilterIn(filterPolicyObject);
        if (null != nfaPolicyForms && !nfaPolicyForms.isEmpty()) {
            formTransObject = new FormTransObject();
            policyObject = new PolicyObject[nfaPolicyForms.size()];
            i = 0;
            for (NfaPolicyForm nfaPolicyForm : nfaPolicyForms) {
                policyObject[i] = formTransObject.nfaPolicyFormTransfObject(nfaPolicyForm);
                ++i;
            }
            zonePolicyObject.setPolicyIn(policyObject);
        }
        if (null != nfaOutboundPolicyForms && !nfaOutboundPolicyForms.isEmpty()) {
            formTransObject = new FormTransObject();
            policyObject = new PolicyObject[nfaOutboundPolicyForms.size()];
            i = 0;
            for (NfaPolicyForm nfaPolicyForm : nfaOutboundPolicyForms) {
                policyObject[i] = formTransObject.nfaPolicyFormTransfObject(nfaPolicyForm);
                ++i;
            }
            zonePolicyObject.setPolicyOut(policyObject);
        }
        try {
            result = this.restfulNfaService.restNfaZonePolicy(zonePolicyObject, nfaInfoForm);
        }
        catch (Exception e) {
            this.logger.error((Object)e);
        }
        return result;
    }

    private void unDeployFilterZoneFromDevice() {
        List<IFeature> unDeployFilterDataZonesData = this.filterToDeployData.getFilterZonesToUnDeployData().get(this.logicDev.getDeviceId());
        if (unDeployFilterDataZonesData != null && !unDeployFilterDataZonesData.isEmpty()) {
            for (IFeature feature : unDeployFilterDataZonesData) {
                Long zoneId;
                FilterZoneData filterZoneData;
                String errorCode;
                block6: {
                    errorCode = "";
                    filterZoneData = (FilterZoneData)feature;
                    zoneId = filterZoneData.getZoneInfoForm().getZoneId();
                    this.logger.info((Object)("pre undeploy filterZone by deploy,  deviceId : " + this.logicDev.getDeviceId() + "zoneId : " + zoneId + ", filterId : " + filterZoneData.getFilterInfo().getPkid()));
                    try {
                        if (this.isDeviceConnectedOK.booleanValue()) {
                            List cmdResultList = (List)filterZoneData.doUndeploy(this.logicDev, null);
                            errorCode = this.checkCmdResultList(cmdResultList);
                            break block6;
                        }
                        this.logger.info((Object)("deploy filter isDeviceConnectedOK is" + this.isDeviceConnectedOK));
                        break;
                    }
                    catch (LegoCheckedException e) {
                        this.logger.error((Object)"deploy filter by deploy error, ", (Throwable)e);
                        this.isDeviceConnectedOK = false;
                        errorCode = "lego.err." + e.getErrorCode();
                    }
                    catch (Exception e) {
                        errorCode = "lego.err.631039";
                    }
                }
                this.checkFilterZoneResult(filterZoneData.getFilterInfo().getPkid(), zoneId, errorCode, false, filterZoneData.getDirection());
            }
        }
    }

    private String checkCmdResultList(List<String> cmdResultList) {
        if (null == cmdResultList) {
            return "";
        }
        int count = 0;
        Iterator<String> iterator = cmdResultList.iterator();
        while (iterator.hasNext()) {
            String resultStringTemp;
            String resultString = resultStringTemp = iterator.next();
            resultString = resultString.toLowerCase(Locale.ENGLISH);
            ++count;
            if ("".equals(resultString)) continue;
            for (Map.Entry<String, String> entry : this.errorMapping.entrySet()) {
                String key = entry.getKey().toLowerCase(Locale.ENGLISH);
                Pattern p = Pattern.compile(key);
                Matcher matcher = p.matcher(resultString);
                if (!matcher.find()) continue;
                if ("lego.err.631003".equals(entry.getValue()) && count == 3) {
                    Pattern p1 = Pattern.compile("-filter-");
                    Matcher matcher1 = p1.matcher(resultString);
                    if (matcher1.find()) continue;
                    return entry.getValue();
                }
                return entry.getValue();
            }
        }
        return "";
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private void checkFilterResult(Long filterId, String errorCode, boolean isDeploy) {
        FilterDevicePair filterDevicePair = new FilterDevicePair(filterId, this.logicDev.getDeviceId());
        if (isDeploy) {
            this.logger.info((Object)("deploy filter by deploy,  deviceId : " + this.logicDev.getDeviceId() + ", filterId : " + filterId + ", errorcode : " + this.getcleanedMessage(errorCode)));
            this.filterDeployResult.put(filterDevicePair, errorCode);
        } else {
            this.logger.info((Object)("undeploy filter by deploy,  deviceId : " + this.logicDev.getDeviceId() + ", filterId : " + filterId + ", errorcode : " + this.getcleanedMessage(errorCode)));
            this.filterUnDeployResult.put(filterDevicePair, errorCode);
        }
    }

    private void checkFilterZoneResult(Long filterId, Long zoneId, String errorCode, boolean isDeploy, int direction) {
        int gloApplyFlag;
        int n = gloApplyFlag = zoneId == 0L ? 1 : 0;
        if ("lego.err.631042".equals(errorCode) && gloApplyFlag == 1) {
            errorCode = "lego.err.631071";
        }
        FilterDeviceZonePair filterDeviceZonePair = new FilterDeviceZonePair(zoneId, filterId, this.logicDev.getDeviceId(), direction, gloApplyFlag);
        if (isDeploy) {
            this.logger.info((Object)("deploy filterZone result by deploy,  zoneId : " + zoneId + ", deviceId : " + this.logicDev.getDeviceId() + " filterId : " + filterId + ", errorcode : " + this.getcleanedMessage(errorCode) + ", direction :" + direction));
            this.filterZoneDeployResult.put(filterDeviceZonePair, errorCode);
        } else {
            this.logger.info((Object)("undeploy filterZone result by deploy,  zoneId : " + zoneId + ", deviceId : " + this.logicDev.getDeviceId() + " filterId : " + filterId + ", errorcode : " + this.getcleanedMessage(errorCode)));
            this.filterZoneUnDeployResult.put(filterDeviceZonePair, errorCode);
        }
    }

    private Long getPreference(Long filterId, Long zoneId, int direction) {
        IFilterDeviceZoneInfoService service = (IFilterDeviceZoneInfoService)ServiceContext.getInstance().getService("filterDeviceZoneInfoService", IFilterDeviceZoneInfoService.class);
        return service.queryPreferenceByFilterIdAndZoneId(filterId, zoneId, direction);
    }

    public IZoneFeatureStatusService getZoneFeatureStatusService() {
        return this.zoneFeatureStatusService;
    }

    public void setZoneFeatureStatusService(IZoneFeatureStatusService zoneFeatureStatusService) {
        this.zoneFeatureStatusService = zoneFeatureStatusService;
    }

    public ILicenseOutboundService getLicenseOutboundService() {
        return this.licenseOutboundService;
    }

    public void setLicenseOutboundService(ILicenseOutboundService licenseOutboundService) {
        this.licenseOutboundService = licenseOutboundService;
    }
}

