/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.service.function.deploy;

import com.hs.atic.sdk.bis.service.IFoundDefaultIdService;
import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.atic.sdk.zone.service.IZoneService;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.secservice.ddos.common.FilterDeviceZonePair;
import com.hs.vsm.secservice.ddos.dao.ZoneDeviceDao;
import com.hs.vsm.secservice.ddos.policy.ref.ZoneReferUtil;
import com.hs.vsm.secservice.ddos.service.data.ConfigDataTools;
import com.hs.vsm.secservice.ddos.service.data.UpdateDeployStatusTools;
import com.hs.vsm.secservice.ddos.service.data.ZoneConfigData;
import com.hs.vsm.secservice.ddos.service.data.ZoneToDeployData;
import com.hs.vsm.secservice.ddos.service.function.Util;
import com.hs.vsm.secservice.ddos.service.function.deploy.FilterDeployCtrl;
import com.hs.vsm.secservice.ddos.service.function.deploy.FilterDeployInfo;
import com.hs.vsm.secservice.ddos.service.function.deploy.ZoneDeployData;
import com.hs.vsm.secservice.ddos.service.function.deploy.ZoneDeployThread;
import com.hs.vsm.secservice.nfa.restful.deploy.DeployNfaPolicy;
import com.hs.vsm.secservice.sdk.common.util.Pair;
import com.hs.vsm.secservice.sdk.common.util.ProgressBar;
import com.hs.vsm.secservice.sdk.common.util.ProgressMgr;
import com.hs.vsm.secservice.sdk.frame.model.IFeature;
import com.hs.vsm.secservice.sdk.frame.model.LogicDev;
import com.hs.vsm.secservice.sdk.module.ddos.Constant;
import com.hs.vsm.secservice.sdk.module.ddos.common.ZonePair;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.policy.third.service.ISynchronizDivertService;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ZoneDeployCtrl {
    private static final int SLLEEP_TIME = 1000;
    private static final int LOOP_COUNT = 100;
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private ConfigDataTools configDataTools;
    private IAticDeviceService aticDeviceService;
    private IFoundDefaultIdService foundDefaultIdService;
    private ZoneDeviceDao zoneDeviceDao;
    private UpdateDeployStatusTools updateDeployStatusTools;
    private FilterDeployCtrl filterDeployCtrl;
    private IZoneService zoneService;
    private DeployNfaPolicy deployNfaPolicy;

    public ZoneDeviceDao getZoneDeviceDao() {
        return this.zoneDeviceDao;
    }

    public void setZoneDeviceDao(ZoneDeviceDao zoneDeviceDao) {
        this.zoneDeviceDao = zoneDeviceDao;
    }

    public IZoneService getZoneService() {
        return this.zoneService;
    }

    public void setZoneService(IZoneService zoneService) {
        this.zoneService = zoneService;
    }

    public FilterDeployCtrl getFilterDeployCtrl() {
        return this.filterDeployCtrl;
    }

    public void setFilterDeployCtrl(FilterDeployCtrl filterDeployCtrl) {
        this.filterDeployCtrl = filterDeployCtrl;
    }

    public UpdateDeployStatusTools getUpdateDeployStatusTools() {
        return this.updateDeployStatusTools;
    }

    public void setUpdateDeployStatusTools(UpdateDeployStatusTools updateDeployStatusTools) {
        this.updateDeployStatusTools = updateDeployStatusTools;
    }

    private void initData(ZoneDeployData deployData, List<String> features, List<String> zoneIp) {
        this.logger.info((Object)"enter initData");
        ZoneConfigData zoneConfigData = this.configDataTools.initZoneConfigData(deployData.getZoneIdList(), deployData.getProgressBar(), features, zoneIp);
        deployData.setZoneConfigData(zoneConfigData);
        ZoneToDeployData zoneToDeployData = new ZoneToDeployData();
        zoneToDeployData.initToDeployData(zoneConfigData, features, zoneIp);
        Map<LogicDev, Map<Long, List<IFeature>>> toDeployData = zoneToDeployData.getToDeployData();
        deployData.setToDeployData(toDeployData);
        int totalStep = this.calcTotalSteps(toDeployData);
        this.logger.info((Object)("initData totalStep:" + totalStep));
        if (null != deployData.getProgressBar()) {
            deployData.getProgressBar().setTotalStep(totalStep + 6);
        }
        ThreadPoolExecutor threadPool = (ThreadPoolExecutor)Executors.newCachedThreadPool();
        deployData.setThreadPool(threadPool);
        this.logger.info((Object)"leave initData");
    }

    private IFoundDefaultIdService getFoundDefaultIdService() {
        for (int i = 0; null == this.foundDefaultIdService && i < 100; ++i) {
            try {
                this.foundDefaultIdService = ZoneReferUtil.getFoundDefaultIdService();
                Thread.sleep(1000L);
                continue;
            }
            catch (Exception e) {
                this.logger.error((Object)"", (Throwable)e);
            }
        }
        return this.foundDefaultIdService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDeploy(List<Long> zoneIdList, Long progressBarId, List<String> features, List<String> zoneIp) {
        this.logger.info((Object)"enter doDeploy");
        ZoneDeployData deployData = new ZoneDeployData();
        deployData.setZoneIdList(zoneIdList);
        this.logger.info((Object)("params zoneIdList:" + zoneIdList));
        ProgressBar progressBar = null;
        if (null == progressBarId) {
            progressBarId = System.currentTimeMillis() / 1000L;
        }
        progressBar = ProgressMgr.getInstance().createProgressBar(100, progressBarId);
        deployData.setProgressBar(progressBar);
        deployData.setProgressBarId(progressBarId);
        this.logger.info((Object)("params progressBarId:" + progressBarId));
        this.logger.info((Object)"---------------------------deployAllZone------------------------ :  initData start ");
        this.initData(deployData, features, zoneIp);
        this.logger.info((Object)"---------------------------deployAllZone------------------------ :  initData end ");
        ArrayList<Pair> pairs = new ArrayList<Pair>();
        try {
            this.getToDeployAdminPairs(pairs, deployData);
            this.logger.info((Object)("current pairs : " + this.getcleanedMessage(((Object)pairs).toString())));
            this.logger.info((Object)("=====submit thread start time : ===== " + System.currentTimeMillis()));
            if (null != deployData.getToDeployData() && !deployData.getToDeployData().isEmpty()) {
                for (Map.Entry<LogicDev, Map<Long, List<IFeature>>> deviceData : deployData.getToDeployData().entrySet()) {
                    if (this.escapeNFADevice(deviceData.getKey().getDeviceId()).booleanValue()) continue;
                    ZoneDeployThread task = new ZoneDeployThread(deviceData.getKey(), deviceData.getValue(), progressBar, deployData.getResult());
                    task.setServicePairToFeaturePairMap(deployData.getZoneConfigData().getServicePair2FeaturePair());
                    Future<?> future = deployData.getThreadPool().submit(task);
                }
                deployData.getThreadPool().shutdown();
                try {
                    if (deployData.getThreadPool().awaitTermination(1800L, TimeUnit.MINUTES)) {
                        this.logger.info((Object)"zone deploy thread execute finished.");
                    }
                }
                catch (InterruptedException e1) {
                    this.logger.error((Object)"zone deploy thread execute timeout.", (Throwable)e1);
                }
            }
            this.logger.info((Object)("=====submit thread end time : ===== " + System.currentTimeMillis()));
            if (null == features || features.contains(Constant.Feature.FilterData.toString()) || features.contains(Constant.Feature.FilterZoneData.toString())) {
                try {
                    this.deployFilter(deployData);
                }
                catch (Exception e) {
                    ProgressBar pbr = deployData.getProgressBar();
                    if (null != pbr && pbr.getTotalStep() > pbr.getCurrentStep()) {
                        pbr.next(pbr.getTotalStep() - pbr.getCurrentStep());
                    }
                    this.logger.error((Object)"deploy filter exception!", (Throwable)e);
                }
            }
            try {
                this.deployNfaPolicy.deployNfaPolicy(zoneIdList);
            }
            catch (Exception e) {
                this.logger.error((Object)("deployNfaPoliy error is" + e.getMessage()), (Throwable)e);
            }
            this.updateDeployStatusTools.updateDeployStatus(deployData);
            this.notifyRefeshDefaultZoneData(deployData);
            this.notifyRefeshDivertZone(deployData);
            this.dealRestfulDeployError(zoneIp, deployData);
        }
        finally {
            int currentStep;
            int totalStep;
            if (null != deployData.getProgressBar() && (totalStep = deployData.getProgressBar().getTotalStep()) > (currentStep = deployData.getProgressBar().getCurrentStep())) {
                progressBar.next(totalStep - currentStep);
            }
        }
        this.logger.info((Object)"leave doDeploy");
    }

    private void dealRestfulDeployError(List<String> zoneIp, ZoneDeployData deployData) {
        if (null != zoneIp) {
            Map<ZonePair, String> errorDetail = deployData.getResult().getErrorDetail();
            for (Map.Entry<ZonePair, Boolean> deviceResult : deployData.getResult().getZoneDeployResult().entrySet()) {
                String errorMsgKey = errorDetail.get(deviceResult.getKey());
                if (null == errorMsgKey || "--".equals(errorMsgKey)) continue;
                String[] split = errorMsgKey.split("\\.");
                if (split.length == 3) {
                    String string = errorMsgKey.split("\\.")[2];
                    throw new LegoCheckedException(Long.parseLong(string));
                }
                throw new LegoCheckedException(errorMsgKey);
            }
        }
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private void deployFilter(ZoneDeployData deployData) {
        this.logger.info((Object)"enter deployFilter");
        FilterDeployInfo filterDeployInfo = this.filterDeployCtrl.doDeployWithZone(deployData.getZoneIdList(), null, null, null);
        Map<FilterDeviceZonePair, String> zoneDeviceDeployMap = this.filterDeployCtrl.getZoneDeviceDeployMap(filterDeployInfo.getFilterZoneDeployResult(), filterDeployInfo.getFilterZoneUnDeployResult());
        for (Map.Entry<FilterDeviceZonePair, String> zoneDeviceDeployMapEntry : zoneDeviceDeployMap.entrySet()) {
            FilterDeviceZonePair filterDeviceZonePair = zoneDeviceDeployMapEntry.getKey();
            String errorCode = zoneDeviceDeployMapEntry.getValue();
            if ("".equals(errorCode)) continue;
            ZonePair zonePair = new ZonePair(filterDeviceZonePair.getDeviceId(), filterDeviceZonePair.getZoneId());
            deployData.getResult().getZoneDeployResult().put(zonePair, false);
        }
        Util.getInstance().processNext(deployData);
        this.logger.info((Object)"leave deployFilter");
    }

    private void notifyRefeshDivertZone(ZoneDeployData deployData) {
        ISynchronizDivertService synchronizDivertService = ZoneReferUtil.getSynchronizDivertService();
        try {
            Map<Long, ZoneInfoForm> zoneInfoMap = deployData.getZoneConfigData().getZoneInfoMap();
            Map<ZonePair, Boolean> resultMap = deployData.getResult().getZoneDeployResult();
            for (Map.Entry<ZonePair, Boolean> entry : resultMap.entrySet()) {
                ZonePair zonePair = entry.getKey();
                Long zoneId = zonePair.getZoneId();
                Long devId = zonePair.getDeviceId();
                for (Map.Entry<Long, ZoneInfoForm> zoneInfo : zoneInfoMap.entrySet()) {
                    if (!zoneId.equals(zoneInfo.getKey()) || !Constant.ZONE_TYPE_OF_DEFAULT.equals(zoneInfo.getValue().getZoneType())) continue;
                    synchronizDivertService.synchronizDivert(zoneId, devId, 3);
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("RefeshDivertZoneData error : " + e));
        }
    }

    private void notifyRefeshDefaultZoneData(ZoneDeployData deployData) {
        try {
            Boolean hasDefaultZone = false;
            Map<Long, ZoneInfoForm> zoneInfoMap = deployData.getZoneConfigData().getZoneInfoMap();
            for (Map.Entry<Long, ZoneInfoForm> entry : zoneInfoMap.entrySet()) {
                if (!Constant.ZONE_TYPE_OF_DEFAULT.equals(entry.getValue().getZoneType())) continue;
                hasDefaultZone = true;
            }
            if (hasDefaultZone.booleanValue()) {
                this.getFoundDefaultIdService().refeshDefaultZoneData();
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("refeshDefaultZoneData error : " + e));
        }
    }

    private Boolean escapeNFADevice(Long deviceId) {
        AticDevice device = this.aticDeviceService.getDeviceByMoid(deviceId.longValue());
        if (null != device && (5 == device.getDeviceType() || 7 == device.getDeviceType())) {
            return true;
        }
        return false;
    }

    private void getToDeployAdminPairs(List<Pair> pairs, ZoneDeployData deployData) {
        if (null != deployData.getToDeployData() && !deployData.getToDeployData().isEmpty()) {
            for (Map.Entry<LogicDev, Map<Long, List<IFeature>>> deviceData : deployData.getToDeployData().entrySet()) {
                if (null == deviceData.getValue() || deviceData.getValue().isEmpty()) continue;
                for (Map.Entry<Long, List<IFeature>> zoneData : deviceData.getValue().entrySet()) {
                    Pair pair = new Pair(zoneData.getKey(), deviceData.getKey().getDeviceId());
                    if (pairs.contains(pair)) continue;
                    pairs.add(pair);
                }
            }
        }
    }

    private int calcTotalSteps(Map<LogicDev, Map<Long, List<IFeature>>> toDeployData) {
        this.logger.info((Object)"enter calcTotalSteps");
        int steps = 0;
        for (Map.Entry<LogicDev, Map<Long, List<IFeature>>> deviceData : toDeployData.entrySet()) {
            int zoneCount = 0;
            for (Map.Entry<Long, List<IFeature>> zoneData : deviceData.getValue().entrySet()) {
                zoneCount += zoneData.getValue().size();
            }
            steps += zoneCount;
        }
        this.logger.info((Object)"leave calcTotalSteps");
        return steps;
    }

    public ConfigDataTools getConfigDataTools() {
        return this.configDataTools;
    }

    public void setConfigDataTools(ConfigDataTools configDataTools) {
        this.configDataTools = configDataTools;
    }

    public void deployEachZone(Long progressBarId) {
        this.logger.info((Object)("deployEachZone start: " + new Date(System.currentTimeMillis())));
        List<Long> allZoneId = this.zoneDeviceDao.getZoneIdHaveDevice();
        try {
            try {
                this.doDeploy(allZoneId, progressBarId, null, null);
            }
            catch (Exception e) {
                this.logger.error((Object)"doDeploy each zone error", (Throwable)e);
                this.logger.error((Object)"---------------------------deployAllZone------------------------ : ", (Throwable)e);
            }
            this.logger.info((Object)("deployEachZone end: " + new Date(System.currentTimeMillis())));
        }
        catch (Exception e) {
            this.logger.error((Object)"deployEachZone total error", (Throwable)e);
        }
    }

    public void setAticDeviceService(IAticDeviceService aticDeviceService) {
        this.aticDeviceService = aticDeviceService;
    }

    public IAticDeviceService getAticDeviceService() {
        return this.aticDeviceService;
    }

    public DeployNfaPolicy getDeployNfaPolicy() {
        return this.deployNfaPolicy;
    }

    public void setDeployNfaPolicy(DeployNfaPolicy deployNfaPolicy) {
        this.deployNfaPolicy = deployNfaPolicy;
    }
}

