/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.service.function.undeploy;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.secservice.ddos.common.FilterDevicePair;
import com.hs.vsm.secservice.ddos.common.FilterDeviceZonePair;
import com.hs.vsm.secservice.ddos.common.ZoneDevicePair;
import com.hs.vsm.secservice.ddos.dao.FilterDeviceDao;
import com.hs.vsm.secservice.ddos.dao.FilterDeviceZoneInfoDao;
import com.hs.vsm.secservice.ddos.dao.FilterDeviceZoneStatusDao;
import com.hs.vsm.secservice.ddos.dao.ZoneDeviceDeployStatusDao;
import com.hs.vsm.secservice.ddos.dao.ZoneFeatureStatusDao;
import com.hs.vsm.secservice.ddos.dao.ZonePolicyApplyDao;
import com.hs.vsm.secservice.ddos.model.FilterDeviceInfo;
import com.hs.vsm.secservice.ddos.model.FilterDeviceZoneInfo;
import com.hs.vsm.secservice.ddos.model.FilterDeviceZoneStatusInfo;
import com.hs.vsm.secservice.ddos.model.ZoneDeviceDeployStatusInfo;
import com.hs.vsm.secservice.ddos.model.ZoneFeatureStatusInfo;
import com.hs.vsm.secservice.ddos.model.ZonePolicyApplyInfo;
import com.hs.vsm.secservice.ddos.service.data.FilterConfigData;
import com.hs.vsm.secservice.ddos.service.data.FilterConfigDataTool;
import com.hs.vsm.secservice.ddos.service.data.FilterToDeployDataTool;
import com.hs.vsm.secservice.ddos.service.data.FilterToUnDeployData;
import com.hs.vsm.secservice.ddos.service.function.undeploy.FilterUnDeployInfo;
import com.hs.vsm.secservice.ddos.service.function.undeploy.FilterUnDeployThread;
import com.hs.vsm.secservice.policyengine.commandutil.CrcUtil;
import com.hs.vsm.secservice.sdk.common.util.ProgressBar;
import com.hs.vsm.secservice.sdk.common.util.VsmUtil;
import com.hs.vsm.secservice.sdk.frame.model.LogicDev;
import com.hs.vsm.secservice.sdk.module.ddos.form.FilterForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneDeviceDeployStatusForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneModifyDetailForm;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZonePolicyApplyService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZonePolicyMgrService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class FilterUnDeployCtrl {
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private FilterConfigDataTool filterConfigDataTool;
    private FilterToDeployDataTool filterToDeployDataTool = new FilterToDeployDataTool();
    private FilterDeviceZoneInfoDao filterDeviceZoneInfoDao;
    private FilterDeviceZoneStatusDao filterDeviceZoneStatusDao;
    private FilterDeviceDao filterDeviceDao;
    private ZoneFeatureStatusDao zoneFeatureStatusDao;
    private ZoneDeviceDeployStatusDao zoneDeviceDeployStatusDao;
    private ZonePolicyApplyDao zonePolicyApplyDao;
    private IZonePolicyApplyService zonePolicyApplyService;
    private IZonePolicyMgrService zonePolicyMgrService;

    public void doUnDeployWithZone(List<Long> zoneIdList, Long progressBarId, ProgressBar progressBar, Long adminId) {
        ArrayList<FilterDeviceZonePair> undeployFilterDeviceZonePairTempList = new ArrayList<FilterDeviceZonePair>();
        HashMap<Long, Set<Long>> deviceUnDeployFilterMap = new HashMap<Long, Set<Long>>();
        for (Long zoneId : zoneIdList) {
            List<FilterDeviceZoneStatusInfo> filterDeviceZoneStatusInfoList = this.filterDeviceZoneStatusDao.getDeployedByZoneId(zoneId);
            for (FilterDeviceZoneStatusInfo filterDeviceZoneStatusInfo : filterDeviceZoneStatusInfoList) {
                if (deviceUnDeployFilterMap.get(filterDeviceZoneStatusInfo.getDeviceId()) == null) {
                    deviceUnDeployFilterMap.put(filterDeviceZoneStatusInfo.getDeviceId(), new HashSet());
                }
                ((Set)deviceUnDeployFilterMap.get(filterDeviceZoneStatusInfo.getDeviceId())).add(filterDeviceZoneStatusInfo.getFilterId());
                this.logger.info((Object)("pre undeploy filter with zone, deviceId : " + filterDeviceZoneStatusInfo.getDeviceId() + ", filterId : " + filterDeviceZoneStatusInfo.getFilterId()));
            }
            this.filterDeviceZoneStatusDao.deleteListByZoneId(zoneId);
        }
        FilterUnDeployInfo filterUnDeployInfo = new FilterUnDeployInfo();
        filterUnDeployInfo.setProgressBar(progressBar);
        filterUnDeployInfo.setProgressBarId(progressBarId);
        this.doUnDeploy(undeployFilterDeviceZonePairTempList, deviceUnDeployFilterMap, filterUnDeployInfo, adminId, false);
    }

    public void doUnDeployWithZone(Long zoneId, List<Long> deviceIdList, Long progressBarId, ProgressBar progressBar, Long adminId) {
        ArrayList<FilterDeviceZonePair> undeployFilterDeviceZonePairTempList = new ArrayList<FilterDeviceZonePair>();
        HashMap<Long, Set<Long>> deviceUnDeployFilterMap = new HashMap<Long, Set<Long>>();
        for (Long deviceId : deviceIdList) {
            List<FilterDeviceZoneStatusInfo> filterDeviceZoneStatusInfoList = this.filterDeviceZoneStatusDao.getDeployedByZoneIdAndDeviceId(zoneId, deviceId);
            for (FilterDeviceZoneStatusInfo filterDeviceZoneStatusInfo : filterDeviceZoneStatusInfoList) {
                if (deviceUnDeployFilterMap.get(filterDeviceZoneStatusInfo.getDeviceId()) == null) {
                    deviceUnDeployFilterMap.put(filterDeviceZoneStatusInfo.getDeviceId(), new HashSet());
                }
                ((Set)deviceUnDeployFilterMap.get(filterDeviceZoneStatusInfo.getDeviceId())).add(filterDeviceZoneStatusInfo.getFilterId());
                this.logger.info((Object)("pre undeploy failter with zone, deviceId : " + filterDeviceZoneStatusInfo.getDeviceId() + ", filterId : " + filterDeviceZoneStatusInfo.getFilterId()));
            }
            this.filterDeviceZoneStatusDao.deleteByDeviceIdAndZoneId(deviceId, zoneId);
        }
        FilterUnDeployInfo filterUnDeployInfo = new FilterUnDeployInfo();
        filterUnDeployInfo.setProgressBar(progressBar);
        filterUnDeployInfo.setProgressBarId(progressBarId);
        this.doUnDeploy(undeployFilterDeviceZonePairTempList, deviceUnDeployFilterMap, filterUnDeployInfo, adminId, false);
    }

    public void doUnDeployWithFilter(List<Long> filterIdList, Long progressBarId, ProgressBar progressBar, Long adminId) {
        ArrayList<FilterDeviceZonePair> undeployFilterDeviceZonePairTempList = new ArrayList<FilterDeviceZonePair>();
        HashMap<Long, Set<Long>> deviceUnDeployFilterMap = new HashMap<Long, Set<Long>>();
        HashSet<Long> deployedZoneIdSet = new HashSet<Long>();
        for (Long filterId : filterIdList) {
            Object filterDeviceZoneStatusInfo2;
            List<FilterDeviceInfo> filterDeviceInfoList = this.filterDeviceDao.getByFilterId(filterId);
            if (filterDeviceInfoList != null && !filterDeviceInfoList.isEmpty()) {
                for (FilterDeviceInfo filterDeviceInfo : filterDeviceInfoList) {
                    if (deviceUnDeployFilterMap.get(filterDeviceInfo.getDeviceId()) == null) {
                        deviceUnDeployFilterMap.put(filterDeviceInfo.getDeviceId(), new HashSet());
                    }
                    ((Set)deviceUnDeployFilterMap.get(filterDeviceInfo.getDeviceId())).add(filterDeviceInfo.getFilterId());
                }
            }
            List<FilterDeviceZoneStatusInfo> filterDeviceZoneStatusInfoList = this.filterDeviceZoneStatusDao.getDeployedByFilterId(filterId);
            for (Object filterDeviceZoneStatusInfo2 : filterDeviceZoneStatusInfoList) {
                FilterDeviceZonePair filterDeviceZonePair = new FilterDeviceZonePair(((FilterDeviceZoneStatusInfo)filterDeviceZoneStatusInfo2).getZoneId(), ((FilterDeviceZoneStatusInfo)filterDeviceZoneStatusInfo2).getFilterId(), ((FilterDeviceZoneStatusInfo)filterDeviceZoneStatusInfo2).getDeviceId(), ((FilterDeviceZoneStatusInfo)filterDeviceZoneStatusInfo2).getDirection());
                undeployFilterDeviceZonePairTempList.add(filterDeviceZonePair);
                deployedZoneIdSet.add(((FilterDeviceZoneStatusInfo)filterDeviceZoneStatusInfo2).getZoneId());
                this.logger.info((Object)("pre undeploy failter with zone : " + filterDeviceZonePair.toString()));
            }
            List<FilterDeviceZoneInfo> list = this.filterDeviceZoneInfoDao.getByFilterId(filterId);
            filterDeviceZoneStatusInfo2 = list.iterator();
            while (filterDeviceZoneStatusInfo2.hasNext()) {
                FilterDeviceZoneInfo filterDeviceZoneInfo = (FilterDeviceZoneInfo)filterDeviceZoneStatusInfo2.next();
                if (0L != filterDeviceZoneInfo.getZoneId() || !"SUCCESS".equals(filterDeviceZoneInfo.getDeployState())) continue;
                FilterDeviceZonePair filterDeviceZonePair = new FilterDeviceZonePair(filterDeviceZoneInfo.getZoneId(), filterId, filterDeviceZoneInfo.getDeviceId(), filterDeviceZoneInfo.getDirection(), 1);
                undeployFilterDeviceZonePairTempList.add(filterDeviceZonePair);
            }
        }
        FilterUnDeployInfo filterUnDeployInfo = new FilterUnDeployInfo();
        filterUnDeployInfo.setProgressBar(progressBar);
        filterUnDeployInfo.setProgressBarId(progressBarId);
        this.doUnDeploy(undeployFilterDeviceZonePairTempList, deviceUnDeployFilterMap, filterUnDeployInfo, adminId, true);
        HashSet<Long> notDeployZoneIdSet = new HashSet<Long>();
        for (Long filterId : filterIdList) {
            List<FilterDeviceZoneInfo> list = this.filterDeviceZoneInfoDao.getByFilterId(filterId);
            if (list != null && !list.isEmpty()) {
                int j = list.size();
                for (int i = 0; i < j; ++i) {
                    notDeployZoneIdSet.add(list.get(i).getZoneId());
                }
            }
            this.filterDeviceZoneInfoDao.deleteByFilterId(filterId);
        }
        notDeployZoneIdSet.removeAll(deployedZoneIdSet);
        notDeployZoneIdSet.remove(0L);
        for (Long zoneId : notDeployZoneIdSet) {
            this.saveZonePolicyApply(zoneId, CrcUtil.getCrcValue(0), "", true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doUnDeploy(List<FilterDeviceZonePair> undeployFilterDeviceZonePairList, Map<Long, Set<Long>> deviceUnDeployFilterMap, FilterUnDeployInfo filterUnDeployInfo, Long adminId, Boolean isDeployWithFilter) {
        Boolean isLockFilterOk = false;
        Boolean isLockZoneOk = true;
        Set<Long> filetrIdSet = null;
        Set<Long> zoneIdSet = null;
        try {
            filterUnDeployInfo = this.initFilterUnDeployInfo(undeployFilterDeviceZonePairList, deviceUnDeployFilterMap, filterUnDeployInfo.getProgressBarId(), filterUnDeployInfo.getProgressBar(), isDeployWithFilter);
            filetrIdSet = filterUnDeployInfo.getFilterConfigData().getFilterInfoMap().keySet();
            zoneIdSet = filterUnDeployInfo.getFilterConfigData().getZoneInfoMap().keySet();
            isLockFilterOk = this.lockFilters(filterUnDeployInfo.getFilterConfigData().getFilterInfoMap().keySet());
            if (isDeployWithFilter.booleanValue()) {
                isLockZoneOk = this.lockZones(filterUnDeployInfo.getFilterConfigData().getZoneInfoMap().keySet());
            }
            this.startFilterUnDeployThreads(filterUnDeployInfo);
            this.dealUnDeployResult(filterUnDeployInfo);
            this.saveZoneStatus(filterUnDeployInfo, isDeployWithFilter);
        }
        catch (Exception e) {
            this.logger.error((Object)"deploy filter error : ", (Throwable)e);
        }
        finally {
            if (isLockFilterOk.booleanValue() && filetrIdSet != null) {
                this.unLockFilters(filetrIdSet);
            }
            if (isLockZoneOk.booleanValue() && zoneIdSet != null) {
                this.unLockZones(zoneIdSet);
            }
        }
    }

    private void dealUnDeployResult(FilterUnDeployInfo filterUnDeployInfo) {
        this.dealFilterUnDeployResult(filterUnDeployInfo.getFilterUnDeployResult());
        this.dealFilterZoneUnDeployResult(filterUnDeployInfo.getFilterZoneUnDeployResult());
    }

    private void dealFilterZoneUnDeployResult(Map<FilterDeviceZonePair, String> filterZoneUnDeployResult) {
        for (Map.Entry<FilterDeviceZonePair, String> filterZoneUnDeployResultEntry : filterZoneUnDeployResult.entrySet()) {
            Long deviceId = filterZoneUnDeployResultEntry.getKey().getDeviceId();
            Long filterId = filterZoneUnDeployResultEntry.getKey().getFilterId();
            Long zoneId = filterZoneUnDeployResultEntry.getKey().getZoneId();
            String errorCode = filterZoneUnDeployResultEntry.getValue();
            if (!"".equals(errorCode)) continue;
            this.filterDeviceZoneStatusDao.deleteByFilterIdAndDeviceIdAndZoneId(filterId, deviceId, zoneId);
            this.filterDeviceZoneInfoDao.deleteByFilterIdAndDeviceIdAndZoneId(filterId, deviceId, zoneId);
        }
    }

    private void dealFilterUnDeployResult(Map<FilterDevicePair, String> filterUnDeployResult) {
        for (Map.Entry<FilterDevicePair, String> filterUnDeployResultEntry : filterUnDeployResult.entrySet()) {
            Long filterId = filterUnDeployResultEntry.getKey().getFilterId();
            Long deviceId = filterUnDeployResultEntry.getKey().getDeviceId();
            if (!"".equals(filterUnDeployResultEntry.getValue())) continue;
            this.filterDeviceDao.deleteByFilterIdAndDeviceId(filterId, deviceId);
        }
    }

    private void startFilterUnDeployThreads(FilterUnDeployInfo filterUnDeployInfo) {
        Set<Long> deviceIdSet = filterUnDeployInfo.getFilterConfigData().getNeInfoMap().keySet();
        for (Long deviceId : deviceIdSet) {
            LogicDev logicDev = new LogicDev(deviceId, 1, "--");
            FilterUnDeployThread filterUnDeployThread = new FilterUnDeployThread(logicDev, filterUnDeployInfo.getFilterToUnDeployData(), filterUnDeployInfo.getFilterUnDeployResult(), filterUnDeployInfo.getFilterZoneUnDeployResult());
            filterUnDeployInfo.getFilterUnDeployThreadPool().submit(filterUnDeployThread);
            this.logger.info((Object)("start filter undeploy thread , deviceId : " + deviceId));
        }
        filterUnDeployInfo.getFilterUnDeployThreadPool().shutdown();
        try {
            if (filterUnDeployInfo.getFilterUnDeployThreadPool().awaitTermination(180L, TimeUnit.MINUTES)) {
                this.logger.info((Object)"filter undeploy thread execute finished.");
            }
        }
        catch (InterruptedException e1) {
            this.logger.error((Object)"filter undeploy thread execute timeout.", (Throwable)e1);
        }
    }

    private void unLockFilters(Set<Long> filterIdSet) {
        this.logger.info((Object)"unlock Filters by undeploy filter");
        VsmUtil.getInstance().unlockFilters(filterIdSet);
    }

    private void unLockZones(Set<Long> zoneIdSet) {
        this.logger.info((Object)"unlock zones by undeploy filter");
        VsmUtil.getInstance().unlockZones(zoneIdSet);
    }

    private Boolean lockFilters(Set<Long> filterIdSet) {
        this.logger.info((Object)"lock Filters by undeploy filter");
        VsmUtil.getInstance().lockFilters(filterIdSet);
        return true;
    }

    private Boolean lockZones(Set<Long> zoneIdSet) {
        this.logger.info((Object)"lock zones by undeploy filter");
        VsmUtil.getInstance().lockZones(zoneIdSet);
        return true;
    }

    private FilterUnDeployInfo initFilterUnDeployInfo(List<FilterDeviceZonePair> undeployFilterDeviceZonePairList, Map<Long, Set<Long>> deviceUnDeployFilterMap, Long progressBarId, ProgressBar progressBar, Boolean isDeployWithFilter) {
        this.logger.info((Object)"init filter undeploy info");
        FilterUnDeployInfo filterUnDeployInfo = new FilterUnDeployInfo();
        if (progressBar == null) {
            progressBar = this.initProgressBar();
        }
        filterUnDeployInfo.setProgressBar(progressBar);
        filterUnDeployInfo.setProgressBarId(progressBarId);
        FilterConfigData filterConfigData = this.initFilterConfigData(undeployFilterDeviceZonePairList, deviceUnDeployFilterMap, isDeployWithFilter);
        filterUnDeployInfo.setFilterConfigData(filterConfigData);
        FilterToUnDeployData filterToUnDeployData = this.initFilterToUnDeployData(filterConfigData);
        filterUnDeployInfo.setFilterToUnDeployData(filterToUnDeployData);
        ThreadPoolExecutor filterUnDeployThreadPool = this.initFilterUnDeployThreadPool(5);
        filterUnDeployInfo.setFilterUnDeployThreadPool(filterUnDeployThreadPool);
        return filterUnDeployInfo;
    }

    private void saveZoneStatus(FilterUnDeployInfo filterUnDeployInfo, Boolean isDeployWithFilter) {
        Map<FilterDeviceZonePair, String> filterZoneUnDeployResult = filterUnDeployInfo.getFilterZoneUnDeployResult();
        HashMap<ZoneDevicePair, String> zoneDeviceDeployMap = new HashMap<ZoneDevicePair, String>();
        zoneDeviceDeployMap.putAll(this.getZoneDeviceDeployMap(filterZoneUnDeployResult));
        for (Map.Entry zoneDeviceDeployMapEntry : zoneDeviceDeployMap.entrySet()) {
            ZoneDevicePair zoneDevicePair = (ZoneDevicePair)zoneDeviceDeployMapEntry.getKey();
            String errorCode = (String)zoneDeviceDeployMapEntry.getValue();
            Long crc = this.getZoneFilterDeployCrc(zoneDevicePair.getZoneId(), zoneDevicePair.getDeviceId());
            this.saveZoneFeatureStatus(zoneDevicePair.getZoneId(), zoneDevicePair.getDeviceId(), crc, errorCode, isDeployWithFilter);
            this.saveZoneDeviceDeployStatus(zoneDevicePair.getZoneId(), zoneDevicePair.getDeviceId(), errorCode);
            this.saveZonePolicyApply(zoneDevicePair.getZoneId(), crc, errorCode, isDeployWithFilter);
        }
    }

    private Map<ZoneDevicePair, String> getZoneDeviceDeployMap(Map<FilterDeviceZonePair, String> filterZoneDeployResult) {
        HashMap<ZoneDevicePair, String> tempResultMap = new HashMap<ZoneDevicePair, String>();
        for (Map.Entry<FilterDeviceZonePair, String> filterZoneDeployResultEntry : filterZoneDeployResult.entrySet()) {
            Long deviceId = filterZoneDeployResultEntry.getKey().getDeviceId();
            Long zoneId = filterZoneDeployResultEntry.getKey().getZoneId();
            String errorCode = filterZoneDeployResultEntry.getValue();
            ZoneDevicePair zoneDevicePair = new ZoneDevicePair(zoneId, deviceId);
            if (tempResultMap.get(zoneDevicePair) == null) {
                tempResultMap.put(zoneDevicePair, "");
            }
            if (errorCode == null || "".equals(errorCode)) continue;
            tempResultMap.put(zoneDevicePair, errorCode);
        }
        return tempResultMap;
    }

    private Long getZoneFilterDeployCrc(Long zoneId, Long deviceId) {
        Long crc = null;
        List<FilterDeviceZoneStatusInfo> filterDeviceZoneStatusInfoList = this.filterDeviceZoneStatusDao.getDeployedByZoneIdAndDeviceId(zoneId, deviceId);
        if (filterDeviceZoneStatusInfoList != null && !filterDeviceZoneStatusInfoList.isEmpty()) {
            ArrayList<Long> filterIdList = new ArrayList<Long>();
            int j = filterDeviceZoneStatusInfoList.size();
            for (int i = 0; i < j; ++i) {
                filterIdList.add(filterDeviceZoneStatusInfoList.get(i).getFilterId());
            }
            Collections.sort(filterIdList);
            crc = CrcUtil.getCrcValue(((Object)filterIdList).toString());
        } else {
            crc = CrcUtil.getCrcValue(0);
        }
        return crc;
    }

    private void saveZonePolicyApply(Long zoneId, Long crc, String errorCode, Boolean isDeployWithFilter) {
        boolean isNoneModify = true;
        boolean isNoneDeployFailed = true;
        if (isDeployWithFilter.booleanValue()) {
            isNoneModify = this.checkZoneIsNoneModify(zoneId);
            isNoneDeployFailed = this.checkZoneIsNodeDeployFailed(zoneId);
        }
        boolean isUpdate = true;
        ZonePolicyApplyInfo zonePolicyApplyInfo = this.zonePolicyApplyDao.getByZoneId(zoneId);
        if (zonePolicyApplyInfo == null) {
            isUpdate = false;
            zonePolicyApplyInfo = new ZonePolicyApplyInfo();
        }
        if (isNoneDeployFailed && isNoneModify) {
            if (errorCode == null || "".equals(errorCode)) {
                zonePolicyApplyInfo.setFilterState("SUCCESS");
            } else {
                zonePolicyApplyInfo.setFilterState("PART_SUCCESS");
            }
        } else if (isNoneDeployFailed && !isNoneModify) {
            if (errorCode == null || "".equals(errorCode)) {
                zonePolicyApplyInfo.setFilterState("INCREAMENT_UNDEPLOY");
            } else {
                zonePolicyApplyInfo.setFilterState("PART_SUCCESS");
            }
        } else {
            return;
        }
        zonePolicyApplyInfo.setZoneId(zoneId);
        zonePolicyApplyInfo.setDeployedCrc(crc);
        zonePolicyApplyInfo.setCurrentCrc(crc);
        if (isUpdate) {
            this.zonePolicyApplyDao.update(zonePolicyApplyInfo);
        } else {
            this.zonePolicyApplyDao.save(zonePolicyApplyInfo);
        }
    }

    private boolean checkZoneIsNodeDeployFailed(Long zoneId) {
        List<ZoneDeviceDeployStatusForm> zoneDeviceDeployStatusFormList = this.zonePolicyMgrService.queryDeployResultByZoneId(zoneId);
        if (zoneDeviceDeployStatusFormList != null && !zoneDeviceDeployStatusFormList.isEmpty()) {
            int j = zoneDeviceDeployStatusFormList.size();
            for (int i = 0; i < j; ++i) {
                ZoneDeviceDeployStatusForm zoneDeviceDeployStatusInfo = zoneDeviceDeployStatusFormList.get(i);
                if (zoneDeviceDeployStatusInfo.getDeployState().booleanValue() || "lego.err.631035".equals(zoneDeviceDeployStatusInfo.getErrorMsgKey()) || "lego.err.631036".equals(zoneDeviceDeployStatusInfo.getErrorMsgKey()) || "lego.err.631037".equals(zoneDeviceDeployStatusInfo.getErrorMsgKey()) || "lego.err.631042".equals(zoneDeviceDeployStatusInfo.getErrorMsgKey()) || "lego.err.631044".equals(zoneDeviceDeployStatusInfo.getErrorMsgKey())) continue;
                return false;
            }
        }
        return true;
    }

    private boolean checkZoneIsNoneModify(Long zoneId) {
        List<ZoneModifyDetailForm> zoneModifyDetailFormList = this.zonePolicyApplyService.getZoneModifyDetail(zoneId);
        return zoneModifyDetailFormList == null || zoneModifyDetailFormList.isEmpty();
    }

    private void saveZoneDeviceDeployStatus(Long zoneId, Long deviceId, String errorCode) {
        ZoneDeviceDeployStatusInfo zoneDeviceDeployStatusInfo = this.zoneDeviceDeployStatusDao.getOneByZoneIdAndDeviceId(zoneId, deviceId, 2);
        if (zoneDeviceDeployStatusInfo != null) {
            if (!(zoneDeviceDeployStatusInfo.getDeployState().booleanValue() || "lego.err.631035".equals(zoneDeviceDeployStatusInfo.getErrorMsgKey()) || "lego.err.631036".equals(zoneDeviceDeployStatusInfo.getErrorMsgKey()) || "lego.err.631037".equals(zoneDeviceDeployStatusInfo.getErrorMsgKey()) || "lego.err.631042".equals(zoneDeviceDeployStatusInfo.getErrorMsgKey()) || "lego.err.631044".equals(zoneDeviceDeployStatusInfo.getErrorMsgKey()))) {
                return;
            }
            zoneDeviceDeployStatusInfo.setZoneId(zoneId);
            zoneDeviceDeployStatusInfo.setDeviceId(deviceId);
            zoneDeviceDeployStatusInfo.setDeployState("".equals(errorCode));
            zoneDeviceDeployStatusInfo.setDeployType(2);
            zoneDeviceDeployStatusInfo.setErrorMsgKey(errorCode);
            zoneDeviceDeployStatusInfo.setDeployTime(new Date());
            this.zoneDeviceDeployStatusDao.update(zoneDeviceDeployStatusInfo);
        } else {
            zoneDeviceDeployStatusInfo = new ZoneDeviceDeployStatusInfo();
            zoneDeviceDeployStatusInfo.setZoneId(zoneId);
            zoneDeviceDeployStatusInfo.setDeviceId(deviceId);
            zoneDeviceDeployStatusInfo.setDeployState("".equals(errorCode));
            zoneDeviceDeployStatusInfo.setDeployType(2);
            zoneDeviceDeployStatusInfo.setErrorMsgKey(errorCode);
            zoneDeviceDeployStatusInfo.setDeployTime(new Date());
            this.zoneDeviceDeployStatusDao.save(zoneDeviceDeployStatusInfo);
        }
    }

    private void saveZoneFeatureStatus(Long zoneId, Long deviceId, Long crc, String errorCode, Boolean isDeployWithFilter) {
        if (isDeployWithFilter.booleanValue()) {
            List<FilterDeviceZoneStatusInfo> filterDeviceZoneStatusInfoList = this.filterDeviceZoneStatusDao.getDeployedByZoneIdAndDeviceId(zoneId, deviceId);
            ZoneFeatureStatusInfo zoneFeatureStatusInfo = this.zoneFeatureStatusDao.getByZoneIdAndDeviceIdAndTypeAndFeatureId(zoneId, deviceId, FilterForm.class.getSimpleName(), zoneId);
            if (zoneFeatureStatusInfo == null) {
                zoneFeatureStatusInfo = new ZoneFeatureStatusInfo();
                zoneFeatureStatusInfo.setZoneId(zoneId);
                zoneFeatureStatusInfo.setDeviceId(deviceId);
                zoneFeatureStatusInfo.setDeployState(errorCode == null || "".equals(errorCode));
                zoneFeatureStatusInfo.setDeployCrc(filterDeviceZoneStatusInfoList == null || filterDeviceZoneStatusInfoList.isEmpty() ? Long.valueOf(CrcUtil.getCrcValue(0)) : crc);
                zoneFeatureStatusInfo.setFeatureId(zoneId);
                zoneFeatureStatusInfo.setFeatureType(FilterForm.class.getSimpleName());
                this.zoneFeatureStatusDao.save(zoneFeatureStatusInfo);
            } else {
                zoneFeatureStatusInfo.setZoneId(zoneId);
                zoneFeatureStatusInfo.setDeviceId(deviceId);
                zoneFeatureStatusInfo.setDeployState(errorCode == null || "".equals(errorCode));
                Long crcV = CrcUtil.getCrcValue(0);
                zoneFeatureStatusInfo.setDeployCrc(filterDeviceZoneStatusInfoList == null || filterDeviceZoneStatusInfoList.isEmpty() ? crcV : crc);
                zoneFeatureStatusInfo.setFeatureId(zoneId);
                zoneFeatureStatusInfo.setFeatureType(FilterForm.class.getSimpleName());
                this.zoneFeatureStatusDao.update(zoneFeatureStatusInfo);
            }
        } else if (errorCode != null && !"".equals(errorCode)) {
            ZoneFeatureStatusInfo zoneFeatureStatusInfo = new ZoneFeatureStatusInfo();
            zoneFeatureStatusInfo.setZoneId(zoneId);
            zoneFeatureStatusInfo.setDeviceId(deviceId);
            zoneFeatureStatusInfo.setDeployState(false);
            zoneFeatureStatusInfo.setDeployCrc(crc);
            zoneFeatureStatusInfo.setFeatureId(zoneId);
            zoneFeatureStatusInfo.setFeatureType(FilterForm.class.getSimpleName());
            this.zoneFeatureStatusDao.save(zoneFeatureStatusInfo);
        }
    }

    private FilterToUnDeployData initFilterToUnDeployData(FilterConfigData filterConfigData) {
        this.logger.info((Object)"init filter undeploy data");
        FilterToUnDeployData filterToUnDeployData = this.filterToDeployDataTool.initFilterToUnDeployData(filterConfigData);
        return filterToUnDeployData;
    }

    private ThreadPoolExecutor initFilterUnDeployThreadPool(int threadPoolSize) {
        this.logger.info((Object)"init filter undeploy thread pool");
        ThreadPoolExecutor filterUnDeployThreadPool = (ThreadPoolExecutor)Executors.newCachedThreadPool();
        return filterUnDeployThreadPool;
    }

    private FilterConfigData initFilterConfigData(List<FilterDeviceZonePair> undeployFilterDeviceZonePairList, Map<Long, Set<Long>> deviceUnDeployFilterMap, Boolean isDeployWithFilter) {
        this.logger.info((Object)"init filter config data");
        FilterConfigData filterConfigData = this.filterConfigDataTool.initUnDeployFilterConfigData(undeployFilterDeviceZonePairList, deviceUnDeployFilterMap, isDeployWithFilter);
        return filterConfigData;
    }

    private ProgressBar initProgressBar() {
        return null;
    }

    public FilterConfigDataTool getFilterConfigDataTool() {
        return this.filterConfigDataTool;
    }

    public void setFilterConfigDataTool(FilterConfigDataTool filterConfigDataTool) {
        this.filterConfigDataTool = filterConfigDataTool;
    }

    public FilterToDeployDataTool getFilterToDeployDataTool() {
        return this.filterToDeployDataTool;
    }

    public void setFilterToDeployDataTool(FilterToDeployDataTool filterToDeployDataTool) {
        this.filterToDeployDataTool = filterToDeployDataTool;
    }

    public FilterDeviceZoneInfoDao getFilterDeviceZoneInfoDao() {
        return this.filterDeviceZoneInfoDao;
    }

    public void setFilterDeviceZoneInfoDao(FilterDeviceZoneInfoDao filterDeviceZoneInfoDao) {
        this.filterDeviceZoneInfoDao = filterDeviceZoneInfoDao;
    }

    public FilterDeviceZoneStatusDao getFilterDeviceZoneStatusDao() {
        return this.filterDeviceZoneStatusDao;
    }

    public void setFilterDeviceZoneStatusDao(FilterDeviceZoneStatusDao filterDeviceZoneStatusDao) {
        this.filterDeviceZoneStatusDao = filterDeviceZoneStatusDao;
    }

    public FilterDeviceDao getFilterDeviceDao() {
        return this.filterDeviceDao;
    }

    public void setFilterDeviceDao(FilterDeviceDao filterDeviceDao) {
        this.filterDeviceDao = filterDeviceDao;
    }

    public ZoneFeatureStatusDao getZoneFeatureStatusDao() {
        return this.zoneFeatureStatusDao;
    }

    public void setZoneFeatureStatusDao(ZoneFeatureStatusDao zoneFeatureStatusDao) {
        this.zoneFeatureStatusDao = zoneFeatureStatusDao;
    }

    public ZoneDeviceDeployStatusDao getZoneDeviceDeployStatusDao() {
        return this.zoneDeviceDeployStatusDao;
    }

    public void setZoneDeviceDeployStatusDao(ZoneDeviceDeployStatusDao zoneDeviceDeployStatusDao) {
        this.zoneDeviceDeployStatusDao = zoneDeviceDeployStatusDao;
    }

    public ZonePolicyApplyDao getZonePolicyApplyDao() {
        return this.zonePolicyApplyDao;
    }

    public void setZonePolicyApplyDao(ZonePolicyApplyDao zonePolicyApplyDao) {
        this.zonePolicyApplyDao = zonePolicyApplyDao;
    }

    public IZonePolicyApplyService getZonePolicyApplyService() {
        return this.zonePolicyApplyService;
    }

    public void setZonePolicyApplyService(IZonePolicyApplyService zonePolicyApplyService) {
        this.zonePolicyApplyService = zonePolicyApplyService;
    }

    public IZonePolicyMgrService getZonePolicyMgrService() {
        return this.zonePolicyMgrService;
    }

    public void setZonePolicyMgrService(IZonePolicyMgrService zonePolicyMgrService) {
        this.zonePolicyMgrService = zonePolicyMgrService;
    }
}

