/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.service.function.undeploy;

import com.hs.atic.sdk.res.service.ILicenseOutboundService;
import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.secservice.ddos.common.ErrorMsg2ResKey;
import com.hs.vsm.secservice.ddos.common.FilterDevicePair;
import com.hs.vsm.secservice.ddos.common.FilterDeviceZonePair;
import com.hs.vsm.secservice.ddos.model.FilterDeviceZoneInfo;
import com.hs.vsm.secservice.ddos.service.data.FilterToUnDeployData;
import com.hs.vsm.secservice.ddos.service.data.feature.FilterData;
import com.hs.vsm.secservice.ddos.service.data.feature.FilterZoneData;
import com.hs.vsm.secservice.nfa.restful.deploy.FormTransObject;
import com.hs.vsm.secservice.nfa.util.NfaFilterUtil;
import com.hs.vsm.secservice.sdk.common.util.Locker;
import com.hs.vsm.secservice.sdk.common.util.VsmUtil;
import com.hs.vsm.secservice.sdk.frame.model.IFeature;
import com.hs.vsm.secservice.sdk.frame.model.LogicDev;
import com.hs.vsm.secservice.sdk.module.ddos.form.FilterDeviceZoneStatusForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.FilterForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.NfaPolicyForm;
import com.hs.vsm.secservice.sdk.module.ddos.service.IFilterDeviceZoneInfoService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IFilterDeviceZoneStatusService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IFilterService;
import com.hs.vsm.secservice.sdk.module.ddos.service.INfaPolicyService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZonePolicyApplyService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.huawei.atic.secservice.nfa.restful.model.DefinedFilter;
import com.huawei.atic.secservice.nfa.restful.model.FilterObject;
import com.huawei.atic.secservice.nfa.restful.model.FilterPolicyObject;
import com.huawei.atic.secservice.nfa.restful.model.NfaInfoForm;
import com.huawei.atic.secservice.nfa.restful.model.PolicyObject;
import com.huawei.atic.secservice.nfa.restful.model.Result;
import com.huawei.atic.secservice.nfa.restful.model.ZonePolicyObject;
import com.huawei.atic.secservice.nfa.restful.sdk.service.IRestfulNfaService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FilterUnDeployThread
extends Thread {
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private LogicDev logicDev;
    private boolean isLockOK = false;
    private FilterToUnDeployData filterToUnDeployData;
    private Map<FilterDevicePair, String> filterUnDeployResult;
    private Map<FilterDeviceZonePair, String> filterZoneUnDeployResult;
    private Boolean isDeviceConnectedOK = true;
    private Map<String, String> errorMapping = ErrorMsg2ResKey.getInstance().getErrorMsgKeyMapping();
    private IRestfulNfaService restfulNfaService;
    private ILicenseOutboundService licenseOutboundService;

    public FilterUnDeployThread(LogicDev logicDev, FilterToUnDeployData filterToUnDeployData, Map<FilterDevicePair, String> filterUnDeployResult, Map<FilterDeviceZonePair, String> filterZoneUnDeployResult) {
        this.logicDev = logicDev;
        this.filterToUnDeployData = filterToUnDeployData;
        this.filterUnDeployResult = filterUnDeployResult;
        this.filterZoneUnDeployResult = filterZoneUnDeployResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.isLockOK = VsmUtil.getInstance().lock(this.logicDev.getDeviceId());
        try {
            IAticDeviceService aticDeviceService = (IAticDeviceService)ServiceContext.getInstance().getService("aticDeviceService", IAticDeviceService.class);
            AticDevice aticDevice = aticDeviceService.getDeviceByMoid(this.logicDev.getDeviceId().longValue());
            if (null != aticDevice && (aticDevice.getDeviceType() == 5 || aticDevice.getDeviceType() == 7)) {
                this.restfulNfaService = (IRestfulNfaService)ServiceContext.getInstance().getService("restfulNfaService", IRestfulNfaService.class);
                NfaInfoForm nfaInfoForm = NfaFilterUtil.getNfaInfoFormByDeviceId(this.logicDev.getDeviceId());
                if (nfaInfoForm != null) {
                    this.unDeployFilterZoneFromNfa(nfaInfoForm);
                    this.unDeployFilterFromNfa(nfaInfoForm);
                } else {
                    this.logger.error((Object)"nfaInfoForm is null");
                }
            } else {
                this.unDeployFilterZoneFromDevice();
                this.unDeployFilterFromDevice();
            }
        }
        catch (RuntimeException e) {
            this.logger.error((Object)("undeploy filter thread error, device id : " + this.logicDev.getDeviceId()));
        }
        finally {
            if (this.isLockOK) {
                Locker.getInstance().unlock(this.logicDev.getDeviceId(), 1);
            }
        }
    }

    private void unDeployFilterFromDevice() {
        List<IFeature> unDeployFilterData = this.filterToUnDeployData.getFilterInfoToUnDeployData().get(this.logicDev.getDeviceId());
        if (unDeployFilterData != null && !unDeployFilterData.isEmpty()) {
            for (IFeature feature : unDeployFilterData) {
                String errorCode = "";
                FilterData filterData = (FilterData)feature;
                this.logger.info((Object)("pre undeploy filter by undeploy,  deviceId : " + this.logicDev.getDeviceId() + ", filterId : " + filterData.getFilterInfo().getPkid()));
                try {
                    errorCode = this.getZoneDeployFromFilterErr(filterData.getFilterInfo().getPkid());
                    if ("".equals(errorCode) && this.isLockOK && this.isDeviceConnectedOK.booleanValue()) {
                        filterData.doUndeploy(this.logicDev, null);
                    }
                }
                catch (LegoCheckedException e) {
                    this.logger.error((Object)"deploy filter by deploy error, ", (Throwable)e);
                    this.isDeviceConnectedOK = false;
                    errorCode = "lego.err." + e.getErrorCode();
                }
                catch (Exception e) {
                    errorCode = "lego.err.631039";
                }
                this.checkFilterResult(filterData.getFeatureId(), errorCode);
            }
        }
    }

    private void unDeployFilterFromNfa(NfaInfoForm nfaInfoForm) {
        List<IFeature> unDeployFilterData = this.filterToUnDeployData.getFilterInfoToUnDeployData().get(this.logicDev.getDeviceId());
        if (unDeployFilterData != null && !unDeployFilterData.isEmpty()) {
            for (IFeature feature : unDeployFilterData) {
                String errorCode = "";
                FilterData filterData = (FilterData)feature;
                this.logger.info((Object)("pre undeploy filter by undeploy,  deviceId : " + nfaInfoForm.getDeviceId() + ", filterId : " + filterData.getFilterInfo().getPkid()));
                DefinedFilter definedFilter = new DefinedFilter();
                definedFilter.setFilterId(filterData.getFilterInfo().getFilterId());
                try {
                    errorCode = this.getZoneDeployFromFilterErr(filterData.getFilterInfo().getPkid());
                    if ("".equals(errorCode) && this.isLockOK && this.isDeviceConnectedOK.booleanValue()) {
                        Result result = this.restfulNfaService.restNfaDelDefinedFilter(definedFilter, nfaInfoForm);
                        errorCode = null != result && result.getStatusCode() == 200 && result.getJson().contains("ok") ? "" : (null != result && result.getStatusCode() == 462 ? "9" : (null != result && null != result.getJson() && result.getJson().contains("certificate is error") ? "certificate" : "8"));
                    }
                }
                catch (LegoCheckedException e) {
                    this.logger.error((Object)"deploy filter by deploy error, ", (Throwable)e);
                    this.isDeviceConnectedOK = false;
                    errorCode = "lego.err." + e.getErrorCode();
                }
                catch (Exception e) {
                    errorCode = "lego.err.631039";
                }
                this.checkFilterResult(filterData.getFeatureId(), errorCode);
            }
        }
    }

    private String getZoneDeployFromFilterErr(Long filterId) {
        for (Map.Entry<FilterDeviceZonePair, String> deployResult : this.filterZoneUnDeployResult.entrySet()) {
            if (!deployResult.getKey().getFilterId().equals(filterId) || !deployResult.getKey().getDeviceId().equals(this.logicDev.getDeviceId()) || deployResult.getValue() == null || "".equals(deployResult.getValue())) continue;
            return deployResult.getValue();
        }
        return "";
    }

    private void unDeployFilterZoneFromDevice() {
        List<IFeature> unDeployFilterDataZonesData = this.filterToUnDeployData.getFilterZonesToUnDeployData().get(this.logicDev.getDeviceId());
        if (unDeployFilterDataZonesData != null && !unDeployFilterDataZonesData.isEmpty()) {
            for (IFeature feature : unDeployFilterDataZonesData) {
                String errorCode = "";
                FilterZoneData filterZoneData = (FilterZoneData)feature;
                this.logger.info((Object)("pre undeploy filterZone by undeploy,  deviceId : " + this.logicDev.getDeviceId() + "zoneId : " + filterZoneData.getZoneInfoForm().getZoneId() + ", filterId : " + filterZoneData.getFilterInfo().getPkid()));
                try {
                    if (!this.isLockOK) {
                        errorCode = "lego.err.630007";
                    } else if (this.isDeviceConnectedOK.booleanValue()) {
                        List cmdResultList = (List)filterZoneData.doUndeploy(this.logicDev, null);
                        errorCode = this.checkCmdResultList(cmdResultList);
                    } else {
                        errorCode = "lego.err.631039";
                    }
                }
                catch (LegoCheckedException e) {
                    this.logger.error((Object)"deploy filter by deploy error, ", (Throwable)e);
                    this.isDeviceConnectedOK = false;
                    errorCode = "lego.err." + e.getErrorCode();
                }
                catch (Exception e) {
                    errorCode = "lego.err.631039";
                }
                this.checkFilterZoneResult(filterZoneData.getFilterInfo().getPkid(), filterZoneData.getZoneInfoForm().getZoneId(), errorCode, filterZoneData.getDirection());
            }
        }
    }

    private void unDeployFilterZoneFromNfa(NfaInfoForm nfaInfoForm) {
        List<IFeature> unDeployFilterDataZonesData = this.filterToUnDeployData.getFilterZonesToUnDeployData().get(nfaInfoForm.getDeviceId());
        if (unDeployFilterDataZonesData != null && !unDeployFilterDataZonesData.isEmpty()) {
            String errorCode = "";
            try {
                Result result;
                errorCode = !this.isLockOK ? "lego.err.630007" : (this.isDeviceConnectedOK.booleanValue() ? (null != (result = this.unDeployZonePolicyToNfa(unDeployFilterDataZonesData, nfaInfoForm)) && result.getStatusCode() == 200 && result.getJson().contains("ok") ? "" : (null != result && result.getStatusCode() == 462 ? "9" : (null != result && null != result.getJson() && result.getJson().contains("certificate is error") ? "certificate" : "7"))) : "lego.err.631039");
            }
            catch (LegoCheckedException e) {
                this.logger.error((Object)"deploy filter by deploy error, ", (Throwable)e);
                this.isDeviceConnectedOK = false;
                errorCode = "lego.err." + e.getErrorCode();
            }
            catch (Exception e) {
                errorCode = "lego.err.631039";
            }
            for (IFeature feature : unDeployFilterDataZonesData) {
                FilterZoneData filterZoneData = (FilterZoneData)feature;
                this.logger.info((Object)("pre undeploy filterZone by undeploy,  deviceId : " + this.logicDev.getDeviceId() + "zoneId : " + filterZoneData.getZoneInfoForm().getZoneId() + ", filterId : " + filterZoneData.getFilterInfo().getPkid()));
                this.checkFilterZoneResult(filterZoneData.getFilterInfo().getPkid(), filterZoneData.getZoneInfoForm().getZoneId(), errorCode, filterZoneData.getDirection());
            }
        }
    }

    private Result unDeployZonePolicyToNfa(List<IFeature> unDeployFilterDataZonesData, NfaInfoForm nfaInfoForm) {
        Result result = null;
        INfaPolicyService nfaPolicyService = (INfaPolicyService)ServiceContext.getInstance().getService("nfaPolicyService", INfaPolicyService.class);
        FormTransObject formTransObject = new FormTransObject();
        ZoneInfoForm zoneInfoForm = null;
        ArrayList<Long> filterIdList = new ArrayList<Long>();
        for (IFeature feature : unDeployFilterDataZonesData) {
            FilterZoneData filterZoneData = (FilterZoneData)feature;
            filterIdList.add(filterZoneData.getFilterInfo().getPkid());
            zoneInfoForm = filterZoneData.getZoneInfoForm();
        }
        if (zoneInfoForm != null) {
            int i;
            PolicyObject[] policyObject;
            List<NfaPolicyForm> nfaPolicyForms;
            List<NfaPolicyForm> nfaOutboundPolicyForms = null;
            Long zoneId = zoneInfoForm.getZoneId();
            Long deviceId = nfaInfoForm.getDeviceId();
            ZonePolicyObject zonePolicyObject = new ZonePolicyObject();
            zonePolicyObject.setZoneId(zoneId.longValue());
            if (nfaInfoForm.getClusterId() != null) {
                nfaPolicyForms = nfaPolicyService.getNfaPolicyForm(zoneInfoForm.getZoneId(), nfaInfoForm.getClusterId());
            } else {
                FilterPolicyObject filterPolicyObject;
                nfaPolicyForms = nfaPolicyService.getNfaPolicyForm(zoneId, deviceId);
                nfaOutboundPolicyForms = nfaPolicyService.getOutboundNfaPolicyForm(zoneId, deviceId);
                if (this.licenseOutboundService.isSupportOutbound()) {
                    filterPolicyObject = this.getFilterObjectById(deviceId, zoneId, filterIdList, 2);
                    zonePolicyObject.setFilterIn(filterPolicyObject);
                }
                filterPolicyObject = this.getFilterObjectById(deviceId, zoneId, filterIdList, 1);
                zonePolicyObject.setFilterOut(filterPolicyObject);
            }
            if (null != nfaPolicyForms && !nfaPolicyForms.isEmpty()) {
                policyObject = new PolicyObject[nfaPolicyForms.size()];
                i = 0;
                for (NfaPolicyForm nfaPolicyForm : nfaPolicyForms) {
                    policyObject[i] = formTransObject.nfaPolicyFormTransfObject(nfaPolicyForm);
                    ++i;
                }
                zonePolicyObject.setPolicyIn(policyObject);
            }
            if (null != nfaOutboundPolicyForms && !nfaOutboundPolicyForms.isEmpty()) {
                policyObject = new PolicyObject[nfaOutboundPolicyForms.size()];
                i = 0;
                for (NfaPolicyForm nfaPolicyForm : nfaOutboundPolicyForms) {
                    policyObject[i] = formTransObject.nfaPolicyFormTransfObject(nfaPolicyForm);
                    ++i;
                }
                zonePolicyObject.setPolicyOut(policyObject);
            }
            try {
                result = this.restfulNfaService.restNfaZonePolicy(zonePolicyObject, nfaInfoForm);
            }
            catch (Exception e) {
                return null;
            }
            return result;
        }
        return null;
    }

    private FilterPolicyObject getFilterObjectById(Long deviceId, Long zoneId, List<Long> filterIdList, int direction) {
        FilterPolicyObject filterPolicyObject = new FilterPolicyObject();
        FilterObject[] filterObject = null;
        IFilterDeviceZoneInfoService filterDeviceZoneInfoService = (IFilterDeviceZoneInfoService)ServiceContext.getInstance().getService("filterDeviceZoneInfoService", IFilterDeviceZoneInfoService.class);
        IFilterDeviceZoneStatusService filterDeviceZoneStatusService = (IFilterDeviceZoneStatusService)ServiceContext.getInstance().getService("filterDeviceZoneStatusService", IFilterDeviceZoneStatusService.class);
        IFilterService filterService = (IFilterService)ServiceContext.getInstance().getService("filterService", IFilterService.class);
        IZonePolicyApplyService zonePolicyApplyService = (IZonePolicyApplyService)ServiceContext.getInstance().getService("zonePolicyApplyService", IZonePolicyApplyService.class);
        if (null == filterDeviceZoneInfoService || null == filterService || null == zonePolicyApplyService || null == filterDeviceZoneStatusService) {
            return filterPolicyObject;
        }
        List<FilterDeviceZoneInfo> filterDeviceZoneForms = filterDeviceZoneInfoService.quertByZoneIdAndDeviceId(zoneId, deviceId, direction);
        ArrayList<FilterDeviceZoneInfo> temFilterDeviceZoneInfos = new ArrayList<FilterDeviceZoneInfo>();
        if (null != filterDeviceZoneForms && !filterDeviceZoneForms.isEmpty()) {
            for (FilterDeviceZoneInfo filterDeviceZoneInfo : filterDeviceZoneForms) {
                FilterDeviceZoneStatusForm filterDeviceZoneStatusForm;
                if (filterIdList.contains(filterDeviceZoneInfo.getFilterId()) || null == (filterDeviceZoneStatusForm = filterDeviceZoneStatusService.getFilterStatusByIdAndDeviceIdAndZoneId(filterDeviceZoneInfo.getFilterId(), deviceId, zoneId)) || !filterDeviceZoneStatusForm.getDeployState().booleanValue()) continue;
                temFilterDeviceZoneInfos.add(filterDeviceZoneInfo);
            }
            filterObject = new FilterObject[temFilterDeviceZoneInfos.size()];
            for (int i = 0; i < temFilterDeviceZoneInfos.size(); ++i) {
                FilterForm filterForm = (FilterForm)filterService.query(((FilterDeviceZoneInfo)temFilterDeviceZoneInfos.get(i)).getFilterId());
                if (null == filterForm) continue;
                filterObject[i] = new FilterObject();
                filterObject[i].setPriority(((FilterDeviceZoneInfo)temFilterDeviceZoneInfos.get(i)).getPreference());
                filterObject[i].setFilterId((long)filterForm.getFilterId().intValue());
            }
        }
        filterPolicyObject.setFilterList(filterObject);
        return filterPolicyObject;
    }

    private String checkCmdResultList(List<String> cmdResultList) {
        Iterator<String> iterator = cmdResultList.iterator();
        while (iterator.hasNext()) {
            String resultStringTemp;
            String resultString = resultStringTemp = iterator.next();
            if ("".equals(resultString = resultString.toLowerCase(Locale.ENGLISH))) continue;
            for (Map.Entry<String, String> entry : this.errorMapping.entrySet()) {
                String key = entry.getKey().toLowerCase(Locale.ENGLISH);
                Pattern p = Pattern.compile(key);
                Matcher matcher = p.matcher(resultString);
                if (!matcher.find()) continue;
                return entry.getValue();
            }
        }
        return "";
    }

    private void checkFilterResult(Long filterId, String errorCode) {
        FilterDevicePair filterDevicePair = new FilterDevicePair(filterId, this.logicDev.getDeviceId());
        this.filterUnDeployResult.put(filterDevicePair, errorCode);
        this.logger.info((Object)("deploy filter by undeploy,  deviceId : " + this.logicDev.getDeviceId() + ", filterId : " + filterId + ", errorcode : " + this.getcleanedMessage(errorCode)));
    }

    private void checkFilterZoneResult(Long filterId, Long zoneId, String errorCode, int direction) {
        FilterDeviceZonePair filterDeviceZonePair = new FilterDeviceZonePair(zoneId, filterId, this.logicDev.getDeviceId(), direction);
        this.filterZoneUnDeployResult.put(filterDeviceZonePair, errorCode);
        this.logger.info((Object)("deploy filterZone result by undeploy,  zoneId : " + zoneId + ", deviceId : " + this.logicDev.getDeviceId() + " filterId : " + filterId + ", errorcode : " + this.getcleanedMessage(errorCode)));
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    public IRestfulNfaService getRestfulNfaService() {
        return this.restfulNfaService;
    }

    public void setRestfulNfaService(IRestfulNfaService restfulNfaService) {
        this.restfulNfaService = restfulNfaService;
    }

    public ILicenseOutboundService getLicenseOutboundService() {
        return this.licenseOutboundService;
    }

    public void setLicenseOutboundService(ILicenseOutboundService licenseOutboundService) {
        this.licenseOutboundService = licenseOutboundService;
    }
}

