/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.service.npfilter.data;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.secservice.ddos.common.ErrorMsg2ResKey;
import com.hs.vsm.secservice.ddos.common.FilterDevicePair;
import com.hs.vsm.secservice.ddos.service.data.feature.NPFilterData;
import com.hs.vsm.secservice.ddos.service.npfilter.data.NPFilterDeployInfo;
import com.hs.vsm.secservice.ddos.service.npfilter.data.NPFilterDeployResult;
import com.hs.vsm.secservice.sdk.frame.model.IFeature;
import com.hs.vsm.secservice.sdk.frame.model.LogicDev;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NPFilterDeployThread
extends Thread {
    private static final String SSL_ERROR = "lego.err.632003";
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private LogicDev logicDev;
    private Map<FilterDevicePair, NPFilterDeployResult> filterDeployResult;
    private Map<FilterDevicePair, NPFilterDeployResult> filterUnDeployResult;
    private NPFilterDeployInfo npFilterDeployInfo;
    private Boolean isDeviceConnectedOK = true;
    private Map<String, String> errorMapping = ErrorMsg2ResKey.getInstance().getErrorMsgKeyMapping();
    private IAticDeviceService aticDeviceService;

    public NPFilterDeployThread(LogicDev logicDev, NPFilterDeployInfo filterDeployInfo) {
        this.logicDev = logicDev;
        this.filterDeployResult = filterDeployInfo.getFilterDeployResult();
        this.filterUnDeployResult = filterDeployInfo.getFilterUnDeployResult();
        this.npFilterDeployInfo = filterDeployInfo;
    }

    @Override
    public void run() {
        this.aticDeviceService = (IAticDeviceService)ServiceContext.getInstance().getService("aticDeviceService", IAticDeviceService.class);
        AticDevice aticDevice = this.aticDeviceService.getDeviceByMoid(this.logicDev.getDeviceId().longValue());
        try {
            if (null != aticDevice && aticDevice.getDeviceType() == 1) {
                this.unDeployFilterFromDevice();
                this.deployFilterToDevice();
            } else {
                this.logger.error((Object)("NPFilter-> deploy NPFilter thread error, because device id : " + this.logicDev.getDeviceId() + " is not ddos."));
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("NPFilter-> deploy NPFilter thread error, device id : " + this.logicDev.getDeviceId()), (Throwable)e);
        }
    }

    private void deployFilterToDevice() {
        if (null == this.npFilterDeployInfo.getFilterInfoToDeployData()) {
            return;
        }
        List<IFeature> deployFilterData = this.npFilterDeployInfo.getFilterInfoToDeployData().get(this.logicDev.getDeviceId());
        if (null != deployFilterData && !deployFilterData.isEmpty()) {
            for (int i = 0; i < deployFilterData.size(); ++i) {
                NPFilterDeployResult deployResult = new NPFilterDeployResult();
                deployResult.setErrorMsgKey("");
                IFeature feature = deployFilterData.get(i);
                NPFilterData filterData = (NPFilterData)feature;
                this.logger.info((Object)("NPFilter-> pre deploy NPFilter by deploy,  deviceId : " + this.logicDev.getDeviceId() + ", filterId : " + filterData.getNpFilterInfo().getId()));
                String errorCode = "lego.err.631039";
                try {
                    if (this.isDeviceConnectedOK.booleanValue()) {
                        List cmdResultList = (List)filterData.doDeploy(this.logicDev, null);
                        this.checkCmdResultList(filterData.getCmds(), cmdResultList, deployResult);
                    }
                }
                catch (LegoCheckedException e) {
                    this.logger.error((Object)"NPFilter-> deploy NPFilter by deploy error, ", (Throwable)e);
                    this.isDeviceConnectedOK = false;
                    errorCode = e.getErrorCode() == 0L ? e.getMessage() : "lego.err." + e.getErrorCode();
                    deployResult.setErrorMsgKey(errorCode);
                }
                catch (Exception e) {
                    this.logger.error((Object)"NPFilter-> deploy NPFilter by deploy error, ", (Throwable)e);
                    errorCode = "lego.err.631039";
                    deployResult.setErrorMsgKey(errorCode);
                }
                this.checkFilterResult(filterData.getNpFilterInfo().getId(), deployResult, true);
            }
        }
    }

    private void unDeployFilterFromDevice() {
        if (null == this.npFilterDeployInfo.getFilterInfoToUnDeployData()) {
            return;
        }
        List<IFeature> unDeployFilterData = this.npFilterDeployInfo.getFilterInfoToUnDeployData().get(this.logicDev.getDeviceId());
        if (null != unDeployFilterData && !unDeployFilterData.isEmpty()) {
            for (IFeature feature : unDeployFilterData) {
                NPFilterData filterData;
                NPFilterDeployResult deployResult;
                block7: {
                    deployResult = new NPFilterDeployResult();
                    deployResult.setErrorMsgKey("");
                    String errorCode = "";
                    filterData = (NPFilterData)feature;
                    this.logger.info((Object)("NPFilter-> pre undeploy NPFilter by deploy,  deviceId : " + this.logicDev.getDeviceId() + ", filterId : " + filterData.getNpFilterInfo().getId()));
                    try {
                        if (this.isDeviceConnectedOK.booleanValue()) {
                            List cmdResultList = (List)filterData.doUndeploy(this.logicDev, null);
                            this.checkCmdResultList(filterData.getCmds(), cmdResultList, deployResult);
                            break block7;
                        }
                        this.logger.info((Object)("NPFilter-> deploy NPFilter isDeviceConnectedOK is" + this.isDeviceConnectedOK));
                        break;
                    }
                    catch (LegoCheckedException e) {
                        this.logger.error((Object)"NPFilter-> deploy NPFilter by deploy error, ", (Throwable)e);
                        this.isDeviceConnectedOK = false;
                        errorCode = "lego.err." + e.getErrorCode();
                        deployResult.setErrorMsgKey(errorCode);
                    }
                    catch (Exception e) {
                        errorCode = "lego.err.631039";
                        deployResult.setErrorMsgKey(errorCode);
                    }
                }
                this.checkFilterResult(filterData.getNpFilterInfo().getId(), deployResult, false);
            }
        }
    }

    private void checkCmdResultList(List<String> cmds, List<String> cmdResult, NPFilterDeployResult deployResult) {
        String returnInfo;
        int i;
        Boolean flag = true;
        String errorMsgKey = "";
        String curCmd = "";
        String errorParam = "";
        for (i = 0; i < cmdResult.size(); ++i) {
            returnInfo = cmdResult.get(i);
            if (!SSL_ERROR.equals(returnInfo.trim())) continue;
            errorMsgKey = returnInfo;
            errorParam = "";
            flag = false;
            break;
        }
        if (flag.booleanValue()) {
            block1: for (i = 0; i < cmdResult.size(); ++i) {
                returnInfo = cmdResult.get(i);
                if (!flag.booleanValue()) break;
                for (Map.Entry<String, String> entry : this.errorMapping.entrySet()) {
                    returnInfo = returnInfo.toLowerCase(Locale.ENGLISH);
                    String key = entry.getKey().toLowerCase(Locale.ENGLISH);
                    Pattern p = Pattern.compile(key);
                    Matcher matcher = p.matcher(returnInfo);
                    if (!matcher.find()) continue;
                    errorMsgKey = entry.getValue();
                    if (null == cmds || cmds.size() <= i) {
                        flag = false;
                        continue block1;
                    }
                    errorParam = curCmd = cmds.get(i);
                    flag = false;
                    continue block1;
                }
            }
        }
        if ("".equals(deployResult.getErrorMsgKey())) {
            deployResult.setErrorMsgKey(errorMsgKey);
            deployResult.setErrorParam(errorParam);
        }
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private void checkFilterResult(Long filterId, NPFilterDeployResult deployResult, boolean isDeploy) {
        FilterDevicePair filterDevicePair = new FilterDevicePair(filterId, this.logicDev.getDeviceId());
        if (isDeploy) {
            this.logger.info((Object)("NPFilter-> deploy NPFilter by deploy,  deviceId : " + this.logicDev.getDeviceId() + ", filterId : " + filterId + ", errorcode : " + this.getcleanedMessage(deployResult.getErrorMsgKey())));
            this.filterDeployResult.put(filterDevicePair, deployResult);
        } else {
            this.logger.info((Object)("NPFilter-> undeploy NPFilter by deploy,  deviceId : " + this.logicDev.getDeviceId() + ", filterId : " + filterId + ", errorcode : " + this.getcleanedMessage(deployResult.getErrorMsgKey())));
            this.filterUnDeployResult.put(filterDevicePair, deployResult);
        }
    }
}

