/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.hcc.service.impl;

import com.hs.atic.rmi.hcc.HccAttackDataEntity;
import com.hs.atic.util.CrashThreadHandler;
import com.hs.atic.zone.dao.ZoneDao;
import com.hs.atic.zone.model.ZoneInfo;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.secservice.hcc.model.HccAttackBuffer;
import com.hs.vsm.secservice.hcc.model.HccAttackObject;
import com.hs.vsm.secservice.hcc.util.HccHttpsClient;
import com.hs.vsm.secservice.hcc.util.HccUtil;
import com.hs.vsm.secservice.nfa.util.JSONUtil;
import com.huawei.atic.secservice.nfa.restful.model.Result;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class InitHccAttackServiceImpl
implements InitializingBean,
DisposableBean {
    private final Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private int splitSize = 100;
    private HccAttackBuffer hccAttackBuffer;
    private ZoneDao zoneDao;
    private UploadHccAttackTread uploadHccAttackTread;
    private List<HccAttackDataEntity> tempList = new CopyOnWriteArrayList<HccAttackDataEntity>();
    private HccHttpsClient httpsClient = HccHttpsClient.getInstance();
    private long sleepTime = 300000L;

    public void destroy() throws Exception {
        if (null != this.uploadHccAttackTread) {
            this.uploadHccAttackTread.stop();
        }
    }

    public void afterPropertiesSet() throws Exception {
        HccUtil.initHccConfig(this.hccAttackBuffer, this.logger);
        if (this.hccAttackBuffer.getConfigMap().get("hccEnable").equals("true")) {
            this.uploadHccAttackTread = new UploadHccAttackTread();
            this.uploadHccAttackTread.setName("uploadHccAttackTread");
            this.uploadHccAttackTread.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)CrashThreadHandler.getInstance());
            this.uploadHccAttackTread.start();
        } else {
            this.logger.info((Object)("InitHccAttackServiceImpl hccEnable value is" + this.hccAttackBuffer.getConfigMap().get("hccEnable") + ",can not start UploadTread"));
        }
    }

    private String getZoneNameById(HccAttackDataEntity entity) {
        String customer = "";
        try {
            int index = 0;
            HashMap<Integer, String> param = new HashMap<Integer, String>();
            param.put(index, entity.getZoneId() + "");
            String sql = "SELECT * FROM t_atic_zone_info where zone_id=?";
            ZoneInfo zoneInfo = this.zoneDao.getZoneInfoForRestIf(sql, param);
            if (null != zoneInfo) {
                customer = zoneInfo.getZoneName();
            }
            return customer;
        }
        catch (Exception e) {
            this.logger.error((Object)"hcc getZoneNameById error:", (Throwable)e);
            return customer;
        }
    }

    public HccAttackBuffer getHccAttackBuffer() {
        return this.hccAttackBuffer;
    }

    public void setHccAttackBuffer(HccAttackBuffer hccAttackBuffer) {
        this.hccAttackBuffer = hccAttackBuffer;
    }

    public ZoneDao getZoneDao() {
        return this.zoneDao;
    }

    public void setZoneDao(ZoneDao zoneDao) {
        this.zoneDao = zoneDao;
    }

    private class UploadHccAttackTread
    extends Thread {
        private UploadHccAttackTread() {
        }

        @Override
        public void run() {
            try {
                if (null != InitHccAttackServiceImpl.this.hccAttackBuffer && null != InitHccAttackServiceImpl.this.hccAttackBuffer.getConfigMap()) {
                    InitHccAttackServiceImpl.this.sleepTime = Long.parseLong(InitHccAttackServiceImpl.this.hccAttackBuffer.getConfigMap().get("sleepTime"));
                }
                Thread.sleep(InitHccAttackServiceImpl.this.sleepTime);
            }
            catch (InterruptedException e) {
                InitHccAttackServiceImpl.this.logger.error((Object)("hcc UploadHccAttackThread sleep error:" + e));
            }
            InitHccAttackServiceImpl.this.logger.info((Object)"start to execute UploadHccAttackThread");
            while (true) {
                try {
                    while (null == InitHccAttackServiceImpl.this.hccAttackBuffer || InitHccAttackServiceImpl.this.hccAttackBuffer.getUploadQueue().size() <= 0) {
                    }
                    InitHccAttackServiceImpl.this.tempList = InitHccAttackServiceImpl.this.hccAttackBuffer.getUploadQueue().poll(500L, TimeUnit.MILLISECONDS);
                    InitHccAttackServiceImpl.this.logger.info((Object)("UploadHccAttackThread tempList:" + InitHccAttackServiceImpl.this.tempList));
                    this.createAndUpLoad(InitHccAttackServiceImpl.this.tempList);
                }
                catch (Exception e) {
                    InitHccAttackServiceImpl.this.logger.error((Object)("UploadHccAttackThread execute error:" + e));
                }
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException e) {
                    InitHccAttackServiceImpl.this.logger.error((Object)e);
                    continue;
                }
                break;
            }
        }

        private void createAndUpLoad(List<HccAttackDataEntity> list) {
            try {
                List<HccAttackDataEntity> temp = list.size() > InitHccAttackServiceImpl.this.splitSize ? list.subList(0, InitHccAttackServiceImpl.this.splitSize) : list;
                for (HccAttackDataEntity entity : temp) {
                    InitHccAttackServiceImpl.this.logger.info((Object)("before hcc entity:" + entity.toString()));
                    HccAttackObject hccAttackObject = this.reStrutData(entity);
                    InitHccAttackServiceImpl.this.logger.info((Object)("after hcc reStrutData entity:" + hccAttackObject.toString()));
                    try {
                        Result result = this.upLoadAttack(hccAttackObject, InitHccAttackServiceImpl.this.hccAttackBuffer);
                        if (null != result) continue;
                        InitHccAttackServiceImpl.this.logger.warn((Object)"hcc UpLoadAttack action result null");
                    }
                    catch (Exception e) {
                        InitHccAttackServiceImpl.this.logger.error((Object)"upLoadAttack error.", (Throwable)e);
                    }
                }
                InitHccAttackServiceImpl.this.tempList.removeAll(temp);
            }
            catch (Exception e) {
                InitHccAttackServiceImpl.this.logger.error((Object)("hcc CreateAndUpLoad error: " + e));
            }
        }

        private Result upLoadAttack(HccAttackObject hccAttackObject, HccAttackBuffer buffer) {
            Result result = null;
            try {
                if (null == buffer.getConfigMap() || null == buffer.getConfigMap().get("hccUri")) {
                    InitHccAttackServiceImpl.this.logger.warn((Object)"can not find hccUriUri from hcc.properties");
                    return null;
                }
                String unicomCleanAlarmUri = buffer.getConfigMap().get("hccUri");
                String json = JSONUtil.getInstance().toJSON(hccAttackObject);
                result = InitHccAttackServiceImpl.this.httpsClient.doHttpsPost(json, unicomCleanAlarmUri);
            }
            catch (IOException e) {
                result = new Result();
                result.setJson(e.getMessage());
                InitHccAttackServiceImpl.this.logger.error((Object)("hcc upLoadAlarm method is exception," + e));
                return result;
            }
            return result;
        }

        private HccAttackObject reStrutData(HccAttackDataEntity entity) {
            String customer = InitHccAttackServiceImpl.this.getZoneNameById(entity);
            String attackType = "";
            int type = entity.getAttackType();
            if (!(null == InitHccAttackServiceImpl.this.hccAttackBuffer || null == InitHccAttackServiceImpl.this.hccAttackBuffer.getAttackTypeMap() || null == InitHccAttackServiceImpl.this.hccAttackBuffer.getAttackTypeMap().get(type) && "".equals(InitHccAttackServiceImpl.this.hccAttackBuffer.getAttackTypeMap().get(type)))) {
                if (type >= 2000 && type < 80000) {
                    type = 2000;
                }
                attackType = InitHccAttackServiceImpl.this.hccAttackBuffer.getAttackTypeMap().get(type);
            }
            String avgBps = String.valueOf(entity.getAvgBps());
            String maxBps = String.valueOf(entity.getMaxBps());
            String startTime = HccUtil.longToIOS(entity.getStartTime(), InitHccAttackServiceImpl.this.logger);
            String endTime = HccUtil.longToIOS(entity.getEndTime(), InitHccAttackServiceImpl.this.logger);
            String attackPort = null == entity.getAttackPort() ? "" : entity.getAttackPort();
            HccAttackObject object = new HccAttackObject(entity.getAttackIp(), attackPort, "", "", attackType, avgBps, maxBps, "", "", "", "", customer, startTime, endTime);
            return object;
        }
    }
}

