/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.hcc.util;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.secservice.nfa.restful.model.Result;
import com.huawei.atic.secservice.nfa.restful.util.MyX509TrustManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;

public final class HccHttpsClient {
    private static final HccHttpsClient INSTANCE = new HccHttpsClient();
    private final Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private SSLConnectionSocketFactory socketFactory;

    private HccHttpsClient() {
    }

    public static HccHttpsClient getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result doHttpsPost(String objectJson, String uri) throws IOException {
        this.logger.info((Object)("doHttpsPost is start.objectJson is:" + objectJson + ",and uri is:" + uri));
        Result result = new Result();
        try {
            this.enableSSL();
        }
        catch (Exception e) {
            result.setJson("hcc certificate is error");
            return result;
        }
        RequestConfig defaultRequestConfig = RequestConfig.custom().setCookieSpec("standard-strict").setExpectContinueEnabled(true).setTargetPreferredAuthSchemes(Arrays.asList("NTLM", "Digest")).setProxyPreferredAuthSchemes(Arrays.asList("Basic")).build();
        Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)this.socketFactory).build();
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        CloseableHttpClient httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).setDefaultRequestConfig(defaultRequestConfig).build();
        InputStream inputStream = null;
        InputStreamReader inputStreamReader = null;
        BufferedReader reader = null;
        try {
            HttpPost post = new HttpPost(uri);
            StringEntity entity = new StringEntity(objectJson);
            entity.setContentEncoding("utf-8");
            entity.setContentType("application/json");
            ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
            nvps.add(new BasicNameValuePair("Content", objectJson));
            UrlEncodedFormEntity entity11 = new UrlEncodedFormEntity(nvps, "UTF-8");
            post.setEntity((HttpEntity)entity11);
            post.getParams().setParameter("Content", (Object)entity);
            CloseableHttpResponse response = null;
            try {
                response = httpClient.execute((HttpUriRequest)post);
            }
            catch (Exception e) {
                if (null != e.getMessage()) {
                    if (e.getMessage().contains("certificate is illegal")) {
                        result.setJson("hcc certificate is illegal");
                    } else if (e.getMessage().contains("Connection timed out")) {
                        result.setJson("hcc Connection timed out");
                    }
                }
                if (StringUtils.isEmpty((CharSequence)result.getJson())) {
                    result.setJson("hcc certificate is error");
                }
                this.logger.error((Object)("hcc doHttpsPost is over,and send data error. result = " + result + ";json =" + objectJson));
                Result result2 = result;
                this.closeReader(reader);
                this.closeInputStreamAndInputStreamReader(inputStream, inputStreamReader);
                this.closeHttpClient(httpClient);
                return result2;
            }
            if (response != null) {
                int httpCode = response.getStatusLine().getStatusCode();
                result.setStatusCode(httpCode);
                if (httpCode == 200) {
                    HttpEntity entity2 = response.getEntity();
                    inputStream = entity2.getContent();
                    inputStreamReader = new InputStreamReader(inputStream, "utf-8");
                    reader = new BufferedReader(inputStreamReader);
                    StringBuffer stringBuffer = new StringBuffer();
                    char[] cbuf = new char[2048];
                    while (reader.read(cbuf) > 0) {
                        stringBuffer.append(String.valueOf(cbuf));
                        if (stringBuffer.length() < 10000) continue;
                    }
                    if (stringBuffer.length() >= 10000) {
                        result.setJson("");
                    } else {
                        result.setJson(stringBuffer.toString().trim());
                    }
                }
                this.logger.info((Object)("hcc doHttpsPost is over, result = " + result + ";json =" + objectJson));
            }
        }
        finally {
            this.closeReader(reader);
            this.closeInputStreamAndInputStreamReader(inputStream, inputStreamReader);
            this.closeHttpClient(httpClient);
        }
        this.logger.info((Object)("hcc doHttpsPost is end:objectJson is:" + objectJson + ",and uri is:" + uri + " and result is:" + result));
        return result;
    }

    private void closeHttpClient(CloseableHttpClient httpClient) {
        try {
            if (null != httpClient) {
                httpClient.close();
            }
        }
        catch (IOException e) {
            this.logger.error((Object)"closeHttpClient is failed, result = ", (Throwable)e);
        }
        finally {
            httpClient = null;
        }
    }

    private void closeReader(BufferedReader reader) {
        try {
            if (null != reader) {
                reader.close();
            }
        }
        catch (IOException e) {
            this.logger.error((Object)"closeReader is failed, result = ", (Throwable)e);
        }
        finally {
            reader = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeInputStreamAndInputStreamReader(InputStream inputStream, InputStreamReader inputStreamReader) {
        try {
            if (null != inputStreamReader) {
                inputStreamReader.close();
            }
            if (null != inputStream) {
                inputStream.close();
            }
        }
        catch (IOException e) {
            this.logger.error((Object)"close inputStreamReader or inputStream failed!");
        }
        finally {
            inputStreamReader = null;
            inputStream = null;
        }
    }

    private void enableSSL() {
        try {
            MyX509TrustManager tm = MyX509TrustManager.getInstance();
            SSLContext context = SSLContext.getInstance("TLS");
            context.init(null, new TrustManager[]{tm}, new SecureRandom());
            this.socketFactory = new SSLConnectionSocketFactory(context, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        }
        catch (NoSuchAlgorithmException e) {
            this.logger.error((Object)("SSL is error," + e));
        }
        catch (KeyManagementException e) {
            this.logger.error((Object)("SSL is error," + e));
        }
    }
}

