/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.hcc.util;

import com.hs.lego.core.sdk.log.Log;
import com.hs.vsm.secservice.hcc.model.HccAttackBuffer;
import com.hs.vsm.secservice.hcc.service.impl.InitHccAttackServiceImpl;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class HccUtil {
    public static String longToIOS(long time, Log logger) {
        try {
            Date date = new Date(time);
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
            return df.format(date);
        }
        catch (Exception e) {
            logger.error((Object)"hcc longToIOS error:", (Throwable)e);
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initHccConfig(HccAttackBuffer hccAttackBuffer, Log logger) {
        InputStream iStream = null;
        HashMap<String, String> configMap = new HashMap<String, String>();
        try {
            iStream = InitHccAttackServiceImpl.class.getResourceAsStream("/hcc.properties");
            Properties properties = new Properties();
            properties.load(iStream);
            String hccEnable = properties.getProperty("hccEnable");
            String hccUri = properties.getProperty("hccURL");
            String isTest = properties.getProperty("isTest");
            String sleepTime = properties.getProperty("sleepTime");
            configMap.put("hccEnable", hccEnable);
            configMap.put("hccUri", hccUri);
            configMap.put("isTest", isTest);
            configMap.put("sleepTime", sleepTime);
            hccAttackBuffer.setConfigMap(configMap);
            hccAttackBuffer.setAttackTypeMap(HccUtil.getAttackMap());
            logger.info((Object)("initHccConfig hccAttackBuffer.getConfigMap is :" + hccAttackBuffer.getConfigMap().toString()));
        }
        catch (FileNotFoundException e) {
            logger.error((Object)"initHccConfig FileInputStream is  error.");
        }
        catch (IOException e) {
            logger.error((Object)"initHccConfig properties load data is error.");
        }
        finally {
            try {
                if (null != iStream) {
                    iStream.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)"initHccConfig InputStream close is error.");
            }
        }
    }

    public static Map<Integer, String> getAttackMap() {
        HashMap<Integer, String> attackMap = new HashMap<Integer, String>();
        attackMap.put(0, "Custom Service Bandwidth Overflow");
        attackMap.put(10, "SYN Flood");
        attackMap.put(11, "ACK Flood");
        attackMap.put(12, "SYN-ACK Flood");
        attackMap.put(13, "FIN/RST Flood");
        attackMap.put(14, "Concurrent Connections Flood");
        attackMap.put(15, "New Connections Flood");
        attackMap.put(16, "TCP Fragment Flood");
        attackMap.put(17, "TCP Fragment Bandwidth Overflow");
        attackMap.put(18, "TCP Bandwidth Overflow");
        attackMap.put(19, "UDP Flood");
        attackMap.put(20, "UDP Fragment Flood");
        attackMap.put(21, "UDP Fragment Bandwidth Overflow");
        attackMap.put(22, "UDP Bandwidth Overflow");
        attackMap.put(23, "ICMP Flood");
        attackMap.put(24, "Other Bandwidth Overflow");
        attackMap.put(25, "Single IP Bandwidth Overflow");
        attackMap.put(26, "HTTPS Flood");
        attackMap.put(27, "HTTP Flood");
        attackMap.put(29, "DNS Query Flood");
        attackMap.put(30, "DNS Reply Flood");
        attackMap.put(31, "SIP Flood");
        attackMap.put(32, "Blacklist");
        attackMap.put(33, "URI Monitor");
        attackMap.put(34, "Global TCP Fragment Abnormal");
        attackMap.put(35, "Global TCP Abnormal");
        attackMap.put(36, "Global UDP Fragment Abnormal");
        attackMap.put(37, "Global UDP Abnormal");
        attackMap.put(38, "Global ICMP Abnormal");
        attackMap.put(39, "Global Other Abnormal");
        attackMap.put(40, "TCP Connection Flood");
        attackMap.put(41, "Domain Hijacking");
        attackMap.put(42, "DNS Cache Poisoning");
        attackMap.put(43, "DNS Reflection");
        attackMap.put(44, "DNS Size Abnormal");
        attackMap.put(45, "Source DNS Request Flow Abnormal");
        attackMap.put(46, "Source DNS Reply Flow Abnormal");
        attackMap.put(47, "DNS Request Domain Flow Abnormal");
        attackMap.put(48, "DNS Reply Domain Flow Abnormal");
        attackMap.put(49, "DNS IP TTL Check Fail");
        attackMap.put(50, "DNS Format Error");
        attackMap.put(51, "DNS Cache Match");
        attackMap.put(52, "Port Scanning Attack");
        attackMap.put(53, "TCP Malformed");
        attackMap.put(54, "BGP Flood Attack");
        attackMap.put(55, "TCP-authenticated UDP Attack");
        attackMap.put(56, "DNS No Such Name");
        attackMap.put(57, "Other Flood");
        attackMap.put(58, "Zone Bandwidth Overflow");
        attackMap.put(59, "HTTP Slow Attack");
        attackMap.put(60, "Botnets/Trojan horses/Worms Attack");
        attackMap.put(61, "Malicious Domains Attack");
        attackMap.put(62, "Filter Attack");
        attackMap.put(63, "Web Attack");
        attackMap.put(64, "SIP Source Rate Abnormity");
        attackMap.put(65, "Anti-Malware");
        attackMap.put(66, "IP Reputation");
        attackMap.put(67, "Location Attack");
        attackMap.put(68, "Destination IP new session rate limiting");
        attackMap.put(69, "TCP Protocol Block");
        attackMap.put(70, "UDP Protocol Block");
        attackMap.put(71, "ICMP Protocol Block");
        attackMap.put(72, "Other Protocol Block");
        attackMap.put(73, "Host Traffic Over Flow");
        attackMap.put(74, "UDP Malformed");
        attackMap.put(75, "TCP Dport Traffic Limit");
        attackMap.put(76, "TCP Dport Relation Defense");
        attackMap.put(99, "Dark IP");
        attackMap.put(101, "Infoleak Exploit(udp)");
        attackMap.put(102, "Iquery IRIX Exploit ");
        attackMap.put(103, "Iquery Linux Exploit ");
        attackMap.put(104, "Iquery Free BSD Exploit ");
        attackMap.put(105, "NXT Buffer Overflow Exploit");
        attackMap.put(106, "TSIG Buffer Overflow Exploit ");
        attackMap.put(107, "TSIG Buffer Overflow Exploit (named) ");
        attackMap.put(108, "TSIG Exploit (LSD)");
        attackMap.put(109, "Iquery Buffer Overflow Exploit (Linux)");
        attackMap.put(110, "TSIG Buffer Overflow Exploit (named) ");
        attackMap.put(111, "Compression Pointer Denial-of-Service");
        attackMap.put(112, "DNS Response Buffer Overflow");
        attackMap.put(113, "TSIG Buffer Overflow (General)");
        attackMap.put(114, "Internationalized Domain Name (IDN) Request");
        attackMap.put(115, "Iquery Buffer Overflow Exploit (Linux) ");
        attackMap.put(116, "Phishing Subdomain Name Request");
        attackMap.put(117, "PROTOS Suite Attack (Query)");
        attackMap.put(118, "PROTOS Suite Attack (Response)");
        attackMap.put(119, "TXT Response Overflow");
        attackMap.put(120, "ATMA Response Overflow (UDP)");
        attackMap.put(121, "Suspicious Localhost PTR Record Response");
        attackMap.put(122, "Tunneling: Iodine DNS Tunneling Request");
        attackMap.put(123, "Tunneling: Iodine DNS Tunneling Response");
        attackMap.put(124, "NetBIOS: Reserved Proxy Host Name Registration");
        attackMap.put(125, "Multiple Vendors libspf2 Record Parsing Buffer Overflow");
        attackMap.put(126, "MailEnable SMTP Service SPF Lookup Buffer Overflow");
        attackMap.put(127, "Windows SMTP Service Denial of Service via Crafted DNS MX Records");
        attackMap.put(128, "Tunneling: Ozymandns DNS Tunneling Response");
        attackMap.put(129, "Tunneling: Ozymandns DNS Tunneling Request");
        attackMap.put(130, "Morto worm DNS Response");
        attackMap.put(1008, "Spyware(Anti-Malware)");
        attackMap.put(1009, "WEB Injection(Anti-Malware)");
        attackMap.put(1010, "C&C");
        attackMap.put(1011, "DoS(Anti-Malware)");
        attackMap.put(2000, "Filter Attack");
        attackMap.put(80000, "Hardware Filter Attack");
        return attackMap;
    }
}

