/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.nfa.restful.deploy;

import com.hs.atic.sdk.res.service.ILicenseOutboundService;
import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.atic.sdk.zone.service.IZoneService;
import com.hs.atic.zone.util.ZoneUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.vsm.secservice.ddos.dao.ZoneDeviceDeployStatusDao;
import com.hs.vsm.secservice.ddos.dao.ZoneServiceDao;
import com.hs.vsm.secservice.ddos.model.ZoneDeviceDeployStatusInfo;
import com.hs.vsm.secservice.ddos.model.ZoneServiceInfo;
import com.hs.vsm.secservice.nfa.restful.deploy.FormTransObject;
import com.hs.vsm.secservice.nfa.restful.deploy.InitNfaDeployData;
import com.hs.vsm.secservice.sdk.module.ddos.Constant;
import com.hs.vsm.secservice.sdk.module.ddos.form.NfaPolicyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneDeviceForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZonePolicyApplyForm;
import com.hs.vsm.secservice.sdk.module.ddos.service.INfaPolicyService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneDeviceService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneFeatureStatusService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZonePolicyApplyService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.device.model.AticDeviceNfa;
import com.huawei.atic.device.model.AticDeviceNfaCluster;
import com.huawei.atic.secne.sdk.service.IAticDeviceNfaService;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.huawei.atic.secne.sdk.service.IClusterService;
import com.huawei.atic.secservice.nfa.restful.model.FilterPolicyObject;
import com.huawei.atic.secservice.nfa.restful.model.NfaInfoForm;
import com.huawei.atic.secservice.nfa.restful.model.PolicyObject;
import com.huawei.atic.secservice.nfa.restful.model.Result;
import com.huawei.atic.secservice.nfa.restful.model.ZoneInfoObject;
import com.huawei.atic.secservice.nfa.restful.model.ZoneIpObject;
import com.huawei.atic.secservice.nfa.restful.model.ZonePolicyObject;
import com.huawei.atic.secservice.nfa.restful.sdk.service.IRestfulNfaService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class DeployNfaPolicy {
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private IZoneDeviceService zoneDeviceService;
    private IAticDeviceService aticDeviceService;
    private IAticDeviceNfaService aticDeviceNfaService;
    private INfaPolicyService nfaPolicyService;
    private IRestfulNfaService restfulNfaService;
    private FormTransObject formTransObject;
    private IZonePolicyApplyService zonePolicyApplyService;
    private IZoneService zoneService;
    private ZoneDeviceDeployStatusDao zoneDeviceDeployStatusDao;
    private ZoneServiceDao zoneServiceDao;
    private IZoneFeatureStatusService zoneFeatureStatusService;
    private IClusterService clusterService;
    private ILicenseOutboundService licenseOutboundService;

    public void deployNfaPolicy(List<Long> zoneIdList) {
        for (Long zoneId : zoneIdList) {
            List<NfaInfoForm> nfaInfoForms;
            if (!this.isContainsNfa(zoneId) || (nfaInfoForms = this.getNfaInfoForm(zoneId)).isEmpty()) continue;
            for (NfaInfoForm nfaInfoForm : nfaInfoForms) {
                int i;
                PolicyObject[] policyObject;
                FilterPolicyObject filterPolicyObject;
                List<NfaPolicyForm> nfaPolicyForms;
                Result result = null;
                Long deviceId = nfaInfoForm.getDeviceId();
                Long clusterId = nfaInfoForm.getClusterId();
                List<NfaPolicyForm> nfaOutboundPolicyForms = null;
                ZonePolicyObject zonePolicyObject = new ZonePolicyObject();
                if (null != clusterId) {
                    nfaPolicyForms = this.nfaPolicyService.getNfaPolicyForm(zoneId, clusterId);
                    nfaOutboundPolicyForms = this.nfaPolicyService.getOutboundNfaPolicyForm(zoneId, clusterId);
                    filterPolicyObject = InitNfaDeployData.queryFilterData(zoneId, clusterId, 2);
                    zonePolicyObject.setFilterOut(filterPolicyObject);
                    filterPolicyObject = InitNfaDeployData.queryFilterData(zoneId, clusterId, 1);
                    zonePolicyObject.setFilterIn(filterPolicyObject);
                } else {
                    nfaPolicyForms = this.nfaPolicyService.getNfaPolicyForm(zoneId, deviceId);
                    nfaOutboundPolicyForms = this.nfaPolicyService.getOutboundNfaPolicyForm(zoneId, deviceId);
                    filterPolicyObject = InitNfaDeployData.queryFilterData(zoneId, deviceId, 2);
                    zonePolicyObject.setFilterOut(filterPolicyObject);
                    filterPolicyObject = InitNfaDeployData.queryFilterData(zoneId, deviceId, 1);
                    zonePolicyObject.setFilterIn(filterPolicyObject);
                }
                if (null != nfaPolicyForms && !nfaPolicyForms.isEmpty()) {
                    policyObject = new PolicyObject[nfaPolicyForms.size()];
                    i = 0;
                    for (NfaPolicyForm nfaPolicyForm : nfaPolicyForms) {
                        policyObject[i] = this.formTransObject.nfaPolicyFormTransfObject(nfaPolicyForm);
                        ++i;
                    }
                    ZoneUtil.addNfaZoneType(zonePolicyObject, zoneId);
                    zonePolicyObject.setPolicyIn(policyObject);
                }
                if (null != nfaOutboundPolicyForms && !nfaOutboundPolicyForms.isEmpty()) {
                    policyObject = new PolicyObject[nfaOutboundPolicyForms.size()];
                    i = 0;
                    for (NfaPolicyForm nfaPolicyForm : nfaOutboundPolicyForms) {
                        policyObject[i] = this.formTransObject.nfaPolicyFormTransfObject(nfaPolicyForm);
                        ++i;
                    }
                    ZoneUtil.addNfaZoneType(zonePolicyObject, zoneId);
                    zonePolicyObject.setPolicyOut(policyObject);
                }
                ZoneInfoObject zoneInfoObject = new ZoneInfoObject();
                ZoneInfoForm zoneInfoForm = this.zoneService.getById(zoneId);
                if (null != zoneInfoForm) {
                    if (zoneInfoForm.getZoneType().intValue() == Constant.ZONE_TYPE_OF_DEFAULT.intValue()) {
                        zoneInfoObject.setZoneId(1L);
                        zoneInfoObject.setZoneName("default");
                    } else {
                        zoneInfoObject.setZoneId(zoneId.longValue());
                        zoneInfoObject.setZoneName(zoneInfoForm.getZoneName());
                    }
                } else {
                    this.logger.error((Object)("deployNfaPolicy(), zoneInfoForm is null, zoneId = " + zoneId));
                    continue;
                }
                try {
                    result = this.restfulNfaService.addZoneOnNFA(zoneInfoObject, nfaInfoForm);
                    if (result.getStatusCode() == 200 && result.getJson().contains("ok")) {
                        if (zoneInfoObject.getZoneId() != (long)Constant.ZONE_TYPE_OF_DEFAULT.intValue()) {
                            result = this.restfulNfaService.restNfaDelALLZoneIp(zoneInfoObject, nfaInfoForm);
                        }
                        if (result.getStatusCode() == 200 && result.getJson().contains("ok")) {
                            result = this.deployZoneIp(zoneInfoForm, nfaInfoForm);
                            if (result.getStatusCode() == 200 && result.getJson().contains("ok")) {
                                result = this.restfulNfaService.restNfaZonePolicy(zonePolicyObject, nfaInfoForm);
                                List<ZoneServiceInfo> infoList = null != clusterId ? this.zoneServiceDao.getByZoneIdAndDeviceId(zoneId.toString(), nfaInfoForm.getClusterId().toString()) : this.zoneServiceDao.getByZoneIdAndDeviceId(zoneId.toString(), nfaInfoForm.getDeviceId().toString());
                                if (!infoList.isEmpty()) {
                                    for (ZoneServiceInfo info : infoList) {
                                        info.setDeployedCrc(info.getCurrentCrc());
                                        this.zoneServiceDao.update(info);
                                    }
                                }
                                this.zoneFeatureStatusService.createOrUpdateZoneIpFeatureStatus(zoneInfoForm, deviceId);
                            } else if (null != result.getJson() && result.getJson().contains("out of range")) {
                                this.logger.error((Object)("restNfaAddZoneIp error, result.getStatusCode is " + result.getStatusCode() + "result.getJson is" + this.getcleanedMessage(result.getJson())));
                            } else {
                                this.logger.error((Object)("restNfaAddZoneIp error, result.getStatusCode is " + result.getStatusCode() + "result.getJson is" + this.getcleanedMessage(result.getJson())));
                                result.setJson("add ip error");
                            }
                        } else {
                            this.logger.error((Object)("restNfaDelALLZoneIp error, result.getStatusCode is " + result.getStatusCode() + "result.getJson is" + this.getcleanedMessage(result.getJson())));
                            result.setJson("deleteAll ip error");
                        }
                    } else if (result.getJson().contains("Connection timed out: connect")) {
                        this.logger.error((Object)("addZoneOnNFA error," + this.getcleanedMessage(result.getJson())));
                    } else if (result.getJson().contains("certificate is error")) {
                        this.logger.error((Object)"certificate is error.");
                    } else {
                        this.logger.error((Object)("addZoneOnNFA error, result.getStatusCode is " + result.getStatusCode() + "result.getJson is" + this.getcleanedMessage(result.getJson())));
                        result.setJson("zone error");
                    }
                }
                catch (RuntimeException e) {
                    this.logger.error((Object)"deployNfaPolicy() is RuntimeException,", (Throwable)e);
                }
                this.updateDeployNfaResult(result, zoneId, nfaInfoForm);
            }
        }
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private Result deployZoneIp(ZoneInfoForm zoneInfoForm, NfaInfoForm nfaInfoForm) {
        ZoneIpObject zoneIpObject = new ZoneIpObject();
        Result result = new Result();
        if (zoneInfoForm.getZoneType().intValue() == Constant.ZONE_TYPE_OF_DEFAULT.intValue()) {
            zoneIpObject.setZoneId(Long.valueOf(1L));
        } else {
            zoneIpObject.setZoneId(zoneInfoForm.getZoneId());
        }
        if (null != zoneInfoForm.getZoneIpFormList() && !zoneInfoForm.getZoneIpFormList().isEmpty()) {
            int i;
            ArrayList<String> ipv4List = new ArrayList<String>();
            ArrayList<String> ipv6List = new ArrayList<String>();
            for (int i2 = 0; i2 < zoneInfoForm.getZoneIpFormList().size(); ++i2) {
                String ipString = zoneInfoForm.getZoneIpFormList().get(i2).getZoneIp();
                Integer mask = zoneInfoForm.getZoneIpFormList().get(i2).getMask();
                if (IPUtil.isIpv4((String)ipString)) {
                    ipv4List.add(ipString + "/" + mask);
                    continue;
                }
                if (!IPUtil.isIpv6((String)ipString)) continue;
                ipv6List.add(ipString + "/" + mask);
            }
            if (ipv4List.size() > 10000 || ipv6List.size() > 10000) {
                result.setJson("out of range");
                return result;
            }
            String[] ip = null;
            String[] ipV6 = null;
            int ipV4Num = ipv4List.size() / 1000;
            int ipV6Num = ipv6List.size() / 1000;
            int ipV4N = ipv4List.size() % 1000;
            int ipV6N = ipv6List.size() % 1000;
            if (0 != ipV4N) {
                ++ipV4Num;
            }
            if (0 != ipV6N) {
                ++ipV6Num;
            }
            for (i = 1; i <= ipV4Num; ++i) {
                ip = i == ipV4Num && 0 != ipV4N ? ipv4List.subList((i - 1) * 1000, ipv4List.size()).toArray(new String[ipV4N]) : ipv4List.subList((i - 1) * 1000, i * 1000).toArray(new String[1000]);
                zoneIpObject.setZoneIp(ip);
                result = this.restfulNfaService.restNfaAddZoneIp(zoneIpObject, nfaInfoForm);
                if (result.getStatusCode() != 200 || !result.getJson().contains("ok")) {
                    return result;
                }
                zoneIpObject.setZoneIp(null);
            }
            for (i = 1; i <= ipV6Num; ++i) {
                ipV6 = i == ipV6Num && 0 != ipV6N ? ipv6List.subList((i - 1) * 1000, ipv6List.size()).toArray(new String[ipV6N]) : ipv6List.subList((i - 1) * 1000, i * 1000).toArray(new String[1000]);
                zoneIpObject.setZoneIpV6(ipV6);
                result = this.restfulNfaService.restNfaAddZoneIp(zoneIpObject, nfaInfoForm);
                if (result.getStatusCode() != 200 || !result.getJson().contains("ok")) {
                    return result;
                }
                zoneIpObject.setZoneIpV6(null);
            }
        } else {
            result.setStatusCode(200);
            result.setJson("ok");
        }
        return result;
    }

    private void updateDeployNfaResult(Result result, Long zoneId, NfaInfoForm nfaInfoForm) {
        ZonePolicyApplyForm zonePolicyApplyForm = this.zonePolicyApplyService.queryByZoneId(zoneId);
        if (null != zonePolicyApplyForm) {
            if (result.getStatusCode() == 200 && result.getJson().contains("ok")) {
                zonePolicyApplyForm.setDeployState("SUCCESS");
                this.zonePolicyApplyService.update(zonePolicyApplyForm);
                String errorCode = "--";
                this.saveZoneDeviceDeployStatus(errorCode, zoneId, nfaInfoForm);
            } else {
                zonePolicyApplyForm.setDeployState("PART_SUCCESS");
                this.zonePolicyApplyService.update(zonePolicyApplyForm);
                String errorCode = "";
                errorCode = result.getStatusCode() == 462 ? "9" : (null != result.getJson() && result.getJson().contains("Connection timed out: connect") ? "offLine" : (null != result.getJson() && result.getJson().contains("certificate is error") ? "certificate" : (null != result.getJson() && result.getJson().contains("out of range") ? "outOfRange" : (null != result.getJson() && result.getJson().equals("zone error") ? "5" : (null != result.getJson() && result.getJson().equals("deleteAll ip error") ? "9" : (null != result.getJson() && result.getJson().equals("add ip error") ? "6" : "7"))))));
                this.saveZoneDeviceDeployStatus(errorCode, zoneId, nfaInfoForm);
            }
        }
    }

    public void saveZoneDeviceDeployStatus(String errorCode, Long zoneId, NfaInfoForm nfaInfoForm) {
        ZoneDeviceDeployStatusInfo zoneDeviceDeployStatusInfo = null;
        zoneDeviceDeployStatusInfo = this.zoneDeviceDeployStatusDao.getOneByZoneIdAndDeviceId(zoneId, nfaInfoForm.getDeviceId(), 3);
        if (null != zoneDeviceDeployStatusInfo) {
            zoneDeviceDeployStatusInfo.setZoneId(zoneId);
            zoneDeviceDeployStatusInfo.setDeviceId(nfaInfoForm.getDeviceId());
            zoneDeviceDeployStatusInfo.setDeployState("--".equals(errorCode));
            zoneDeviceDeployStatusInfo.setDeployType(3);
            zoneDeviceDeployStatusInfo.setErrorMsgKey("--".equals(errorCode) ? "--" : "lego.err." + errorCode);
            zoneDeviceDeployStatusInfo.setDeployTime(new Date());
            this.zoneDeviceDeployStatusDao.update(zoneDeviceDeployStatusInfo);
        } else {
            zoneDeviceDeployStatusInfo = new ZoneDeviceDeployStatusInfo();
            zoneDeviceDeployStatusInfo.setZoneId(zoneId);
            zoneDeviceDeployStatusInfo.setDeviceId(nfaInfoForm.getDeviceId());
            zoneDeviceDeployStatusInfo.setDeployState("--".equals(errorCode));
            zoneDeviceDeployStatusInfo.setDeployType(3);
            zoneDeviceDeployStatusInfo.setErrorMsgKey("--".equals(errorCode) ? "--" : "lego.err." + errorCode);
            zoneDeviceDeployStatusInfo.setDeployTime(new Date());
            this.zoneDeviceDeployStatusDao.save(zoneDeviceDeployStatusInfo);
        }
    }

    public boolean isContainsNfa(long zoneId) {
        List deviceIdList = this.zoneDeviceService.getDeviceIdsByZoneId(Long.valueOf(zoneId));
        if (null == deviceIdList || deviceIdList.isEmpty()) {
            return false;
        }
        for (Long deviceIdLong : deviceIdList) {
            AticDevice device = this.aticDeviceService.getDeviceByMoid(deviceIdLong.longValue());
            if (null == device || 5 != device.getDeviceType() && 7 != device.getDeviceType()) continue;
            return true;
        }
        return false;
    }

    public List<NfaInfoForm> getNfaInfoForm(Long zoneId) {
        ArrayList<NfaInfoForm> nfaInfoForms = new ArrayList<NfaInfoForm>();
        List<AticDeviceNfaCluster> nfaDeviceList = this.getNfaDeviceList(zoneId);
        for (AticDeviceNfaCluster nfaCluster : nfaDeviceList) {
            AticDevice aticDevice = this.aticDeviceService.getDeviceByMoid(nfaCluster.getDeviceId().longValue());
            if (aticDevice.getDeviceType() != 5 && aticDevice.getDeviceType() != 7) continue;
            NfaInfoForm nfaInfoForm = new NfaInfoForm();
            nfaInfoForm.setIpAdress(aticDevice.getIpAddress());
            AticDeviceNfa aticDeviceNfa = this.aticDeviceNfaService.findByMoid(nfaCluster.getDeviceId());
            nfaInfoForm.setDeviceId(nfaCluster.getDeviceId());
            nfaInfoForm.setApiKey(aticDeviceNfa.getApiKey());
            nfaInfoForm.setPort(aticDeviceNfa.getRestfulPort().intValue());
            if (null != nfaCluster.getClusterId()) {
                nfaInfoForm.setClusterId(nfaCluster.getClusterId());
            }
            nfaInfoForms.add(nfaInfoForm);
        }
        return nfaInfoForms;
    }

    private List<AticDeviceNfaCluster> getNfaDeviceList(Long zoneId) {
        List aticDeviceList = this.zoneDeviceService.getByZoneId(zoneId);
        ArrayList<AticDeviceNfaCluster> bindNfaList = new ArrayList<AticDeviceNfaCluster>();
        for (ZoneDeviceForm zoneForm : aticDeviceList) {
            Long deviceId = zoneForm.getDeviceId();
            AticDevice aticDevice = this.aticDeviceService.getDeviceByMoid(deviceId.longValue());
            if (aticDevice.getDeviceType() == 7) {
                List nfaClusters = this.clusterService.getBindNfaDevice(deviceId);
                for (AticDeviceNfaCluster nfaCluster : nfaClusters) {
                    bindNfaList.add(nfaCluster);
                }
                continue;
            }
            AticDeviceNfaCluster nfaCluster = new AticDeviceNfaCluster();
            nfaCluster.setDeviceId(Long.valueOf(aticDevice.getMoId()));
            bindNfaList.add(nfaCluster);
        }
        return bindNfaList;
    }

    public IZoneDeviceService getZoneDeviceService() {
        return this.zoneDeviceService;
    }

    public void setZoneDeviceService(IZoneDeviceService zoneDeviceService) {
        this.zoneDeviceService = zoneDeviceService;
    }

    public IAticDeviceService getAticDeviceService() {
        return this.aticDeviceService;
    }

    public void setAticDeviceService(IAticDeviceService aticDeviceService) {
        this.aticDeviceService = aticDeviceService;
    }

    public IAticDeviceNfaService getAticDeviceNfaService() {
        return this.aticDeviceNfaService;
    }

    public void setAticDeviceNfaService(IAticDeviceNfaService aticDeviceNfaService) {
        this.aticDeviceNfaService = aticDeviceNfaService;
    }

    public INfaPolicyService getNfaPolicyService() {
        return this.nfaPolicyService;
    }

    public void setNfaPolicyService(INfaPolicyService nfaPolicyService) {
        this.nfaPolicyService = nfaPolicyService;
    }

    public IRestfulNfaService getRestfulNfaService() {
        return this.restfulNfaService;
    }

    public void setRestfulNfaService(IRestfulNfaService restfulNfaService) {
        this.restfulNfaService = restfulNfaService;
    }

    public FormTransObject getFormTransObject() {
        return this.formTransObject;
    }

    public void setFormTransObject(FormTransObject formTransObject) {
        this.formTransObject = formTransObject;
    }

    public IZonePolicyApplyService getZonePolicyApplyService() {
        return this.zonePolicyApplyService;
    }

    public void setZonePolicyApplyService(IZonePolicyApplyService zonePolicyApplyService) {
        this.zonePolicyApplyService = zonePolicyApplyService;
    }

    public IZoneService getZoneService() {
        return this.zoneService;
    }

    public void setZoneService(IZoneService zoneService) {
        this.zoneService = zoneService;
    }

    public ZoneDeviceDeployStatusDao getZoneDeviceDeployStatusDao() {
        return this.zoneDeviceDeployStatusDao;
    }

    public void setZoneDeviceDeployStatusDao(ZoneDeviceDeployStatusDao zoneDeviceDeployStatusDao) {
        this.zoneDeviceDeployStatusDao = zoneDeviceDeployStatusDao;
    }

    public ZoneServiceDao getZoneServiceDao() {
        return this.zoneServiceDao;
    }

    public void setZoneServiceDao(ZoneServiceDao zoneServiceDao) {
        this.zoneServiceDao = zoneServiceDao;
    }

    public IZoneFeatureStatusService getZoneFeatureStatusService() {
        return this.zoneFeatureStatusService;
    }

    public void setZoneFeatureStatusService(IZoneFeatureStatusService zoneFeatureStatusService) {
        this.zoneFeatureStatusService = zoneFeatureStatusService;
    }

    public IClusterService getClusterService() {
        return this.clusterService;
    }

    public void setClusterService(IClusterService clusterService) {
        this.clusterService = clusterService;
    }

    public ILicenseOutboundService getLicenseOutboundService() {
        return this.licenseOutboundService;
    }

    public void setLicenseOutboundService(ILicenseOutboundService licenseOutboundService) {
        this.licenseOutboundService = licenseOutboundService;
    }
}

