/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.nfa.restful.deploy;

import com.hs.vsm.secservice.sdk.module.ddos.form.NfaPolicyForm;
import com.huawei.atic.secservice.nfa.restful.model.PolicyObject;

public class FormTransObject {
    private static final Long NUM_1 = 0xFFFFFFFFL;
    private static final long PPSTHREHOLD_PER_GPPS = 1000000000L;
    private static final long PPSTHREHOLD_PER_MPPS = 1000000L;
    private static final Long PPSTHREHOLD_PER_PPS = 1000L;

    long convertPpsToGpps(Integer ppsThreshold) {
        return (long)ppsThreshold.intValue() * 1000000000L;
    }

    long convertPpsToMpps(Integer ppsThreshold) {
        return (long)ppsThreshold.intValue() * 1000000L;
    }

    public PolicyObject nfaPolicyFormTransfObject(NfaPolicyForm nfaPolicyForm) {
        PolicyObject policyObject = new PolicyObject();
        if (nfaPolicyForm.getEnable().booleanValue()) {
            policyObject.setEnable(Integer.valueOf(1));
        } else {
            policyObject.setEnable(Integer.valueOf(0));
        }
        policyObject.setAttackType(this.attackTypeTransf(nfaPolicyForm.getName()));
        if (!nfaPolicyForm.getPpsEnable().booleanValue()) {
            policyObject.setThresholdPps(0L);
        } else {
            Integer ppsThreshold = nfaPolicyForm.getPpsThreshold();
            if (nfaPolicyForm.getPpsUnit().equals("pps")) {
                policyObject.setThresholdPps((long)ppsThreshold.intValue());
            } else if (nfaPolicyForm.getPpsUnit().equals("Kpps")) {
                policyObject.setThresholdPps(ppsThreshold >= 0x400000 ? NUM_1 : (long)ppsThreshold.intValue() * PPSTHREHOLD_PER_PPS);
            } else if (nfaPolicyForm.getPpsUnit().equals("Mpps")) {
                policyObject.setThresholdPps(ppsThreshold >= 4096 ? NUM_1.longValue() : this.convertPpsToMpps(ppsThreshold));
            } else if (nfaPolicyForm.getPpsUnit().equals("Gpps")) {
                policyObject.setThresholdPps(ppsThreshold >= 4 ? NUM_1.longValue() : this.convertPpsToGpps(ppsThreshold));
            }
        }
        if (!nfaPolicyForm.getBpsEnable().booleanValue()) {
            policyObject.setThresholdKbps(Integer.valueOf(0));
        } else if (nfaPolicyForm.getBpsUnit().equals("Kbps")) {
            policyObject.setThresholdKbps(nfaPolicyForm.getBpsThreshold());
        } else if (nfaPolicyForm.getBpsUnit().equals("Mbps")) {
            policyObject.setThresholdKbps(Integer.valueOf(nfaPolicyForm.getBpsThreshold() * 1000));
        } else if (nfaPolicyForm.getBpsUnit().equals("Gbps")) {
            policyObject.setThresholdKbps(Integer.valueOf(nfaPolicyForm.getBpsThreshold() * 1000 * 1000));
        }
        return policyObject;
    }

    private Integer attackTypeTransf(String attackName) {
        if (attackName.equals("Host_Traffic_Overflow")) {
            return 25;
        }
        if (attackName.equals("Tcp_Syn_Flood")) {
            return 10;
        }
        if (attackName.equals("Tcp_Ack_Flood")) {
            return 11;
        }
        if (attackName.equals("Tcp_Malformed_Flood")) {
            return 53;
        }
        if (attackName.equals("Tcp_Fragment_Flood")) {
            return 16;
        }
        if (attackName.equals("Tcp_RstFin_Flood")) {
            return 13;
        }
        if (attackName.equals("Udp_Flood")) {
            return 19;
        }
        if (attackName.equals("Udp_Fragment_Flood")) {
            return 20;
        }
        if (attackName.equals("Dns_Query_Flood")) {
            return 29;
        }
        if (attackName.equals("Dns_Reply_Flood")) {
            return 30;
        }
        if (attackName.equals("Http_Flood")) {
            return 27;
        }
        if (attackName.equals("Https_Flood")) {
            return 26;
        }
        if (attackName.equals("Sip_Flood")) {
            return 31;
        }
        if (attackName.equals("Icmp_Flood")) {
            return 23;
        }
        if (attackName.equals("Other_Flood")) {
            return 24;
        }
        if (attackName.equals("Dark_Ip")) {
            return 99;
        }
        return 0;
    }
}

