/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.nfa.restful.deploy;

import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.vsm.secservice.ddos.model.FilterDeviceZoneInfo;
import com.hs.vsm.secservice.sdk.module.ddos.form.FilterForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZonePolicyApplyForm;
import com.hs.vsm.secservice.sdk.module.ddos.service.IFilterDeviceZoneInfoService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IFilterService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZonePolicyApplyService;
import com.huawei.atic.secservice.nfa.restful.model.FilterObject;
import com.huawei.atic.secservice.nfa.restful.model.FilterPolicyObject;
import java.util.List;

public class InitNfaDeployData {
    public static FilterPolicyObject queryFilterData(Long zoneId, Long deviceId, int direction) {
        FilterPolicyObject filterPolicyObject = new FilterPolicyObject();
        FilterObject[] filterObject = null;
        IFilterService filterService = (IFilterService)ServiceContext.getInstance().getService("filterService", IFilterService.class);
        List<FilterDeviceZoneInfo> filterDeviceZoneForms = InitNfaDeployData.getNfaFilterData(zoneId, deviceId, direction);
        if (null != filterDeviceZoneForms && !filterDeviceZoneForms.isEmpty()) {
            filterObject = new FilterObject[filterDeviceZoneForms.size()];
            for (int i = 0; i < filterDeviceZoneForms.size(); ++i) {
                FilterForm filterForm = (FilterForm)filterService.query(filterDeviceZoneForms.get(i).getFilterId());
                if (null == filterForm) continue;
                filterObject[i] = new FilterObject();
                filterObject[i].setFilterId((long)filterForm.getFilterId().intValue());
                filterObject[i].setPriority(filterDeviceZoneForms.get(i).getPreference());
            }
        }
        ZonePolicyApplyForm applyForm = InitNfaDeployData.getFilterDropThreshold(zoneId);
        if (direction == 1) {
            filterPolicyObject.setThresholdPps(applyForm.getFilterDropThreshold());
            filterPolicyObject.setThresholdKbps(Long.valueOf(0L));
        } else {
            filterPolicyObject.setThresholdPps(applyForm.getOutBoundFilterDropThreshold());
            filterPolicyObject.setThresholdKbps(Long.valueOf(0L));
        }
        filterPolicyObject.setFilterList(filterObject);
        return filterPolicyObject;
    }

    private static List<FilterDeviceZoneInfo> getNfaFilterData(Long zoneId, Long deviceId, int direction) {
        IFilterDeviceZoneInfoService filterDeviceZoneInfoService = (IFilterDeviceZoneInfoService)ServiceContext.getInstance().getService("filterDeviceZoneInfoService", IFilterDeviceZoneInfoService.class);
        List<FilterDeviceZoneInfo> filterDeviceZoneForms = filterDeviceZoneInfoService.quertByZoneIdAndDeviceId(zoneId, deviceId, direction);
        if (null != filterDeviceZoneForms && !filterDeviceZoneForms.isEmpty()) {
            return filterDeviceZoneForms;
        }
        return filterDeviceZoneForms;
    }

    private static ZonePolicyApplyForm getFilterDropThreshold(Long zoneId) {
        IZonePolicyApplyService zonePolicyApplyService = (IZonePolicyApplyService)ServiceContext.getInstance().getService("zonePolicyApplyService", IZonePolicyApplyService.class);
        ZonePolicyApplyForm zonePolicyApplyForm = (ZonePolicyApplyForm)zonePolicyApplyService.query(zoneId);
        return zonePolicyApplyForm;
    }
}

