/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.nfa.restful.deploy;

import com.hs.atic.sdk.zone.service.IZoneService;
import com.hs.atic.zone.util.ZoneUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.secservice.ddos.dao.FilterDao;
import com.hs.vsm.secservice.ddos.dao.FilterDeviceZoneStatusDao;
import com.hs.vsm.secservice.ddos.dao.ZoneDeviceDeployStatusDao;
import com.hs.vsm.secservice.ddos.dao.ZoneFeatureStatusDao;
import com.hs.vsm.secservice.ddos.model.FilterDeviceZoneStatusInfo;
import com.hs.vsm.secservice.ddos.model.FilterInfo;
import com.hs.vsm.secservice.ddos.model.ZoneDeviceDeployStatusInfo;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneDeviceForm;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneDeviceDeployStatusService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneDeviceService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.device.model.AticDeviceNfa;
import com.huawei.atic.device.model.AticDeviceNfaCluster;
import com.huawei.atic.secne.sdk.service.IAticDeviceNfaService;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.huawei.atic.secne.sdk.service.IClusterService;
import com.huawei.atic.secservice.nfa.restful.model.DefinedFilter;
import com.huawei.atic.secservice.nfa.restful.model.NfaInfoForm;
import com.huawei.atic.secservice.nfa.restful.model.Result;
import com.huawei.atic.secservice.nfa.restful.model.ZoneInfoObject;
import com.huawei.atic.secservice.nfa.restful.sdk.service.IRestfulNfaService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class UnDeployNfaPolicy {
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private IAticDeviceNfaService aticDeviceNfaService;
    private IAticDeviceService aticDeviceService;
    private IZoneDeviceDeployStatusService zoneDeviceDeployStatusService;
    private IRestfulNfaService restfulNfaService;
    private IZoneService zoneService;
    private IZoneDeviceService zoneDeviceService;
    private ZoneDeviceDeployStatusDao zoneDeviceDeployStatusDao;
    private FilterDeviceZoneStatusDao filterDeviceZoneStatusDao;
    private FilterDao filterDao;
    private IClusterService clusterService;
    private ZoneFeatureStatusDao zoneFeatureStatusDao;

    public boolean undoNfaPolicy(Long zoneId, Long deviceId) {
        this.logger.info((Object)("undo Nfadevice,deviceId is " + deviceId + ",zoneId is " + zoneId));
        ZoneInfoObject zoneInfoObject = new ZoneInfoObject();
        ZoneUtil.modifyNfaZoneType(zoneInfoObject, zoneId);
        List<AticDevice> aticDevices = this.getNfaInfo(deviceId);
        boolean flag = true;
        for (AticDevice aticDevice : aticDevices) {
            Long nfaId = aticDevice.getMoId();
            NfaInfoForm nfaInfoForm = new NfaInfoForm();
            AticDeviceNfa aticDeviceNfa = this.aticDeviceNfaService.findByMoid(nfaId);
            nfaInfoForm.setDeviceId(nfaId);
            nfaInfoForm.setApiKey(aticDeviceNfa.getApiKey());
            nfaInfoForm.setPort(aticDeviceNfa.getRestfulPort().intValue());
            nfaInfoForm.setIpAdress(aticDevice.getIpAddress());
            List<Integer> filterIds = this.getFilterIds(zoneId, nfaId);
            if (!filterIds.isEmpty()) {
                for (Integer filterId : filterIds) {
                    DefinedFilter definedFilter = new DefinedFilter();
                    definedFilter.setFilterId(filterId);
                    this.restfulNfaService.restNfaDelDefinedFilter(definedFilter, nfaInfoForm);
                }
            }
            Result nfaRestult = this.restfulNfaService.deleteZoneOnNFA(zoneInfoObject, nfaInfoForm);
            this.logger.info((Object)("delete ZoneId unDeploy NfaDevice,nfaRestult error is " + this.getcleanedMessage(nfaRestult.getJson())));
            if (nfaRestult.getStatusCode() == 200 && nfaRestult.getJson().contains("ok")) {
                this.zoneDeviceDeployStatusService.deleteByDeviceIdAndZoneId(nfaId, zoneId);
                this.filterDeviceZoneStatusDao.deleteByDeviceIdAndZoneId(nfaId, zoneId);
                this.zoneFeatureStatusDao.deleteByDeviceIdAndZoneId(nfaId, zoneId);
                continue;
            }
            String errorCode = "";
            errorCode = nfaRestult.getJson().contains("1") && nfaRestult.getJson().contains("fail") ? "501" : (nfaRestult.getJson().contains("Connection timed out") ? "offLine" : "502");
            this.saveZoneDeviceDeployStatus(errorCode, zoneId, nfaInfoForm);
            flag = false;
        }
        if (aticDevices.isEmpty()) {
            flag = false;
        }
        return flag;
    }

    private List<AticDevice> getNfaInfo(Long deviceId) {
        ArrayList<AticDevice> aticDevices = new ArrayList<AticDevice>();
        AticDevice aticDevice = this.aticDeviceService.getDeviceByMoid(deviceId.longValue());
        if (aticDevice.getDeviceType() == 7) {
            List nfaClusters = this.clusterService.getBindNfaDevice(deviceId);
            for (AticDeviceNfaCluster nfaCluster : nfaClusters) {
                Long nfaId = nfaCluster.getDeviceId();
                aticDevice = this.aticDeviceService.getDeviceByMoid(nfaId.longValue());
                aticDevices.add(aticDevice);
            }
        } else {
            aticDevices.add(aticDevice);
        }
        return aticDevices;
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    public void saveZoneDeviceDeployStatus(String errorCode, Long zoneId, NfaInfoForm nfaInfoForm) {
        ZoneDeviceDeployStatusInfo zoneDeviceDeployStatusInfo = null;
        try {
            zoneDeviceDeployStatusInfo = this.zoneDeviceDeployStatusDao.getOneByZoneIdAndDeviceId(zoneId, nfaInfoForm.getDeviceId(), 3);
        }
        catch (Exception e) {
            this.logger.error((Object)"saveZoneDeviceDeployStatus() is exception--->>>", (Throwable)e);
        }
        if (null != zoneDeviceDeployStatusInfo) {
            zoneDeviceDeployStatusInfo.setZoneId(zoneId);
            zoneDeviceDeployStatusInfo.setDeviceId(nfaInfoForm.getDeviceId());
            zoneDeviceDeployStatusInfo.setDeployState("--".equals(errorCode));
            zoneDeviceDeployStatusInfo.setDeployType(3);
            zoneDeviceDeployStatusInfo.setErrorMsgKey("--".equals(errorCode) ? "--" : "lego.err." + errorCode);
            zoneDeviceDeployStatusInfo.setDeployTime(new Date());
            this.zoneDeviceDeployStatusDao.update(zoneDeviceDeployStatusInfo);
        } else {
            zoneDeviceDeployStatusInfo = new ZoneDeviceDeployStatusInfo();
            zoneDeviceDeployStatusInfo.setZoneId(zoneId);
            zoneDeviceDeployStatusInfo.setDeviceId(nfaInfoForm.getDeviceId());
            zoneDeviceDeployStatusInfo.setDeployState("--".equals(errorCode));
            zoneDeviceDeployStatusInfo.setDeployType(3);
            zoneDeviceDeployStatusInfo.setErrorMsgKey("--".equals(errorCode) ? "--" : "lego.err." + errorCode);
            zoneDeviceDeployStatusInfo.setDeployTime(new Date());
            this.zoneDeviceDeployStatusDao.save(zoneDeviceDeployStatusInfo);
        }
    }

    public void undoNfaZoneIp(Long zoneId) {
        ZoneInfoObject zoneInfoObject = new ZoneInfoObject();
        ZoneUtil.modifyNfaZoneType(zoneInfoObject, zoneId);
        List<NfaInfoForm> nfaInfoForms = this.getNfaInfoForm(zoneId);
        for (NfaInfoForm nfaInfoForm : nfaInfoForms) {
            this.restfulNfaService.restNfaDelALLZoneIp(zoneInfoObject, nfaInfoForm);
        }
    }

    public List<NfaInfoForm> getNfaInfoForm(Long zoneId) {
        ArrayList<NfaInfoForm> nfaInfoForms = new ArrayList<NfaInfoForm>();
        List aticDeviceList = this.zoneDeviceService.getByZoneId(zoneId);
        for (ZoneDeviceForm zoneForm : aticDeviceList) {
            AticDevice aticDevice = this.aticDeviceService.getDeviceByMoid(zoneForm.getDeviceId().longValue());
            if (!aticDevice.getDeviceModel().contains("NFA")) continue;
            NfaInfoForm nfaInfoForm = new NfaInfoForm();
            nfaInfoForm.setIpAdress(aticDevice.getIpAddress());
            AticDeviceNfa aticDeviceNfa = this.aticDeviceNfaService.findByMoid(zoneForm.getDeviceId());
            nfaInfoForm.setDeviceId(zoneForm.getDeviceId());
            nfaInfoForm.setApiKey(aticDeviceNfa.getApiKey());
            nfaInfoForm.setPort(aticDeviceNfa.getRestfulPort().intValue());
            nfaInfoForms.add(nfaInfoForm);
        }
        return nfaInfoForms;
    }

    private List<Integer> getFilterIds(Long zoneId, Long deviceId) {
        List<FilterDeviceZoneStatusInfo> filterDeviceZoneInfoList = this.filterDeviceZoneStatusDao.getDeployedByZoneIdAndDeviceId(zoneId, deviceId);
        ArrayList<Integer> filterIds = new ArrayList<Integer>();
        if (null != filterDeviceZoneInfoList && !filterDeviceZoneInfoList.isEmpty()) {
            for (FilterDeviceZoneStatusInfo filterDeviceZoneInfo : filterDeviceZoneInfoList) {
                FilterInfo filterInfo;
                List<FilterDeviceZoneStatusInfo> filterDeviceZoneInfos = this.filterDeviceZoneStatusDao.getDeployedByFilterIdAndDeviceId(filterDeviceZoneInfo.getFilterId(), deviceId);
                if (filterDeviceZoneInfos.size() != 1 || null == (filterInfo = this.filterDao.get(filterDeviceZoneInfo.getFilterId()))) continue;
                filterIds.add(filterInfo.getFilterId());
            }
        }
        return filterIds;
    }

    public IAticDeviceNfaService getAticDeviceNfaService() {
        return this.aticDeviceNfaService;
    }

    public void setAticDeviceNfaService(IAticDeviceNfaService aticDeviceNfaService) {
        this.aticDeviceNfaService = aticDeviceNfaService;
    }

    public IZoneDeviceDeployStatusService getZoneDeviceDeployStatusService() {
        return this.zoneDeviceDeployStatusService;
    }

    public void setZoneDeviceDeployStatusService(IZoneDeviceDeployStatusService zoneDeviceDeployStatusService) {
        this.zoneDeviceDeployStatusService = zoneDeviceDeployStatusService;
    }

    public IRestfulNfaService getRestfulNfaService() {
        return this.restfulNfaService;
    }

    public void setRestfulNfaService(IRestfulNfaService restfulNfaService) {
        this.restfulNfaService = restfulNfaService;
    }

    public IAticDeviceService getAticDeviceService() {
        return this.aticDeviceService;
    }

    public void setAticDeviceService(IAticDeviceService aticDeviceService) {
        this.aticDeviceService = aticDeviceService;
    }

    public IZoneService getZoneService() {
        return this.zoneService;
    }

    public void setZoneService(IZoneService zoneService) {
        this.zoneService = zoneService;
    }

    public IZoneDeviceService getZoneDeviceService() {
        return this.zoneDeviceService;
    }

    public void setZoneDeviceService(IZoneDeviceService zoneDeviceService) {
        this.zoneDeviceService = zoneDeviceService;
    }

    public ZoneDeviceDeployStatusDao getZoneDeviceDeployStatusDao() {
        return this.zoneDeviceDeployStatusDao;
    }

    public void setZoneDeviceDeployStatusDao(ZoneDeviceDeployStatusDao zoneDeviceDeployStatusDao) {
        this.zoneDeviceDeployStatusDao = zoneDeviceDeployStatusDao;
    }

    public FilterDeviceZoneStatusDao getFilterDeviceZoneStatusDao() {
        return this.filterDeviceZoneStatusDao;
    }

    public void setFilterDeviceZoneStatusDao(FilterDeviceZoneStatusDao filterDeviceZoneStatusDao) {
        this.filterDeviceZoneStatusDao = filterDeviceZoneStatusDao;
    }

    public FilterDao getFilterDao() {
        return this.filterDao;
    }

    public void setFilterDao(FilterDao filterDao) {
        this.filterDao = filterDao;
    }

    public IClusterService getClusterService() {
        return this.clusterService;
    }

    public void setClusterService(IClusterService clusterService) {
        this.clusterService = clusterService;
    }

    public ZoneFeatureStatusDao getZoneFeatureStatusDao() {
        return this.zoneFeatureStatusDao;
    }

    public void setZoneFeatureStatusDao(ZoneFeatureStatusDao zoneFeatureStatusDao) {
        this.zoneFeatureStatusDao = zoneFeatureStatusDao;
    }
}

