/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.nfa.util;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.secservice.ddos.policy.ref.ZoneReferUtil;
import com.hs.vsm.secservice.nfa.util.NfaFilterUtil;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.device.model.AticDeviceNfaCluster;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.huawei.atic.secne.sdk.service.IClusterService;
import com.huawei.atic.secservice.nfa.restful.model.ClusterObject;
import com.huawei.atic.secservice.nfa.restful.model.NfaInfoForm;
import com.huawei.atic.secservice.nfa.restful.model.Result;
import com.huawei.atic.secservice.nfa.restful.sdk.service.IRestfulNfaService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class NfaClusterUtil {
    private static Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);

    private NfaClusterUtil() {
    }

    public static boolean modifyInvalidNfaInCluster(Long clusterId, List<AticDevice> nfaList) {
        IAticDeviceService aticDeviceService = ZoneReferUtil.getFirewallService();
        AticDevice aticDevice = aticDeviceService.getDeviceByMoid(clusterId.longValue());
        boolean result = true;
        ArrayList<Long> nfaIdList = new ArrayList<Long>();
        for (AticDevice nfa : nfaList) {
            nfaIdList.add(nfa.getMoId());
        }
        for (Long deviceId : nfaIdList) {
            NfaInfoForm nfaInfoForm = NfaFilterUtil.getNfaInfoFormByDeviceId(deviceId);
            result = NfaClusterUtil.deployNFAClusterInfo(nfaInfoForm, aticDevice.getIpAddress(), "modify", nfaIdList);
        }
        return result;
    }

    public static boolean deployNFAClusterInfo(NfaInfoForm nfaInfoForm, String clusterIp, String operation, List<Long> idList) {
        try {
            IRestfulNfaService restfulNfaService = ZoneReferUtil.getRestfulNfaService();
            if (null == restfulNfaService) {
                logger.error((Object)"deployNFAClusterInfo is failed, restfulNfaService is null");
                throw new LegoCheckedException(570506L);
            }
            IAticDeviceService aticDeviceService = ZoneReferUtil.getFirewallService();
            if (null == aticDeviceService) {
                logger.error((Object)"deployNFAClusterInfo is failed, aticDeviceService is null");
                throw new LegoCheckedException(570506L);
            }
            ClusterObject[] clusterObjects = null;
            ClusterObject obj = null;
            AticDevice dev = null;
            ArrayList<Long> nfaIdList = new ArrayList<Long>();
            if (null != idList && !idList.isEmpty()) {
                for (Long id : idList) {
                    dev = aticDeviceService.getDeviceByMoid(id.longValue());
                    if (null == dev || 5 != dev.getDeviceType()) continue;
                    nfaIdList.add(id);
                }
                clusterObjects = new ClusterObject[nfaIdList.size()];
                for (int i = 0; i < nfaIdList.size(); ++i) {
                    Long id;
                    id = (Long)nfaIdList.get(i);
                    obj = new ClusterObject();
                    obj.setClusterIp(clusterIp);
                    dev = aticDeviceService.getDeviceByMoid(id.longValue());
                    if (null == dev) continue;
                    obj.setNfaIp(dev.getIpAddress());
                    obj.setNfaState(Integer.valueOf(aticDeviceService.getStatusByMoid(id.longValue()) == 0 ? 1 : 0));
                    clusterObjects[i] = obj;
                }
            }
            Result result = restfulNfaService.restNfaClusterInfo(clusterObjects, nfaInfoForm, operation);
            boolean resultCluster = false;
            String mess = "null";
            if (null != result) {
                resultCluster = NfaClusterUtil.checkJson(result);
                mess = result.toString();
            }
            if (!resultCluster) {
                logger.error((Object)("deployNFAClusterInfo to " + nfaInfoForm.getIpAdress() + "failed, result = " + NfaClusterUtil.getcleanedMessage(mess)));
                return false;
            }
        }
        catch (RuntimeException e) {
            logger.error((Object)"deployNFAClusterInfo failed");
            return false;
        }
        return true;
    }

    public static AticDevice getNfaDeviceInfo(Long clusterId) {
        IClusterService clusterService = ZoneReferUtil.getClusterService();
        IAticDeviceService aticDeviceService = ZoneReferUtil.getFirewallService();
        AticDevice aticDevice = new AticDevice();
        try {
            Iterator iterator;
            List nfaClusters = clusterService.getBindNfaDevice(clusterId);
            if (null != nfaClusters && !nfaClusters.isEmpty() && (iterator = nfaClusters.iterator()).hasNext()) {
                AticDeviceNfaCluster nfaCluster = (AticDeviceNfaCluster)iterator.next();
                aticDevice = aticDeviceService.getDeviceByMoid(nfaCluster.getDeviceId().longValue());
            }
        }
        catch (RuntimeException e) {
            logger.error((Object)("getNfaDeviceInfo error , current clusterId is " + clusterId));
        }
        return aticDevice;
    }

    public static boolean checkJson(Result result) {
        if (null == result) {
            return false;
        }
        int statusCode = result.getStatusCode();
        if (200 == statusCode) {
            return result.getJson().contains("ok");
        }
        return false;
    }

    public static String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }
}

