/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.nfa.util;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.secservice.ddos.model.HttpFilterInfo;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.device.model.AticDeviceNfa;
import com.huawei.atic.device.model.AticDeviceNfaCluster;
import com.huawei.atic.secne.sdk.service.IAticDeviceNfaService;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.huawei.atic.secne.sdk.service.IClusterService;
import com.huawei.atic.secservice.nfa.restful.model.DefinedFilter;
import com.huawei.atic.secservice.nfa.restful.model.NfaInfoForm;
import java.util.ArrayList;
import java.util.List;

public final class NfaFilterUtil {
    private static Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);

    private NfaFilterUtil() {
    }

    public static DefinedFilter httpFilterTransfDefinedFilter(List<HttpFilterInfo> httpFilterInfos) {
        DefinedFilter definedFilter = new DefinedFilter();
        ArrayList<Integer> protocol = new ArrayList<Integer>();
        ArrayList<String> srcPort = new ArrayList<String>();
        ArrayList<String> dstPort = new ArrayList<String>();
        ArrayList<Integer> tos = new ArrayList<Integer>();
        ArrayList<Integer> tcpFlag = new ArrayList<Integer>();
        ArrayList<String> flowPacketCount = new ArrayList<String>();
        ArrayList<String> flowPacketBytes = new ArrayList<String>();
        ArrayList<String> flowBytes = new ArrayList<String>();
        if (null != httpFilterInfos && !httpFilterInfos.isEmpty()) {
            for (HttpFilterInfo httpFilterInfo : httpFilterInfos) {
                if (httpFilterInfo.getFilterKey().equals("protocol")) {
                    protocol.add(Integer.valueOf(httpFilterInfo.getFilterContent()));
                    continue;
                }
                if (httpFilterInfo.getFilterKey().equals("source-port")) {
                    srcPort.add(httpFilterInfo.getFilterContent());
                    continue;
                }
                if (httpFilterInfo.getFilterKey().equals("destination-port")) {
                    dstPort.add(httpFilterInfo.getFilterContent());
                    continue;
                }
                if (httpFilterInfo.getFilterKey().equals("dscp")) {
                    tos.add(Integer.valueOf(httpFilterInfo.getFilterContent()));
                    continue;
                }
                if (httpFilterInfo.getFilterKey().equals("tcp-flag")) {
                    tcpFlag.add(Integer.valueOf(httpFilterInfo.getFilterContent()));
                    continue;
                }
                if (httpFilterInfo.getFilterKey().equals("flow-packet-count")) {
                    flowPacketCount.add(httpFilterInfo.getFilterContent());
                    continue;
                }
                if (httpFilterInfo.getFilterKey().equals("packet-length")) {
                    flowPacketBytes.add(httpFilterInfo.getFilterContent());
                    continue;
                }
                if (!httpFilterInfo.getFilterKey().equals("flow-bytes")) continue;
                flowBytes.add(httpFilterInfo.getFilterContent());
            }
        }
        definedFilter.setProtocol(NfaFilterUtil.listIntegerToArray(protocol));
        definedFilter.setSrcPort(NfaFilterUtil.listStringToArray(srcPort));
        definedFilter.setDstPort(NfaFilterUtil.listStringToArray(dstPort));
        definedFilter.setTos(NfaFilterUtil.listIntegerToArray(tos));
        definedFilter.setTcpFlag(NfaFilterUtil.listIntegerToArray(tcpFlag));
        definedFilter.setFlowPacketCount(NfaFilterUtil.listStringToArray(flowPacketCount));
        definedFilter.setFlowPacketBytes(NfaFilterUtil.listStringToArray(flowPacketBytes));
        definedFilter.setFlowBytes(NfaFilterUtil.listStringToArray(flowBytes));
        return definedFilter;
    }

    private static String[] listStringToArray(List<String> list) {
        if (null != list && !list.isEmpty()) {
            String[] array = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                array[i] = list.get(i);
            }
            return array;
        }
        return new String[0];
    }

    private static Integer[] listIntegerToArray(List<Integer> list) {
        if (null != list && !list.isEmpty()) {
            Integer[] array = new Integer[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                array[i] = list.get(i);
            }
            return array;
        }
        return new Integer[0];
    }

    public static NfaInfoForm getNfaInfoFormByDeviceId(Long deviceId) {
        IAticDeviceNfaService aticDeviceNfaService = (IAticDeviceNfaService)ServiceContext.getInstance().getService("aticDeviceNfaService", IAticDeviceNfaService.class);
        IAticDeviceService aticDeviceService = (IAticDeviceService)ServiceContext.getInstance().getService("aticDeviceService", IAticDeviceService.class);
        IClusterService clusterService = (IClusterService)ServiceContext.getInstance().getService("clusterService", IClusterService.class);
        if (null == aticDeviceNfaService) {
            return null;
        }
        if (null == aticDeviceService) {
            return null;
        }
        if (null == clusterService) {
            return null;
        }
        AticDevice aticDevice = aticDeviceService.getDeviceByMoid(deviceId.longValue());
        if (null == aticDevice || aticDevice.getDeviceType() != 5) {
            return null;
        }
        Long clusterId = null;
        try {
            if (clusterService.isBelongCluster(deviceId)) {
                AticDeviceNfaCluster nfaCluster = clusterService.getClusterByNfaId(deviceId);
                clusterId = nfaCluster.getClusterId();
            }
        }
        catch (Exception e) {
            logger.error((Object)("get AticDeviceNfaCluster error ,deviceId is " + deviceId));
            return null;
        }
        NfaInfoForm nfaInfoForm = new NfaInfoForm();
        AticDeviceNfa aticDeviceNfa = aticDeviceNfaService.findByMoid(Long.valueOf(aticDevice.getMoId()));
        if (null == aticDeviceNfa) {
            return null;
        }
        nfaInfoForm.setDeviceId(Long.valueOf(aticDeviceNfa.getMoId()));
        nfaInfoForm.setApiKey(aticDeviceNfa.getApiKey());
        nfaInfoForm.setPort(aticDeviceNfa.getRestfulPort().intValue());
        nfaInfoForm.setClusterId(clusterId);
        nfaInfoForm.setIpAdress(aticDevice.getIpAddress());
        return nfaInfoForm;
    }
}

