/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.policyengine.commandengine;

import com.hs.vsm.secservice.policyengine.commandbean.Command;
import com.hs.vsm.secservice.policyengine.commandbean.CommandTemplate;
import com.hs.vsm.secservice.policyengine.commandbean.CommandTemplateParam;
import com.hs.vsm.secservice.policyengine.commandutil.CmdParam;
import com.hs.vsm.secservice.policyengine.commandutil.CommandUtil;
import com.hs.vsm.secservice.policyengine.commandutil.ParseException;
import com.hs.vsm.secservice.policyengine.parambean.CompositeKeyword;
import com.hs.vsm.secservice.policyengine.parambean.DealWord;
import com.hs.vsm.secservice.policyengine.parambean.TplSuffix;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class CommandParser {
    private static final Logger LOGGER = Logger.getLogger(CommandParser.class);
    private CommandUtil commandUtil = new CommandUtil();

    public List<CmdParam> doParse(String commandLine, CommandTemplate commandTemplateBean) {
        LOGGER.info((Object)"Enter CommandParser.doParse");
        ArrayList<CmdParam> dataList = new ArrayList<CmdParam>();
        String commandCli = this.preParse(commandTemplateBean.getCommandTemplateParam(), commandLine);
        BufferedReader reader = null;
        String tmpRow = "";
        CmdParam cmdParam = null;
        try {
            reader = new BufferedReader(new StringReader(commandCli));
            tmpRow = reader.readLine();
            while (tmpRow != null) {
                Command matchedCommand;
                if (!tmpRow.trim().equals("") && (matchedCommand = this.findCommandTpl(commandTemplateBean, tmpRow)) != null) {
                    cmdParam = this.parseRowData(matchedCommand, tmpRow);
                    dataList.add(cmdParam);
                }
                tmpRow = reader.readLine();
            }
        }
        catch (IOException e) {
            LOGGER.info((Object)"the need char has no input value");
            throw new ParseException(112, (Throwable)e);
        }
        finally {
            if (null != reader) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    LOGGER.error((Object)"reader.close() fail", (Throwable)e);
                }
            }
        }
        LOGGER.info((Object)"Leave CommandParser.doParse");
        return dataList;
    }

    private String preParse(CommandTemplateParam commandTemplateParam, String commandCli) {
        LOGGER.info((Object)"Enter CommandParser.preParse");
        String beginStr = commandTemplateParam.getBeginStr();
        String secondBeginStr = commandTemplateParam.getSecondBeginStr();
        String endStr = commandTemplateParam.getEndStr();
        String commandLine = commandCli;
        if (beginStr != null && !beginStr.trim().equals("")) {
            commandLine = commandLine.substring(commandLine.indexOf(beginStr) + beginStr.length());
        }
        if (secondBeginStr != null && !secondBeginStr.trim().equals("")) {
            commandLine = commandLine.substring(commandLine.indexOf(secondBeginStr) + secondBeginStr.length());
        }
        if (endStr != null && !endStr.equals("")) {
            commandLine = commandLine.substring(0, commandLine.lastIndexOf(endStr));
        }
        LOGGER.info((Object)"Leave CommandParser.preParse");
        return commandLine;
    }

    private Command findCommandTpl(CommandTemplate commandTemplateBean, String oneRowCli) {
        LOGGER.info((Object)"Enter CommandParser.findCommandTpl");
        List<Command> commandList = commandTemplateBean.getCommandList();
        Command reCommand = null;
        HashMap<String, Command> tmpTplMap = new HashMap<String, Command>();
        for (int i = 0; i < commandList.size(); ++i) {
            String tmpRowCli;
            Command commandBean = commandList.get(i);
            String commandTplContent = commandBean.getCommandContent();
            commandTplContent = this.commandUtil.changeTabToSpace(commandTplContent);
            String tplContentPre = commandBean.getContentPre();
            Pattern p = Pattern.compile("^\\s*" + tplContentPre.toLowerCase(Locale.ENGLISH));
            Matcher m = p.matcher(this.commandUtil.changeTabToSpace(tmpRowCli = this.commandUtil.changeTabToSpace(oneRowCli).toLowerCase(Locale.ENGLISH)));
            if (!m.find()) continue;
            if (tmpTplMap.isEmpty()) {
                tmpTplMap.put(tplContentPre, commandBean);
                continue;
            }
            this.findMatchedTpl(tplContentPre, commandBean, tmpTplMap, commandTplContent, oneRowCli);
        }
        if (!tmpTplMap.isEmpty()) {
            for (Map.Entry entry : tmpTplMap.entrySet()) {
                reCommand = (Command)entry.getValue();
            }
        }
        LOGGER.info((Object)"Leave CommandParser.findCommandTpl");
        return reCommand;
    }

    private void findMatchedTpl(String tplContentPre, Command commandBean, Map<String, Command> tmpTplMap, String commandTplContent, String oneRowCli) {
        Map<String, Command> tMap = tmpTplMap;
        for (Map.Entry<String, Command> entry : tMap.entrySet()) {
            if (tplContentPre.length() > entry.getKey().length()) {
                tmpTplMap.remove(entry.getKey());
                tmpTplMap.put(tplContentPre, commandBean);
                continue;
            }
            if (tplContentPre.length() != entry.getKey().length()) continue;
            TplSuffix tplSuffix = new TplSuffix();
            tplSuffix.setCommandTplContent(commandTplContent);
            tplSuffix.setOneRowCli(oneRowCli);
            tplSuffix.setTplContentPre(tplContentPre);
            tplSuffix.setCommandBean(commandBean);
            tplSuffix.setTmpTplMap(tmpTplMap);
            tplSuffix.setEntry(entry);
            this.findTplBySuffix(tplSuffix);
        }
    }

    private void findTplBySuffix(TplSuffix tplSuffix) {
        String commandTplContent = tplSuffix.getCommandTplContent();
        String oneRowCli = tplSuffix.getOneRowCli();
        String tplContentPre = tplSuffix.getTplContentPre();
        Command commandBean = tplSuffix.getCommandBean();
        Map<String, Command> tmpTplMap = tplSuffix.getTmpTplMap();
        Map.Entry<String, Command> entry = tplSuffix.getEntry();
        Pattern pSuffix = Pattern.compile("\\s+[a-zA-Z][a-zA-Z0-9-_]{1,31}\\s*$");
        Matcher mSuffix = pSuffix.matcher(commandTplContent);
        Matcher mDataSuffix = pSuffix.matcher(oneRowCli);
        if (mSuffix.find()) {
            String cliSuffix;
            String tplPost = mSuffix.group().trim();
            if (mDataSuffix.find() && (cliSuffix = mDataSuffix.group().trim()).equalsIgnoreCase(tplPost)) {
                tmpTplMap.remove(entry.getKey());
                tmpTplMap.put(tplContentPre, commandBean);
            }
        }
    }

    private CmdParam parseRowData(Command commandBean, String oneRowCli) {
        LOGGER.info((Object)"Enter CommandParser.parseRowData");
        CmdParam cmdParam = new CmdParam();
        String commandTplContent = commandBean.getCommandContent();
        commandTplContent = this.commandUtil.changeTabToSpace(commandTplContent);
        HashMap params = (HashMap)this.cutCommandTpl(commandTplContent, oneRowCli);
        cmdParam.setCmdID(commandBean.getId());
        cmdParam.setParams((Map)params);
        LOGGER.info((Object)"Leave CommandParser.parseRowData");
        return cmdParam;
    }

    private Map<String, String> cutCommandTpl(String commandTpl, String oneRowCli) {
        LOGGER.info((Object)"Enter CommandParser.cutCommandTpl");
        String cmdTpl = null;
        Map<String, String> map = new HashMap<String, String>();
        cmdTpl = this.dealInnerBracket(commandTpl, oneRowCli);
        map = this.parseSimpleCommandStr(cmdTpl, oneRowCli, map);
        LOGGER.info((Object)"Leave CommandParser.cutCommandTpl");
        return map;
    }

    private String dealInnerBracket(String commandTplStr, String oneRowCli) {
        Matcher mBig;
        String commandStr = commandTplStr;
        if (commandStr.indexOf("[") == -1 && commandStr.indexOf("{") == -1) {
            return commandStr;
        }
        Pattern pMidBracket = Pattern.compile("\\[[^\\[\\]\\{\\}]+\\]");
        Pattern pBigBracket = Pattern.compile("\\{[^\\[\\]\\{\\}]+\\}");
        Matcher mMid = pMidBracket.matcher(commandStr);
        if (mMid.find()) {
            commandStr = this.dealMidBracket(mMid, commandStr, oneRowCli);
        }
        if ((mBig = pBigBracket.matcher(commandStr)).find()) {
            commandStr = this.dealBigBracket(mBig, commandStr, oneRowCli);
        }
        commandStr = this.dealInnerBracket(commandStr, oneRowCli);
        return commandStr;
    }

    private String dealBigBracket(Matcher mBig, String commandStr, String oneRowCli) {
        int startIndex = mBig.start();
        int endIndex = mBig.end();
        String mg = mBig.group();
        ArrayList<String> tmpStrList = new ArrayList<String>();
        String tmpMg = mg.substring(1, mg.length() - 1);
        List<String> keywordList = this.findKeyword(tmpMg);
        List<String> disappearKeywordList = this.findDisappearKeyword(oneRowCli, keywordList);
        String[] strArr = tmpMg.split("\\|");
        for (int i = 0; i < strArr.length; ++i) {
            List<String> subKeywordList = this.findKeyword(strArr[i]);
            String subKeyword = "";
            if (subKeywordList.isEmpty()) {
                tmpStrList.add(strArr[i]);
                continue;
            }
            subKeyword = subKeywordList.get(0).toLowerCase(Locale.ENGLISH);
            if (disappearKeywordList.contains(subKeyword)) continue;
            tmpStrList.add(strArr[i]);
        }
        if (tmpStrList.size() == 1) {
            StringBuffer tplBuffer = new StringBuffer(commandStr.substring(0, startIndex));
            commandStr = tplBuffer.append((String)tmpStrList.get(0)).append(commandStr.substring(endIndex)).toString();
        } else {
            String preStr = commandStr.substring(0, startIndex);
            ArrayList<String> preKeywordList = new ArrayList<String>();
            String preKeyword = "";
            if (preStr.trim().equals("")) {
                LOGGER.info((Object)"unknown template error");
                throw new ParseException(500, "unknown template error");
            }
            CompositeKeyword compositeKeyword = new CompositeKeyword();
            compositeKeyword.setPreKeywordList(preKeywordList);
            compositeKeyword.setPreStr(preStr);
            compositeKeyword.setPreKeyword(preKeyword);
            compositeKeyword.setTmpStrList(tmpStrList);
            compositeKeyword.setOneRowCli(oneRowCli);
            compositeKeyword.setCommandStr(commandStr);
            compositeKeyword.setTplBuffer(new StringBuffer(""));
            compositeKeyword.setStartIndex(startIndex);
            compositeKeyword.setEndIndex(endIndex);
            commandStr = this.delByCompositeKeyWord(compositeKeyword);
        }
        return commandStr;
    }

    private String delByCompositeKeyWord(CompositeKeyword compositeKeyword) {
        List<String> preKeywordList = null;
        String preStr = compositeKeyword.getPreStr();
        String preKeyword = null;
        List<String> tmpStrList = compositeKeyword.getTmpStrList();
        String oneRowCli = compositeKeyword.getOneRowCli();
        String commandStr = compositeKeyword.getCommandStr();
        StringBuffer tplBuffer = null;
        int startIndex = compositeKeyword.getStartIndex();
        int endIndex = compositeKeyword.getEndIndex();
        String myStr = "";
        preKeywordList = this.findKeyword(preStr);
        preKeyword = preKeywordList.get(preKeywordList.size() - 1);
        for (int j = 0; j < tmpStrList.size(); ++j) {
            String splitStr = tmpStrList.get(j);
            List<String> tmpList = this.findKeyword(splitStr);
            if (tmpList.isEmpty()) {
                Pattern pKeyandVar = Pattern.compile("[a-zA-Z][a-zA-Z-_0-9]{0,63}\\$");
                Matcher mKeyandVar = pKeyandVar.matcher(splitStr);
                if (mKeyandVar.find()) {
                    String keyAndVar = mKeyandVar.group();
                    Pattern compP = Pattern.compile(preKeyword + "\\s+" + keyAndVar.substring(0, keyAndVar.length() - 1));
                    Matcher compM = compP.matcher(oneRowCli);
                    if (!compM.find()) continue;
                    myStr = "$" + compM.group().trim().replaceAll("\\s+", "_");
                    continue;
                }
                myStr = tmpStrList.get(j);
                continue;
            }
            Pattern compositeP = Pattern.compile(preKeyword + "\\s+" + tmpList.get(0));
            Matcher compositeM = compositeP.matcher(oneRowCli);
            if (!compositeM.find()) continue;
            myStr = tmpStrList.get(j);
            break;
        }
        tplBuffer = new StringBuffer(commandStr.substring(0, startIndex));
        commandStr = tplBuffer.append(myStr).append(commandStr.substring(endIndex)).toString();
        return commandStr;
    }

    private String dealMidBracket(Matcher mMid, String commandStr, String oneRowCli) {
        int startIndex = mMid.start();
        int endIndex = mMid.end();
        String subStr = commandStr.substring(startIndex, endIndex);
        String tmpSubStr = subStr.substring(1, subStr.length() - 1);
        String[] strArr = tmpSubStr.split("\\|");
        List<String> keywordList = this.findKeyword(subStr);
        List<String> disappearKeywordList = this.findDisappearKeyword(oneRowCli, keywordList);
        String tmpStr = "";
        if (disappearKeywordList.isEmpty()) {
            Pattern pKeyandVar = Pattern.compile("[a-zA-Z][a-zA-Z-_0-9]{0,63}\\$");
            Matcher mKeyandVar = pKeyandVar.matcher(tmpSubStr);
            if (mKeyandVar.find()) {
                String keyAndVar = mKeyandVar.group();
                tmpSubStr = oneRowCli.indexOf(keyAndVar.substring(0, keyAndVar.length() - 1)) != -1 ? "$" + keyAndVar.substring(0, keyAndVar.length() - 1) : "";
            }
            StringBuffer tplBuffer = new StringBuffer(commandStr.substring(0, startIndex));
            commandStr = tplBuffer.append(tmpSubStr).append(commandStr.substring(endIndex)).toString();
        } else {
            for (int i = 0; i < strArr.length; ++i) {
                List<String> subKeywordList = this.findKeyword(strArr[i]);
                if (subKeywordList.isEmpty()) {
                    LOGGER.info((Object)"each split item must has key word in mid bracket");
                    throw new ParseException(118, "each split item must has key word in mid bracket");
                }
                String subKeyword = subKeywordList.get(0).toLowerCase(Locale.ENGLISH);
                if (disappearKeywordList.contains(subKeyword)) continue;
                tmpStr = strArr[i];
            }
            StringBuffer tplBuffer = new StringBuffer(commandStr.substring(0, startIndex));
            commandStr = tplBuffer.append(tmpStr).append(commandStr.substring(endIndex)).toString();
        }
        return commandStr;
    }

    private List<String> findKeyword(String commandTplStr) {
        String commandStr = commandTplStr;
        ArrayList<String> keywordList = new ArrayList<String>();
        for (int i = 0; i < commandStr.length(); ++i) {
            char ch = commandStr.charAt(i);
            if (ch != '[' && ch != ']' && ch != '{' && ch != '}' && ch != '|') continue;
            commandStr = commandStr.replace(String.valueOf(ch), "");
        }
        String[] strs = commandStr.split("\\s+");
        Pattern pattern = Pattern.compile("^[a-zA-Z][a-zA-Z0-9-_]{0,63}$");
        for (int j = 0; j < strs.length; ++j) {
            Matcher m = pattern.matcher(strs[j]);
            if (!m.find()) continue;
            keywordList.add(m.group().toLowerCase(Locale.ENGLISH));
        }
        return keywordList;
    }

    private List<String> findDisappearKeyword(String oneRowCli, List<String> keyWordList) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < keyWordList.size(); ++i) {
            String keyword = keyWordList.get(i);
            Pattern pattern = Pattern.compile("\\s+" + keyword + "\\s+");
            Matcher matcher = pattern.matcher(oneRowCli);
            if (matcher.find()) continue;
            list.add(keyword);
        }
        return list;
    }

    private Map<String, String> parseSimpleCommandStr(String commandTplStr, String commandCliStr, Map<String, String> map) {
        String commandStr = commandTplStr;
        String cliStr = commandCliStr;
        Pattern p = Pattern.compile("[^\\s]+");
        Matcher mTpl = p.matcher(commandStr);
        Matcher mCli = p.matcher(cliStr);
        String cliWord = "";
        if (mTpl.find()) {
            commandStr = commandStr.substring(mTpl.end());
            String tplWord = mTpl.group();
            if (tplWord != null) {
                DealWord dealWord = new DealWord();
                dealWord.setTplWord(tplWord);
                dealWord.setmCli(mCli);
                dealWord.setCliStr(cliStr);
                dealWord.setMap(map);
                dealWord.setCliWord(cliWord);
                dealWord.setCommandStr(commandStr);
                Map<String, String> tempMap = this.dealOneWord(dealWord);
                Map.Entry<String, String> keyStr = tempMap.entrySet().iterator().next();
                this.parseSimpleCommandStr(keyStr.getKey(), tempMap.get(keyStr.getKey()), map);
            }
        }
        return map;
    }

    private Map<String, String> dealOneWord(DealWord dealWord) {
        HashMap<String, String> tmpMap = new HashMap<String, String>();
        String tplWord = dealWord.getTplWord();
        Matcher mCli = dealWord.getmCli();
        String cliStr = dealWord.getCliStr();
        Map<String, String> map = dealWord.getMap();
        String cliWord = dealWord.getCliWord();
        String commandStr = dealWord.getCommandStr();
        int endIndex = 0;
        if (mCli.find()) {
            endIndex = mCli.end();
            if (tplWord.indexOf("$") == -1) {
                cliStr = cliStr.substring(endIndex);
            } else {
                DealWord oneStep = new DealWord();
                oneStep.setTplWord(tplWord);
                oneStep.setmCli(mCli);
                oneStep.setCliStr(cliStr);
                oneStep.setMap(map);
                oneStep.setCliWord(cliWord);
                oneStep.setCommandStr(commandStr);
                oneStep.setEndIndex(endIndex);
                cliStr = this.generateMap(oneStep);
            }
        }
        tmpMap.put(commandStr, cliStr);
        return tmpMap;
    }

    private String generateMap(DealWord dealWord) {
        String tplWord = dealWord.getTplWord();
        Matcher mCli = dealWord.getmCli();
        String cliStr = dealWord.getCliStr();
        Map<String, String> map = dealWord.getMap();
        String cliWord = dealWord.getCliWord();
        String commandStr = dealWord.getCommandStr();
        int endIndex = dealWord.getEndIndex();
        if (tplWord.indexOf("(desc)") != -1) {
            tplWord = tplWord.substring(0, tplWord.length() - 6);
            cliWord = cliStr.trim();
        } else if (tplWord.indexOf("(repeat)") != -1) {
            int tmpIndex = -1;
            List<String> keyWordList = this.findKeyword(commandStr);
            List<String> disappearList = this.findDisappearKeyword(cliStr, keyWordList);
            for (int i = 0; i < keyWordList.size(); ++i) {
                String tmpWord = keyWordList.get(i);
                if (disappearList.contains(tmpWord)) continue;
                tmpIndex = cliStr.indexOf(tmpWord);
                break;
            }
            if (tmpIndex != -1) {
                tplWord = tplWord.substring(0, tplWord.length() - 8);
                cliWord = cliStr.substring(0, tmpIndex).trim();
                endIndex = tmpIndex;
            } else {
                tplWord = tplWord.substring(0, tplWord.length() - 8);
                cliWord = cliStr;
            }
        } else {
            cliWord = mCli.group();
        }
        cliStr = cliStr.substring(endIndex);
        map.put(tplWord.substring(1), cliWord);
        return cliStr;
    }
}

