/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.sdk.common.util;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.zip.CRC32;

public final class CrcUtil {
    private static Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);

    private CrcUtil() {
    }

    public static long getCrcValue(String string) {
        String csn = Charset.defaultCharset().name();
        CRC32 crc32 = new CRC32();
        crc32.reset();
        try {
            crc32.update(string.getBytes(csn));
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)e);
        }
        return crc32.getValue();
    }

    public static long getCrcValue(Object object) {
        Long crc = CrcUtil.getCrcValue(object.toString());
        return crc;
    }

    public static String getChangedName(String name) {
        int index;
        if (name != null && (index = name.indexOf(64)) != -1) {
            return name.substring(0, index);
        }
        return name;
    }
}

