/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.sdk.common.util;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.secservice.sdk.common.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;

public final class Locker {
    public static final int RESOURCE_TYPE_DEVICE = 1;
    public static final int RESOURCE_TYPE_ADMIN = 2;
    private static final Locker LOCKEROCKUTILINSTANCE = new Locker();
    private static ReentrantLock lock = new ReentrantLock();
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private Map<Integer, Set<Long>> resource = new HashMap<Integer, Set<Long>>();
    private Map<Long, List<Pair>> pairsMap;
    private Map<String, Set<Long>> otherResource;
    private List<Long> zoneIdList;
    private List<Long> lockedFilterIdList;
    private boolean importFlag = false;
    private boolean importBlackAndWhiteFlag = false;
    private boolean importDomainWhiteFlag = false;
    private boolean importIpDomainFlag = false;
    private boolean importProxyIpFlag = false;

    private Locker() {
    }

    public static Locker getInstance() {
        return LOCKEROCKUTILINSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean lock(Long resourceID, int resourceType) {
        lock.lock();
        try {
            this.logger.info((Object)"enter lock");
            this.logger.info((Object)("resourceID:" + resourceID + ";resourceType:" + resourceType));
            boolean lockFlag = false;
            Set<Object> res = null;
            if (this.resource.containsKey(resourceType)) {
                res = this.resource.get(resourceType);
                this.logger.info((Object)("current set:" + res));
            } else {
                res = new HashSet();
                this.resource.put(resourceType, res);
                this.logger.info((Object)("current set:" + res));
            }
            if (!res.contains(resourceID)) {
                res.add(resourceID);
                this.logger.info((Object)("do lock,current set:" + res));
                lockFlag = true;
            } else {
                lockFlag = false;
                this.logger.error((Object)("lock failed ,resourceID:" + resourceID + ";resourceType:" + resourceType));
            }
            this.logger.info((Object)"leave lock");
            boolean bl = lockFlag;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean lock(List<Long> resourceIDList, int resourceType, List<Long> lockFail) {
        lock.lock();
        try {
            this.logger.info((Object)"enter lock");
            this.logger.info((Object)("resourceIDList:" + resourceIDList));
            boolean lockFlag = false;
            for (Long res : resourceIDList) {
                if (this.lock(res, resourceType)) continue;
                lockFail.add(res);
            }
            if (lockFail.isEmpty()) {
                lockFlag = true;
            } else {
                this.unlock(lockFail, resourceType);
                lockFlag = false;
            }
            this.logger.info((Object)"enter lock");
            boolean bl = lockFlag;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unlock(Long resourceID, int resourceType) {
        lock.lock();
        try {
            Set<Long> res;
            this.logger.info((Object)"enter unlock");
            boolean unlockflag = true;
            if (this.resource.containsKey(resourceType) && null != (res = this.resource.get(resourceType)) && res.contains(resourceID)) {
                this.logger.info((Object)("before unlock set:" + res));
                unlockflag = res.remove(resourceID);
                this.logger.info((Object)("after unlock set:" + res));
            }
            this.logger.info((Object)"leave unlock");
            boolean bl = unlockflag;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unlock(List<Long> resourceIDList, int resourceType) {
        lock.lock();
        try {
            this.logger.info((Object)"enter unlock");
            boolean unlockflag = true;
            for (Long res : resourceIDList) {
                unlockflag &= this.unlock(res, resourceType);
            }
            this.logger.info((Object)"leave unlock");
            boolean bl = unlockflag;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    public Map<Integer, Set<Long>> getResource() {
        lock.lock();
        try {
            Map<Integer, Set<Long>> map = this.resource;
            return map;
        }
        finally {
            lock.unlock();
        }
    }

    public void setResource(Map<Integer, Set<Long>> resource) {
        lock.lock();
        try {
            this.resource = resource;
        }
        finally {
            lock.unlock();
        }
    }

    public Map<Long, List<Pair>> getPairsMap() {
        lock.lock();
        try {
            Map<Long, List<Pair>> map = this.pairsMap;
            return map;
        }
        finally {
            lock.unlock();
        }
    }

    public void setPairsMap(Map<Long, List<Pair>> pairsMap) {
        lock.lock();
        try {
            this.pairsMap = pairsMap;
        }
        finally {
            lock.unlock();
        }
    }

    public List<Long> getZoneIdList() {
        lock.lock();
        try {
            List<Long> list = this.zoneIdList;
            return list;
        }
        finally {
            lock.unlock();
        }
    }

    public void setZoneIdList(List<Long> zoneIdList) {
        lock.lock();
        try {
            this.zoneIdList = zoneIdList;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean lockPairs(Long adminId, List<Pair> pairs) {
        lock.lock();
        try {
            Boolean lockFlag = true;
            if (this.pairsMap == null || this.pairsMap.isEmpty()) {
                lockFlag = true;
                this.pairsMap = new HashMap<Long, List<Pair>>();
                this.pairsMap.put(adminId, pairs);
            } else {
                ArrayList lockedPairs = new ArrayList();
                for (Map.Entry<Long, List<Pair>> singleAdminPairs : this.pairsMap.entrySet()) {
                    lockedPairs.addAll(singleAdminPairs.getValue());
                }
                this.logger.info((Object)("lockedPairs : " + ((Object)lockedPairs).toString()));
                this.logger.info((Object)("passedCurrentPairs : " + pairs.toString()));
                for (Pair pair : pairs) {
                    if (!lockedPairs.contains(pair)) continue;
                    this.logger.info((Object)("pairInContainsPair : " + pair.toString()));
                    lockFlag = false;
                    break;
                }
                if (lockFlag.booleanValue()) {
                    if (this.pairsMap.containsKey(adminId)) {
                        List<Pair> myPairs = this.pairsMap.get(adminId);
                        myPairs.addAll(pairs);
                        this.pairsMap.put(adminId, myPairs);
                    } else {
                        this.pairsMap.put(adminId, pairs);
                    }
                }
                this.logger.info((Object)("lockFlagOfnotFirstAdmin : " + lockFlag));
            }
            Boolean bl = lockFlag;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unLockPairs(Long adminId, List<Pair> pairs) {
        lock.lock();
        try {
            this.logger.info((Object)("unLockPairs in  unLockPairs method: " + pairs.toString()));
            if (this.pairsMap.containsKey(adminId)) {
                List<Pair> thisAdminLockedPairs = this.pairsMap.get(adminId);
                thisAdminLockedPairs.removeAll(pairs);
                if (thisAdminLockedPairs.isEmpty()) {
                    this.pairsMap.remove(adminId);
                } else {
                    this.pairsMap.put(adminId, thisAdminLockedPairs);
                }
                this.logger.info((Object)("unLockPairs after unLockPairs method remain: " + thisAdminLockedPairs.toString()));
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean lockSet(List<Long> zoneIds, String type) {
        lock.lock();
        try {
            Boolean lockFlag = true;
            HashSet<Long> zoneIdSet = new HashSet<Long>();
            if (null != zoneIds && !zoneIds.isEmpty()) {
                for (Long l : zoneIds) {
                    zoneIdSet.add(l);
                }
            }
            if (this.otherResource == null || this.otherResource.isEmpty()) {
                lockFlag = true;
                this.otherResource = new HashMap<String, Set<Long>>();
                this.otherResource.put(type, zoneIdSet);
            } else {
                Set<Long> lockedPairs = this.otherResource.get(type);
                if (null != lockedPairs && !lockedPairs.isEmpty()) {
                    this.logger.info((Object)("lockedPairs : " + lockedPairs.toString()));
                    this.logger.info((Object)("zoneIdSet : " + ((Object)zoneIdSet).toString()));
                    for (Long zoneId : zoneIdSet) {
                        if (!lockedPairs.contains(zoneId)) continue;
                        this.logger.info((Object)("zoneIdInOtherResource : " + zoneId.toString()));
                        lockFlag = false;
                        break;
                    }
                }
                if (lockFlag.booleanValue()) {
                    if (this.otherResource.containsKey(type)) {
                        Set<Long> set = this.otherResource.get(type);
                        set.addAll(zoneIdSet);
                        this.otherResource.put(type, zoneIdSet);
                    } else {
                        this.otherResource.put(type, zoneIdSet);
                    }
                }
                this.logger.info((Object)("lockFlag : " + lockFlag));
            }
            Boolean bl = lockFlag;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unLockSet(String type, List<Long> zoneIds) {
        lock.lock();
        try {
            HashSet<Long> zoneIdSet = new HashSet<Long>();
            if (null != zoneIds && !zoneIds.isEmpty()) {
                for (Long zoneId : zoneIds) {
                    zoneIdSet.add(zoneId);
                }
            }
            this.logger.info((Object)("unLockSet in  unLockSet method: " + ((Object)zoneIdSet).toString()));
            if (this.otherResource.containsKey(type)) {
                Set<Long> thisAdminLockedPairs = this.otherResource.get(type);
                thisAdminLockedPairs.removeAll(zoneIdSet);
                if (thisAdminLockedPairs.isEmpty()) {
                    this.otherResource.remove(type);
                }
                this.logger.info((Object)("unLockSet after unLockSet method remain: " + thisAdminLockedPairs.toString()));
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean lockResources(List<Long> zoneIds) {
        lock.lock();
        try {
            this.logger.info((Object)"enter lockResources ");
            Boolean lockFlag = true;
            if (this.zoneIdList == null || this.zoneIdList.isEmpty()) {
                lockFlag = true;
                this.zoneIdList = new ArrayList<Long>();
                this.zoneIdList.addAll(zoneIds);
            } else {
                List<Long> lockedZones = this.getZoneIdList();
                this.logger.info((Object)("lockedZones : " + lockedZones.toString()));
                this.logger.info((Object)("passedCurrentZones : " + zoneIds.toString()));
                for (Long zoneId : zoneIds) {
                    if (!lockedZones.contains(zoneId)) continue;
                    this.logger.info((Object)("zoneInContainZones : " + zoneId));
                    lockFlag = false;
                    break;
                }
                if (lockFlag.booleanValue()) {
                    this.zoneIdList.addAll(zoneIds);
                }
            }
            this.logger.info((Object)"leave lockResources ");
            Boolean bl = lockFlag;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean lockFilters(List<Long> preLockFilterIds) {
        lock.lock();
        try {
            Boolean lockFlag = true;
            if (this.lockedFilterIdList == null || this.lockedFilterIdList.isEmpty()) {
                lockFlag = true;
                this.lockedFilterIdList = new ArrayList<Long>();
                this.lockedFilterIdList.addAll(preLockFilterIds);
            } else {
                for (Long filterId : preLockFilterIds) {
                    if (!this.lockedFilterIdList.contains(filterId)) continue;
                    lockFlag = false;
                    break;
                }
                if (lockFlag.booleanValue()) {
                    this.lockedFilterIdList.addAll(preLockFilterIds);
                }
            }
            Boolean bl = lockFlag;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    public void unlockFilters(List<Long> preUnLockFilterIds) {
        lock.lock();
        try {
            this.lockedFilterIdList.removeAll(preUnLockFilterIds);
        }
        finally {
            lock.unlock();
        }
    }

    public void unLockResources(List<Long> zoneIDList) {
        lock.lock();
        try {
            this.logger.info((Object)("enter in  unLockResources method: " + zoneIDList.toString()));
            this.getZoneIdList().removeAll(zoneIDList);
            this.logger.info((Object)"leave in unLockResources");
        }
        finally {
            lock.unlock();
        }
    }

    public boolean isImportFlag() {
        lock.lock();
        try {
            boolean bl = this.importFlag;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    public void setImportFlag(boolean importFlag) {
        lock.lock();
        try {
            this.importFlag = importFlag;
        }
        finally {
            lock.unlock();
        }
    }

    public boolean isImportBlackAndWhiteFlag() {
        lock.lock();
        try {
            boolean bl = this.importBlackAndWhiteFlag;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    public void setImportBlackAndWhiteFlag(boolean importBlackAndWhiteFlag) {
        lock.lock();
        try {
            this.importBlackAndWhiteFlag = importBlackAndWhiteFlag;
        }
        finally {
            lock.unlock();
        }
    }

    public boolean isImportDomainWhiteFlag() {
        lock.lock();
        try {
            boolean bl = this.importDomainWhiteFlag;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    public void setImportDomainWhiteFlag(boolean importDomainWhiteFlag) {
        lock.lock();
        try {
            this.importDomainWhiteFlag = importDomainWhiteFlag;
        }
        finally {
            lock.unlock();
        }
    }

    public boolean isImportIpDomainFlag() {
        lock.lock();
        try {
            boolean bl = this.importIpDomainFlag;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    public void setImportIpDomainFlag(boolean importIpDomainFlag) {
        lock.lock();
        try {
            this.importIpDomainFlag = importIpDomainFlag;
        }
        finally {
            lock.unlock();
        }
    }

    public boolean isImportProxyIpFlag() {
        lock.lock();
        try {
            boolean bl = this.importProxyIpFlag;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    public void setImportProxyIpFlag(boolean importProxyIpFlag) {
        lock.lock();
        try {
            this.importProxyIpFlag = importProxyIpFlag;
        }
        finally {
            lock.unlock();
        }
    }
}

