/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.sdk.common.util;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;

public class ProgressBar
implements Serializable {
    private static final long serialVersionUID = -5655303448426454812L;
    private static ReentrantLock lock = new ReentrantLock();
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private boolean cancleTask = false;
    private long progressBarID;
    private int totalStep;
    private int currentStep = 0;
    private String currentTask;
    private List<String> historyRecord;
    private List<String> cacheRecord;

    public ProgressBar() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProgressBar(int totalStep, long progressBarID) {
        lock.lock();
        try {
            this.logger.info((Object)"enter ProgressBar()");
            this.totalStep = totalStep;
            this.progressBarID = progressBarID;
            this.currentStep = 0;
            this.logger.info((Object)"leave ProgressBar()");
        }
        finally {
            lock.unlock();
        }
    }

    public void next() {
        lock.lock();
        try {
            ++this.currentStep;
            this.logger.info((Object)("progress info:" + this.getcleanedMessage(this.toString())));
            this.logger.info((Object)("currentStep = " + this.currentStep + "current progress = " + this.getProgress() + "%"));
        }
        finally {
            lock.unlock();
        }
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    public void next(int steps) {
        lock.lock();
        try {
            this.currentStep += steps;
            this.logger.info((Object)("progress info:" + this.getcleanedMessage(this.toString())));
            this.logger.info((Object)("currentStep = " + this.currentStep + "current progress = " + this.getProgress() + "%"));
        }
        finally {
            lock.unlock();
        }
    }

    public int getProgress() {
        lock.lock();
        try {
            int progress = this.currentStep * 100 / this.totalStep;
            this.logger.info((Object)("progress info:" + this.getcleanedMessage(this.toString())));
            this.logger.info((Object)("currentStep = " + this.currentStep + "current progress = " + progress + "%"));
            int n = progress;
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    public String getDepAllZoneProgress() {
        lock.lock();
        try {
            String progress;
            String string = progress = this.currentStep + "/" + this.totalStep;
            return string;
        }
        finally {
            lock.unlock();
        }
    }

    public ProgressBar getProgressBar() {
        return this;
    }

    public int getTotalStep() {
        lock.lock();
        try {
            int n = this.totalStep;
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    public void setTotalStep(int totalStep) {
        lock.lock();
        try {
            this.logger.info((Object)"enter setTotalStep");
            this.totalStep = totalStep;
            this.logger.info((Object)("progress info:" + this.getcleanedMessage(this.toString())));
            this.logger.info((Object)"leave setTotalStep");
        }
        finally {
            lock.unlock();
        }
    }

    public int getCurrentStep() {
        lock.lock();
        try {
            int n = this.currentStep;
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    public String getCurrentTask() {
        return this.currentTask;
    }

    public void setCurrentTask(String currentTask) {
        this.currentTask = currentTask;
    }

    public List<String> getHistoryRecord() {
        return this.historyRecord;
    }

    public void setHistoryRecord(List<String> historyRecord) {
        this.historyRecord = historyRecord;
    }

    public List<String> getCacheRecord() {
        return this.cacheRecord;
    }

    public void setCacheRecord(List<String> cacheRecord) {
        this.cacheRecord = cacheRecord;
    }

    public void addHistoryRecord(String record) {
        lock.lock();
        try {
            this.historyRecord.add(record);
        }
        finally {
            lock.unlock();
        }
    }

    public boolean isCancled() {
        lock.lock();
        try {
            boolean bl = this.cancleTask;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    public void setCancled(boolean isCancled) {
        lock.lock();
        try {
            this.logger.info((Object)("enter ProgressBar setCancled,ProgressBarID:" + this.progressBarID));
            this.cancleTask = isCancled;
            this.logger.info((Object)("after ProgressBar setCancled,ProgressBarID:" + this.progressBarID + "cancleTask:" + this.cancleTask));
            this.logger.info((Object)("leave ProgressBar setCancled,ProgressBarID:" + this.progressBarID));
        }
        finally {
            lock.unlock();
        }
    }

    public long getProgressBarID() {
        lock.lock();
        try {
            long l = this.progressBarID;
            return l;
        }
        finally {
            lock.unlock();
        }
    }

    public void setProgressBarID(long progressBarID) {
        lock.lock();
        try {
            this.progressBarID = progressBarID;
        }
        finally {
            lock.unlock();
        }
    }

    public String toString() {
        return "ProgressBar [cacheRecord=" + this.cacheRecord + ", cancleTask=" + this.cancleTask + ", currentStep=" + this.currentStep + ", currentTask=" + this.currentTask + ", historyRecord=" + this.historyRecord + ", progressBarID=" + this.progressBarID + ", totalStep=" + this.totalStep + "]";
    }
}

