/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.sdk.common.util;

import com.hs.atic.bis.util.ZoneBisUtil;
import com.hs.atic.sdk.system.form.BasicInfoForm;
import com.hs.atic.sdk.util.BasicInfoUtil;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.secservice.sdk.common.util.DeployResultPair;
import com.hs.vsm.secservice.sdk.common.util.Locker;
import com.hs.vsm.secservice.sdk.common.util.Pair;
import com.huawei.atic.util.AticInstallUtil;
import com.huawei.atic.util.CertFileUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.math.BigInteger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.beans.BeanUtils;

public final class VsmUtil {
    private static Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private static final VsmUtil INSTANCE = new VsmUtil();
    private static final int IP_SUB_NODE_LEN = 8;
    private static final int BIN_DIS = 2;
    private static final int DEC_DIS = 10;
    private static final int IP_COUNT = 4;
    private static final int MAXIMUMINVOKECOUNT = ZoneBisUtil.getVtyConfigService().getVtyNum() * 2;
    private static final double DOUBLE_2 = 2.0;
    private static final ConcurrentMap<String, AtomicInteger> API_INVOKECOUNT_MAP = new ConcurrentHashMap<String, AtomicInteger>();

    private VsmUtil() {
    }

    public static VsmUtil getInstance() {
        return INSTANCE;
    }

    public void copyProperties(Object source, Object target) {
        if (null != source && null != target) {
            BeanUtils.copyProperties((Object)source, (Object)target);
        }
    }

    public void copyProperties(Object source, Object target, String[] ignoreProperties) {
        if (null != source && null != target) {
            BeanUtils.copyProperties((Object)source, (Object)target, (String[])ignoreProperties);
        }
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    public Map<String, String> getObjectFieldAndValues(Object object) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (null != object) {
            Field[] fields = object.getClass().getDeclaredFields();
            try {
                for (Field field : fields) {
                    this.setAccessible(field);
                    String fieldName = field.getName();
                    if (field.get(object) == null || "".equals(field.get(object).toString().trim())) continue;
                    String fieldValue = String.valueOf(field.get(object));
                    map.put(fieldName, fieldValue);
                }
            }
            catch (IllegalArgumentException e) {
                logger.error((Object)e);
            }
            catch (IllegalAccessException e) {
                logger.error((Object)e);
            }
        }
        return map;
    }

    private void setAccessible(Field field) {
        field.setAccessible(true);
    }

    public void transactionMap2Object(Object object, Map map) {
        if (null != object) {
            Field[] fields = object.getClass().getDeclaredFields();
            try {
                for (Field field : fields) {
                    try {
                        if (!map.containsKey(field.getName())) continue;
                        this.setAccessible(field);
                        this.setValue(object, field, map.get(field.getName()));
                    }
                    catch (Exception e) {
                        logger.error((Object)e);
                    }
                }
            }
            catch (IllegalArgumentException e) {
                logger.error((Object)e);
            }
        }
    }

    private void setValue(Object obj, Field field, Object value) {
        try {
            if (field.getType().getSimpleName().equalsIgnoreCase("long")) {
                field.set(obj, Long.valueOf(value.toString()));
            } else if (field.getType().getSimpleName().equalsIgnoreCase("boolean")) {
                field.set(obj, Boolean.valueOf(value.toString()));
            } else if (field.getType().getSimpleName().equalsIgnoreCase("integer")) {
                field.set(obj, Integer.valueOf(value.toString()));
            } else if (field.getType().getSimpleName().equalsIgnoreCase("int")) {
                field.set(obj, Integer.valueOf(value.toString()));
            } else if (field.getType().getSimpleName().equalsIgnoreCase("double")) {
                field.set(obj, Double.valueOf(value.toString()));
            } else if (field.getType().getSimpleName().equalsIgnoreCase("float")) {
                field.set(obj, Float.valueOf(value.toString()));
            } else {
                field.set(obj, value);
            }
        }
        catch (IllegalAccessException e) {
            logger.error((Object)e);
        }
    }

    public void checkCmdResult(List<String> list, Map<String, String> errorMap, DeployResultPair deployResult) {
        logger.info(list);
        Boolean flag = true;
        String errorMsgKey = "--";
        Iterator<String> iterator = list.iterator();
        block0: while (iterator.hasNext()) {
            String returnInfoTemp;
            String returnInfo = returnInfoTemp = iterator.next();
            if (!flag.booleanValue()) break;
            for (Map.Entry<String, String> entry : errorMap.entrySet()) {
                String key;
                if (!(returnInfo = returnInfo.toLowerCase(Locale.ENGLISH)).contains(key = entry.getKey().toLowerCase(Locale.ENGLISH))) continue;
                errorMsgKey = entry.getValue();
                flag = false;
                continue block0;
            }
        }
        deployResult.setIsFeatureDeployOk(flag);
        if ("--".equals(deployResult.getErrorMsgKey())) {
            deployResult.setErrorMsgKey(errorMsgKey);
        }
    }

    public Boolean checkCmdResult(List<String> list) {
        logger.info((Object)("cmdResult:" + this.getcleanedMessage(list.toString())));
        Boolean flag = true;
        if (list.toString().toLowerCase(Locale.ENGLISH).contains("error")) {
            flag = false;
        }
        if (AticUtil.judgmentEcho((String)list.toString())) {
            flag = false;
        }
        return flag;
    }

    public boolean lock(Long deviceId) {
        boolean flag = false;
        flag = Locker.getInstance().lock(deviceId, 1);
        return flag;
    }

    public boolean lockUser(Long userId, int errorCode) {
        boolean flag = false;
        flag = Locker.getInstance().lock(userId, 2);
        if (!flag) {
            throw new LegoCheckedException((long)errorCode);
        }
        return flag;
    }

    public void unlockUser(Long userId) {
        Locker.getInstance().unlock(userId, 2);
    }

    public Boolean lockAdminPairs(Long adminId, List<Pair> pairs) {
        Boolean flag = Locker.getInstance().lockPairs(adminId, pairs);
        if (!flag.booleanValue()) {
            throw new LegoCheckedException(630102L);
        }
        return true;
    }

    public Boolean lockZones(List<Long> zoneIds, String type) {
        logger.info((Object)"enter VsmUtil lockZones : ");
        Boolean flag = Locker.getInstance().lockResources(zoneIds);
        if (!flag.booleanValue()) {
            throw new LegoCheckedException(630154L);
        }
        logger.info((Object)"leave VsmUtil lockZones : ");
        return true;
    }

    public Boolean isLockedZones(List<Long> zoneIds) {
        Boolean zoneIsLocked = false;
        logger.info((Object)"enter VsmUtil isLockedZones : ");
        List<Long> existingZoneIds = Locker.getInstance().getZoneIdList();
        for (Long zoneId : zoneIds) {
            if (existingZoneIds == null || !existingZoneIds.contains(zoneId)) continue;
            zoneIsLocked = true;
            break;
        }
        logger.info((Object)"enter VsmUtil isLockedZones : ");
        return zoneIsLocked;
    }

    public void unlockZones(List<Long> zoneIdList) {
        Locker.getInstance().unLockResources(zoneIdList);
    }

    public Boolean lockAdminPairs(Long adminId, List<Pair> pairs, int errorCode) {
        Boolean flag = Locker.getInstance().lockPairs(adminId, pairs);
        if (!flag.booleanValue()) {
            throw new LegoCheckedException((long)errorCode);
        }
        return true;
    }

    public void unLockAdminPairs(Long adminId, List<Pair> pairs) {
        Locker.getInstance().unLockPairs(adminId, pairs);
    }

    public Boolean lockSet(List<Long> zoneIds, String type) {
        logger.info((Object)"enter VsmUtil lockSet : ");
        Boolean flag = Locker.getInstance().lockSet(zoneIds, type);
        if (!flag.booleanValue()) {
            throw new LegoCheckedException(630154L);
        }
        logger.info((Object)"leave VsmUtil lockSet : ");
        return true;
    }

    public void unLockSet(List<Long> zoneIds, String type) {
        logger.info((Object)"enter VsmUtil unLockSet : ");
        Locker.getInstance().unLockSet(type, zoneIds);
        logger.info((Object)"leave VsmUtil unLockSet : ");
    }

    public static String convertMaskInt2Mask(int maskInt) {
        StringBuffer mask = new StringBuffer();
        if (maskInt < 8) {
            return null;
        }
        int a = -1;
        mask.append(((a <<= 32 - maskInt) & 0xFF000000) >>> 24);
        mask.append('.');
        mask.append((a & 0xFF0000) >> 16);
        mask.append('.');
        mask.append((a & 0xFF00) >> 8);
        mask.append('.');
        mask.append(a & 0xFF);
        return mask.toString();
    }

    public static int convertMask2MaskInt(String mask) {
        String[] listIpMask = mask.split("\\.");
        if (listIpMask.length < 4) {
            return -1;
        }
        int ipMask1 = Integer.parseInt(listIpMask[0]);
        int ipMask2 = Integer.parseInt(listIpMask[1]);
        int ipMask3 = Integer.parseInt(listIpMask[2]);
        int ipMask4 = Integer.parseInt(listIpMask[3]);
        int maskInt = 0;
        int ipMask = ipMask1 * 0x1000000 + ipMask2 * 65536 + ipMask3 * 256 + ipMask4;
        for (int i = 0; i < 32 && 0 != (ipMask & (int)Math.pow(2.0, 31 - i)); ++i) {
            ++maskInt;
        }
        return maskInt;
    }

    public static String convertMask2ReverseCode(String srcMask) {
        String mask = null;
        mask = VsmUtil.changeIPAddrFromDec2Bin(srcMask);
        String tmp = mask.replace('0', '#');
        tmp = tmp.replace('1', '0');
        tmp = tmp.replace('#', '1');
        mask = VsmUtil.changeIPAddrFromBin2Dec(tmp, 8);
        return mask;
    }

    public static String changeIPAddrFromDec2Bin(String ipAddr) {
        StringBuffer binIp = new StringBuffer();
        String[] subIpArr = ipAddr.split("\\.");
        String subIpTmp = "";
        for (String subIp : subIpArr) {
            subIpTmp = new BigInteger(subIp).toString(2);
            binIp.append(VsmUtil.prefixZero2IpNode(subIpTmp));
        }
        return binIp.toString();
    }

    public static String changeIPAddrFromBin2Dec(String ipAddrBin, int splitLength) {
        StringBuffer decIp = new StringBuffer();
        boolean addDotTag = false;
        int subNum = ipAddrBin.length() / 8;
        String[] subIpArr = new String[subNum];
        for (int i = 0; i < subNum; ++i) {
            subIpArr[i] = ipAddrBin.substring(i * splitLength, (i + 1) * splitLength);
        }
        String subIpTmp = "";
        for (String subIp : subIpArr) {
            subIpTmp = new BigInteger(subIp, 2).toString(10);
            if (addDotTag) {
                decIp.append('.');
            } else {
                addDotTag = true;
            }
            decIp.append(subIpTmp);
        }
        return decIp.toString();
    }

    public static String prefixZero2IpNode(String binStr) {
        StringBuffer zeroBf = new StringBuffer();
        int preFixNum = 8 - binStr.length();
        for (int i = 0; i < preFixNum; ++i) {
            zeroBf.append('0');
        }
        String ret = zeroBf.toString() + binStr;
        return ret;
    }

    public String getNetAddress(String ipAddress, String mask) {
        String netAddress = null;
        try {
            StringBuffer result = new StringBuffer();
            StringTokenizer ipToken = new StringTokenizer(ipAddress, ".");
            StringTokenizer maskToken = new StringTokenizer(mask, ".");
            if (ipToken.countTokens() == 4 && maskToken.countTokens() == 4) {
                while (ipToken.hasMoreTokens()) {
                    String tempIP = ipToken.nextToken();
                    String tempMask = maskToken.nextToken();
                    int tempNet = Integer.parseInt(tempIP) & Integer.parseInt(tempMask);
                    result.append(tempNet).append('.');
                }
                netAddress = result.substring(0, result.length() - 1);
            }
        }
        catch (RuntimeException e) {
            netAddress = null;
        }
        catch (Exception e) {
            netAddress = null;
        }
        return netAddress;
    }

    public static String splitAndSort(String string, String split) {
        Object[] stringSplit = string.split(split);
        Arrays.sort(stringSplit);
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < stringSplit.length; ++i) {
            result.append(((String)stringSplit[i]).trim());
            if (i >= stringSplit.length - 1) continue;
            result.append(split);
        }
        return result.toString();
    }

    public void checkCmdResult(List<String> cmds, List<String> cmdResult, Map<String, String> errorMapping, DeployResultPair deployResult) {
        String returnInfo;
        int i;
        logger.info(cmdResult);
        Boolean flag = true;
        String errorMsgKey = "--";
        String curCmd = "";
        String errorParam = "";
        for (i = 0; i < cmdResult.size(); ++i) {
            returnInfo = cmdResult.get(i);
            if (!"lego.err.632003".equals(returnInfo.trim())) continue;
            errorMsgKey = returnInfo;
            errorParam = "";
            flag = false;
            break;
        }
        if (flag.booleanValue()) {
            for (i = 0; i < cmdResult.size(); ++i) {
                returnInfo = cmdResult.get(i).toLowerCase(Locale.ENGLISH);
                if (!flag.booleanValue()) break;
                for (Map.Entry<String, String> entry : errorMapping.entrySet()) {
                    String key = entry.getKey().toLowerCase(Locale.ENGLISH);
                    Pattern p = Pattern.compile(key);
                    Matcher matcher = p.matcher(returnInfo);
                    if (!matcher.find()) continue;
                    errorMsgKey = entry.getValue();
                    if (null == cmds || cmds.size() <= i) {
                        flag = false;
                        break;
                    }
                    errorParam = curCmd = cmds.get(i);
                    flag = false;
                    break;
                }
                if (!flag.booleanValue() || !returnInfo.contains("error:")) continue;
                String cmdRest = returnInfo.split("\\r\\n")[1];
                errorMsgKey = cmdRest.substring(cmdRest.indexOf(":") + 1);
                errorParam = cmds.get(i);
                flag = false;
                break;
            }
        }
        deployResult.setIsFeatureDeployOk(flag);
        if ("--".equals(deployResult.getErrorMsgKey())) {
            deployResult.setErrorMsgKey(errorMsgKey);
            deployResult.setErrorParam(errorParam);
        }
    }

    public static long convert2long(String date, String format) {
        if (!"".equals(date)) {
            SimpleDateFormat sf = new SimpleDateFormat(format);
            try {
                return sf.parse(date).getTime();
            }
            catch (ParseException e) {
                logger.error((Object)e.getMessage());
            }
        }
        return 0L;
    }

    public static String convert2String(Long l, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        Date date = new Date(l);
        String sDateTime = sdf.format(date);
        return sDateTime;
    }

    public Boolean lockZones(Set<Long> zoneIdSet) {
        ArrayList<Long> zoneIdList = new ArrayList<Long>(zoneIdSet);
        Boolean flag = Locker.getInstance().lockResources(zoneIdList);
        if (!flag.booleanValue()) {
            throw new LegoCheckedException(630154L);
        }
        return true;
    }

    public void unlockZones(Set<Long> zoneIdSet) {
        ArrayList<Long> zoneIdList = new ArrayList<Long>(zoneIdSet);
        Locker.getInstance().unLockResources(zoneIdList);
    }

    public Boolean lockFilters(Set<Long> filterIdSet) {
        ArrayList<Long> filterIdList = new ArrayList<Long>(filterIdSet);
        Boolean flag = Locker.getInstance().lockFilters(filterIdList);
        if (!flag.booleanValue()) {
            throw new LegoCheckedException(630154L);
        }
        return true;
    }

    public void unlockFilters(Set<Long> filterIdSet) {
        ArrayList<Long> filterIdList = new ArrayList<Long>(filterIdSet);
        Locker.getInstance().unlockFilters(filterIdList);
    }

    public static String getInstallPath() {
        String path = null;
        BasicInfoForm basicInfoForm = BasicInfoUtil.getBasicInfo();
        path = null == basicInfoForm ? "D:/VSM" : basicInfoForm.getInstallPath();
        return path;
    }

    public String getThridCertPwdFromCfg() {
        String certPwd = null;
        Properties properties = CertFileUtil.getInstance().loadLegoCertInfoProperties();
        certPwd = properties.getProperty("truststore.third.password");
        return certPwd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getFileBytes(String fileName) {
        String filePath = AticInstallUtil.getInstance().getAticInstallPath() + File.separator + "LegoRuntime" + File.separator + "cert" + File.separator + fileName;
        File findFile = new File(filePath);
        if (findFile.exists() && !findFile.isDirectory()) {
            byte[] b = new byte[(int)findFile.length()];
            BufferedInputStream is = null;
            try {
                is = new BufferedInputStream(new FileInputStream(findFile));
                if (is.read(b) != (int)findFile.length()) {
                    logger.error((Object)"stream read error");
                }
            }
            catch (FileNotFoundException e) {
                logger.error((Object)"file not foud");
            }
            catch (IOException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            finally {
                try {
                    if (null != is) {
                        is.close();
                    }
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            return b;
        }
        logger.error((Object)"file not exist or is directory");
        return new byte[0];
    }

    public Boolean acquireApiInvoke(String apiName) {
        AtomicInteger newApiInvokeCount;
        AtomicInteger apiInvokeCount = (AtomicInteger)API_INVOKECOUNT_MAP.get(apiName);
        if (apiInvokeCount == null && (apiInvokeCount = API_INVOKECOUNT_MAP.putIfAbsent(apiName, newApiInvokeCount = new AtomicInteger(0))) == null) {
            apiInvokeCount = newApiInvokeCount;
        }
        Boolean isAquirable = false;
        if (apiInvokeCount.incrementAndGet() <= MAXIMUMINVOKECOUNT) {
            isAquirable = true;
        }
        return isAquirable;
    }

    public void releaseApiInvoke(String apiName) {
        int curApiInvokeCount;
        AtomicInteger apiInvokeCount = (AtomicInteger)API_INVOKECOUNT_MAP.get(apiName);
        if (apiInvokeCount != null && (curApiInvokeCount = apiInvokeCount.decrementAndGet()) < 0) {
            apiInvokeCount.incrementAndGet();
        }
    }
}

