/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fds.util;

import com.huawei.fds.util.LineFileWriter;
import com.huawei.fds.util.OsLineFileWriter;
import java.util.concurrent.locks.ReentrantLock;

public final class FileToolsFactory {
    private static FileToolsFactory instance;
    private static ReentrantLock lock;

    private FileToolsFactory() {
    }

    public static FileToolsFactory getInstance() {
        lock.lock();
        try {
            FileToolsFactory fileToolsFactory = instance == null ? (FileToolsFactory)FileToolsFactory.class.newInstance() : instance;
            return fileToolsFactory;
        }
        catch (InstantiationException e) {
            FileToolsFactory fileToolsFactory = null;
            return fileToolsFactory;
        }
        catch (IllegalAccessException e) {
            FileToolsFactory fileToolsFactory = null;
            return fileToolsFactory;
        }
        finally {
            lock.unlock();
        }
    }

    public static LineFileWriter getFileWriter(String filenameWithPath) {
        return new OsLineFileWriter(filenameWithPath);
    }

    static {
        lock = new ReentrantLock();
    }
}

