/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fds.util;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public final class PackUtil {
    private static final int BUFF_SIZE = 0x100000;
    private static Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);

    private PackUtil() {
    }

    private static void closeOutStream(ZipOutputStream outStream) {
        if (null != outStream) {
            try {
                outStream.close();
            }
            catch (Exception e) {
                logger.error((Object)"close outputStream error", (Throwable)e);
            }
            finally {
                outStream = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void zipFiles(Collection<File> resFileList, File zipFile) throws IOException {
        ZipOutputStream zipout = null;
        try {
            zipout = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zipFile), 0x100000));
            for (File resFile : resFileList) {
                PackUtil.zipFile(resFile, zipout, "");
            }
            if (zipout == null) return;
        }
        catch (Throwable throwable) {
            if (zipout == null) throw throwable;
            PackUtil.closeOutStream(zipout);
            throw throwable;
        }
        PackUtil.closeOutStream(zipout);
    }

    private static void closeOutputStream(ZipOutputStream outputStream) {
        if (null != outputStream) {
            try {
                outputStream.closeEntry();
            }
            catch (Exception e) {
                logger.error((Object)"close inputStream error", (Throwable)e);
            }
            finally {
                outputStream = null;
            }
        }
    }

    private static void closeInStream(BufferedInputStream inputStream) {
        if (null != inputStream) {
            try {
                inputStream.close();
            }
            catch (Exception e) {
                logger.error((Object)"close inputStream error", (Throwable)e);
            }
            finally {
                inputStream = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipFile(File resFile, ZipOutputStream zipout, String rootpath) throws IOException {
        block14: {
            block13: {
                rootpath = rootpath + (rootpath.trim().length() == 0 ? "" : File.separator) + resFile.getName();
                if (!resFile.exists()) {
                    throw new FileNotFoundException("resource file is not exist!");
                }
                if (!resFile.isDirectory()) break block13;
                File[] fileList = resFile.listFiles();
                if (fileList == null) break block14;
                for (File file : fileList) {
                    PackUtil.zipFile(file, zipout, rootpath);
                }
                break block14;
            }
            byte[] buffer = new byte[0x100000];
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(resFile), 0x100000);
            try {
                int realLength;
                zipout.putNextEntry(new ZipEntry(rootpath));
                while ((realLength = in.read(buffer)) != -1) {
                    zipout.write(buffer, 0, realLength);
                }
            }
            finally {
                try {
                    PackUtil.closeInStream(in);
                }
                finally {
                    if (null != zipout) {
                        PackUtil.flushZipOutputStream(zipout);
                        PackUtil.closeOutputStream(zipout);
                    }
                }
            }
        }
    }

    private static void flushZipOutputStream(ZipOutputStream zipOutputStream) {
        if (null != zipOutputStream) {
            try {
                zipOutputStream.flush();
            }
            catch (IOException e) {
                logger.error((Object)"flush zipOutputStream error", (Throwable)e);
            }
            finally {
                zipOutputStream = null;
            }
        }
    }
}

