/*
 * Decompiled with CFR 0.152.
 */
package com.restful.service.impl;

import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.vsm.secservice.ddos.policy.ref.ZoneReferUtil;
import com.hs.vsm.secservice.sdk.common.util.VsmUtil;
import com.hs.vsm.secservice.sdk.module.ddos.Constant;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneBlackWhiteForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneDeviceDeployStatusForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneDeviceForm;
import com.hs.vsm.secservice.sdk.module.ddos.service.IBlackWhiteListService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZonePolicyMgrService;
import com.huawei.atic.util.JSONUtil;
import com.restful.model.RestBlackWhiteListInfo;
import com.restful.service.RestBlackAndWhiteService;
import com.restful.util.RestAuthUtil;
import com.restful.util.RestLogInfo;
import com.restful.util.RestUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.struts2.ServletActionContext;

@Path(value="ddos/blackwhite")
public class RestBlackAndWhiteServiceImpl
implements RestBlackAndWhiteService {
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_REST);
    private IBlackWhiteListService blackWhiteListService;
    private Map<String, List<String>> featureMap = new HashMap<String, List<String>>();

    @Override
    @POST
    @Path(value="/add")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response addZoneBlackOrWhiteList(String json) {
        RestLogInfo logInfo = new RestLogInfo();
        HttpServletRequest request = ServletActionContext.getRequest();
        String userName = RestAuthUtil.isLegalToken((HttpServletRequest)request, (String)"ddos/blackwhite/add");
        String requestMsg = "add BlackWhiteList. restful request is null. json :" + json;
        String terminalIp = "127.0.0.1";
        String url = "null";
        if (null != request) {
            url = RestAuthUtil.getRequestURL((HttpServletRequest)request, (String)"ddos/blackwhite/add");
            requestMsg = "add BlackWhiteList. restful request url : " + url + ". json :" + json;
            terminalIp = request.getRemoteAddr();
        }
        String apiName = "addBlackWhiteList";
        logInfo.setApiName(apiName);
        logInfo.setUrl(url);
        logInfo.setJson("addZoneBlackOrWhiteList");
        logInfo.setUserName(userName);
        logInfo.setTerminalIp(terminalIp);
        logInfo.setOperation("atic.restful.blackwhite.add");
        int responseCode = 200;
        String responseMsg = "add blackWhiteList succeed";
        if (AticUtil.isNull((String)userName)) {
            responseMsg = "illegal token.";
            responseCode = 412;
            logInfo.setResponseMsg(responseMsg);
            logInfo.setResponseCode(responseCode);
            logInfo.setResponseDetail(responseCode + "," + responseMsg);
            logInfo.setOperation("atic.restful.blackwhite.add");
            logInfo.setTarget("");
            logInfo.setTargetLocal(false);
            return this.logExit(logInfo);
        }
        LOGGER.info((Object)("addZoneBlackOrWhiteList, userName :" + userName + ". " + requestMsg));
        ArrayList<String> ipAddressList = new ArrayList<String>();
        RestBlackWhiteListInfo listInfo = null;
        try {
            listInfo = (RestBlackWhiteListInfo)JSONUtil.getInstance().fromJSON(json, RestBlackWhiteListInfo.class);
            this.checkJsonParam(listInfo.getBlackWhiteType());
            List<String> ips = listInfo.getIps();
            for (String ip : ips) {
                ipAddressList.add(this.checkIpAndSalt(ip));
            }
        }
        catch (Exception e) {
            responseMsg = "json format error";
            responseCode = 400;
            logInfo.setResponseMsg(responseMsg);
            logInfo.setResponseCode(responseCode);
            logInfo.setResponseDetail(responseCode + "," + responseMsg);
            logInfo.setOperation("atic.restful.blackwhite.add");
            logInfo.setTarget("");
            logInfo.setTargetLocal(true);
            LOGGER.error((Object)"Exception :", (Throwable)e);
            return this.logExit(logInfo);
        }
        if (!VsmUtil.getInstance().acquireApiInvoke(apiName).booleanValue()) {
            Response response = this.handleOverAPInvokeLimit(logInfo);
            return response;
        }
        try {
            List<ZoneDeviceForm> zoneDeviceForms = this.blackWhiteListService.queryZoneDeviceByZoneName(listInfo.getZoneName());
            if (zoneDeviceForms.size() <= 0) {
                responseMsg = listInfo.getZoneName() + " is not exist";
                responseCode = 445;
                logInfo.setResponseMsg(responseMsg);
                logInfo.setResponseCode(responseCode);
                logInfo.setResponseDetail(responseCode + "," + responseMsg);
                logInfo.setOperation("atic.restful.blackwhite.add");
                logInfo.setTarget("");
                logInfo.setTargetLocal(false);
                return this.logExit(logInfo);
            }
            Long zoneId = zoneDeviceForms.get(0).getZoneId();
            int blackWhiteType = listInfo.getBlackWhiteType();
            for (int i = 0; i < ipAddressList.size(); ++i) {
                String[] zoneIpDetails = ((String)ipAddressList.get(i)).split("/");
                String ipAddress = zoneIpDetails[0].trim();
                int mask = Integer.parseInt(zoneIpDetails[1].trim());
                ZoneBlackWhiteForm blackWhiteForm = new ZoneBlackWhiteForm();
                blackWhiteForm.setBlackWhiteType(blackWhiteType);
                blackWhiteForm.setZoneId(zoneId);
                blackWhiteForm.setIpAddress(ipAddress);
                blackWhiteForm.setMask(mask);
                blackWhiteForm.setZoneName(listInfo.getZoneName());
                blackWhiteForm.setDeleteFlag(0);
                int result = this.blackWhiteListService.saveZoneBlackWhiteList(blackWhiteForm);
                if (0 == result) continue;
                this.deployZoneBlackWhite(zoneId, blackWhiteType);
                if (1000 == result) {
                    responseMsg = "The number of black and white lists of protection objects exceeds 1000";
                    responseCode = 449;
                } else {
                    responseMsg = blackWhiteForm.getIpAddressAndMask() + ",already exists and cannot be delivered repeatedly.";
                    responseCode = 448;
                }
                logInfo.setResponseMsg(responseMsg);
                logInfo.setResponseCode(responseCode);
                logInfo.setResponseDetail(responseCode + "," + responseMsg);
                logInfo.setOperation("atic.restful.blackwhite.add");
                logInfo.setTarget("");
                logInfo.setTargetLocal(false);
                return this.logExit(logInfo);
            }
            Map<String, String> errorMsg = this.deployZoneBlackWhite(zoneId, blackWhiteType);
            if (errorMsg.size() > 0) {
                StringBuilder deviceName = new StringBuilder();
                for (Map.Entry<String, String> entry : errorMsg.entrySet()) {
                    deviceName.append(entry.getKey()).append(",");
                }
                responseCode = 447;
                responseMsg = "add blackWhiteList partial failure.failure deviceName is :" + deviceName.substring(0, deviceName.length() - 1);
            }
            logInfo.setResponseMsg(responseMsg);
            logInfo.setResponseCode(responseCode);
            logInfo.setResponseDetail(responseCode + "," + responseMsg);
            logInfo.setOperation("atic.restful.blackwhite.add");
            logInfo.setTarget("");
            logInfo.setTargetLocal(false);
            return this.logExit(logInfo);
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"deploy blackWhiteList failed,", (Throwable)e);
            responseCode = 500;
            responseMsg = "add blackWhiteList filed";
            logInfo.setResponseMsg(responseMsg);
            logInfo.setResponseCode(responseCode);
            logInfo.setResponseDetail(responseCode + "," + responseMsg);
            logInfo.setOperation("atic.restful.blackwhite.add");
            logInfo.setTarget("");
            logInfo.setTargetLocal(false);
            return this.logExit(logInfo);
        }
    }

    @Override
    @DELETE
    @Path(value="/delete")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response deleteZoneBlackOrWhiteList(String json) {
        RestLogInfo logInfo = new RestLogInfo();
        HttpServletRequest request = ServletActionContext.getRequest();
        String userName = RestAuthUtil.isLegalToken((HttpServletRequest)request, (String)"ddos/blackwhite/delete");
        String requestMsg = "delete blackWhiteList. restful request is null. json :" + json;
        String terminalIp = "127.0.0.1";
        String url = "null";
        if (null != request) {
            url = RestAuthUtil.getRequestURL((HttpServletRequest)request, (String)"ddos/blackwhite/delete");
            requestMsg = "delete blackWhiteList. restful request url : " + url + ". json :" + json;
            terminalIp = request.getRemoteAddr();
        }
        String apiName = "deleteBlackWhiteList";
        logInfo.setApiName(apiName);
        logInfo.setUrl(url);
        logInfo.setJson("deleteZoneBlackOrWhiteList");
        logInfo.setUserName(userName);
        logInfo.setTerminalIp(terminalIp);
        logInfo.setOperation("atic.restful.blackwhite.delete");
        int responseCode = 200;
        String responseMsg = "delete blackWhiteList succeed";
        if (AticUtil.isNull((String)userName)) {
            responseMsg = "illegal token.";
            responseCode = 412;
            logInfo.setResponseMsg(responseMsg);
            logInfo.setResponseCode(responseCode);
            logInfo.setResponseDetail(responseCode + "," + responseMsg);
            logInfo.setOperation("atic.restful.blackwhite.delete");
            logInfo.setTarget("");
            logInfo.setTargetLocal(false);
            return this.logExit(logInfo);
        }
        LOGGER.info((Object)("deleteZoneBlackOrWhiteList, userName :" + userName + ". " + requestMsg));
        ArrayList<String> ipAddressList = new ArrayList<String>();
        RestBlackWhiteListInfo listInfo = null;
        try {
            listInfo = (RestBlackWhiteListInfo)JSONUtil.getInstance().fromJSON(json, RestBlackWhiteListInfo.class);
            this.checkJsonParam(listInfo.getBlackWhiteType());
            this.checkJsonParam(listInfo.getDeleteAll());
            if (listInfo.getDeleteAll() != 1) {
                List<String> ips = listInfo.getIps();
                for (String ip : ips) {
                    ipAddressList.add(this.checkIpAndSalt(ip));
                }
            }
        }
        catch (Exception e) {
            responseMsg = "json format error";
            responseCode = 400;
            logInfo.setResponseMsg(responseMsg);
            logInfo.setResponseCode(responseCode);
            logInfo.setResponseDetail(responseCode + "," + responseMsg);
            logInfo.setOperation("atic.restful.blackwhite.delete");
            logInfo.setTarget("");
            logInfo.setTargetLocal(true);
            LOGGER.error((Object)"Exception :", (Throwable)e);
            return this.logExit(logInfo);
        }
        if (!VsmUtil.getInstance().acquireApiInvoke(apiName).booleanValue()) {
            Response response = this.handleOverAPInvokeLimit(logInfo);
            return response;
        }
        try {
            ZoneBlackWhiteForm blackWhiteForm;
            List<ZoneDeviceForm> zoneDeviceForms = this.blackWhiteListService.queryZoneDeviceByZoneName(listInfo.getZoneName());
            if (zoneDeviceForms.size() == 0) {
                responseMsg = listInfo.getZoneName() + " is not exist";
                responseCode = 445;
                logInfo.setResponseMsg(responseMsg);
                logInfo.setResponseCode(responseCode);
                logInfo.setResponseDetail(responseCode + "," + responseMsg);
                logInfo.setOperation("atic.restful.blackwhite.delete");
                logInfo.setTarget("");
                logInfo.setTargetLocal(false);
                return this.logExit(logInfo);
            }
            ArrayList<ZoneBlackWhiteForm> needDeleteblackWhiteForms = new ArrayList<ZoneBlackWhiteForm>();
            Long zoneId = zoneDeviceForms.get(0).getZoneId();
            int blackWhiteType = listInfo.getBlackWhiteType();
            if (listInfo.getDeleteAll() == 1) {
                blackWhiteForm = new ZoneBlackWhiteForm();
                blackWhiteForm.setZoneId(zoneId);
                blackWhiteForm.setBlackWhiteType(blackWhiteType);
                this.blackWhiteListService.batchDelAllZoneBlackWhiteList(blackWhiteForm);
            } else {
                List<ZoneBlackWhiteForm> zoneBlackWhiteForms = this.blackWhiteListService.queryConfigBlackWhiteListByZoneIdAndType(zoneId, blackWhiteType);
                for (int i = 0; i < ipAddressList.size(); ++i) {
                    boolean isExist = false;
                    for (ZoneBlackWhiteForm form : zoneBlackWhiteForms) {
                        if (!form.getIpAddressAndMask().contains((CharSequence)ipAddressList.get(i))) continue;
                        isExist = true;
                        break;
                    }
                    if (!isExist) continue;
                    String[] zoneIpDetails = ((String)ipAddressList.get(i)).split("/");
                    String ipAddress = zoneIpDetails[0].trim();
                    int mask = Integer.parseInt(zoneIpDetails[1].trim());
                    blackWhiteForm = new ZoneBlackWhiteForm();
                    blackWhiteForm.setBlackWhiteType(blackWhiteType);
                    blackWhiteForm.setZoneId(zoneId);
                    blackWhiteForm.setIpAddress(ipAddress);
                    blackWhiteForm.setMask(mask);
                    needDeleteblackWhiteForms.add(blackWhiteForm);
                }
            }
            this.blackWhiteListService.deleteBlackWhiteByForm(needDeleteblackWhiteForms);
            Map<String, String> errorMsg = this.deployZoneBlackWhite(zoneId, blackWhiteType);
            if (errorMsg.size() > 0) {
                StringBuilder deviceName = new StringBuilder();
                for (Map.Entry<String, String> entry : errorMsg.entrySet()) {
                    deviceName.append(entry.getKey()).append(",");
                }
                responseCode = 447;
                responseMsg = "delete blackWhiteList partial failure.failure deviceName is :" + deviceName.substring(0, deviceName.length() - 1);
            }
            logInfo.setResponseMsg(responseMsg);
            logInfo.setResponseCode(responseCode);
            logInfo.setResponseDetail(responseCode + "," + responseMsg);
            logInfo.setOperation("atic.restful.blackwhite.delete");
            logInfo.setTarget("");
            logInfo.setTargetLocal(false);
            return this.logExit(logInfo);
        }
        catch (LegoCheckedException e) {
            responseCode = 500;
            responseMsg = "delete blackWhiteList filed";
            logInfo.setResponseMsg(responseMsg);
            logInfo.setResponseCode(responseCode);
            logInfo.setResponseDetail(responseCode + "," + responseMsg);
            logInfo.setOperation("atic.restful.blackwhite.delete");
            logInfo.setTarget("");
            logInfo.setTargetLocal(false);
            return this.logExit(logInfo);
        }
    }

    private Map<String, String> deployZoneBlackWhite(Long zoneId, int blackWhiteType) {
        HashMap<String, String> errorMsg = new HashMap<String, String>();
        ArrayList<Long> zoneIdList = new ArrayList<Long>();
        zoneIdList.add(zoneId);
        String methodName = "blackListData";
        if (2 == blackWhiteType) {
            methodName = "whiteListData";
        }
        IZonePolicyMgrService zonePolicyMgrService = ZoneReferUtil.getZonePolicyMgrService();
        zonePolicyMgrService.deployInRest(zoneIdList, this.initFeatures(methodName), null);
        List<ZoneDeviceDeployStatusForm> zDeployStatusForms = zonePolicyMgrService.queryAllDeployResultByZoneId(zoneId);
        for (ZoneDeviceDeployStatusForm zDeployStatusForm : zDeployStatusForms) {
            String errorKey = zDeployStatusForm.getErrorMsgKey();
            if (zDeployStatusForm.getDeployState().booleanValue()) continue;
            errorMsg.put(zDeployStatusForm.getDeviceName(), errorKey);
        }
        return errorMsg;
    }

    private List<String> initFeatures(String methodName) {
        if (!this.featureMap.containsKey(methodName)) {
            ArrayList<String> features = new ArrayList<String>();
            switch (methodName) {
                case "blackListData": {
                    features.add(Constant.Feature.ZoneBasicPolicyInfo.toString());
                    features.add(Constant.Feature.ZoneBlackListData.toString());
                    break;
                }
                case "whiteListData": {
                    features.add(Constant.Feature.ZoneBasicPolicyInfo.toString());
                    features.add(Constant.Feature.ZoneWhiteListData.toString());
                    break;
                }
            }
            if (!features.isEmpty()) {
                this.featureMap.put(methodName, features);
            }
        }
        return this.featureMap.get(methodName);
    }

    @Override
    @POST
    @Path(value="/query")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response queryZoneBlackOrWhiteList(String json) {
        RestLogInfo logInfo = new RestLogInfo();
        HttpServletRequest request = ServletActionContext.getRequest();
        String userName = RestAuthUtil.isLegalToken((HttpServletRequest)request, (String)"ddos/blackwhite/query");
        String requestMsg = "query BlackWhiteList. restful request is null. json :" + json;
        String terminalIp = "127.0.0.1";
        String url = "null";
        if (null != request) {
            url = RestAuthUtil.getRequestURL((HttpServletRequest)request, (String)"ddos/blackwhite/query");
            requestMsg = "query BlackWhiteList. restful request url : " + url + ". json :" + json;
            terminalIp = request.getRemoteAddr();
        }
        String apiName = "queryBlackWhiteList";
        logInfo.setApiName(apiName);
        logInfo.setUrl(url);
        logInfo.setJson("queryZoneBlackOrWhiteList");
        logInfo.setUserName(userName);
        logInfo.setTerminalIp(terminalIp);
        logInfo.setOperation("atic.restful.blackwhite.query");
        int responseCode = 200;
        String responseMsg = "query blackWhiteList succeed";
        if (AticUtil.isNull((String)userName)) {
            responseMsg = "illegal token.";
            responseCode = 412;
            logInfo.setResponseMsg(responseMsg);
            logInfo.setResponseCode(responseCode);
            logInfo.setResponseDetail(responseCode + "," + responseMsg);
            logInfo.setOperation("atic.restful.blackwhite.query");
            logInfo.setTarget("");
            logInfo.setTargetLocal(false);
            return this.logExit(logInfo);
        }
        LOGGER.info((Object)("queryZoneBlackOrWhiteList, userName :" + userName + ". " + requestMsg));
        RestBlackWhiteListInfo listInfo = null;
        try {
            listInfo = (RestBlackWhiteListInfo)JSONUtil.getInstance().fromJSON(json, RestBlackWhiteListInfo.class);
            this.checkJsonParam(listInfo.getQueryAll());
            this.checkJsonParam(listInfo.getBlackWhiteType());
        }
        catch (Exception e) {
            responseMsg = "json format error";
            responseCode = 400;
            logInfo.setResponseMsg(responseMsg);
            logInfo.setResponseCode(responseCode);
            logInfo.setResponseDetail(responseCode + "," + responseMsg);
            logInfo.setOperation("atic.restful.blackwhite.query");
            logInfo.setTarget("");
            logInfo.setTargetLocal(true);
            LOGGER.error((Object)"Exception :", (Throwable)e);
            return this.logExit(logInfo);
        }
        if (!VsmUtil.getInstance().acquireApiInvoke(apiName).booleanValue()) {
            Response response = this.handleOverAPInvokeLimit(logInfo);
            return response;
        }
        List<Object> blackWhiteForms = new ArrayList();
        try {
            if (listInfo.getQueryAll() == 1) {
                blackWhiteForms = this.blackWhiteListService.queryAllByType(listInfo.getBlackWhiteType());
            } else {
                for (String zoneName : listInfo.getZoneNames()) {
                    List<ZoneDeviceForm> zoneDeviceForms = this.blackWhiteListService.queryZoneDeviceByZoneName(zoneName);
                    if (zoneDeviceForms.size() == 0) {
                        responseMsg = zoneName + " is not exist";
                        responseCode = 445;
                        logInfo.setResponseMsg(responseMsg);
                        logInfo.setResponseCode(responseCode);
                        logInfo.setResponseDetail(responseCode + "," + responseMsg);
                        logInfo.setOperation("atic.restful.blackwhite.query");
                        logInfo.setTarget("");
                        logInfo.setTargetLocal(false);
                        return this.logExit(logInfo);
                    }
                    Long zoneId = zoneDeviceForms.get(0).getZoneId();
                    blackWhiteForms.addAll(this.blackWhiteListService.queryBlackWhiteListByZoneIdAndType(zoneId, listInfo.getBlackWhiteType()));
                }
            }
        }
        catch (LegoCheckedException e) {
            responseCode = 500;
            responseMsg = "query blackWhiteList filed";
            logInfo.setResponseMsg(responseMsg);
            logInfo.setResponseCode(responseCode);
            logInfo.setResponseDetail(responseCode + "," + responseMsg);
            logInfo.setOperation("atic.restful.blackwhite.query");
            logInfo.setTarget("");
            logInfo.setTargetLocal(false);
            return this.logExit(logInfo);
        }
        LOGGER.info((Object)("query blackWhiteList size = " + blackWhiteForms.size()));
        Map<String, List<String>> tempMap = this.queryAssembleBlackWhite(blackWhiteForms);
        StringBuilder resultStr = new StringBuilder();
        resultStr.append("{\"type\":").append(listInfo.getBlackWhiteType()).append(",\"zoneNames\":[");
        for (Map.Entry<String, List<String>> map : tempMap.entrySet()) {
            resultStr.append("{\"zoneName\": \"").append(map.getKey()).append("\" ,\"ips\":");
            StringBuilder ipStr = new StringBuilder("[");
            List<String> ipAndMasks = map.getValue();
            for (int i = 0; i < ipAndMasks.size(); ++i) {
                ipStr.append("\"").append(ipAndMasks.get(i)).append("\"");
                if (i == ipAndMasks.size() - 1) continue;
                ipStr.append(',');
            }
            ipStr.append("]");
            resultStr.append((CharSequence)ipStr).append("},");
        }
        if (tempMap.size() > 0) {
            responseMsg = resultStr.substring(0, resultStr.length() - 1) + "]}";
        } else {
            resultStr.append("]}");
            responseMsg = resultStr.toString();
        }
        logInfo.setResponseMsg(responseMsg);
        logInfo.setResponseCode(responseCode);
        logInfo.setResponseDetail(responseCode + "," + responseMsg);
        logInfo.setOperation("atic.restful.blackwhite.query");
        logInfo.setTarget("");
        logInfo.setTargetLocal(false);
        return this.logExit(logInfo);
    }

    private Response handleOverAPInvokeLimit(RestLogInfo logInfo) {
        int responseCode = 423;
        String responseMsg = "exceed concurrent api call limit.";
        logInfo.setResponseCode(responseCode);
        logInfo.setResponseMsg(responseMsg);
        logInfo.setResponseDetail(responseCode + "," + responseMsg);
        return this.logExit(logInfo);
    }

    private Map<String, List<String>> queryAssembleBlackWhite(List<ZoneBlackWhiteForm> blackWhiteForms) {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (ZoneBlackWhiteForm form : blackWhiteForms) {
            if (null != map.get(form.getZoneName()) && ((List)map.get(form.getZoneName())).contains(form.getIpAddressAndMask())) continue;
            if (map.containsKey(form.getZoneName())) {
                ((List)map.get(form.getZoneName())).add(form.getIpAddressAndMask());
                continue;
            }
            ArrayList<String> list = new ArrayList<String>();
            list.add(form.getIpAddressAndMask());
            map.put(form.getZoneName(), list);
        }
        return map;
    }

    private String checkIpAndSalt(String ip) {
        if (ip.isEmpty()) {
            throw new IllegalArgumentException("illegal parameter.");
        }
        int mask = 0;
        if (ip.contains("/")) {
            String[] zoneIpDetails = ip.split("/");
            ip = zoneIpDetails[0].trim();
            mask = Integer.parseInt(zoneIpDetails[1].trim());
        } else {
            ip = ip.trim();
        }
        if (IPUtil.isIpv4((String)ip) && (mask == 0 || mask >= 8 && mask <= 32)) {
            if (mask == 0) {
                mask = 32;
            }
            ip = ip + "/" + mask;
        } else if (IPUtil.isIpv6((String)ip) && (mask == 0 || mask >= 8 && mask <= 128)) {
            if (mask == 0) {
                mask = 128;
            }
            ip = ip + "/" + mask;
        } else {
            throw new IllegalArgumentException("illegal parameter.");
        }
        return ip;
    }

    private void checkJsonParam(int number) {
        if (number != 1 && number != 2) {
            throw new IllegalArgumentException("illegal parameter.");
        }
    }

    private Response logExit(RestLogInfo logInfo) {
        VsmUtil.getInstance().releaseApiInvoke(logInfo.getApiName());
        RestUtil.processSysLog((String)logInfo.getRequestMsg(), (int)logInfo.getResponseCode(), (String)logInfo.getResponseMsg());
        String[] params = new String[]{logInfo.getTerminalIp(), logInfo.getUserName(), logInfo.getOperation(), logInfo.getTarget()};
        String[] detailPara = new String[]{logInfo.getUrl(), logInfo.getJson(), logInfo.getResponseDetail()};
        RestUtil.processOpeLogByTarget((String[])detailPara, (int)logInfo.getResponseCode(), (String[])params, (boolean)logInfo.isTargetLocal());
        Response.ResponseBuilder responseBuilder = Response.ok();
        responseBuilder = responseBuilder.status(logInfo.getResponseCode());
        responseBuilder.entity((Object)logInfo.getResponseMsg());
        return responseBuilder.build();
    }

    public IBlackWhiteListService getBlackWhiteListService() {
        return this.blackWhiteListService;
    }

    public void setBlackWhiteListService(IBlackWhiteListService blackWhiteListService) {
        this.blackWhiteListService = blackWhiteListService;
    }

    public Map<String, List<String>> getFeatureMap() {
        return this.featureMap;
    }

    public void setFeatureMap(Map<String, List<String>> featureMap) {
        this.featureMap = featureMap;
    }
}

