/*
 * Decompiled with CFR 0.152.
 */
package com.restful.service.impl;

import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.vsm.secservice.ddos.policy.ref.ZoneReferUtil;
import com.hs.vsm.secservice.sdk.module.ddos.form.FilterForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.HttpFilterForm;
import com.hs.vsm.secservice.sdk.module.ddos.service.IFilterService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IHttpFilterService;
import com.restful.model.RestFilterDstIpInfo;
import com.restful.service.RestFilterService;
import com.restful.util.JSONUtil;
import com.restful.util.RestAuthUtil;
import com.restful.util.RestUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.struts2.ServletActionContext;

@Path(value="ddos/filter")
public class RestFilterServiceImpl
implements RestFilterService {
    private static final int PARAMETER_ERROR = 418;
    private static final String FILTER_DST_IP = "destination-ip";
    private static final int FILTER_DST_IP_MAX_SIZE = 100;
    private static final int TOO_MUCH_DST_IP = 419;
    private static final int DEPLOY_ERROR = 509;
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_REST);

    @Override
    @GET
    @Path(value="/{filter_id}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response queryFilterName(@PathParam(value="filter_id") String filterId) {
        Response.ResponseBuilder responseBuilder = Response.ok();
        int responseCode = 500;
        String reg = "^\\+?[1-9]\\d*$";
        HttpServletRequest request = ServletActionContext.getRequest();
        String userName = RestAuthUtil.isLegalToken((HttpServletRequest)request, (String)"ddos/filter/{filter_id}");
        String requestMsg = "queryFilter by filterid. restful request is null.";
        String terminalIp = "127.0.0.1";
        String url = "null";
        if (null != request) {
            url = RestAuthUtil.getRequestURL((HttpServletRequest)request, (String)"ddos/filter/{filter_id}");
            requestMsg = "restful request url : " + url + ".";
            terminalIp = request.getRemoteAddr();
        }
        String responseMsg = "";
        String[] detailPara = new String[3];
        detailPara[0] = url;
        detailPara[1] = "null";
        if (!this.checkLong(filterId)) {
            responseCode = 400;
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"illegal parameter.");
            detailPara[2] = responseCode + "";
            RestUtil.processOpeLog((String[])detailPara, (int)responseCode, (String)terminalIp, (String)"restful", (String)"atic.restful.query.filtername");
            responseBuilder = responseBuilder.status(responseCode);
            return responseBuilder.build();
        }
        if (AticUtil.isNull((String)userName)) {
            responseCode = 412;
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"illegal token.");
            detailPara[2] = responseCode + "";
            RestUtil.processOpeLog((String[])detailPara, (int)responseCode, (String)terminalIp, (String)"restful", (String)"atic.restful.query.filtername");
            responseBuilder = responseBuilder.status(responseCode);
            return responseBuilder.build();
        }
        this.logger.info((Object)("is Legal Token, userName :" + userName + ". " + requestMsg));
        if (!filterId.matches(reg)) {
            responseCode = 400;
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"filterForm is not exist.");
            detailPara[2] = responseCode + "";
            RestUtil.processOpeLog((String[])detailPara, (int)responseCode, (String)terminalIp, (String)userName, (String)"atic.restful.query.filtername");
            responseBuilder = responseBuilder.status(responseCode);
            return responseBuilder.build();
        }
        IFilterService filterService = ZoneReferUtil.getFilterService();
        FilterForm filterForm = null;
        if (null != filterService) {
            filterForm = filterService.queryFilterName(Long.valueOf(filterId));
            if (null == filterForm) {
                responseCode = 404;
                RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"filterForm is not exist.");
                detailPara[2] = responseCode + "";
                RestUtil.processOpeLog((String[])detailPara, (int)responseCode, (String)terminalIp, (String)userName, (String)"atic.restful.query.filtername");
                responseBuilder = responseBuilder.status(responseCode);
                return responseBuilder.build();
            }
            StringBuffer json = new StringBuffer("{\"filter_id\": \"");
            json.append(filterForm.getFilterId() + "\" ,\"filter_name\": \"" + filterForm.getFilterName() + "\"}");
            responseMsg = json.toString();
            responseCode = 200;
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
            detailPara[2] = responseCode + "," + responseMsg;
            RestUtil.processOpeLog((String[])detailPara, (int)responseCode, (String)terminalIp, (String)userName, (String)"atic.restful.query.filtername");
            return Response.ok((Object)responseMsg).build();
        }
        responseCode = 500;
        RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"filterService is null.");
        detailPara[2] = responseCode + "";
        RestUtil.processOpeLog((String[])detailPara, (int)responseCode, (String)terminalIp, (String)userName, (String)"atic.restful.query.filtername");
        responseBuilder = responseBuilder.status(responseCode);
        return responseBuilder.build();
    }

    public boolean checkLong(String str) {
        try {
            if (Long.parseLong(str) < 0L) {
                return false;
            }
        }
        catch (NumberFormatException e) {
            return false;
        }
        catch (RuntimeException e) {
            return false;
        }
        return true;
    }

    private void checkJson(String json) {
        if (null != json && json.trim().length() > 5000) {
            throw new IllegalArgumentException("the parameters of json is more than 5000.");
        }
    }

    @Override
    @POST
    @Path(value="/add_filter_dst_ip")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response addFilterDstIp(String json) {
        Response.ResponseBuilder responseBuilder = Response.ok();
        String requestMsg = "addFilterDstIp. restful request is null.";
        String terminalIp = "127.0.0.1";
        String url = "null";
        HttpServletRequest request = ServletActionContext.getRequest();
        String userName = RestAuthUtil.isLegalToken((HttpServletRequest)request, (String)"ddos/filter/add_filter_dst_ip");
        if (null != request) {
            url = RestAuthUtil.getRequestURL((HttpServletRequest)request, (String)"ddos/filter/add_filter_dst_ip");
            terminalIp = request.getRemoteAddr();
            requestMsg = "addFilterDstIp. restful request url : " + url + ". json : " + json;
        }
        String responseMsg = "";
        int responseCode = 200;
        String[] detailPara = new String[3];
        detailPara[0] = url;
        detailPara[1] = json;
        if (AticUtil.isNull((String)userName)) {
            responseCode = 412;
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"illegal token.");
            detailPara[2] = responseCode + "";
            RestUtil.processOpeLog((String[])detailPara, (int)responseCode, (String)terminalIp, (String)"restful", (String)"atic.restful.filter.addFilterDstIp");
            responseBuilder.status(responseCode);
            return responseBuilder.build();
        }
        this.logger.info((Object)("is Legal Token, userName : " + userName + ". " + responseMsg));
        RestFilterDstIpInfo restFilterDstIpInfo = null;
        try {
            this.checkJson(json);
            restFilterDstIpInfo = (RestFilterDstIpInfo)JSONUtil.getInstance().fromJSON(json, RestFilterDstIpInfo.class);
        }
        catch (Exception e) {
            responseMsg = "json format error";
            responseCode = 418;
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
            detailPara[2] = responseCode + "," + responseMsg;
            String[] params = new String[]{terminalIp, userName, "atic.restful.filter.addFilterDstIp", ""};
            RestUtil.processOpeLogByTarget((String[])detailPara, (int)responseCode, (String[])params, (boolean)true);
            responseBuilder.status(responseCode);
            responseBuilder.entity((Object)responseMsg);
            return responseBuilder.build();
        }
        for (String dstIp : restFilterDstIpInfo.getFilterDstIp()) {
            if (IPUtil.isIpv4((String)dstIp.split("/")[0])) continue;
            responseCode = 418;
            responseMsg = "only ipv4 is supported";
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
            detailPara[2] = responseCode + "," + responseMsg;
            String[] params = new String[]{terminalIp, userName, "atic.restful.filter.addFilterDstIp", ""};
            RestUtil.processOpeLogByTarget((String[])detailPara, (int)responseCode, (String[])params, (boolean)true);
            responseBuilder.status(responseCode);
            return responseBuilder.build();
        }
        IFilterService filterService = ZoneReferUtil.getFilterService();
        IHttpFilterService httpFilterService = ZoneReferUtil.getHttpFilterService();
        if (null == filterService || null == httpFilterService) {
            responseCode = 500;
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"filterService or httpFilterService is null.");
            detailPara[2] = responseCode + "";
            RestUtil.processOpeLog((String[])detailPara, (int)responseCode, (String)terminalIp, (String)userName, (String)"atic.restful.filter.addFilterDstIp");
            responseBuilder = responseBuilder.status(responseCode);
            return responseBuilder.build();
        }
        FilterForm filter = filterService.queryByName(restFilterDstIpInfo.getFilterName());
        if (null == filter) {
            responseCode = 404;
            responseMsg = "filter is not exist.";
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
            detailPara[2] = responseCode + "";
            RestUtil.processOpeLog((String[])detailPara, (int)responseCode, (String)terminalIp, (String)userName, (String)"atic.restful.filter.addFilterDstIp");
            responseBuilder.status(responseCode);
            responseBuilder.entity((Object)responseMsg);
            return responseBuilder.build();
        }
        List<String> list = httpFilterService.queryByFilterIdAndFilterKey(filter.getPkid(), FILTER_DST_IP);
        if (null != list && list.size() + restFilterDstIpInfo.getFilterDstIp().size() > 100) {
            requestMsg = "Too much destination-ip";
            responseCode = 419;
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
            detailPara[2] = responseCode + "";
            RestUtil.processOpeLog((String[])detailPara, (int)responseCode, (String)terminalIp, (String)userName, (String)"atic.restful.filter.addFilterDstIp");
            responseBuilder.status(responseCode);
            return responseBuilder.build();
        }
        ArrayList<HttpFilterForm> newHttpFilterFormList = new ArrayList<HttpFilterForm>();
        Long pkid = filter.getPkid();
        for (String dstIp : restFilterDstIpInfo.getFilterDstIp()) {
            HttpFilterForm form = new HttpFilterForm();
            form.setFilterKey(FILTER_DST_IP);
            form.setFilterContent(dstIp);
            form.setFilterId(pkid);
            newHttpFilterFormList.add(form);
        }
        filter.setHttpFilterFormList(newHttpFilterFormList);
        try {
            filterService.doDeployFilterDstIp(filter);
        }
        catch (Exception e) {
            LegoCheckedException ex;
            responseCode = 509;
            if (e instanceof LegoCheckedException && 571507L == (ex = (LegoCheckedException)((Object)e)).getErrorCode()) {
                responseMsg = "filter not deploy into device";
            }
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)e.getMessage());
            detailPara[2] = responseCode + "";
            RestUtil.processOpeLog((String[])detailPara, (int)responseCode, (String)terminalIp, (String)userName, (String)"atic.restful.filter.addFilterDstIp");
            responseBuilder.status(responseCode);
            responseBuilder.entity((Object)responseMsg);
            return responseBuilder.build();
        }
        RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
        detailPara[2] = responseCode + "";
        RestUtil.processOpeLog((String[])detailPara, (int)responseCode, (String)terminalIp, (String)userName, (String)"atic.restful.filter.addFilterDstIp");
        responseCode = 200;
        responseBuilder.status(responseCode);
        return responseBuilder.build();
    }

    @Override
    @DELETE
    @Path(value="/delete_filter_dst_ip")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response deleteFilterDstIp(String json) {
        Response.ResponseBuilder responseBuilder = Response.ok();
        String requestMsg = "addFilterDstIp. restful request is null.";
        String terminalIp = "127.0.0.1";
        String url = "null";
        HttpServletRequest request = ServletActionContext.getRequest();
        String userName = RestAuthUtil.isLegalToken((HttpServletRequest)request, (String)"ddos/filter/delete_filter_dst_ip");
        if (null != request) {
            url = RestAuthUtil.getRequestURL((HttpServletRequest)request, (String)"ddos/filter/delete_filter_dst_ip");
            terminalIp = request.getRemoteAddr();
            requestMsg = "addFilterDstIp. restful request url : " + url + ". json : " + json;
        }
        String responseMsg = "";
        int responseCode = 200;
        String[] detailPara = new String[3];
        detailPara[0] = url;
        detailPara[1] = json;
        if (AticUtil.isNull((String)userName)) {
            responseCode = 412;
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"illegal token.");
            detailPara[2] = responseCode + "";
            RestUtil.processOpeLog((String[])detailPara, (int)responseCode, (String)terminalIp, (String)"restful", (String)"atic.restful.filter.deleteFilterDstIp");
            responseBuilder.status(responseCode);
            return responseBuilder.build();
        }
        this.logger.info((Object)("is Legal Token, userName : " + userName + ". " + responseMsg));
        RestFilterDstIpInfo restFilterDstIpInfo = null;
        try {
            this.checkJson(json);
            restFilterDstIpInfo = (RestFilterDstIpInfo)JSONUtil.getInstance().fromJSON(json, RestFilterDstIpInfo.class);
        }
        catch (Exception e) {
            responseMsg = "json format error";
            responseCode = 418;
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
            detailPara[2] = responseCode + "," + responseMsg;
            String[] params = new String[]{terminalIp, userName, "atic.restful.filter.deleteFilterDstIp", ""};
            RestUtil.processOpeLogByTarget((String[])detailPara, (int)responseCode, (String[])params, (boolean)true);
            responseBuilder.status(responseCode);
            responseBuilder.entity((Object)responseMsg);
            return responseBuilder.build();
        }
        for (String dstIp : restFilterDstIpInfo.getFilterDstIp()) {
            if (IPUtil.isIpv4((String)dstIp.split("/")[0])) continue;
            responseCode = 418;
            responseMsg = "only ipv4 is supported";
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
            detailPara[2] = responseCode + "," + responseMsg;
            String[] params = new String[]{terminalIp, userName, "atic.restful.filter.deleteFilterDstIp", ""};
            RestUtil.processOpeLogByTarget((String[])detailPara, (int)responseCode, (String[])params, (boolean)true);
            responseBuilder.status(responseCode);
            return responseBuilder.build();
        }
        IFilterService filterService = ZoneReferUtil.getFilterService();
        if (null == filterService) {
            responseCode = 500;
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"filterService is null.");
            detailPara[2] = responseCode + "";
            RestUtil.processOpeLog((String[])detailPara, (int)responseCode, (String)terminalIp, (String)userName, (String)"atic.restful.filter.deleteFilterDstIp");
            responseBuilder = responseBuilder.status(responseCode);
            return responseBuilder.build();
        }
        FilterForm filter = filterService.queryByName(restFilterDstIpInfo.getFilterName());
        if (null == filter) {
            responseCode = 404;
            responseMsg = "filter is not exist.";
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
            detailPara[2] = responseCode + "";
            RestUtil.processOpeLog((String[])detailPara, (int)responseCode, (String)terminalIp, (String)userName, (String)"atic.restful.filter.deleteFilterDstIp");
            responseBuilder.status(responseCode);
            responseBuilder.entity((Object)responseMsg);
            return responseBuilder.build();
        }
        ArrayList<HttpFilterForm> newHttpFilterFormList = new ArrayList<HttpFilterForm>();
        Long pkid = filter.getPkid();
        for (String dstIp : restFilterDstIpInfo.getFilterDstIp()) {
            HttpFilterForm form = new HttpFilterForm();
            form.setFilterKey(FILTER_DST_IP);
            form.setFilterContent(dstIp);
            form.setFilterId(pkid);
            newHttpFilterFormList.add(form);
        }
        filter.setHttpFilterFormList(newHttpFilterFormList);
        try {
            filterService.doUndeployFilterDstIp(filter);
        }
        catch (Exception e) {
            responseCode = 500;
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)e.getMessage());
            detailPara[2] = responseCode + "";
            RestUtil.processOpeLog((String[])detailPara, (int)responseCode, (String)terminalIp, (String)userName, (String)"atic.restful.filter.deleteFilterDstIp");
            responseBuilder.status(responseCode);
            responseBuilder.entity((Object)responseMsg);
            return responseBuilder.build();
        }
        RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
        detailPara[2] = responseCode + "," + responseMsg;
        RestUtil.processOpeLog((String[])detailPara, (int)responseCode, (String)terminalIp, (String)userName, (String)"atic.restful.filter.deleteFilterDstIp");
        responseBuilder = responseBuilder.status(200);
        return responseBuilder.build();
    }

    @Override
    @GET
    @Path(value="/filter_dst_ip/{filter_name}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response queryFilterDstIp(@PathParam(value="filter_name") String filterName) {
        Response.ResponseBuilder responseBuilder = Response.ok();
        String requestMsg = "queryFilterDstIp. restful request is null.";
        String terminalIp = "127.0.0.1";
        String url = "null";
        String responseMsg = "";
        HttpServletRequest request = ServletActionContext.getRequest();
        String userName = RestAuthUtil.isLegalToken((HttpServletRequest)request, (String)"ddos/filter/filter_dst_ip/{filter_name}");
        if (null != request) {
            url = RestAuthUtil.getRequestURL((HttpServletRequest)request, (String)"ddos/filter/filter_dst_ip/{filter_name}");
            terminalIp = request.getRemoteAddr();
            requestMsg = "queryFilterDstIp. restful request url : " + url + ". filterName : " + filterName;
        }
        int responseCode = 200;
        String[] detailPara = new String[3];
        detailPara[0] = url;
        detailPara[1] = filterName;
        if (AticUtil.isNull((String)userName)) {
            responseCode = 412;
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"illegal token.");
            detailPara[2] = responseCode + "";
            RestUtil.processOpeLog((String[])detailPara, (int)responseCode, (String)terminalIp, (String)"restful", (String)"atic.restful.filter.queryFilterDstIp");
            responseBuilder.status(responseCode);
            return responseBuilder.build();
        }
        boolean validateFilterName = this.validateFilterName(filterName);
        if (!validateFilterName) {
            responseCode = 418;
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"illegal parameter.");
            detailPara[2] = responseCode + "";
            RestUtil.processOpeLog((String[])detailPara, (int)responseCode, (String)terminalIp, (String)"restful", (String)"atic.restful.filter.queryFilterDstIp");
            responseBuilder.status(responseCode);
            responseBuilder.build();
        }
        HashMap map = new HashMap();
        IFilterService filterService = ZoneReferUtil.getFilterService();
        IHttpFilterService httpFilterService = ZoneReferUtil.getHttpFilterService();
        if (null == filterService || null == httpFilterService) {
            responseBuilder.status(500);
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"filterService is null.");
            detailPara[2] = responseCode + "";
            RestUtil.processOpeLog((String[])detailPara, (int)responseCode, (String)terminalIp, (String)userName, (String)"atic.restful.filter.queryFilterDstIp");
            return responseBuilder.build();
        }
        String jsonString = "";
        try {
            FilterForm filter = filterService.queryByName(filterName);
            List<Object> list = new ArrayList();
            if (null != filter) {
                list = httpFilterService.queryByFilterIdAndFilterKey(filter.getPkid(), FILTER_DST_IP);
            }
            map.put("filter_ip", list);
            jsonString = JSONUtil.getInstance().toJSONString(map);
        }
        catch (Exception e) {
            this.logger.error((Object)"woo...", (Throwable)e);
        }
        RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
        detailPara[2] = responseCode + "," + responseMsg;
        RestUtil.processOpeLog((String[])detailPara, (int)responseCode, (String)terminalIp, (String)userName, (String)"atic.restful.filter.queryFilterDstIp");
        responseBuilder = responseBuilder.status(200);
        responseBuilder.entity((Object)jsonString);
        return responseBuilder.build();
    }

    private boolean validateFilterName(String filterName) {
        if (AticUtil.isNull((String)filterName)) {
            return false;
        }
        if (filterName.trim().equalsIgnoreCase("null")) {
            return false;
        }
        String nameRegex = "^(?!\\s*null$)[\\w*]{1,63}$";
        return filterName.matches(nameRegex);
    }
}

